// mojo/public/mojom/base/binder.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  GenericPendingReceiverSpec as mojoBase_mojom_GenericPendingReceiverSpec,
  GenericPendingReceiver as mojoBase_mojom_GenericPendingReceiver
} from './generic_pending_receiver.mojom-webui.js';







export type BinderPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<BinderPendingReceiver>;

export class BinderPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Binder> {

  handle: mojo.internal.interfaceSupport.Endpoint<BinderPendingReceiver>;
  constructor(handle: MojoHandle|BinderPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'mojo_base.mojom.Binder',
        scope);
  }
}

export interface BinderInterface {
  bind(receiver: mojoBase_mojom_GenericPendingReceiver): void;
}

export class BinderRemote implements BinderInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<BinderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<BinderPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|BinderPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BinderPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  bind(
      receiver: mojoBase_mojom_GenericPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        Binder_Bind_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Binder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BinderReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BinderRemote, BinderPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BinderRemote, BinderPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: BinderInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BinderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Binder_Bind_ParamsSpec.$,
        null,
        impl.bind.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Binder {
  static get $interfaceName(): string {
    return "mojo_base.mojom.Binder";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): BinderRemote {
    let remote = new BinderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Binder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BinderCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    BinderRemote, BinderPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    BinderRemote, BinderPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  bind: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BinderRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.bind =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Binder_Bind_ParamsSpec.$,
        null,
        this.bind.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const Binder_Bind_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface Binder_Bind_ParamsMojoType {
  receiver: mojoBase_mojom_GenericPendingReceiver;
}


export type Binder_Bind_Params = Binder_Bind_ParamsMojoType;
mojo.internal.Struct<Binder_Bind_ParamsMojoType>(
    Binder_Bind_ParamsSpec.$,
    'Binder_Bind_Params',
    [
      mojo.internal.StructField<Binder_Bind_ParamsMojoType, mojoBase_mojom_GenericPendingReceiver>(
        'receiver', 0,
        0,
        mojoBase_mojom_GenericPendingReceiverSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



