// media/mojo/mojom/video_encoder_metrics_provider.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/video_encoder_metrics_provider.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }


  var VideoEncoderUseCase = {};
  VideoEncoderUseCase.kCastMirroring = 0;
  VideoEncoderUseCase.kMediaRecorder = 1;
  VideoEncoderUseCase.kWebCodecs = 2;
  VideoEncoderUseCase.kWebRTC = 3;
  VideoEncoderUseCase.MIN_VALUE = 0;
  VideoEncoderUseCase.MAX_VALUE = 3;

  VideoEncoderUseCase.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  VideoEncoderUseCase.toKnownEnumValue = function(value) {
    return value;
  };

  VideoEncoderUseCase.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function VideoEncoderMetricsProvider_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncoderMetricsProvider_Initialize_Params.prototype.initDefaults_ = function() {
    this.encoderId = 0;
    this.encoderUseCase = 0;
    this.profile = 0;
    this.encodeSize = null;
    this.isHardwareEncoder = false;
    this.svcMode = 0;
  };
  VideoEncoderMetricsProvider_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncoderMetricsProvider_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncoderMetricsProvider_Initialize_Params.encoderUseCase
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, VideoEncoderUseCase);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncoderMetricsProvider_Initialize_Params.profile
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, media_types$.VideoCodecProfile);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoEncoderMetricsProvider_Initialize_Params.encodeSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncoderMetricsProvider_Initialize_Params.svcMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, media_types$.SVCScalabilityMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncoderMetricsProvider_Initialize_Params.encodedSize = codec.kStructHeaderSize + 32;

  VideoEncoderMetricsProvider_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncoderMetricsProvider_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encoderId =
        decoder.decodeStruct(codec.Uint64);
    val.encoderUseCase =
        decoder.decodeStruct(new codec.Enum(VideoEncoderUseCase));
    val.profile =
        decoder.decodeStruct(new codec.Enum(media_types$.VideoCodecProfile));
    val.encodeSize =
        decoder.decodeStructPointer(geometry$.Size);
    packed = decoder.readUint8();
    val.isHardwareEncoder = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.svcMode =
        decoder.decodeStruct(new codec.Enum(media_types$.SVCScalabilityMode));
    return val;
  };

  VideoEncoderMetricsProvider_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncoderMetricsProvider_Initialize_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.encoderId);
    encoder.encodeStruct(codec.Int32, val.encoderUseCase);
    encoder.encodeStruct(codec.Int32, val.profile);
    encoder.encodeStructPointer(geometry$.Size, val.encodeSize);
    packed = 0;
    packed |= (val.isHardwareEncoder & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.svcMode);
  };
  function VideoEncoderMetricsProvider_SetEncodedFrameCount_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.prototype.initDefaults_ = function() {
    this.encoderId = 0;
    this.numEncodedFrames = 0;
  };
  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncoderMetricsProvider_SetEncodedFrameCount_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encoderId =
        decoder.decodeStruct(codec.Uint64);
    val.numEncodedFrames =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.encoderId);
    encoder.encodeStruct(codec.Uint64, val.numEncodedFrames);
  };
  function VideoEncoderMetricsProvider_SetError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncoderMetricsProvider_SetError_Params.prototype.initDefaults_ = function() {
    this.encoderId = 0;
    this.status = null;
  };
  VideoEncoderMetricsProvider_SetError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncoderMetricsProvider_SetError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate VideoEncoderMetricsProvider_SetError_Params.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, media_types$.EncoderStatus, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoEncoderMetricsProvider_SetError_Params.encodedSize = codec.kStructHeaderSize + 16;

  VideoEncoderMetricsProvider_SetError_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncoderMetricsProvider_SetError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encoderId =
        decoder.decodeStruct(codec.Uint64);
    val.status =
        decoder.decodeStructPointer(media_types$.EncoderStatus);
    return val;
  };

  VideoEncoderMetricsProvider_SetError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncoderMetricsProvider_SetError_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.encoderId);
    encoder.encodeStructPointer(media_types$.EncoderStatus, val.status);
  };
  function VideoEncoderMetricsProvider_Complete_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoEncoderMetricsProvider_Complete_Params.prototype.initDefaults_ = function() {
    this.encoderId = 0;
  };
  VideoEncoderMetricsProvider_Complete_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoEncoderMetricsProvider_Complete_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VideoEncoderMetricsProvider_Complete_Params.encodedSize = codec.kStructHeaderSize + 8;

  VideoEncoderMetricsProvider_Complete_Params.decode = function(decoder) {
    var packed;
    var val = new VideoEncoderMetricsProvider_Complete_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encoderId =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  VideoEncoderMetricsProvider_Complete_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoEncoderMetricsProvider_Complete_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.encoderId);
  };
  var kVideoEncoderMetricsProvider_Initialize_Name = 0;
  var kVideoEncoderMetricsProvider_SetEncodedFrameCount_Name = 1;
  var kVideoEncoderMetricsProvider_SetError_Name = 2;
  var kVideoEncoderMetricsProvider_Complete_Name = 3;

  function VideoEncoderMetricsProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(VideoEncoderMetricsProvider,
                                                   handleOrPtrInfo);
  }

  function VideoEncoderMetricsProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        VideoEncoderMetricsProvider, associatedInterfacePtrInfo);
  }

  VideoEncoderMetricsProviderAssociatedPtr.prototype =
      Object.create(VideoEncoderMetricsProviderPtr.prototype);
  VideoEncoderMetricsProviderAssociatedPtr.prototype.constructor =
      VideoEncoderMetricsProviderAssociatedPtr;

  function VideoEncoderMetricsProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  VideoEncoderMetricsProviderPtr.prototype.initialize = function() {
    return VideoEncoderMetricsProviderProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncoderMetricsProviderProxy.prototype.initialize = function(encoderId, encoderUseCase, profile, encodeSize, isHardwareEncoder, svcMode) {
    var params_ = new VideoEncoderMetricsProvider_Initialize_Params();
    params_.encoderId = encoderId;
    params_.encoderUseCase = encoderUseCase;
    params_.profile = profile;
    params_.encodeSize = encodeSize;
    params_.isHardwareEncoder = isHardwareEncoder;
    params_.svcMode = svcMode;
    var builder = new codec.MessageV0Builder(
        kVideoEncoderMetricsProvider_Initialize_Name,
        codec.align(VideoEncoderMetricsProvider_Initialize_Params.encodedSize));
    builder.encodeStruct(VideoEncoderMetricsProvider_Initialize_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncoderMetricsProviderPtr.prototype.setEncodedFrameCount = function() {
    return VideoEncoderMetricsProviderProxy.prototype.setEncodedFrameCount
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncoderMetricsProviderProxy.prototype.setEncodedFrameCount = function(encoderId, numEncodedFrames) {
    var params_ = new VideoEncoderMetricsProvider_SetEncodedFrameCount_Params();
    params_.encoderId = encoderId;
    params_.numEncodedFrames = numEncodedFrames;
    var builder = new codec.MessageV0Builder(
        kVideoEncoderMetricsProvider_SetEncodedFrameCount_Name,
        codec.align(VideoEncoderMetricsProvider_SetEncodedFrameCount_Params.encodedSize));
    builder.encodeStruct(VideoEncoderMetricsProvider_SetEncodedFrameCount_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncoderMetricsProviderPtr.prototype.setError = function() {
    return VideoEncoderMetricsProviderProxy.prototype.setError
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncoderMetricsProviderProxy.prototype.setError = function(encoderId, status) {
    var params_ = new VideoEncoderMetricsProvider_SetError_Params();
    params_.encoderId = encoderId;
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kVideoEncoderMetricsProvider_SetError_Name,
        codec.align(VideoEncoderMetricsProvider_SetError_Params.encodedSize));
    builder.encodeStruct(VideoEncoderMetricsProvider_SetError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  VideoEncoderMetricsProviderPtr.prototype.complete = function() {
    return VideoEncoderMetricsProviderProxy.prototype.complete
        .apply(this.ptr.getProxy(), arguments);
  };

  VideoEncoderMetricsProviderProxy.prototype.complete = function(encoderId) {
    var params_ = new VideoEncoderMetricsProvider_Complete_Params();
    params_.encoderId = encoderId;
    var builder = new codec.MessageV0Builder(
        kVideoEncoderMetricsProvider_Complete_Name,
        codec.align(VideoEncoderMetricsProvider_Complete_Params.encodedSize));
    builder.encodeStruct(VideoEncoderMetricsProvider_Complete_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function VideoEncoderMetricsProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  VideoEncoderMetricsProviderStub.prototype.initialize = function(encoderId, encoderUseCase, profile, encodeSize, isHardwareEncoder, svcMode) {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize(encoderId, encoderUseCase, profile, encodeSize, isHardwareEncoder, svcMode);
  }
  VideoEncoderMetricsProviderStub.prototype.setEncodedFrameCount = function(encoderId, numEncodedFrames) {
    return this.delegate_ && this.delegate_.setEncodedFrameCount && this.delegate_.setEncodedFrameCount(encoderId, numEncodedFrames);
  }
  VideoEncoderMetricsProviderStub.prototype.setError = function(encoderId, status) {
    return this.delegate_ && this.delegate_.setError && this.delegate_.setError(encoderId, status);
  }
  VideoEncoderMetricsProviderStub.prototype.complete = function(encoderId) {
    return this.delegate_ && this.delegate_.complete && this.delegate_.complete(encoderId);
  }

  VideoEncoderMetricsProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kVideoEncoderMetricsProvider_Initialize_Name:
      var params = reader.decodeStruct(VideoEncoderMetricsProvider_Initialize_Params);
      this.initialize(params.encoderId, params.encoderUseCase, params.profile, params.encodeSize, params.isHardwareEncoder, params.svcMode);
      return true;
    case kVideoEncoderMetricsProvider_SetEncodedFrameCount_Name:
      var params = reader.decodeStruct(VideoEncoderMetricsProvider_SetEncodedFrameCount_Params);
      this.setEncodedFrameCount(params.encoderId, params.numEncodedFrames);
      return true;
    case kVideoEncoderMetricsProvider_SetError_Name:
      var params = reader.decodeStruct(VideoEncoderMetricsProvider_SetError_Params);
      this.setError(params.encoderId, params.status);
      return true;
    case kVideoEncoderMetricsProvider_Complete_Name:
      var params = reader.decodeStruct(VideoEncoderMetricsProvider_Complete_Params);
      this.complete(params.encoderId);
      return true;
    default:
      return false;
    }
  };

  VideoEncoderMetricsProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateVideoEncoderMetricsProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kVideoEncoderMetricsProvider_Initialize_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncoderMetricsProvider_Initialize_Params;
      break;
      case kVideoEncoderMetricsProvider_SetEncodedFrameCount_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncoderMetricsProvider_SetEncodedFrameCount_Params;
      break;
      case kVideoEncoderMetricsProvider_SetError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncoderMetricsProvider_SetError_Params;
      break;
      case kVideoEncoderMetricsProvider_Complete_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = VideoEncoderMetricsProvider_Complete_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateVideoEncoderMetricsProviderResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var VideoEncoderMetricsProvider = {
    name: 'media.mojom.VideoEncoderMetricsProvider',
    kVersion: 0,
    ptrClass: VideoEncoderMetricsProviderPtr,
    proxyClass: VideoEncoderMetricsProviderProxy,
    stubClass: VideoEncoderMetricsProviderStub,
    validateRequest: validateVideoEncoderMetricsProviderRequest,
    validateResponse: null,
  };
  VideoEncoderMetricsProviderStub.prototype.validator = validateVideoEncoderMetricsProviderRequest;
  VideoEncoderMetricsProviderProxy.prototype.validator = null;
  exports.VideoEncoderUseCase = VideoEncoderUseCase;
  exports.VideoEncoderMetricsProvider = VideoEncoderMetricsProvider;
  exports.VideoEncoderMetricsProviderPtr = VideoEncoderMetricsProviderPtr;
  exports.VideoEncoderMetricsProviderAssociatedPtr = VideoEncoderMetricsProviderAssociatedPtr;
})();