// media/mojo/mojom/video_encoder_metrics_provider.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.SVCScalabilityMode');
goog.require('media.mojom.VideoCodecProfile');
goog.require('media.mojom.EncoderStatus');
goog.require('gfx.mojom.Size');




goog.provide('media.mojom.VideoEncoderUseCase');
goog.provide('media.mojom.VideoEncoderUseCaseSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.VideoEncoderUseCaseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.VideoEncoderUseCase = {
  
  kCastMirroring: 0,
  kMediaRecorder: 1,
  kWebCodecs: 2,
  kWebRTC: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('media.mojom.VideoEncoderMetricsProvider');
goog.provide('media.mojom.VideoEncoderMetricsProviderReceiver');
goog.provide('media.mojom.VideoEncoderMetricsProviderCallbackRouter');
goog.provide('media.mojom.VideoEncoderMetricsProviderInterface');
goog.provide('media.mojom.VideoEncoderMetricsProviderRemote');
goog.provide('media.mojom.VideoEncoderMetricsProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.VideoEncoderMetricsProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.VideoEncoderMetricsProvider.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.VideoEncoderMetricsProviderInterface = class {
  
  /**
   * @param { !bigint } encoderId
   * @param { !media.mojom.VideoEncoderUseCase } encoderUseCase
   * @param { !media.mojom.VideoCodecProfile } profile
   * @param { !gfx.mojom.Size } encodeSize
   * @param { !boolean } isHardwareEncoder
   * @param { !media.mojom.SVCScalabilityMode } svcMode
   */

  initialize(encoderId, encoderUseCase, profile, encodeSize, isHardwareEncoder, svcMode) {}
  
  /**
   * @param { !bigint } encoderId
   * @param { !bigint } numEncodedFrames
   */

  setEncodedFrameCount(encoderId, numEncodedFrames) {}
  
  /**
   * @param { !bigint } encoderId
   * @param { !media.mojom.EncoderStatus } status
   */

  setError(encoderId, status) {}
  
  /**
   * @param { !bigint } encoderId
   */

  complete(encoderId) {}
};

/**
 * @export
 * @implements { media.mojom.VideoEncoderMetricsProviderInterface }
 */
media.mojom.VideoEncoderMetricsProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.VideoEncoderMetricsProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.VideoEncoderMetricsProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.VideoEncoderMetricsProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } encoderId
   * @param { !media.mojom.VideoEncoderUseCase } encoderUseCase
   * @param { !media.mojom.VideoCodecProfile } profile
   * @param { !gfx.mojom.Size } encodeSize
   * @param { !boolean } isHardwareEncoder
   * @param { !media.mojom.SVCScalabilityMode } svcMode
   */

  initialize(
      encoderId,
      encoderUseCase,
      profile,
      encodeSize,
      isHardwareEncoder,
      svcMode) {
    this.proxy.sendMessage(
        0,
        media.mojom.VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
        null,
        [
          encoderId,
          encoderUseCase,
          profile,
          encodeSize,
          isHardwareEncoder,
          svcMode
        ],
        false);
  }

  
  /**
   * @param { !bigint } encoderId
   * @param { !bigint } numEncodedFrames
   */

  setEncodedFrameCount(
      encoderId,
      numEncodedFrames) {
    this.proxy.sendMessage(
        1,
        media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
        null,
        [
          encoderId,
          numEncodedFrames
        ],
        false);
  }

  
  /**
   * @param { !bigint } encoderId
   * @param { !media.mojom.EncoderStatus } status
   */

  setError(
      encoderId,
      status) {
    this.proxy.sendMessage(
        2,
        media.mojom.VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
        null,
        [
          encoderId,
          status
        ],
        false);
  }

  
  /**
   * @param { !bigint } encoderId
   */

  complete(
      encoderId) {
    this.proxy.sendMessage(
        3,
        media.mojom.VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
        null,
        [
          encoderId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VideoEncoderMetricsProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.VideoEncoderMetricsProviderReceiver = class {
  /**
   * @param {!media.mojom.VideoEncoderMetricsProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.VideoEncoderMetricsProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.VideoEncoderMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncoderMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
        null,
        impl.setEncodedFrameCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
        null,
        impl.setError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.VideoEncoderMetricsProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoEncoderMetricsProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.VideoEncoderMetricsProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.VideoEncoderMetricsProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VideoEncoderMetricsProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.VideoEncoderMetricsProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.VideoEncoderMetricsProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.VideoEncoderMetricsProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEncodedFrameCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
        null,
        this.setEncodedFrameCount.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
        null,
        this.setError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.VideoEncoderMetricsProvider_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncoderMetricsProvider_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncoderMetricsProvider_SetError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncoderMetricsProvider_SetError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.VideoEncoderMetricsProvider_Complete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.VideoEncoderMetricsProvider_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.VideoEncoderMetricsProvider_Initialize_ParamsSpec.$,
    'VideoEncoderMetricsProvider_Initialize_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encoderUseCase', 8,
        0,
        media.mojom.VideoEncoderUseCaseSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'profile', 12,
        0,
        media.mojom.VideoCodecProfileSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encodeSize', 16,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isHardwareEncoder', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'svcMode', 28,
        0,
        media.mojom.SVCScalabilityModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('media.mojom.VideoEncoderMetricsProvider_Initialize_Params');

/** @record */
media.mojom.VideoEncoderMetricsProvider_Initialize_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.encoderId;
    /** @export { !media.mojom.VideoEncoderUseCase } */
    this.encoderUseCase;
    /** @export { !media.mojom.VideoCodecProfile } */
    this.profile;
    /** @export { !gfx.mojom.Size } */
    this.encodeSize;
    /** @export { !boolean } */
    this.isHardwareEncoder;
    /** @export { !media.mojom.SVCScalabilityMode } */
    this.svcMode;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_ParamsSpec.$,
    'VideoEncoderMetricsProvider_SetEncodedFrameCount_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numEncodedFrames', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_Params');

/** @record */
media.mojom.VideoEncoderMetricsProvider_SetEncodedFrameCount_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.encoderId;
    /** @export { !bigint } */
    this.numEncodedFrames;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncoderMetricsProvider_SetError_ParamsSpec.$,
    'VideoEncoderMetricsProvider_SetError_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        media.mojom.EncoderStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.VideoEncoderMetricsProvider_SetError_Params');

/** @record */
media.mojom.VideoEncoderMetricsProvider_SetError_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.encoderId;
    /** @export { !media.mojom.EncoderStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.VideoEncoderMetricsProvider_Complete_ParamsSpec.$,
    'VideoEncoderMetricsProvider_Complete_Params',
    [
      mojo.internal.StructField(
        'encoderId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.VideoEncoderMetricsProvider_Complete_Params');

/** @record */
media.mojom.VideoEncoderMetricsProvider_Complete_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.encoderId;
  }
};

