// media/mojo/mojom/video_encoder_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encoder_info.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool ResolutionRateLimit_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ResolutionRateLimit_Data* object =
      static_cast<const ResolutionRateLimit_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_size, validation_context))
    return false;

  return true;
}

ResolutionRateLimit_Data::ResolutionRateLimit_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncoderInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncoderInfo_Data* object =
      static_cast<const VideoEncoderInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->implementation_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& implementation_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->implementation_name, validation_context,
                                         &implementation_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fps_allocation, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fps_allocation_validate_params =
      mojo::internal::GetArrayValidator<5, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->fps_allocation, validation_context,
                                         &fps_allocation_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resolution_rate_limits, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& resolution_rate_limits_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->resolution_rate_limits, validation_context,
                                         &resolution_rate_limits_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_supported_pixel_formats, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gpu_supported_pixel_formats_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoPixelFormat_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->gpu_supported_pixel_formats, validation_context,
                                         &gpu_supported_pixel_formats_validate_params)) {
    return false;
  }

  return true;
}

VideoEncoderInfo_Data::VideoEncoderInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media