// media/mojo/mojom/video_encode_accelerator.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SEND_VALIDATION_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SEND_VALIDATION_H_

#include "media/mojo/mojom/video_encode_accelerator.mojom-shared-internal.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"

#include "media/mojo/mojom/video_encode_accelerator.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoEncodeAcceleratorSupportedRateControlMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncodeAcceleratorSupportedProfileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEncodeAcceleratorSupportedProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile(input),
        &fragment->profile);

      decltype(Traits::min_resolution(input)) in_min_resolution = Traits::min_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->min_resolution)::BaseType> min_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_min_resolution,
        min_resolution_fragment);

      fragment->min_resolution.Set(
          min_resolution_fragment.is_null() ? nullptr : min_resolution_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->min_resolution.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_resolution in VideoEncodeAcceleratorSupportedProfile struct");

      decltype(Traits::max_resolution(input)) in_max_resolution = Traits::max_resolution(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_resolution)::BaseType> max_resolution_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_max_resolution,
        max_resolution_fragment);

      fragment->max_resolution.Set(
          max_resolution_fragment.is_null() ? nullptr : max_resolution_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_resolution.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_resolution in VideoEncodeAcceleratorSupportedProfile struct");

      fragment->max_framerate_numerator = Traits::max_framerate_numerator(input);

      fragment->max_framerate_denominator = Traits::max_framerate_denominator(input);

      decltype(Traits::rate_control_modes(input)) in_rate_control_modes = Traits::rate_control_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rate_control_modes)::BaseType>
          rate_control_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& rate_control_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoEncodeAcceleratorSupportedRateControlMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoEncodeAcceleratorSupportedRateControlMode>, send_validation>(
        in_rate_control_modes,
        rate_control_modes_fragment,
        &rate_control_modes_validate_params);

      fragment->rate_control_modes.Set(
          rate_control_modes_fragment.is_null() ? nullptr : rate_control_modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rate_control_modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rate_control_modes in VideoEncodeAcceleratorSupportedProfile struct");

      decltype(Traits::scalability_modes(input)) in_scalability_modes = Traits::scalability_modes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scalability_modes)::BaseType>
          scalability_modes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& scalability_modes_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::SVCScalabilityMode_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SVCScalabilityMode>, send_validation>(
        in_scalability_modes,
        scalability_modes_fragment,
        &scalability_modes_validate_params);

      fragment->scalability_modes.Set(
          scalability_modes_fragment.is_null() ? nullptr : scalability_modes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scalability_modes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scalability_modes in VideoEncodeAcceleratorSupportedProfile struct");

      fragment->is_software_codec = Traits::is_software_codec(input);

      decltype(Traits::gpu_supported_pixel_formats(input)) in_gpu_supported_pixel_formats = Traits::gpu_supported_pixel_formats(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gpu_supported_pixel_formats)::BaseType>
          gpu_supported_pixel_formats_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& gpu_supported_pixel_formats_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::VideoPixelFormat_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoPixelFormat>, send_validation>(
        in_gpu_supported_pixel_formats,
        gpu_supported_pixel_formats_fragment,
        &gpu_supported_pixel_formats_validate_params);

      fragment->gpu_supported_pixel_formats.Set(
          gpu_supported_pixel_formats_fragment.is_null() ? nullptr : gpu_supported_pixel_formats_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->gpu_supported_pixel_formats.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gpu_supported_pixel_formats in VideoEncodeAcceleratorSupportedProfile struct");

      fragment->supports_gpu_shared_images = Traits::supports_gpu_shared_images(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::EncodeCommandBufferIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EncodeCommandBufferIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EncodeCommandBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::channel_token(input)) in_channel_token = Traits::channel_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->channel_token)::BaseType> channel_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_channel_token,
        channel_token_fragment);

      fragment->channel_token.Set(
          channel_token_fragment.is_null() ? nullptr : channel_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->channel_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null channel_token in EncodeCommandBufferId struct");

      fragment->route_id = Traits::route_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VariableBitratePeakDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VariableBitratePeakDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VariableBitratePeak_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->bps = Traits::bps(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoBitrateAllocationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoBitrateAllocationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoBitrateAllocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bitrates(input)) in_bitrates = Traits::bitrates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bitrates)::BaseType>
          bitrates_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bitrates_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_bitrates,
        bitrates_fragment,
        &bitrates_validate_params);

      fragment->bitrates.Set(
          bitrates_fragment.is_null() ? nullptr : bitrates_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bitrates.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitrates in VideoBitrateAllocation struct");

      decltype(Traits::variable_bitrate_peak(input)) in_variable_bitrate_peak = Traits::variable_bitrate_peak(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->variable_bitrate_peak)::BaseType> variable_bitrate_peak_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VariableBitratePeakDataView, send_validation>(
        in_variable_bitrate_peak,
        variable_bitrate_peak_fragment);

      fragment->variable_bitrate_peak.Set(
          variable_bitrate_peak_fragment.is_null() ? nullptr : variable_bitrate_peak_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SpatialLayerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SpatialLayerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SpatialLayer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->width = Traits::width(input);

      fragment->height = Traits::height(input);

      fragment->bitrate_bps = Traits::bitrate_bps(input);

      fragment->framerate = Traits::framerate(input);

      fragment->max_qp = Traits::max_qp(input);

      fragment->num_of_temporal_layers = Traits::num_of_temporal_layers(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::ConstantBitrateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ConstantBitrateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ConstantBitrate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->target_bps = Traits::target_bps(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VariableBitrateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VariableBitrateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VariableBitrate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->target_bps = Traits::target_bps(input);

      fragment->peak_bps = Traits::peak_bps(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::ExternalBitrateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ExternalBitrateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ExternalBitrate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoEncodeAcceleratorConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncodeAcceleratorConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEncodeAcceleratorConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
        Traits::input_format(input),
        &fragment->input_format);

      decltype(Traits::input_visible_size(input)) in_input_visible_size = Traits::input_visible_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_visible_size)::BaseType> input_visible_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_input_visible_size,
        input_visible_size_fragment);

      fragment->input_visible_size.Set(
          input_visible_size_fragment.is_null() ? nullptr : input_visible_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input_visible_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_visible_size in VideoEncodeAcceleratorConfig struct");

      
      mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::output_profile(input),
        &fragment->output_profile);

      decltype(Traits::bitrate(input)) in_bitrate = Traits::bitrate(input);
      mojo::internal::MessageFragment<decltype(fragment->bitrate)>
          bitrate_fragment(fragment.message());
      bitrate_fragment.Claim(&fragment->bitrate);
      
      mojo::internal::Serialize<::media::mojom::BitrateDataView, send_validation>(
        in_bitrate,
        bitrate_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bitrate.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitrate in VideoEncodeAcceleratorConfig struct");

      fragment->framerate = Traits::framerate(input);

      
      mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfig_StorageType>(
        Traits::storage_type(input),
        &fragment->storage_type);

      
      mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfig_ContentType>(
        Traits::content_type(input),
        &fragment->content_type);

      fragment->gop_length = Traits::gop_length(input);

      fragment->has_gop_length = Traits::has_gop_length(input);

      fragment->h264_output_level = Traits::h264_output_level(input);

      fragment->has_h264_output_level = Traits::has_h264_output_level(input);

      fragment->is_constrained_h264 = Traits::is_constrained_h264(input);

      fragment->drop_frame_thresh_percentage = Traits::drop_frame_thresh_percentage(input);

      decltype(Traits::spatial_layers(input)) in_spatial_layers = Traits::spatial_layers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->spatial_layers)::BaseType>
          spatial_layers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SpatialLayerDataView>, send_validation>(
        in_spatial_layers,
        spatial_layers_fragment,
        &spatial_layers_validate_params);

      fragment->spatial_layers.Set(
          spatial_layers_fragment.is_null() ? nullptr : spatial_layers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->spatial_layers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spatial_layers in VideoEncodeAcceleratorConfig struct");

      
      mojo::internal::Serialize<::media::mojom::SVCInterLayerPredMode>(
        Traits::inter_layer_pred(input),
        &fragment->inter_layer_pred);

      fragment->require_low_delay = Traits::require_low_delay(input);

      
      mojo::internal::Serialize<::media::mojom::VideoEncodeAcceleratorConfig_EncoderType>(
        Traits::required_encoder_type(input),
        &fragment->required_encoder_type);

      fragment->manual_reference_buffer_control = Traits::manual_reference_buffer_control(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoEncodeOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncodeOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEncodeOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->force_keyframe = Traits::force_keyframe(input);

      fragment->quantizer = Traits::quantizer(input);
      fragment->update_buffer_$flag = Traits::update_buffer(input).has_value();
      if (Traits::update_buffer(input).has_value()) {
        fragment->update_buffer_$value = Traits::update_buffer(input).value();
      }

      decltype(Traits::reference_buffers(input)) in_reference_buffers = Traits::reference_buffers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reference_buffers)::BaseType>
          reference_buffers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& reference_buffers_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_reference_buffers,
        reference_buffers_fragment,
        &reference_buffers_validate_params);

      fragment->reference_buffers.Set(
          reference_buffers_fragment.is_null() ? nullptr : reference_buffers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reference_buffers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reference_buffers in VideoEncodeOptions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::DropFrameMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DropFrameMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DropFrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->spatial_idx = Traits::spatial_idx(input);

      fragment->end_of_picture = Traits::end_of_picture(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::H264MetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::H264MetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::H264Metadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->temporal_idx = Traits::temporal_idx(input);

      fragment->layer_sync = Traits::layer_sync(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::Vp8MetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::Vp8MetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Vp8Metadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->non_reference = Traits::non_reference(input);

      fragment->temporal_idx = Traits::temporal_idx(input);

      fragment->layer_sync = Traits::layer_sync(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::Vp9MetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::Vp9MetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Vp9Metadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->inter_pic_predicted = Traits::inter_pic_predicted(input);

      fragment->temporal_up_switch = Traits::temporal_up_switch(input);

      fragment->referenced_by_upper_spatial_layers = Traits::referenced_by_upper_spatial_layers(input);

      fragment->reference_lower_spatial_layers = Traits::reference_lower_spatial_layers(input);

      fragment->end_of_picture = Traits::end_of_picture(input);

      fragment->temporal_idx = Traits::temporal_idx(input);

      fragment->spatial_idx = Traits::spatial_idx(input);

      decltype(Traits::spatial_layer_resolutions(input)) in_spatial_layer_resolutions = Traits::spatial_layer_resolutions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->spatial_layer_resolutions)::BaseType>
          spatial_layer_resolutions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& spatial_layer_resolutions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>, send_validation>(
        in_spatial_layer_resolutions,
        spatial_layer_resolutions_fragment,
        &spatial_layer_resolutions_validate_params);

      fragment->spatial_layer_resolutions.Set(
          spatial_layer_resolutions_fragment.is_null() ? nullptr : spatial_layer_resolutions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->spatial_layer_resolutions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spatial_layer_resolutions in Vp9Metadata struct");

      fragment->begin_active_spatial_layer_index = Traits::begin_active_spatial_layer_index(input);

      fragment->end_active_spatial_layer_index = Traits::end_active_spatial_layer_index(input);

      decltype(Traits::p_diffs(input)) in_p_diffs = Traits::p_diffs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->p_diffs)::BaseType>
          p_diffs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& p_diffs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_p_diffs,
        p_diffs_fragment,
        &p_diffs_validate_params);

      fragment->p_diffs.Set(
          p_diffs_fragment.is_null() ? nullptr : p_diffs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->p_diffs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null p_diffs in Vp9Metadata struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::SVCGenericMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SVCGenericMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SVCGenericMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->follow_svc_spec = Traits::follow_svc_spec(input);

      fragment->temporal_idx = Traits::temporal_idx(input);

      fragment->spatial_idx = Traits::spatial_idx(input);
      fragment->reference_flags_$flag = Traits::reference_flags(input).has_value();
      if (Traits::reference_flags(input).has_value()) {
        fragment->reference_flags_$value = Traits::reference_flags(input).value();
      }
      fragment->refresh_flags_$flag = Traits::refresh_flags(input).has_value();
      if (Traits::refresh_flags(input).has_value()) {
        fragment->refresh_flags_$value = Traits::refresh_flags(input).value();
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::BitstreamBufferMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::BitstreamBufferMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::BitstreamBufferMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->payload_size_bytes = Traits::payload_size_bytes(input);

      fragment->key_frame = Traits::key_frame(input);

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in BitstreamBufferMetadata struct");

      fragment->qp = Traits::qp(input);

      decltype(Traits::optional_metadata(input)) in_optional_metadata = Traits::optional_metadata(input);
      mojo::internal::MessageFragment<decltype(fragment->optional_metadata)>
          optional_metadata_fragment(fragment.message());
      optional_metadata_fragment.Claim(&fragment->optional_metadata);
      
      mojo::internal::Serialize<::media::mojom::OptionalMetadataDataView, send_validation>(
        in_optional_metadata,
        optional_metadata_fragment,
        true);

      decltype(Traits::svc_generic(input)) in_svc_generic = Traits::svc_generic(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->svc_generic)::BaseType> svc_generic_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::SVCGenericMetadataDataView, send_validation>(
        in_svc_generic,
        svc_generic_fragment);

      fragment->svc_generic.Set(
          svc_generic_fragment.is_null() ? nullptr : svc_generic_fragment.data());

      decltype(Traits::encoded_size(input)) in_encoded_size = Traits::encoded_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encoded_size)::BaseType> encoded_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_encoded_size,
        encoded_size_fragment);

      fragment->encoded_size.Set(
          encoded_size_fragment.is_null() ? nullptr : encoded_size_fragment.data());

      decltype(Traits::encoded_color_space(input)) in_encoded_color_space = Traits::encoded_color_space(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encoded_color_space)::BaseType> encoded_color_space_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView, send_validation>(
        in_encoded_color_space,
        encoded_color_space_fragment);

      fragment->encoded_color_space.Set(
          encoded_color_space_fragment.is_null() ? nullptr : encoded_color_space_fragment.data());
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::BitrateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::BitrateDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::Bitrate_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::BitrateDataView::Tag::kConstant: {
    decltype(Traits::constant(input))
    in_constant = Traits::constant(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_constant)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::ConstantBitrateDataView, send_validation>(
  in_constant,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null constant in Bitrate union");
    fragment->data.f_constant.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::BitrateDataView::Tag::kVariable: {
    decltype(Traits::variable(input))
    in_variable = Traits::variable(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_variable)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::VariableBitrateDataView, send_validation>(
  in_variable,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null variable in Bitrate union");
    fragment->data.f_variable.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::BitrateDataView::Tag::kExternal: {
    decltype(Traits::external(input))
    in_external = Traits::external(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_external)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::ExternalBitrateDataView, send_validation>(
  in_external,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null external in Bitrate union");
    fragment->data.f_external.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::OptionalMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::OptionalMetadataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::OptionalMetadata_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::OptionalMetadataDataView::Tag::kDrop: {
    decltype(Traits::drop(input))
    in_drop = Traits::drop(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_drop)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::DropFrameMetadataDataView, send_validation>(
  in_drop,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null drop in OptionalMetadata union");
    fragment->data.f_drop.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::OptionalMetadataDataView::Tag::kH264: {
    decltype(Traits::h264(input))
    in_h264 = Traits::h264(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_h264)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::H264MetadataDataView, send_validation>(
  in_h264,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null h264 in OptionalMetadata union");
    fragment->data.f_h264.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::OptionalMetadataDataView::Tag::kVp8: {
    decltype(Traits::vp8(input))
    in_vp8 = Traits::vp8(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_vp8)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::Vp8MetadataDataView, send_validation>(
  in_vp8,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null vp8 in OptionalMetadata union");
    fragment->data.f_vp8.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::OptionalMetadataDataView::Tag::kVp9: {
    decltype(Traits::vp9(input))
    in_vp9 = Traits::vp9(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_vp9)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::Vp9MetadataDataView, send_validation>(
  in_vp9,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null vp9 in OptionalMetadata union");
    fragment->data.f_vp9.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SEND_VALIDATION_H_