// media/mojo/mojom/speech_recognizer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  SpeechRecognitionAudioForwarderRemote as media_mojom_SpeechRecognitionAudioForwarderRemote,
  SpeechRecognitionAudioForwarderPendingReceiver as media_mojom_SpeechRecognitionAudioForwarderPendingReceiver
} from './speech_recognition_audio_forwarder.mojom.m.js';

import {
  SpeechRecognitionError as media_mojom_SpeechRecognitionError,
  SpeechRecognitionErrorSpec as media_mojom_SpeechRecognitionErrorSpec
} from './speech_recognition_error.mojom.m.js';

import {
  SpeechRecognitionGrammar as media_mojom_SpeechRecognitionGrammar,
  SpeechRecognitionGrammarSpec as media_mojom_SpeechRecognitionGrammarSpec
} from './speech_recognition_grammar.mojom.m.js';

import {
  SpeechRecognitionRecognitionContext as media_mojom_SpeechRecognitionRecognitionContext,
  SpeechRecognitionRecognitionContextSpec as media_mojom_SpeechRecognitionRecognitionContextSpec
} from './speech_recognition_recognition_context.mojom.m.js';

import {
  WebSpeechRecognitionResult as media_mojom_WebSpeechRecognitionResult,
  WebSpeechRecognitionResultSpec as media_mojom_WebSpeechRecognitionResultSpec
} from './speech_recognition_result.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AvailabilityStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AvailabilityStatus = {
  
  kUnavailable: 0,
  kDownloadable: 1,
  kDownloading: 2,
  kAvailable: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognizerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognizer', scope);
  }
}

/** @interface */
export class SpeechRecognizerInterface {
  
  /**
   * @param { !StartSpeechRecognitionRequestParams } params
   */

  start(params) {}
}

/**
 * @implements { SpeechRecognizerInterface }
 */
export class SpeechRecognizerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognizerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognizerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognizerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !StartSpeechRecognitionRequestParams } params
   */

  start(
      params) {
    this.proxy.sendMessage(
        0,
        SpeechRecognizer_Start_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognizer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognizerReceiver {
  /**
   * @param {!SpeechRecognizerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognizerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognizer_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognizer {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognizer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognizerRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognizerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognizer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognizerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognizerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognizerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognizer_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OnDeviceSpeechRecognitionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.OnDeviceSpeechRecognition', scope);
  }
}

/** @interface */
export class OnDeviceSpeechRecognitionInterface {
  
  /**
   * @param { !Array<!string> } languages
   * @return {!Promise<{
        status: !AvailabilityStatus,
   *  }>}
   */

  available(languages) {}
  
  /**
   * @param { !Array<!string> } languages
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  install(languages) {}
}

/**
 * @implements { OnDeviceSpeechRecognitionInterface }
 */
export class OnDeviceSpeechRecognitionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OnDeviceSpeechRecognitionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OnDeviceSpeechRecognitionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OnDeviceSpeechRecognitionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } languages
   * @return {!Promise<{
        status: !AvailabilityStatus,
   *  }>}
   */

  available(
      languages) {
    return this.proxy.sendMessage(
        0,
        OnDeviceSpeechRecognition_Available_ParamsSpec.$,
        OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
        [
          languages
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } languages
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  install(
      languages) {
    return this.proxy.sendMessage(
        1,
        OnDeviceSpeechRecognition_Install_ParamsSpec.$,
        OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
        [
          languages
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OnDeviceSpeechRecognition
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceSpeechRecognitionReceiver {
  /**
   * @param {!OnDeviceSpeechRecognitionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OnDeviceSpeechRecognitionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OnDeviceSpeechRecognitionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceSpeechRecognitionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OnDeviceSpeechRecognition_Available_ParamsSpec.$,
        OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
        impl.available.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        OnDeviceSpeechRecognition_Install_ParamsSpec.$,
        OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
        impl.install.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OnDeviceSpeechRecognition {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.OnDeviceSpeechRecognition";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OnDeviceSpeechRecognitionRemote}
   */
  static getRemote() {
    let remote = new OnDeviceSpeechRecognitionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OnDeviceSpeechRecognition
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceSpeechRecognitionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OnDeviceSpeechRecognitionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OnDeviceSpeechRecognitionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.available =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OnDeviceSpeechRecognition_Available_ParamsSpec.$,
        OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
        this.available.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.install =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        OnDeviceSpeechRecognition_Install_ParamsSpec.$,
        OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
        this.install.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionSessionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionSession', scope);
  }
}

/** @interface */
export class SpeechRecognitionSessionInterface {
  
  /**
   */

  abort() {}
  
  /**
   */

  stopCapture() {}
  
  /**
   * @param { !media_mojom_SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(recognitionContext) {}
}

/**
 * @implements { SpeechRecognitionSessionInterface }
 */
export class SpeechRecognitionSessionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionSession_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stopCapture() {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionSession_StopCapture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_SpeechRecognitionRecognitionContext } recognitionContext
   */

  updateRecognitionContext(
      recognitionContext) {
    this.proxy.sendMessage(
        2,
        SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
        null,
        [
          recognitionContext
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionSessionReceiver {
  /**
   * @param {!SpeechRecognitionSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSession_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSession_StopCapture_ParamsSpec.$,
        null,
        impl.stopCapture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
        null,
        impl.updateRecognitionContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionSession {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionSessionRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionSessionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSession_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopCapture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSession_StopCapture_ParamsSpec.$,
        null,
        this.stopCapture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
        null,
        this.updateRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionSessionClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionSessionClient', scope);
  }
}

/** @interface */
export class SpeechRecognitionSessionClientInterface {
  
  /**
   * @param { !Array<!media_mojom_WebSpeechRecognitionResult> } results
   */

  resultRetrieved(results) {}
  
  /**
   * @param { !media_mojom_SpeechRecognitionError } error
   */

  errorOccurred(error) {}
  
  /**
   */

  started() {}
  
  /**
   */

  audioStarted() {}
  
  /**
   */

  soundStarted() {}
  
  /**
   */

  soundEnded() {}
  
  /**
   */

  audioEnded() {}
  
  /**
   */

  ended() {}
}

/**
 * @implements { SpeechRecognitionSessionClientInterface }
 */
export class SpeechRecognitionSessionClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionSessionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionSessionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionSessionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!media_mojom_WebSpeechRecognitionResult> } results
   */

  resultRetrieved(
      results) {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
        null,
        [
          results
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_SpeechRecognitionError } error
   */

  errorOccurred(
      error) {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   */

  started() {
    this.proxy.sendMessage(
        2,
        SpeechRecognitionSessionClient_Started_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  audioStarted() {
    this.proxy.sendMessage(
        3,
        SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  soundStarted() {
    this.proxy.sendMessage(
        4,
        SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  soundEnded() {
    this.proxy.sendMessage(
        5,
        SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  audioEnded() {
    this.proxy.sendMessage(
        6,
        SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  ended() {
    this.proxy.sendMessage(
        7,
        SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionSessionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionSessionClientReceiver {
  /**
   * @param {!SpeechRecognitionSessionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionSessionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
        null,
        impl.resultRetrieved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
        null,
        impl.errorOccurred.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionSessionClient_Started_ParamsSpec.$,
        null,
        impl.started.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
        null,
        impl.audioStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
        null,
        impl.soundStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
        null,
        impl.soundEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
        null,
        impl.audioEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
        null,
        impl.ended.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionSessionClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionSessionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionSessionClientRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionSessionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionSessionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionSessionClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionSessionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionSessionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resultRetrieved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
        null,
        this.resultRetrieved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.errorOccurred =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
        null,
        this.errorOccurred.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.started =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionSessionClient_Started_ParamsSpec.$,
        null,
        this.started.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
        null,
        this.audioStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.soundStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
        null,
        this.soundStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.soundEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
        null,
        this.soundEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.audioEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
        null,
        this.audioEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.ended =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
        null,
        this.ended.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StartSpeechRecognitionRequestParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognizer_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceSpeechRecognition_Available_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceSpeechRecognition_Available_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceSpeechRecognition_Install_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OnDeviceSpeechRecognition_Install_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSession_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSession_StopCapture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_Started_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_AudioStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_SoundStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_SoundEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_AudioEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionSessionClient_Ended_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    StartSpeechRecognitionRequestParamsSpec.$,
    'StartSpeechRecognitionRequestParams',
    [
      mojo.internal.StructField(
        'sessionReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(SpeechRecognitionSessionPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(SpeechRecognitionSessionClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'grammars', 24,
        0,
        mojo.internal.Array(media_mojom_SpeechRecognitionGrammarSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recognitionContext', 32,
        0,
        media_mojom_SpeechRecognitionRecognitionContextSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxHypotheses', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'continuous', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'interimResults', 40,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'onDevice', 40,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowCloudFallback', 40,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioForwarder', 44,
        0,
        mojo.internal.InterfaceRequest(media_mojom_SpeechRecognitionAudioForwarderPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'channelCount', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sampleRate', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class StartSpeechRecognitionRequestParams {
  constructor() {
    /** @type { !SpeechRecognitionSessionPendingReceiver } */
    this.sessionReceiver;
    /** @type { !SpeechRecognitionSessionClientRemote } */
    this.client;
    /** @type { !string } */
    this.language;
    /** @type { !Array<!media_mojom_SpeechRecognitionGrammar> } */
    this.grammars;
    /** @type { (media_mojom_SpeechRecognitionRecognitionContext|undefined) } */
    this.recognitionContext;
    /** @type { !number } */
    this.maxHypotheses;
    /** @type { !boolean } */
    this.continuous;
    /** @type { !boolean } */
    this.interimResults;
    /** @type { !boolean } */
    this.onDevice;
    /** @type { !boolean } */
    this.allowCloudFallback;
    /** @type { (media_mojom_SpeechRecognitionAudioForwarderPendingReceiver|undefined) } */
    this.audioForwarder;
    /** @type { !number } */
    this.channelCount;
    /** @type { !number } */
    this.sampleRate;
  }
}



mojo.internal.Struct(
    SpeechRecognizer_Start_ParamsSpec.$,
    'SpeechRecognizer_Start_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        StartSpeechRecognitionRequestParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognizer_Start_Params {
  constructor() {
    /** @type { !StartSpeechRecognitionRequestParams } */
    this.params;
  }
}



mojo.internal.Struct(
    OnDeviceSpeechRecognition_Available_ParamsSpec.$,
    'OnDeviceSpeechRecognition_Available_Params',
    [
      mojo.internal.StructField(
        'languages', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceSpeechRecognition_Available_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.languages;
  }
}



mojo.internal.Struct(
    OnDeviceSpeechRecognition_Available_ResponseParamsSpec.$,
    'OnDeviceSpeechRecognition_Available_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        AvailabilityStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceSpeechRecognition_Available_ResponseParams {
  constructor() {
    /** @type { !AvailabilityStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    OnDeviceSpeechRecognition_Install_ParamsSpec.$,
    'OnDeviceSpeechRecognition_Install_Params',
    [
      mojo.internal.StructField(
        'languages', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceSpeechRecognition_Install_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.languages;
  }
}



mojo.internal.Struct(
    OnDeviceSpeechRecognition_Install_ResponseParamsSpec.$,
    'OnDeviceSpeechRecognition_Install_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class OnDeviceSpeechRecognition_Install_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    SpeechRecognitionSession_Abort_ParamsSpec.$,
    'SpeechRecognitionSession_Abort_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSession_Abort_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSession_StopCapture_ParamsSpec.$,
    'SpeechRecognitionSession_StopCapture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSession_StopCapture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSession_UpdateRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionSession_UpdateRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'recognitionContext', 0,
        0,
        media_mojom_SpeechRecognitionRecognitionContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionSession_UpdateRecognitionContext_Params {
  constructor() {
    /** @type { !media_mojom_SpeechRecognitionRecognitionContext } */
    this.recognitionContext;
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_ResultRetrieved_ParamsSpec.$,
    'SpeechRecognitionSessionClient_ResultRetrieved_Params',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(media_mojom_WebSpeechRecognitionResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_ResultRetrieved_Params {
  constructor() {
    /** @type { !Array<!media_mojom_WebSpeechRecognitionResult> } */
    this.results;
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_ErrorOccurred_ParamsSpec.$,
    'SpeechRecognitionSessionClient_ErrorOccurred_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        media_mojom_SpeechRecognitionErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_ErrorOccurred_Params {
  constructor() {
    /** @type { !media_mojom_SpeechRecognitionError } */
    this.error;
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_Started_ParamsSpec.$,
    'SpeechRecognitionSessionClient_Started_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_Started_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_AudioStarted_ParamsSpec.$,
    'SpeechRecognitionSessionClient_AudioStarted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_AudioStarted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_SoundStarted_ParamsSpec.$,
    'SpeechRecognitionSessionClient_SoundStarted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_SoundStarted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_SoundEnded_ParamsSpec.$,
    'SpeechRecognitionSessionClient_SoundEnded_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_SoundEnded_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_AudioEnded_ParamsSpec.$,
    'SpeechRecognitionSessionClient_AudioEnded_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_AudioEnded_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SpeechRecognitionSessionClient_Ended_ParamsSpec.$,
    'SpeechRecognitionSessionClient_Ended_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SpeechRecognitionSessionClient_Ended_Params {
  constructor() {
  }
}

