// media/mojo/mojom/speech_recognizer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/speech_recognizer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var speech_recognition_audio_forwarder$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_audio_forwarder.mojom', 'speech_recognition_audio_forwarder.mojom.js');
  }
  var speech_recognition_error$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_error.mojom', 'speech_recognition_error.mojom.js');
  }
  var speech_recognition_grammar$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_grammar.mojom', 'speech_recognition_grammar.mojom.js');
  }
  var speech_recognition_result$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_result.mojom', 'speech_recognition_result.mojom.js');
  }
  var speech_recognition_recognition_context$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_recognition_context.mojom', 'speech_recognition_recognition_context.mojom.js');
  }


  var AvailabilityStatus = {};
  AvailabilityStatus.kUnavailable = 0;
  AvailabilityStatus.kDownloadable = 1;
  AvailabilityStatus.kDownloading = 2;
  AvailabilityStatus.kAvailable = 3;
  AvailabilityStatus.MIN_VALUE = 0;
  AvailabilityStatus.MAX_VALUE = 3;

  AvailabilityStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AvailabilityStatus.toKnownEnumValue = function(value) {
    return value;
  };

  AvailabilityStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function StartSpeechRecognitionRequestParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StartSpeechRecognitionRequestParams.prototype.initDefaults_ = function() {
    this.sessionReceiver = new bindings.InterfaceRequest();
    this.client = new SpeechRecognitionSessionClientPtr();
    this.maxHypotheses = 0;
    this.language = null;
    this.grammars = null;
    this.recognitionContext = null;
    this.continuous = false;
    this.interimResults = false;
    this.onDevice = false;
    this.allowCloudFallback = false;
    this.audioForwarder = new bindings.InterfaceRequest();
    this.channelCount = 0;
    this.sampleRate = 0;
  };
  StartSpeechRecognitionRequestParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StartSpeechRecognitionRequestParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StartSpeechRecognitionRequestParams.sessionReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate StartSpeechRecognitionRequestParams.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StartSpeechRecognitionRequestParams.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate StartSpeechRecognitionRequestParams.grammars
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(speech_recognition_grammar$.SpeechRecognitionGrammar), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StartSpeechRecognitionRequestParams.recognitionContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, true);
    if (err !== validator.validationError.NONE)
        return err;







    // validate StartSpeechRecognitionRequestParams.audioForwarder
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 44, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  StartSpeechRecognitionRequestParams.encodedSize = codec.kStructHeaderSize + 56;

  StartSpeechRecognitionRequestParams.decode = function(decoder) {
    var packed;
    var val = new StartSpeechRecognitionRequestParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(SpeechRecognitionSessionClientPtr));
    val.maxHypotheses =
        decoder.decodeStruct(codec.Uint32);
    val.language =
        decoder.decodeStruct(codec.String);
    val.grammars =
        decoder.decodeArrayPointer(new codec.PointerTo(speech_recognition_grammar$.SpeechRecognitionGrammar));
    val.recognitionContext =
        decoder.decodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext);
    packed = decoder.readUint8();
    val.continuous = (packed >> 0) & 1 ? true : false;
    val.interimResults = (packed >> 1) & 1 ? true : false;
    val.onDevice = (packed >> 2) & 1 ? true : false;
    val.allowCloudFallback = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.audioForwarder =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.channelCount =
        decoder.decodeStruct(codec.Int32);
    val.sampleRate =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  StartSpeechRecognitionRequestParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StartSpeechRecognitionRequestParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.sessionReceiver);
    encoder.encodeStruct(new codec.Interface(SpeechRecognitionSessionClientPtr), val.client);
    encoder.encodeStruct(codec.Uint32, val.maxHypotheses);
    encoder.encodeStruct(codec.String, val.language);
    encoder.encodeArrayPointer(new codec.PointerTo(speech_recognition_grammar$.SpeechRecognitionGrammar), val.grammars);
    encoder.encodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, val.recognitionContext);
    packed = 0;
    packed |= (val.continuous & 1) << 0
    packed |= (val.interimResults & 1) << 1
    packed |= (val.onDevice & 1) << 2
    packed |= (val.allowCloudFallback & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.audioForwarder);
    encoder.encodeStruct(codec.Int32, val.channelCount);
    encoder.encodeStruct(codec.Int32, val.sampleRate);
  };
  function SpeechRecognizer_Start_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognizer_Start_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  SpeechRecognizer_Start_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognizer_Start_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognizer_Start_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, StartSpeechRecognitionRequestParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognizer_Start_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognizer_Start_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognizer_Start_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(StartSpeechRecognitionRequestParams);
    return val;
  };

  SpeechRecognizer_Start_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognizer_Start_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(StartSpeechRecognitionRequestParams, val.params);
  };
  function OnDeviceSpeechRecognition_Available_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceSpeechRecognition_Available_Params.prototype.initDefaults_ = function() {
    this.languages = null;
  };
  OnDeviceSpeechRecognition_Available_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceSpeechRecognition_Available_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceSpeechRecognition_Available_Params.languages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceSpeechRecognition_Available_Params.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceSpeechRecognition_Available_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceSpeechRecognition_Available_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.languages =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  OnDeviceSpeechRecognition_Available_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceSpeechRecognition_Available_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.languages);
  };
  function OnDeviceSpeechRecognition_Available_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceSpeechRecognition_Available_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  OnDeviceSpeechRecognition_Available_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceSpeechRecognition_Available_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceSpeechRecognition_Available_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AvailabilityStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceSpeechRecognition_Available_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceSpeechRecognition_Available_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceSpeechRecognition_Available_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(AvailabilityStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceSpeechRecognition_Available_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceSpeechRecognition_Available_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OnDeviceSpeechRecognition_Install_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceSpeechRecognition_Install_Params.prototype.initDefaults_ = function() {
    this.languages = null;
  };
  OnDeviceSpeechRecognition_Install_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceSpeechRecognition_Install_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OnDeviceSpeechRecognition_Install_Params.languages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OnDeviceSpeechRecognition_Install_Params.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceSpeechRecognition_Install_Params.decode = function(decoder) {
    var packed;
    var val = new OnDeviceSpeechRecognition_Install_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.languages =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  OnDeviceSpeechRecognition_Install_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceSpeechRecognition_Install_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.languages);
  };
  function OnDeviceSpeechRecognition_Install_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OnDeviceSpeechRecognition_Install_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  OnDeviceSpeechRecognition_Install_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OnDeviceSpeechRecognition_Install_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OnDeviceSpeechRecognition_Install_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  OnDeviceSpeechRecognition_Install_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new OnDeviceSpeechRecognition_Install_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OnDeviceSpeechRecognition_Install_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OnDeviceSpeechRecognition_Install_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechRecognitionSession_Abort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSession_Abort_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSession_Abort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSession_Abort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSession_Abort_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSession_Abort_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSession_Abort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSession_Abort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSession_Abort_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSession_StopCapture_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSession_StopCapture_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSession_StopCapture_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSession_StopCapture_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSession_StopCapture_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSession_StopCapture_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSession_StopCapture_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSession_StopCapture_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSession_StopCapture_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSession_UpdateRecognitionContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSession_UpdateRecognitionContext_Params.prototype.initDefaults_ = function() {
    this.recognitionContext = null;
  };
  SpeechRecognitionSession_UpdateRecognitionContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSession_UpdateRecognitionContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionSession_UpdateRecognitionContext_Params.recognitionContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSession_UpdateRecognitionContext_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionSession_UpdateRecognitionContext_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSession_UpdateRecognitionContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.recognitionContext =
        decoder.decodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext);
    return val;
  };

  SpeechRecognitionSession_UpdateRecognitionContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSession_UpdateRecognitionContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(speech_recognition_recognition_context$.SpeechRecognitionRecognitionContext, val.recognitionContext);
  };
  function SpeechRecognitionSessionClient_ResultRetrieved_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_ResultRetrieved_Params.prototype.initDefaults_ = function() {
    this.results = null;
  };
  SpeechRecognitionSessionClient_ResultRetrieved_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_ResultRetrieved_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionSessionClient_ResultRetrieved_Params.results
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(speech_recognition_result$.WebSpeechRecognitionResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_ResultRetrieved_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionSessionClient_ResultRetrieved_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_ResultRetrieved_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.results =
        decoder.decodeArrayPointer(new codec.PointerTo(speech_recognition_result$.WebSpeechRecognitionResult));
    return val;
  };

  SpeechRecognitionSessionClient_ResultRetrieved_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_ResultRetrieved_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(speech_recognition_result$.WebSpeechRecognitionResult), val.results);
  };
  function SpeechRecognitionSessionClient_ErrorOccurred_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_ErrorOccurred_Params.prototype.initDefaults_ = function() {
    this.error = null;
  };
  SpeechRecognitionSessionClient_ErrorOccurred_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_ErrorOccurred_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionSessionClient_ErrorOccurred_Params.error
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, speech_recognition_error$.SpeechRecognitionError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_ErrorOccurred_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionSessionClient_ErrorOccurred_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_ErrorOccurred_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStructPointer(speech_recognition_error$.SpeechRecognitionError);
    return val;
  };

  SpeechRecognitionSessionClient_ErrorOccurred_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_ErrorOccurred_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(speech_recognition_error$.SpeechRecognitionError, val.error);
  };
  function SpeechRecognitionSessionClient_Started_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_Started_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSessionClient_Started_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_Started_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_Started_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSessionClient_Started_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_Started_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSessionClient_Started_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_Started_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSessionClient_AudioStarted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_AudioStarted_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSessionClient_AudioStarted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_AudioStarted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_AudioStarted_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSessionClient_AudioStarted_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_AudioStarted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSessionClient_AudioStarted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_AudioStarted_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSessionClient_SoundStarted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_SoundStarted_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSessionClient_SoundStarted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_SoundStarted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_SoundStarted_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSessionClient_SoundStarted_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_SoundStarted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSessionClient_SoundStarted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_SoundStarted_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSessionClient_SoundEnded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_SoundEnded_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSessionClient_SoundEnded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_SoundEnded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_SoundEnded_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSessionClient_SoundEnded_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_SoundEnded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSessionClient_SoundEnded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_SoundEnded_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSessionClient_AudioEnded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_AudioEnded_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSessionClient_AudioEnded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_AudioEnded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_AudioEnded_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSessionClient_AudioEnded_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_AudioEnded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSessionClient_AudioEnded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_AudioEnded_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechRecognitionSessionClient_Ended_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionSessionClient_Ended_Params.prototype.initDefaults_ = function() {
  };
  SpeechRecognitionSessionClient_Ended_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionSessionClient_Ended_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionSessionClient_Ended_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechRecognitionSessionClient_Ended_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionSessionClient_Ended_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechRecognitionSessionClient_Ended_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionSessionClient_Ended_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kSpeechRecognizer_Start_Name = 0;

  function SpeechRecognizerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognizer,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognizerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognizer, associatedInterfacePtrInfo);
  }

  SpeechRecognizerAssociatedPtr.prototype =
      Object.create(SpeechRecognizerPtr.prototype);
  SpeechRecognizerAssociatedPtr.prototype.constructor =
      SpeechRecognizerAssociatedPtr;

  function SpeechRecognizerProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognizerPtr.prototype.start = function() {
    return SpeechRecognizerProxy.prototype.start
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognizerProxy.prototype.start = function(params) {
    var params_ = new SpeechRecognizer_Start_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognizer_Start_Name,
        codec.align(SpeechRecognizer_Start_Params.encodedSize));
    builder.encodeStruct(SpeechRecognizer_Start_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognizerStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognizerStub.prototype.start = function(params) {
    return this.delegate_ && this.delegate_.start && this.delegate_.start(params);
  }

  SpeechRecognizerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognizer_Start_Name:
      var params = reader.decodeStruct(SpeechRecognizer_Start_Params);
      this.start(params.params);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognizerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognizerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognizer_Start_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognizer_Start_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognizerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognizer = {
    name: 'media.mojom.SpeechRecognizer',
    kVersion: 0,
    ptrClass: SpeechRecognizerPtr,
    proxyClass: SpeechRecognizerProxy,
    stubClass: SpeechRecognizerStub,
    validateRequest: validateSpeechRecognizerRequest,
    validateResponse: null,
  };
  SpeechRecognizerStub.prototype.validator = validateSpeechRecognizerRequest;
  SpeechRecognizerProxy.prototype.validator = null;
  var kOnDeviceSpeechRecognition_Available_Name = 0;
  var kOnDeviceSpeechRecognition_Install_Name = 1;

  function OnDeviceSpeechRecognitionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OnDeviceSpeechRecognition,
                                                   handleOrPtrInfo);
  }

  function OnDeviceSpeechRecognitionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OnDeviceSpeechRecognition, associatedInterfacePtrInfo);
  }

  OnDeviceSpeechRecognitionAssociatedPtr.prototype =
      Object.create(OnDeviceSpeechRecognitionPtr.prototype);
  OnDeviceSpeechRecognitionAssociatedPtr.prototype.constructor =
      OnDeviceSpeechRecognitionAssociatedPtr;

  function OnDeviceSpeechRecognitionProxy(receiver) {
    this.receiver_ = receiver;
  }
  OnDeviceSpeechRecognitionPtr.prototype.available = function() {
    return OnDeviceSpeechRecognitionProxy.prototype.available
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceSpeechRecognitionProxy.prototype.available = function(languages) {
    var params_ = new OnDeviceSpeechRecognition_Available_Params();
    params_.languages = languages;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceSpeechRecognition_Available_Name,
          codec.align(OnDeviceSpeechRecognition_Available_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceSpeechRecognition_Available_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceSpeechRecognition_Available_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  OnDeviceSpeechRecognitionPtr.prototype.install = function() {
    return OnDeviceSpeechRecognitionProxy.prototype.install
        .apply(this.ptr.getProxy(), arguments);
  };

  OnDeviceSpeechRecognitionProxy.prototype.install = function(languages) {
    var params_ = new OnDeviceSpeechRecognition_Install_Params();
    params_.languages = languages;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kOnDeviceSpeechRecognition_Install_Name,
          codec.align(OnDeviceSpeechRecognition_Install_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(OnDeviceSpeechRecognition_Install_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(OnDeviceSpeechRecognition_Install_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function OnDeviceSpeechRecognitionStub(delegate) {
    this.delegate_ = delegate;
  }
  OnDeviceSpeechRecognitionStub.prototype.available = function(languages) {
    return this.delegate_ && this.delegate_.available && this.delegate_.available(languages);
  }
  OnDeviceSpeechRecognitionStub.prototype.install = function(languages) {
    return this.delegate_ && this.delegate_.install && this.delegate_.install(languages);
  }

  OnDeviceSpeechRecognitionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  OnDeviceSpeechRecognitionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOnDeviceSpeechRecognition_Available_Name:
      var params = reader.decodeStruct(OnDeviceSpeechRecognition_Available_Params);
      this.available(params.languages).then(function(response) {
        var responseParams =
            new OnDeviceSpeechRecognition_Available_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kOnDeviceSpeechRecognition_Available_Name,
            codec.align(OnDeviceSpeechRecognition_Available_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceSpeechRecognition_Available_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kOnDeviceSpeechRecognition_Install_Name:
      var params = reader.decodeStruct(OnDeviceSpeechRecognition_Install_Params);
      this.install(params.languages).then(function(response) {
        var responseParams =
            new OnDeviceSpeechRecognition_Install_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kOnDeviceSpeechRecognition_Install_Name,
            codec.align(OnDeviceSpeechRecognition_Install_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(OnDeviceSpeechRecognition_Install_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateOnDeviceSpeechRecognitionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOnDeviceSpeechRecognition_Available_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceSpeechRecognition_Available_Params;
      break;
      case kOnDeviceSpeechRecognition_Install_Name:
        if (message.expectsResponse())
          paramsClass = OnDeviceSpeechRecognition_Install_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOnDeviceSpeechRecognitionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kOnDeviceSpeechRecognition_Available_Name:
        if (message.isResponse())
          paramsClass = OnDeviceSpeechRecognition_Available_ResponseParams;
        break;
      case kOnDeviceSpeechRecognition_Install_Name:
        if (message.isResponse())
          paramsClass = OnDeviceSpeechRecognition_Install_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var OnDeviceSpeechRecognition = {
    name: 'media.mojom.OnDeviceSpeechRecognition',
    kVersion: 0,
    ptrClass: OnDeviceSpeechRecognitionPtr,
    proxyClass: OnDeviceSpeechRecognitionProxy,
    stubClass: OnDeviceSpeechRecognitionStub,
    validateRequest: validateOnDeviceSpeechRecognitionRequest,
    validateResponse: validateOnDeviceSpeechRecognitionResponse,
  };
  OnDeviceSpeechRecognitionStub.prototype.validator = validateOnDeviceSpeechRecognitionRequest;
  OnDeviceSpeechRecognitionProxy.prototype.validator = validateOnDeviceSpeechRecognitionResponse;
  var kSpeechRecognitionSession_Abort_Name = 0;
  var kSpeechRecognitionSession_StopCapture_Name = 1;
  var kSpeechRecognitionSession_UpdateRecognitionContext_Name = 2;

  function SpeechRecognitionSessionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionSession,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionSessionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionSession, associatedInterfacePtrInfo);
  }

  SpeechRecognitionSessionAssociatedPtr.prototype =
      Object.create(SpeechRecognitionSessionPtr.prototype);
  SpeechRecognitionSessionAssociatedPtr.prototype.constructor =
      SpeechRecognitionSessionAssociatedPtr;

  function SpeechRecognitionSessionProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionSessionPtr.prototype.abort = function() {
    return SpeechRecognitionSessionProxy.prototype.abort
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionProxy.prototype.abort = function() {
    var params_ = new SpeechRecognitionSession_Abort_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSession_Abort_Name,
        codec.align(SpeechRecognitionSession_Abort_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSession_Abort_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionPtr.prototype.stopCapture = function() {
    return SpeechRecognitionSessionProxy.prototype.stopCapture
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionProxy.prototype.stopCapture = function() {
    var params_ = new SpeechRecognitionSession_StopCapture_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSession_StopCapture_Name,
        codec.align(SpeechRecognitionSession_StopCapture_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSession_StopCapture_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionPtr.prototype.updateRecognitionContext = function() {
    return SpeechRecognitionSessionProxy.prototype.updateRecognitionContext
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionProxy.prototype.updateRecognitionContext = function(recognitionContext) {
    var params_ = new SpeechRecognitionSession_UpdateRecognitionContext_Params();
    params_.recognitionContext = recognitionContext;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSession_UpdateRecognitionContext_Name,
        codec.align(SpeechRecognitionSession_UpdateRecognitionContext_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSession_UpdateRecognitionContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionSessionStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionSessionStub.prototype.abort = function() {
    return this.delegate_ && this.delegate_.abort && this.delegate_.abort();
  }
  SpeechRecognitionSessionStub.prototype.stopCapture = function() {
    return this.delegate_ && this.delegate_.stopCapture && this.delegate_.stopCapture();
  }
  SpeechRecognitionSessionStub.prototype.updateRecognitionContext = function(recognitionContext) {
    return this.delegate_ && this.delegate_.updateRecognitionContext && this.delegate_.updateRecognitionContext(recognitionContext);
  }

  SpeechRecognitionSessionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionSession_Abort_Name:
      var params = reader.decodeStruct(SpeechRecognitionSession_Abort_Params);
      this.abort();
      return true;
    case kSpeechRecognitionSession_StopCapture_Name:
      var params = reader.decodeStruct(SpeechRecognitionSession_StopCapture_Params);
      this.stopCapture();
      return true;
    case kSpeechRecognitionSession_UpdateRecognitionContext_Name:
      var params = reader.decodeStruct(SpeechRecognitionSession_UpdateRecognitionContext_Params);
      this.updateRecognitionContext(params.recognitionContext);
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionSessionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionSessionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionSession_Abort_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSession_Abort_Params;
      break;
      case kSpeechRecognitionSession_StopCapture_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSession_StopCapture_Params;
      break;
      case kSpeechRecognitionSession_UpdateRecognitionContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSession_UpdateRecognitionContext_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionSessionResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionSession = {
    name: 'media.mojom.SpeechRecognitionSession',
    kVersion: 1,
    ptrClass: SpeechRecognitionSessionPtr,
    proxyClass: SpeechRecognitionSessionProxy,
    stubClass: SpeechRecognitionSessionStub,
    validateRequest: validateSpeechRecognitionSessionRequest,
    validateResponse: null,
  };
  SpeechRecognitionSessionStub.prototype.validator = validateSpeechRecognitionSessionRequest;
  SpeechRecognitionSessionProxy.prototype.validator = null;
  var kSpeechRecognitionSessionClient_ResultRetrieved_Name = 0;
  var kSpeechRecognitionSessionClient_ErrorOccurred_Name = 1;
  var kSpeechRecognitionSessionClient_Started_Name = 2;
  var kSpeechRecognitionSessionClient_AudioStarted_Name = 3;
  var kSpeechRecognitionSessionClient_SoundStarted_Name = 4;
  var kSpeechRecognitionSessionClient_SoundEnded_Name = 5;
  var kSpeechRecognitionSessionClient_AudioEnded_Name = 6;
  var kSpeechRecognitionSessionClient_Ended_Name = 7;

  function SpeechRecognitionSessionClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechRecognitionSessionClient,
                                                   handleOrPtrInfo);
  }

  function SpeechRecognitionSessionClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechRecognitionSessionClient, associatedInterfacePtrInfo);
  }

  SpeechRecognitionSessionClientAssociatedPtr.prototype =
      Object.create(SpeechRecognitionSessionClientPtr.prototype);
  SpeechRecognitionSessionClientAssociatedPtr.prototype.constructor =
      SpeechRecognitionSessionClientAssociatedPtr;

  function SpeechRecognitionSessionClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechRecognitionSessionClientPtr.prototype.resultRetrieved = function() {
    return SpeechRecognitionSessionClientProxy.prototype.resultRetrieved
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.resultRetrieved = function(results) {
    var params_ = new SpeechRecognitionSessionClient_ResultRetrieved_Params();
    params_.results = results;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_ResultRetrieved_Name,
        codec.align(SpeechRecognitionSessionClient_ResultRetrieved_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_ResultRetrieved_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.errorOccurred = function() {
    return SpeechRecognitionSessionClientProxy.prototype.errorOccurred
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.errorOccurred = function(error) {
    var params_ = new SpeechRecognitionSessionClient_ErrorOccurred_Params();
    params_.error = error;
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_ErrorOccurred_Name,
        codec.align(SpeechRecognitionSessionClient_ErrorOccurred_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_ErrorOccurred_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.started = function() {
    return SpeechRecognitionSessionClientProxy.prototype.started
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.started = function() {
    var params_ = new SpeechRecognitionSessionClient_Started_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_Started_Name,
        codec.align(SpeechRecognitionSessionClient_Started_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_Started_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.audioStarted = function() {
    return SpeechRecognitionSessionClientProxy.prototype.audioStarted
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.audioStarted = function() {
    var params_ = new SpeechRecognitionSessionClient_AudioStarted_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_AudioStarted_Name,
        codec.align(SpeechRecognitionSessionClient_AudioStarted_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_AudioStarted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.soundStarted = function() {
    return SpeechRecognitionSessionClientProxy.prototype.soundStarted
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.soundStarted = function() {
    var params_ = new SpeechRecognitionSessionClient_SoundStarted_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_SoundStarted_Name,
        codec.align(SpeechRecognitionSessionClient_SoundStarted_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_SoundStarted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.soundEnded = function() {
    return SpeechRecognitionSessionClientProxy.prototype.soundEnded
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.soundEnded = function() {
    var params_ = new SpeechRecognitionSessionClient_SoundEnded_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_SoundEnded_Name,
        codec.align(SpeechRecognitionSessionClient_SoundEnded_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_SoundEnded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.audioEnded = function() {
    return SpeechRecognitionSessionClientProxy.prototype.audioEnded
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.audioEnded = function() {
    var params_ = new SpeechRecognitionSessionClient_AudioEnded_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_AudioEnded_Name,
        codec.align(SpeechRecognitionSessionClient_AudioEnded_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_AudioEnded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechRecognitionSessionClientPtr.prototype.ended = function() {
    return SpeechRecognitionSessionClientProxy.prototype.ended
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechRecognitionSessionClientProxy.prototype.ended = function() {
    var params_ = new SpeechRecognitionSessionClient_Ended_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechRecognitionSessionClient_Ended_Name,
        codec.align(SpeechRecognitionSessionClient_Ended_Params.encodedSize));
    builder.encodeStruct(SpeechRecognitionSessionClient_Ended_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechRecognitionSessionClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechRecognitionSessionClientStub.prototype.resultRetrieved = function(results) {
    return this.delegate_ && this.delegate_.resultRetrieved && this.delegate_.resultRetrieved(results);
  }
  SpeechRecognitionSessionClientStub.prototype.errorOccurred = function(error) {
    return this.delegate_ && this.delegate_.errorOccurred && this.delegate_.errorOccurred(error);
  }
  SpeechRecognitionSessionClientStub.prototype.started = function() {
    return this.delegate_ && this.delegate_.started && this.delegate_.started();
  }
  SpeechRecognitionSessionClientStub.prototype.audioStarted = function() {
    return this.delegate_ && this.delegate_.audioStarted && this.delegate_.audioStarted();
  }
  SpeechRecognitionSessionClientStub.prototype.soundStarted = function() {
    return this.delegate_ && this.delegate_.soundStarted && this.delegate_.soundStarted();
  }
  SpeechRecognitionSessionClientStub.prototype.soundEnded = function() {
    return this.delegate_ && this.delegate_.soundEnded && this.delegate_.soundEnded();
  }
  SpeechRecognitionSessionClientStub.prototype.audioEnded = function() {
    return this.delegate_ && this.delegate_.audioEnded && this.delegate_.audioEnded();
  }
  SpeechRecognitionSessionClientStub.prototype.ended = function() {
    return this.delegate_ && this.delegate_.ended && this.delegate_.ended();
  }

  SpeechRecognitionSessionClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechRecognitionSessionClient_ResultRetrieved_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_ResultRetrieved_Params);
      this.resultRetrieved(params.results);
      return true;
    case kSpeechRecognitionSessionClient_ErrorOccurred_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_ErrorOccurred_Params);
      this.errorOccurred(params.error);
      return true;
    case kSpeechRecognitionSessionClient_Started_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_Started_Params);
      this.started();
      return true;
    case kSpeechRecognitionSessionClient_AudioStarted_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_AudioStarted_Params);
      this.audioStarted();
      return true;
    case kSpeechRecognitionSessionClient_SoundStarted_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_SoundStarted_Params);
      this.soundStarted();
      return true;
    case kSpeechRecognitionSessionClient_SoundEnded_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_SoundEnded_Params);
      this.soundEnded();
      return true;
    case kSpeechRecognitionSessionClient_AudioEnded_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_AudioEnded_Params);
      this.audioEnded();
      return true;
    case kSpeechRecognitionSessionClient_Ended_Name:
      var params = reader.decodeStruct(SpeechRecognitionSessionClient_Ended_Params);
      this.ended();
      return true;
    default:
      return false;
    }
  };

  SpeechRecognitionSessionClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechRecognitionSessionClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechRecognitionSessionClient_ResultRetrieved_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_ResultRetrieved_Params;
      break;
      case kSpeechRecognitionSessionClient_ErrorOccurred_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_ErrorOccurred_Params;
      break;
      case kSpeechRecognitionSessionClient_Started_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_Started_Params;
      break;
      case kSpeechRecognitionSessionClient_AudioStarted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_AudioStarted_Params;
      break;
      case kSpeechRecognitionSessionClient_SoundStarted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_SoundStarted_Params;
      break;
      case kSpeechRecognitionSessionClient_SoundEnded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_SoundEnded_Params;
      break;
      case kSpeechRecognitionSessionClient_AudioEnded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_AudioEnded_Params;
      break;
      case kSpeechRecognitionSessionClient_Ended_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechRecognitionSessionClient_Ended_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechRecognitionSessionClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechRecognitionSessionClient = {
    name: 'media.mojom.SpeechRecognitionSessionClient',
    kVersion: 0,
    ptrClass: SpeechRecognitionSessionClientPtr,
    proxyClass: SpeechRecognitionSessionClientProxy,
    stubClass: SpeechRecognitionSessionClientStub,
    validateRequest: validateSpeechRecognitionSessionClientRequest,
    validateResponse: null,
  };
  SpeechRecognitionSessionClientStub.prototype.validator = validateSpeechRecognitionSessionClientRequest;
  SpeechRecognitionSessionClientProxy.prototype.validator = null;
  exports.AvailabilityStatus = AvailabilityStatus;
  exports.StartSpeechRecognitionRequestParams = StartSpeechRecognitionRequestParams;
  exports.SpeechRecognizer = SpeechRecognizer;
  exports.SpeechRecognizerPtr = SpeechRecognizerPtr;
  exports.SpeechRecognizerAssociatedPtr = SpeechRecognizerAssociatedPtr;
  exports.OnDeviceSpeechRecognition = OnDeviceSpeechRecognition;
  exports.OnDeviceSpeechRecognitionPtr = OnDeviceSpeechRecognitionPtr;
  exports.OnDeviceSpeechRecognitionAssociatedPtr = OnDeviceSpeechRecognitionAssociatedPtr;
  exports.SpeechRecognitionSession = SpeechRecognitionSession;
  exports.SpeechRecognitionSessionPtr = SpeechRecognitionSessionPtr;
  exports.SpeechRecognitionSessionAssociatedPtr = SpeechRecognitionSessionAssociatedPtr;
  exports.SpeechRecognitionSessionClient = SpeechRecognitionSessionClient;
  exports.SpeechRecognitionSessionClientPtr = SpeechRecognitionSessionClientPtr;
  exports.SpeechRecognitionSessionClientAssociatedPtr = SpeechRecognitionSessionClientAssociatedPtr;
})();