// media/mojo/mojom/speech_recognition_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  AudioParameters as media_mojom_AudioParameters,
  AudioParametersSpec as media_mojom_AudioParametersSpec
} from './audio_parameters.mojom.m.js';

import {
  AudioStreamFactoryRemote as media_mojom_AudioStreamFactoryRemote,
  AudioStreamFactoryPendingReceiver as media_mojom_AudioStreamFactoryPendingReceiver
} from './audio_stream_factory.mojom.m.js';

import {
  SpeechRecognitionContextRemote as media_mojom_SpeechRecognitionContextRemote,
  SpeechRecognitionContextPendingReceiver as media_mojom_SpeechRecognitionContextPendingReceiver,
  SpeechRecognitionRecognizerClientRemote as media_mojom_SpeechRecognitionRecognizerClientRemote,
  SpeechRecognitionRecognizerClientPendingReceiver as media_mojom_SpeechRecognitionRecognizerClientPendingReceiver,
  SpeechRecognitionOptions as media_mojom_SpeechRecognitionOptions,
  SpeechRecognitionOptionsSpec as media_mojom_SpeechRecognitionOptionsSpec
} from './speech_recognition.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioSourceSpeechRecognitionContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioSourceSpeechRecognitionContext', scope);
  }
}

/** @interface */
export class AudioSourceSpeechRecognitionContextInterface {
  
  /**
   * @param { !AudioSourceFetcherPendingReceiver } fetcherReceiver
   * @param { !media_mojom_SpeechRecognitionRecognizerClientRemote } client
   * @param { !media_mojom_SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindAudioSourceFetcher(fetcherReceiver, client, options) {}
}

/**
 * @implements { AudioSourceSpeechRecognitionContextInterface }
 */
export class AudioSourceSpeechRecognitionContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioSourceSpeechRecognitionContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioSourceSpeechRecognitionContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioSourceSpeechRecognitionContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AudioSourceFetcherPendingReceiver } fetcherReceiver
   * @param { !media_mojom_SpeechRecognitionRecognizerClientRemote } client
   * @param { !media_mojom_SpeechRecognitionOptions } options
   * @return {!Promise<{
        isMultichannelSupported: !boolean,
   *  }>}
   */

  bindAudioSourceFetcher(
      fetcherReceiver,
      client,
      options) {
    return this.proxy.sendMessage(
        0,
        AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
        AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
        [
          fetcherReceiver,
          client,
          options
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioSourceSpeechRecognitionContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioSourceSpeechRecognitionContextReceiver {
  /**
   * @param {!AudioSourceSpeechRecognitionContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioSourceSpeechRecognitionContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioSourceSpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioSourceSpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
        AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
        impl.bindAudioSourceFetcher.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioSourceSpeechRecognitionContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioSourceSpeechRecognitionContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioSourceSpeechRecognitionContextRemote}
   */
  static getRemote() {
    let remote = new AudioSourceSpeechRecognitionContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioSourceSpeechRecognitionContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioSourceSpeechRecognitionContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioSourceSpeechRecognitionContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioSourceSpeechRecognitionContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindAudioSourceFetcher =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
        AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
        this.bindAudioSourceFetcher.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SpeechRecognitionServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.SpeechRecognitionService', scope);
  }
}

/** @interface */
export class SpeechRecognitionServiceInterface {
  
  /**
   * @param { !media_mojom_SpeechRecognitionContextPendingReceiver } context
   */

  bindSpeechRecognitionContext(context) {}
  
  /**
   * @param { !AudioSourceSpeechRecognitionContextPendingReceiver } context
   */

  bindAudioSourceSpeechRecognitionContext(context) {}
  
  /**
   * @param { !mojoBase_mojom_FilePath } binaryPath
   * @param { !Object<!string, !mojoBase_mojom_FilePath> } configPaths
   * @param { !string } primaryLanguageName
   */

  setSodaPaths(binaryPath, configPaths, primaryLanguageName) {}
  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  setSodaParams(maskOffensiveWords) {}
  
  /**
   * @param { !Object<!string, !mojoBase_mojom_FilePath> } configPaths
   */

  setSodaConfigPaths(configPaths) {}
}

/**
 * @implements { SpeechRecognitionServiceInterface }
 */
export class SpeechRecognitionServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SpeechRecognitionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SpeechRecognitionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SpeechRecognitionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_SpeechRecognitionContextPendingReceiver } context
   */

  bindSpeechRecognitionContext(
      context) {
    this.proxy.sendMessage(
        0,
        SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  
  /**
   * @param { !AudioSourceSpeechRecognitionContextPendingReceiver } context
   */

  bindAudioSourceSpeechRecognitionContext(
      context) {
    this.proxy.sendMessage(
        1,
        SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_FilePath } binaryPath
   * @param { !Object<!string, !mojoBase_mojom_FilePath> } configPaths
   * @param { !string } primaryLanguageName
   */

  setSodaPaths(
      binaryPath,
      configPaths,
      primaryLanguageName) {
    this.proxy.sendMessage(
        2,
        SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
        null,
        [
          binaryPath,
          configPaths,
          primaryLanguageName
        ],
        false);
  }

  
  /**
   * @param { !boolean } maskOffensiveWords
   */

  setSodaParams(
      maskOffensiveWords) {
    this.proxy.sendMessage(
        3,
        SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
        null,
        [
          maskOffensiveWords
        ],
        false);
  }

  
  /**
   * @param { !Object<!string, !mojoBase_mojom_FilePath> } configPaths
   */

  setSodaConfigPaths(
      configPaths) {
    this.proxy.sendMessage(
        4,
        SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
        null,
        [
          configPaths
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SpeechRecognitionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SpeechRecognitionServiceReceiver {
  /**
   * @param {!SpeechRecognitionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SpeechRecognitionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SpeechRecognitionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
        null,
        impl.bindSpeechRecognitionContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
        null,
        impl.bindAudioSourceSpeechRecognitionContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
        null,
        impl.setSodaPaths.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
        null,
        impl.setSodaParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
        null,
        impl.setSodaConfigPaths.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SpeechRecognitionService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.SpeechRecognitionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SpeechRecognitionServiceRemote}
   */
  static getRemote() {
    let remote = new SpeechRecognitionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SpeechRecognitionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SpeechRecognitionServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SpeechRecognitionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SpeechRecognitionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSpeechRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
        null,
        this.bindSpeechRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindAudioSourceSpeechRecognitionContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
        null,
        this.bindAudioSourceSpeechRecognitionContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSodaPaths =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
        null,
        this.setSodaPaths.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSodaParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
        null,
        this.setSodaParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSodaConfigPaths =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
        null,
        this.setSodaConfigPaths.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioSourceFetcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioSourceFetcher', scope);
  }
}

/** @interface */
export class AudioSourceFetcherInterface {
  
  /**
   * @param { !media_mojom_AudioStreamFactoryRemote } factory
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } audioParameters
   */

  start(factory, deviceId, audioParameters) {}
  
  /**
   */

  stop() {}
}

/**
 * @implements { AudioSourceFetcherInterface }
 */
export class AudioSourceFetcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioSourceFetcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioSourceFetcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioSourceFetcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media_mojom_AudioStreamFactoryRemote } factory
   * @param { !string } deviceId
   * @param { !media_mojom_AudioParameters } audioParameters
   */

  start(
      factory,
      deviceId,
      audioParameters) {
    this.proxy.sendMessage(
        0,
        AudioSourceFetcher_Start_ParamsSpec.$,
        null,
        [
          factory,
          deviceId,
          audioParameters
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        1,
        AudioSourceFetcher_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioSourceFetcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioSourceFetcherReceiver {
  /**
   * @param {!AudioSourceFetcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioSourceFetcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioSourceFetcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioSourceFetcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioSourceFetcher_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioSourceFetcher_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioSourceFetcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioSourceFetcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioSourceFetcherRemote}
   */
  static getRemote() {
    let remote = new AudioSourceFetcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioSourceFetcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioSourceFetcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioSourceFetcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioSourceFetcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioSourceFetcher_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioSourceFetcher_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionService_SetSodaPaths_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionService_SetSodaParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioSourceFetcher_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioSourceFetcher_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ParamsSpec.$,
    'AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params',
    [
      mojo.internal.StructField(
        'fetcherReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(AudioSourceFetcherPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(media_mojom_SpeechRecognitionRecognizerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        media_mojom_SpeechRecognitionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_Params {
  constructor() {
    /** @type { !AudioSourceFetcherPendingReceiver } */
    this.fetcherReceiver;
    /** @type { !media_mojom_SpeechRecognitionRecognizerClientRemote } */
    this.client;
    /** @type { !media_mojom_SpeechRecognitionOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParamsSpec.$,
    'AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams',
    [
      mojo.internal.StructField(
        'isMultichannelSupported', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioSourceSpeechRecognitionContext_BindAudioSourceFetcher_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.isMultichannelSupported;
  }
}



mojo.internal.Struct(
    SpeechRecognitionService_BindSpeechRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionService_BindSpeechRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        mojo.internal.InterfaceRequest(media_mojom_SpeechRecognitionContextPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionService_BindSpeechRecognitionContext_Params {
  constructor() {
    /** @type { !media_mojom_SpeechRecognitionContextPendingReceiver } */
    this.context;
  }
}



mojo.internal.Struct(
    SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_ParamsSpec.$,
    'SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        mojo.internal.InterfaceRequest(AudioSourceSpeechRecognitionContextPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionService_BindAudioSourceSpeechRecognitionContext_Params {
  constructor() {
    /** @type { !AudioSourceSpeechRecognitionContextPendingReceiver } */
    this.context;
  }
}



mojo.internal.Struct(
    SpeechRecognitionService_SetSodaPaths_ParamsSpec.$,
    'SpeechRecognitionService_SetSodaPaths_Params',
    [
      mojo.internal.StructField(
        'binaryPath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'configPaths', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase_mojom_FilePathSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'primaryLanguageName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SpeechRecognitionService_SetSodaPaths_Params {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.binaryPath;
    /** @type { !Object<!string, !mojoBase_mojom_FilePath> } */
    this.configPaths;
    /** @type { !string } */
    this.primaryLanguageName;
  }
}



mojo.internal.Struct(
    SpeechRecognitionService_SetSodaParams_ParamsSpec.$,
    'SpeechRecognitionService_SetSodaParams_Params',
    [
      mojo.internal.StructField(
        'maskOffensiveWords', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionService_SetSodaParams_Params {
  constructor() {
    /** @type { !boolean } */
    this.maskOffensiveWords;
  }
}



mojo.internal.Struct(
    SpeechRecognitionService_SetSodaConfigPaths_ParamsSpec.$,
    'SpeechRecognitionService_SetSodaConfigPaths_Params',
    [
      mojo.internal.StructField(
        'configPaths', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojoBase_mojom_FilePathSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SpeechRecognitionService_SetSodaConfigPaths_Params {
  constructor() {
    /** @type { !Object<!string, !mojoBase_mojom_FilePath> } */
    this.configPaths;
  }
}



mojo.internal.Struct(
    AudioSourceFetcher_Start_ParamsSpec.$,
    'AudioSourceFetcher_Start_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceProxy(media_mojom_AudioStreamFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioParameters', 16,
        0,
        media_mojom_AudioParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioSourceFetcher_Start_Params {
  constructor() {
    /** @type { !media_mojom_AudioStreamFactoryRemote } */
    this.factory;
    /** @type { !string } */
    this.deviceId;
    /** @type { !media_mojom_AudioParameters } */
    this.audioParameters;
  }
}



mojo.internal.Struct(
    AudioSourceFetcher_Stop_ParamsSpec.$,
    'AudioSourceFetcher_Stop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioSourceFetcher_Stop_Params {
  constructor() {
  }
}

