// media/mojo/mojom/speech_recognition_error.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/speech_recognition_error.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var speech_recognition_error_code$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/speech_recognition_error_code.mojom', 'speech_recognition_error_code.mojom.js');
  }


  var SpeechAudioErrorDetails = {};
  SpeechAudioErrorDetails.kNone = 0;
  SpeechAudioErrorDetails.kNoMic = 1;
  SpeechAudioErrorDetails.MIN_VALUE = 0;
  SpeechAudioErrorDetails.MAX_VALUE = 1;
  SpeechAudioErrorDetails.DEFAULT_VALUE = 0;

  SpeechAudioErrorDetails.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SpeechAudioErrorDetails.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SpeechAudioErrorDetails.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SpeechRecognitionError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechRecognitionError.prototype.initDefaults_ = function() {
    this.code = 0;
    this.details = 0;
  };
  SpeechRecognitionError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechRecognitionError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionError.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, speech_recognition_error_code$.SpeechRecognitionErrorCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechRecognitionError.details
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, SpeechAudioErrorDetails);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechRecognitionError.encodedSize = codec.kStructHeaderSize + 8;

  SpeechRecognitionError.decode = function(decoder) {
    var packed;
    var val = new SpeechRecognitionError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(new codec.Enum(speech_recognition_error_code$.SpeechRecognitionErrorCode));
    val.details =
        decoder.decodeStruct(new codec.Enum(SpeechAudioErrorDetails));
    return val;
  };

  SpeechRecognitionError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechRecognitionError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.encodeStruct(codec.Int32, val.details);
  };
  exports.SpeechAudioErrorDetails = SpeechAudioErrorDetails;
  exports.SpeechRecognitionError = SpeechRecognitionError;
})();