// media/mojo/mojom/renderer_extensions.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/renderer_extensions.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var media_types$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/media_types.mojom', 'media_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var MediaFoundationRenderingMode = {};
  MediaFoundationRenderingMode.DirectComposition = 0;
  MediaFoundationRenderingMode.FrameServer = 1;
  MediaFoundationRenderingMode.MIN_VALUE = 0;
  MediaFoundationRenderingMode.MAX_VALUE = 1;

  MediaFoundationRenderingMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  MediaFoundationRenderingMode.toKnownEnumValue = function(value) {
    return value;
  };

  MediaFoundationRenderingMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FlingingRendererClientExtension_OnRemotePlayStateChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FlingingRendererClientExtension_OnRemotePlayStateChange_Params.prototype.initDefaults_ = function() {
    this.state = 0;
  };
  FlingingRendererClientExtension_OnRemotePlayStateChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FlingingRendererClientExtension_OnRemotePlayStateChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FlingingRendererClientExtension_OnRemotePlayStateChange_Params.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, media_types$.MediaStatusState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FlingingRendererClientExtension_OnRemotePlayStateChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  FlingingRendererClientExtension_OnRemotePlayStateChange_Params.decode = function(decoder) {
    var packed;
    var val = new FlingingRendererClientExtension_OnRemotePlayStateChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(media_types$.MediaStatusState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FlingingRendererClientExtension_OnRemotePlayStateChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FlingingRendererClientExtension_OnRemotePlayStateChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.prototype.initDefaults_ = function() {
    this.observer = new bindings.InterfaceRequest();
  };
  MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.observer
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.decode = function(decoder) {
    var packed;
    var val = new MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFlingingRendererClientExtension_OnRemotePlayStateChange_Name = 0;

  function FlingingRendererClientExtensionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FlingingRendererClientExtension,
                                                   handleOrPtrInfo);
  }

  function FlingingRendererClientExtensionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FlingingRendererClientExtension, associatedInterfacePtrInfo);
  }

  FlingingRendererClientExtensionAssociatedPtr.prototype =
      Object.create(FlingingRendererClientExtensionPtr.prototype);
  FlingingRendererClientExtensionAssociatedPtr.prototype.constructor =
      FlingingRendererClientExtensionAssociatedPtr;

  function FlingingRendererClientExtensionProxy(receiver) {
    this.receiver_ = receiver;
  }
  FlingingRendererClientExtensionPtr.prototype.onRemotePlayStateChange = function() {
    return FlingingRendererClientExtensionProxy.prototype.onRemotePlayStateChange
        .apply(this.ptr.getProxy(), arguments);
  };

  FlingingRendererClientExtensionProxy.prototype.onRemotePlayStateChange = function(state) {
    var params_ = new FlingingRendererClientExtension_OnRemotePlayStateChange_Params();
    params_.state = state;
    var builder = new codec.MessageV0Builder(
        kFlingingRendererClientExtension_OnRemotePlayStateChange_Name,
        codec.align(FlingingRendererClientExtension_OnRemotePlayStateChange_Params.encodedSize));
    builder.encodeStruct(FlingingRendererClientExtension_OnRemotePlayStateChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FlingingRendererClientExtensionStub(delegate) {
    this.delegate_ = delegate;
  }
  FlingingRendererClientExtensionStub.prototype.onRemotePlayStateChange = function(state) {
    return this.delegate_ && this.delegate_.onRemotePlayStateChange && this.delegate_.onRemotePlayStateChange(state);
  }

  FlingingRendererClientExtensionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFlingingRendererClientExtension_OnRemotePlayStateChange_Name:
      var params = reader.decodeStruct(FlingingRendererClientExtension_OnRemotePlayStateChange_Params);
      this.onRemotePlayStateChange(params.state);
      return true;
    default:
      return false;
    }
  };

  FlingingRendererClientExtensionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFlingingRendererClientExtensionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFlingingRendererClientExtension_OnRemotePlayStateChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FlingingRendererClientExtension_OnRemotePlayStateChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFlingingRendererClientExtensionResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FlingingRendererClientExtension = {
    name: 'media.mojom.FlingingRendererClientExtension',
    kVersion: 0,
    ptrClass: FlingingRendererClientExtensionPtr,
    proxyClass: FlingingRendererClientExtensionProxy,
    stubClass: FlingingRendererClientExtensionStub,
    validateRequest: validateFlingingRendererClientExtensionRequest,
    validateResponse: null,
  };
  FlingingRendererClientExtensionStub.prototype.validator = validateFlingingRendererClientExtensionRequest;
  FlingingRendererClientExtensionProxy.prototype.validator = null;

  function MediaFoundationRendererObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaFoundationRendererObserver,
                                                   handleOrPtrInfo);
  }

  function MediaFoundationRendererObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaFoundationRendererObserver, associatedInterfacePtrInfo);
  }

  MediaFoundationRendererObserverAssociatedPtr.prototype =
      Object.create(MediaFoundationRendererObserverPtr.prototype);
  MediaFoundationRendererObserverAssociatedPtr.prototype.constructor =
      MediaFoundationRendererObserverAssociatedPtr;

  function MediaFoundationRendererObserverProxy(receiver) {
    this.receiver_ = receiver;
  }

  function MediaFoundationRendererObserverStub(delegate) {
    this.delegate_ = delegate;
  }

  MediaFoundationRendererObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  MediaFoundationRendererObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaFoundationRendererObserverRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateMediaFoundationRendererObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaFoundationRendererObserver = {
    name: 'media.mojom.MediaFoundationRendererObserver',
    kVersion: 0,
    ptrClass: MediaFoundationRendererObserverPtr,
    proxyClass: MediaFoundationRendererObserverProxy,
    stubClass: MediaFoundationRendererObserverStub,
    validateRequest: validateMediaFoundationRendererObserverRequest,
    validateResponse: null,
  };
  MediaFoundationRendererObserverStub.prototype.validator = validateMediaFoundationRendererObserverRequest;
  MediaFoundationRendererObserverProxy.prototype.validator = null;
  var kMediaFoundationRendererNotifier_MediaFoundationRendererCreated_Name = 0;

  function MediaFoundationRendererNotifierPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaFoundationRendererNotifier,
                                                   handleOrPtrInfo);
  }

  function MediaFoundationRendererNotifierAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaFoundationRendererNotifier, associatedInterfacePtrInfo);
  }

  MediaFoundationRendererNotifierAssociatedPtr.prototype =
      Object.create(MediaFoundationRendererNotifierPtr.prototype);
  MediaFoundationRendererNotifierAssociatedPtr.prototype.constructor =
      MediaFoundationRendererNotifierAssociatedPtr;

  function MediaFoundationRendererNotifierProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaFoundationRendererNotifierPtr.prototype.mediaFoundationRendererCreated = function() {
    return MediaFoundationRendererNotifierProxy.prototype.mediaFoundationRendererCreated
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaFoundationRendererNotifierProxy.prototype.mediaFoundationRendererCreated = function(observer) {
    var params_ = new MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kMediaFoundationRendererNotifier_MediaFoundationRendererCreated_Name,
        codec.align(MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params.encodedSize));
    builder.encodeStruct(MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaFoundationRendererNotifierStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaFoundationRendererNotifierStub.prototype.mediaFoundationRendererCreated = function(observer) {
    return this.delegate_ && this.delegate_.mediaFoundationRendererCreated && this.delegate_.mediaFoundationRendererCreated(observer);
  }

  MediaFoundationRendererNotifierStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaFoundationRendererNotifier_MediaFoundationRendererCreated_Name:
      var params = reader.decodeStruct(MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params);
      this.mediaFoundationRendererCreated(params.observer);
      return true;
    default:
      return false;
    }
  };

  MediaFoundationRendererNotifierStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaFoundationRendererNotifierRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaFoundationRendererNotifier_MediaFoundationRendererCreated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaFoundationRendererNotifierResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaFoundationRendererNotifier = {
    name: 'media.mojom.MediaFoundationRendererNotifier',
    kVersion: 0,
    ptrClass: MediaFoundationRendererNotifierPtr,
    proxyClass: MediaFoundationRendererNotifierProxy,
    stubClass: MediaFoundationRendererNotifierStub,
    validateRequest: validateMediaFoundationRendererNotifierRequest,
    validateResponse: null,
  };
  MediaFoundationRendererNotifierStub.prototype.validator = validateMediaFoundationRendererNotifierRequest;
  MediaFoundationRendererNotifierProxy.prototype.validator = null;
  exports.MediaFoundationRenderingMode = MediaFoundationRenderingMode;
  exports.FlingingRendererClientExtension = FlingingRendererClientExtension;
  exports.FlingingRendererClientExtensionPtr = FlingingRendererClientExtensionPtr;
  exports.FlingingRendererClientExtensionAssociatedPtr = FlingingRendererClientExtensionAssociatedPtr;
  exports.MediaFoundationRendererObserver = MediaFoundationRendererObserver;
  exports.MediaFoundationRendererObserverPtr = MediaFoundationRendererObserverPtr;
  exports.MediaFoundationRendererObserverAssociatedPtr = MediaFoundationRendererObserverAssociatedPtr;
  exports.MediaFoundationRendererNotifier = MediaFoundationRendererNotifier;
  exports.MediaFoundationRendererNotifierPtr = MediaFoundationRendererNotifierPtr;
  exports.MediaFoundationRendererNotifierAssociatedPtr = MediaFoundationRendererNotifierAssociatedPtr;
})();