// media/mojo/mojom/renderer.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('media.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.RendererPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.Renderer.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.RendererInterface }
 */
media.mojom.RendererRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.RendererPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.RendererPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.RendererPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @param { ?Array<!media.mojom.DemuxerStreamRemote> } streams
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initialize(
      client,
      streams) {
    return this.proxy.sendMessage(
        0,
        media.mojom.Renderer_Initialize_ParamsSpec.$,
        media.mojom.Renderer_Initialize_ResponseParamsSpec.$,
        [
          client,
          streams
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flush() {
    return this.proxy.sendMessage(
        1,
        media.mojom.Renderer_Flush_ParamsSpec.$,
        media.mojom.Renderer_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } time
   */

  startPlayingFrom(
      time) {
    this.proxy.sendMessage(
        2,
        media.mojom.Renderer_StartPlayingFrom_ParamsSpec.$,
        null,
        [
          time
        ],
        false);
  }

  
  /**
   * @param { !number } playbackRate
   */

  setPlaybackRate(
      playbackRate) {
    this.proxy.sendMessage(
        3,
        media.mojom.Renderer_SetPlaybackRate_ParamsSpec.$,
        null,
        [
          playbackRate
        ],
        false);
  }

  
  /**
   * @param { !number } volume
   */

  setVolume(
      volume) {
    this.proxy.sendMessage(
        4,
        media.mojom.Renderer_SetVolume_ParamsSpec.$,
        null,
        [
          volume
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.UnguessableToken } cdmId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setCdm(
      cdmId) {
    return this.proxy.sendMessage(
        5,
        media.mojom.Renderer_SetCdm_ParamsSpec.$,
        media.mojom.Renderer_SetCdm_ResponseParamsSpec.$,
        [
          cdmId
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.TimeDelta } latencyHint
   */

  setLatencyHint(
      latencyHint) {
    this.proxy.sendMessage(
        6,
        media.mojom.Renderer_SetLatencyHint_ParamsSpec.$,
        null,
        [
          latencyHint
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Renderer
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.RendererReceiver = class {
  /**
   * @param {!media.mojom.RendererInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.RendererRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.Renderer_Initialize_ParamsSpec.$,
        media.mojom.Renderer_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.Renderer_Flush_ParamsSpec.$,
        media.mojom.Renderer_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.Renderer_StartPlayingFrom_ParamsSpec.$,
        null,
        impl.startPlayingFrom.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.Renderer_SetPlaybackRate_ParamsSpec.$,
        null,
        impl.setPlaybackRate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.Renderer_SetVolume_ParamsSpec.$,
        null,
        impl.setVolume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.Renderer_SetCdm_ParamsSpec.$,
        media.mojom.Renderer_SetCdm_ResponseParamsSpec.$,
        impl.setCdm.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.Renderer_SetLatencyHint_ParamsSpec.$,
        null,
        impl.setLatencyHint.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.Renderer = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.Renderer";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.RendererRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.RendererRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Renderer
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.RendererCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.RendererRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.RendererRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.Renderer_Initialize_ParamsSpec.$,
        media.mojom.Renderer_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.Renderer_Flush_ParamsSpec.$,
        media.mojom.Renderer_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startPlayingFrom =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.Renderer_StartPlayingFrom_ParamsSpec.$,
        null,
        this.startPlayingFrom.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPlaybackRate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.Renderer_SetPlaybackRate_ParamsSpec.$,
        null,
        this.setPlaybackRate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVolume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.Renderer_SetVolume_ParamsSpec.$,
        null,
        this.setVolume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCdm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.Renderer_SetCdm_ParamsSpec.$,
        media.mojom.Renderer_SetCdm_ResponseParamsSpec.$,
        this.setCdm.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLatencyHint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.Renderer_SetLatencyHint_ParamsSpec.$,
        null,
        this.setLatencyHint.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.RendererClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.RendererClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { media.mojom.RendererClientInterface }
 */
media.mojom.RendererClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.RendererClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.RendererClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.RendererClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } time
   * @param { !mojoBase.mojom.TimeDelta } maxTime
   * @param { !mojoBase.mojom.TimeTicks } captureTime
   */

  onTimeUpdate(
      time,
      maxTime,
      captureTime) {
    this.proxy.sendMessage(
        0,
        media.mojom.RendererClient_OnTimeUpdate_ParamsSpec.$,
        null,
        [
          time,
          maxTime,
          captureTime
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.BufferingState } state
   * @param { !media.mojom.BufferingStateChangeReason } reason
   */

  onBufferingStateChange(
      state,
      reason) {
    this.proxy.sendMessage(
        1,
        media.mojom.RendererClient_OnBufferingStateChange_ParamsSpec.$,
        null,
        [
          state,
          reason
        ],
        false);
  }

  
  /**
   */

  onEnded() {
    this.proxy.sendMessage(
        2,
        media.mojom.RendererClient_OnEnded_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatus } status
   */

  onError(
      status) {
    this.proxy.sendMessage(
        3,
        media.mojom.RendererClient_OnError_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioDecoderConfig } config
   */

  onAudioConfigChange(
      config) {
    this.proxy.sendMessage(
        4,
        media.mojom.RendererClient_OnAudioConfigChange_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoDecoderConfig } config
   */

  onVideoConfigChange(
      config) {
    this.proxy.sendMessage(
        5,
        media.mojom.RendererClient_OnVideoConfigChange_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Size } size
   */

  onVideoNaturalSizeChange(
      size) {
    this.proxy.sendMessage(
        6,
        media.mojom.RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
        null,
        [
          size
        ],
        false);
  }

  
  /**
   * @param { !boolean } opaque
   */

  onVideoOpacityChange(
      opaque) {
    this.proxy.sendMessage(
        7,
        media.mojom.RendererClient_OnVideoOpacityChange_ParamsSpec.$,
        null,
        [
          opaque
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.PipelineStatistics } stats
   */

  onStatisticsUpdate(
      stats) {
    this.proxy.sendMessage(
        8,
        media.mojom.RendererClient_OnStatisticsUpdate_ParamsSpec.$,
        null,
        [
          stats
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.WaitingReason } reason
   */

  onWaiting(
      reason) {
    this.proxy.sendMessage(
        9,
        media.mojom.RendererClient_OnWaiting_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RendererClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.RendererClientReceiver = class {
  /**
   * @param {!media.mojom.RendererClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.RendererClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.RendererClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.RendererClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.RendererClient_OnTimeUpdate_ParamsSpec.$,
        null,
        impl.onTimeUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.RendererClient_OnBufferingStateChange_ParamsSpec.$,
        null,
        impl.onBufferingStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.RendererClient_OnEnded_ParamsSpec.$,
        null,
        impl.onEnded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.RendererClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.RendererClient_OnAudioConfigChange_ParamsSpec.$,
        null,
        impl.onAudioConfigChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.RendererClient_OnVideoConfigChange_ParamsSpec.$,
        null,
        impl.onVideoConfigChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
        null,
        impl.onVideoNaturalSizeChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.RendererClient_OnVideoOpacityChange_ParamsSpec.$,
        null,
        impl.onVideoOpacityChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        media.mojom.RendererClient_OnStatisticsUpdate_ParamsSpec.$,
        null,
        impl.onStatisticsUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        media.mojom.RendererClient_OnWaiting_ParamsSpec.$,
        null,
        impl.onWaiting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.RendererClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.RendererClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.RendererClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.RendererClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RendererClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.RendererClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.RendererClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.RendererClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTimeUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.RendererClient_OnTimeUpdate_ParamsSpec.$,
        null,
        this.onTimeUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferingStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.RendererClient_OnBufferingStateChange_ParamsSpec.$,
        null,
        this.onBufferingStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.RendererClient_OnEnded_ParamsSpec.$,
        null,
        this.onEnded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.RendererClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAudioConfigChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.RendererClient_OnAudioConfigChange_ParamsSpec.$,
        null,
        this.onAudioConfigChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoConfigChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.RendererClient_OnVideoConfigChange_ParamsSpec.$,
        null,
        this.onVideoConfigChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoNaturalSizeChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
        null,
        this.onVideoNaturalSizeChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVideoOpacityChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.RendererClient_OnVideoOpacityChange_ParamsSpec.$,
        null,
        this.onVideoOpacityChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStatisticsUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        media.mojom.RendererClient_OnStatisticsUpdate_ParamsSpec.$,
        null,
        this.onStatisticsUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWaiting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        media.mojom.RendererClient_OnWaiting_ParamsSpec.$,
        null,
        this.onWaiting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_StartPlayingFrom_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_SetPlaybackRate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_SetVolume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_SetCdm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_SetCdm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Renderer_SetLatencyHint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnTimeUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnBufferingStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnEnded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnAudioConfigChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnVideoConfigChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnVideoNaturalSizeChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnVideoOpacityChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnStatisticsUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.RendererClient_OnWaiting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.Renderer_Initialize_ParamsSpec.$,
    'Renderer_Initialize_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.RendererClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streams', 8,
        0,
        mojo.internal.Array(mojo.internal.InterfaceProxy(media.mojom.DemuxerStreamRemote), false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
media.mojom.Renderer_Initialize_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
    /** @export { (Array<!media.mojom.DemuxerStreamRemote>|undefined) } */
    this.streams;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_Initialize_ResponseParamsSpec.$,
    'Renderer_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_Flush_ParamsSpec.$,
    'Renderer_Flush_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.Renderer_Flush_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_Flush_ResponseParamsSpec.$,
    'Renderer_Flush_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.Renderer_Flush_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_StartPlayingFrom_ParamsSpec.$,
    'Renderer_StartPlayingFrom_Params',
    [
      mojo.internal.StructField(
        'time', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_StartPlayingFrom_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.time;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_SetPlaybackRate_ParamsSpec.$,
    'Renderer_SetPlaybackRate_Params',
    [
      mojo.internal.StructField(
        'playbackRate', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_SetPlaybackRate_Params = class {
  constructor() {
    /** @export { !number } */
    this.playbackRate;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_SetVolume_ParamsSpec.$,
    'Renderer_SetVolume_Params',
    [
      mojo.internal.StructField(
        'volume', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_SetVolume_Params = class {
  constructor() {
    /** @export { !number } */
    this.volume;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_SetCdm_ParamsSpec.$,
    'Renderer_SetCdm_Params',
    [
      mojo.internal.StructField(
        'cdmId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_SetCdm_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.cdmId;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_SetCdm_ResponseParamsSpec.$,
    'Renderer_SetCdm_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_SetCdm_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    media.mojom.Renderer_SetLatencyHint_ParamsSpec.$,
    'Renderer_SetLatencyHint_Params',
    [
      mojo.internal.StructField(
        'latencyHint', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.Renderer_SetLatencyHint_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.TimeDelta|undefined) } */
    this.latencyHint;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnTimeUpdate_ParamsSpec.$,
    'RendererClient_OnTimeUpdate_Params',
    [
      mojo.internal.StructField(
        'time', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxTime', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'captureTime', 16,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
media.mojom.RendererClient_OnTimeUpdate_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.time;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.maxTime;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.captureTime;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnBufferingStateChange_ParamsSpec.$,
    'RendererClient_OnBufferingStateChange_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        media.mojom.BufferingStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        media.mojom.BufferingStateChangeReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnBufferingStateChange_Params = class {
  constructor() {
    /** @export { !media.mojom.BufferingState } */
    this.state;
    /** @export { !media.mojom.BufferingStateChangeReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnEnded_ParamsSpec.$,
    'RendererClient_OnEnded_Params',
    [
    ],
    [[0, 8],]);





/** @record */
media.mojom.RendererClient_OnEnded_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnError_ParamsSpec.$,
    'RendererClient_OnError_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.PipelineStatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnError_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnAudioConfigChange_ParamsSpec.$,
    'RendererClient_OnAudioConfigChange_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.AudioDecoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnAudioConfigChange_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioDecoderConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnVideoConfigChange_ParamsSpec.$,
    'RendererClient_OnVideoConfigChange_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.VideoDecoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnVideoConfigChange_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoDecoderConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnVideoNaturalSizeChange_ParamsSpec.$,
    'RendererClient_OnVideoNaturalSizeChange_Params',
    [
      mojo.internal.StructField(
        'size', 0,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnVideoNaturalSizeChange_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Size } */
    this.size;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnVideoOpacityChange_ParamsSpec.$,
    'RendererClient_OnVideoOpacityChange_Params',
    [
      mojo.internal.StructField(
        'opaque', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnVideoOpacityChange_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.opaque;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnStatisticsUpdate_ParamsSpec.$,
    'RendererClient_OnStatisticsUpdate_Params',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        media.mojom.PipelineStatisticsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnStatisticsUpdate_Params = class {
  constructor() {
    /** @export { !media.mojom.PipelineStatistics } */
    this.stats;
  }
};



mojo.internal.Struct(
    media.mojom.RendererClient_OnWaiting_ParamsSpec.$,
    'RendererClient_OnWaiting_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media.mojom.WaitingReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
media.mojom.RendererClient_OnWaiting_Params = class {
  constructor() {
    /** @export { !media.mojom.WaitingReason } */
    this.reason;
  }
};

