// media/mojo/mojom/renderer.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_TEST_UTILS_H_

#include "media/mojo/mojom/renderer.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace media::mojom::blink {


class BLINK_PLATFORM_EXPORT RendererInterceptorForTesting : public Renderer {
  virtual Renderer* GetForwardingInterface() = 0;
  void Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<::blink::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams, InitializeCallback callback) override;
  void Flush(FlushCallback callback) override;
  void StartPlayingFrom(::base::TimeDelta time) override;
  void SetPlaybackRate(double playback_rate) override;
  void SetVolume(float volume) override;
  void SetCdm(const std::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) override;
  void SetLatencyHint(std::optional<::base::TimeDelta> latency_hint) override;
};
class BLINK_PLATFORM_EXPORT RendererAsyncWaiter {
 public:
  explicit RendererAsyncWaiter(Renderer* proxy);

  RendererAsyncWaiter(const RendererAsyncWaiter&) = delete;
  RendererAsyncWaiter& operator=(const RendererAsyncWaiter&) = delete;

  ~RendererAsyncWaiter();
  void Initialize(
      ::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<::blink::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams, bool* out_success);
  bool Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, std::optional<::blink::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams);
  void Flush(
      );
  
  void SetCdm(
      const std::optional<::base::UnguessableToken>& cdm_id, bool* out_success);
  bool SetCdm(const std::optional<::base::UnguessableToken>& cdm_id);

 private:
  Renderer* const proxy_;
};


class BLINK_PLATFORM_EXPORT RendererClientInterceptorForTesting : public RendererClient {
  virtual RendererClient* GetForwardingInterface() = 0;
  void OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) override;
  void OnBufferingStateChange(::media::mojom::blink::BufferingState state, ::media::mojom::blink::BufferingStateChangeReason reason) override;
  void OnEnded() override;
  void OnError(const ::media::PipelineStatus& status) override;
  void OnAudioConfigChange(::media::mojom::blink::AudioDecoderConfigPtr config) override;
  void OnVideoConfigChange(::media::mojom::blink::VideoDecoderConfigPtr config) override;
  void OnVideoNaturalSizeChange(const ::gfx::Size& size) override;
  void OnVideoOpacityChange(bool opaque) override;
  void OnStatisticsUpdate(const ::media::PipelineStatistics& stats) override;
  void OnWaiting(::media::mojom::blink::WaitingReason reason) override;
};
class BLINK_PLATFORM_EXPORT RendererClientAsyncWaiter {
 public:
  explicit RendererClientAsyncWaiter(RendererClient* proxy);

  RendererClientAsyncWaiter(const RendererClientAsyncWaiter&) = delete;
  RendererClientAsyncWaiter& operator=(const RendererClientAsyncWaiter&) = delete;

  ~RendererClientAsyncWaiter();

 private:
  RendererClient* const proxy_;
};




}  // media::mojom::blink

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_TEST_UTILS_H_