// media/mojo/mojom/media_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_types.mojom-params-data.h"
#include "media/mojo/mojom/media_types.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_types.mojom-import-headers.h"
#include "media/mojo/mojom/media_types.mojom-test-utils.h"
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"


namespace media::mojom {
VideoTransformation::VideoTransformation()
    : rotation(),
      mirrored() {}

VideoTransformation::VideoTransformation(
    ::media::VideoRotation rotation_in,
    bool mirrored_in)
    : rotation(std::move(rotation_in)),
      mirrored(std::move(mirrored_in)) {}

VideoTransformation::~VideoTransformation() = default;

void VideoTransformation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation"), this->rotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoRotation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mirrored"), this->mirrored,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoTransformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoAspectRatio::VideoAspectRatio()
    : type(),
      value() {}

VideoAspectRatio::VideoAspectRatio(
    VideoAspectRatio::Type type_in,
    double value_in)
    : type(std::move(type_in)),
      value(std::move(value_in)) {}

VideoAspectRatio::~VideoAspectRatio() = default;

void VideoAspectRatio::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoAspectRatio::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoAspectRatio::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoColorSpace::VideoColorSpace()
    : primaries(),
      transfer(),
      matrix(),
      range() {}

VideoColorSpace::VideoColorSpace(
    ::media::VideoColorSpace::PrimaryID primaries_in,
    ::media::VideoColorSpace::TransferID transfer_in,
    ::media::VideoColorSpace::MatrixID matrix_in,
    ::gfx::ColorSpace::RangeID range_in)
    : primaries(std::move(primaries_in)),
      transfer(std::move(transfer_in)),
      matrix(std::move(matrix_in)),
      range(std::move(range_in)) {}

VideoColorSpace::~VideoColorSpace() = default;

void VideoColorSpace::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primaries"), this->primaries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoColorSpace::PrimaryID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer"), this->transfer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoColorSpace::TransferID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matrix"), this->matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoColorSpace::MatrixID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "range"), this->range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ColorSpace::RangeID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoColorSpace::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioDecoderConfig::AudioDecoderConfig()
    : codec(),
      sample_format(),
      channel_layout(),
      samples_per_second(),
      extra_data(),
      encryption_scheme(),
      seek_preroll(),
      codec_delay(),
      profile(),
      target_output_channel_layout(),
      target_output_sample_format(),
      should_discard_decoder_delay() {}

AudioDecoderConfig::AudioDecoderConfig(
    ::media::AudioCodec codec_in,
    ::media::SampleFormat sample_format_in,
    ::media::ChannelLayout channel_layout_in,
    int32_t samples_per_second_in,
    std::vector<uint8_t> extra_data_in,
    ::media::EncryptionScheme encryption_scheme_in,
    ::base::TimeDelta seek_preroll_in,
    int32_t codec_delay_in,
    ::media::AudioCodecProfile profile_in,
    ::media::ChannelLayout target_output_channel_layout_in,
    ::media::SampleFormat target_output_sample_format_in,
    bool should_discard_decoder_delay_in)
    : codec(std::move(codec_in)),
      sample_format(std::move(sample_format_in)),
      channel_layout(std::move(channel_layout_in)),
      samples_per_second(std::move(samples_per_second_in)),
      extra_data(std::move(extra_data_in)),
      encryption_scheme(std::move(encryption_scheme_in)),
      seek_preroll(std::move(seek_preroll_in)),
      codec_delay(std::move(codec_delay_in)),
      profile(std::move(profile_in)),
      target_output_channel_layout(std::move(target_output_channel_layout_in)),
      target_output_sample_format(std::move(target_output_sample_format_in)),
      should_discard_decoder_delay(std::move(should_discard_decoder_delay_in)) {}

AudioDecoderConfig::~AudioDecoderConfig() = default;

void AudioDecoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_format"), this->sample_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::SampleFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_layout"), this->channel_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ChannelLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samples_per_second"), this->samples_per_second,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seek_preroll"), this->seek_preroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec_delay"), this->codec_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_output_channel_layout"), this->target_output_channel_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ChannelLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_output_sample_format"), this->target_output_sample_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::SampleFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_discard_decoder_delay"), this->should_discard_decoder_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecoderConfig::VideoDecoderConfig()
    : codec(),
      profile(),
      level(),
      has_alpha(),
      transformation(),
      coded_size(),
      visible_rect(),
      natural_size(),
      aspect_ratio(),
      extra_data(),
      encryption_scheme(),
      color_space_info(),
      hdr_metadata() {}

VideoDecoderConfig::VideoDecoderConfig(
    ::media::VideoCodec codec_in,
    ::media::VideoCodecProfile profile_in,
    uint32_t level_in,
    bool has_alpha_in,
    const ::media::VideoTransformation& transformation_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    const ::media::VideoAspectRatio& aspect_ratio_in,
    std::vector<uint8_t> extra_data_in,
    ::media::EncryptionScheme encryption_scheme_in,
    const ::media::VideoColorSpace& color_space_info_in,
    const std::optional<::gfx::HDRMetadata>& hdr_metadata_in)
    : codec(std::move(codec_in)),
      profile(std::move(profile_in)),
      level(std::move(level_in)),
      has_alpha(std::move(has_alpha_in)),
      transformation(std::move(transformation_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      aspect_ratio(std::move(aspect_ratio_in)),
      extra_data(std::move(extra_data_in)),
      encryption_scheme(std::move(encryption_scheme_in)),
      color_space_info(std::move(color_space_info_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoDecoderConfig::~VideoDecoderConfig() = default;

void VideoDecoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level"), this->level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_alpha"), this->has_alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transformation"), this->transformation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoTransformation&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aspect_ratio"), this->aspect_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoAspectRatio&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space_info"), this->color_space_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::HDRMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecryptConfig::DecryptConfig()
    : encryption_scheme(),
      key_id(),
      iv(),
      subsamples(),
      encryption_pattern() {}

DecryptConfig::DecryptConfig(
    ::media::EncryptionScheme encryption_scheme_in,
    const std::string& key_id_in,
    const std::string& iv_in,
    std::vector<::media::SubsampleEntry> subsamples_in,
    const std::optional<::media::EncryptionPattern>& encryption_pattern_in)
    : encryption_scheme(std::move(encryption_scheme_in)),
      key_id(std::move(key_id_in)),
      iv(std::move(iv_in)),
      subsamples(std::move(subsamples_in)),
      encryption_pattern(std::move(encryption_pattern_in)) {}

DecryptConfig::~DecryptConfig() = default;

void DecryptConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iv"), this->iv,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsamples"), this->subsamples,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::SubsampleEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_pattern"), this->encryption_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::EncryptionPattern>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecryptConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderBufferSideData::DecoderBufferSideData()
    : spatial_layers(),
      alpha_data(),
      secure_handle(),
      front_discard(),
      back_discard() {}

DecoderBufferSideData::DecoderBufferSideData(
    std::vector<uint32_t> spatial_layers_in,
    std::vector<uint8_t> alpha_data_in,
    uint64_t secure_handle_in,
    ::base::TimeDelta front_discard_in,
    ::base::TimeDelta back_discard_in)
    : spatial_layers(std::move(spatial_layers_in)),
      alpha_data(std::move(alpha_data_in)),
      secure_handle(std::move(secure_handle_in)),
      front_discard(std::move(front_discard_in)),
      back_discard(std::move(back_discard_in)) {}

DecoderBufferSideData::~DecoderBufferSideData() = default;

void DecoderBufferSideData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_layers"), this->spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_data"), this->alpha_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_handle"), this->secure_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "front_discard"), this->front_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_discard"), this->back_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecoderBufferSideData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataDecoderBuffer::DataDecoderBuffer()
    : timestamp(),
      duration(),
      data_size(),
      is_key_frame(),
      decrypt_config(),
      side_data() {}

DataDecoderBuffer::DataDecoderBuffer(
    ::base::TimeDelta timestamp_in,
    ::base::TimeDelta duration_in,
    uint32_t data_size_in,
    bool is_key_frame_in,
    DecryptConfigPtr decrypt_config_in,
    DecoderBufferSideDataPtr side_data_in)
    : timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)),
      data_size(std::move(data_size_in)),
      is_key_frame(std::move(is_key_frame_in)),
      decrypt_config(std::move(decrypt_config_in)),
      side_data(std::move(side_data_in)) {}

DataDecoderBuffer::~DataDecoderBuffer() = default;

void DataDecoderBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_size"), this->data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_key_frame"), this->is_key_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decrypt_config"), this->decrypt_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DecryptConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "side_data"), this->side_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DecoderBufferSideDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataDecoderBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EosDecoderBuffer::EosDecoderBuffer()
    : next_config() {}

EosDecoderBuffer::EosDecoderBuffer(
    DecoderBufferSideDataNextConfigPtr next_config_in)
    : next_config(std::move(next_config_in)) {}

EosDecoderBuffer::~EosDecoderBuffer() = default;

void EosDecoderBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "next_config"), this->next_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DecoderBufferSideDataNextConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EosDecoderBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioBuffer::AudioBuffer()
    : sample_format(),
      channel_layout(),
      channel_count(),
      sample_rate(),
      frame_count(),
      end_of_stream(),
      timestamp(),
      data() {}

AudioBuffer::AudioBuffer(
    ::media::SampleFormat sample_format_in,
    ::media::ChannelLayout channel_layout_in,
    int32_t channel_count_in,
    int32_t sample_rate_in,
    int32_t frame_count_in,
    bool end_of_stream_in,
    ::base::TimeDelta timestamp_in,
    std::vector<uint8_t> data_in)
    : sample_format(std::move(sample_format_in)),
      channel_layout(std::move(channel_layout_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      frame_count(std::move(frame_count_in)),
      end_of_stream(std::move(end_of_stream_in)),
      timestamp(std::move(timestamp_in)),
      data(std::move(data_in)) {}

AudioBuffer::~AudioBuffer() = default;

void AudioBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_format"), this->sample_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::SampleFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_layout"), this->channel_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ChannelLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_count"), this->frame_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_stream"), this->end_of_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CaptureVersion::CaptureVersion()
    : source(),
      sub_capture() {}

CaptureVersion::CaptureVersion(
    uint32_t source_in,
    uint32_t sub_capture_in)
    : source(std::move(source_in)),
      sub_capture(std::move(sub_capture_in)) {}

CaptureVersion::~CaptureVersion() = default;

void CaptureVersion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sub_capture"), this->sub_capture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CaptureVersion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameMetadata::VideoFrameMetadata()
    : allow_overlay(),
      capture_begin_time(),
      capture_end_time(),
      has_capture_counter(),
      capture_counter(),
      capture_update_rect(),
      source_size(),
      region_capture_rect(),
      capture_version(),
      copy_required(),
      end_of_stream(),
      frame_duration(),
      has_frame_rate(),
      frame_rate(),
      interactive_content(),
      reference_time(),
      read_lock_fences_enabled(),
      transformation(),
      in_surface_view(),
      wants_promotion_hint(),
      protected_video(),
      hw_protected(),
      needs_detiling(),
      is_webgpu_compatible(),
      tracking_token(),
      power_efficient(),
      has_device_scale_factor(),
      device_scale_factor(),
      has_page_scale_factor(),
      page_scale_factor(),
      has_root_scroll_offset_x(),
      root_scroll_offset_x(),
      has_root_scroll_offset_y(),
      root_scroll_offset_y(),
      has_top_controls_visible_height(),
      top_controls_visible_height(),
      decode_begin_time(),
      decode_end_time(),
      processing_time(),
      has_rtp_timestamp(),
      rtp_timestamp(),
      receive_time(),
      wallclock_frame_duration(),
      frame_sequence(),
      source_id(),
      background_blur() {}

VideoFrameMetadata::VideoFrameMetadata(
    bool allow_overlay_in,
    std::optional<::base::TimeTicks> capture_begin_time_in,
    std::optional<::base::TimeTicks> capture_end_time_in,
    bool has_capture_counter_in,
    int32_t capture_counter_in,
    const std::optional<::gfx::Rect>& capture_update_rect_in,
    const std::optional<::gfx::Size>& source_size_in,
    const std::optional<::gfx::Rect>& region_capture_rect_in,
    const ::media::CaptureVersion& capture_version_in,
    bool copy_required_in,
    bool end_of_stream_in,
    std::optional<::base::TimeDelta> frame_duration_in,
    bool has_frame_rate_in,
    double frame_rate_in,
    bool interactive_content_in,
    std::optional<::base::TimeTicks> reference_time_in,
    bool read_lock_fences_enabled_in,
    const std::optional<::media::VideoTransformation>& transformation_in,
    bool in_surface_view_in,
    bool wants_promotion_hint_in,
    bool protected_video_in,
    bool hw_protected_in,
    bool needs_detiling_in,
    bool is_webgpu_compatible_in,
    const std::optional<::base::UnguessableToken>& tracking_token_in,
    bool power_efficient_in,
    bool has_device_scale_factor_in,
    double device_scale_factor_in,
    bool has_page_scale_factor_in,
    double page_scale_factor_in,
    bool has_root_scroll_offset_x_in,
    double root_scroll_offset_x_in,
    bool has_root_scroll_offset_y_in,
    double root_scroll_offset_y_in,
    bool has_top_controls_visible_height_in,
    double top_controls_visible_height_in,
    std::optional<::base::TimeTicks> decode_begin_time_in,
    std::optional<::base::TimeTicks> decode_end_time_in,
    std::optional<::base::TimeDelta> processing_time_in,
    bool has_rtp_timestamp_in,
    double rtp_timestamp_in,
    std::optional<::base::TimeTicks> receive_time_in,
    std::optional<::base::TimeDelta> wallclock_frame_duration_in,
    std::optional<uint64_t> frame_sequence_in,
    std::optional<uint64_t> source_id_in,
    EffectState background_blur_in)
    : allow_overlay(std::move(allow_overlay_in)),
      capture_begin_time(std::move(capture_begin_time_in)),
      capture_end_time(std::move(capture_end_time_in)),
      has_capture_counter(std::move(has_capture_counter_in)),
      capture_counter(std::move(capture_counter_in)),
      capture_update_rect(std::move(capture_update_rect_in)),
      source_size(std::move(source_size_in)),
      region_capture_rect(std::move(region_capture_rect_in)),
      capture_version(std::move(capture_version_in)),
      copy_required(std::move(copy_required_in)),
      end_of_stream(std::move(end_of_stream_in)),
      frame_duration(std::move(frame_duration_in)),
      has_frame_rate(std::move(has_frame_rate_in)),
      frame_rate(std::move(frame_rate_in)),
      interactive_content(std::move(interactive_content_in)),
      reference_time(std::move(reference_time_in)),
      read_lock_fences_enabled(std::move(read_lock_fences_enabled_in)),
      transformation(std::move(transformation_in)),
      in_surface_view(std::move(in_surface_view_in)),
      wants_promotion_hint(std::move(wants_promotion_hint_in)),
      protected_video(std::move(protected_video_in)),
      hw_protected(std::move(hw_protected_in)),
      needs_detiling(std::move(needs_detiling_in)),
      is_webgpu_compatible(std::move(is_webgpu_compatible_in)),
      tracking_token(std::move(tracking_token_in)),
      power_efficient(std::move(power_efficient_in)),
      has_device_scale_factor(std::move(has_device_scale_factor_in)),
      device_scale_factor(std::move(device_scale_factor_in)),
      has_page_scale_factor(std::move(has_page_scale_factor_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      has_root_scroll_offset_x(std::move(has_root_scroll_offset_x_in)),
      root_scroll_offset_x(std::move(root_scroll_offset_x_in)),
      has_root_scroll_offset_y(std::move(has_root_scroll_offset_y_in)),
      root_scroll_offset_y(std::move(root_scroll_offset_y_in)),
      has_top_controls_visible_height(std::move(has_top_controls_visible_height_in)),
      top_controls_visible_height(std::move(top_controls_visible_height_in)),
      decode_begin_time(std::move(decode_begin_time_in)),
      decode_end_time(std::move(decode_end_time_in)),
      processing_time(std::move(processing_time_in)),
      has_rtp_timestamp(std::move(has_rtp_timestamp_in)),
      rtp_timestamp(std::move(rtp_timestamp_in)),
      receive_time(std::move(receive_time_in)),
      wallclock_frame_duration(std::move(wallclock_frame_duration_in)),
      frame_sequence(std::move(frame_sequence_in)),
      source_id(std::move(source_id_in)),
      background_blur(std::move(background_blur_in)) {}

VideoFrameMetadata::~VideoFrameMetadata() = default;

void VideoFrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_overlay"), this->allow_overlay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_begin_time"), this->capture_begin_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_end_time"), this->capture_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_capture_counter"), this->has_capture_counter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_counter"), this->capture_counter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_update_rect"), this->capture_update_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_size"), this->source_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "region_capture_rect"), this->region_capture_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_version"), this->capture_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::CaptureVersion&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copy_required"), this->copy_required,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "end_of_stream"), this->end_of_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_duration"), this->frame_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_frame_rate"), this->has_frame_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_rate"), this->frame_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interactive_content"), this->interactive_content,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference_time"), this->reference_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_lock_fences_enabled"), this->read_lock_fences_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transformation"), this->transformation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::VideoTransformation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_surface_view"), this->in_surface_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wants_promotion_hint"), this->wants_promotion_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_video"), this->protected_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_protected"), this->hw_protected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_detiling"), this->needs_detiling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_webgpu_compatible"), this->is_webgpu_compatible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tracking_token"), this->tracking_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "power_efficient"), this->power_efficient,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_device_scale_factor"), this->has_device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scale_factor"), this->device_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_page_scale_factor"), this->has_page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "page_scale_factor"), this->page_scale_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_root_scroll_offset_x"), this->has_root_scroll_offset_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset_x"), this->root_scroll_offset_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_root_scroll_offset_y"), this->has_root_scroll_offset_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_scroll_offset_y"), this->root_scroll_offset_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_top_controls_visible_height"), this->has_top_controls_visible_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_controls_visible_height"), this->top_controls_visible_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decode_begin_time"), this->decode_begin_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decode_end_time"), this->decode_end_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "processing_time"), this->processing_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_rtp_timestamp"), this->has_rtp_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtp_timestamp"), this->rtp_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receive_time"), this->receive_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeTicks>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wallclock_frame_duration"), this->wallclock_frame_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sequence"), this->frame_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_blur"), this->background_blur,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EffectState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrame::VideoFrame()
    : format(),
      coded_size(),
      visible_rect(),
      natural_size(),
      timestamp(),
      data(),
      metadata(),
      color_space(),
      hdr_metadata() {}

VideoFrame::VideoFrame(
    ::media::VideoPixelFormat format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    ::base::TimeDelta timestamp_in,
    VideoFrameDataPtr data_in,
    const ::media::VideoFrameMetadata& metadata_in,
    const ::gfx::ColorSpace& color_space_in,
    const std::optional<::gfx::HDRMetadata>& hdr_metadata_in)
    : format(std::move(format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      timestamp(std::move(timestamp_in)),
      data(std::move(data_in)),
      metadata(std::move(metadata_in)),
      color_space(std::move(color_space_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoFrame::~VideoFrame() = default;

void VideoFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoFrameDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoFrameMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::HDRMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EosVideoFrameData::EosVideoFrameData() {}

EosVideoFrameData::~EosVideoFrameData() = default;
size_t EosVideoFrameData::Hash(size_t seed) const {
  return seed;
}

void EosVideoFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool EosVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedMemoryVideoFrameData::SharedMemoryVideoFrameData()
    : frame_data(),
      strides(),
      offsets() {}

SharedMemoryVideoFrameData::SharedMemoryVideoFrameData(
    ::base::ReadOnlySharedMemoryRegion frame_data_in,
    std::vector<int32_t> strides_in,
    std::vector<uint32_t> offsets_in)
    : frame_data(std::move(frame_data_in)),
      strides(std::move(strides_in)),
      offsets(std::move(offsets_in)) {}

SharedMemoryVideoFrameData::~SharedMemoryVideoFrameData() = default;

void SharedMemoryVideoFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_data"), this->frame_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ReadOnlySharedMemoryRegion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offsets"), this->offsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedMemoryVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuMemoryBufferSharedImageVideoFrameData::GpuMemoryBufferSharedImageVideoFrameData()
    : gpu_memory_buffer_handle(),
      shared_image(),
      sync_token() {}

GpuMemoryBufferSharedImageVideoFrameData::GpuMemoryBufferSharedImageVideoFrameData(
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle_in,
    std::optional<::gpu::ExportedSharedImage> shared_image_in,
    const ::gpu::SyncToken& sync_token_in)
    : gpu_memory_buffer_handle(std::move(gpu_memory_buffer_handle_in)),
      shared_image(std::move(shared_image_in)),
      sync_token(std::move(sync_token_in)) {}

GpuMemoryBufferSharedImageVideoFrameData::~GpuMemoryBufferSharedImageVideoFrameData() = default;

void GpuMemoryBufferSharedImageVideoFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_memory_buffer_handle"), this->gpu_memory_buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_image"), this->shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::gpu::ExportedSharedImage>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token"), this->sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GpuMemoryBufferSharedImageVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedImageVideoFrameData::SharedImageVideoFrameData()
    : shared_image(),
      sync_token(),
      is_mappable_si_enabled() {}

SharedImageVideoFrameData::SharedImageVideoFrameData(
    ::gpu::ExportedSharedImage shared_image_in,
    const ::gpu::SyncToken& sync_token_in,
    bool is_mappable_si_enabled_in)
    : shared_image(std::move(shared_image_in)),
      sync_token(std::move(sync_token_in)),
      is_mappable_si_enabled(std::move(is_mappable_si_enabled_in)) {}

SharedImageVideoFrameData::~SharedImageVideoFrameData() = default;

void SharedImageVideoFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_image"), this->shared_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gpu::ExportedSharedImage>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sync_token"), this->sync_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gpu::SyncToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mappable_si_enabled"), this->is_mappable_si_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedImageVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpaqueVideoFrameData::OpaqueVideoFrameData() {}

OpaqueVideoFrameData::~OpaqueVideoFrameData() = default;
size_t OpaqueVideoFrameData::Hash(size_t seed) const {
  return seed;
}

void OpaqueVideoFrameData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool OpaqueVideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PipelineStatistics::PipelineStatistics()
    : audio_bytes_decoded(),
      video_bytes_decoded(),
      video_frames_decoded(),
      video_frames_dropped(),
      audio_memory_usage(),
      video_memory_usage() {}

PipelineStatistics::PipelineStatistics(
    uint64_t audio_bytes_decoded_in,
    uint64_t video_bytes_decoded_in,
    uint32_t video_frames_decoded_in,
    uint32_t video_frames_dropped_in,
    int64_t audio_memory_usage_in,
    int64_t video_memory_usage_in)
    : audio_bytes_decoded(std::move(audio_bytes_decoded_in)),
      video_bytes_decoded(std::move(video_bytes_decoded_in)),
      video_frames_decoded(std::move(video_frames_decoded_in)),
      video_frames_dropped(std::move(video_frames_dropped_in)),
      audio_memory_usage(std::move(audio_memory_usage_in)),
      video_memory_usage(std::move(video_memory_usage_in)) {}

PipelineStatistics::~PipelineStatistics() = default;

void PipelineStatistics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_bytes_decoded"), this->audio_bytes_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_bytes_decoded"), this->video_bytes_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_frames_decoded"), this->video_frames_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_frames_dropped"), this->video_frames_dropped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_memory_usage"), this->audio_memory_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_memory_usage"), this->video_memory_usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PipelineStatistics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PredictionFeatures::PredictionFeatures()
    : profile(),
      video_size(),
      frames_per_sec(0),
      key_system(),
      use_hw_secure_codecs(false) {}

PredictionFeatures::PredictionFeatures(
    ::media::VideoCodecProfile profile_in,
    const ::gfx::Size& video_size_in,
    double frames_per_sec_in,
    const std::string& key_system_in,
    bool use_hw_secure_codecs_in)
    : profile(std::move(profile_in)),
      video_size(std::move(video_size_in)),
      frames_per_sec(std::move(frames_per_sec_in)),
      key_system(std::move(key_system_in)),
      use_hw_secure_codecs(std::move(use_hw_secure_codecs_in)) {}

PredictionFeatures::~PredictionFeatures() = default;

void PredictionFeatures::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_size"), this->video_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_per_sec"), this->frames_per_sec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_system"), this->key_system,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_hw_secure_codecs"), this->use_hw_secure_codecs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PredictionFeatures::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PredictionTargets::PredictionTargets()
    : frames_decoded(0U),
      frames_dropped(0U),
      frames_power_efficient(0U) {}

PredictionTargets::PredictionTargets(
    uint32_t frames_decoded_in,
    uint32_t frames_dropped_in,
    uint32_t frames_power_efficient_in)
    : frames_decoded(std::move(frames_decoded_in)),
      frames_dropped(std::move(frames_dropped_in)),
      frames_power_efficient(std::move(frames_power_efficient_in)) {}

PredictionTargets::~PredictionTargets() = default;
size_t PredictionTargets::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->frames_decoded);
  seed = mojo::internal::Hash(seed, this->frames_dropped);
  seed = mojo::internal::Hash(seed, this->frames_power_efficient);
  return seed;
}

void PredictionTargets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_decoded"), this->frames_decoded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_dropped"), this->frames_dropped,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames_power_efficient"), this->frames_power_efficient,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PredictionTargets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioPipelineInfo::AudioPipelineInfo()
    : decoder_type(),
      is_platform_decoder(false),
      has_decrypting_demuxer_stream(false),
      encryption_type() {}

AudioPipelineInfo::AudioPipelineInfo(
    ::media::AudioDecoderType decoder_type_in,
    bool is_platform_decoder_in,
    bool has_decrypting_demuxer_stream_in,
    EncryptionType encryption_type_in)
    : decoder_type(std::move(decoder_type_in)),
      is_platform_decoder(std::move(is_platform_decoder_in)),
      has_decrypting_demuxer_stream(std::move(has_decrypting_demuxer_stream_in)),
      encryption_type(std::move(encryption_type_in)) {}

AudioPipelineInfo::~AudioPipelineInfo() = default;

void AudioPipelineInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoder_type"), this->decoder_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_decoder"), this->is_platform_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_decrypting_demuxer_stream"), this->has_decrypting_demuxer_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_type"), this->encryption_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EncryptionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioPipelineInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoPipelineInfo::VideoPipelineInfo()
    : decoder_type(),
      is_platform_decoder(false),
      has_decrypting_demuxer_stream(false),
      encryption_type() {}

VideoPipelineInfo::VideoPipelineInfo(
    ::media::VideoDecoderType decoder_type_in,
    bool is_platform_decoder_in,
    bool has_decrypting_demuxer_stream_in,
    EncryptionType encryption_type_in)
    : decoder_type(std::move(decoder_type_in)),
      is_platform_decoder(std::move(is_platform_decoder_in)),
      has_decrypting_demuxer_stream(std::move(has_decrypting_demuxer_stream_in)),
      encryption_type(std::move(encryption_type_in)) {}

VideoPipelineInfo::~VideoPipelineInfo() = default;

void VideoPipelineInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decoder_type"), this->decoder_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_platform_decoder"), this->is_platform_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_decrypting_demuxer_stream"), this->has_decrypting_demuxer_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_type"), this->encryption_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EncryptionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoPipelineInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StatusData::StatusData()
    : group(),
      code(),
      message(),
      frames(),
      cause(),
      data() {}

StatusData::StatusData(
    const std::string& group_in,
    uint16_t code_in,
    const std::string& message_in,
    ::base::Value::List frames_in,
    const std::optional<::media::internal::StatusData>& cause_in,
    ::base::Value data_in)
    : group(std::move(group_in)),
      code(std::move(code_in)),
      message(std::move(message_in)),
      frames(std::move(frames_in)),
      cause(std::move(cause_in)),
      data(std::move(data_in)) {}

StatusData::~StatusData() = default;

void StatusData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group"), this->group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames"), this->frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::List>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cause"), this->cause,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::internal::StatusData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StatusData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EncoderStatus::EncoderStatus()
    : internal() {}

EncoderStatus::EncoderStatus(
    const std::optional<::media::internal::StatusData>& internal_in)
    : internal(std::move(internal_in)) {}

EncoderStatus::~EncoderStatus() = default;

void EncoderStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal"), this->internal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::internal::StatusData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EncoderStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderStatus::DecoderStatus()
    : internal() {}

DecoderStatus::DecoderStatus(
    const std::optional<::media::internal::StatusData>& internal_in)
    : internal(std::move(internal_in)) {}

DecoderStatus::~DecoderStatus() = default;

void DecoderStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal"), this->internal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::internal::StatusData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecoderStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PipelineStatus::PipelineStatus()
    : internal() {}

PipelineStatus::PipelineStatus(
    const std::optional<::media::internal::StatusData>& internal_in)
    : internal(std::move(internal_in)) {}

PipelineStatus::~PipelineStatus() = default;

void PipelineStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal"), this->internal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::internal::StatusData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PipelineStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutoPipInfo::AutoPipInfo()
    : auto_pip_reason(),
      has_audio_focus(),
      is_playing(),
      was_recently_audible(),
      has_safe_url(),
      meets_media_engagement_conditions(),
      blocked_due_to_content_setting() {}

AutoPipInfo::AutoPipInfo(
    AutoPipReason auto_pip_reason_in,
    bool has_audio_focus_in,
    bool is_playing_in,
    bool was_recently_audible_in,
    bool has_safe_url_in,
    bool meets_media_engagement_conditions_in,
    bool blocked_due_to_content_setting_in)
    : auto_pip_reason(std::move(auto_pip_reason_in)),
      has_audio_focus(std::move(has_audio_focus_in)),
      is_playing(std::move(is_playing_in)),
      was_recently_audible(std::move(was_recently_audible_in)),
      has_safe_url(std::move(has_safe_url_in)),
      meets_media_engagement_conditions(std::move(meets_media_engagement_conditions_in)),
      blocked_due_to_content_setting(std::move(blocked_due_to_content_setting_in)) {}

AutoPipInfo::~AutoPipInfo() = default;

void AutoPipInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_pip_reason"), this->auto_pip_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutoPipReason>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_audio_focus"), this->has_audio_focus,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_playing"), this->is_playing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_recently_audible"), this->was_recently_audible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_safe_url"), this->has_safe_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "meets_media_engagement_conditions"), this->meets_media_engagement_conditions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked_due_to_content_setting"), this->blocked_due_to_content_setting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutoPipInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderBufferSideDataNextConfigPtr
DecoderBufferSideDataNextConfig::NewNextAudioConfig(
    const ::media::AudioDecoderConfig& value) {
  return DecoderBufferSideDataNextConfigPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNextAudioConfig)>,
      std::move(value));
}

DecoderBufferSideDataNextConfigPtr
DecoderBufferSideDataNextConfig::NewNextVideoConfig(
    const ::media::VideoDecoderConfig& value) {
  return DecoderBufferSideDataNextConfigPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNextVideoConfig)>,
      std::move(value));
}

DecoderBufferSideDataNextConfig::DecoderBufferSideDataNextConfig(
    std::in_place_index_t<static_cast<size_t>(Tag::kNextAudioConfig)>,
    const ::media::AudioDecoderConfig& value)
    : tag_(Tag::kNextAudioConfig),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNextAudioConfig)>,
            std::move(value)) {}

DecoderBufferSideDataNextConfig::DecoderBufferSideDataNextConfig(
    std::in_place_index_t<static_cast<size_t>(Tag::kNextVideoConfig)>,
    const ::media::VideoDecoderConfig& value)
    : tag_(Tag::kNextVideoConfig),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNextVideoConfig)>,
            std::move(value)) {}
DecoderBufferSideDataNextConfig::~DecoderBufferSideDataNextConfig() {
  DestroyActive();
}

void DecoderBufferSideDataNextConfig::set_next_audio_config(const ::media::AudioDecoderConfig& next_audio_config) {
  if (tag_ == Tag::kNextAudioConfig) {
    data_.next_audio_config = std::move(next_audio_config);
  } else {
    DestroyActive();
    tag_ = Tag::kNextAudioConfig;
    new (&data_.next_audio_config) ::media::AudioDecoderConfig(
        std::move(next_audio_config));
  }
}

void DecoderBufferSideDataNextConfig::set_next_video_config(const ::media::VideoDecoderConfig& next_video_config) {
  if (tag_ == Tag::kNextVideoConfig) {
    data_.next_video_config = std::move(next_video_config);
  } else {
    DestroyActive();
    tag_ = Tag::kNextVideoConfig;
    new (&data_.next_video_config) ::media::VideoDecoderConfig(
        std::move(next_video_config));
  }
}


DecoderBufferSideDataNextConfig::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNextAudioConfig)>,
    const ::media::AudioDecoderConfig& value)
    : next_audio_config(std::move(value)) {}

DecoderBufferSideDataNextConfig::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNextVideoConfig)>,
    const ::media::VideoDecoderConfig& value)
    : next_video_config(std::move(value)) {}

void DecoderBufferSideDataNextConfig::DestroyActive() {
  switch (tag_) {

    case Tag::kNextAudioConfig:
      std::destroy_at(&data_.next_audio_config);
      break;
    case Tag::kNextVideoConfig:
      std::destroy_at(&data_.next_video_config);
      break;
  }
}

bool DecoderBufferSideDataNextConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
DecoderBufferPtr
DecoderBuffer::NewEos(
    EosDecoderBufferPtr value) {
  return DecoderBufferPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEos)>,
      std::move(value));
}

DecoderBufferPtr
DecoderBuffer::NewData(
    DataDecoderBufferPtr value) {
  return DecoderBufferPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kData)>,
      std::move(value));
}

DecoderBuffer::DecoderBuffer(
    std::in_place_index_t<static_cast<size_t>(Tag::kEos)>,
    EosDecoderBufferPtr value)
    : tag_(Tag::kEos),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEos)>,
            std::move(value)) {}

DecoderBuffer::DecoderBuffer(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    DataDecoderBufferPtr value)
    : tag_(Tag::kData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kData)>,
            std::move(value)) {}
DecoderBuffer::~DecoderBuffer() {
  DestroyActive();
}

void DecoderBuffer::set_eos(EosDecoderBufferPtr eos) {
  if (tag_ == Tag::kEos) {
    data_.eos = std::move(eos);
  } else {
    DestroyActive();
    tag_ = Tag::kEos;
    new (&data_.eos) EosDecoderBufferPtr(
        std::move(eos));
  }
}

void DecoderBuffer::set_data(DataDecoderBufferPtr data) {
  if (tag_ == Tag::kData) {
    data_.data = std::move(data);
  } else {
    DestroyActive();
    tag_ = Tag::kData;
    new (&data_.data) DataDecoderBufferPtr(
        std::move(data));
  }
}


DecoderBuffer::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEos)>,
    EosDecoderBufferPtr value)
    : eos(std::move(value)) {}

DecoderBuffer::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
    DataDecoderBufferPtr value)
    : data(std::move(value)) {}

void DecoderBuffer::DestroyActive() {
  switch (tag_) {

    case Tag::kEos:
      std::destroy_at(&data_.eos);
      break;
    case Tag::kData:
      std::destroy_at(&data_.data);
      break;
  }
}

bool DecoderBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
VideoFrameDataPtr
VideoFrameData::NewEosData(
    EosVideoFrameDataPtr value) {
  return VideoFrameDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEosData)>,
      std::move(value));
}

VideoFrameDataPtr
VideoFrameData::NewSharedMemoryData(
    SharedMemoryVideoFrameDataPtr value) {
  return VideoFrameDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedMemoryData)>,
      std::move(value));
}

VideoFrameDataPtr
VideoFrameData::NewGpuMemoryBufferSharedImageData(
    GpuMemoryBufferSharedImageVideoFrameDataPtr value) {
  return VideoFrameDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGpuMemoryBufferSharedImageData)>,
      std::move(value));
}

VideoFrameDataPtr
VideoFrameData::NewSharedImageData(
    SharedImageVideoFrameDataPtr value) {
  return VideoFrameDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedImageData)>,
      std::move(value));
}

VideoFrameDataPtr
VideoFrameData::NewOpaqueData(
    OpaqueVideoFrameDataPtr value) {
  return VideoFrameDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOpaqueData)>,
      std::move(value));
}

VideoFrameData::VideoFrameData(
    std::in_place_index_t<static_cast<size_t>(Tag::kEosData)>,
    EosVideoFrameDataPtr value)
    : tag_(Tag::kEosData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEosData)>,
            std::move(value)) {}

VideoFrameData::VideoFrameData(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryData)>,
    SharedMemoryVideoFrameDataPtr value)
    : tag_(Tag::kSharedMemoryData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedMemoryData)>,
            std::move(value)) {}

VideoFrameData::VideoFrameData(
    std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferSharedImageData)>,
    GpuMemoryBufferSharedImageVideoFrameDataPtr value)
    : tag_(Tag::kGpuMemoryBufferSharedImageData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGpuMemoryBufferSharedImageData)>,
            std::move(value)) {}

VideoFrameData::VideoFrameData(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageData)>,
    SharedImageVideoFrameDataPtr value)
    : tag_(Tag::kSharedImageData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedImageData)>,
            std::move(value)) {}

VideoFrameData::VideoFrameData(
    std::in_place_index_t<static_cast<size_t>(Tag::kOpaqueData)>,
    OpaqueVideoFrameDataPtr value)
    : tag_(Tag::kOpaqueData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOpaqueData)>,
            std::move(value)) {}
VideoFrameData::~VideoFrameData() {
  DestroyActive();
}

void VideoFrameData::set_eos_data(EosVideoFrameDataPtr eos_data) {
  if (tag_ == Tag::kEosData) {
    data_.eos_data = std::move(eos_data);
  } else {
    DestroyActive();
    tag_ = Tag::kEosData;
    new (&data_.eos_data) EosVideoFrameDataPtr(
        std::move(eos_data));
  }
}

void VideoFrameData::set_shared_memory_data(SharedMemoryVideoFrameDataPtr shared_memory_data) {
  if (tag_ == Tag::kSharedMemoryData) {
    data_.shared_memory_data = std::move(shared_memory_data);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedMemoryData;
    new (&data_.shared_memory_data) SharedMemoryVideoFrameDataPtr(
        std::move(shared_memory_data));
  }
}

void VideoFrameData::set_gpu_memory_buffer_shared_image_data(GpuMemoryBufferSharedImageVideoFrameDataPtr gpu_memory_buffer_shared_image_data) {
  if (tag_ == Tag::kGpuMemoryBufferSharedImageData) {
    data_.gpu_memory_buffer_shared_image_data = std::move(gpu_memory_buffer_shared_image_data);
  } else {
    DestroyActive();
    tag_ = Tag::kGpuMemoryBufferSharedImageData;
    new (&data_.gpu_memory_buffer_shared_image_data) GpuMemoryBufferSharedImageVideoFrameDataPtr(
        std::move(gpu_memory_buffer_shared_image_data));
  }
}

void VideoFrameData::set_shared_image_data(SharedImageVideoFrameDataPtr shared_image_data) {
  if (tag_ == Tag::kSharedImageData) {
    data_.shared_image_data = std::move(shared_image_data);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedImageData;
    new (&data_.shared_image_data) SharedImageVideoFrameDataPtr(
        std::move(shared_image_data));
  }
}

void VideoFrameData::set_opaque_data(OpaqueVideoFrameDataPtr opaque_data) {
  if (tag_ == Tag::kOpaqueData) {
    data_.opaque_data = std::move(opaque_data);
  } else {
    DestroyActive();
    tag_ = Tag::kOpaqueData;
    new (&data_.opaque_data) OpaqueVideoFrameDataPtr(
        std::move(opaque_data));
  }
}


VideoFrameData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEosData)>,
    EosVideoFrameDataPtr value)
    : eos_data(std::move(value)) {}

VideoFrameData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedMemoryData)>,
    SharedMemoryVideoFrameDataPtr value)
    : shared_memory_data(std::move(value)) {}

VideoFrameData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGpuMemoryBufferSharedImageData)>,
    GpuMemoryBufferSharedImageVideoFrameDataPtr value)
    : gpu_memory_buffer_shared_image_data(std::move(value)) {}

VideoFrameData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedImageData)>,
    SharedImageVideoFrameDataPtr value)
    : shared_image_data(std::move(value)) {}

VideoFrameData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOpaqueData)>,
    OpaqueVideoFrameDataPtr value)
    : opaque_data(std::move(value)) {}

void VideoFrameData::DestroyActive() {
  switch (tag_) {

    case Tag::kEosData:
      std::destroy_at(&data_.eos_data);
      break;
    case Tag::kSharedMemoryData:
      std::destroy_at(&data_.shared_memory_data);
      break;
    case Tag::kGpuMemoryBufferSharedImageData:
      std::destroy_at(&data_.gpu_memory_buffer_shared_image_data);
      break;
    case Tag::kSharedImageData:
      std::destroy_at(&data_.shared_image_data);
      break;
    case Tag::kOpaqueData:
      std::destroy_at(&data_.opaque_data);
      break;
  }
}

bool VideoFrameData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // media::mojom


namespace mojo {


// static
bool StructTraits<::media::mojom::VideoTransformation::DataView, ::media::mojom::VideoTransformationPtr>::Read(
    ::media::mojom::VideoTransformation::DataView input,
    ::media::mojom::VideoTransformationPtr* output) {
  bool success = true;
  ::media::mojom::VideoTransformationPtr result(::media::mojom::VideoTransformation::New());
  
      if (success && !input.ReadRotation(&result->rotation))
        success = false;
      if (success)
        result->mirrored = input.mirrored();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoAspectRatio::DataView, ::media::mojom::VideoAspectRatioPtr>::Read(
    ::media::mojom::VideoAspectRatio::DataView input,
    ::media::mojom::VideoAspectRatioPtr* output) {
  bool success = true;
  ::media::mojom::VideoAspectRatioPtr result(::media::mojom::VideoAspectRatio::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoColorSpace::DataView, ::media::mojom::VideoColorSpacePtr>::Read(
    ::media::mojom::VideoColorSpace::DataView input,
    ::media::mojom::VideoColorSpacePtr* output) {
  bool success = true;
  ::media::mojom::VideoColorSpacePtr result(::media::mojom::VideoColorSpace::New());
  
      if (success && !input.ReadPrimaries(&result->primaries))
        success = false;
      if (success && !input.ReadTransfer(&result->transfer))
        success = false;
      if (success && !input.ReadMatrix(&result->matrix))
        success = false;
      if (success && !input.ReadRange(&result->range))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioDecoderConfig::DataView, ::media::mojom::AudioDecoderConfigPtr>::Read(
    ::media::mojom::AudioDecoderConfig::DataView input,
    ::media::mojom::AudioDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::AudioDecoderConfigPtr result(::media::mojom::AudioDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadSampleFormat(&result->sample_format))
        success = false;
      if (success && !input.ReadChannelLayout(&result->channel_layout))
        success = false;
      if (success)
        result->samples_per_second = input.samples_per_second();
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadSeekPreroll(&result->seek_preroll))
        success = false;
      if (success)
        result->codec_delay = input.codec_delay();
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadTargetOutputChannelLayout(&result->target_output_channel_layout))
        success = false;
      if (success && !input.ReadTargetOutputSampleFormat(&result->target_output_sample_format))
        success = false;
      if (success)
        result->should_discard_decoder_delay = input.should_discard_decoder_delay();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoDecoderConfig::DataView, ::media::mojom::VideoDecoderConfigPtr>::Read(
    ::media::mojom::VideoDecoderConfig::DataView input,
    ::media::mojom::VideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::VideoDecoderConfigPtr result(::media::mojom::VideoDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success)
        result->level = input.level();
      if (success)
        result->has_alpha = input.has_alpha();
      if (success && !input.ReadTransformation(&result->transformation))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadAspectRatio(&result->aspect_ratio))
        success = false;
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadColorSpaceInfo(&result->color_space_info))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DecryptConfig::DataView, ::media::mojom::DecryptConfigPtr>::Read(
    ::media::mojom::DecryptConfig::DataView input,
    ::media::mojom::DecryptConfigPtr* output) {
  bool success = true;
  ::media::mojom::DecryptConfigPtr result(::media::mojom::DecryptConfig::New());
  
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadIv(&result->iv))
        success = false;
      if (success && !input.ReadSubsamples(&result->subsamples))
        success = false;
      if (success && !input.ReadEncryptionPattern(&result->encryption_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DecoderBufferSideData::DataView, ::media::mojom::DecoderBufferSideDataPtr>::Read(
    ::media::mojom::DecoderBufferSideData::DataView input,
    ::media::mojom::DecoderBufferSideDataPtr* output) {
  bool success = true;
  ::media::mojom::DecoderBufferSideDataPtr result(::media::mojom::DecoderBufferSideData::New());
  
      if (success && !input.ReadSpatialLayers(&result->spatial_layers))
        success = false;
      if (success && !input.ReadAlphaData(&result->alpha_data))
        success = false;
      if (success)
        result->secure_handle = input.secure_handle();
      if (success && !input.ReadFrontDiscard(&result->front_discard))
        success = false;
      if (success && !input.ReadBackDiscard(&result->back_discard))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DataDecoderBuffer::DataView, ::media::mojom::DataDecoderBufferPtr>::Read(
    ::media::mojom::DataDecoderBuffer::DataView input,
    ::media::mojom::DataDecoderBufferPtr* output) {
  bool success = true;
  ::media::mojom::DataDecoderBufferPtr result(::media::mojom::DataDecoderBuffer::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success)
        result->data_size = input.data_size();
      if (success)
        result->is_key_frame = input.is_key_frame();
      if (success && !input.ReadDecryptConfig(&result->decrypt_config))
        success = false;
      if (success && !input.ReadSideData(&result->side_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::EosDecoderBuffer::DataView, ::media::mojom::EosDecoderBufferPtr>::Read(
    ::media::mojom::EosDecoderBuffer::DataView input,
    ::media::mojom::EosDecoderBufferPtr* output) {
  bool success = true;
  ::media::mojom::EosDecoderBufferPtr result(::media::mojom::EosDecoderBuffer::New());
  
      if (success && !input.ReadNextConfig(&result->next_config))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioBuffer::DataView, ::media::mojom::AudioBufferPtr>::Read(
    ::media::mojom::AudioBuffer::DataView input,
    ::media::mojom::AudioBufferPtr* output) {
  bool success = true;
  ::media::mojom::AudioBufferPtr result(::media::mojom::AudioBuffer::New());
  
      if (success && !input.ReadSampleFormat(&result->sample_format))
        success = false;
      if (success && !input.ReadChannelLayout(&result->channel_layout))
        success = false;
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->frame_count = input.frame_count();
      if (success)
        result->end_of_stream = input.end_of_stream();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::CaptureVersion::DataView, ::media::mojom::CaptureVersionPtr>::Read(
    ::media::mojom::CaptureVersion::DataView input,
    ::media::mojom::CaptureVersionPtr* output) {
  bool success = true;
  ::media::mojom::CaptureVersionPtr result(::media::mojom::CaptureVersion::New());
  
      if (success)
        result->source = input.source();
      if (success)
        result->sub_capture = input.sub_capture();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoFrameMetadata::DataView, ::media::mojom::VideoFrameMetadataPtr>::Read(
    ::media::mojom::VideoFrameMetadata::DataView input,
    ::media::mojom::VideoFrameMetadataPtr* output) {
  bool success = true;
  ::media::mojom::VideoFrameMetadataPtr result(::media::mojom::VideoFrameMetadata::New());
  
      if (success)
        result->allow_overlay = input.allow_overlay();
      if (success && !input.ReadCaptureBeginTime(&result->capture_begin_time))
        success = false;
      if (success && !input.ReadCaptureEndTime(&result->capture_end_time))
        success = false;
      if (success)
        result->has_capture_counter = input.has_capture_counter();
      if (success)
        result->capture_counter = input.capture_counter();
      if (success && !input.ReadCaptureUpdateRect(&result->capture_update_rect))
        success = false;
      if (success && !input.ReadSourceSize(&result->source_size))
        success = false;
      if (success && !input.ReadRegionCaptureRect(&result->region_capture_rect))
        success = false;
      if (success && !input.ReadCaptureVersion(&result->capture_version))
        success = false;
      if (success)
        result->copy_required = input.copy_required();
      if (success)
        result->end_of_stream = input.end_of_stream();
      if (success && !input.ReadFrameDuration(&result->frame_duration))
        success = false;
      if (success)
        result->has_frame_rate = input.has_frame_rate();
      if (success)
        result->frame_rate = input.frame_rate();
      if (success)
        result->interactive_content = input.interactive_content();
      if (success && !input.ReadReferenceTime(&result->reference_time))
        success = false;
      if (success)
        result->read_lock_fences_enabled = input.read_lock_fences_enabled();
      if (success && !input.ReadTransformation(&result->transformation))
        success = false;
      if (success)
        result->in_surface_view = input.in_surface_view();
      if (success)
        result->wants_promotion_hint = input.wants_promotion_hint();
      if (success)
        result->protected_video = input.protected_video();
      if (success)
        result->hw_protected = input.hw_protected();
      if (success)
        result->needs_detiling = input.needs_detiling();
      if (success)
        result->is_webgpu_compatible = input.is_webgpu_compatible();
      if (success && !input.ReadTrackingToken(&result->tracking_token))
        success = false;
      if (success)
        result->power_efficient = input.power_efficient();
      if (success)
        result->has_device_scale_factor = input.has_device_scale_factor();
      if (success)
        result->device_scale_factor = input.device_scale_factor();
      if (success)
        result->has_page_scale_factor = input.has_page_scale_factor();
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->has_root_scroll_offset_x = input.has_root_scroll_offset_x();
      if (success)
        result->root_scroll_offset_x = input.root_scroll_offset_x();
      if (success)
        result->has_root_scroll_offset_y = input.has_root_scroll_offset_y();
      if (success)
        result->root_scroll_offset_y = input.root_scroll_offset_y();
      if (success)
        result->has_top_controls_visible_height = input.has_top_controls_visible_height();
      if (success)
        result->top_controls_visible_height = input.top_controls_visible_height();
      if (success && !input.ReadDecodeBeginTime(&result->decode_begin_time))
        success = false;
      if (success && !input.ReadDecodeEndTime(&result->decode_end_time))
        success = false;
      if (success && !input.ReadProcessingTime(&result->processing_time))
        success = false;
      if (success)
        result->has_rtp_timestamp = input.has_rtp_timestamp();
      if (success)
        result->rtp_timestamp = input.rtp_timestamp();
      if (success && !input.ReadReceiveTime(&result->receive_time))
        success = false;
      if (success && !input.ReadWallclockFrameDuration(&result->wallclock_frame_duration))
        success = false;
      if (success) {
        result->frame_sequence = input.frame_sequence();
      }
      if (success) {
        result->source_id = input.source_id();
      }
      if (success && !input.ReadBackgroundBlur(&result->background_blur))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoFrame::DataView, ::media::mojom::VideoFramePtr>::Read(
    ::media::mojom::VideoFrame::DataView input,
    ::media::mojom::VideoFramePtr* output) {
  bool success = true;
  ::media::mojom::VideoFramePtr result(::media::mojom::VideoFrame::New());
  
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::EosVideoFrameData::DataView, ::media::mojom::EosVideoFrameDataPtr>::Read(
    ::media::mojom::EosVideoFrameData::DataView input,
    ::media::mojom::EosVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::EosVideoFrameDataPtr result(::media::mojom::EosVideoFrameData::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SharedMemoryVideoFrameData::DataView, ::media::mojom::SharedMemoryVideoFrameDataPtr>::Read(
    ::media::mojom::SharedMemoryVideoFrameData::DataView input,
    ::media::mojom::SharedMemoryVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::SharedMemoryVideoFrameDataPtr result(::media::mojom::SharedMemoryVideoFrameData::New());
  
      if (success && !input.ReadFrameData(&result->frame_data))
        success = false;
      if (success && !input.ReadStrides(&result->strides))
        success = false;
      if (success && !input.ReadOffsets(&result->offsets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::DataView, ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr>::Read(
    ::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::DataView input,
    ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr result(::media::mojom::GpuMemoryBufferSharedImageVideoFrameData::New());
  
      if (success && !input.ReadGpuMemoryBufferHandle(&result->gpu_memory_buffer_handle))
        success = false;
      if (success && !input.ReadSharedImage(&result->shared_image))
        success = false;
      if (success && !input.ReadSyncToken(&result->sync_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::SharedImageVideoFrameData::DataView, ::media::mojom::SharedImageVideoFrameDataPtr>::Read(
    ::media::mojom::SharedImageVideoFrameData::DataView input,
    ::media::mojom::SharedImageVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::SharedImageVideoFrameDataPtr result(::media::mojom::SharedImageVideoFrameData::New());
  
      if (success && !input.ReadSharedImage(&result->shared_image))
        success = false;
      if (success && !input.ReadSyncToken(&result->sync_token))
        success = false;
      if (success)
        result->is_mappable_si_enabled = input.is_mappable_si_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::OpaqueVideoFrameData::DataView, ::media::mojom::OpaqueVideoFrameDataPtr>::Read(
    ::media::mojom::OpaqueVideoFrameData::DataView input,
    ::media::mojom::OpaqueVideoFrameDataPtr* output) {
  bool success = true;
  ::media::mojom::OpaqueVideoFrameDataPtr result(::media::mojom::OpaqueVideoFrameData::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PipelineStatistics::DataView, ::media::mojom::PipelineStatisticsPtr>::Read(
    ::media::mojom::PipelineStatistics::DataView input,
    ::media::mojom::PipelineStatisticsPtr* output) {
  bool success = true;
  ::media::mojom::PipelineStatisticsPtr result(::media::mojom::PipelineStatistics::New());
  
      if (success)
        result->audio_bytes_decoded = input.audio_bytes_decoded();
      if (success)
        result->video_bytes_decoded = input.video_bytes_decoded();
      if (success)
        result->video_frames_decoded = input.video_frames_decoded();
      if (success)
        result->video_frames_dropped = input.video_frames_dropped();
      if (success)
        result->audio_memory_usage = input.audio_memory_usage();
      if (success)
        result->video_memory_usage = input.video_memory_usage();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PredictionFeatures::DataView, ::media::mojom::PredictionFeaturesPtr>::Read(
    ::media::mojom::PredictionFeatures::DataView input,
    ::media::mojom::PredictionFeaturesPtr* output) {
  bool success = true;
  ::media::mojom::PredictionFeaturesPtr result(::media::mojom::PredictionFeatures::New());
  
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success && !input.ReadVideoSize(&result->video_size))
        success = false;
      if (success)
        result->frames_per_sec = input.frames_per_sec();
      if (success && !input.ReadKeySystem(&result->key_system))
        success = false;
      if (success)
        result->use_hw_secure_codecs = input.use_hw_secure_codecs();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PredictionTargets::DataView, ::media::mojom::PredictionTargetsPtr>::Read(
    ::media::mojom::PredictionTargets::DataView input,
    ::media::mojom::PredictionTargetsPtr* output) {
  bool success = true;
  ::media::mojom::PredictionTargetsPtr result(::media::mojom::PredictionTargets::New());
  
      if (success)
        result->frames_decoded = input.frames_decoded();
      if (success)
        result->frames_dropped = input.frames_dropped();
      if (success)
        result->frames_power_efficient = input.frames_power_efficient();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AudioPipelineInfo::DataView, ::media::mojom::AudioPipelineInfoPtr>::Read(
    ::media::mojom::AudioPipelineInfo::DataView input,
    ::media::mojom::AudioPipelineInfoPtr* output) {
  bool success = true;
  ::media::mojom::AudioPipelineInfoPtr result(::media::mojom::AudioPipelineInfo::New());
  
      if (success && !input.ReadDecoderType(&result->decoder_type))
        success = false;
      if (success)
        result->is_platform_decoder = input.is_platform_decoder();
      if (success)
        result->has_decrypting_demuxer_stream = input.has_decrypting_demuxer_stream();
      if (success && !input.ReadEncryptionType(&result->encryption_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::VideoPipelineInfo::DataView, ::media::mojom::VideoPipelineInfoPtr>::Read(
    ::media::mojom::VideoPipelineInfo::DataView input,
    ::media::mojom::VideoPipelineInfoPtr* output) {
  bool success = true;
  ::media::mojom::VideoPipelineInfoPtr result(::media::mojom::VideoPipelineInfo::New());
  
      if (success && !input.ReadDecoderType(&result->decoder_type))
        success = false;
      if (success)
        result->is_platform_decoder = input.is_platform_decoder();
      if (success)
        result->has_decrypting_demuxer_stream = input.has_decrypting_demuxer_stream();
      if (success && !input.ReadEncryptionType(&result->encryption_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::StatusData::DataView, ::media::mojom::StatusDataPtr>::Read(
    ::media::mojom::StatusData::DataView input,
    ::media::mojom::StatusDataPtr* output) {
  bool success = true;
  ::media::mojom::StatusDataPtr result(::media::mojom::StatusData::New());
  
      if (success && !input.ReadGroup(&result->group))
        success = false;
      if (success)
        result->code = input.code();
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadFrames(&result->frames))
        success = false;
      if (success && !input.ReadCause(&result->cause))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::EncoderStatus::DataView, ::media::mojom::EncoderStatusPtr>::Read(
    ::media::mojom::EncoderStatus::DataView input,
    ::media::mojom::EncoderStatusPtr* output) {
  bool success = true;
  ::media::mojom::EncoderStatusPtr result(::media::mojom::EncoderStatus::New());
  
      if (success && !input.ReadInternal(&result->internal))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::DecoderStatus::DataView, ::media::mojom::DecoderStatusPtr>::Read(
    ::media::mojom::DecoderStatus::DataView input,
    ::media::mojom::DecoderStatusPtr* output) {
  bool success = true;
  ::media::mojom::DecoderStatusPtr result(::media::mojom::DecoderStatus::New());
  
      if (success && !input.ReadInternal(&result->internal))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::PipelineStatus::DataView, ::media::mojom::PipelineStatusPtr>::Read(
    ::media::mojom::PipelineStatus::DataView input,
    ::media::mojom::PipelineStatusPtr* output) {
  bool success = true;
  ::media::mojom::PipelineStatusPtr result(::media::mojom::PipelineStatus::New());
  
      if (success && !input.ReadInternal(&result->internal))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::AutoPipInfo::DataView, ::media::mojom::AutoPipInfoPtr>::Read(
    ::media::mojom::AutoPipInfo::DataView input,
    ::media::mojom::AutoPipInfoPtr* output) {
  bool success = true;
  ::media::mojom::AutoPipInfoPtr result(::media::mojom::AutoPipInfo::New());
  
      if (success && !input.ReadAutoPipReason(&result->auto_pip_reason))
        success = false;
      if (success)
        result->has_audio_focus = input.has_audio_focus();
      if (success)
        result->is_playing = input.is_playing();
      if (success)
        result->was_recently_audible = input.was_recently_audible();
      if (success)
        result->has_safe_url = input.has_safe_url();
      if (success)
        result->meets_media_engagement_conditions = input.meets_media_engagement_conditions();
      if (success)
        result->blocked_due_to_content_setting = input.blocked_due_to_content_setting();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::media::mojom::DecoderBufferSideDataNextConfig::DataView, ::media::mojom::DecoderBufferSideDataNextConfigPtr>::Read(
    ::media::mojom::DecoderBufferSideDataNextConfig::DataView input,
    ::media::mojom::DecoderBufferSideDataNextConfigPtr* output) {
  using UnionType = ::media::mojom::DecoderBufferSideDataNextConfig;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNextAudioConfig: {
      ::media::AudioDecoderConfig result_next_audio_config{};
      if (!input.ReadNextAudioConfig(&result_next_audio_config))
        return false;

      *output = UnionType::NewNextAudioConfig(
          std::move(result_next_audio_config));
      break;
    }
    case Tag::kNextVideoConfig: {
      ::media::VideoDecoderConfig result_next_video_config{};
      if (!input.ReadNextVideoConfig(&result_next_video_config))
        return false;

      *output = UnionType::NewNextVideoConfig(
          std::move(result_next_video_config));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::media::mojom::DecoderBuffer::DataView, ::media::mojom::DecoderBufferPtr>::Read(
    ::media::mojom::DecoderBuffer::DataView input,
    ::media::mojom::DecoderBufferPtr* output) {
  using UnionType = ::media::mojom::DecoderBuffer;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kEos: {
      ::media::mojom::EosDecoderBufferPtr result_eos{};
      if (!input.ReadEos(&result_eos))
        return false;

      *output = UnionType::NewEos(
          std::move(result_eos));
      break;
    }
    case Tag::kData: {
      ::media::mojom::DataDecoderBufferPtr result_data{};
      if (!input.ReadData(&result_data))
        return false;

      *output = UnionType::NewData(
          std::move(result_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::media::mojom::VideoFrameData::DataView, ::media::mojom::VideoFrameDataPtr>::Read(
    ::media::mojom::VideoFrameData::DataView input,
    ::media::mojom::VideoFrameDataPtr* output) {
  using UnionType = ::media::mojom::VideoFrameData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kEosData: {
      ::media::mojom::EosVideoFrameDataPtr result_eos_data{};
      if (!input.ReadEosData(&result_eos_data))
        return false;

      *output = UnionType::NewEosData(
          std::move(result_eos_data));
      break;
    }
    case Tag::kSharedMemoryData: {
      ::media::mojom::SharedMemoryVideoFrameDataPtr result_shared_memory_data{};
      if (!input.ReadSharedMemoryData(&result_shared_memory_data))
        return false;

      *output = UnionType::NewSharedMemoryData(
          std::move(result_shared_memory_data));
      break;
    }
    case Tag::kGpuMemoryBufferSharedImageData: {
      ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataPtr result_gpu_memory_buffer_shared_image_data{};
      if (!input.ReadGpuMemoryBufferSharedImageData(&result_gpu_memory_buffer_shared_image_data))
        return false;

      *output = UnionType::NewGpuMemoryBufferSharedImageData(
          std::move(result_gpu_memory_buffer_shared_image_data));
      break;
    }
    case Tag::kSharedImageData: {
      ::media::mojom::SharedImageVideoFrameDataPtr result_shared_image_data{};
      if (!input.ReadSharedImageData(&result_shared_image_data))
        return false;

      *output = UnionType::NewSharedImageData(
          std::move(result_shared_image_data));
      break;
    }
    case Tag::kOpaqueData: {
      ::media::mojom::OpaqueVideoFrameDataPtr result_opaque_data{};
      if (!input.ReadOpaqueData(&result_opaque_data))
        return false;

      *output = UnionType::NewOpaqueData(
          std::move(result_opaque_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {




}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif