// media/mojo/mojom/media_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "media/mojo/mojom/audio_data.mojom-shared.h"
#include "media/mojo/mojom/encryption_pattern.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "media/mojo/mojom/media_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::media::mojom::VideoRotation>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoRotation> {};

template <>
struct hash<::media::mojom::EncryptionType>
    : public mojo::internal::EnumHashImpl<::media::mojom::EncryptionType> {};

template <>
struct hash<::media::mojom::SVCScalabilityMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::SVCScalabilityMode> {};

template <>
struct hash<::media::mojom::SVCInterLayerPredMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::SVCInterLayerPredMode> {};

template <>
struct hash<::media::mojom::CdmSessionClosedReason>
    : public mojo::internal::EnumHashImpl<::media::mojom::CdmSessionClosedReason> {};

template <>
struct hash<::media::mojom::EffectState>
    : public mojo::internal::EnumHashImpl<::media::mojom::EffectState> {};

template <>
struct hash<::media::mojom::MediaStreamType>
    : public mojo::internal::EnumHashImpl<::media::mojom::MediaStreamType> {};

template <>
struct hash<::media::mojom::InputStreamErrorCode>
    : public mojo::internal::EnumHashImpl<::media::mojom::InputStreamErrorCode> {};

template <>
struct hash<::media::mojom::RendererType>
    : public mojo::internal::EnumHashImpl<::media::mojom::RendererType> {};

template <>
struct hash<::media::mojom::DemuxerType>
    : public mojo::internal::EnumHashImpl<::media::mojom::DemuxerType> {};

template <>
struct hash<::media::mojom::CreateCdmStatus>
    : public mojo::internal::EnumHashImpl<::media::mojom::CreateCdmStatus> {};

template <>
struct hash<::media::mojom::AutoPipReason>
    : public mojo::internal::EnumHashImpl<::media::mojom::AutoPipReason> {};

template <>
struct hash<::media::mojom::VideoAspectRatio_Type>
    : public mojo::internal::EnumHashImpl<::media::mojom::VideoAspectRatio_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoRotation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoRotation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoRotation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EncryptionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::EncryptionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::EncryptionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SVCScalabilityMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SVCScalabilityMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SVCScalabilityMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SVCInterLayerPredMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SVCInterLayerPredMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SVCInterLayerPredMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmSessionClosedReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CdmSessionClosedReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CdmSessionClosedReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EffectState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::EffectState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::EffectState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::MediaStreamType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::MediaStreamType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::MediaStreamType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::InputStreamErrorCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::InputStreamErrorCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::InputStreamErrorCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RendererType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RendererType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RendererType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DemuxerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::DemuxerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::DemuxerType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CreateCdmStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CreateCdmStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CreateCdmStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AutoPipReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::AutoPipReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::AutoPipReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoAspectRatio_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::VideoAspectRatio_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::VideoAspectRatio_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoTransformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoTransformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoTransformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoRotation>(
      Traits::rotation(input),
      &fragment->rotation);

    fragment->mirrored = Traits::mirrored(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoTransformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoTransformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoAspectRatioDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoAspectRatioDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoAspectRatio_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoAspectRatio_Type>(
      Traits::type(input),
      &fragment->type);

    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::media::mojom::internal::VideoAspectRatio_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoAspectRatioDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoColorSpaceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoColorSpaceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoColorSpace_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoColorSpace_PrimaryID>(
      Traits::primaries(input),
      &fragment->primaries);

    
    mojo::internal::Serialize<::media::mojom::VideoColorSpace_TransferID>(
      Traits::transfer(input),
      &fragment->transfer);

    
    mojo::internal::Serialize<::media::mojom::VideoColorSpace_MatrixID>(
      Traits::matrix(input),
      &fragment->matrix);

    
    mojo::internal::Serialize<::media::mojom::VideoColorSpace_RangeID>(
      Traits::range(input),
      &fragment->range);
  }

  static bool Deserialize(::media::mojom::internal::VideoColorSpace_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoColorSpaceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::AudioCodec>(
      Traits::codec(input),
      &fragment->codec);

    
    mojo::internal::Serialize<::media::mojom::SampleFormat>(
      Traits::sample_format(input),
      &fragment->sample_format);

    
    mojo::internal::Serialize<::media::mojom::ChannelLayout>(
      Traits::channel_layout(input),
      &fragment->channel_layout);

    fragment->samples_per_second = Traits::samples_per_second(input);

    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_data)::BaseType>
        extra_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_extra_data,
      extra_data_fragment,
      &extra_data_validate_params);

    fragment->extra_data.Set(
        extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extra_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra_data in AudioDecoderConfig struct");

    
    mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
      Traits::encryption_scheme(input),
      &fragment->encryption_scheme);

    decltype(Traits::seek_preroll(input)) in_seek_preroll = Traits::seek_preroll(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->seek_preroll)::BaseType> seek_preroll_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_preroll,
      seek_preroll_fragment);

    fragment->seek_preroll.Set(
        seek_preroll_fragment.is_null() ? nullptr : seek_preroll_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->seek_preroll.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_preroll in AudioDecoderConfig struct");

    fragment->codec_delay = Traits::codec_delay(input);

    
    mojo::internal::Serialize<::media::mojom::AudioCodecProfile>(
      Traits::profile(input),
      &fragment->profile);

    
    mojo::internal::Serialize<::media::mojom::ChannelLayout>(
      Traits::target_output_channel_layout(input),
      &fragment->target_output_channel_layout);

    
    mojo::internal::Serialize<::media::mojom::SampleFormat>(
      Traits::target_output_sample_format(input),
      &fragment->target_output_sample_format);

    fragment->should_discard_decoder_delay = Traits::should_discard_decoder_delay(input);
  }

  static bool Deserialize(::media::mojom::internal::AudioDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoCodec>(
      Traits::codec(input),
      &fragment->codec);

    
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
      Traits::profile(input),
      &fragment->profile);

    fragment->level = Traits::level(input);

    fragment->has_alpha = Traits::has_alpha(input);

    decltype(Traits::transformation(input)) in_transformation = Traits::transformation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transformation)::BaseType> transformation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoTransformationDataView>(
      in_transformation,
      transformation_fragment);

    fragment->transformation.Set(
        transformation_fragment.is_null() ? nullptr : transformation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transformation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transformation in VideoDecoderConfig struct");

    decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_coded_size,
      coded_size_fragment);

    fragment->coded_size.Set(
        coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->coded_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null coded_size in VideoDecoderConfig struct");

    decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_visible_rect,
      visible_rect_fragment);

    fragment->visible_rect.Set(
        visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_rect in VideoDecoderConfig struct");

    decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_natural_size,
      natural_size_fragment);

    fragment->natural_size.Set(
        natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->natural_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null natural_size in VideoDecoderConfig struct");

    decltype(Traits::aspect_ratio(input)) in_aspect_ratio = Traits::aspect_ratio(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aspect_ratio)::BaseType> aspect_ratio_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoAspectRatioDataView>(
      in_aspect_ratio,
      aspect_ratio_fragment);

    fragment->aspect_ratio.Set(
        aspect_ratio_fragment.is_null() ? nullptr : aspect_ratio_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->aspect_ratio.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null aspect_ratio in VideoDecoderConfig struct");

    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_data)::BaseType>
        extra_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_extra_data,
      extra_data_fragment,
      &extra_data_validate_params);

    fragment->extra_data.Set(
        extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extra_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra_data in VideoDecoderConfig struct");

    
    mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
      Traits::encryption_scheme(input),
      &fragment->encryption_scheme);

    decltype(Traits::color_space_info(input)) in_color_space_info = Traits::color_space_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space_info)::BaseType> color_space_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoColorSpaceDataView>(
      in_color_space_info,
      color_space_info_fragment);

    fragment->color_space_info.Set(
        color_space_info_fragment.is_null() ? nullptr : color_space_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_space_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_space_info in VideoDecoderConfig struct");

    decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HDRMetadataDataView>(
      in_hdr_metadata,
      hdr_metadata_fragment);

    fragment->hdr_metadata.Set(
        hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::VideoDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DecryptConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DecryptConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DecryptConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::EncryptionScheme>(
      Traits::encryption_scheme(input),
      &fragment->encryption_scheme);

    decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_id)::BaseType> key_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_key_id,
      key_id_fragment);

    fragment->key_id.Set(
        key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_id in DecryptConfig struct");

    decltype(Traits::iv(input)) in_iv = Traits::iv(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->iv)::BaseType> iv_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_iv,
      iv_fragment);

    fragment->iv.Set(
        iv_fragment.is_null() ? nullptr : iv_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->iv.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null iv in DecryptConfig struct");

    decltype(Traits::subsamples(input)) in_subsamples = Traits::subsamples(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subsamples)::BaseType>
        subsamples_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& subsamples_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::SubsampleEntryDataView>>(
      in_subsamples,
      subsamples_fragment,
      &subsamples_validate_params);

    fragment->subsamples.Set(
        subsamples_fragment.is_null() ? nullptr : subsamples_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subsamples.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subsamples in DecryptConfig struct");

    decltype(Traits::encryption_pattern(input)) in_encryption_pattern = Traits::encryption_pattern(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encryption_pattern)::BaseType> encryption_pattern_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::EncryptionPatternDataView>(
      in_encryption_pattern,
      encryption_pattern_fragment);

    fragment->encryption_pattern.Set(
        encryption_pattern_fragment.is_null() ? nullptr : encryption_pattern_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::DecryptConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DecryptConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DecoderBufferSideDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DecoderBufferSideDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DecoderBufferSideData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::spatial_layers(input)) in_spatial_layers = Traits::spatial_layers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->spatial_layers)::BaseType>
        spatial_layers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_spatial_layers,
      spatial_layers_fragment,
      &spatial_layers_validate_params);

    fragment->spatial_layers.Set(
        spatial_layers_fragment.is_null() ? nullptr : spatial_layers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->spatial_layers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null spatial_layers in DecoderBufferSideData struct");

    decltype(Traits::alpha_data(input)) in_alpha_data = Traits::alpha_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alpha_data)::BaseType>
        alpha_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alpha_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_alpha_data,
      alpha_data_fragment,
      &alpha_data_validate_params);

    fragment->alpha_data.Set(
        alpha_data_fragment.is_null() ? nullptr : alpha_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alpha_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alpha_data in DecoderBufferSideData struct");

    fragment->secure_handle = Traits::secure_handle(input);

    decltype(Traits::front_discard(input)) in_front_discard = Traits::front_discard(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->front_discard)::BaseType> front_discard_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_front_discard,
      front_discard_fragment);

    fragment->front_discard.Set(
        front_discard_fragment.is_null() ? nullptr : front_discard_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->front_discard.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null front_discard in DecoderBufferSideData struct");

    decltype(Traits::back_discard(input)) in_back_discard = Traits::back_discard(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->back_discard)::BaseType> back_discard_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_back_discard,
      back_discard_fragment);

    fragment->back_discard.Set(
        back_discard_fragment.is_null() ? nullptr : back_discard_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->back_discard.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null back_discard in DecoderBufferSideData struct");
  }

  static bool Deserialize(::media::mojom::internal::DecoderBufferSideData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DecoderBufferSideDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DataDecoderBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DataDecoderBufferDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DataDecoderBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in DataDecoderBuffer struct");

    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration,
      duration_fragment);

    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in DataDecoderBuffer struct");

    fragment->data_size = Traits::data_size(input);

    fragment->is_key_frame = Traits::is_key_frame(input);

    decltype(Traits::decrypt_config(input)) in_decrypt_config = Traits::decrypt_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->decrypt_config)::BaseType> decrypt_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::DecryptConfigDataView>(
      in_decrypt_config,
      decrypt_config_fragment);

    fragment->decrypt_config.Set(
        decrypt_config_fragment.is_null() ? nullptr : decrypt_config_fragment.data());

    decltype(Traits::side_data(input)) in_side_data = Traits::side_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->side_data)::BaseType> side_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::DecoderBufferSideDataDataView>(
      in_side_data,
      side_data_fragment);

    fragment->side_data.Set(
        side_data_fragment.is_null() ? nullptr : side_data_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::DataDecoderBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DataDecoderBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EosDecoderBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EosDecoderBufferDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EosDecoderBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::next_config(input)) in_next_config = Traits::next_config(input);
    mojo::internal::MessageFragment<decltype(fragment->next_config)>
        next_config_fragment(fragment.message());
    next_config_fragment.Claim(&fragment->next_config);
    
    mojo::internal::Serialize<::media::mojom::DecoderBufferSideDataNextConfigDataView>(
      in_next_config,
      next_config_fragment,
      true);
  }

  static bool Deserialize(::media::mojom::internal::EosDecoderBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::EosDecoderBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioBufferDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::SampleFormat>(
      Traits::sample_format(input),
      &fragment->sample_format);

    
    mojo::internal::Serialize<::media::mojom::ChannelLayout>(
      Traits::channel_layout(input),
      &fragment->channel_layout);

    fragment->channel_count = Traits::channel_count(input);

    fragment->sample_rate = Traits::sample_rate(input);

    fragment->frame_count = Traits::frame_count(input);

    fragment->end_of_stream = Traits::end_of_stream(input);

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in AudioBuffer struct");

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in AudioBuffer struct");
  }

  static bool Deserialize(::media::mojom::internal::AudioBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CaptureVersionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CaptureVersionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CaptureVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->source = Traits::source(input);

    fragment->sub_capture = Traits::sub_capture(input);
  }

  static bool Deserialize(::media::mojom::internal::CaptureVersion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CaptureVersionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoFrameMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoFrameMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoFrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->allow_overlay = Traits::allow_overlay(input);

    decltype(Traits::capture_begin_time(input)) in_capture_begin_time = Traits::capture_begin_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_begin_time)::BaseType> capture_begin_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_capture_begin_time,
      capture_begin_time_fragment);

    fragment->capture_begin_time.Set(
        capture_begin_time_fragment.is_null() ? nullptr : capture_begin_time_fragment.data());

    decltype(Traits::capture_end_time(input)) in_capture_end_time = Traits::capture_end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_end_time)::BaseType> capture_end_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_capture_end_time,
      capture_end_time_fragment);

    fragment->capture_end_time.Set(
        capture_end_time_fragment.is_null() ? nullptr : capture_end_time_fragment.data());

    fragment->has_capture_counter = Traits::has_capture_counter(input);

    fragment->capture_counter = Traits::capture_counter(input);

    decltype(Traits::capture_update_rect(input)) in_capture_update_rect = Traits::capture_update_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_update_rect)::BaseType> capture_update_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_capture_update_rect,
      capture_update_rect_fragment);

    fragment->capture_update_rect.Set(
        capture_update_rect_fragment.is_null() ? nullptr : capture_update_rect_fragment.data());

    decltype(Traits::source_size(input)) in_source_size = Traits::source_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_size)::BaseType> source_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_source_size,
      source_size_fragment);

    fragment->source_size.Set(
        source_size_fragment.is_null() ? nullptr : source_size_fragment.data());

    decltype(Traits::region_capture_rect(input)) in_region_capture_rect = Traits::region_capture_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->region_capture_rect)::BaseType> region_capture_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_region_capture_rect,
      region_capture_rect_fragment);

    fragment->region_capture_rect.Set(
        region_capture_rect_fragment.is_null() ? nullptr : region_capture_rect_fragment.data());

    decltype(Traits::capture_version(input)) in_capture_version = Traits::capture_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_version)::BaseType> capture_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::CaptureVersionDataView>(
      in_capture_version,
      capture_version_fragment);

    fragment->capture_version.Set(
        capture_version_fragment.is_null() ? nullptr : capture_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->capture_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capture_version in VideoFrameMetadata struct");

    fragment->copy_required = Traits::copy_required(input);

    fragment->end_of_stream = Traits::end_of_stream(input);

    decltype(Traits::frame_duration(input)) in_frame_duration = Traits::frame_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_duration)::BaseType> frame_duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_frame_duration,
      frame_duration_fragment);

    fragment->frame_duration.Set(
        frame_duration_fragment.is_null() ? nullptr : frame_duration_fragment.data());

    fragment->has_frame_rate = Traits::has_frame_rate(input);

    fragment->frame_rate = Traits::frame_rate(input);

    fragment->interactive_content = Traits::interactive_content(input);

    decltype(Traits::reference_time(input)) in_reference_time = Traits::reference_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reference_time)::BaseType> reference_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_reference_time,
      reference_time_fragment);

    fragment->reference_time.Set(
        reference_time_fragment.is_null() ? nullptr : reference_time_fragment.data());

    fragment->read_lock_fences_enabled = Traits::read_lock_fences_enabled(input);

    decltype(Traits::transformation(input)) in_transformation = Traits::transformation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transformation)::BaseType> transformation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoTransformationDataView>(
      in_transformation,
      transformation_fragment);

    fragment->transformation.Set(
        transformation_fragment.is_null() ? nullptr : transformation_fragment.data());

    fragment->in_surface_view = Traits::in_surface_view(input);

    fragment->wants_promotion_hint = Traits::wants_promotion_hint(input);

    fragment->protected_video = Traits::protected_video(input);

    fragment->hw_protected = Traits::hw_protected(input);

    fragment->needs_detiling = Traits::needs_detiling(input);

    fragment->is_webgpu_compatible = Traits::is_webgpu_compatible(input);

    decltype(Traits::tracking_token(input)) in_tracking_token = Traits::tracking_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracking_token)::BaseType> tracking_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_tracking_token,
      tracking_token_fragment);

    fragment->tracking_token.Set(
        tracking_token_fragment.is_null() ? nullptr : tracking_token_fragment.data());

    fragment->power_efficient = Traits::power_efficient(input);

    fragment->has_device_scale_factor = Traits::has_device_scale_factor(input);

    fragment->device_scale_factor = Traits::device_scale_factor(input);

    fragment->has_page_scale_factor = Traits::has_page_scale_factor(input);

    fragment->page_scale_factor = Traits::page_scale_factor(input);

    fragment->has_root_scroll_offset_x = Traits::has_root_scroll_offset_x(input);

    fragment->root_scroll_offset_x = Traits::root_scroll_offset_x(input);

    fragment->has_root_scroll_offset_y = Traits::has_root_scroll_offset_y(input);

    fragment->root_scroll_offset_y = Traits::root_scroll_offset_y(input);

    fragment->has_top_controls_visible_height = Traits::has_top_controls_visible_height(input);

    fragment->top_controls_visible_height = Traits::top_controls_visible_height(input);

    decltype(Traits::decode_begin_time(input)) in_decode_begin_time = Traits::decode_begin_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->decode_begin_time)::BaseType> decode_begin_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_decode_begin_time,
      decode_begin_time_fragment);

    fragment->decode_begin_time.Set(
        decode_begin_time_fragment.is_null() ? nullptr : decode_begin_time_fragment.data());

    decltype(Traits::decode_end_time(input)) in_decode_end_time = Traits::decode_end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->decode_end_time)::BaseType> decode_end_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_decode_end_time,
      decode_end_time_fragment);

    fragment->decode_end_time.Set(
        decode_end_time_fragment.is_null() ? nullptr : decode_end_time_fragment.data());

    decltype(Traits::processing_time(input)) in_processing_time = Traits::processing_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->processing_time)::BaseType> processing_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_processing_time,
      processing_time_fragment);

    fragment->processing_time.Set(
        processing_time_fragment.is_null() ? nullptr : processing_time_fragment.data());

    fragment->has_rtp_timestamp = Traits::has_rtp_timestamp(input);

    fragment->rtp_timestamp = Traits::rtp_timestamp(input);

    decltype(Traits::receive_time(input)) in_receive_time = Traits::receive_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->receive_time)::BaseType> receive_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_receive_time,
      receive_time_fragment);

    fragment->receive_time.Set(
        receive_time_fragment.is_null() ? nullptr : receive_time_fragment.data());

    decltype(Traits::wallclock_frame_duration(input)) in_wallclock_frame_duration = Traits::wallclock_frame_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wallclock_frame_duration)::BaseType> wallclock_frame_duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_wallclock_frame_duration,
      wallclock_frame_duration_fragment);

    fragment->wallclock_frame_duration.Set(
        wallclock_frame_duration_fragment.is_null() ? nullptr : wallclock_frame_duration_fragment.data());
    fragment->frame_sequence_$flag = Traits::frame_sequence(input).has_value();
    if (Traits::frame_sequence(input).has_value()) {
      fragment->frame_sequence_$value = Traits::frame_sequence(input).value();
    }
    fragment->source_id_$flag = Traits::source_id(input).has_value();
    if (Traits::source_id(input).has_value()) {
      fragment->source_id_$value = Traits::source_id(input).value();
    }

    
    mojo::internal::Serialize<::media::mojom::EffectState>(
      Traits::background_blur(input),
      &fragment->background_blur);
  }

  static bool Deserialize(::media::mojom::internal::VideoFrameMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoFrameMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
      Traits::format(input),
      &fragment->format);

    decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_coded_size,
      coded_size_fragment);

    fragment->coded_size.Set(
        coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->coded_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null coded_size in VideoFrame struct");

    decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_visible_rect,
      visible_rect_fragment);

    fragment->visible_rect.Set(
        visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_rect in VideoFrame struct");

    decltype(Traits::natural_size(input)) in_natural_size = Traits::natural_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->natural_size)::BaseType> natural_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_natural_size,
      natural_size_fragment);

    fragment->natural_size.Set(
        natural_size_fragment.is_null() ? nullptr : natural_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->natural_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null natural_size in VideoFrame struct");

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in VideoFrame struct");

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::media::mojom::VideoFrameDataDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in VideoFrame struct");

    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::VideoFrameMetadataDataView>(
      in_metadata,
      metadata_fragment);

    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->metadata.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in VideoFrame struct");

    decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space)::BaseType> color_space_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
      in_color_space,
      color_space_fragment);

    fragment->color_space.Set(
        color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_space.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_space in VideoFrame struct");

    decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HDRMetadataDataView>(
      in_hdr_metadata,
      hdr_metadata_fragment);

    fragment->hdr_metadata.Set(
        hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::VideoFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EosVideoFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EosVideoFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EosVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::media::mojom::internal::EosVideoFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::EosVideoFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SharedMemoryVideoFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SharedMemoryVideoFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SharedMemoryVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_data(input)) in_frame_data = Traits::frame_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_data)::BaseType> frame_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_frame_data,
      frame_data_fragment);

    fragment->frame_data.Set(
        frame_data_fragment.is_null() ? nullptr : frame_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_data in SharedMemoryVideoFrameData struct");

    decltype(Traits::strides(input)) in_strides = Traits::strides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->strides)::BaseType>
        strides_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& strides_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_strides,
      strides_fragment,
      &strides_validate_params);

    fragment->strides.Set(
        strides_fragment.is_null() ? nullptr : strides_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->strides.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null strides in SharedMemoryVideoFrameData struct");

    decltype(Traits::offsets(input)) in_offsets = Traits::offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offsets)::BaseType>
        offsets_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& offsets_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_offsets,
      offsets_fragment,
      &offsets_validate_params);

    fragment->offsets.Set(
        offsets_fragment.is_null() ? nullptr : offsets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->offsets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null offsets in SharedMemoryVideoFrameData struct");
  }

  static bool Deserialize(::media::mojom::internal::SharedMemoryVideoFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SharedMemoryVideoFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::GpuMemoryBufferSharedImageVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::gpu_memory_buffer_handle(input)) in_gpu_memory_buffer_handle = Traits::gpu_memory_buffer_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gpu_memory_buffer_handle)::BaseType> gpu_memory_buffer_handle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_gpu_memory_buffer_handle,
      gpu_memory_buffer_handle_fragment);

    fragment->gpu_memory_buffer_handle.Set(
        gpu_memory_buffer_handle_fragment.is_null() ? nullptr : gpu_memory_buffer_handle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gpu_memory_buffer_handle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gpu_memory_buffer_handle in GpuMemoryBufferSharedImageVideoFrameData struct");

    decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
      in_shared_image,
      shared_image_fragment);

    fragment->shared_image.Set(
        shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token,
      sync_token_fragment);

    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sync_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in GpuMemoryBufferSharedImageVideoFrameData struct");
  }

  static bool Deserialize(::media::mojom::internal::GpuMemoryBufferSharedImageVideoFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SharedImageVideoFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SharedImageVideoFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SharedImageVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
      in_shared_image,
      shared_image_fragment);

    fragment->shared_image.Set(
        shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shared_image.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_image in SharedImageVideoFrameData struct");

    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token,
      sync_token_fragment);

    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sync_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in SharedImageVideoFrameData struct");

    fragment->is_mappable_si_enabled = Traits::is_mappable_si_enabled(input);
  }

  static bool Deserialize(::media::mojom::internal::SharedImageVideoFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SharedImageVideoFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::OpaqueVideoFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::OpaqueVideoFrameDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::OpaqueVideoFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::media::mojom::internal::OpaqueVideoFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::OpaqueVideoFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PipelineStatisticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PipelineStatisticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PipelineStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->audio_bytes_decoded = Traits::audio_bytes_decoded(input);

    fragment->video_bytes_decoded = Traits::video_bytes_decoded(input);

    fragment->video_frames_decoded = Traits::video_frames_decoded(input);

    fragment->video_frames_dropped = Traits::video_frames_dropped(input);

    fragment->audio_memory_usage = Traits::audio_memory_usage(input);

    fragment->video_memory_usage = Traits::video_memory_usage(input);
  }

  static bool Deserialize(::media::mojom::internal::PipelineStatistics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PipelineStatisticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PredictionFeaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PredictionFeaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PredictionFeatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
      Traits::profile(input),
      &fragment->profile);

    decltype(Traits::video_size(input)) in_video_size = Traits::video_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->video_size)::BaseType> video_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_video_size,
      video_size_fragment);

    fragment->video_size.Set(
        video_size_fragment.is_null() ? nullptr : video_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->video_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null video_size in PredictionFeatures struct");

    fragment->frames_per_sec = Traits::frames_per_sec(input);

    decltype(Traits::key_system(input)) in_key_system = Traits::key_system(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_system)::BaseType> key_system_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key_system,
      key_system_fragment);

    fragment->key_system.Set(
        key_system_fragment.is_null() ? nullptr : key_system_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_system.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_system in PredictionFeatures struct");

    fragment->use_hw_secure_codecs = Traits::use_hw_secure_codecs(input);
  }

  static bool Deserialize(::media::mojom::internal::PredictionFeatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PredictionFeaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PredictionTargetsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PredictionTargetsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PredictionTargets_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->frames_decoded = Traits::frames_decoded(input);

    fragment->frames_dropped = Traits::frames_dropped(input);

    fragment->frames_power_efficient = Traits::frames_power_efficient(input);
  }

  static bool Deserialize(::media::mojom::internal::PredictionTargets_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PredictionTargetsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioPipelineInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioPipelineInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioPipelineInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::AudioDecoderType>(
      Traits::decoder_type(input),
      &fragment->decoder_type);

    fragment->is_platform_decoder = Traits::is_platform_decoder(input);

    fragment->has_decrypting_demuxer_stream = Traits::has_decrypting_demuxer_stream(input);

    
    mojo::internal::Serialize<::media::mojom::EncryptionType>(
      Traits::encryption_type(input),
      &fragment->encryption_type);
  }

  static bool Deserialize(::media::mojom::internal::AudioPipelineInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioPipelineInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoPipelineInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoPipelineInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoPipelineInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::VideoDecoderType>(
      Traits::decoder_type(input),
      &fragment->decoder_type);

    fragment->is_platform_decoder = Traits::is_platform_decoder(input);

    fragment->has_decrypting_demuxer_stream = Traits::has_decrypting_demuxer_stream(input);

    
    mojo::internal::Serialize<::media::mojom::EncryptionType>(
      Traits::encryption_type(input),
      &fragment->encryption_type);
  }

  static bool Deserialize(::media::mojom::internal::VideoPipelineInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoPipelineInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::StatusDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::StatusDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::StatusData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::group(input)) in_group = Traits::group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group)::BaseType> group_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group,
      group_fragment);

    fragment->group.Set(
        group_fragment.is_null() ? nullptr : group_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group in StatusData struct");

    fragment->code = Traits::code(input);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in StatusData struct");

    decltype(Traits::frames(input)) in_frames = Traits::frames(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frames)::BaseType> frames_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_frames,
      frames_fragment);

    fragment->frames.Set(
        frames_fragment.is_null() ? nullptr : frames_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frames.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frames in StatusData struct");

    decltype(Traits::cause(input)) in_cause = Traits::cause(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cause)::BaseType> cause_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::StatusDataDataView>(
      in_cause,
      cause_fragment);

    fragment->cause.Set(
        cause_fragment.is_null() ? nullptr : cause_fragment.data());

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in StatusData struct");
  }

  static bool Deserialize(::media::mojom::internal::StatusData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::StatusDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EncoderStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EncoderStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EncoderStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::internal(input)) in_internal = Traits::internal(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->internal)::BaseType> internal_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::StatusDataDataView>(
      in_internal,
      internal_fragment);

    fragment->internal.Set(
        internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::EncoderStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::EncoderStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DecoderStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::DecoderStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::DecoderStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::internal(input)) in_internal = Traits::internal(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->internal)::BaseType> internal_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::StatusDataDataView>(
      in_internal,
      internal_fragment);

    fragment->internal.Set(
        internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::DecoderStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DecoderStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PipelineStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PipelineStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PipelineStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::internal(input)) in_internal = Traits::internal(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->internal)::BaseType> internal_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::media::mojom::StatusDataDataView>(
      in_internal,
      internal_fragment);

    fragment->internal.Set(
        internal_fragment.is_null() ? nullptr : internal_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::PipelineStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PipelineStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AutoPipInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AutoPipInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AutoPipInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media::mojom::AutoPipReason>(
      Traits::auto_pip_reason(input),
      &fragment->auto_pip_reason);

    fragment->has_audio_focus = Traits::has_audio_focus(input);

    fragment->is_playing = Traits::is_playing(input);

    fragment->was_recently_audible = Traits::was_recently_audible(input);

    fragment->has_safe_url = Traits::has_safe_url(input);

    fragment->meets_media_engagement_conditions = Traits::meets_media_engagement_conditions(input);

    fragment->blocked_due_to_content_setting = Traits::blocked_due_to_content_setting(input);
  }

  static bool Deserialize(::media::mojom::internal::AutoPipInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AutoPipInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DecoderBufferSideDataNextConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::DecoderBufferSideDataNextConfigDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::DecoderBufferSideDataNextConfig_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::DecoderBufferSideDataNextConfigDataView::Tag::kNextAudioConfig: {
    decltype(Traits::next_audio_config(input))
    in_next_audio_config = Traits::next_audio_config(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_next_audio_config)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::AudioDecoderConfigDataView>(
  in_next_audio_config,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null next_audio_config in DecoderBufferSideDataNextConfig union");
    fragment->data.f_next_audio_config.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::DecoderBufferSideDataNextConfigDataView::Tag::kNextVideoConfig: {
    decltype(Traits::next_video_config(input))
    in_next_video_config = Traits::next_video_config(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_next_video_config)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::VideoDecoderConfigDataView>(
  in_next_video_config,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null next_video_config in DecoderBufferSideDataNextConfig union");
    fragment->data.f_next_video_config.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::media::mojom::internal::DecoderBufferSideDataNextConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DecoderBufferSideDataNextConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::DecoderBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::DecoderBufferDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::DecoderBuffer_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::DecoderBufferDataView::Tag::kEos: {
    decltype(Traits::eos(input))
    in_eos = Traits::eos(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_eos)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::EosDecoderBufferDataView>(
  in_eos,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null eos in DecoderBuffer union");
    fragment->data.f_eos.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::DecoderBufferDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::DataDecoderBufferDataView>(
  in_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in DecoderBuffer union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::media::mojom::internal::DecoderBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::DecoderBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoFrameDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::VideoFrameDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::VideoFrameData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media::mojom::VideoFrameDataDataView::Tag::kEosData: {
    decltype(Traits::eos_data(input))
    in_eos_data = Traits::eos_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_eos_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::EosVideoFrameDataDataView>(
  in_eos_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null eos_data in VideoFrameData union");
    fragment->data.f_eos_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kSharedMemoryData: {
    decltype(Traits::shared_memory_data(input))
    in_shared_memory_data = Traits::shared_memory_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_memory_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::SharedMemoryVideoFrameDataDataView>(
  in_shared_memory_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_memory_data in VideoFrameData union");
    fragment->data.f_shared_memory_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kGpuMemoryBufferSharedImageData: {
    decltype(Traits::gpu_memory_buffer_shared_image_data(input))
    in_gpu_memory_buffer_shared_image_data = Traits::gpu_memory_buffer_shared_image_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_gpu_memory_buffer_shared_image_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::GpuMemoryBufferSharedImageVideoFrameDataDataView>(
  in_gpu_memory_buffer_shared_image_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null gpu_memory_buffer_shared_image_data in VideoFrameData union");
    fragment->data.f_gpu_memory_buffer_shared_image_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kSharedImageData: {
    decltype(Traits::shared_image_data(input))
    in_shared_image_data = Traits::shared_image_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_image_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::SharedImageVideoFrameDataDataView>(
  in_shared_image_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_image_data in VideoFrameData union");
    fragment->data.f_shared_image_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media::mojom::VideoFrameDataDataView::Tag::kOpaqueData: {
    decltype(Traits::opaque_data(input))
    in_opaque_data = Traits::opaque_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_opaque_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media::mojom::OpaqueVideoFrameDataDataView>(
  in_opaque_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null opaque_data in VideoFrameData union");
    fragment->data.f_opaque_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::media::mojom::internal::VideoFrameData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoFrameDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {







inline void AudioDecoderConfigDataView::GetExtraDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->extra_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void AudioDecoderConfigDataView::GetSeekPrerollDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_preroll.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void VideoDecoderConfigDataView::GetTransformationDataView(
    VideoTransformationDataView* output) {
  auto pointer = data_->transformation.Get();
  *output = VideoTransformationDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetCodedSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetNaturalSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->natural_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetAspectRatioDataView(
    VideoAspectRatioDataView* output) {
  auto pointer = data_->aspect_ratio.Get();
  *output = VideoAspectRatioDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetExtraDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->extra_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetColorSpaceInfoDataView(
    VideoColorSpaceDataView* output) {
  auto pointer = data_->color_space_info.Get();
  *output = VideoColorSpaceDataView(pointer, message_);
}
inline void VideoDecoderConfigDataView::GetHdrMetadataDataView(
    ::gfx::mojom::HDRMetadataDataView* output) {
  auto pointer = data_->hdr_metadata.Get();
  *output = ::gfx::mojom::HDRMetadataDataView(pointer, message_);
}


inline void DecryptConfigDataView::GetKeyIdDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->key_id.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void DecryptConfigDataView::GetIvDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->iv.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void DecryptConfigDataView::GetSubsamplesDataView(
    mojo::ArrayDataView<SubsampleEntryDataView>* output) {
  auto pointer = data_->subsamples.Get();
  *output = mojo::ArrayDataView<SubsampleEntryDataView>(pointer, message_);
}
inline void DecryptConfigDataView::GetEncryptionPatternDataView(
    ::media::mojom::EncryptionPatternDataView* output) {
  auto pointer = data_->encryption_pattern.Get();
  *output = ::media::mojom::EncryptionPatternDataView(pointer, message_);
}


inline void DecoderBufferSideDataDataView::GetSpatialLayersDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->spatial_layers.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void DecoderBufferSideDataDataView::GetAlphaDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->alpha_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void DecoderBufferSideDataDataView::GetFrontDiscardDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->front_discard.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DecoderBufferSideDataDataView::GetBackDiscardDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->back_discard.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void DataDecoderBufferDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DataDecoderBufferDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DataDecoderBufferDataView::GetDecryptConfigDataView(
    DecryptConfigDataView* output) {
  auto pointer = data_->decrypt_config.Get();
  *output = DecryptConfigDataView(pointer, message_);
}
inline void DataDecoderBufferDataView::GetSideDataDataView(
    DecoderBufferSideDataDataView* output) {
  auto pointer = data_->side_data.Get();
  *output = DecoderBufferSideDataDataView(pointer, message_);
}


inline void EosDecoderBufferDataView::GetNextConfigDataView(
    DecoderBufferSideDataNextConfigDataView* output) {
  auto pointer = &data_->next_config;
  *output = DecoderBufferSideDataNextConfigDataView(pointer, message_);
}


inline void AudioBufferDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void AudioBufferDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void VideoFrameMetadataDataView::GetCaptureBeginTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->capture_begin_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetCaptureEndTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->capture_end_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetCaptureUpdateRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->capture_update_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetSourceSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->source_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetRegionCaptureRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->region_capture_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetCaptureVersionDataView(
    CaptureVersionDataView* output) {
  auto pointer = data_->capture_version.Get();
  *output = CaptureVersionDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetFrameDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->frame_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetReferenceTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->reference_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetTransformationDataView(
    VideoTransformationDataView* output) {
  auto pointer = data_->transformation.Get();
  *output = VideoTransformationDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetTrackingTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->tracking_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetDecodeBeginTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->decode_begin_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetDecodeEndTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->decode_end_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetProcessingTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->processing_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetReceiveTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->receive_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void VideoFrameMetadataDataView::GetWallclockFrameDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->wallclock_frame_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void VideoFrameDataView::GetCodedSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoFrameDataView::GetVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoFrameDataView::GetNaturalSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->natural_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoFrameDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void VideoFrameDataView::GetDataDataView(
    VideoFrameDataDataView* output) {
  auto pointer = &data_->data;
  *output = VideoFrameDataDataView(pointer, message_);
}
inline void VideoFrameDataView::GetMetadataDataView(
    VideoFrameMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = VideoFrameMetadataDataView(pointer, message_);
}
inline void VideoFrameDataView::GetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}
inline void VideoFrameDataView::GetHdrMetadataDataView(
    ::gfx::mojom::HDRMetadataDataView* output) {
  auto pointer = data_->hdr_metadata.Get();
  *output = ::gfx::mojom::HDRMetadataDataView(pointer, message_);
}




inline void SharedMemoryVideoFrameDataDataView::GetFrameDataDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->frame_data.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void SharedMemoryVideoFrameDataDataView::GetStridesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->strides.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void SharedMemoryVideoFrameDataDataView::GetOffsetsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->offsets.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}


inline void GpuMemoryBufferSharedImageVideoFrameDataDataView::GetGpuMemoryBufferHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) {
  auto pointer = data_->gpu_memory_buffer_handle.Get();
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(pointer, message_);
}
inline void GpuMemoryBufferSharedImageVideoFrameDataDataView::GetSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void GpuMemoryBufferSharedImageVideoFrameDataDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}


inline void SharedImageVideoFrameDataDataView::GetSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void SharedImageVideoFrameDataDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}






inline void PredictionFeaturesDataView::GetVideoSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->video_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PredictionFeaturesDataView::GetKeySystemDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key_system.Get();
  *output = mojo::StringDataView(pointer, message_);
}








inline void StatusDataDataView::GetGroupDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StatusDataDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StatusDataDataView::GetFramesDataView(
    ::mojo_base::mojom::ListValueDataView* output) {
  auto pointer = data_->frames.Get();
  *output = ::mojo_base::mojom::ListValueDataView(pointer, message_);
}
inline void StatusDataDataView::GetCauseDataView(
    StatusDataDataView* output) {
  auto pointer = data_->cause.Get();
  *output = StatusDataDataView(pointer, message_);
}
inline void StatusDataDataView::GetDataDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}


inline void EncoderStatusDataView::GetInternalDataView(
    StatusDataDataView* output) {
  auto pointer = data_->internal.Get();
  *output = StatusDataDataView(pointer, message_);
}


inline void DecoderStatusDataView::GetInternalDataView(
    StatusDataDataView* output) {
  auto pointer = data_->internal.Get();
  *output = StatusDataDataView(pointer, message_);
}


inline void PipelineStatusDataView::GetInternalDataView(
    StatusDataDataView* output) {
  auto pointer = data_->internal.Get();
  *output = StatusDataDataView(pointer, message_);
}




inline void DecoderBufferSideDataNextConfigDataView::GetNextAudioConfigDataView(
    AudioDecoderConfigDataView* output) const {
  CHECK(is_next_audio_config());
  *output = AudioDecoderConfigDataView(data_->data.f_next_audio_config.Get(), message_);
}
inline void DecoderBufferSideDataNextConfigDataView::GetNextVideoConfigDataView(
    VideoDecoderConfigDataView* output) const {
  CHECK(is_next_video_config());
  *output = VideoDecoderConfigDataView(data_->data.f_next_video_config.Get(), message_);
}

inline void DecoderBufferDataView::GetEosDataView(
    EosDecoderBufferDataView* output) const {
  CHECK(is_eos());
  *output = EosDecoderBufferDataView(data_->data.f_eos.Get(), message_);
}
inline void DecoderBufferDataView::GetDataDataView(
    DataDecoderBufferDataView* output) const {
  CHECK(is_data());
  *output = DataDecoderBufferDataView(data_->data.f_data.Get(), message_);
}

inline void VideoFrameDataDataView::GetEosDataDataView(
    EosVideoFrameDataDataView* output) const {
  CHECK(is_eos_data());
  *output = EosVideoFrameDataDataView(data_->data.f_eos_data.Get(), message_);
}
inline void VideoFrameDataDataView::GetSharedMemoryDataDataView(
    SharedMemoryVideoFrameDataDataView* output) const {
  CHECK(is_shared_memory_data());
  *output = SharedMemoryVideoFrameDataDataView(data_->data.f_shared_memory_data.Get(), message_);
}
inline void VideoFrameDataDataView::GetGpuMemoryBufferSharedImageDataDataView(
    GpuMemoryBufferSharedImageVideoFrameDataDataView* output) const {
  CHECK(is_gpu_memory_buffer_shared_image_data());
  *output = GpuMemoryBufferSharedImageVideoFrameDataDataView(data_->data.f_gpu_memory_buffer_shared_image_data.Get(), message_);
}
inline void VideoFrameDataDataView::GetSharedImageDataDataView(
    SharedImageVideoFrameDataDataView* output) const {
  CHECK(is_shared_image_data());
  *output = SharedImageVideoFrameDataDataView(data_->data.f_shared_image_data.Get(), message_);
}
inline void VideoFrameDataDataView::GetOpaqueDataDataView(
    OpaqueVideoFrameDataDataView* output) const {
  CHECK(is_opaque_data());
  *output = OpaqueVideoFrameDataDataView(data_->data.f_opaque_data.Get(), message_);
}


}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoRotation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoRotation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::EncryptionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::EncryptionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SVCScalabilityMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SVCScalabilityMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SVCInterLayerPredMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SVCInterLayerPredMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CdmSessionClosedReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CdmSessionClosedReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::EffectState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::EffectState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::MediaStreamType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::MediaStreamType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::InputStreamErrorCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::InputStreamErrorCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RendererType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RendererType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::DemuxerType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::DemuxerType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CreateCdmStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CreateCdmStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::AutoPipReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::AutoPipReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::VideoAspectRatio_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::VideoAspectRatio_Type value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_H_