// media/mojo/mojom/media_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/media_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_types.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* VideoRotationToStringHelper(VideoRotation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoRotation::kVideoRotation0:
      return "kVideoRotation0";
    case VideoRotation::kVideoRotation90:
      return "kVideoRotation90";
    case VideoRotation::kVideoRotation180:
      return "kVideoRotation180";
    case VideoRotation::kVideoRotation270:
      return "kVideoRotation270";
    default:
      return nullptr;
  }
}

std::string VideoRotationToString(VideoRotation value) {
  const char *str = VideoRotationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoRotation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoRotation value) {
  return os << VideoRotationToString(value);
}

NOINLINE static const char* EncryptionTypeToStringHelper(EncryptionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EncryptionType::kNone:
      return "kNone";
    case EncryptionType::kClear:
      return "kClear";
    case EncryptionType::kEncrypted:
      return "kEncrypted";
    case EncryptionType::kEncryptedWithClearLead:
      return "kEncryptedWithClearLead";
    default:
      return nullptr;
  }
}

std::string EncryptionTypeToString(EncryptionType value) {
  const char *str = EncryptionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EncryptionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EncryptionType value) {
  return os << EncryptionTypeToString(value);
}

NOINLINE static const char* SVCScalabilityModeToStringHelper(SVCScalabilityMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SVCScalabilityMode::kUnsupportedMode:
      return "kUnsupportedMode";
    case SVCScalabilityMode::kL1T1:
      return "kL1T1";
    case SVCScalabilityMode::kL1T2:
      return "kL1T2";
    case SVCScalabilityMode::kL1T3:
      return "kL1T3";
    case SVCScalabilityMode::kL2T1:
      return "kL2T1";
    case SVCScalabilityMode::kL2T2:
      return "kL2T2";
    case SVCScalabilityMode::kL2T3:
      return "kL2T3";
    case SVCScalabilityMode::kL3T1:
      return "kL3T1";
    case SVCScalabilityMode::kL3T2:
      return "kL3T2";
    case SVCScalabilityMode::kL3T3:
      return "kL3T3";
    case SVCScalabilityMode::kL2T1Key:
      return "kL2T1Key";
    case SVCScalabilityMode::kL2T2Key:
      return "kL2T2Key";
    case SVCScalabilityMode::kL2T3Key:
      return "kL2T3Key";
    case SVCScalabilityMode::kL3T1Key:
      return "kL3T1Key";
    case SVCScalabilityMode::kL3T2Key:
      return "kL3T2Key";
    case SVCScalabilityMode::kL3T3Key:
      return "kL3T3Key";
    case SVCScalabilityMode::kS2T1:
      return "kS2T1";
    case SVCScalabilityMode::kS2T2:
      return "kS2T2";
    case SVCScalabilityMode::kS2T3:
      return "kS2T3";
    case SVCScalabilityMode::kS3T1:
      return "kS3T1";
    case SVCScalabilityMode::kS3T2:
      return "kS3T2";
    case SVCScalabilityMode::kS3T3:
      return "kS3T3";
    default:
      return nullptr;
  }
}

std::string SVCScalabilityModeToString(SVCScalabilityMode value) {
  const char *str = SVCScalabilityModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SVCScalabilityMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SVCScalabilityMode value) {
  return os << SVCScalabilityModeToString(value);
}

NOINLINE static const char* SVCInterLayerPredModeToStringHelper(SVCInterLayerPredMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SVCInterLayerPredMode::kOff:
      return "kOff";
    case SVCInterLayerPredMode::kOn:
      return "kOn";
    case SVCInterLayerPredMode::kOnKeyPic:
      return "kOnKeyPic";
    default:
      return nullptr;
  }
}

std::string SVCInterLayerPredModeToString(SVCInterLayerPredMode value) {
  const char *str = SVCInterLayerPredModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SVCInterLayerPredMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SVCInterLayerPredMode value) {
  return os << SVCInterLayerPredModeToString(value);
}

NOINLINE static const char* CdmSessionClosedReasonToStringHelper(CdmSessionClosedReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CdmSessionClosedReason::kInternalError:
      return "kInternalError";
    case CdmSessionClosedReason::kClose:
      return "kClose";
    case CdmSessionClosedReason::kReleaseAcknowledged:
      return "kReleaseAcknowledged";
    case CdmSessionClosedReason::kHardwareContextReset:
      return "kHardwareContextReset";
    case CdmSessionClosedReason::kResourceEvicted:
      return "kResourceEvicted";
    default:
      return nullptr;
  }
}

std::string CdmSessionClosedReasonToString(CdmSessionClosedReason value) {
  const char *str = CdmSessionClosedReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CdmSessionClosedReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CdmSessionClosedReason value) {
  return os << CdmSessionClosedReasonToString(value);
}

NOINLINE static const char* EffectStateToStringHelper(EffectState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EffectState::kUnknown:
      return "kUnknown";
    case EffectState::kDisabled:
      return "kDisabled";
    case EffectState::kEnabled:
      return "kEnabled";
    default:
      return nullptr;
  }
}

std::string EffectStateToString(EffectState value) {
  const char *str = EffectStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EffectState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EffectState value) {
  return os << EffectStateToString(value);
}

NOINLINE static const char* MediaStreamTypeToStringHelper(MediaStreamType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaStreamType::kLocalElementCapture:
      return "kLocalElementCapture";
    case MediaStreamType::kLocalDeviceCapture:
      return "kLocalDeviceCapture";
    case MediaStreamType::kLocalTabCapture:
      return "kLocalTabCapture";
    case MediaStreamType::kLocalDesktopCapture:
      return "kLocalDesktopCapture";
    case MediaStreamType::kLocalDisplayCapture:
      return "kLocalDisplayCapture";
    case MediaStreamType::kRemote:
      return "kRemote";
    case MediaStreamType::kNone:
      return "kNone";
    default:
      return nullptr;
  }
}

std::string MediaStreamTypeToString(MediaStreamType value) {
  const char *str = MediaStreamTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaStreamType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaStreamType value) {
  return os << MediaStreamTypeToString(value);
}

NOINLINE static const char* InputStreamErrorCodeToStringHelper(InputStreamErrorCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputStreamErrorCode::kUnknown:
      return "kUnknown";
    case InputStreamErrorCode::kSystemPermissions:
      return "kSystemPermissions";
    case InputStreamErrorCode::kDeviceInUse:
      return "kDeviceInUse";
    default:
      return nullptr;
  }
}

std::string InputStreamErrorCodeToString(InputStreamErrorCode value) {
  const char *str = InputStreamErrorCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputStreamErrorCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputStreamErrorCode value) {
  return os << InputStreamErrorCodeToString(value);
}

NOINLINE static const char* RendererTypeToStringHelper(RendererType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RendererType::kRendererImpl:
      return "kRendererImpl";
    case RendererType::kMojo:
      return "kMojo";
    case RendererType::kCourier:
      return "kCourier";
    case RendererType::kFlinging:
      return "kFlinging";
    case RendererType::kCast:
      return "kCast";
    case RendererType::kMediaFoundation:
      return "kMediaFoundation";
    case RendererType::kRemoting:
      return "kRemoting";
    case RendererType::kCastStreaming:
      return "kCastStreaming";
    case RendererType::kContentEmbedderDefined:
      return "kContentEmbedderDefined";
    case RendererType::kTest:
      return "kTest";
    default:
      return nullptr;
  }
}

std::string RendererTypeToString(RendererType value) {
  const char *str = RendererTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RendererType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RendererType value) {
  return os << RendererTypeToString(value);
}

NOINLINE static const char* DemuxerTypeToStringHelper(DemuxerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DemuxerType::kUnknownDemuxer:
      return "kUnknownDemuxer";
    case DemuxerType::kMockDemuxer:
      return "kMockDemuxer";
    case DemuxerType::kFFmpegDemuxer:
      return "kFFmpegDemuxer";
    case DemuxerType::kChunkDemuxer:
      return "kChunkDemuxer";
    case DemuxerType::kFrameInjectingDemuxer:
      return "kFrameInjectingDemuxer";
    case DemuxerType::kStreamProviderDemuxer:
      return "kStreamProviderDemuxer";
    case DemuxerType::kManifestDemuxer:
      return "kManifestDemuxer";
    default:
      return nullptr;
  }
}

std::string DemuxerTypeToString(DemuxerType value) {
  const char *str = DemuxerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DemuxerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DemuxerType value) {
  return os << DemuxerTypeToString(value);
}

NOINLINE static const char* CreateCdmStatusToStringHelper(CreateCdmStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateCdmStatus::kSuccess:
      return "kSuccess";
    case CreateCdmStatus::kUnknownError:
      return "kUnknownError";
    case CreateCdmStatus::kCdmCreationAborted:
      return "kCdmCreationAborted";
    case CreateCdmStatus::kCreateCdmFuncNotAvailable:
      return "kCreateCdmFuncNotAvailable";
    case CreateCdmStatus::kCdmHelperCreationFailed:
      return "kCdmHelperCreationFailed";
    case CreateCdmStatus::kGetCdmPrefDataFailed:
      return "kGetCdmPrefDataFailed";
    case CreateCdmStatus::kGetCdmOriginIdFailed:
      return "kGetCdmOriginIdFailed";
    case CreateCdmStatus::kInitCdmFailed:
      return "kInitCdmFailed";
    case CreateCdmStatus::kCdmFactoryCreationFailed:
      return "kCdmFactoryCreationFailed";
    case CreateCdmStatus::kCdmNotSupported:
      return "kCdmNotSupported";
    case CreateCdmStatus::kInvalidCdmConfig:
      return "kInvalidCdmConfig";
    case CreateCdmStatus::kUnsupportedKeySystem:
      return "kUnsupportedKeySystem";
    case CreateCdmStatus::kDisconnectionError:
      return "kDisconnectionError";
    case CreateCdmStatus::kNotAllowedOnUniqueOrigin:
      return "kNotAllowedOnUniqueOrigin";
    case CreateCdmStatus::kMediaCryptoNotAvailable:
      return "kMediaCryptoNotAvailable";
    case CreateCdmStatus::kNoMoreInstances:
      return "kNoMoreInstances";
    case CreateCdmStatus::kInsufficientGpuResources:
      return "kInsufficientGpuResources";
    case CreateCdmStatus::kCrOsVerifiedAccessDisabled:
      return "kCrOsVerifiedAccessDisabled";
    case CreateCdmStatus::kCrOsRemoteFactoryCreationFailed:
      return "kCrOsRemoteFactoryCreationFailed";
    case CreateCdmStatus::kAndroidMediaDrmIllegalArgument:
      return "kAndroidMediaDrmIllegalArgument";
    case CreateCdmStatus::kAndroidMediaDrmIllegalState:
      return "kAndroidMediaDrmIllegalState";
    case CreateCdmStatus::kAndroidFailedL1SecurityLevel:
      return "kAndroidFailedL1SecurityLevel";
    case CreateCdmStatus::kAndroidFailedL3SecurityLevel:
      return "kAndroidFailedL3SecurityLevel";
    case CreateCdmStatus::kAndroidFailedSecurityOrigin:
      return "kAndroidFailedSecurityOrigin";
    case CreateCdmStatus::kAndroidFailedMediaCryptoSession:
      return "kAndroidFailedMediaCryptoSession";
    case CreateCdmStatus::kAndroidFailedToStartProvisioning:
      return "kAndroidFailedToStartProvisioning";
    case CreateCdmStatus::kAndroidFailedMediaCryptoCreate:
      return "kAndroidFailedMediaCryptoCreate";
    case CreateCdmStatus::kAndroidUnsupportedMediaCryptoScheme:
      return "kAndroidUnsupportedMediaCryptoScheme";
    default:
      return nullptr;
  }
}

std::string CreateCdmStatusToString(CreateCdmStatus value) {
  const char *str = CreateCdmStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateCdmStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateCdmStatus value) {
  return os << CreateCdmStatusToString(value);
}

NOINLINE static const char* AutoPipReasonToStringHelper(AutoPipReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AutoPipReason::kUnknown:
      return "kUnknown";
    case AutoPipReason::kVideoConferencing:
      return "kVideoConferencing";
    case AutoPipReason::kMediaPlayback:
      return "kMediaPlayback";
    case AutoPipReason::kBrowserInitiated:
      return "kBrowserInitiated";
    default:
      return nullptr;
  }
}

std::string AutoPipReasonToString(AutoPipReason value) {
  const char *str = AutoPipReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AutoPipReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AutoPipReason value) {
  return os << AutoPipReasonToString(value);
}

NOINLINE static const char* VideoAspectRatio_TypeToStringHelper(VideoAspectRatio_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoAspectRatio_Type::kDisplay:
      return "kDisplay";
    case VideoAspectRatio_Type::kPixel:
      return "kPixel";
    default:
      return nullptr;
  }
}

std::string VideoAspectRatio_TypeToString(VideoAspectRatio_Type value) {
  const char *str = VideoAspectRatio_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoAspectRatio_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoAspectRatio_Type value) {
  return os << VideoAspectRatio_TypeToString(value);
}

namespace internal {
// static
bool DecoderBufferSideDataNextConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DecoderBufferSideDataNextConfig_Data* object = static_cast<const DecoderBufferSideDataNextConfig_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DecoderBufferSideDataNextConfig_Tag::kNextAudioConfig: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_next_audio_config, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_next_audio_config, validation_context))
        return false;
      return true;
    }
    case DecoderBufferSideDataNextConfig_Tag::kNextVideoConfig: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_next_video_config, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_next_video_config, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DecoderBufferSideDataNextConfig");
      return false;
    }
  }
}
// static
bool DecoderBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DecoderBuffer_Data* object = static_cast<const DecoderBuffer_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DecoderBuffer_Tag::kEos: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_eos, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_eos, validation_context))
        return false;
      return true;
    }
    case DecoderBuffer_Tag::kData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DecoderBuffer");
      return false;
    }
  }
}
// static
bool VideoFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const VideoFrameData_Data* object = static_cast<const VideoFrameData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case VideoFrameData_Tag::kEosData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_eos_data, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_eos_data, validation_context))
        return false;
      return true;
    }
    case VideoFrameData_Tag::kSharedMemoryData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_memory_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_memory_data, validation_context))
        return false;
      return true;
    }
    case VideoFrameData_Tag::kGpuMemoryBufferSharedImageData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gpu_memory_buffer_shared_image_data, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gpu_memory_buffer_shared_image_data, validation_context))
        return false;
      return true;
    }
    case VideoFrameData_Tag::kSharedImageData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_image_data, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_image_data, validation_context))
        return false;
      return true;
    }
    case VideoFrameData_Tag::kOpaqueData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_opaque_data, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_opaque_data, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in VideoFrameData");
      return false;
    }
  }
}


// static
bool VideoTransformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoTransformation_Data* object =
      static_cast<const VideoTransformation_Data*>(data);


  if (!::media::mojom::internal::VideoRotation_Data
        ::Validate(object->rotation, validation_context))
    return false;

  return true;
}

VideoTransformation_Data::VideoTransformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoAspectRatio_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoAspectRatio_Data* object =
      static_cast<const VideoAspectRatio_Data*>(data);


  if (!::media::mojom::internal::VideoAspectRatio_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

VideoAspectRatio_Data::VideoAspectRatio_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoColorSpace_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoColorSpace_Data* object =
      static_cast<const VideoColorSpace_Data*>(data);


  if (!::media::mojom::internal::VideoColorSpace_PrimaryID_Data
        ::Validate(object->primaries, validation_context))
    return false;


  if (!::media::mojom::internal::VideoColorSpace_TransferID_Data
        ::Validate(object->transfer, validation_context))
    return false;


  if (!::media::mojom::internal::VideoColorSpace_MatrixID_Data
        ::Validate(object->matrix, validation_context))
    return false;


  if (!::media::mojom::internal::VideoColorSpace_RangeID_Data
        ::Validate(object->range, validation_context))
    return false;

  return true;
}

VideoColorSpace_Data::VideoColorSpace_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioDecoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioDecoderConfig_Data* object =
      static_cast<const AudioDecoderConfig_Data*>(data);


  if (!::media::mojom::internal::AudioCodec_Data
        ::Validate(object->codec, validation_context))
    return false;


  if (!::media::mojom::internal::SampleFormat_Data
        ::Validate(object->sample_format, validation_context))
    return false;


  if (!::media::mojom::internal::ChannelLayout_Data
        ::Validate(object->channel_layout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::EncryptionScheme_Data
        ::Validate(object->encryption_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_preroll, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_preroll, validation_context))
    return false;


  if (!::media::mojom::internal::AudioCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;


  if (!::media::mojom::internal::ChannelLayout_Data
        ::Validate(object->target_output_channel_layout, validation_context))
    return false;


  if (!::media::mojom::internal::SampleFormat_Data
        ::Validate(object->target_output_sample_format, validation_context))
    return false;

  return true;
}

AudioDecoderConfig_Data::AudioDecoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoDecoderConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoDecoderConfig_Data* object =
      static_cast<const VideoDecoderConfig_Data*>(data);


  if (!::media::mojom::internal::VideoCodec_Data
        ::Validate(object->codec, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transformation, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transformation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->natural_size, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->natural_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aspect_ratio, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aspect_ratio, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extra_data, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extra_data, validation_context,
                                         &extra_data_validate_params)) {
    return false;
  }


  if (!::media::mojom::internal::EncryptionScheme_Data
        ::Validate(object->encryption_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space_info, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hdr_metadata, validation_context))
    return false;

  return true;
}

VideoDecoderConfig_Data::VideoDecoderConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DecryptConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DecryptConfig_Data* object =
      static_cast<const DecryptConfig_Data*>(data);


  if (!::media::mojom::internal::EncryptionScheme_Data
        ::Validate(object->encryption_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->iv, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->iv, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subsamples, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subsamples_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subsamples, validation_context,
                                         &subsamples_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->encryption_pattern, validation_context))
    return false;

  return true;
}

DecryptConfig_Data::DecryptConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DecoderBufferSideData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DecoderBufferSideData_Data* object =
      static_cast<const DecoderBufferSideData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spatial_layers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& spatial_layers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->spatial_layers, validation_context,
                                         &spatial_layers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpha_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alpha_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alpha_data, validation_context,
                                         &alpha_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->front_discard, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->front_discard, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->back_discard, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->back_discard, validation_context))
    return false;

  return true;
}

DecoderBufferSideData_Data::DecoderBufferSideData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataDecoderBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataDecoderBuffer_Data* object =
      static_cast<const DataDecoderBuffer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->decrypt_config, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->side_data, validation_context))
    return false;

  return true;
}

DataDecoderBuffer_Data::DataDecoderBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EosDecoderBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EosDecoderBuffer_Data* object =
      static_cast<const EosDecoderBuffer_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->next_config, validation_context))
    return false;

  return true;
}

EosDecoderBuffer_Data::EosDecoderBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioBuffer_Data* object =
      static_cast<const AudioBuffer_Data*>(data);


  if (!::media::mojom::internal::SampleFormat_Data
        ::Validate(object->sample_format, validation_context))
    return false;


  if (!::media::mojom::internal::ChannelLayout_Data
        ::Validate(object->channel_layout, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

AudioBuffer_Data::AudioBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CaptureVersion_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CaptureVersion_Data* object =
      static_cast<const CaptureVersion_Data*>(data);

  return true;
}

CaptureVersion_Data::CaptureVersion_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrameMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 216, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameMetadata_Data* object =
      static_cast<const VideoFrameMetadata_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->capture_begin_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->capture_end_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->capture_update_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->region_capture_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capture_version, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capture_version, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_duration, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reference_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->transformation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tracking_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->decode_begin_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->decode_end_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->processing_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->receive_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->wallclock_frame_duration, validation_context))
    return false;


  if (!::media::mojom::internal::EffectState_Data
        ::Validate(object->background_blur, validation_context))
    return false;

  return true;
}

VideoFrameMetadata_Data::VideoFrameMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrame_Data* object =
      static_cast<const VideoFrame_Data*>(data);


  if (!::media::mojom::internal::VideoPixelFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->natural_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->natural_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hdr_metadata, validation_context))
    return false;

  return true;
}

VideoFrame_Data::VideoFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EosVideoFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EosVideoFrameData_Data* object =
      static_cast<const EosVideoFrameData_Data*>(data);

  return true;
}

EosVideoFrameData_Data::EosVideoFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedMemoryVideoFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedMemoryVideoFrameData_Data* object =
      static_cast<const SharedMemoryVideoFrameData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->strides, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& strides_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->strides, validation_context,
                                         &strides_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offsets, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& offsets_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->offsets, validation_context,
                                         &offsets_validate_params)) {
    return false;
  }

  return true;
}

SharedMemoryVideoFrameData_Data::SharedMemoryVideoFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuMemoryBufferSharedImageVideoFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuMemoryBufferSharedImageVideoFrameData_Data* object =
      static_cast<const GpuMemoryBufferSharedImageVideoFrameData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_memory_buffer_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_memory_buffer_handle, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

GpuMemoryBufferSharedImageVideoFrameData_Data::GpuMemoryBufferSharedImageVideoFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedImageVideoFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedImageVideoFrameData_Data* object =
      static_cast<const SharedImageVideoFrameData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

SharedImageVideoFrameData_Data::SharedImageVideoFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OpaqueVideoFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OpaqueVideoFrameData_Data* object =
      static_cast<const OpaqueVideoFrameData_Data*>(data);

  return true;
}

OpaqueVideoFrameData_Data::OpaqueVideoFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PipelineStatistics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PipelineStatistics_Data* object =
      static_cast<const PipelineStatistics_Data*>(data);

  return true;
}

PipelineStatistics_Data::PipelineStatistics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PredictionFeatures_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PredictionFeatures_Data* object =
      static_cast<const PredictionFeatures_Data*>(data);


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->video_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_system, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_system_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key_system, validation_context,
                                         &key_system_validate_params)) {
    return false;
  }

  return true;
}

PredictionFeatures_Data::PredictionFeatures_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PredictionTargets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PredictionTargets_Data* object =
      static_cast<const PredictionTargets_Data*>(data);

  return true;
}

PredictionTargets_Data::PredictionTargets_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioPipelineInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioPipelineInfo_Data* object =
      static_cast<const AudioPipelineInfo_Data*>(data);


  if (!::media::mojom::internal::AudioDecoderType_Data
        ::Validate(object->decoder_type, validation_context))
    return false;


  if (!::media::mojom::internal::EncryptionType_Data
        ::Validate(object->encryption_type, validation_context))
    return false;

  return true;
}

AudioPipelineInfo_Data::AudioPipelineInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoPipelineInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoPipelineInfo_Data* object =
      static_cast<const VideoPipelineInfo_Data*>(data);


  if (!::media::mojom::internal::VideoDecoderType_Data
        ::Validate(object->decoder_type, validation_context))
    return false;


  if (!::media::mojom::internal::EncryptionType_Data
        ::Validate(object->encryption_type, validation_context))
    return false;

  return true;
}

VideoPipelineInfo_Data::VideoPipelineInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StatusData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StatusData_Data* object =
      static_cast<const StatusData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group, validation_context,
                                         &group_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frames, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frames, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cause, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

StatusData_Data::StatusData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EncoderStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EncoderStatus_Data* object =
      static_cast<const EncoderStatus_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->internal, validation_context))
    return false;

  return true;
}

EncoderStatus_Data::EncoderStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DecoderStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DecoderStatus_Data* object =
      static_cast<const DecoderStatus_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->internal, validation_context))
    return false;

  return true;
}

DecoderStatus_Data::DecoderStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PipelineStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PipelineStatus_Data* object =
      static_cast<const PipelineStatus_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->internal, validation_context))
    return false;

  return true;
}

PipelineStatus_Data::PipelineStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AutoPipInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AutoPipInfo_Data* object =
      static_cast<const AutoPipInfo_Data*>(data);


  if (!::media::mojom::internal::AutoPipReason_Data
        ::Validate(object->auto_pip_reason, validation_context))
    return false;

  return true;
}

AutoPipInfo_Data::AutoPipInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoRotation>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoRotation value) {
  return std::move(context).WriteString(::media::mojom::VideoRotationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::EncryptionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::EncryptionType value) {
  return std::move(context).WriteString(::media::mojom::EncryptionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::SVCScalabilityMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::SVCScalabilityMode value) {
  return std::move(context).WriteString(::media::mojom::SVCScalabilityModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::SVCInterLayerPredMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::SVCInterLayerPredMode value) {
  return std::move(context).WriteString(::media::mojom::SVCInterLayerPredModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CdmSessionClosedReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::CdmSessionClosedReason value) {
  return std::move(context).WriteString(::media::mojom::CdmSessionClosedReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::EffectState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::EffectState value) {
  return std::move(context).WriteString(::media::mojom::EffectStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::MediaStreamType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::MediaStreamType value) {
  return std::move(context).WriteString(::media::mojom::MediaStreamTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::InputStreamErrorCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::InputStreamErrorCode value) {
  return std::move(context).WriteString(::media::mojom::InputStreamErrorCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RendererType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RendererType value) {
  return std::move(context).WriteString(::media::mojom::RendererTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::DemuxerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::DemuxerType value) {
  return std::move(context).WriteString(::media::mojom::DemuxerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::CreateCdmStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::CreateCdmStatus value) {
  return std::move(context).WriteString(::media::mojom::CreateCdmStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::AutoPipReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::AutoPipReason value) {
  return std::move(context).WriteString(::media::mojom::AutoPipReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoAspectRatio_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoAspectRatio_Type value) {
  return std::move(context).WriteString(::media::mojom::VideoAspectRatio_TypeToString(value));
}

} // namespace perfetto