// media/mojo/mojom/media_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('sandbox.mojom.Sandbox');
goog.require('media.mojom.FrameInterfaceFactory');
goog.require('media.mojom.InterfaceFactory');



goog.provide('media.mojom.MEDIA_SANDBOX');
/**
 * @const { !sandbox.mojom.Sandbox }
 * @export
 */
media.mojom.MEDIA_SANDBOX = sandbox.mojom.Sandbox.kGpu;



goog.provide('media.mojom.MediaService');
goog.provide('media.mojom.MediaServiceReceiver');
goog.provide('media.mojom.MediaServiceCallbackRouter');
goog.provide('media.mojom.MediaServiceInterface');
goog.provide('media.mojom.MediaServiceRemote');
goog.provide('media.mojom.MediaServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.MediaServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.MediaService.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.MediaServiceInterface = class {
  
  /**
   * @param { !media.mojom.InterfaceFactoryPendingReceiver } factory
   * @param { !media.mojom.FrameInterfaceFactoryRemote } frameInterfaces
   */

  createInterfaceFactory(factory, frameInterfaces) {}
};

/**
 * @export
 * @implements { media.mojom.MediaServiceInterface }
 */
media.mojom.MediaServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.MediaServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.MediaServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.MediaServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.InterfaceFactoryPendingReceiver } factory
   * @param { !media.mojom.FrameInterfaceFactoryRemote } frameInterfaces
   */

  createInterfaceFactory(
      factory,
      frameInterfaces) {
    this.proxy.sendMessage(
        0,
        media.mojom.MediaService_CreateInterfaceFactory_ParamsSpec.$,
        null,
        [
          factory,
          frameInterfaces
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.MediaServiceReceiver = class {
  /**
   * @param {!media.mojom.MediaServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.MediaServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.MediaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.MediaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.MediaService_CreateInterfaceFactory_ParamsSpec.$,
        null,
        impl.createInterfaceFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.MediaService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.MediaService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.MediaServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.MediaServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.MediaServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.MediaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.MediaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createInterfaceFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.MediaService_CreateInterfaceFactory_ParamsSpec.$,
        null,
        this.createInterfaceFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.MediaService_CreateInterfaceFactory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.MediaService_CreateInterfaceFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.MediaService_CreateInterfaceFactory_ParamsSpec.$,
    'MediaService_CreateInterfaceFactory_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.InterfaceRequest(media.mojom.InterfaceFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'frameInterfaces', 4,
        0,
        mojo.internal.InterfaceProxy(media.mojom.FrameInterfaceFactoryRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.MediaService_CreateInterfaceFactory_Params');

/** @record */
media.mojom.MediaService_CreateInterfaceFactory_Params = class {
  constructor() {
    /** @export { !media.mojom.InterfaceFactoryPendingReceiver } */
    this.factory;
    /** @export { !media.mojom.FrameInterfaceFactoryRemote } */
    this.frameInterfaces;
  }
};

