// media/mojo/mojom/frame_interface_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_H_
#define MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/frame_interface_factory.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/frame_interface_factory.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/frame_interface_factory.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/cdm_storage.mojom-forward.h"
#include "media/mojo/mojom/provision_fetcher.mojom-forward.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class FrameInterfaceFactoryProxy;

template <typename ImplRefTraits>
class FrameInterfaceFactoryStub;

class FrameInterfaceFactoryRequestValidator;
class FrameInterfaceFactoryResponseValidator;


class FrameInterfaceFactory
    : public FrameInterfaceFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.FrameInterfaceFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    2
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameInterfaceFactoryInterfaceBase;
  using Proxy_ = FrameInterfaceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameInterfaceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = FrameInterfaceFactoryRequestValidator;
  using ResponseValidator_ = FrameInterfaceFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateProvisionFetcherMinVersion = 0,
    kCreateCdmStorageMinVersion = 0,
    kGetCdmOriginMinVersion = 0,
    kBindEmbedderReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateProvisionFetcher_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCdmStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCdmOrigin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindEmbedderReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameInterfaceFactory() = default;

  virtual void CreateProvisionFetcher(::mojo::PendingReceiver<::media::mojom::ProvisionFetcher> provision_fetcher) = 0;

  virtual void CreateCdmStorage(::mojo::PendingReceiver<::media::mojom::CdmStorage> cdm_storage) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCdmOrigin(::url::Origin* out_cdm_origin);
  using GetCdmOriginCallback = base::OnceCallback<void(const ::url::Origin&)>;
  using GetCdmOriginMojoCallback = base::OnceCallback<void(const ::url::Origin&)>;

  virtual void GetCdmOrigin(GetCdmOriginCallback callback) = 0;

  virtual void BindEmbedderReceiver(::mojo::GenericPendingReceiver receiver) = 0;
};



class  FrameInterfaceFactoryProxy
    : public FrameInterfaceFactory {
 public:
  using InterfaceType = FrameInterfaceFactory;

  explicit FrameInterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateProvisionFetcher(::mojo::PendingReceiver<::media::mojom::ProvisionFetcher> provision_fetcher) final;
  
  void CreateCdmStorage(::mojo::PendingReceiver<::media::mojom::CdmStorage> cdm_storage) final;
  
  bool GetCdmOrigin(::url::Origin* out_cdm_origin) final;
  
  void GetCdmOrigin(GetCdmOriginCallback callback) final;
  
  void BindEmbedderReceiver(::mojo::GenericPendingReceiver receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameInterfaceFactoryStubDispatch {
 public:
  static bool Accept(FrameInterfaceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameInterfaceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameInterfaceFactory>>
class FrameInterfaceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameInterfaceFactoryStub() = default;
  ~FrameInterfaceFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameInterfaceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameInterfaceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameInterfaceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameInterfaceFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_H_