// media/mojo/mojom/decryptor.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.AudioBuffer');
goog.require('media.mojom.AudioDecoderConfig');
goog.require('media.mojom.VideoDecoderConfig');
goog.require('media.mojom.VideoFrame');
goog.require('media.mojom.DecoderBuffer');






goog.provide('media.mojom.Decryptor');
goog.provide('media.mojom.DecryptorReceiver');
goog.provide('media.mojom.DecryptorCallbackRouter');
goog.provide('media.mojom.DecryptorInterface');
goog.provide('media.mojom.DecryptorRemote');
goog.provide('media.mojom.DecryptorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.DecryptorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.Decryptor.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.DecryptorInterface = class {
  
  /**
   * @param { !MojoHandle } audioPipe
   * @param { !MojoHandle } videoPipe
   * @param { !MojoHandle } decryptPipe
   * @param { !MojoHandle } decryptedPipe
   */

  initialize(audioPipe, videoPipe, decryptPipe, decryptedPipe) {}
  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   * @param { !media.mojom.DecoderBuffer } encrypted
   * @return {!Promise<{
        status: !media.mojom.Decryptor_Status,
        buffer: ?media.mojom.DecoderBuffer,
   *  }>}
   */

  decrypt(streamType, encrypted) {}
  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   */

  cancelDecrypt(streamType) {}
  
  /**
   * @param { !media.mojom.AudioDecoderConfig } config
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeAudioDecoder(config) {}
  
  /**
   * @param { !media.mojom.VideoDecoderConfig } config
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeVideoDecoder(config) {}
  
  /**
   * @param { !media.mojom.DecoderBuffer } encrypted
   * @return {!Promise<{
        status: !media.mojom.Decryptor_Status,
        audioBuffers: !Array<!media.mojom.AudioBuffer>,
   *  }>}
   */

  decryptAndDecodeAudio(encrypted) {}
  
  /**
   * @param { !media.mojom.DecoderBuffer } encrypted
   * @return {!Promise<{
        status: !media.mojom.Decryptor_Status,
        videoFrame: ?media.mojom.VideoFrame,
        releaser: ?media.mojom.FrameResourceReleaserRemote,
   *  }>}
   */

  decryptAndDecodeVideo(encrypted) {}
  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   */

  resetDecoder(streamType) {}
  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   */

  deinitializeDecoder(streamType) {}
};

/**
 * @export
 * @implements { media.mojom.DecryptorInterface }
 */
media.mojom.DecryptorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.DecryptorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.DecryptorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.DecryptorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MojoHandle } audioPipe
   * @param { !MojoHandle } videoPipe
   * @param { !MojoHandle } decryptPipe
   * @param { !MojoHandle } decryptedPipe
   */

  initialize(
      audioPipe,
      videoPipe,
      decryptPipe,
      decryptedPipe) {
    this.proxy.sendMessage(
        0,
        media.mojom.Decryptor_Initialize_ParamsSpec.$,
        null,
        [
          audioPipe,
          videoPipe,
          decryptPipe,
          decryptedPipe
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   * @param { !media.mojom.DecoderBuffer } encrypted
   * @return {!Promise<{
        status: !media.mojom.Decryptor_Status,
        buffer: ?media.mojom.DecoderBuffer,
   *  }>}
   */

  decrypt(
      streamType,
      encrypted) {
    return this.proxy.sendMessage(
        1,
        media.mojom.Decryptor_Decrypt_ParamsSpec.$,
        media.mojom.Decryptor_Decrypt_ResponseParamsSpec.$,
        [
          streamType,
          encrypted
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   */

  cancelDecrypt(
      streamType) {
    this.proxy.sendMessage(
        2,
        media.mojom.Decryptor_CancelDecrypt_ParamsSpec.$,
        null,
        [
          streamType
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.AudioDecoderConfig } config
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeAudioDecoder(
      config) {
    return this.proxy.sendMessage(
        3,
        media.mojom.Decryptor_InitializeAudioDecoder_ParamsSpec.$,
        media.mojom.Decryptor_InitializeAudioDecoder_ResponseParamsSpec.$,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.VideoDecoderConfig } config
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeVideoDecoder(
      config) {
    return this.proxy.sendMessage(
        4,
        media.mojom.Decryptor_InitializeVideoDecoder_ParamsSpec.$,
        media.mojom.Decryptor_InitializeVideoDecoder_ResponseParamsSpec.$,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.DecoderBuffer } encrypted
   * @return {!Promise<{
        status: !media.mojom.Decryptor_Status,
        audioBuffers: !Array<!media.mojom.AudioBuffer>,
   *  }>}
   */

  decryptAndDecodeAudio(
      encrypted) {
    return this.proxy.sendMessage(
        5,
        media.mojom.Decryptor_DecryptAndDecodeAudio_ParamsSpec.$,
        media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParamsSpec.$,
        [
          encrypted
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.DecoderBuffer } encrypted
   * @return {!Promise<{
        status: !media.mojom.Decryptor_Status,
        videoFrame: ?media.mojom.VideoFrame,
        releaser: ?media.mojom.FrameResourceReleaserRemote,
   *  }>}
   */

  decryptAndDecodeVideo(
      encrypted) {
    return this.proxy.sendMessage(
        6,
        media.mojom.Decryptor_DecryptAndDecodeVideo_ParamsSpec.$,
        media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParamsSpec.$,
        [
          encrypted
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   */

  resetDecoder(
      streamType) {
    this.proxy.sendMessage(
        7,
        media.mojom.Decryptor_ResetDecoder_ParamsSpec.$,
        null,
        [
          streamType
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.Decryptor_StreamType } streamType
   */

  deinitializeDecoder(
      streamType) {
    this.proxy.sendMessage(
        8,
        media.mojom.Decryptor_DeinitializeDecoder_ParamsSpec.$,
        null,
        [
          streamType
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Decryptor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.DecryptorReceiver = class {
  /**
   * @param {!media.mojom.DecryptorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.DecryptorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.DecryptorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.DecryptorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.Decryptor_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.Decryptor_Decrypt_ParamsSpec.$,
        media.mojom.Decryptor_Decrypt_ResponseParamsSpec.$,
        impl.decrypt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.Decryptor_CancelDecrypt_ParamsSpec.$,
        null,
        impl.cancelDecrypt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.Decryptor_InitializeAudioDecoder_ParamsSpec.$,
        media.mojom.Decryptor_InitializeAudioDecoder_ResponseParamsSpec.$,
        impl.initializeAudioDecoder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.Decryptor_InitializeVideoDecoder_ParamsSpec.$,
        media.mojom.Decryptor_InitializeVideoDecoder_ResponseParamsSpec.$,
        impl.initializeVideoDecoder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.Decryptor_DecryptAndDecodeAudio_ParamsSpec.$,
        media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParamsSpec.$,
        impl.decryptAndDecodeAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.Decryptor_DecryptAndDecodeVideo_ParamsSpec.$,
        media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParamsSpec.$,
        impl.decryptAndDecodeVideo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.Decryptor_ResetDecoder_ParamsSpec.$,
        null,
        impl.resetDecoder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        media.mojom.Decryptor_DeinitializeDecoder_ParamsSpec.$,
        null,
        impl.deinitializeDecoder.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.Decryptor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.Decryptor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.DecryptorRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.DecryptorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};

goog.provide('media.mojom.Decryptor_Status');
goog.provide('media.mojom.Decryptor.StatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.Decryptor.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.Decryptor_Status = {
  
};
goog.provide('media.mojom.Decryptor_StreamType');
goog.provide('media.mojom.Decryptor.StreamTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.Decryptor.StreamTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.Decryptor_StreamType = {
  
};

/**
 * An object which receives request messages for the Decryptor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.DecryptorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.DecryptorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.DecryptorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.Decryptor_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decrypt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.Decryptor_Decrypt_ParamsSpec.$,
        media.mojom.Decryptor_Decrypt_ResponseParamsSpec.$,
        this.decrypt.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelDecrypt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.Decryptor_CancelDecrypt_ParamsSpec.$,
        null,
        this.cancelDecrypt.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeAudioDecoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.Decryptor_InitializeAudioDecoder_ParamsSpec.$,
        media.mojom.Decryptor_InitializeAudioDecoder_ResponseParamsSpec.$,
        this.initializeAudioDecoder.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeVideoDecoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.Decryptor_InitializeVideoDecoder_ParamsSpec.$,
        media.mojom.Decryptor_InitializeVideoDecoder_ResponseParamsSpec.$,
        this.initializeVideoDecoder.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decryptAndDecodeAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.Decryptor_DecryptAndDecodeAudio_ParamsSpec.$,
        media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParamsSpec.$,
        this.decryptAndDecodeAudio.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decryptAndDecodeVideo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.Decryptor_DecryptAndDecodeVideo_ParamsSpec.$,
        media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParamsSpec.$,
        this.decryptAndDecodeVideo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetDecoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.Decryptor_ResetDecoder_ParamsSpec.$,
        null,
        this.resetDecoder.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deinitializeDecoder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        media.mojom.Decryptor_DeinitializeDecoder_ParamsSpec.$,
        null,
        this.deinitializeDecoder.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.FrameResourceReleaser');
goog.provide('media.mojom.FrameResourceReleaserReceiver');
goog.provide('media.mojom.FrameResourceReleaserCallbackRouter');
goog.provide('media.mojom.FrameResourceReleaserInterface');
goog.provide('media.mojom.FrameResourceReleaserRemote');
goog.provide('media.mojom.FrameResourceReleaserPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.FrameResourceReleaserPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.FrameResourceReleaser.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.FrameResourceReleaserInterface = class {
};

/**
 * @export
 * @implements { media.mojom.FrameResourceReleaserInterface }
 */
media.mojom.FrameResourceReleaserRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.FrameResourceReleaserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.FrameResourceReleaserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.FrameResourceReleaserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the FrameResourceReleaser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.FrameResourceReleaserReceiver = class {
  /**
   * @param {!media.mojom.FrameResourceReleaserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.FrameResourceReleaserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.FrameResourceReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.FrameResourceReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.FrameResourceReleaser = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.FrameResourceReleaser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.FrameResourceReleaserRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.FrameResourceReleaserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FrameResourceReleaser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.FrameResourceReleaserCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.FrameResourceReleaserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.FrameResourceReleaserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.Decryptor_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_Decrypt_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_Decrypt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_Decrypt_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_Decrypt_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_CancelDecrypt_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_CancelDecrypt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_InitializeAudioDecoder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_InitializeAudioDecoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_InitializeAudioDecoder_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_InitializeAudioDecoder_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_InitializeVideoDecoder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_InitializeVideoDecoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_InitializeVideoDecoder_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_InitializeVideoDecoder_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_DecryptAndDecodeAudio_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_DecryptAndDecodeAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_DecryptAndDecodeVideo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_DecryptAndDecodeVideo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_ResetDecoder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_ResetDecoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.Decryptor_DeinitializeDecoder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.Decryptor_DeinitializeDecoder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.Decryptor_Initialize_ParamsSpec.$,
    'Decryptor_Initialize_Params',
    [
      mojo.internal.StructField(
        'audioPipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoPipe', 4,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decryptPipe', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decryptedPipe', 12,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.Decryptor_Initialize_Params');

/** @record */
media.mojom.Decryptor_Initialize_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.audioPipe;
    /** @export { !MojoHandle } */
    this.videoPipe;
    /** @export { !MojoHandle } */
    this.decryptPipe;
    /** @export { !MojoHandle } */
    this.decryptedPipe;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_Decrypt_ParamsSpec.$,
    'Decryptor_Decrypt_Params',
    [
      mojo.internal.StructField(
        'streamType', 0,
        0,
        media.mojom.Decryptor.StreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encrypted', 8,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.Decryptor_Decrypt_Params');

/** @record */
media.mojom.Decryptor_Decrypt_Params = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_StreamType } */
    this.streamType;
    /** @export { !media.mojom.DecoderBuffer } */
    this.encrypted;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_Decrypt_ResponseParamsSpec.$,
    'Decryptor_Decrypt_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.Decryptor.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.Decryptor_Decrypt_ResponseParams');

/** @record */
media.mojom.Decryptor_Decrypt_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_Status } */
    this.status;
    /** @export { (media.mojom.DecoderBuffer|undefined) } */
    this.buffer;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_CancelDecrypt_ParamsSpec.$,
    'Decryptor_CancelDecrypt_Params',
    [
      mojo.internal.StructField(
        'streamType', 0,
        0,
        media.mojom.Decryptor.StreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_CancelDecrypt_Params');

/** @record */
media.mojom.Decryptor_CancelDecrypt_Params = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_StreamType } */
    this.streamType;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_InitializeAudioDecoder_ParamsSpec.$,
    'Decryptor_InitializeAudioDecoder_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.AudioDecoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_InitializeAudioDecoder_Params');

/** @record */
media.mojom.Decryptor_InitializeAudioDecoder_Params = class {
  constructor() {
    /** @export { !media.mojom.AudioDecoderConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_InitializeAudioDecoder_ResponseParamsSpec.$,
    'Decryptor_InitializeAudioDecoder_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_InitializeAudioDecoder_ResponseParams');

/** @record */
media.mojom.Decryptor_InitializeAudioDecoder_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_InitializeVideoDecoder_ParamsSpec.$,
    'Decryptor_InitializeVideoDecoder_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        media.mojom.VideoDecoderConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_InitializeVideoDecoder_Params');

/** @record */
media.mojom.Decryptor_InitializeVideoDecoder_Params = class {
  constructor() {
    /** @export { !media.mojom.VideoDecoderConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_InitializeVideoDecoder_ResponseParamsSpec.$,
    'Decryptor_InitializeVideoDecoder_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_InitializeVideoDecoder_ResponseParams');

/** @record */
media.mojom.Decryptor_InitializeVideoDecoder_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_DecryptAndDecodeAudio_ParamsSpec.$,
    'Decryptor_DecryptAndDecodeAudio_Params',
    [
      mojo.internal.StructField(
        'encrypted', 0,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.Decryptor_DecryptAndDecodeAudio_Params');

/** @record */
media.mojom.Decryptor_DecryptAndDecodeAudio_Params = class {
  constructor() {
    /** @export { !media.mojom.DecoderBuffer } */
    this.encrypted;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParamsSpec.$,
    'Decryptor_DecryptAndDecodeAudio_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.Decryptor.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioBuffers', 8,
        0,
        mojo.internal.Array(media.mojom.AudioBufferSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParams');

/** @record */
media.mojom.Decryptor_DecryptAndDecodeAudio_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_Status } */
    this.status;
    /** @export { !Array<!media.mojom.AudioBuffer> } */
    this.audioBuffers;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_DecryptAndDecodeVideo_ParamsSpec.$,
    'Decryptor_DecryptAndDecodeVideo_Params',
    [
      mojo.internal.StructField(
        'encrypted', 0,
        0,
        media.mojom.DecoderBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.Decryptor_DecryptAndDecodeVideo_Params');

/** @record */
media.mojom.Decryptor_DecryptAndDecodeVideo_Params = class {
  constructor() {
    /** @export { !media.mojom.DecoderBuffer } */
    this.encrypted;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParamsSpec.$,
    'Decryptor_DecryptAndDecodeVideo_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        media.mojom.Decryptor.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoFrame', 8,
        0,
        media.mojom.VideoFrameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'releaser', 16,
        0,
        mojo.internal.InterfaceProxy(media.mojom.FrameResourceReleaserRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParams');

/** @record */
media.mojom.Decryptor_DecryptAndDecodeVideo_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_Status } */
    this.status;
    /** @export { (media.mojom.VideoFrame|undefined) } */
    this.videoFrame;
    /** @export { (media.mojom.FrameResourceReleaserRemote|undefined) } */
    this.releaser;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_ResetDecoder_ParamsSpec.$,
    'Decryptor_ResetDecoder_Params',
    [
      mojo.internal.StructField(
        'streamType', 0,
        0,
        media.mojom.Decryptor.StreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_ResetDecoder_Params');

/** @record */
media.mojom.Decryptor_ResetDecoder_Params = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_StreamType } */
    this.streamType;
  }
};



mojo.internal.Struct(
    media.mojom.Decryptor_DeinitializeDecoder_ParamsSpec.$,
    'Decryptor_DeinitializeDecoder_Params',
    [
      mojo.internal.StructField(
        'streamType', 0,
        0,
        media.mojom.Decryptor.StreamTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.Decryptor_DeinitializeDecoder_Params');

/** @record */
media.mojom.Decryptor_DeinitializeDecoder_Params = class {
  constructor() {
    /** @export { !media.mojom.Decryptor_StreamType } */
    this.streamType;
  }
};

