// media/mojo/mojom/content_decryption_module.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('media.mojom.CdmSessionClosedReason');
goog.require('media.mojom.CreateCdmStatus');
goog.require('media.mojom.Decryptor');
goog.require('mojoBase.mojom.UnguessableToken');




goog.provide('media.mojom.EmeInitDataType');
goog.provide('media.mojom.EmeInitDataTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.EmeInitDataTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.EmeInitDataType = {
  
};

goog.provide('media.mojom.CdmSessionType');
goog.provide('media.mojom.CdmSessionTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmSessionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmSessionType = {
  
};

goog.provide('media.mojom.CdmMessageType');
goog.provide('media.mojom.CdmMessageTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmMessageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmMessageType = {
  
};

goog.provide('media.mojom.CdmKeyStatus');
goog.provide('media.mojom.CdmKeyStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmKeyStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmKeyStatus = {
  
  USABLE: 0,
  INTERNAL_ERROR: 1,
  EXPIRED: 2,
  OUTPUT_RESTRICTED: 3,
  OUTPUT_DOWNSCALED: 4,
  KEY_STATUS_PENDING: 5,
  RELEASED: 6,
  USABLE_IN_FUTURE: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('media.mojom.HdcpVersion');
goog.provide('media.mojom.HdcpVersionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.HdcpVersionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.HdcpVersion = {
  
};



goog.provide('media.mojom.ContentDecryptionModule');
goog.provide('media.mojom.ContentDecryptionModuleReceiver');
goog.provide('media.mojom.ContentDecryptionModuleCallbackRouter');
goog.provide('media.mojom.ContentDecryptionModuleInterface');
goog.provide('media.mojom.ContentDecryptionModuleRemote');
goog.provide('media.mojom.ContentDecryptionModulePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.ContentDecryptionModulePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.ContentDecryptionModule.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.ContentDecryptionModuleInterface = class {
  
  /**
   * @param { !Object } client
   */

  setClient(client) {}
  
  /**
   * @param { !Array<!number> } certificateData
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  setServerCertificate(certificateData) {}
  
  /**
   * @param { !media.mojom.HdcpVersion } minHdcpVersion
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
        keyStatus: !media.mojom.CdmKeyStatus,
   *  }>}
   */

  getStatusForPolicy(minHdcpVersion) {}
  
  /**
   * @param { !media.mojom.CdmSessionType } sessionType
   * @param { !media.mojom.EmeInitDataType } initDataType
   * @param { !Array<!number> } initData
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  createSessionAndGenerateRequest(sessionType, initDataType, initData) {}
  
  /**
   * @param { !media.mojom.CdmSessionType } sessionType
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  loadSession(sessionType, sessionId) {}
  
  /**
   * @param { !string } sessionId
   * @param { !Array<!number> } response
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  updateSession(sessionId, response) {}
  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  closeSession(sessionId) {}
  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  removeSession(sessionId) {}
};

/**
 * @export
 * @implements { media.mojom.ContentDecryptionModuleInterface }
 */
media.mojom.ContentDecryptionModuleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.ContentDecryptionModulePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.ContentDecryptionModulePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.ContentDecryptionModulePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        media.mojom.ContentDecryptionModule_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } certificateData
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  setServerCertificate(
      certificateData) {
    return this.proxy.sendMessage(
        1,
        media.mojom.ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
        [
          certificateData
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.HdcpVersion } minHdcpVersion
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
        keyStatus: !media.mojom.CdmKeyStatus,
   *  }>}
   */

  getStatusForPolicy(
      minHdcpVersion) {
    return this.proxy.sendMessage(
        2,
        media.mojom.ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
        [
          minHdcpVersion
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.CdmSessionType } sessionType
   * @param { !media.mojom.EmeInitDataType } initDataType
   * @param { !Array<!number> } initData
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  createSessionAndGenerateRequest(
      sessionType,
      initDataType,
      initData) {
    return this.proxy.sendMessage(
        3,
        media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
        [
          sessionType,
          initDataType,
          initData
        ],
        false);
  }

  
  /**
   * @param { !media.mojom.CdmSessionType } sessionType
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
        sessionId: !string,
   *  }>}
   */

  loadSession(
      sessionType,
      sessionId) {
    return this.proxy.sendMessage(
        4,
        media.mojom.ContentDecryptionModule_LoadSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
        [
          sessionType,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !Array<!number> } response
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  updateSession(
      sessionId,
      response) {
    return this.proxy.sendMessage(
        5,
        media.mojom.ContentDecryptionModule_UpdateSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
        [
          sessionId,
          response
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  closeSession(
      sessionId) {
    return this.proxy.sendMessage(
        6,
        media.mojom.ContentDecryptionModule_CloseSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
        [
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @return {!Promise<{
        result: !media.mojom.CdmPromiseResult,
   *  }>}
   */

  removeSession(
      sessionId) {
    return this.proxy.sendMessage(
        7,
        media.mojom.ContentDecryptionModule_RemoveSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
        [
          sessionId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContentDecryptionModule
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.ContentDecryptionModuleReceiver = class {
  /**
   * @param {!media.mojom.ContentDecryptionModuleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.ContentDecryptionModuleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.ContentDecryptionModuleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.ContentDecryptionModuleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.ContentDecryptionModule_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
        impl.setServerCertificate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
        impl.getStatusForPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
        impl.createSessionAndGenerateRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        media.mojom.ContentDecryptionModule_LoadSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
        impl.loadSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        media.mojom.ContentDecryptionModule_UpdateSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
        impl.updateSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        media.mojom.ContentDecryptionModule_CloseSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
        impl.closeSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        media.mojom.ContentDecryptionModule_RemoveSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
        impl.removeSession.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.ContentDecryptionModule = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.ContentDecryptionModule";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.ContentDecryptionModuleRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.ContentDecryptionModuleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ContentDecryptionModule
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.ContentDecryptionModuleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.ContentDecryptionModuleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.ContentDecryptionModuleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.ContentDecryptionModule_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setServerCertificate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
        this.setServerCertificate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStatusForPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
        this.getStatusForPolicy.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createSessionAndGenerateRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
        this.createSessionAndGenerateRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.loadSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        media.mojom.ContentDecryptionModule_LoadSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
        this.loadSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        media.mojom.ContentDecryptionModule_UpdateSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
        this.updateSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        media.mojom.ContentDecryptionModule_CloseSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
        this.closeSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        media.mojom.ContentDecryptionModule_RemoveSession_ParamsSpec.$,
        media.mojom.ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
        this.removeSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.ContentDecryptionModuleClient');
goog.provide('media.mojom.ContentDecryptionModuleClientReceiver');
goog.provide('media.mojom.ContentDecryptionModuleClientCallbackRouter');
goog.provide('media.mojom.ContentDecryptionModuleClientInterface');
goog.provide('media.mojom.ContentDecryptionModuleClientRemote');
goog.provide('media.mojom.ContentDecryptionModuleClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.ContentDecryptionModuleClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.ContentDecryptionModuleClient.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.ContentDecryptionModuleClientInterface = class {
  
  /**
   * @param { !string } sessionId
   * @param { !media.mojom.CdmMessageType } messageType
   * @param { !Array<!number> } message
   */

  onSessionMessage(sessionId, messageType, message) {}
  
  /**
   * @param { !string } sessionId
   * @param { !media.mojom.CdmSessionClosedReason } reason
   */

  onSessionClosed(sessionId, reason) {}
  
  /**
   * @param { !string } sessionId
   * @param { !boolean } hasAdditionalUsableKey
   * @param { !Array<!media.mojom.CdmKeyInformation> } keysInfo
   */

  onSessionKeysChange(sessionId, hasAdditionalUsableKey, keysInfo) {}
  
  /**
   * @param { !string } sessionId
   * @param { !number } newExpiryTimeSec
   */

  onSessionExpirationUpdate(sessionId, newExpiryTimeSec) {}
};

/**
 * @export
 * @implements { media.mojom.ContentDecryptionModuleClientInterface }
 */
media.mojom.ContentDecryptionModuleClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.ContentDecryptionModuleClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.ContentDecryptionModuleClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.ContentDecryptionModuleClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } sessionId
   * @param { !media.mojom.CdmMessageType } messageType
   * @param { !Array<!number> } message
   */

  onSessionMessage(
      sessionId,
      messageType,
      message) {
    this.proxy.sendMessage(
        0,
        media.mojom.ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
        null,
        [
          sessionId,
          messageType,
          message
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !media.mojom.CdmSessionClosedReason } reason
   */

  onSessionClosed(
      sessionId,
      reason) {
    this.proxy.sendMessage(
        1,
        media.mojom.ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
        null,
        [
          sessionId,
          reason
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !boolean } hasAdditionalUsableKey
   * @param { !Array<!media.mojom.CdmKeyInformation> } keysInfo
   */

  onSessionKeysChange(
      sessionId,
      hasAdditionalUsableKey,
      keysInfo) {
    this.proxy.sendMessage(
        2,
        media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
        null,
        [
          sessionId,
          hasAdditionalUsableKey,
          keysInfo
        ],
        false);
  }

  
  /**
   * @param { !string } sessionId
   * @param { !number } newExpiryTimeSec
   */

  onSessionExpirationUpdate(
      sessionId,
      newExpiryTimeSec) {
    this.proxy.sendMessage(
        3,
        media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
        null,
        [
          sessionId,
          newExpiryTimeSec
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ContentDecryptionModuleClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.ContentDecryptionModuleClientReceiver = class {
  /**
   * @param {!media.mojom.ContentDecryptionModuleClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.ContentDecryptionModuleClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.ContentDecryptionModuleClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.ContentDecryptionModuleClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
        null,
        impl.onSessionMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        media.mojom.ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
        null,
        impl.onSessionClosed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
        null,
        impl.onSessionKeysChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
        null,
        impl.onSessionExpirationUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.ContentDecryptionModuleClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.ContentDecryptionModuleClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.ContentDecryptionModuleClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.ContentDecryptionModuleClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ContentDecryptionModuleClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.ContentDecryptionModuleClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.ContentDecryptionModuleClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.ContentDecryptionModuleClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
        null,
        this.onSessionMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        media.mojom.ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
        null,
        this.onSessionClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionKeysChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
        null,
        this.onSessionKeysChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionExpirationUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
        null,
        this.onSessionExpirationUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.CdmFactory');
goog.provide('media.mojom.CdmFactoryReceiver');
goog.provide('media.mojom.CdmFactoryCallbackRouter');
goog.provide('media.mojom.CdmFactoryInterface');
goog.provide('media.mojom.CdmFactoryRemote');
goog.provide('media.mojom.CdmFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
media.mojom.CdmFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        media.mojom.CdmFactory.$interfaceName,
        scope);
  }
};

/** @interface */
media.mojom.CdmFactoryInterface = class {
  
  /**
   * @param { !media.mojom.CdmConfig } cdmConfig
   * @return {!Promise<{
        cdm: ?media.mojom.ContentDecryptionModuleRemote,
        cdmContext: ?media.mojom.CdmContext,
        status: !media.mojom.CreateCdmStatus,
   *  }>}
   */

  createCdm(cdmConfig) {}
};

/**
 * @export
 * @implements { media.mojom.CdmFactoryInterface }
 */
media.mojom.CdmFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!media.mojom.CdmFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          media.mojom.CdmFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!media.mojom.CdmFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !media.mojom.CdmConfig } cdmConfig
   * @return {!Promise<{
        cdm: ?media.mojom.ContentDecryptionModuleRemote,
        cdmContext: ?media.mojom.CdmContext,
        status: !media.mojom.CreateCdmStatus,
   *  }>}
   */

  createCdm(
      cdmConfig) {
    return this.proxy.sendMessage(
        0,
        media.mojom.CdmFactory_CreateCdm_ParamsSpec.$,
        media.mojom.CdmFactory_CreateCdm_ResponseParamsSpec.$,
        [
          cdmConfig
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CdmFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
media.mojom.CdmFactoryReceiver = class {
  /**
   * @param {!media.mojom.CdmFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!media.mojom.CdmFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        media.mojom.CdmFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmFactory_CreateCdm_ParamsSpec.$,
        media.mojom.CdmFactory_CreateCdm_ResponseParamsSpec.$,
        impl.createCdm.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
media.mojom.CdmFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.CdmFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!media.mojom.CdmFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new media.mojom.CdmFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CdmFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
media.mojom.CdmFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      media.mojom.CdmFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!media.mojom.CdmFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createCdm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        media.mojom.CdmFactory_CreateCdm_ParamsSpec.$,
        media.mojom.CdmFactory_CreateCdm_ResponseParamsSpec.$,
        this.createCdm.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('media.mojom.CdmConfigSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmPromiseResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmPromiseResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmKeyInformationSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmKeyInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmContextSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_SetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_SetServerCertificate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_SetServerCertificate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_GetStatusForPolicy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_GetStatusForPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_LoadSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_LoadSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_LoadSession_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_LoadSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_UpdateSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_UpdateSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_UpdateSession_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_UpdateSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_CloseSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_CloseSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_CloseSession_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_CloseSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_RemoveSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_RemoveSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModule_RemoveSession_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModule_RemoveSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmFactory_CreateCdm_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmFactory_CreateCdm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('media.mojom.CdmFactory_CreateCdm_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
media.mojom.CdmFactory_CreateCdm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    media.mojom.CdmConfigSpec.$,
    'CdmConfig',
    [
      mojo.internal.StructField(
        'keySystem', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowDistinctiveIdentifier', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowPersistentState', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useHwSecureCodecs', 8,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.CdmConfig');

/** @record */
media.mojom.CdmConfig = class {
  constructor() {
    /** @export { !string } */
    this.keySystem;
    /** @export { !boolean } */
    this.allowDistinctiveIdentifier;
    /** @export { !boolean } */
    this.allowPersistentState;
    /** @export { !boolean } */
    this.useHwSecureCodecs;
  }
};


goog.provide('media.mojom.CdmPromiseResult_Exception');
goog.provide('media.mojom.CdmPromiseResultSpec.ExceptionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
media.mojom.CdmPromiseResultSpec.ExceptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
media.mojom.CdmPromiseResult_Exception = {
  
};


mojo.internal.Struct(
    media.mojom.CdmPromiseResultSpec.$,
    'CdmPromiseResult',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exception', 4,
        0,
        media.mojom.CdmPromiseResultSpec.ExceptionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'systemCode', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.CdmPromiseResult');

/** @record */
media.mojom.CdmPromiseResult = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !media.mojom.CdmPromiseResult_Exception } */
    this.exception;
    /** @export { !number } */
    this.systemCode;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    media.mojom.CdmKeyInformationSpec.$,
    'CdmKeyInformation',
    [
      mojo.internal.StructField(
        'keyId', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        media.mojom.CdmKeyStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'systemCode', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.CdmKeyInformation');

/** @record */
media.mojom.CdmKeyInformation = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.keyId;
    /** @export { !media.mojom.CdmKeyStatus } */
    this.status;
    /** @export { !number } */
    this.systemCode;
  }
};



mojo.internal.Struct(
    media.mojom.CdmContextSpec.$,
    'CdmContext',
    [
      mojo.internal.StructField(
        'cdmId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'decryptor', 8,
        0,
        mojo.internal.InterfaceProxy(media.mojom.DecryptorRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.CdmContext');

/** @record */
media.mojom.CdmContext = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.cdmId;
    /** @export { (media.mojom.DecryptorRemote|undefined) } */
    this.decryptor;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_SetClient_ParamsSpec.$,
    'ContentDecryptionModule_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(media.mojom.ContentDecryptionModuleClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_SetClient_Params');

/** @record */
media.mojom.ContentDecryptionModule_SetClient_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_SetServerCertificate_ParamsSpec.$,
    'ContentDecryptionModule_SetServerCertificate_Params',
    [
      mojo.internal.StructField(
        'certificateData', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_SetServerCertificate_Params');

/** @record */
media.mojom.ContentDecryptionModule_SetServerCertificate_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.certificateData;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParamsSpec.$,
    'ContentDecryptionModule_SetServerCertificate_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_SetServerCertificate_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_GetStatusForPolicy_ParamsSpec.$,
    'ContentDecryptionModule_GetStatusForPolicy_Params',
    [
      mojo.internal.StructField(
        'minHdcpVersion', 0,
        0,
        media.mojom.HdcpVersionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_GetStatusForPolicy_Params');

/** @record */
media.mojom.ContentDecryptionModule_GetStatusForPolicy_Params = class {
  constructor() {
    /** @export { !media.mojom.HdcpVersion } */
    this.minHdcpVersion;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParamsSpec.$,
    'ContentDecryptionModule_GetStatusForPolicy_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyStatus', 8,
        0,
        media.mojom.CdmKeyStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_GetStatusForPolicy_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
    /** @export { !media.mojom.CdmKeyStatus } */
    this.keyStatus;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ParamsSpec.$,
    'ContentDecryptionModule_CreateSessionAndGenerateRequest_Params',
    [
      mojo.internal.StructField(
        'sessionType', 0,
        0,
        media.mojom.CdmSessionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initDataType', 4,
        0,
        media.mojom.EmeInitDataTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'initData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_Params');

/** @record */
media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_Params = class {
  constructor() {
    /** @export { !media.mojom.CdmSessionType } */
    this.sessionType;
    /** @export { !media.mojom.EmeInitDataType } */
    this.initDataType;
    /** @export { !Array<!number> } */
    this.initData;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParamsSpec.$,
    'ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_CreateSessionAndGenerateRequest_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
    /** @export { !string } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_LoadSession_ParamsSpec.$,
    'ContentDecryptionModule_LoadSession_Params',
    [
      mojo.internal.StructField(
        'sessionType', 0,
        0,
        media.mojom.CdmSessionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModule_LoadSession_Params');

/** @record */
media.mojom.ContentDecryptionModule_LoadSession_Params = class {
  constructor() {
    /** @export { !media.mojom.CdmSessionType } */
    this.sessionType;
    /** @export { !string } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_LoadSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_LoadSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModule_LoadSession_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_LoadSession_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
    /** @export { !string } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_UpdateSession_ParamsSpec.$,
    'ContentDecryptionModule_UpdateSession_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'response', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModule_UpdateSession_Params');

/** @record */
media.mojom.ContentDecryptionModule_UpdateSession_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
    /** @export { !Array<!number> } */
    this.response;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_UpdateSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_UpdateSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_UpdateSession_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_UpdateSession_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_CloseSession_ParamsSpec.$,
    'ContentDecryptionModule_CloseSession_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_CloseSession_Params');

/** @record */
media.mojom.ContentDecryptionModule_CloseSession_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_CloseSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_CloseSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_CloseSession_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_CloseSession_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_RemoveSession_ParamsSpec.$,
    'ContentDecryptionModule_RemoveSession_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_RemoveSession_Params');

/** @record */
media.mojom.ContentDecryptionModule_RemoveSession_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModule_RemoveSession_ResponseParamsSpec.$,
    'ContentDecryptionModule_RemoveSession_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        media.mojom.CdmPromiseResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.ContentDecryptionModule_RemoveSession_ResponseParams');

/** @record */
media.mojom.ContentDecryptionModule_RemoveSession_ResponseParams = class {
  constructor() {
    /** @export { !media.mojom.CdmPromiseResult } */
    this.result;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModuleClient_OnSessionMessage_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionMessage_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'messageType', 8,
        0,
        media.mojom.CdmMessageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionMessage_Params');

/** @record */
media.mojom.ContentDecryptionModuleClient_OnSessionMessage_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
    /** @export { !media.mojom.CdmMessageType } */
    this.messageType;
    /** @export { !Array<!number> } */
    this.message;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModuleClient_OnSessionClosed_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionClosed_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        media.mojom.CdmSessionClosedReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionClosed_Params');

/** @record */
media.mojom.ContentDecryptionModuleClient_OnSessionClosed_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
    /** @export { !media.mojom.CdmSessionClosedReason } */
    this.reason;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionKeysChange_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasAdditionalUsableKey', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keysInfo', 16,
        0,
        mojo.internal.Array(media.mojom.CdmKeyInformationSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_Params');

/** @record */
media.mojom.ContentDecryptionModuleClient_OnSessionKeysChange_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
    /** @export { !boolean } */
    this.hasAdditionalUsableKey;
    /** @export { !Array<!media.mojom.CdmKeyInformation> } */
    this.keysInfo;
  }
};



mojo.internal.Struct(
    media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_ParamsSpec.$,
    'ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params',
    [
      mojo.internal.StructField(
        'sessionId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newExpiryTimeSec', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params');

/** @record */
media.mojom.ContentDecryptionModuleClient_OnSessionExpirationUpdate_Params = class {
  constructor() {
    /** @export { !string } */
    this.sessionId;
    /** @export { !number } */
    this.newExpiryTimeSec;
  }
};



mojo.internal.Struct(
    media.mojom.CdmFactory_CreateCdm_ParamsSpec.$,
    'CdmFactory_CreateCdm_Params',
    [
      mojo.internal.StructField(
        'cdmConfig', 0,
        0,
        media.mojom.CdmConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('media.mojom.CdmFactory_CreateCdm_Params');

/** @record */
media.mojom.CdmFactory_CreateCdm_Params = class {
  constructor() {
    /** @export { !media.mojom.CdmConfig } */
    this.cdmConfig;
  }
};



mojo.internal.Struct(
    media.mojom.CdmFactory_CreateCdm_ResponseParamsSpec.$,
    'CdmFactory_CreateCdm_ResponseParams',
    [
      mojo.internal.StructField(
        'cdm', 0,
        0,
        mojo.internal.InterfaceProxy(media.mojom.ContentDecryptionModuleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cdmContext', 8,
        0,
        media.mojom.CdmContextSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 16,
        0,
        media.mojom.CreateCdmStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('media.mojom.CdmFactory_CreateCdm_ResponseParams');

/** @record */
media.mojom.CdmFactory_CreateCdm_ResponseParams = class {
  constructor() {
    /** @export { (media.mojom.ContentDecryptionModuleRemote|undefined) } */
    this.cdm;
    /** @export { (media.mojom.CdmContext|undefined) } */
    this.cdmContext;
    /** @export { !media.mojom.CreateCdmStatus } */
    this.status;
  }
};

