// media/mojo/mojom/cdm_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_storage.mojom-params-data.h"
#include "media/mojo/mojom/cdm_storage.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_storage.mojom-blink-import-headers.h"
#include "media/mojo/mojom/cdm_storage.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
// The declaration includes the definition on other builds.

CdmStorage::IPCStableHashFunction CdmStorage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmStorage>(message.name())) {
    case messages::CdmStorage::kOpen: {
      return &CdmStorage::Open_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmStorage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmStorage>(message.name())) {
      case messages::CdmStorage::kOpen:
            return "Receive media::mojom::CdmStorage::Open";
    }
  } else {
    switch (static_cast<messages::CdmStorage>(message.name())) {
      case messages::CdmStorage::kOpen:
            return "Receive reply media::mojom::CdmStorage::Open";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmStorage::Open_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d8bc6af;  // IPCStableHash for media::mojom::CdmStorage::Open
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CdmStorage_Open_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmStorage_Open_ForwardToCallback(
      CdmStorage::OpenCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmStorage_Open_ForwardToCallback(const CdmStorage_Open_ForwardToCallback&) = delete;
  CdmStorage_Open_ForwardToCallback& operator=(const CdmStorage_Open_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmStorage::OpenCallback callback_;
};

CdmStorageProxy::CdmStorageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmStorageProxy::Open(
    const ::blink::String& in_file_name, OpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmStorage::Open", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_name"), in_file_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmStorage::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmStorage_Open_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_name)::BaseType> file_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_file_name,
    file_name_fragment);

  params->file_name.Set(
      file_name_fragment.is_null() ? nullptr : file_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_name in CdmStorage.Open request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmStorage::Name_);
  message.set_method_name("Open");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmStorage_Open_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CdmStorage_Open_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmStorage::OpenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmStorage_Open_ProxyToResponder> proxy(
        new CdmStorage_Open_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmStorage_Open_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmStorage_Open_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmStorage_Open_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CdmStorage::OpenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmStorage::Status in_status, ::mojo::PendingAssociatedRemote<CdmFile> in_cdm_file);
};

bool CdmStorage_Open_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmStorage_Open_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmStorage_Open_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmStorage.0
  bool success = true;
  CdmStorage::Status p_status{};
  ::mojo::PendingAssociatedRemote<CdmFile> p_cdm_file{};
  CdmStorage_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success) {
    p_cdm_file =
        input_data_view.TakeCdmFile<decltype(p_cdm_file)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmStorage::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_cdm_file));
  }
  return true;
}

void CdmStorage_Open_ProxyToResponder::Run(
    CdmStorage::Status in_status, ::mojo::PendingAssociatedRemote<CdmFile> in_cdm_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmStorage::Open", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CdmStorage::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_file"), in_cdm_file,
                        "<value of type ::mojo::PendingAssociatedRemote<CdmFile>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmStorage::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmStorage_Open_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::CdmStorage_Status>(
    in_status,
    &params->status);

  
  mojo::internal::Serialize<::media::mojom::CdmFileAssociatedPtrInfoDataView>(
    in_cdm_file,
    &params->cdm_file,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmStorage::Name_);
  message.set_method_name("Open");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmStorageStubDispatch::Accept(
    CdmStorage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmStorage>(message->header()->name)) {
    case messages::CdmStorage::kOpen: {
      break;
    }
  }
  return false;
}

// static
bool CdmStorageStubDispatch::AcceptWithResponder(
    CdmStorage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmStorage>(message->header()->name)) {
    case messages::CdmStorage::kOpen: {
      internal::CdmStorage_Open_Params_Data* params =
          reinterpret_cast<
              internal::CdmStorage_Open_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmStorage.0
      bool success = true;
      ::blink::String p_file_name{};
      CdmStorage_Open_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFileName(&p_file_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmStorage::Name_, 0, false);
        return false;
      }
      auto callback =
          CdmStorage_Open_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(        
        std::move(p_file_name), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCdmStorageValidationInfo[] = {
    { &internal::CdmStorage_Open_Params_Data::Validate,
     &internal::CdmStorage_Open_ResponseParams_Data::Validate},
};

bool CdmStorageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::CdmStorage::Name_,
    kCdmStorageValidationInfo);
}

bool CdmStorageResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::CdmStorage::Name_,
    kCdmStorageValidationInfo);
}
// The declaration includes the definition on other builds.

CdmFile::IPCStableHashFunction CdmFile::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmFile>(message.name())) {
    case messages::CdmFile::kRead: {
      return &CdmFile::Read_Sym::IPCStableHash;
    }
    case messages::CdmFile::kWrite: {
      return &CdmFile::Write_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmFile::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmFile>(message.name())) {
      case messages::CdmFile::kRead:
            return "Receive media::mojom::CdmFile::Read";
      case messages::CdmFile::kWrite:
            return "Receive media::mojom::CdmFile::Write";
    }
  } else {
    switch (static_cast<messages::CdmFile>(message.name())) {
      case messages::CdmFile::kRead:
            return "Receive reply media::mojom::CdmFile::Read";
      case messages::CdmFile::kWrite:
            return "Receive reply media::mojom::CdmFile::Write";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmFile::Read_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ceb5a29;  // IPCStableHash for media::mojom::CdmFile::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmFile::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x968765ee;  // IPCStableHash for media::mojom::CdmFile::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CdmFile_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmFile_Read_ForwardToCallback(
      CdmFile::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmFile_Read_ForwardToCallback(const CdmFile_Read_ForwardToCallback&) = delete;
  CdmFile_Read_ForwardToCallback& operator=(const CdmFile_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmFile::ReadCallback callback_;
};

class CdmFile_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmFile_Write_ForwardToCallback(
      CdmFile::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmFile_Write_ForwardToCallback(const CdmFile_Write_ForwardToCallback&) = delete;
  CdmFile_Write_ForwardToCallback& operator=(const CdmFile_Write_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmFile::WriteCallback callback_;
};

CdmFileProxy::CdmFileProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmFileProxy::Read(
    ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::CdmFile::Read");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmFile::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmFile_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmFileProxy::Write(
    const ::blink::Vector<uint8_t>& in_data, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmFile::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmFile::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Write_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in CdmFile.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmFile_Write_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CdmFile_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmFile::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmFile_Read_ProxyToResponder> proxy(
        new CdmFile_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmFile_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmFile_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmFile_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CdmFile::ReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmFile::Status in_status, const ::blink::Vector<uint8_t>& in_data);
};

bool CdmFile_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmFile_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmFile_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmFile.0
  bool success = true;
  CdmFile::Status p_status{};
  ::blink::Vector<uint8_t> p_data{};
  CdmFile_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmFile::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_data));
  }
  return true;
}

void CdmFile_Read_ProxyToResponder::Run(
    CdmFile::Status in_status, const ::blink::Vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmFile::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CdmFile::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmFile::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Read_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::CdmFile_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmFile_Write_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmFile::WriteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmFile_Write_ProxyToResponder> proxy(
        new CdmFile_Write_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmFile_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmFile_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmFile_Write_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CdmFile::WriteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmFile::Status in_status);
};

bool CdmFile_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmFile_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmFile_Write_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmFile.1
  bool success = true;
  CdmFile::Status p_status{};
  CdmFile_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmFile::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void CdmFile_Write_ProxyToResponder::Run(
    CdmFile::Status in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmFile::Write", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CdmFile::Status>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmFile::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Write_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::CdmFile_Status>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmFileStubDispatch::Accept(
    CdmFile* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmFile>(message->header()->name)) {
    case messages::CdmFile::kRead: {
      break;
    }
    case messages::CdmFile::kWrite: {
      break;
    }
  }
  return false;
}

// static
bool CdmFileStubDispatch::AcceptWithResponder(
    CdmFile* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmFile>(message->header()->name)) {
    case messages::CdmFile::kRead: {
      internal::CdmFile_Read_Params_Data* params =
          reinterpret_cast<
              internal::CdmFile_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmFile.0
      bool success = true;
      CdmFile_Read_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmFile::Name_, 0, false);
        return false;
      }
      auto callback =
          CdmFile_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(std::move(callback));
      return true;
    }
    case messages::CdmFile::kWrite: {
      internal::CdmFile_Write_Params_Data* params =
          reinterpret_cast<
              internal::CdmFile_Write_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmFile.1
      bool success = true;
      ::blink::Vector<uint8_t> p_data{};
      CdmFile_Write_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmFile::Name_, 1, false);
        return false;
      }
      auto callback =
          CdmFile_Write_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCdmFileValidationInfo[] = {
    { &internal::CdmFile_Read_Params_Data::Validate,
     &internal::CdmFile_Read_ResponseParams_Data::Validate},
    { &internal::CdmFile_Write_Params_Data::Validate,
     &internal::CdmFile_Write_ResponseParams_Data::Validate},
};

bool CdmFileRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::CdmFile::Name_,
    kCdmFileValidationInfo);
}

bool CdmFileResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::CdmFile::Name_,
    kCdmFileValidationInfo);
}


}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void CdmStorageInterceptorForTesting::Open(const ::blink::String& file_name, OpenCallback callback) {
  GetForwardingInterface()->Open(
    std::move(file_name)
    , std::move(callback));
}
CdmStorageAsyncWaiter::CdmStorageAsyncWaiter(
    CdmStorage* proxy) : proxy_(proxy) {}

CdmStorageAsyncWaiter::~CdmStorageAsyncWaiter() = default;


void CdmStorageAsyncWaiter::Open(
    const ::blink::String& file_name, CdmStorage::Status* out_status, ::mojo::PendingAssociatedRemote<CdmFile>* out_cdm_file) {
  base::RunLoop loop;
  proxy_->Open(
      std::move(file_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmStorage::Status* out_status
,
             ::mojo::PendingAssociatedRemote<CdmFile>* out_cdm_file
,
             CdmStorage::Status status,
             ::mojo::PendingAssociatedRemote<CdmFile> cdm_file) {*out_status = std::move(status);*out_cdm_file = std::move(cdm_file);
            loop->Quit();
          },
          &loop,
          out_status,
          out_cdm_file));
  loop.Run();
}






void CdmFileInterceptorForTesting::Read(ReadCallback callback) {
  GetForwardingInterface()->Read(std::move(callback));
}
void CdmFileInterceptorForTesting::Write(const ::blink::Vector<uint8_t>& data, WriteCallback callback) {
  GetForwardingInterface()->Write(
    std::move(data)
    , std::move(callback));
}
CdmFileAsyncWaiter::CdmFileAsyncWaiter(
    CdmFile* proxy) : proxy_(proxy) {}

CdmFileAsyncWaiter::~CdmFileAsyncWaiter() = default;


void CdmFileAsyncWaiter::Read(
    CdmFile::Status* out_status, ::blink::Vector<uint8_t>* out_data) {
  base::RunLoop loop;
  proxy_->Read(
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmFile::Status* out_status
,
             ::blink::Vector<uint8_t>* out_data
,
             CdmFile::Status status,
             const ::blink::Vector<uint8_t>& data) {*out_status = std::move(status);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_status,
          out_data));
  loop.Run();
}



void CdmFileAsyncWaiter::Write(
    const ::blink::Vector<uint8_t>& data, CdmFile::Status* out_status) {
  base::RunLoop loop;
  proxy_->Write(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmFile::Status* out_status
,
             CdmFile::Status status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

CdmFile::Status CdmFileAsyncWaiter::Write(
    const ::blink::Vector<uint8_t>& data) {
  CdmFile::Status async_wait_result;
  Write(std::move(data),&async_wait_result);
  return async_wait_result;
}






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif