// media/mojo/mojom/audio_stream_factory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'media/mojo/mojom/audio_stream_factory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('media.mojom');
  var audio_data_pipe$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_data_pipe.mojom', 'audio_data_pipe.mojom.js');
  }
  var audio_input_stream$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_input_stream.mojom', 'audio_input_stream.mojom.js');
  }
  var audio_logging$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_logging.mojom', 'audio_logging.mojom.js');
  }
  var audio_output_stream$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_output_stream.mojom', 'audio_output_stream.mojom.js');
  }
  var audio_parameters$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_parameters.mojom', 'audio_parameters.mojom.js');
  }
  var audio_processing$ =
      mojo.internal.exposeNamespace('media.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'media/mojo/mojom/audio_processing.mojom', 'audio_processing.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../sandbox/policy/mojom/context.mojom.js');
  }



  function AudioStreamFactory_CreateInputStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateInputStream_Params.prototype.initDefaults_ = function() {
    this.stream = new bindings.InterfaceRequest();
    this.client = new audio_input_stream$.AudioInputStreamClientPtr();
    this.observer = new audio_input_stream$.AudioInputStreamObserverPtr();
    this.log = new audio_logging$.AudioLogPtr();
    this.sharedMemoryCount = 0;
    this.deviceId = null;
    this.params = null;
    this.groupId = null;
    this.enableAgc = false;
    this.processingConfig = null;
  };
  AudioStreamFactory_CreateInputStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateInputStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.stream
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.log
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 20, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_Params.groupId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AudioStreamFactory_CreateInputStream_Params.processingConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, audio_processing$.AudioProcessingConfig, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateInputStream_Params.encodedSize = codec.kStructHeaderSize + 72;

  AudioStreamFactory_CreateInputStream_Params.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateInputStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stream =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(audio_input_stream$.AudioInputStreamClientPtr));
    val.observer =
        decoder.decodeStruct(new codec.NullableInterface(audio_input_stream$.AudioInputStreamObserverPtr));
    val.log =
        decoder.decodeStruct(new codec.NullableInterface(audio_logging$.AudioLogPtr));
    val.sharedMemoryCount =
        decoder.decodeStruct(codec.Uint32);
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.params =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    val.groupId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    packed = decoder.readUint8();
    val.enableAgc = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.processingConfig =
        decoder.decodeStructPointer(audio_processing$.AudioProcessingConfig);
    return val;
  };

  AudioStreamFactory_CreateInputStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateInputStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.stream);
    encoder.encodeStruct(new codec.Interface(audio_input_stream$.AudioInputStreamClientPtr), val.client);
    encoder.encodeStruct(new codec.NullableInterface(audio_input_stream$.AudioInputStreamObserverPtr), val.observer);
    encoder.encodeStruct(new codec.NullableInterface(audio_logging$.AudioLogPtr), val.log);
    encoder.encodeStruct(codec.Uint32, val.sharedMemoryCount);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.params);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.groupId);
    packed = 0;
    packed |= (val.enableAgc & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(audio_processing$.AudioProcessingConfig, val.processingConfig);
  };
  function AudioStreamFactory_CreateInputStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateInputStream_ResponseParams.prototype.initDefaults_ = function() {
    this.dataPipe = null;
    this.initiallyMuted = false;
    this.streamId = null;
  };
  AudioStreamFactory_CreateInputStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateInputStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateInputStream_ResponseParams.dataPipe
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, audio_data_pipe$.ReadWriteAudioDataPipe, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AudioStreamFactory_CreateInputStream_ResponseParams.streamId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateInputStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  AudioStreamFactory_CreateInputStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateInputStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataPipe =
        decoder.decodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe);
    packed = decoder.readUint8();
    val.initiallyMuted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.streamId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioStreamFactory_CreateInputStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateInputStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe, val.dataPipe);
    packed = 0;
    packed |= (val.initiallyMuted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.streamId);
  };
  function AudioStreamFactory_AssociateInputAndOutputForAec_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_AssociateInputAndOutputForAec_Params.prototype.initDefaults_ = function() {
    this.inputStreamId = null;
    this.outputDeviceId = null;
  };
  AudioStreamFactory_AssociateInputAndOutputForAec_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_AssociateInputAndOutputForAec_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_AssociateInputAndOutputForAec_Params.inputStreamId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_AssociateInputAndOutputForAec_Params.outputDeviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_AssociateInputAndOutputForAec_Params.encodedSize = codec.kStructHeaderSize + 16;

  AudioStreamFactory_AssociateInputAndOutputForAec_Params.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_AssociateInputAndOutputForAec_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputStreamId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.outputDeviceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AudioStreamFactory_AssociateInputAndOutputForAec_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_AssociateInputAndOutputForAec_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.inputStreamId);
    encoder.encodeStruct(codec.String, val.outputDeviceId);
  };
  function AudioStreamFactory_CreateOutputStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateOutputStream_Params.prototype.initDefaults_ = function() {
    this.stream = new bindings.InterfaceRequest();
    this.observer = new associatedBindings.AssociatedInterfacePtrInfo();
    this.log = new audio_logging$.AudioLogPtr();
    this.deviceId = null;
    this.params = null;
    this.groupId = null;
  };
  AudioStreamFactory_CreateOutputStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateOutputStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_Params.stream
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_Params.observer
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 4, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_Params.log
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_Params.groupId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateOutputStream_Params.encodedSize = codec.kStructHeaderSize + 48;

  AudioStreamFactory_CreateOutputStream_Params.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateOutputStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stream =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.observer =
        decoder.decodeStruct(codec.NullableAssociatedInterfacePtrInfo);
    val.log =
        decoder.decodeStruct(new codec.NullableInterface(audio_logging$.AudioLogPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.params =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    val.groupId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioStreamFactory_CreateOutputStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateOutputStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.stream);
    encoder.encodeStruct(codec.NullableAssociatedInterfacePtrInfo, val.observer);
    encoder.encodeStruct(new codec.NullableInterface(audio_logging$.AudioLogPtr), val.log);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.params);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.groupId);
  };
  function AudioStreamFactory_CreateOutputStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateOutputStream_ResponseParams.prototype.initDefaults_ = function() {
    this.dataPipe = null;
  };
  AudioStreamFactory_CreateOutputStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateOutputStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateOutputStream_ResponseParams.dataPipe
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, audio_data_pipe$.ReadWriteAudioDataPipe, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateOutputStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioStreamFactory_CreateOutputStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateOutputStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataPipe =
        decoder.decodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe);
    return val;
  };

  AudioStreamFactory_CreateOutputStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateOutputStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe, val.dataPipe);
  };
  function AudioStreamFactory_CreateSwitchableOutputStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateSwitchableOutputStream_Params.prototype.initDefaults_ = function() {
    this.stream = new bindings.InterfaceRequest();
    this.deviceSwitchReceiver = new bindings.InterfaceRequest();
    this.observer = new associatedBindings.AssociatedInterfacePtrInfo();
    this.log = new audio_logging$.AudioLogPtr();
    this.deviceId = null;
    this.params = null;
    this.groupId = null;
  };
  AudioStreamFactory_CreateSwitchableOutputStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateSwitchableOutputStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.stream
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.deviceSwitchReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 4, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.observer
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.log
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.deviceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_Params.groupId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateSwitchableOutputStream_Params.encodedSize = codec.kStructHeaderSize + 48;

  AudioStreamFactory_CreateSwitchableOutputStream_Params.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateSwitchableOutputStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.stream =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.deviceSwitchReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.observer =
        decoder.decodeStruct(codec.NullableAssociatedInterfacePtrInfo);
    val.log =
        decoder.decodeStruct(new codec.NullableInterface(audio_logging$.AudioLogPtr));
    val.deviceId =
        decoder.decodeStruct(codec.String);
    val.params =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    val.groupId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioStreamFactory_CreateSwitchableOutputStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateSwitchableOutputStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.stream);
    encoder.encodeStruct(codec.InterfaceRequest, val.deviceSwitchReceiver);
    encoder.encodeStruct(codec.NullableAssociatedInterfacePtrInfo, val.observer);
    encoder.encodeStruct(new codec.NullableInterface(audio_logging$.AudioLogPtr), val.log);
    encoder.encodeStruct(codec.String, val.deviceId);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.params);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.groupId);
  };
  function AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.prototype.initDefaults_ = function() {
    this.dataPipe = null;
  };
  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.dataPipe
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, audio_data_pipe$.ReadWriteAudioDataPipe, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataPipe =
        decoder.decodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe);
    return val;
  };

  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe, val.dataPipe);
  };
  function AudioStreamFactory_BindMuter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_BindMuter_Params.prototype.initDefaults_ = function() {
    this.receiver = new associatedBindings.AssociatedInterfaceRequest();
    this.groupId = null;
  };
  AudioStreamFactory_BindMuter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_BindMuter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_BindMuter_Params.receiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_BindMuter_Params.groupId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_BindMuter_Params.encodedSize = codec.kStructHeaderSize + 16;

  AudioStreamFactory_BindMuter_Params.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_BindMuter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.groupId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioStreamFactory_BindMuter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_BindMuter_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.groupId);
  };
  function AudioStreamFactory_CreateLoopbackStream_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateLoopbackStream_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.client = new audio_input_stream$.AudioInputStreamClientPtr();
    this.observer = new audio_input_stream$.AudioInputStreamObserverPtr();
    this.sharedMemoryCount = 0;
    this.params = null;
    this.groupId = null;
  };
  AudioStreamFactory_CreateLoopbackStream_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateLoopbackStream_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateLoopbackStream_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateLoopbackStream_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateLoopbackStream_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateLoopbackStream_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, audio_parameters$.AudioParameters, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AudioStreamFactory_CreateLoopbackStream_Params.groupId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateLoopbackStream_Params.encodedSize = codec.kStructHeaderSize + 40;

  AudioStreamFactory_CreateLoopbackStream_Params.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateLoopbackStream_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.client =
        decoder.decodeStruct(new codec.Interface(audio_input_stream$.AudioInputStreamClientPtr));
    val.observer =
        decoder.decodeStruct(new codec.Interface(audio_input_stream$.AudioInputStreamObserverPtr));
    val.sharedMemoryCount =
        decoder.decodeStruct(codec.Uint32);
    val.params =
        decoder.decodeStructPointer(audio_parameters$.AudioParameters);
    val.groupId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioStreamFactory_CreateLoopbackStream_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateLoopbackStream_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.Interface(audio_input_stream$.AudioInputStreamClientPtr), val.client);
    encoder.encodeStruct(new codec.Interface(audio_input_stream$.AudioInputStreamObserverPtr), val.observer);
    encoder.encodeStruct(codec.Uint32, val.sharedMemoryCount);
    encoder.encodeStructPointer(audio_parameters$.AudioParameters, val.params);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.groupId);
  };
  function AudioStreamFactory_CreateLoopbackStream_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioStreamFactory_CreateLoopbackStream_ResponseParams.prototype.initDefaults_ = function() {
    this.dataPipe = null;
  };
  AudioStreamFactory_CreateLoopbackStream_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioStreamFactory_CreateLoopbackStream_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioStreamFactory_CreateLoopbackStream_ResponseParams.dataPipe
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, audio_data_pipe$.ReadWriteAudioDataPipe, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioStreamFactory_CreateLoopbackStream_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioStreamFactory_CreateLoopbackStream_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioStreamFactory_CreateLoopbackStream_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.dataPipe =
        decoder.decodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe);
    return val;
  };

  AudioStreamFactory_CreateLoopbackStream_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioStreamFactory_CreateLoopbackStream_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(audio_data_pipe$.ReadWriteAudioDataPipe, val.dataPipe);
  };

  function LocalMuterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LocalMuter,
                                                   handleOrPtrInfo);
  }

  function LocalMuterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LocalMuter, associatedInterfacePtrInfo);
  }

  LocalMuterAssociatedPtr.prototype =
      Object.create(LocalMuterPtr.prototype);
  LocalMuterAssociatedPtr.prototype.constructor =
      LocalMuterAssociatedPtr;

  function LocalMuterProxy(receiver) {
    this.receiver_ = receiver;
  }

  function LocalMuterStub(delegate) {
    this.delegate_ = delegate;
  }

  LocalMuterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  LocalMuterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateLocalMuterRequest(messageValidator) {
    return validator.validationError.NONE;
  }

  function validateLocalMuterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var LocalMuter = {
    name: 'media.mojom.LocalMuter',
    kVersion: 0,
    ptrClass: LocalMuterPtr,
    proxyClass: LocalMuterProxy,
    stubClass: LocalMuterStub,
    validateRequest: validateLocalMuterRequest,
    validateResponse: null,
  };
  LocalMuterStub.prototype.validator = validateLocalMuterRequest;
  LocalMuterProxy.prototype.validator = null;
  var kAudioStreamFactory_CreateInputStream_Name = 0;
  var kAudioStreamFactory_AssociateInputAndOutputForAec_Name = 1;
  var kAudioStreamFactory_CreateOutputStream_Name = 2;
  var kAudioStreamFactory_CreateSwitchableOutputStream_Name = 3;
  var kAudioStreamFactory_BindMuter_Name = 4;
  var kAudioStreamFactory_CreateLoopbackStream_Name = 5;

  function AudioStreamFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioStreamFactory,
                                                   handleOrPtrInfo);
  }

  function AudioStreamFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioStreamFactory, associatedInterfacePtrInfo);
  }

  AudioStreamFactoryAssociatedPtr.prototype =
      Object.create(AudioStreamFactoryPtr.prototype);
  AudioStreamFactoryAssociatedPtr.prototype.constructor =
      AudioStreamFactoryAssociatedPtr;

  function AudioStreamFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioStreamFactoryPtr.prototype.createInputStream = function() {
    return AudioStreamFactoryProxy.prototype.createInputStream
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioStreamFactoryProxy.prototype.createInputStream = function(stream, client, observer, log, deviceId, params, groupId, sharedMemoryCount, enableAgc, processingConfig) {
    var params_ = new AudioStreamFactory_CreateInputStream_Params();
    params_.stream = stream;
    params_.client = client;
    params_.observer = observer;
    params_.log = log;
    params_.deviceId = deviceId;
    params_.params = params;
    params_.groupId = groupId;
    params_.sharedMemoryCount = sharedMemoryCount;
    params_.enableAgc = enableAgc;
    params_.processingConfig = processingConfig;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioStreamFactory_CreateInputStream_Name,
          codec.align(AudioStreamFactory_CreateInputStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioStreamFactory_CreateInputStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioStreamFactory_CreateInputStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioStreamFactoryPtr.prototype.associateInputAndOutputForAec = function() {
    return AudioStreamFactoryProxy.prototype.associateInputAndOutputForAec
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioStreamFactoryProxy.prototype.associateInputAndOutputForAec = function(inputStreamId, outputDeviceId) {
    var params_ = new AudioStreamFactory_AssociateInputAndOutputForAec_Params();
    params_.inputStreamId = inputStreamId;
    params_.outputDeviceId = outputDeviceId;
    var builder = new codec.MessageV0Builder(
        kAudioStreamFactory_AssociateInputAndOutputForAec_Name,
        codec.align(AudioStreamFactory_AssociateInputAndOutputForAec_Params.encodedSize));
    builder.encodeStruct(AudioStreamFactory_AssociateInputAndOutputForAec_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioStreamFactoryPtr.prototype.createOutputStream = function() {
    return AudioStreamFactoryProxy.prototype.createOutputStream
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioStreamFactoryProxy.prototype.createOutputStream = function(stream, observer, log, deviceId, params, groupId) {
    var params_ = new AudioStreamFactory_CreateOutputStream_Params();
    params_.stream = stream;
    params_.observer = observer;
    params_.log = log;
    params_.deviceId = deviceId;
    params_.params = params;
    params_.groupId = groupId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kAudioStreamFactory_CreateOutputStream_Name,
          codec.align(AudioStreamFactory_CreateOutputStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(AudioStreamFactory_CreateOutputStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioStreamFactory_CreateOutputStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioStreamFactoryPtr.prototype.createSwitchableOutputStream = function() {
    return AudioStreamFactoryProxy.prototype.createSwitchableOutputStream
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioStreamFactoryProxy.prototype.createSwitchableOutputStream = function(stream, deviceSwitchReceiver, observer, log, deviceId, params, groupId) {
    var params_ = new AudioStreamFactory_CreateSwitchableOutputStream_Params();
    params_.stream = stream;
    params_.deviceSwitchReceiver = deviceSwitchReceiver;
    params_.observer = observer;
    params_.log = log;
    params_.deviceId = deviceId;
    params_.params = params;
    params_.groupId = groupId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kAudioStreamFactory_CreateSwitchableOutputStream_Name,
          codec.align(AudioStreamFactory_CreateSwitchableOutputStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(AudioStreamFactory_CreateSwitchableOutputStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioStreamFactoryPtr.prototype.bindMuter = function() {
    return AudioStreamFactoryProxy.prototype.bindMuter
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioStreamFactoryProxy.prototype.bindMuter = function(receiver, groupId) {
    var params_ = new AudioStreamFactory_BindMuter_Params();
    params_.receiver = receiver;
    params_.groupId = groupId;
    var builder = new codec.MessageV2Builder(
        kAudioStreamFactory_BindMuter_Name,
        codec.align(AudioStreamFactory_BindMuter_Params.encodedSize));
    builder.setPayload(AudioStreamFactory_BindMuter_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioStreamFactoryPtr.prototype.createLoopbackStream = function() {
    return AudioStreamFactoryProxy.prototype.createLoopbackStream
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioStreamFactoryProxy.prototype.createLoopbackStream = function(receiver, client, observer, params, sharedMemoryCount, groupId) {
    var params_ = new AudioStreamFactory_CreateLoopbackStream_Params();
    params_.receiver = receiver;
    params_.client = client;
    params_.observer = observer;
    params_.params = params;
    params_.sharedMemoryCount = sharedMemoryCount;
    params_.groupId = groupId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioStreamFactory_CreateLoopbackStream_Name,
          codec.align(AudioStreamFactory_CreateLoopbackStream_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioStreamFactory_CreateLoopbackStream_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioStreamFactory_CreateLoopbackStream_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AudioStreamFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioStreamFactoryStub.prototype.createInputStream = function(stream, client, observer, log, deviceId, params, groupId, sharedMemoryCount, enableAgc, processingConfig) {
    return this.delegate_ && this.delegate_.createInputStream && this.delegate_.createInputStream(stream, client, observer, log, deviceId, params, groupId, sharedMemoryCount, enableAgc, processingConfig);
  }
  AudioStreamFactoryStub.prototype.associateInputAndOutputForAec = function(inputStreamId, outputDeviceId) {
    return this.delegate_ && this.delegate_.associateInputAndOutputForAec && this.delegate_.associateInputAndOutputForAec(inputStreamId, outputDeviceId);
  }
  AudioStreamFactoryStub.prototype.createOutputStream = function(stream, observer, log, deviceId, params, groupId) {
    return this.delegate_ && this.delegate_.createOutputStream && this.delegate_.createOutputStream(stream, observer, log, deviceId, params, groupId);
  }
  AudioStreamFactoryStub.prototype.createSwitchableOutputStream = function(stream, deviceSwitchReceiver, observer, log, deviceId, params, groupId) {
    return this.delegate_ && this.delegate_.createSwitchableOutputStream && this.delegate_.createSwitchableOutputStream(stream, deviceSwitchReceiver, observer, log, deviceId, params, groupId);
  }
  AudioStreamFactoryStub.prototype.bindMuter = function(receiver, groupId) {
    return this.delegate_ && this.delegate_.bindMuter && this.delegate_.bindMuter(receiver, groupId);
  }
  AudioStreamFactoryStub.prototype.createLoopbackStream = function(receiver, client, observer, params, sharedMemoryCount, groupId) {
    return this.delegate_ && this.delegate_.createLoopbackStream && this.delegate_.createLoopbackStream(receiver, client, observer, params, sharedMemoryCount, groupId);
  }

  AudioStreamFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioStreamFactory_AssociateInputAndOutputForAec_Name:
      var params = reader.decodeStruct(AudioStreamFactory_AssociateInputAndOutputForAec_Params);
      this.associateInputAndOutputForAec(params.inputStreamId, params.outputDeviceId);
      return true;
    case kAudioStreamFactory_BindMuter_Name:
      var params = reader.decodeStruct(AudioStreamFactory_BindMuter_Params);
      this.bindMuter(params.receiver, params.groupId);
      return true;
    default:
      return false;
    }
  };

  AudioStreamFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioStreamFactory_CreateInputStream_Name:
      var params = reader.decodeStruct(AudioStreamFactory_CreateInputStream_Params);
      this.createInputStream(params.stream, params.client, params.observer, params.log, params.deviceId, params.params, params.groupId, params.sharedMemoryCount, params.enableAgc, params.processingConfig).then(function(response) {
        var responseParams =
            new AudioStreamFactory_CreateInputStream_ResponseParams();
        responseParams.dataPipe = response.dataPipe;
        responseParams.initiallyMuted = response.initiallyMuted;
        responseParams.streamId = response.streamId;
        var builder = new codec.MessageV1Builder(
            kAudioStreamFactory_CreateInputStream_Name,
            codec.align(AudioStreamFactory_CreateInputStream_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioStreamFactory_CreateInputStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioStreamFactory_CreateOutputStream_Name:
      var params = reader.decodeStruct(AudioStreamFactory_CreateOutputStream_Params);
      this.createOutputStream(params.stream, params.observer, params.log, params.deviceId, params.params, params.groupId).then(function(response) {
        var responseParams =
            new AudioStreamFactory_CreateOutputStream_ResponseParams();
        responseParams.dataPipe = response.dataPipe;
        var builder = new codec.MessageV2Builder(
            kAudioStreamFactory_CreateOutputStream_Name,
            codec.align(AudioStreamFactory_CreateOutputStream_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(AudioStreamFactory_CreateOutputStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioStreamFactory_CreateSwitchableOutputStream_Name:
      var params = reader.decodeStruct(AudioStreamFactory_CreateSwitchableOutputStream_Params);
      this.createSwitchableOutputStream(params.stream, params.deviceSwitchReceiver, params.observer, params.log, params.deviceId, params.params, params.groupId).then(function(response) {
        var responseParams =
            new AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams();
        responseParams.dataPipe = response.dataPipe;
        var builder = new codec.MessageV2Builder(
            kAudioStreamFactory_CreateSwitchableOutputStream_Name,
            codec.align(AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioStreamFactory_CreateLoopbackStream_Name:
      var params = reader.decodeStruct(AudioStreamFactory_CreateLoopbackStream_Params);
      this.createLoopbackStream(params.receiver, params.client, params.observer, params.params, params.sharedMemoryCount, params.groupId).then(function(response) {
        var responseParams =
            new AudioStreamFactory_CreateLoopbackStream_ResponseParams();
        responseParams.dataPipe = response.dataPipe;
        var builder = new codec.MessageV1Builder(
            kAudioStreamFactory_CreateLoopbackStream_Name,
            codec.align(AudioStreamFactory_CreateLoopbackStream_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioStreamFactory_CreateLoopbackStream_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAudioStreamFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioStreamFactory_CreateInputStream_Name:
        if (message.expectsResponse())
          paramsClass = AudioStreamFactory_CreateInputStream_Params;
      break;
      case kAudioStreamFactory_AssociateInputAndOutputForAec_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioStreamFactory_AssociateInputAndOutputForAec_Params;
      break;
      case kAudioStreamFactory_CreateOutputStream_Name:
        if (message.expectsResponse())
          paramsClass = AudioStreamFactory_CreateOutputStream_Params;
      break;
      case kAudioStreamFactory_CreateSwitchableOutputStream_Name:
        if (message.expectsResponse())
          paramsClass = AudioStreamFactory_CreateSwitchableOutputStream_Params;
      break;
      case kAudioStreamFactory_BindMuter_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioStreamFactory_BindMuter_Params;
      break;
      case kAudioStreamFactory_CreateLoopbackStream_Name:
        if (message.expectsResponse())
          paramsClass = AudioStreamFactory_CreateLoopbackStream_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioStreamFactoryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAudioStreamFactory_CreateInputStream_Name:
        if (message.isResponse())
          paramsClass = AudioStreamFactory_CreateInputStream_ResponseParams;
        break;
      case kAudioStreamFactory_CreateOutputStream_Name:
        if (message.isResponse())
          paramsClass = AudioStreamFactory_CreateOutputStream_ResponseParams;
        break;
      case kAudioStreamFactory_CreateSwitchableOutputStream_Name:
        if (message.isResponse())
          paramsClass = AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams;
        break;
      case kAudioStreamFactory_CreateLoopbackStream_Name:
        if (message.isResponse())
          paramsClass = AudioStreamFactory_CreateLoopbackStream_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AudioStreamFactory = {
    name: 'media.mojom.AudioStreamFactory',
    kVersion: 0,
    ptrClass: AudioStreamFactoryPtr,
    proxyClass: AudioStreamFactoryProxy,
    stubClass: AudioStreamFactoryStub,
    validateRequest: validateAudioStreamFactoryRequest,
    validateResponse: validateAudioStreamFactoryResponse,
  };
  AudioStreamFactoryStub.prototype.validator = validateAudioStreamFactoryRequest;
  AudioStreamFactoryProxy.prototype.validator = validateAudioStreamFactoryResponse;
  exports.LocalMuter = LocalMuter;
  exports.LocalMuterPtr = LocalMuterPtr;
  exports.LocalMuterAssociatedPtr = LocalMuterAssociatedPtr;
  exports.AudioStreamFactory = AudioStreamFactory;
  exports.AudioStreamFactoryPtr = AudioStreamFactoryPtr;
  exports.AudioStreamFactoryAssociatedPtr = AudioStreamFactoryAssociatedPtr;
})();