// media/mojo/mojom/audio_stream_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_stream_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_stream_factory.mojom-params-data.h"
#include "media/mojo/mojom/audio_stream_factory.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_stream_factory.mojom-import-headers.h"
#include "media/mojo/mojom/audio_stream_factory.mojom-test-utils.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

LocalMuter::IPCStableHashFunction LocalMuter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalMuter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

LocalMuterProxy::LocalMuterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool LocalMuterStubDispatch::Accept(
    LocalMuter* impl,
    mojo::Message* message) {
  return false;
}

// static
bool LocalMuterStubDispatch::AcceptWithResponder(
    LocalMuter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool LocalMuterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::LocalMuter::Name_,
    {});
}

// The declaration includes the definition on other builds.

AudioStreamFactory::IPCStableHashFunction AudioStreamFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioStreamFactory>(message.name())) {
    case messages::AudioStreamFactory::kCreateInputStream: {
      return &AudioStreamFactory::CreateInputStream_Sym::IPCStableHash;
    }
    case messages::AudioStreamFactory::kAssociateInputAndOutputForAec: {
      return &AudioStreamFactory::AssociateInputAndOutputForAec_Sym::IPCStableHash;
    }
    case messages::AudioStreamFactory::kCreateOutputStream: {
      return &AudioStreamFactory::CreateOutputStream_Sym::IPCStableHash;
    }
    case messages::AudioStreamFactory::kCreateSwitchableOutputStream: {
      return &AudioStreamFactory::CreateSwitchableOutputStream_Sym::IPCStableHash;
    }
    case messages::AudioStreamFactory::kBindMuter: {
      return &AudioStreamFactory::BindMuter_Sym::IPCStableHash;
    }
    case messages::AudioStreamFactory::kCreateLoopbackStream: {
      return &AudioStreamFactory::CreateLoopbackStream_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioStreamFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioStreamFactory>(message.name())) {
      case messages::AudioStreamFactory::kCreateInputStream:
            return "Receive media::mojom::AudioStreamFactory::CreateInputStream";
      case messages::AudioStreamFactory::kAssociateInputAndOutputForAec:
            return "Receive media::mojom::AudioStreamFactory::AssociateInputAndOutputForAec";
      case messages::AudioStreamFactory::kCreateOutputStream:
            return "Receive media::mojom::AudioStreamFactory::CreateOutputStream";
      case messages::AudioStreamFactory::kCreateSwitchableOutputStream:
            return "Receive media::mojom::AudioStreamFactory::CreateSwitchableOutputStream";
      case messages::AudioStreamFactory::kBindMuter:
            return "Receive media::mojom::AudioStreamFactory::BindMuter";
      case messages::AudioStreamFactory::kCreateLoopbackStream:
            return "Receive media::mojom::AudioStreamFactory::CreateLoopbackStream";
    }
  } else {
    switch (static_cast<messages::AudioStreamFactory>(message.name())) {
      case messages::AudioStreamFactory::kCreateInputStream:
            return "Receive reply media::mojom::AudioStreamFactory::CreateInputStream";
      case messages::AudioStreamFactory::kAssociateInputAndOutputForAec:
            return "Receive reply media::mojom::AudioStreamFactory::AssociateInputAndOutputForAec";
      case messages::AudioStreamFactory::kCreateOutputStream:
            return "Receive reply media::mojom::AudioStreamFactory::CreateOutputStream";
      case messages::AudioStreamFactory::kCreateSwitchableOutputStream:
            return "Receive reply media::mojom::AudioStreamFactory::CreateSwitchableOutputStream";
      case messages::AudioStreamFactory::kBindMuter:
            return "Receive reply media::mojom::AudioStreamFactory::BindMuter";
      case messages::AudioStreamFactory::kCreateLoopbackStream:
            return "Receive reply media::mojom::AudioStreamFactory::CreateLoopbackStream";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioStreamFactory::CreateInputStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x829cb615;  // IPCStableHash for media::mojom::AudioStreamFactory::CreateInputStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioStreamFactory::AssociateInputAndOutputForAec_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45e263ed;  // IPCStableHash for media::mojom::AudioStreamFactory::AssociateInputAndOutputForAec
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioStreamFactory::CreateOutputStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd03767eb;  // IPCStableHash for media::mojom::AudioStreamFactory::CreateOutputStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioStreamFactory::CreateSwitchableOutputStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85775a2a;  // IPCStableHash for media::mojom::AudioStreamFactory::CreateSwitchableOutputStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioStreamFactory::BindMuter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72900c59;  // IPCStableHash for media::mojom::AudioStreamFactory::BindMuter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioStreamFactory::CreateLoopbackStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c9b4249;  // IPCStableHash for media::mojom::AudioStreamFactory::CreateLoopbackStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioStreamFactory_CreateInputStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioStreamFactory_CreateInputStream_ForwardToCallback(
      AudioStreamFactory::CreateInputStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioStreamFactory_CreateInputStream_ForwardToCallback(const AudioStreamFactory_CreateInputStream_ForwardToCallback&) = delete;
  AudioStreamFactory_CreateInputStream_ForwardToCallback& operator=(const AudioStreamFactory_CreateInputStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioStreamFactory::CreateInputStreamCallback callback_;
};

class AudioStreamFactory_CreateOutputStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioStreamFactory_CreateOutputStream_ForwardToCallback(
      AudioStreamFactory::CreateOutputStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioStreamFactory_CreateOutputStream_ForwardToCallback(const AudioStreamFactory_CreateOutputStream_ForwardToCallback&) = delete;
  AudioStreamFactory_CreateOutputStream_ForwardToCallback& operator=(const AudioStreamFactory_CreateOutputStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioStreamFactory::CreateOutputStreamCallback callback_;
};

class AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback(
      AudioStreamFactory::CreateSwitchableOutputStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback(const AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback&) = delete;
  AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback& operator=(const AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioStreamFactory::CreateSwitchableOutputStreamCallback callback_;
};

class AudioStreamFactory_CreateLoopbackStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioStreamFactory_CreateLoopbackStream_ForwardToCallback(
      AudioStreamFactory::CreateLoopbackStreamCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioStreamFactory_CreateLoopbackStream_ForwardToCallback(const AudioStreamFactory_CreateLoopbackStream_ForwardToCallback&) = delete;
  AudioStreamFactory_CreateLoopbackStream_ForwardToCallback& operator=(const AudioStreamFactory_CreateLoopbackStream_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioStreamFactory::CreateLoopbackStreamCallback callback_;
};

AudioStreamFactoryProxy::AudioStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioStreamFactoryProxy::CreateInputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> in_stream, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> in_client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> in_observer, ::mojo::PendingRemote<::media::mojom::AudioLog> in_log, const std::string& in_device_id, const ::media::AudioParameters& in_params, const ::base::UnguessableToken& in_group_id, uint32_t in_shared_memory_count, bool in_enable_agc, ::media::mojom::AudioProcessingConfigPtr in_processing_config, CreateInputStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioStreamFactory::CreateInputStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioInputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log"), in_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory_count"), in_shared_memory_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable_agc"), in_enable_agc,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("processing_config"), in_processing_config,
                        "<value of type ::media::mojom::AudioProcessingConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateInputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateInputStream_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in AudioStreamFactory.CreateInputStream request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AudioStreamFactory.CreateInputStream request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
    in_log,
    &params->log,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in AudioStreamFactory.CreateInputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AudioStreamFactory.CreateInputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in AudioStreamFactory.CreateInputStream request");

  params->shared_memory_count = in_shared_memory_count;

  params->enable_agc = in_enable_agc;
  mojo::internal::MessageFragment<
      typename decltype(params->processing_config)::BaseType> processing_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioProcessingConfigDataView>(
    in_processing_config,
    processing_config_fragment);

  params->processing_config.Set(
      processing_config_fragment.is_null() ? nullptr : processing_config_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateInputStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioStreamFactory_CreateInputStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioStreamFactoryProxy::AssociateInputAndOutputForAec(
    const ::base::UnguessableToken& in_input_stream_id, const std::string& in_output_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioStreamFactory::AssociateInputAndOutputForAec", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_stream_id"), in_input_stream_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_device_id"), in_output_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kAssociateInputAndOutputForAec), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_stream_id)::BaseType> input_stream_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_input_stream_id,
    input_stream_id_fragment);

  params->input_stream_id.Set(
      input_stream_id_fragment.is_null() ? nullptr : input_stream_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_stream_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_stream_id in AudioStreamFactory.AssociateInputAndOutputForAec request");
  mojo::internal::MessageFragment<
      typename decltype(params->output_device_id)::BaseType> output_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_output_device_id,
    output_device_id_fragment);

  params->output_device_id.Set(
      output_device_id_fragment.is_null() ? nullptr : output_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output_device_id in AudioStreamFactory.AssociateInputAndOutputForAec request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("AssociateInputAndOutputForAec");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioStreamFactoryProxy::CreateOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> in_stream, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> in_observer, ::mojo::PendingRemote<::media::mojom::AudioLog> in_log, const std::string& in_device_id, const ::media::AudioParameters& in_params, const ::base::UnguessableToken& in_group_id, CreateOutputStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioStreamFactory::CreateOutputStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioOutputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log"), in_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateOutputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateOutputStream_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in AudioStreamFactory.CreateOutputStream request");

  
  mojo::internal::Serialize<::media::mojom::AudioOutputStreamObserverAssociatedPtrInfoDataView>(
    in_observer,
    &params->observer,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
    in_log,
    &params->log,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in AudioStreamFactory.CreateOutputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AudioStreamFactory.CreateOutputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in AudioStreamFactory.CreateOutputStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateOutputStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioStreamFactory_CreateOutputStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioStreamFactoryProxy::CreateSwitchableOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> in_stream, ::mojo::PendingReceiver<::media::mojom::DeviceSwitchInterface> in_device_switch_receiver, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> in_observer, ::mojo::PendingRemote<::media::mojom::AudioLog> in_log, const std::string& in_device_id, const ::media::AudioParameters& in_params, const ::base::UnguessableToken& in_group_id, CreateSwitchableOutputStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioStreamFactory::CreateSwitchableOutputStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioOutputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_switch_receiver"), in_device_switch_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::DeviceSwitchInterface>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log"), in_log,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioLog>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateSwitchableOutputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamInterfaceBase>>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in AudioStreamFactory.CreateSwitchableOutputStream request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::DeviceSwitchInterfaceInterfaceBase>>(
    in_device_switch_receiver,
    &params->device_switch_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->device_switch_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid device_switch_receiver in AudioStreamFactory.CreateSwitchableOutputStream request");

  
  mojo::internal::Serialize<::media::mojom::AudioOutputStreamObserverAssociatedPtrInfoDataView>(
    in_observer,
    &params->observer,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioLogInterfaceBase>>(
    in_log,
    &params->log,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in AudioStreamFactory.CreateSwitchableOutputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AudioStreamFactory.CreateSwitchableOutputStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in AudioStreamFactory.CreateSwitchableOutputStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateSwitchableOutputStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioStreamFactoryProxy::BindMuter(
    ::mojo::PendingAssociatedReceiver<LocalMuter> in_receiver, const ::base::UnguessableToken& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioStreamFactory::BindMuter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<LocalMuter>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kBindMuter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_BindMuter_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::LocalMuterAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in AudioStreamFactory.BindMuter request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in AudioStreamFactory.BindMuter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("BindMuter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioStreamFactoryProxy::CreateLoopbackStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> in_receiver, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> in_client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> in_observer, const ::media::AudioParameters& in_params, uint32_t in_shared_memory_count, const ::base::UnguessableToken& in_group_id, CreateLoopbackStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioStreamFactory::CreateLoopbackStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioInputStream>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory_count"), in_shared_memory_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateLoopbackStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateLoopbackStream_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioInputStreamInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioStreamFactory.CreateLoopbackStream request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in AudioStreamFactory.CreateLoopbackStream request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::AudioInputStreamObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in AudioStreamFactory.CreateLoopbackStream request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in AudioStreamFactory.CreateLoopbackStream request");

  params->shared_memory_count = in_shared_memory_count;
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in AudioStreamFactory.CreateLoopbackStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateLoopbackStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioStreamFactory_CreateLoopbackStream_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AudioStreamFactory_CreateInputStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioStreamFactory::CreateInputStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioStreamFactory_CreateInputStream_ProxyToResponder> proxy(
        new AudioStreamFactory_CreateInputStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioStreamFactory_CreateInputStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioStreamFactory_CreateInputStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioStreamFactory_CreateInputStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioStreamFactory::CreateInputStreamCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe, bool in_initially_muted, const std::optional<::base::UnguessableToken>& in_stream_id);
};

bool AudioStreamFactory_CreateInputStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioStreamFactory_CreateInputStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioStreamFactory_CreateInputStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioStreamFactory.0
  bool success = true;
  ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
  bool p_initially_muted{};
  std::optional<::base::UnguessableToken> p_stream_id{};
  AudioStreamFactory_CreateInputStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (success)
    p_initially_muted = input_data_view.initially_muted();
  if (success && !input_data_view.ReadStreamId(&p_stream_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioStreamFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data_pipe), 
std::move(p_initially_muted), 
std::move(p_stream_id));
  }
  return true;
}

void AudioStreamFactory_CreateInputStream_ProxyToResponder::Run(
    ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe, bool in_initially_muted, const std::optional<::base::UnguessableToken>& in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioStreamFactory::CreateInputStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initially_muted"), in_initially_muted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateInputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateInputStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
    in_data_pipe,
    data_pipe_fragment);

  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

  params->initially_muted = in_initially_muted;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_id)::BaseType> stream_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_stream_id,
    stream_id_fragment);

  params->stream_id.Set(
      stream_id_fragment.is_null() ? nullptr : stream_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateInputStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioStreamFactory_CreateOutputStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioStreamFactory::CreateOutputStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioStreamFactory_CreateOutputStream_ProxyToResponder> proxy(
        new AudioStreamFactory_CreateOutputStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioStreamFactory_CreateOutputStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioStreamFactory_CreateOutputStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioStreamFactory_CreateOutputStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioStreamFactory::CreateOutputStreamCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe);
};

bool AudioStreamFactory_CreateOutputStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioStreamFactory_CreateOutputStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioStreamFactory_CreateOutputStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioStreamFactory.2
  bool success = true;
  ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
  AudioStreamFactory_CreateOutputStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioStreamFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data_pipe));
  }
  return true;
}

void AudioStreamFactory_CreateOutputStream_ProxyToResponder::Run(
    ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioStreamFactory::CreateOutputStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateOutputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateOutputStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
    in_data_pipe,
    data_pipe_fragment);

  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateOutputStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioStreamFactory::CreateSwitchableOutputStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder> proxy(
        new AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioStreamFactory::CreateSwitchableOutputStreamCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe);
};

bool AudioStreamFactory_CreateSwitchableOutputStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioStreamFactory.3
  bool success = true;
  ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
  AudioStreamFactory_CreateSwitchableOutputStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioStreamFactory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data_pipe));
  }
  return true;
}

void AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder::Run(
    ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioStreamFactory::CreateSwitchableOutputStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateSwitchableOutputStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
    in_data_pipe,
    data_pipe_fragment);

  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateSwitchableOutputStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioStreamFactory_CreateLoopbackStream_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioStreamFactory::CreateLoopbackStreamCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioStreamFactory_CreateLoopbackStream_ProxyToResponder> proxy(
        new AudioStreamFactory_CreateLoopbackStream_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioStreamFactory_CreateLoopbackStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioStreamFactory_CreateLoopbackStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioStreamFactory_CreateLoopbackStream_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioStreamFactory::CreateLoopbackStreamCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe);
};

bool AudioStreamFactory_CreateLoopbackStream_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioStreamFactory.5
  bool success = true;
  ::media::mojom::ReadWriteAudioDataPipePtr p_data_pipe{};
  AudioStreamFactory_CreateLoopbackStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDataPipe(&p_data_pipe))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioStreamFactory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data_pipe));
  }
  return true;
}

void AudioStreamFactory_CreateLoopbackStream_ProxyToResponder::Run(
    ::media::mojom::ReadWriteAudioDataPipePtr in_data_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioStreamFactory::CreateLoopbackStream", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_pipe"), in_data_pipe,
                        "<value of type ::media::mojom::ReadWriteAudioDataPipePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioStreamFactory::kCreateLoopbackStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data_pipe)::BaseType> data_pipe_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::ReadWriteAudioDataPipeDataView>(
    in_data_pipe,
    data_pipe_fragment);

  params->data_pipe.Set(
      data_pipe_fragment.is_null() ? nullptr : data_pipe_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioStreamFactory::Name_);
  message.set_method_name("CreateLoopbackStream");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioStreamFactoryStubDispatch::Accept(
    AudioStreamFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioStreamFactory>(message->header()->name)) {
    case messages::AudioStreamFactory::kCreateInputStream: {
      break;
    }
    case messages::AudioStreamFactory::kAssociateInputAndOutputForAec: {
      DCHECK(message->is_serialized());
      internal::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data* params =
          reinterpret_cast<internal::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioStreamFactory.1
      bool success = true;
      ::base::UnguessableToken p_input_stream_id{};
      std::string p_output_device_id{};
      AudioStreamFactory_AssociateInputAndOutputForAec_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputStreamId(&p_input_stream_id))
        success = false;
      if (success && !input_data_view.ReadOutputDeviceId(&p_output_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioStreamFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AssociateInputAndOutputForAec(        
        std::move(p_input_stream_id), 
        std::move(p_output_device_id));
      return true;
    }
    case messages::AudioStreamFactory::kCreateOutputStream: {
      break;
    }
    case messages::AudioStreamFactory::kCreateSwitchableOutputStream: {
      break;
    }
    case messages::AudioStreamFactory::kBindMuter: {
      DCHECK(message->is_serialized());
      internal::AudioStreamFactory_BindMuter_Params_Data* params =
          reinterpret_cast<internal::AudioStreamFactory_BindMuter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioStreamFactory.4
      bool success = true;
      ::mojo::PendingAssociatedReceiver<LocalMuter> p_receiver{};
      ::base::UnguessableToken p_group_id{};
      AudioStreamFactory_BindMuter_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioStreamFactory::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindMuter(        
        std::move(p_receiver), 
        std::move(p_group_id));
      return true;
    }
    case messages::AudioStreamFactory::kCreateLoopbackStream: {
      break;
    }
  }
  return false;
}

// static
bool AudioStreamFactoryStubDispatch::AcceptWithResponder(
    AudioStreamFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioStreamFactory>(message->header()->name)) {
    case messages::AudioStreamFactory::kCreateInputStream: {
      internal::AudioStreamFactory_CreateInputStream_Params_Data* params =
          reinterpret_cast<
              internal::AudioStreamFactory_CreateInputStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioStreamFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioInputStream> p_stream{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> p_observer{};
      ::mojo::PendingRemote<::media::mojom::AudioLog> p_log{};
      std::string p_device_id{};
      ::media::AudioParameters p_params{};
      ::base::UnguessableToken p_group_id{};
      uint32_t p_shared_memory_count{};
      bool p_enable_agc{};
      ::media::mojom::AudioProcessingConfigPtr p_processing_config{};
      AudioStreamFactory_CreateInputStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_log =
            input_data_view.TakeLog<decltype(p_log)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success)
        p_shared_memory_count = input_data_view.shared_memory_count();
      if (success)
        p_enable_agc = input_data_view.enable_agc();
      if (success && !input_data_view.ReadProcessingConfig(&p_processing_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioStreamFactory::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioStreamFactory_CreateInputStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateInputStream(        
        std::move(p_stream), 
        std::move(p_client), 
        std::move(p_observer), 
        std::move(p_log), 
        std::move(p_device_id), 
        std::move(p_params), 
        std::move(p_group_id), 
        std::move(p_shared_memory_count), 
        std::move(p_enable_agc), 
        std::move(p_processing_config), std::move(callback));
      return true;
    }
    case messages::AudioStreamFactory::kAssociateInputAndOutputForAec: {
      break;
    }
    case messages::AudioStreamFactory::kCreateOutputStream: {
      internal::AudioStreamFactory_CreateOutputStream_Params_Data* params =
          reinterpret_cast<
              internal::AudioStreamFactory_CreateOutputStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioStreamFactory.2
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> p_stream{};
      ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> p_observer{};
      ::mojo::PendingRemote<::media::mojom::AudioLog> p_log{};
      std::string p_device_id{};
      ::media::AudioParameters p_params{};
      ::base::UnguessableToken p_group_id{};
      AudioStreamFactory_CreateOutputStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_log =
            input_data_view.TakeLog<decltype(p_log)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioStreamFactory::Name_, 2, false);
        return false;
      }
      auto callback =
          AudioStreamFactory_CreateOutputStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateOutputStream(        
        std::move(p_stream), 
        std::move(p_observer), 
        std::move(p_log), 
        std::move(p_device_id), 
        std::move(p_params), 
        std::move(p_group_id), std::move(callback));
      return true;
    }
    case messages::AudioStreamFactory::kCreateSwitchableOutputStream: {
      internal::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data* params =
          reinterpret_cast<
              internal::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioStreamFactory.3
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> p_stream{};
      ::mojo::PendingReceiver<::media::mojom::DeviceSwitchInterface> p_device_switch_receiver{};
      ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> p_observer{};
      ::mojo::PendingRemote<::media::mojom::AudioLog> p_log{};
      std::string p_device_id{};
      ::media::AudioParameters p_params{};
      ::base::UnguessableToken p_group_id{};
      AudioStreamFactory_CreateSwitchableOutputStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_device_switch_receiver =
            input_data_view.TakeDeviceSwitchReceiver<decltype(p_device_switch_receiver)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success) {
        p_log =
            input_data_view.TakeLog<decltype(p_log)>();
      }
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioStreamFactory::Name_, 3, false);
        return false;
      }
      auto callback =
          AudioStreamFactory_CreateSwitchableOutputStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSwitchableOutputStream(        
        std::move(p_stream), 
        std::move(p_device_switch_receiver), 
        std::move(p_observer), 
        std::move(p_log), 
        std::move(p_device_id), 
        std::move(p_params), 
        std::move(p_group_id), std::move(callback));
      return true;
    }
    case messages::AudioStreamFactory::kBindMuter: {
      break;
    }
    case messages::AudioStreamFactory::kCreateLoopbackStream: {
      internal::AudioStreamFactory_CreateLoopbackStream_Params_Data* params =
          reinterpret_cast<
              internal::AudioStreamFactory_CreateLoopbackStream_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioStreamFactory.5
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioInputStream> p_receiver{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> p_client{};
      ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> p_observer{};
      ::media::AudioParameters p_params{};
      uint32_t p_shared_memory_count{};
      ::base::UnguessableToken p_group_id{};
      AudioStreamFactory_CreateLoopbackStream_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_shared_memory_count = input_data_view.shared_memory_count();
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioStreamFactory::Name_, 5, false);
        return false;
      }
      auto callback =
          AudioStreamFactory_CreateLoopbackStream_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLoopbackStream(        
        std::move(p_receiver), 
        std::move(p_client), 
        std::move(p_observer), 
        std::move(p_params), 
        std::move(p_shared_memory_count), 
        std::move(p_group_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioStreamFactoryValidationInfo[] = {
    { &internal::AudioStreamFactory_CreateInputStream_Params_Data::Validate,
     &internal::AudioStreamFactory_CreateInputStream_ResponseParams_Data::Validate},
    { &internal::AudioStreamFactory_AssociateInputAndOutputForAec_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioStreamFactory_CreateOutputStream_Params_Data::Validate,
     &internal::AudioStreamFactory_CreateOutputStream_ResponseParams_Data::Validate},
    { &internal::AudioStreamFactory_CreateSwitchableOutputStream_Params_Data::Validate,
     &internal::AudioStreamFactory_CreateSwitchableOutputStream_ResponseParams_Data::Validate},
    { &internal::AudioStreamFactory_BindMuter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioStreamFactory_CreateLoopbackStream_Params_Data::Validate,
     &internal::AudioStreamFactory_CreateLoopbackStream_ResponseParams_Data::Validate},
};

bool AudioStreamFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::AudioStreamFactory::Name_,
    kAudioStreamFactoryValidationInfo);
}

bool AudioStreamFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::AudioStreamFactory::Name_,
    kAudioStreamFactoryValidationInfo);
}


}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


LocalMuterAsyncWaiter::LocalMuterAsyncWaiter(
    LocalMuter* proxy) : proxy_(proxy) {}

LocalMuterAsyncWaiter::~LocalMuterAsyncWaiter() = default;





void AudioStreamFactoryInterceptorForTesting::CreateInputStream(::mojo::PendingReceiver<::media::mojom::AudioInputStream> stream, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, uint32_t shared_memory_count, bool enable_agc, ::media::mojom::AudioProcessingConfigPtr processing_config, CreateInputStreamCallback callback) {
  GetForwardingInterface()->CreateInputStream(
    std::move(stream)
    , 
    std::move(client)
    , 
    std::move(observer)
    , 
    std::move(log)
    , 
    std::move(device_id)
    , 
    std::move(params)
    , 
    std::move(group_id)
    , 
    std::move(shared_memory_count)
    , 
    std::move(enable_agc)
    , 
    std::move(processing_config)
    , std::move(callback));
}
void AudioStreamFactoryInterceptorForTesting::AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const std::string& output_device_id) {
  GetForwardingInterface()->AssociateInputAndOutputForAec(
    std::move(input_stream_id)
    , 
    std::move(output_device_id)
    );
}
void AudioStreamFactoryInterceptorForTesting::CreateOutputStream(::mojo::PendingReceiver<::media::mojom::AudioOutputStream> stream, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, CreateOutputStreamCallback callback) {
  GetForwardingInterface()->CreateOutputStream(
    std::move(stream)
    , 
    std::move(observer)
    , 
    std::move(log)
    , 
    std::move(device_id)
    , 
    std::move(params)
    , 
    std::move(group_id)
    , std::move(callback));
}
void AudioStreamFactoryInterceptorForTesting::CreateSwitchableOutputStream(::mojo::PendingReceiver<::media::mojom::AudioOutputStream> stream, ::mojo::PendingReceiver<::media::mojom::DeviceSwitchInterface> device_switch_receiver, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, CreateSwitchableOutputStreamCallback callback) {
  GetForwardingInterface()->CreateSwitchableOutputStream(
    std::move(stream)
    , 
    std::move(device_switch_receiver)
    , 
    std::move(observer)
    , 
    std::move(log)
    , 
    std::move(device_id)
    , 
    std::move(params)
    , 
    std::move(group_id)
    , std::move(callback));
}
void AudioStreamFactoryInterceptorForTesting::BindMuter(::mojo::PendingAssociatedReceiver<LocalMuter> receiver, const ::base::UnguessableToken& group_id) {
  GetForwardingInterface()->BindMuter(
    std::move(receiver)
    , 
    std::move(group_id)
    );
}
void AudioStreamFactoryInterceptorForTesting::CreateLoopbackStream(::mojo::PendingReceiver<::media::mojom::AudioInputStream> receiver, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> observer, const ::media::AudioParameters& params, uint32_t shared_memory_count, const ::base::UnguessableToken& group_id, CreateLoopbackStreamCallback callback) {
  GetForwardingInterface()->CreateLoopbackStream(
    std::move(receiver)
    , 
    std::move(client)
    , 
    std::move(observer)
    , 
    std::move(params)
    , 
    std::move(shared_memory_count)
    , 
    std::move(group_id)
    , std::move(callback));
}
AudioStreamFactoryAsyncWaiter::AudioStreamFactoryAsyncWaiter(
    AudioStreamFactory* proxy) : proxy_(proxy) {}

AudioStreamFactoryAsyncWaiter::~AudioStreamFactoryAsyncWaiter() = default;


void AudioStreamFactoryAsyncWaiter::CreateInputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> stream, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, uint32_t shared_memory_count, bool enable_agc, ::media::mojom::AudioProcessingConfigPtr processing_config, ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe, bool* out_initially_muted, std::optional<::base::UnguessableToken>* out_stream_id) {
  base::RunLoop loop;
  proxy_->CreateInputStream(
      std::move(stream),
      std::move(client),
      std::move(observer),
      std::move(log),
      std::move(device_id),
      std::move(params),
      std::move(group_id),
      std::move(shared_memory_count),
      std::move(enable_agc),
      std::move(processing_config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe
,
             bool* out_initially_muted
,
             std::optional<::base::UnguessableToken>* out_stream_id
,
             ::media::mojom::ReadWriteAudioDataPipePtr data_pipe,
             bool initially_muted,
             const std::optional<::base::UnguessableToken>& stream_id) {*out_data_pipe = std::move(data_pipe);*out_initially_muted = std::move(initially_muted);*out_stream_id = std::move(stream_id);
            loop->Quit();
          },
          &loop,
          out_data_pipe,
          out_initially_muted,
          out_stream_id));
  loop.Run();
}



void AudioStreamFactoryAsyncWaiter::CreateOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> stream, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe) {
  base::RunLoop loop;
  proxy_->CreateOutputStream(
      std::move(stream),
      std::move(observer),
      std::move(log),
      std::move(device_id),
      std::move(params),
      std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe
,
             ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) {*out_data_pipe = std::move(data_pipe);
            loop->Quit();
          },
          &loop,
          out_data_pipe));
  loop.Run();
}

::media::mojom::ReadWriteAudioDataPipePtr AudioStreamFactoryAsyncWaiter::CreateOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> stream, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id) {
  ::media::mojom::ReadWriteAudioDataPipePtr async_wait_result;
  CreateOutputStream(std::move(stream),std::move(observer),std::move(log),std::move(device_id),std::move(params),std::move(group_id),&async_wait_result);
  return async_wait_result;
}

void AudioStreamFactoryAsyncWaiter::CreateSwitchableOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> stream, ::mojo::PendingReceiver<::media::mojom::DeviceSwitchInterface> device_switch_receiver, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id, ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe) {
  base::RunLoop loop;
  proxy_->CreateSwitchableOutputStream(
      std::move(stream),
      std::move(device_switch_receiver),
      std::move(observer),
      std::move(log),
      std::move(device_id),
      std::move(params),
      std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe
,
             ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) {*out_data_pipe = std::move(data_pipe);
            loop->Quit();
          },
          &loop,
          out_data_pipe));
  loop.Run();
}

::media::mojom::ReadWriteAudioDataPipePtr AudioStreamFactoryAsyncWaiter::CreateSwitchableOutputStream(
    ::mojo::PendingReceiver<::media::mojom::AudioOutputStream> stream, ::mojo::PendingReceiver<::media::mojom::DeviceSwitchInterface> device_switch_receiver, ::mojo::PendingAssociatedRemote<::media::mojom::AudioOutputStreamObserver> observer, ::mojo::PendingRemote<::media::mojom::AudioLog> log, const std::string& device_id, const ::media::AudioParameters& params, const ::base::UnguessableToken& group_id) {
  ::media::mojom::ReadWriteAudioDataPipePtr async_wait_result;
  CreateSwitchableOutputStream(std::move(stream),std::move(device_switch_receiver),std::move(observer),std::move(log),std::move(device_id),std::move(params),std::move(group_id),&async_wait_result);
  return async_wait_result;
}

void AudioStreamFactoryAsyncWaiter::CreateLoopbackStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> receiver, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> observer, const ::media::AudioParameters& params, uint32_t shared_memory_count, const ::base::UnguessableToken& group_id, ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe) {
  base::RunLoop loop;
  proxy_->CreateLoopbackStream(
      std::move(receiver),
      std::move(client),
      std::move(observer),
      std::move(params),
      std::move(shared_memory_count),
      std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::ReadWriteAudioDataPipePtr* out_data_pipe
,
             ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) {*out_data_pipe = std::move(data_pipe);
            loop->Quit();
          },
          &loop,
          out_data_pipe));
  loop.Run();
}

::media::mojom::ReadWriteAudioDataPipePtr AudioStreamFactoryAsyncWaiter::CreateLoopbackStream(
    ::mojo::PendingReceiver<::media::mojom::AudioInputStream> receiver, ::mojo::PendingRemote<::media::mojom::AudioInputStreamClient> client, ::mojo::PendingRemote<::media::mojom::AudioInputStreamObserver> observer, const ::media::AudioParameters& params, uint32_t shared_memory_count, const ::base::UnguessableToken& group_id) {
  ::media::mojom::ReadWriteAudioDataPipePtr async_wait_result;
  CreateLoopbackStream(std::move(receiver),std::move(client),std::move(observer),std::move(params),std::move(shared_memory_count),std::move(group_id),&async_wait_result);
  return async_wait_result;
}






}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif