// media/mojo/mojom/audio_processing.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioProcessorControlsPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.AudioProcessorControls', scope);
  }
}

/** @interface */
export class AudioProcessorControlsInterface {
  
  /**
   * @return {!Promise<{
        stats: !AudioProcessingStats,
   *  }>}
   */

  getStats() {}
  
  /**
   * @param { !number } numPreferredChannels
   */

  setPreferredNumCaptureChannels(numPreferredChannels) {}
}

/**
 * @implements { AudioProcessorControlsInterface }
 */
export class AudioProcessorControlsRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioProcessorControlsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioProcessorControlsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioProcessorControlsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        stats: !AudioProcessingStats,
   *  }>}
   */

  getStats() {
    return this.proxy.sendMessage(
        0,
        AudioProcessorControls_GetStats_ParamsSpec.$,
        AudioProcessorControls_GetStats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } numPreferredChannels
   */

  setPreferredNumCaptureChannels(
      numPreferredChannels) {
    this.proxy.sendMessage(
        1,
        AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
        null,
        [
          numPreferredChannels
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioProcessorControls
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioProcessorControlsReceiver {
  /**
   * @param {!AudioProcessorControlsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioProcessorControlsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioProcessorControlsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioProcessorControlsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioProcessorControls_GetStats_ParamsSpec.$,
        AudioProcessorControls_GetStats_ResponseParamsSpec.$,
        impl.getStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
        null,
        impl.setPreferredNumCaptureChannels.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioProcessorControls {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.AudioProcessorControls";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioProcessorControlsRemote}
   */
  static getRemote() {
    let remote = new AudioProcessorControlsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioProcessorControls
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioProcessorControlsCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioProcessorControlsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioProcessorControlsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioProcessorControls_GetStats_ParamsSpec.$,
        AudioProcessorControls_GetStats_ResponseParamsSpec.$,
        this.getStats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPreferredNumCaptureChannels =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
        null,
        this.setPreferredNumCaptureChannels.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioProcessingStatsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioProcessingSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioProcessingConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioProcessorControls_GetStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioProcessorControls_GetStats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioProcessingStatsSpec.$,
    'AudioProcessingStats',
    [
      mojo.internal.StructField(
        'hasEchoReturnLoss', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoReturnLoss', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasEchoReturnLossEnhancement', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'echoReturnLossEnhancement', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioProcessingStats {
  constructor() {
    /** @type { !boolean } */
    this.hasEchoReturnLoss;
    /** @type { !number } */
    this.echoReturnLoss;
    /** @type { !boolean } */
    this.hasEchoReturnLossEnhancement;
    /** @type { !number } */
    this.echoReturnLossEnhancement;
  }
}



mojo.internal.Struct(
    AudioProcessingSettingsSpec.$,
    'AudioProcessingSettings',
    [
      mojo.internal.StructField(
        'echoCancellation', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'noiseSuppression', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'automaticGainControl', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'multiChannelCaptureProcessing', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useLoopbackAecReference', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioProcessingSettings {
  constructor() {
    /** @type { !boolean } */
    this.echoCancellation;
    /** @type { !boolean } */
    this.noiseSuppression;
    /** @type { !boolean } */
    this.automaticGainControl;
    /** @type { !boolean } */
    this.multiChannelCaptureProcessing;
    /** @type { !boolean } */
    this.useLoopbackAecReference;
  }
}



mojo.internal.Struct(
    AudioProcessingConfigSpec.$,
    'AudioProcessingConfig',
    [
      mojo.internal.StructField(
        'controlsReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(AudioProcessorControlsPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        AudioProcessingSettingsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioProcessingConfig {
  constructor() {
    /** @type { !AudioProcessorControlsPendingReceiver } */
    this.controlsReceiver;
    /** @type { !AudioProcessingSettings } */
    this.settings;
  }
}



mojo.internal.Struct(
    AudioProcessorControls_GetStats_ParamsSpec.$,
    'AudioProcessorControls_GetStats_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioProcessorControls_GetStats_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioProcessorControls_GetStats_ResponseParamsSpec.$,
    'AudioProcessorControls_GetStats_ResponseParams',
    [
      mojo.internal.StructField(
        'stats', 0,
        0,
        AudioProcessingStatsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioProcessorControls_GetStats_ResponseParams {
  constructor() {
    /** @type { !AudioProcessingStats } */
    this.stats;
  }
}



mojo.internal.Struct(
    AudioProcessorControls_SetPreferredNumCaptureChannels_ParamsSpec.$,
    'AudioProcessorControls_SetPreferredNumCaptureChannels_Params',
    [
      mojo.internal.StructField(
        'numPreferredChannels', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioProcessorControls_SetPreferredNumCaptureChannels_Params {
  constructor() {
    /** @type { !number } */
    this.numPreferredChannels;
  }
}

