// media/mojo/mojom/audio_output_stream.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_TEST_UTILS_H_
#define MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_TEST_UTILS_H_

#include "media/mojo/mojom/audio_output_stream.mojom.h"


namespace media::mojom {


class  AudioOutputStreamInterceptorForTesting : public AudioOutputStream {
  virtual AudioOutputStream* GetForwardingInterface() = 0;
  void Play() override;
  void Pause() override;
  void Flush() override;
  void SetVolume(double volume) override;
};
class  AudioOutputStreamAsyncWaiter {
 public:
  explicit AudioOutputStreamAsyncWaiter(AudioOutputStream* proxy);

  AudioOutputStreamAsyncWaiter(const AudioOutputStreamAsyncWaiter&) = delete;
  AudioOutputStreamAsyncWaiter& operator=(const AudioOutputStreamAsyncWaiter&) = delete;

  ~AudioOutputStreamAsyncWaiter();

 private:
  AudioOutputStream* const proxy_;
};


class  AudioOutputStreamObserverInterceptorForTesting : public AudioOutputStreamObserver {
  virtual AudioOutputStreamObserver* GetForwardingInterface() = 0;
  void DidStartPlaying() override;
  void DidStopPlaying() override;
  void DidChangeAudibleState(bool is_audible) override;
};
class  AudioOutputStreamObserverAsyncWaiter {
 public:
  explicit AudioOutputStreamObserverAsyncWaiter(AudioOutputStreamObserver* proxy);

  AudioOutputStreamObserverAsyncWaiter(const AudioOutputStreamObserverAsyncWaiter&) = delete;
  AudioOutputStreamObserverAsyncWaiter& operator=(const AudioOutputStreamObserverAsyncWaiter&) = delete;

  ~AudioOutputStreamObserverAsyncWaiter();

 private:
  AudioOutputStreamObserver* const proxy_;
};


class  AudioOutputStreamProviderInterceptorForTesting : public AudioOutputStreamProvider {
  virtual AudioOutputStreamProvider* GetForwardingInterface() = 0;
  void Acquire(const ::media::AudioParameters& params, ::mojo::PendingRemote<AudioOutputStreamProviderClient> client) override;
};
class  AudioOutputStreamProviderAsyncWaiter {
 public:
  explicit AudioOutputStreamProviderAsyncWaiter(AudioOutputStreamProvider* proxy);

  AudioOutputStreamProviderAsyncWaiter(const AudioOutputStreamProviderAsyncWaiter&) = delete;
  AudioOutputStreamProviderAsyncWaiter& operator=(const AudioOutputStreamProviderAsyncWaiter&) = delete;

  ~AudioOutputStreamProviderAsyncWaiter();

 private:
  AudioOutputStreamProvider* const proxy_;
};


class  AudioOutputStreamProviderClientInterceptorForTesting : public AudioOutputStreamProviderClient {
  virtual AudioOutputStreamProviderClient* GetForwardingInterface() = 0;
  void Created(::mojo::PendingRemote<AudioOutputStream> stream, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe) override;
};
class  AudioOutputStreamProviderClientAsyncWaiter {
 public:
  explicit AudioOutputStreamProviderClientAsyncWaiter(AudioOutputStreamProviderClient* proxy);

  AudioOutputStreamProviderClientAsyncWaiter(const AudioOutputStreamProviderClientAsyncWaiter&) = delete;
  AudioOutputStreamProviderClientAsyncWaiter& operator=(const AudioOutputStreamProviderClientAsyncWaiter&) = delete;

  ~AudioOutputStreamProviderClientAsyncWaiter();

 private:
  AudioOutputStreamProviderClient* const proxy_;
};


class  DeviceSwitchInterfaceInterceptorForTesting : public DeviceSwitchInterface {
  virtual DeviceSwitchInterface* GetForwardingInterface() = 0;
  void SwitchAudioOutputDeviceId(const std::string& output_device_id) override;
};
class  DeviceSwitchInterfaceAsyncWaiter {
 public:
  explicit DeviceSwitchInterfaceAsyncWaiter(DeviceSwitchInterface* proxy);

  DeviceSwitchInterfaceAsyncWaiter(const DeviceSwitchInterfaceAsyncWaiter&) = delete;
  DeviceSwitchInterfaceAsyncWaiter& operator=(const DeviceSwitchInterfaceAsyncWaiter&) = delete;

  ~DeviceSwitchInterfaceAsyncWaiter();

 private:
  DeviceSwitchInterface* const proxy_;
};




}  // media::mojom

#endif  // MEDIA_MOJO_MOJOM_AUDIO_OUTPUT_STREAM_MOJOM_TEST_UTILS_H_