// media/mojo/mojom/audio_encoder.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_encoder.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_encoder.mojom-params-data.h"
#include "media/mojo/mojom/audio_encoder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_encoder.mojom-blink-import-headers.h"
#include "media/mojo/mojom/audio_encoder.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
AacAudioEncoderConfig::AacAudioEncoderConfig()
    : format() {}

AacAudioEncoderConfig::AacAudioEncoderConfig(
    AacOutputFormat format_in)
    : format(std::move(format_in)) {}

AacAudioEncoderConfig::~AacAudioEncoderConfig() = default;
size_t AacAudioEncoderConfig::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->format);
  return seed;
}

void AacAudioEncoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AacOutputFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AacAudioEncoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioEncoderConfig::AudioEncoderConfig()
    : codec(),
      channel_count(),
      sample_rate(),
      bitrate(),
      aac() {}

AudioEncoderConfig::AudioEncoderConfig(
    ::media::AudioCodec codec_in,
    uint8_t channel_count_in,
    uint32_t sample_rate_in,
    uint32_t bitrate_in,
    AacAudioEncoderConfigPtr aac_in)
    : codec(std::move(codec_in)),
      channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      bitrate(std::move(bitrate_in)),
      aac(std::move(aac_in)) {}

AudioEncoderConfig::~AudioEncoderConfig() = default;

void AudioEncoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::AudioCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bitrate"), this->bitrate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aac"), this->aac,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AacAudioEncoderConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioEncoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EncodedAudioBuffer::EncodedAudioBuffer()
    : params(),
      timestamp(),
      duration(),
      data() {}

EncodedAudioBuffer::EncodedAudioBuffer(
    const ::media::AudioParameters& params_in,
    ::base::TimeDelta timestamp_in,
    ::base::TimeDelta duration_in,
    ::blink::Vector<uint8_t> data_in)
    : params(std::move(params_in)),
      timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)),
      data(std::move(data_in)) {}

EncodedAudioBuffer::~EncodedAudioBuffer() = default;

void EncodedAudioBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::AudioParameters&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EncodedAudioBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AudioEncoder::IPCStableHashFunction AudioEncoder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioEncoder>(message.name())) {
    case messages::AudioEncoder::kInitialize: {
      return &AudioEncoder::Initialize_Sym::IPCStableHash;
    }
    case messages::AudioEncoder::kEncode: {
      return &AudioEncoder::Encode_Sym::IPCStableHash;
    }
    case messages::AudioEncoder::kFlush: {
      return &AudioEncoder::Flush_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioEncoder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioEncoder>(message.name())) {
      case messages::AudioEncoder::kInitialize:
            return "Receive media::mojom::AudioEncoder::Initialize";
      case messages::AudioEncoder::kEncode:
            return "Receive media::mojom::AudioEncoder::Encode";
      case messages::AudioEncoder::kFlush:
            return "Receive media::mojom::AudioEncoder::Flush";
    }
  } else {
    switch (static_cast<messages::AudioEncoder>(message.name())) {
      case messages::AudioEncoder::kInitialize:
            return "Receive reply media::mojom::AudioEncoder::Initialize";
      case messages::AudioEncoder::kEncode:
            return "Receive reply media::mojom::AudioEncoder::Encode";
      case messages::AudioEncoder::kFlush:
            return "Receive reply media::mojom::AudioEncoder::Flush";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioEncoder::Initialize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74b167cc;  // IPCStableHash for media::mojom::AudioEncoder::Initialize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioEncoder::Encode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4934446f;  // IPCStableHash for media::mojom::AudioEncoder::Encode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioEncoder::Flush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1baa81a4;  // IPCStableHash for media::mojom::AudioEncoder::Flush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AudioEncoder_Initialize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioEncoder_Initialize_ForwardToCallback(
      AudioEncoder::InitializeCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioEncoder_Initialize_ForwardToCallback(const AudioEncoder_Initialize_ForwardToCallback&) = delete;
  AudioEncoder_Initialize_ForwardToCallback& operator=(const AudioEncoder_Initialize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioEncoder::InitializeCallback callback_;
};

class AudioEncoder_Encode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioEncoder_Encode_ForwardToCallback(
      AudioEncoder::EncodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioEncoder_Encode_ForwardToCallback(const AudioEncoder_Encode_ForwardToCallback&) = delete;
  AudioEncoder_Encode_ForwardToCallback& operator=(const AudioEncoder_Encode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioEncoder::EncodeCallback callback_;
};

class AudioEncoder_Flush_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AudioEncoder_Flush_ForwardToCallback(
      AudioEncoder::FlushCallback callback
      ) : callback_(std::move(callback)) {
  }

  AudioEncoder_Flush_ForwardToCallback(const AudioEncoder_Flush_ForwardToCallback&) = delete;
  AudioEncoder_Flush_ForwardToCallback& operator=(const AudioEncoder_Flush_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AudioEncoder::FlushCallback callback_;
};

AudioEncoderProxy::AudioEncoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioEncoderProxy::Initialize(
    ::mojo::PendingAssociatedRemote<AudioEncoderClient> in_client, AudioEncoderConfigPtr in_config, InitializeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioEncoder::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<AudioEncoderClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type AudioEncoderConfigPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoder_Initialize_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::AudioEncoderClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in AudioEncoder.Initialize request");
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioEncoderConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in AudioEncoder.Initialize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoder::Name_);
  message.set_method_name("Initialize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioEncoder_Initialize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioEncoderProxy::Encode(
    ::media::mojom::blink::AudioBufferPtr in_buffer, EncodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioEncoder::Encode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::blink::AudioBufferPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoder::kEncode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoder_Encode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioBufferDataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in AudioEncoder.Encode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoder::Name_);
  message.set_method_name("Encode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioEncoder_Encode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AudioEncoderProxy::Flush(
    FlushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::AudioEncoder::Flush");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoder::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoder_Flush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoder::Name_);
  message.set_method_name("Flush");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AudioEncoder_Flush_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AudioEncoder_Initialize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioEncoder::InitializeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioEncoder_Initialize_ProxyToResponder> proxy(
        new AudioEncoder_Initialize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioEncoder_Initialize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioEncoder_Initialize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioEncoder_Initialize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioEncoder::InitializeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::EncoderStatusPtr in_status);
};

bool AudioEncoder_Initialize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioEncoder_Initialize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioEncoder_Initialize_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioEncoder.0
  bool success = true;
  ::media::mojom::blink::EncoderStatusPtr p_status{};
  AudioEncoder_Initialize_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioEncoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void AudioEncoder_Initialize_ProxyToResponder::Run(
    ::media::mojom::blink::EncoderStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioEncoder::Initialize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::EncoderStatusPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoder::kInitialize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoder_Initialize_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoder::Name_);
  message.set_method_name("Initialize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioEncoder_Encode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioEncoder::EncodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioEncoder_Encode_ProxyToResponder> proxy(
        new AudioEncoder_Encode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioEncoder_Encode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioEncoder_Encode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioEncoder_Encode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioEncoder::EncodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::EncoderStatusPtr in_status);
};

bool AudioEncoder_Encode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioEncoder_Encode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioEncoder_Encode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioEncoder.1
  bool success = true;
  ::media::mojom::blink::EncoderStatusPtr p_status{};
  AudioEncoder_Encode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioEncoder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void AudioEncoder_Encode_ProxyToResponder::Run(
    ::media::mojom::blink::EncoderStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioEncoder::Encode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::EncoderStatusPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoder::kEncode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoder_Encode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoder::Name_);
  message.set_method_name("Encode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class AudioEncoder_Flush_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AudioEncoder::FlushCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AudioEncoder_Flush_ProxyToResponder> proxy(
        new AudioEncoder_Flush_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AudioEncoder_Flush_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AudioEncoder_Flush_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AudioEncoder_Flush_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AudioEncoder::FlushCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::EncoderStatusPtr in_status);
};

bool AudioEncoder_Flush_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AudioEncoder_Flush_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AudioEncoder_Flush_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AudioEncoder.2
  bool success = true;
  ::media::mojom::blink::EncoderStatusPtr p_status{};
  AudioEncoder_Flush_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AudioEncoder::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void AudioEncoder_Flush_ProxyToResponder::Run(
    ::media::mojom::blink::EncoderStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::AudioEncoder::Flush", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::EncoderStatusPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoder::kFlush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoder_Flush_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncoderStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoder::Name_);
  message.set_method_name("Flush");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AudioEncoderStubDispatch::Accept(
    AudioEncoder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioEncoder>(message->header()->name)) {
    case messages::AudioEncoder::kInitialize: {
      break;
    }
    case messages::AudioEncoder::kEncode: {
      break;
    }
    case messages::AudioEncoder::kFlush: {
      break;
    }
  }
  return false;
}

// static
bool AudioEncoderStubDispatch::AcceptWithResponder(
    AudioEncoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioEncoder>(message->header()->name)) {
    case messages::AudioEncoder::kInitialize: {
      internal::AudioEncoder_Initialize_Params_Data* params =
          reinterpret_cast<
              internal::AudioEncoder_Initialize_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioEncoder.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<AudioEncoderClient> p_client{};
      AudioEncoderConfigPtr p_config{};
      AudioEncoder_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioEncoder::Name_, 0, false);
        return false;
      }
      auto callback =
          AudioEncoder_Initialize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(        
        std::move(p_client), 
        std::move(p_config), std::move(callback));
      return true;
    }
    case messages::AudioEncoder::kEncode: {
      internal::AudioEncoder_Encode_Params_Data* params =
          reinterpret_cast<
              internal::AudioEncoder_Encode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioEncoder.1
      bool success = true;
      ::media::mojom::blink::AudioBufferPtr p_buffer{};
      AudioEncoder_Encode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioEncoder::Name_, 1, false);
        return false;
      }
      auto callback =
          AudioEncoder_Encode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Encode(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::AudioEncoder::kFlush: {
      internal::AudioEncoder_Flush_Params_Data* params =
          reinterpret_cast<
              internal::AudioEncoder_Flush_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AudioEncoder.2
      bool success = true;
      AudioEncoder_Flush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioEncoder::Name_, 2, false);
        return false;
      }
      auto callback =
          AudioEncoder_Flush_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Flush(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioEncoderValidationInfo[] = {
    { &internal::AudioEncoder_Initialize_Params_Data::Validate,
     &internal::AudioEncoder_Initialize_ResponseParams_Data::Validate},
    { &internal::AudioEncoder_Encode_Params_Data::Validate,
     &internal::AudioEncoder_Encode_ResponseParams_Data::Validate},
    { &internal::AudioEncoder_Flush_Params_Data::Validate,
     &internal::AudioEncoder_Flush_ResponseParams_Data::Validate},
};

bool AudioEncoderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::AudioEncoder::Name_,
    kAudioEncoderValidationInfo);
}

bool AudioEncoderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::media::mojom::blink::AudioEncoder::Name_,
    kAudioEncoderValidationInfo);
}
// The declaration includes the definition on other builds.

AudioEncoderClient::IPCStableHashFunction AudioEncoderClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioEncoderClient>(message.name())) {
    case messages::AudioEncoderClient::kOnEncodedBufferReady: {
      return &AudioEncoderClient::OnEncodedBufferReady_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioEncoderClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioEncoderClient>(message.name())) {
      case messages::AudioEncoderClient::kOnEncodedBufferReady:
            return "Receive media::mojom::AudioEncoderClient::OnEncodedBufferReady";
    }
  } else {
    switch (static_cast<messages::AudioEncoderClient>(message.name())) {
      case messages::AudioEncoderClient::kOnEncodedBufferReady:
            return "Receive reply media::mojom::AudioEncoderClient::OnEncodedBufferReady";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioEncoderClient::OnEncodedBufferReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08187aa4;  // IPCStableHash for media::mojom::AudioEncoderClient::OnEncodedBufferReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioEncoderClientProxy::AudioEncoderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioEncoderClientProxy::OnEncodedBufferReady(
    EncodedAudioBufferPtr in_buffer, const ::blink::Vector<uint8_t>& in_description) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::AudioEncoderClient::OnEncodedBufferReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type EncodedAudioBufferPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioEncoderClient::kOnEncodedBufferReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::AudioEncoderClient_OnEncodedBufferReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType> buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::EncodedAudioBufferDataView>(
    in_buffer,
    buffer_fragment);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in AudioEncoderClient.OnEncodedBufferReady request");
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType>
      description_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_description,
    description_fragment,
    &description_validate_params);

  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description in AudioEncoderClient.OnEncodedBufferReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioEncoderClient::Name_);
  message.set_method_name("OnEncodedBufferReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioEncoderClientStubDispatch::Accept(
    AudioEncoderClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioEncoderClient>(message->header()->name)) {
    case messages::AudioEncoderClient::kOnEncodedBufferReady: {
      DCHECK(message->is_serialized());
      internal::AudioEncoderClient_OnEncodedBufferReady_Params_Data* params =
          reinterpret_cast<internal::AudioEncoderClient_OnEncodedBufferReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioEncoderClient.0
      bool success = true;
      EncodedAudioBufferPtr p_buffer{};
      ::blink::Vector<uint8_t> p_description{};
      AudioEncoderClient_OnEncodedBufferReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioEncoderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEncodedBufferReady(        
        std::move(p_buffer), 
        std::move(p_description));
      return true;
    }
  }
  return false;
}

// static
bool AudioEncoderClientStubDispatch::AcceptWithResponder(
    AudioEncoderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioEncoderClient>(message->header()->name)) {
    case messages::AudioEncoderClient::kOnEncodedBufferReady: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioEncoderClientValidationInfo[] = {
    { &internal::AudioEncoderClient_OnEncodedBufferReady_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioEncoderClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media::mojom::blink::AudioEncoderClient::Name_,
    kAudioEncoderClientValidationInfo);
}



}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::AacAudioEncoderConfig::DataView, ::media::mojom::blink::AacAudioEncoderConfigPtr>::Read(
    ::media::mojom::blink::AacAudioEncoderConfig::DataView input,
    ::media::mojom::blink::AacAudioEncoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::AacAudioEncoderConfigPtr result(::media::mojom::blink::AacAudioEncoderConfig::New());
  
      if (success && !input.ReadFormat(&result->format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::AudioEncoderConfig::DataView, ::media::mojom::blink::AudioEncoderConfigPtr>::Read(
    ::media::mojom::blink::AudioEncoderConfig::DataView input,
    ::media::mojom::blink::AudioEncoderConfigPtr* output) {
  bool success = true;
  ::media::mojom::blink::AudioEncoderConfigPtr result(::media::mojom::blink::AudioEncoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->bitrate = input.bitrate();
      if (success && !input.ReadAac(&result->aac))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::EncodedAudioBuffer::DataView, ::media::mojom::blink::EncodedAudioBufferPtr>::Read(
    ::media::mojom::blink::EncodedAudioBuffer::DataView input,
    ::media::mojom::blink::EncodedAudioBufferPtr* output) {
  bool success = true;
  ::media::mojom::blink::EncodedAudioBufferPtr result(::media::mojom::blink::EncodedAudioBuffer::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void AudioEncoderInterceptorForTesting::Initialize(::mojo::PendingAssociatedRemote<AudioEncoderClient> client, AudioEncoderConfigPtr config, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(
    std::move(client)
    , 
    std::move(config)
    , std::move(callback));
}
void AudioEncoderInterceptorForTesting::Encode(::media::mojom::blink::AudioBufferPtr buffer, EncodeCallback callback) {
  GetForwardingInterface()->Encode(
    std::move(buffer)
    , std::move(callback));
}
void AudioEncoderInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
AudioEncoderAsyncWaiter::AudioEncoderAsyncWaiter(
    AudioEncoder* proxy) : proxy_(proxy) {}

AudioEncoderAsyncWaiter::~AudioEncoderAsyncWaiter() = default;


void AudioEncoderAsyncWaiter::Initialize(
    ::mojo::PendingAssociatedRemote<AudioEncoderClient> client, AudioEncoderConfigPtr config, ::media::mojom::blink::EncoderStatusPtr* out_status) {
  base::RunLoop loop;
  proxy_->Initialize(
      std::move(client),
      std::move(config),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::EncoderStatusPtr* out_status
,
             ::media::mojom::blink::EncoderStatusPtr status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::mojom::blink::EncoderStatusPtr AudioEncoderAsyncWaiter::Initialize(
    ::mojo::PendingAssociatedRemote<AudioEncoderClient> client, AudioEncoderConfigPtr config) {
  ::media::mojom::blink::EncoderStatusPtr async_wait_result;
  Initialize(std::move(client),std::move(config),&async_wait_result);
  return async_wait_result;
}

void AudioEncoderAsyncWaiter::Encode(
    ::media::mojom::blink::AudioBufferPtr buffer, ::media::mojom::blink::EncoderStatusPtr* out_status) {
  base::RunLoop loop;
  proxy_->Encode(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::EncoderStatusPtr* out_status
,
             ::media::mojom::blink::EncoderStatusPtr status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::mojom::blink::EncoderStatusPtr AudioEncoderAsyncWaiter::Encode(
    ::media::mojom::blink::AudioBufferPtr buffer) {
  ::media::mojom::blink::EncoderStatusPtr async_wait_result;
  Encode(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void AudioEncoderAsyncWaiter::Flush(
    ::media::mojom::blink::EncoderStatusPtr* out_status) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::EncoderStatusPtr* out_status
,
             ::media::mojom::blink::EncoderStatusPtr status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::mojom::blink::EncoderStatusPtr AudioEncoderAsyncWaiter::Flush(
    ) {
  ::media::mojom::blink::EncoderStatusPtr async_wait_result;
  Flush(&async_wait_result);
  return async_wait_result;
}




void AudioEncoderClientInterceptorForTesting::OnEncodedBufferReady(EncodedAudioBufferPtr buffer, const ::blink::Vector<uint8_t>& description) {
  GetForwardingInterface()->OnEncodedBufferReady(
    std::move(buffer)
    , 
    std::move(description)
    );
}
AudioEncoderClientAsyncWaiter::AudioEncoderClientAsyncWaiter(
    AudioEncoderClient* proxy) : proxy_(proxy) {}

AudioEncoderClientAsyncWaiter::~AudioEncoderClientAsyncWaiter() = default;







}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif