// media/capture/mojom/video_effects_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_DATA_VIEW_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "media/capture/mojom/video_effects_manager.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace media::mojom {
class ImageEnhancementDataView;

class BlurDataView;

class FramingDataView;

class VideoEffectsConfigurationDataView;



}  // media::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::ImageEnhancementDataView> {
  using Data = ::media::mojom::internal::ImageEnhancement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BlurDataView> {
  using Data = ::media::mojom::internal::Blur_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::FramingDataView> {
  using Data = ::media::mojom::internal::Framing_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEffectsConfigurationDataView> {
  using Data = ::media::mojom::internal::VideoEffectsConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class SetConfigurationResult : int32_t {
  
  kOk = 0,
  
  kError = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SetConfigurationResult value);
inline bool IsKnownEnumValue(SetConfigurationResult value) {
  return internal::SetConfigurationResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VideoEffectsConfigurationObserverInterfaceBase {};

using VideoEffectsConfigurationObserverPtrDataView =
    mojo::InterfacePtrDataView<VideoEffectsConfigurationObserverInterfaceBase>;
using VideoEffectsConfigurationObserverRequestDataView =
    mojo::InterfaceRequestDataView<VideoEffectsConfigurationObserverInterfaceBase>;
using VideoEffectsConfigurationObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEffectsConfigurationObserverInterfaceBase>;
using VideoEffectsConfigurationObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEffectsConfigurationObserverInterfaceBase>;
class ReadonlyVideoEffectsManagerInterfaceBase {};

using ReadonlyVideoEffectsManagerPtrDataView =
    mojo::InterfacePtrDataView<ReadonlyVideoEffectsManagerInterfaceBase>;
using ReadonlyVideoEffectsManagerRequestDataView =
    mojo::InterfaceRequestDataView<ReadonlyVideoEffectsManagerInterfaceBase>;
using ReadonlyVideoEffectsManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ReadonlyVideoEffectsManagerInterfaceBase>;
using ReadonlyVideoEffectsManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ReadonlyVideoEffectsManagerInterfaceBase>;


class ImageEnhancementDataView {
 public:
  ImageEnhancementDataView() = default;

  ImageEnhancementDataView(
      internal::ImageEnhancement_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool lighting() const {
    return data_->lighting;
  }
 private:
  internal::ImageEnhancement_Data* data_ = nullptr;
};


class BlurDataView {
 public:
  BlurDataView() = default;

  BlurDataView(
      internal::Blur_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Blur_Data* data_ = nullptr;
};


class FramingDataView {
 public:
  FramingDataView() = default;

  FramingDataView(
      internal::Framing_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPaddingRatiosDataView(
      ::gfx::mojom::InsetsFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaddingRatios(UserType* output) {
    
    auto* pointer = data_->padding_ratios.Get();
    return mojo::internal::Deserialize<::gfx::mojom::InsetsFDataView>(
        pointer, output, message_);
  }
 private:
  internal::Framing_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEffectsConfigurationDataView {
 public:
  VideoEffectsConfigurationDataView() = default;

  VideoEffectsConfigurationDataView(
      internal::VideoEffectsConfiguration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageEnhancementDataView(
      ImageEnhancementDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageEnhancement(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ImageEnhancementDataView, UserType>(),
    "Attempting to read the optional `image_enhancement` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageEnhancement` instead "
    "of `ReadImageEnhancement if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_enhancement.Get();
    return mojo::internal::Deserialize<::media::mojom::ImageEnhancementDataView>(
        pointer, output, message_);
  }
  inline void GetBlurDataView(
      BlurDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlur(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::BlurDataView, UserType>(),
    "Attempting to read the optional `blur` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlur` instead "
    "of `ReadBlur if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blur.Get();
    return mojo::internal::Deserialize<::media::mojom::BlurDataView>(
        pointer, output, message_);
  }
  inline void GetFramingDataView(
      FramingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFraming(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::FramingDataView, UserType>(),
    "Attempting to read the optional `framing` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFraming` instead "
    "of `ReadFraming if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->framing.Get();
    return mojo::internal::Deserialize<::media::mojom::FramingDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEffectsConfiguration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_DATA_VIEW_H_