// media/capture/mojom/video_capture_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SEND_VALIDATION_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SEND_VALIDATION_H_

#include "media/capture/mojom/video_capture_types.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "media/capture/mojom/video_capture_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCapturePixelFormat, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::ResolutionChangePolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::PowerLineFrequency, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoFacingMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::CameraAvailability, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCaptureApi, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCaptureTransportType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCaptureBufferType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCaptureError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::VideoCaptureFrameDropReason, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::SubCaptureTargetType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::ApplySubCaptureTargetResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media::mojom::DeviceEnumerationResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureControlSupportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureControlSupportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureControlSupport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->pan = Traits::pan(input);

      fragment->tilt = Traits::tilt(input);

      fragment->zoom = Traits::zoom(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureFormatDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureFormatDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_size(input)) in_frame_size = Traits::frame_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_size)::BaseType> frame_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_frame_size,
        frame_size_fragment);

      fragment->frame_size.Set(
          frame_size_fragment.is_null() ? nullptr : frame_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_size in VideoCaptureFormat struct");

      fragment->frame_rate = Traits::frame_rate(input);

      
      mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
        Traits::pixel_format(input),
        &fragment->pixel_format);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::requested_format(input)) in_requested_format = Traits::requested_format(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->requested_format)::BaseType> requested_format_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoCaptureFormatDataView, send_validation>(
        in_requested_format,
        requested_format_fragment);

      fragment->requested_format.Set(
          requested_format_fragment.is_null() ? nullptr : requested_format_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->requested_format.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requested_format in VideoCaptureParams struct");

      
      mojo::internal::Serialize<::media::mojom::VideoCaptureBufferType>(
        Traits::buffer_type(input),
        &fragment->buffer_type);

      
      mojo::internal::Serialize<::media::mojom::ResolutionChangePolicy>(
        Traits::resolution_change_policy(input),
        &fragment->resolution_change_policy);

      
      mojo::internal::Serialize<::media::mojom::PowerLineFrequency>(
        Traits::power_line_frequency(input),
        &fragment->power_line_frequency);

      fragment->enable_face_detection = Traits::enable_face_detection(input);

      fragment->is_high_dpi_enabled = Traits::is_high_dpi_enabled(input);

      fragment->capture_version_source = Traits::capture_version_source(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureFeedbackDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureFeedbackDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureFeedback_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->resource_utilization = Traits::resource_utilization(input);

      fragment->max_framerate_fps = Traits::max_framerate_fps(input);

      fragment->max_pixels = Traits::max_pixels(input);

      fragment->require_mapped_frame = Traits::require_mapped_frame(input);

      decltype(Traits::DEPRECATED_mapped_sizes(input)) in_DEPRECATED_mapped_sizes = Traits::DEPRECATED_mapped_sizes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->DEPRECATED_mapped_sizes)::BaseType>
          DEPRECATED_mapped_sizes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& DEPRECATED_mapped_sizes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>, send_validation>(
        in_DEPRECATED_mapped_sizes,
        DEPRECATED_mapped_sizes_fragment,
        &DEPRECATED_mapped_sizes_validate_params);

      fragment->DEPRECATED_mapped_sizes.Set(
          DEPRECATED_mapped_sizes_fragment.is_null() ? nullptr : DEPRECATED_mapped_sizes_fragment.data());

      fragment->frame_id = Traits::frame_id(input);

      fragment->has_frame_id = Traits::has_frame_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::PlaneStridesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PlaneStridesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PlaneStrides_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::stride_by_plane(input)) in_stride_by_plane = Traits::stride_by_plane(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stride_by_plane)::BaseType>
          stride_by_plane_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& stride_by_plane_validate_params =
          mojo::internal::GetArrayValidator<4, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>, send_validation>(
        in_stride_by_plane,
        stride_by_plane_fragment,
        &stride_by_plane_validate_params);

      fragment->stride_by_plane.Set(
          stride_by_plane_fragment.is_null() ? nullptr : stride_by_plane_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stride_by_plane.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stride_by_plane in PlaneStrides struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureDeviceDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureDeviceDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureDeviceDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in VideoCaptureDeviceDescriptor struct");

      decltype(Traits::device_id(input)) in_device_id = Traits::device_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_id)::BaseType> device_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_device_id,
        device_id_fragment);

      fragment->device_id.Set(
          device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_id in VideoCaptureDeviceDescriptor struct");

      decltype(Traits::model_id(input)) in_model_id = Traits::model_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->model_id)::BaseType> model_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_model_id,
        model_id_fragment);

      fragment->model_id.Set(
          model_id_fragment.is_null() ? nullptr : model_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->model_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null model_id in VideoCaptureDeviceDescriptor struct");

      
      mojo::internal::Serialize<::media::mojom::VideoFacingMode>(
        Traits::facing_mode(input),
        &fragment->facing_mode);

      
      mojo::internal::Serialize<::media::mojom::VideoCaptureApi>(
        Traits::capture_api(input),
        &fragment->capture_api);

      decltype(Traits::control_support(input)) in_control_support = Traits::control_support(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->control_support)::BaseType> control_support_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoCaptureControlSupportDataView, send_validation>(
        in_control_support,
        control_support_fragment);

      fragment->control_support.Set(
          control_support_fragment.is_null() ? nullptr : control_support_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->control_support.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null control_support in VideoCaptureDeviceDescriptor struct");

      
      mojo::internal::Serialize<::media::mojom::VideoCaptureTransportType>(
        Traits::transport_type(input),
        &fragment->transport_type);
      fragment->availability_$flag = Traits::availability(input).has_value();
      if (Traits::availability(input).has_value()) {
        
        mojo::internal::Serialize<::media::mojom::CameraAvailability>(
          Traits::availability(input).value(),
          &fragment->availability_$value);
      } else {
        fragment->availability_$value =
            static_cast<int32_t>(::media::mojom::CameraAvailability::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media::mojom::VideoCaptureDeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoCaptureDeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoCaptureDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::descriptor(input)) in_descriptor = Traits::descriptor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->descriptor)::BaseType> descriptor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::VideoCaptureDeviceDescriptorDataView, send_validation>(
        in_descriptor,
        descriptor_fragment);

      fragment->descriptor.Set(
          descriptor_fragment.is_null() ? nullptr : descriptor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->descriptor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null descriptor in VideoCaptureDeviceInfo struct");

      decltype(Traits::supported_formats(input)) in_supported_formats = Traits::supported_formats(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->supported_formats)::BaseType>
          supported_formats_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& supported_formats_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>, send_validation>(
        in_supported_formats,
        supported_formats_fragment,
        &supported_formats_validate_params);

      fragment->supported_formats.Set(
          supported_formats_fragment.is_null() ? nullptr : supported_formats_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->supported_formats.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_formats in VideoCaptureDeviceInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_TYPES_MOJOM_SEND_VALIDATION_H_