// media/capture/mojom/video_capture.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  CaptureVersion as media_mojom_CaptureVersion,
  CaptureVersionSpec as media_mojom_CaptureVersionSpec
} from '../../mojo/mojom/media_types.mojom.m.js';

import {
  ReadyBuffer as media_mojom_ReadyBuffer,
  ReadyBufferSpec as media_mojom_ReadyBufferSpec,
  VideoBufferHandle as media_mojom_VideoBufferHandle,
  VideoBufferHandleSpec as media_mojom_VideoBufferHandleSpec
} from './video_capture_buffer.mojom.m.js';

import {
  VideoCaptureError as media_mojom_VideoCaptureError,
  VideoCaptureErrorSpec as media_mojom_VideoCaptureErrorSpec,
  VideoCaptureFrameDropReason as media_mojom_VideoCaptureFrameDropReason,
  VideoCaptureFrameDropReasonSpec as media_mojom_VideoCaptureFrameDropReasonSpec,
  VideoCaptureFeedback as media_mojom_VideoCaptureFeedback,
  VideoCaptureFeedbackSpec as media_mojom_VideoCaptureFeedbackSpec,
  VideoCaptureFormat as media_mojom_VideoCaptureFormat,
  VideoCaptureFormatSpec as media_mojom_VideoCaptureFormatSpec,
  VideoCaptureParams as media_mojom_VideoCaptureParams,
  VideoCaptureParamsSpec as media_mojom_VideoCaptureParamsSpec
} from './video_capture_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const VideoCaptureStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const VideoCaptureState = {
  
  STARTED: 0,
  PAUSED: 1,
  RESUMED: 2,
  STOPPED: 3,
  ENDED: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoCaptureObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoCaptureObserver', scope);
  }
}

/** @interface */
export class VideoCaptureObserverInterface {
  
  /**
   * @param { !VideoCaptureResult } result
   */

  onStateChanged(result) {}
  
  /**
   * @param { !number } bufferId
   * @param { !media_mojom_VideoBufferHandle } bufferHandle
   */

  onNewBuffer(bufferId, bufferHandle) {}
  
  /**
   * @param { !media_mojom_ReadyBuffer } buffer
   */

  onBufferReady(buffer) {}
  
  /**
   * @param { !number } bufferId
   */

  onBufferDestroyed(bufferId) {}
  
  /**
   * @param { !media_mojom_VideoCaptureFrameDropReason } reason
   */

  onFrameDropped(reason) {}
  
  /**
   * @param { !media_mojom_CaptureVersion } captureVersion
   */

  onNewCaptureVersion(captureVersion) {}
}

/**
 * @implements { VideoCaptureObserverInterface }
 */
export class VideoCaptureObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoCaptureObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoCaptureObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoCaptureObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !VideoCaptureResult } result
   */

  onStateChanged(
      result) {
    this.proxy.sendMessage(
        0,
        VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   * @param { !number } bufferId
   * @param { !media_mojom_VideoBufferHandle } bufferHandle
   */

  onNewBuffer(
      bufferId,
      bufferHandle) {
    this.proxy.sendMessage(
        1,
        VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
        null,
        [
          bufferId,
          bufferHandle
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_ReadyBuffer } buffer
   */

  onBufferReady(
      buffer) {
    this.proxy.sendMessage(
        2,
        VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
        null,
        [
          buffer
        ],
        false);
  }

  
  /**
   * @param { !number } bufferId
   */

  onBufferDestroyed(
      bufferId) {
    this.proxy.sendMessage(
        3,
        VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
        null,
        [
          bufferId
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_VideoCaptureFrameDropReason } reason
   */

  onFrameDropped(
      reason) {
    this.proxy.sendMessage(
        4,
        VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
        null,
        [
          reason
        ],
        false);
  }

  
  /**
   * @param { !media_mojom_CaptureVersion } captureVersion
   */

  onNewCaptureVersion(
      captureVersion) {
    this.proxy.sendMessage(
        5,
        VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
        null,
        [
          captureVersion
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoCaptureObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoCaptureObserverReceiver {
  /**
   * @param {!VideoCaptureObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoCaptureObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoCaptureObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoCaptureObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
        null,
        impl.onStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
        null,
        impl.onNewBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
        null,
        impl.onBufferReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
        null,
        impl.onBufferDestroyed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
        null,
        impl.onFrameDropped.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
        null,
        impl.onNewCaptureVersion.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoCaptureObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoCaptureObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoCaptureObserverRemote}
   */
  static getRemote() {
    let remote = new VideoCaptureObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoCaptureObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoCaptureObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoCaptureObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoCaptureObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
        null,
        this.onStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
        null,
        this.onNewBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
        null,
        this.onBufferReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBufferDestroyed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
        null,
        this.onBufferDestroyed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFrameDropped =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
        null,
        this.onFrameDropped.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onNewCaptureVersion =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
        null,
        this.onNewCaptureVersion.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VideoCaptureHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media.mojom.VideoCaptureHost', scope);
  }
}

/** @interface */
export class VideoCaptureHostInterface {
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_VideoCaptureParams } params
   * @param { !VideoCaptureObserverRemote } observer
   */

  start(deviceId, sessionId, params, observer) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   */

  stop(deviceId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   */

  pause(deviceId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_VideoCaptureParams } params
   */

  resume(deviceId, sessionId, params) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   */

  requestRefreshFrame(deviceId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !number } bufferId
   * @param { !media_mojom_VideoCaptureFeedback } feedback
   */

  releaseBuffer(deviceId, bufferId, feedback) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @return {!Promise<{
        formatsSupported: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getDeviceSupportedFormats(deviceId, sessionId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @return {!Promise<{
        formatsInUse: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getDeviceFormatsInUse(deviceId, sessionId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !string } message
   */

  onLog(deviceId, message) {}
}

/**
 * @implements { VideoCaptureHostInterface }
 */
export class VideoCaptureHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VideoCaptureHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VideoCaptureHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VideoCaptureHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_VideoCaptureParams } params
   * @param { !VideoCaptureObserverRemote } observer
   */

  start(
      deviceId,
      sessionId,
      params,
      observer) {
    this.proxy.sendMessage(
        0,
        VideoCaptureHost_Start_ParamsSpec.$,
        null,
        [
          deviceId,
          sessionId,
          params,
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   */

  stop(
      deviceId) {
    this.proxy.sendMessage(
        1,
        VideoCaptureHost_Stop_ParamsSpec.$,
        null,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   */

  pause(
      deviceId) {
    this.proxy.sendMessage(
        2,
        VideoCaptureHost_Pause_ParamsSpec.$,
        null,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @param { !media_mojom_VideoCaptureParams } params
   */

  resume(
      deviceId,
      sessionId,
      params) {
    this.proxy.sendMessage(
        3,
        VideoCaptureHost_Resume_ParamsSpec.$,
        null,
        [
          deviceId,
          sessionId,
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   */

  requestRefreshFrame(
      deviceId) {
    this.proxy.sendMessage(
        4,
        VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
        null,
        [
          deviceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !number } bufferId
   * @param { !media_mojom_VideoCaptureFeedback } feedback
   */

  releaseBuffer(
      deviceId,
      bufferId,
      feedback) {
    this.proxy.sendMessage(
        5,
        VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
        null,
        [
          deviceId,
          bufferId,
          feedback
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @return {!Promise<{
        formatsSupported: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getDeviceSupportedFormats(
      deviceId,
      sessionId) {
    return this.proxy.sendMessage(
        6,
        VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
        VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
        [
          deviceId,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !mojoBase_mojom_UnguessableToken } sessionId
   * @return {!Promise<{
        formatsInUse: !Array<!media_mojom_VideoCaptureFormat>,
   *  }>}
   */

  getDeviceFormatsInUse(
      deviceId,
      sessionId) {
    return this.proxy.sendMessage(
        7,
        VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
        VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
        [
          deviceId,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } deviceId
   * @param { !string } message
   */

  onLog(
      deviceId,
      message) {
    this.proxy.sendMessage(
        8,
        VideoCaptureHost_OnLog_ParamsSpec.$,
        null,
        [
          deviceId,
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VideoCaptureHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VideoCaptureHostReceiver {
  /**
   * @param {!VideoCaptureHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VideoCaptureHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VideoCaptureHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoCaptureHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VideoCaptureHost_Start_ParamsSpec.$,
        null,
        impl.start.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VideoCaptureHost_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        VideoCaptureHost_Pause_ParamsSpec.$,
        null,
        impl.pause.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        VideoCaptureHost_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
        null,
        impl.requestRefreshFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
        null,
        impl.releaseBuffer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
        VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
        impl.getDeviceSupportedFormats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
        VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
        impl.getDeviceFormatsInUse.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        VideoCaptureHost_OnLog_ParamsSpec.$,
        null,
        impl.onLog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VideoCaptureHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media.mojom.VideoCaptureHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VideoCaptureHostRemote}
   */
  static getRemote() {
    let remote = new VideoCaptureHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VideoCaptureHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VideoCaptureHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VideoCaptureHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VideoCaptureHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.start =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VideoCaptureHost_Start_ParamsSpec.$,
        null,
        this.start.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VideoCaptureHost_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pause =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        VideoCaptureHost_Pause_ParamsSpec.$,
        null,
        this.pause.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        VideoCaptureHost_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestRefreshFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
        null,
        this.requestRefreshFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.releaseBuffer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
        null,
        this.releaseBuffer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceSupportedFormats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
        VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
        this.getDeviceSupportedFormats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDeviceFormatsInUse =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
        VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
        this.getDeviceFormatsInUse.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        VideoCaptureHost_OnLog_ParamsSpec.$,
        null,
        this.onLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureObserver_OnStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureObserver_OnNewBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureObserver_OnBufferReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureObserver_OnBufferDestroyed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureObserver_OnFrameDropped_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_Start_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_Pause_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_RequestRefreshFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_ReleaseBuffer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VideoCaptureHost_OnLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const VideoCaptureResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VideoCaptureObserver_OnStateChanged_ParamsSpec.$,
    'VideoCaptureObserver_OnStateChanged_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        VideoCaptureResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCaptureObserver_OnStateChanged_Params {
  constructor() {
    /** @type { !VideoCaptureResult } */
    this.result;
  }
}



mojo.internal.Struct(
    VideoCaptureObserver_OnNewBuffer_ParamsSpec.$,
    'VideoCaptureObserver_OnNewBuffer_Params',
    [
      mojo.internal.StructField(
        'bufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferHandle', 8,
        0,
        media_mojom_VideoBufferHandleSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoCaptureObserver_OnNewBuffer_Params {
  constructor() {
    /** @type { !number } */
    this.bufferId;
    /** @type { !media_mojom_VideoBufferHandle } */
    this.bufferHandle;
  }
}



mojo.internal.Struct(
    VideoCaptureObserver_OnBufferReady_ParamsSpec.$,
    'VideoCaptureObserver_OnBufferReady_Params',
    [
      mojo.internal.StructField(
        'buffer', 0,
        0,
        media_mojom_ReadyBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureObserver_OnBufferReady_Params {
  constructor() {
    /** @type { !media_mojom_ReadyBuffer } */
    this.buffer;
  }
}



mojo.internal.Struct(
    VideoCaptureObserver_OnBufferDestroyed_ParamsSpec.$,
    'VideoCaptureObserver_OnBufferDestroyed_Params',
    [
      mojo.internal.StructField(
        'bufferId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureObserver_OnBufferDestroyed_Params {
  constructor() {
    /** @type { !number } */
    this.bufferId;
  }
}



mojo.internal.Struct(
    VideoCaptureObserver_OnFrameDropped_ParamsSpec.$,
    'VideoCaptureObserver_OnFrameDropped_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        media_mojom_VideoCaptureFrameDropReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureObserver_OnFrameDropped_Params {
  constructor() {
    /** @type { !media_mojom_VideoCaptureFrameDropReason } */
    this.reason;
  }
}



mojo.internal.Struct(
    VideoCaptureObserver_OnNewCaptureVersion_ParamsSpec.$,
    'VideoCaptureObserver_OnNewCaptureVersion_Params',
    [
      mojo.internal.StructField(
        'captureVersion', 0,
        0,
        media_mojom_CaptureVersionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureObserver_OnNewCaptureVersion_Params {
  constructor() {
    /** @type { !media_mojom_CaptureVersion } */
    this.captureVersion;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_Start_ParamsSpec.$,
    'VideoCaptureHost_Start_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 16,
        0,
        media_mojom_VideoCaptureParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 24,
        0,
        mojo.internal.InterfaceProxy(VideoCaptureObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class VideoCaptureHost_Start_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !media_mojom_VideoCaptureParams } */
    this.params;
    /** @type { !VideoCaptureObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_Stop_ParamsSpec.$,
    'VideoCaptureHost_Stop_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureHost_Stop_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_Pause_ParamsSpec.$,
    'VideoCaptureHost_Pause_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureHost_Pause_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_Resume_ParamsSpec.$,
    'VideoCaptureHost_Resume_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 16,
        0,
        media_mojom_VideoCaptureParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoCaptureHost_Resume_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
    /** @type { !media_mojom_VideoCaptureParams } */
    this.params;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_RequestRefreshFrame_ParamsSpec.$,
    'VideoCaptureHost_RequestRefreshFrame_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureHost_RequestRefreshFrame_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_ReleaseBuffer_ParamsSpec.$,
    'VideoCaptureHost_ReleaseBuffer_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bufferId', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'feedback', 16,
        0,
        media_mojom_VideoCaptureFeedbackSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class VideoCaptureHost_ReleaseBuffer_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
    /** @type { !number } */
    this.bufferId;
    /** @type { !media_mojom_VideoCaptureFeedback } */
    this.feedback;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_GetDeviceSupportedFormats_ParamsSpec.$,
    'VideoCaptureHost_GetDeviceSupportedFormats_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCaptureHost_GetDeviceSupportedFormats_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_GetDeviceSupportedFormats_ResponseParamsSpec.$,
    'VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams',
    [
      mojo.internal.StructField(
        'formatsSupported', 0,
        0,
        mojo.internal.Array(media_mojom_VideoCaptureFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureHost_GetDeviceSupportedFormats_ResponseParams {
  constructor() {
    /** @type { !Array<!media_mojom_VideoCaptureFormat> } */
    this.formatsSupported;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_GetDeviceFormatsInUse_ParamsSpec.$,
    'VideoCaptureHost_GetDeviceFormatsInUse_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCaptureHost_GetDeviceFormatsInUse_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sessionId;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_GetDeviceFormatsInUse_ResponseParamsSpec.$,
    'VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams',
    [
      mojo.internal.StructField(
        'formatsInUse', 0,
        0,
        mojo.internal.Array(media_mojom_VideoCaptureFormatSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VideoCaptureHost_GetDeviceFormatsInUse_ResponseParams {
  constructor() {
    /** @type { !Array<!media_mojom_VideoCaptureFormat> } */
    this.formatsInUse;
  }
}



mojo.internal.Struct(
    VideoCaptureHost_OnLog_ParamsSpec.$,
    'VideoCaptureHost_OnLog_Params',
    [
      mojo.internal.StructField(
        'deviceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class VideoCaptureHost_OnLog_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.deviceId;
    /** @type { !string } */
    this.message;
  }
}

mojo.internal.Union(
    VideoCaptureResultSpec.$, 'VideoCaptureResult',
    {
      'state': {
        'ordinal': 0,
        'type': VideoCaptureStateSpec.$,
      },
      'errorCode': {
        'ordinal': 1,
        'type': media_mojom_VideoCaptureErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   state: (!VideoCaptureState|undefined),
 *   errorCode: (!media_mojom_VideoCaptureError|undefined),
 * } }
 */
export const VideoCaptureResult = {};
