// ipc/ipc.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef IPC_IPC_MOJOM_DATA_VIEW_H_
#define IPC_IPC_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ipc/ipc.mojom-shared-internal.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_associated_receiver.mojom-shared.h"


namespace IPC::mojom {
class MessageDataView;



}  // IPC::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::IPC::mojom::MessageDataView> {
  using Data = ::IPC::mojom::internal::Message_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace IPC::mojom {
// Interface base classes. They are used for type safety check.
class ChannelInterfaceBase {};

using ChannelPtrDataView =
    mojo::InterfacePtrDataView<ChannelInterfaceBase>;
using ChannelRequestDataView =
    mojo::InterfaceRequestDataView<ChannelInterfaceBase>;
using ChannelAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChannelInterfaceBase>;
using ChannelAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChannelInterfaceBase>;
class ChannelBootstrapInterfaceBase {};

using ChannelBootstrapPtrDataView =
    mojo::InterfacePtrDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapRequestDataView =
    mojo::InterfaceRequestDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChannelBootstrapInterfaceBase>;
using ChannelBootstrapAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChannelBootstrapInterfaceBase>;


class MessageDataView {
 public:
  MessageDataView() = default;

  MessageDataView(
      internal::Message_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) {
    
    auto* pointer = data_->bytes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetHandlesDataView(
      mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandles(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>, UserType>(),
    "Attempting to read the optional `handles` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHandles` instead "
    "of `ReadHandles if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->handles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo::native::SerializedHandleDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Message_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // IPC::mojom

#endif  // IPC_IPC_MOJOM_DATA_VIEW_H_