// gpu/ipc/common/surface_handle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_SURFACE_HANDLE_MOJOM_BLINK_H_
#define GPU_IPC_COMMON_SURFACE_HANDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/surface_handle.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/surface_handle.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/surface_handle.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gpu::mojom::blink {





class  SurfaceHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SurfaceHandle, T>::value>;
  using DataView = SurfaceHandleDataView;
  using Data_ = internal::SurfaceHandle_Data;

  template <typename... Args>
  static SurfaceHandlePtr New(Args&&... args) {
    return SurfaceHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SurfaceHandlePtr From(const U& u) {
    return mojo::TypeConverter<SurfaceHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SurfaceHandle>::Convert(*this);
  }


  SurfaceHandle();

  explicit SurfaceHandle(
      uint64_t surface_handle);


  ~SurfaceHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SurfaceHandlePtr>
  SurfaceHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceHandle::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceHandle::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SurfaceHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SurfaceHandle_UnserializedMessageContext<
            UserType, SurfaceHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SurfaceHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SurfaceHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SurfaceHandle_UnserializedMessageContext<
            UserType, SurfaceHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SurfaceHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t surface_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SurfaceHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SurfaceHandlePtr SurfaceHandle::Clone() const {
  return New(
      mojo::Clone(surface_handle)
  );
}

template <typename T, SurfaceHandle::EnableIfSame<T>*>
bool SurfaceHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->surface_handle, other_struct.surface_handle))
    return false;
  return true;
}

template <typename T, SurfaceHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.surface_handle < rhs.surface_handle)
    return true;
  if (rhs.surface_handle < lhs.surface_handle)
    return false;
  return false;
}


}  // gpu::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gpu::mojom::blink::SurfaceHandle::DataView,
                                         ::gpu::mojom::blink::SurfaceHandlePtr> {
  static bool IsNull(const ::gpu::mojom::blink::SurfaceHandlePtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::blink::SurfaceHandlePtr* output) { output->reset(); }

  static decltype(::gpu::mojom::blink::SurfaceHandle::surface_handle) surface_handle(
      const ::gpu::mojom::blink::SurfaceHandlePtr& input) {
    return input->surface_handle;
  }

  static bool Read(::gpu::mojom::blink::SurfaceHandle::DataView input, ::gpu::mojom::blink::SurfaceHandlePtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_SURFACE_HANDLE_MOJOM_BLINK_H_