// gpu/ipc/common/memory_stats.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_MEMORY_STATS_MOJOM_SEND_VALIDATION_H_
#define GPU_IPC_COMMON_MEMORY_STATS_MOJOM_SEND_VALIDATION_H_

#include "gpu/ipc/common/memory_stats.mojom-shared-internal.h"

#include "gpu/ipc/common/memory_stats.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::VideoMemoryProcessStatsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoMemoryProcessStatsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoMemoryProcessStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->video_memory_bytes = Traits::video_memory_bytes(input);

      fragment->has_duplicates = Traits::has_duplicates(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gpu::mojom::VideoMemoryUsageStatsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VideoMemoryUsageStatsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VideoMemoryUsageStats_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::process_map(input)) in_process_map = Traits::process_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->process_map)::BaseType>
          process_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& process_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<int32_t, ::gpu::mojom::VideoMemoryProcessStatsDataView>, send_validation>(
        in_process_map,
        process_map_fragment,
        &process_map_validate_params);

      fragment->process_map.Set(
          process_map_fragment.is_null() ? nullptr : process_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->process_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null process_map in VideoMemoryUsageStats struct");

      fragment->bytes_allocated = Traits::bytes_allocated(input);
  }
};

}  // namespace mojo::internal

#endif  // GPU_IPC_COMMON_MEMORY_STATS_MOJOM_SEND_VALIDATION_H_