// gpu/ipc/common/gpu_feature_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/gpu_feature_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"




#include "gpu/ipc/common/gpu_feature_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::gpu::mojom::GpuFeatureStatus>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::GpuFeatureStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuFeatureStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::GpuFeatureStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::GpuFeatureStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::GpuFeatureInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::GpuFeatureInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::GpuFeatureInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::status_values(input)) in_status_values = Traits::status_values(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->status_values)::BaseType>
        status_values_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& status_values_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<12, false, ::gpu::mojom::internal::GpuFeatureStatus_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::GpuFeatureStatus>>(
      in_status_values,
      status_values_fragment,
      &status_values_validate_params);

    fragment->status_values.Set(
        status_values_fragment.is_null() ? nullptr : status_values_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->status_values.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status_values in GpuFeatureInfo struct");

    decltype(Traits::enabled_gpu_driver_bug_workarounds(input)) in_enabled_gpu_driver_bug_workarounds = Traits::enabled_gpu_driver_bug_workarounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enabled_gpu_driver_bug_workarounds)::BaseType>
        enabled_gpu_driver_bug_workarounds_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& enabled_gpu_driver_bug_workarounds_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_enabled_gpu_driver_bug_workarounds,
      enabled_gpu_driver_bug_workarounds_fragment,
      &enabled_gpu_driver_bug_workarounds_validate_params);

    fragment->enabled_gpu_driver_bug_workarounds.Set(
        enabled_gpu_driver_bug_workarounds_fragment.is_null() ? nullptr : enabled_gpu_driver_bug_workarounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->enabled_gpu_driver_bug_workarounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null enabled_gpu_driver_bug_workarounds in GpuFeatureInfo struct");

    decltype(Traits::disabled_extensions(input)) in_disabled_extensions = Traits::disabled_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disabled_extensions)::BaseType> disabled_extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_disabled_extensions,
      disabled_extensions_fragment);

    fragment->disabled_extensions.Set(
        disabled_extensions_fragment.is_null() ? nullptr : disabled_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->disabled_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disabled_extensions in GpuFeatureInfo struct");

    decltype(Traits::disabled_webgl_extensions(input)) in_disabled_webgl_extensions = Traits::disabled_webgl_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disabled_webgl_extensions)::BaseType> disabled_webgl_extensions_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_disabled_webgl_extensions,
      disabled_webgl_extensions_fragment);

    fragment->disabled_webgl_extensions.Set(
        disabled_webgl_extensions_fragment.is_null() ? nullptr : disabled_webgl_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->disabled_webgl_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disabled_webgl_extensions in GpuFeatureInfo struct");

    decltype(Traits::applied_gpu_blocklist_entries(input)) in_applied_gpu_blocklist_entries = Traits::applied_gpu_blocklist_entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->applied_gpu_blocklist_entries)::BaseType>
        applied_gpu_blocklist_entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& applied_gpu_blocklist_entries_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_applied_gpu_blocklist_entries,
      applied_gpu_blocklist_entries_fragment,
      &applied_gpu_blocklist_entries_validate_params);

    fragment->applied_gpu_blocklist_entries.Set(
        applied_gpu_blocklist_entries_fragment.is_null() ? nullptr : applied_gpu_blocklist_entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->applied_gpu_blocklist_entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null applied_gpu_blocklist_entries in GpuFeatureInfo struct");

    decltype(Traits::applied_gpu_driver_bug_list_entries(input)) in_applied_gpu_driver_bug_list_entries = Traits::applied_gpu_driver_bug_list_entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->applied_gpu_driver_bug_list_entries)::BaseType>
        applied_gpu_driver_bug_list_entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& applied_gpu_driver_bug_list_entries_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
      in_applied_gpu_driver_bug_list_entries,
      applied_gpu_driver_bug_list_entries_fragment,
      &applied_gpu_driver_bug_list_entries_validate_params);

    fragment->applied_gpu_driver_bug_list_entries.Set(
        applied_gpu_driver_bug_list_entries_fragment.is_null() ? nullptr : applied_gpu_driver_bug_list_entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->applied_gpu_driver_bug_list_entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null applied_gpu_driver_bug_list_entries in GpuFeatureInfo struct");

    decltype(Traits::supported_buffer_formats_for_allocation_and_texturing(input)) in_supported_buffer_formats_for_allocation_and_texturing = Traits::supported_buffer_formats_for_allocation_and_texturing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_buffer_formats_for_allocation_and_texturing)::BaseType>
        supported_buffer_formats_for_allocation_and_texturing_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_buffer_formats_for_allocation_and_texturing_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::gfx::mojom::internal::BufferFormat_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>>(
      in_supported_buffer_formats_for_allocation_and_texturing,
      supported_buffer_formats_for_allocation_and_texturing_fragment,
      &supported_buffer_formats_for_allocation_and_texturing_validate_params);

    fragment->supported_buffer_formats_for_allocation_and_texturing.Set(
        supported_buffer_formats_for_allocation_and_texturing_fragment.is_null() ? nullptr : supported_buffer_formats_for_allocation_and_texturing_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_buffer_formats_for_allocation_and_texturing.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_buffer_formats_for_allocation_and_texturing in GpuFeatureInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::GpuFeatureInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::GpuFeatureInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void GpuFeatureInfoDataView::GetStatusValuesDataView(
    mojo::ArrayDataView<GpuFeatureStatus>* output) {
  auto pointer = data_->status_values.Get();
  *output = mojo::ArrayDataView<GpuFeatureStatus>(pointer, message_);
}
inline void GpuFeatureInfoDataView::GetEnabledGpuDriverBugWorkaroundsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->enabled_gpu_driver_bug_workarounds.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void GpuFeatureInfoDataView::GetDisabledExtensionsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->disabled_extensions.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuFeatureInfoDataView::GetDisabledWebglExtensionsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->disabled_webgl_extensions.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GpuFeatureInfoDataView::GetAppliedGpuBlocklistEntriesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->applied_gpu_blocklist_entries.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void GpuFeatureInfoDataView::GetAppliedGpuDriverBugListEntriesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->applied_gpu_driver_bug_list_entries.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void GpuFeatureInfoDataView::GetSupportedBufferFormatsForAllocationAndTexturingDataView(
    mojo::ArrayDataView<::gfx::mojom::BufferFormat>* output) {
  auto pointer = data_->supported_buffer_formats_for_allocation_and_texturing.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::BufferFormat>(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::GpuFeatureStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::GpuFeatureStatus value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_GPU_FEATURE_INFO_MOJOM_SHARED_H_