// extensions/common/mojom/url_pattern_set.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "extensions/common/mojom/url_pattern_set.mojom-shared-internal.h"


namespace extensions::mojom {
class URLPatternDataView;

class URLPatternSetDataView;



}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::URLPatternDataView> {
  using Data = ::extensions::mojom::internal::URLPattern_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::URLPatternSetDataView> {
  using Data = ::extensions::mojom::internal::URLPatternSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {


class URLPatternDataView {
 public:
  URLPatternDataView() = default;

  URLPatternDataView(
      internal::URLPattern_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t valid_schemes() const {
    return data_->valid_schemes;
  }
  inline void GetPatternDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPattern(UserType* output) {
    
    auto* pointer = data_->pattern.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLPattern_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLPatternSetDataView {
 public:
  URLPatternSetDataView() = default;

  URLPatternSetDataView(
      internal::URLPatternSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPatternsDataView(
      mojo::ArrayDataView<URLPatternDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPatterns(UserType* output) {
    
    auto* pointer = data_->patterns.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::URLPatternDataView>>(
        pointer, output, message_);
  }
 private:
  internal::URLPatternSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_URL_PATTERN_SET_MOJOM_DATA_VIEW_H_