// extensions/common/mojom/service_worker_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/service_worker_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/service_worker_host.mojom-params-data.h"
#include "extensions/common/mojom/service_worker_host.mojom-shared-message-ids.h"

#include "extensions/common/mojom/service_worker_host.mojom-import-headers.h"
#include "extensions/common/mojom/service_worker_host.mojom-test-utils.h"


namespace extensions::mojom {
// The declaration includes the definition on other builds.

ServiceWorkerHost::IPCStableHashFunction ServiceWorkerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerHost>(message.name())) {
    case messages::ServiceWorkerHost::kDidInitializeServiceWorkerContext: {
      return &ServiceWorkerHost::DidInitializeServiceWorkerContext_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kDidStartServiceWorkerContext: {
      return &ServiceWorkerHost::DidStartServiceWorkerContext_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kDidStopServiceWorkerContext: {
      return &ServiceWorkerHost::DidStopServiceWorkerContext_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kRequestWorker: {
      return &ServiceWorkerHost::RequestWorker_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kWorkerResponseAck: {
      return &ServiceWorkerHost::WorkerResponseAck_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kOpenChannelToExtension: {
      return &ServiceWorkerHost::OpenChannelToExtension_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kOpenChannelToNativeApp: {
      return &ServiceWorkerHost::OpenChannelToNativeApp_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerHost::kOpenChannelToTab: {
      return &ServiceWorkerHost::OpenChannelToTab_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerHost>(message.name())) {
      case messages::ServiceWorkerHost::kDidInitializeServiceWorkerContext:
            return "Receive extensions::mojom::ServiceWorkerHost::DidInitializeServiceWorkerContext";
      case messages::ServiceWorkerHost::kDidStartServiceWorkerContext:
            return "Receive extensions::mojom::ServiceWorkerHost::DidStartServiceWorkerContext";
      case messages::ServiceWorkerHost::kDidStopServiceWorkerContext:
            return "Receive extensions::mojom::ServiceWorkerHost::DidStopServiceWorkerContext";
      case messages::ServiceWorkerHost::kRequestWorker:
            return "Receive extensions::mojom::ServiceWorkerHost::RequestWorker";
      case messages::ServiceWorkerHost::kWorkerResponseAck:
            return "Receive extensions::mojom::ServiceWorkerHost::WorkerResponseAck";
      case messages::ServiceWorkerHost::kOpenChannelToExtension:
            return "Receive extensions::mojom::ServiceWorkerHost::OpenChannelToExtension";
      case messages::ServiceWorkerHost::kOpenChannelToNativeApp:
            return "Receive extensions::mojom::ServiceWorkerHost::OpenChannelToNativeApp";
      case messages::ServiceWorkerHost::kOpenChannelToTab:
            return "Receive extensions::mojom::ServiceWorkerHost::OpenChannelToTab";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerHost>(message.name())) {
      case messages::ServiceWorkerHost::kDidInitializeServiceWorkerContext:
            return "Receive reply extensions::mojom::ServiceWorkerHost::DidInitializeServiceWorkerContext";
      case messages::ServiceWorkerHost::kDidStartServiceWorkerContext:
            return "Receive reply extensions::mojom::ServiceWorkerHost::DidStartServiceWorkerContext";
      case messages::ServiceWorkerHost::kDidStopServiceWorkerContext:
            return "Receive reply extensions::mojom::ServiceWorkerHost::DidStopServiceWorkerContext";
      case messages::ServiceWorkerHost::kRequestWorker:
            return "Receive reply extensions::mojom::ServiceWorkerHost::RequestWorker";
      case messages::ServiceWorkerHost::kWorkerResponseAck:
            return "Receive reply extensions::mojom::ServiceWorkerHost::WorkerResponseAck";
      case messages::ServiceWorkerHost::kOpenChannelToExtension:
            return "Receive reply extensions::mojom::ServiceWorkerHost::OpenChannelToExtension";
      case messages::ServiceWorkerHost::kOpenChannelToNativeApp:
            return "Receive reply extensions::mojom::ServiceWorkerHost::OpenChannelToNativeApp";
      case messages::ServiceWorkerHost::kOpenChannelToTab:
            return "Receive reply extensions::mojom::ServiceWorkerHost::OpenChannelToTab";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerHost::DidInitializeServiceWorkerContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc837c9aa;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::DidInitializeServiceWorkerContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::DidStartServiceWorkerContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e2ff3ea;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::DidStartServiceWorkerContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::DidStopServiceWorkerContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9bbee74;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::DidStopServiceWorkerContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::RequestWorker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97aa9d63;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::RequestWorker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::WorkerResponseAck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44a8c144;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::WorkerResponseAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::OpenChannelToExtension_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9728b9f;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::OpenChannelToExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::OpenChannelToNativeApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3768b0ea;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::OpenChannelToNativeApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerHost::OpenChannelToTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79c42a9f;  // IPCStableHash for extensions::mojom::ServiceWorkerHost::OpenChannelToTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerHost_RequestWorker_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerHost_RequestWorker_ForwardToCallback(
      ServiceWorkerHost::RequestWorkerCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerHost_RequestWorker_ForwardToCallback(const ServiceWorkerHost_RequestWorker_ForwardToCallback&) = delete;
  ServiceWorkerHost_RequestWorker_ForwardToCallback& operator=(const ServiceWorkerHost_RequestWorker_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerHost::RequestWorkerCallback callback_;
};

ServiceWorkerHostProxy::ServiceWorkerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerHostProxy::DidInitializeServiceWorkerContext(
    const ::extensions::ExtensionId& in_extension_id, int64_t in_service_worker_version_id, int32_t in_worker_thread_id, const ::blink::ServiceWorkerToken& in_service_worker_token, ::mojo::PendingAssociatedRemote<::extensions::mojom::EventDispatcher> in_event_dispatcher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::DidInitializeServiceWorkerContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_token"), in_service_worker_token,
                        "<value of type const ::blink::ServiceWorkerToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_dispatcher"), in_event_dispatcher,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::EventDispatcher>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kDidInitializeServiceWorkerContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ServiceWorkerHost.DidInitializeServiceWorkerContext request");

  params->service_worker_version_id = in_service_worker_version_id;

  params->worker_thread_id = in_worker_thread_id;
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_token)::BaseType> service_worker_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerTokenDataView>(
    in_service_worker_token,
    service_worker_token_fragment);

  params->service_worker_token.Set(
      service_worker_token_fragment.is_null() ? nullptr : service_worker_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_worker_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_worker_token in ServiceWorkerHost.DidInitializeServiceWorkerContext request");

  
  mojo::internal::Serialize<::extensions::mojom::EventDispatcherAssociatedPtrInfoDataView>(
    in_event_dispatcher,
    &params->event_dispatcher,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->event_dispatcher)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid event_dispatcher in ServiceWorkerHost.DidInitializeServiceWorkerContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("DidInitializeServiceWorkerContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::DidStartServiceWorkerContext(
    const ::extensions::ExtensionId& in_extension_id, const ::base::UnguessableToken& in_activation_token, const ::GURL& in_service_worker_scope, int64_t in_service_worker_version_id, int32_t in_worker_thread_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::DidStartServiceWorkerContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activation_token"), in_activation_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_scope"), in_service_worker_scope,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kDidStartServiceWorkerContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ServiceWorkerHost.DidStartServiceWorkerContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->activation_token)::BaseType> activation_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_activation_token,
    activation_token_fragment);

  params->activation_token.Set(
      activation_token_fragment.is_null() ? nullptr : activation_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->activation_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null activation_token in ServiceWorkerHost.DidStartServiceWorkerContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_scope)::BaseType> service_worker_scope_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_service_worker_scope,
    service_worker_scope_fragment);

  params->service_worker_scope.Set(
      service_worker_scope_fragment.is_null() ? nullptr : service_worker_scope_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_worker_scope.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_worker_scope in ServiceWorkerHost.DidStartServiceWorkerContext request");

  params->service_worker_version_id = in_service_worker_version_id;

  params->worker_thread_id = in_worker_thread_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("DidStartServiceWorkerContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::DidStopServiceWorkerContext(
    const ::extensions::ExtensionId& in_extension_id, const ::base::UnguessableToken& in_activation_token, const ::GURL& in_service_worker_scope, int64_t in_service_worker_version_id, int32_t in_worker_thread_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::DidStopServiceWorkerContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("activation_token"), in_activation_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_scope"), in_service_worker_scope,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_version_id"), in_service_worker_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_thread_id"), in_worker_thread_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kDidStopServiceWorkerContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in ServiceWorkerHost.DidStopServiceWorkerContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->activation_token)::BaseType> activation_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_activation_token,
    activation_token_fragment);

  params->activation_token.Set(
      activation_token_fragment.is_null() ? nullptr : activation_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->activation_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null activation_token in ServiceWorkerHost.DidStopServiceWorkerContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_worker_scope)::BaseType> service_worker_scope_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_service_worker_scope,
    service_worker_scope_fragment);

  params->service_worker_scope.Set(
      service_worker_scope_fragment.is_null() ? nullptr : service_worker_scope_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_worker_scope.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_worker_scope in ServiceWorkerHost.DidStopServiceWorkerContext request");

  params->service_worker_version_id = in_service_worker_version_id;

  params->worker_thread_id = in_worker_thread_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("DidStopServiceWorkerContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::RequestWorker(
    ::extensions::mojom::RequestParamsPtr in_params, RequestWorkerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::RequestWorker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::extensions::mojom::RequestParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kRequestWorker), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_RequestWorker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::RequestParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ServiceWorkerHost.RequestWorker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("RequestWorker");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerHost_RequestWorker_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerHostProxy::WorkerResponseAck(
    const ::base::Uuid& in_request_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::WorkerResponseAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_uuid"), in_request_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kWorkerResponseAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_WorkerResponseAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_uuid)::BaseType> request_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_request_uuid,
    request_uuid_fragment);

  params->request_uuid.Set(
      request_uuid_fragment.is_null() ? nullptr : request_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_uuid in ServiceWorkerHost.WorkerResponseAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("WorkerResponseAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::OpenChannelToExtension(
    ::extensions::mojom::ExternalConnectionInfoPtr in_info, ::extensions::mojom::ChannelType in_channel_type, const std::string& in_channel_name, const ::extensions::PortId& in_port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> in_port_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::OpenChannelToExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::extensions::mojom::ExternalConnectionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_type"), in_channel_type,
                        "<value of type ::extensions::mojom::ChannelType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_name"), in_channel_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenChannelToExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_OpenChannelToExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExternalConnectionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ServiceWorkerHost.OpenChannelToExtension request");

  
  mojo::internal::Serialize<::extensions::mojom::ChannelType>(
    in_channel_type,
    &params->channel_type);
  mojo::internal::MessageFragment<
      typename decltype(params->channel_name)::BaseType> channel_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_channel_name,
    channel_name_fragment);

  params->channel_name.Set(
      channel_name_fragment.is_null() ? nullptr : channel_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->channel_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null channel_name in ServiceWorkerHost.OpenChannelToExtension request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in ServiceWorkerHost.OpenChannelToExtension request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedPtrInfoDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in ServiceWorkerHost.OpenChannelToExtension request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedRequestDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in ServiceWorkerHost.OpenChannelToExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenChannelToExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::OpenChannelToNativeApp(
    const std::string& in_native_app_name, const ::extensions::PortId& in_port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> in_port_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::OpenChannelToNativeApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_app_name"), in_native_app_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenChannelToNativeApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_OpenChannelToNativeApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_app_name)::BaseType> native_app_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_app_name,
    native_app_name_fragment);

  params->native_app_name.Set(
      native_app_name_fragment.is_null() ? nullptr : native_app_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_app_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_app_name in ServiceWorkerHost.OpenChannelToNativeApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in ServiceWorkerHost.OpenChannelToNativeApp request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedPtrInfoDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in ServiceWorkerHost.OpenChannelToNativeApp request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedRequestDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in ServiceWorkerHost.OpenChannelToNativeApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenChannelToNativeApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerHostProxy::OpenChannelToTab(
    int32_t in_tab_id, int32_t in_frame_id, const std::optional<std::string>& in_document_id, ::extensions::mojom::ChannelType in_channel_type, const std::string& in_channel_name, const ::extensions::PortId& in_port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> in_port_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::ServiceWorkerHost::OpenChannelToTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_id"), in_document_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_type"), in_channel_type,
                        "<value of type ::extensions::mojom::ChannelType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_name"), in_channel_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kOpenChannelToTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_OpenChannelToTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_id)::BaseType> document_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_document_id,
    document_id_fragment);

  params->document_id.Set(
      document_id_fragment.is_null() ? nullptr : document_id_fragment.data());

  
  mojo::internal::Serialize<::extensions::mojom::ChannelType>(
    in_channel_type,
    &params->channel_type);
  mojo::internal::MessageFragment<
      typename decltype(params->channel_name)::BaseType> channel_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_channel_name,
    channel_name_fragment);

  params->channel_name.Set(
      channel_name_fragment.is_null() ? nullptr : channel_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->channel_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null channel_name in ServiceWorkerHost.OpenChannelToTab request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in ServiceWorkerHost.OpenChannelToTab request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedPtrInfoDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in ServiceWorkerHost.OpenChannelToTab request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedRequestDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in ServiceWorkerHost.OpenChannelToTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("OpenChannelToTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ServiceWorkerHost_RequestWorker_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerHost::RequestWorkerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerHost_RequestWorker_ProxyToResponder> proxy(
        new ServiceWorkerHost_RequestWorker_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerHost_RequestWorker_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerHost_RequestWorker_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerHost_RequestWorker_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerHost::RequestWorkerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::base::Value::List in_response_wrapper, const std::string& in_error, ::extensions::mojom::ExtraResponseDataPtr in_extra_data);
};

bool ServiceWorkerHost_RequestWorker_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerHost_RequestWorker_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerHost_RequestWorker_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerHost.3
  bool success = true;
  bool p_success{};
  ::base::Value::List p_response_wrapper{};
  std::string p_error{};
  ::extensions::mojom::ExtraResponseDataPtr p_extra_data{};
  ServiceWorkerHost_RequestWorker_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResponseWrapper(&p_response_wrapper))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadExtraData(&p_extra_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_response_wrapper), 
std::move(p_error), 
std::move(p_extra_data));
  }
  return true;
}

void ServiceWorkerHost_RequestWorker_ProxyToResponder::Run(
    bool in_success, ::base::Value::List in_response_wrapper, const std::string& in_error, ::extensions::mojom::ExtraResponseDataPtr in_extra_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::ServiceWorkerHost::RequestWorker", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_wrapper"), in_response_wrapper,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extra_data"), in_extra_data,
                        "<value of type ::extensions::mojom::ExtraResponseDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerHost::kRequestWorker), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::ServiceWorkerHost_RequestWorker_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->response_wrapper)::BaseType> response_wrapper_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_response_wrapper,
    response_wrapper_fragment);

  params->response_wrapper.Set(
      response_wrapper_fragment.is_null() ? nullptr : response_wrapper_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_wrapper.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_wrapper in ");
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in ");
  mojo::internal::MessageFragment<
      typename decltype(params->extra_data)::BaseType> extra_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtraResponseDataDataView>(
    in_extra_data,
    extra_data_fragment);

  params->extra_data.Set(
      extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerHost::Name_);
  message.set_method_name("RequestWorker");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerHostStubDispatch::Accept(
    ServiceWorkerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerHost>(message->header()->name)) {
    case messages::ServiceWorkerHost::kDidInitializeServiceWorkerContext: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.0
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      ::blink::ServiceWorkerToken p_service_worker_token{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::EventDispatcher> p_event_dispatcher{};
      ServiceWorkerHost_DidInitializeServiceWorkerContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (success && !input_data_view.ReadServiceWorkerToken(&p_service_worker_token))
        success = false;
      if (success) {
        p_event_dispatcher =
            input_data_view.TakeEventDispatcher<decltype(p_event_dispatcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidInitializeServiceWorkerContext(        
        std::move(p_extension_id), 
        std::move(p_service_worker_version_id), 
        std::move(p_worker_thread_id), 
        std::move(p_service_worker_token), 
        std::move(p_event_dispatcher));
      return true;
    }
    case messages::ServiceWorkerHost::kDidStartServiceWorkerContext: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.1
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      ::base::UnguessableToken p_activation_token{};
      ::GURL p_service_worker_scope{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      ServiceWorkerHost_DidStartServiceWorkerContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadActivationToken(&p_activation_token))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerScope(&p_service_worker_scope))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartServiceWorkerContext(        
        std::move(p_extension_id), 
        std::move(p_activation_token), 
        std::move(p_service_worker_scope), 
        std::move(p_service_worker_version_id), 
        std::move(p_worker_thread_id));
      return true;
    }
    case messages::ServiceWorkerHost::kDidStopServiceWorkerContext: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.2
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      ::base::UnguessableToken p_activation_token{};
      ::GURL p_service_worker_scope{};
      int64_t p_service_worker_version_id{};
      int32_t p_worker_thread_id{};
      ServiceWorkerHost_DidStopServiceWorkerContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadActivationToken(&p_activation_token))
        success = false;
      if (success && !input_data_view.ReadServiceWorkerScope(&p_service_worker_scope))
        success = false;
      if (success)
        p_service_worker_version_id = input_data_view.service_worker_version_id();
      if (success)
        p_worker_thread_id = input_data_view.worker_thread_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopServiceWorkerContext(        
        std::move(p_extension_id), 
        std::move(p_activation_token), 
        std::move(p_service_worker_scope), 
        std::move(p_service_worker_version_id), 
        std::move(p_worker_thread_id));
      return true;
    }
    case messages::ServiceWorkerHost::kRequestWorker: {
      break;
    }
    case messages::ServiceWorkerHost::kWorkerResponseAck: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_WorkerResponseAck_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_WorkerResponseAck_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.4
      bool success = true;
      ::base::Uuid p_request_uuid{};
      ServiceWorkerHost_WorkerResponseAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestUuid(&p_request_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WorkerResponseAck(        
        std::move(p_request_uuid));
      return true;
    }
    case messages::ServiceWorkerHost::kOpenChannelToExtension: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_OpenChannelToExtension_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_OpenChannelToExtension_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.5
      bool success = true;
      ::extensions::mojom::ExternalConnectionInfoPtr p_info{};
      ::extensions::mojom::ChannelType p_channel_type{};
      std::string p_channel_name{};
      ::extensions::PortId p_port_id{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> p_port_host{};
      ServiceWorkerHost_OpenChannelToExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadChannelType(&p_channel_type))
        success = false;
      if (success && !input_data_view.ReadChannelName(&p_channel_name))
        success = false;
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToExtension(        
        std::move(p_info), 
        std::move(p_channel_type), 
        std::move(p_channel_name), 
        std::move(p_port_id), 
        std::move(p_port), 
        std::move(p_port_host));
      return true;
    }
    case messages::ServiceWorkerHost::kOpenChannelToNativeApp: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_OpenChannelToNativeApp_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_OpenChannelToNativeApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.6
      bool success = true;
      std::string p_native_app_name{};
      ::extensions::PortId p_port_id{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> p_port_host{};
      ServiceWorkerHost_OpenChannelToNativeApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeAppName(&p_native_app_name))
        success = false;
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToNativeApp(        
        std::move(p_native_app_name), 
        std::move(p_port_id), 
        std::move(p_port), 
        std::move(p_port_host));
      return true;
    }
    case messages::ServiceWorkerHost::kOpenChannelToTab: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerHost_OpenChannelToTab_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerHost_OpenChannelToTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerHost.7
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_frame_id{};
      std::optional<std::string> p_document_id{};
      ::extensions::mojom::ChannelType p_channel_type{};
      std::string p_channel_name{};
      ::extensions::PortId p_port_id{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> p_port_host{};
      ServiceWorkerHost_OpenChannelToTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadDocumentId(&p_document_id))
        success = false;
      if (success && !input_data_view.ReadChannelType(&p_channel_type))
        success = false;
      if (success && !input_data_view.ReadChannelName(&p_channel_name))
        success = false;
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToTab(        
        std::move(p_tab_id), 
        std::move(p_frame_id), 
        std::move(p_document_id), 
        std::move(p_channel_type), 
        std::move(p_channel_name), 
        std::move(p_port_id), 
        std::move(p_port), 
        std::move(p_port_host));
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerHostStubDispatch::AcceptWithResponder(
    ServiceWorkerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerHost>(message->header()->name)) {
    case messages::ServiceWorkerHost::kDidInitializeServiceWorkerContext: {
      break;
    }
    case messages::ServiceWorkerHost::kDidStartServiceWorkerContext: {
      break;
    }
    case messages::ServiceWorkerHost::kDidStopServiceWorkerContext: {
      break;
    }
    case messages::ServiceWorkerHost::kRequestWorker: {
      internal::ServiceWorkerHost_RequestWorker_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerHost_RequestWorker_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerHost.3
      bool success = true;
      ::extensions::mojom::RequestParamsPtr p_params{};
      ServiceWorkerHost_RequestWorker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerHost::Name_, 3, false);
        return false;
      }
      auto callback =
          ServiceWorkerHost_RequestWorker_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestWorker(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerHost::kWorkerResponseAck: {
      break;
    }
    case messages::ServiceWorkerHost::kOpenChannelToExtension: {
      break;
    }
    case messages::ServiceWorkerHost::kOpenChannelToNativeApp: {
      break;
    }
    case messages::ServiceWorkerHost::kOpenChannelToTab: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerHostValidationInfo[] = {
    { &internal::ServiceWorkerHost_DidInitializeServiceWorkerContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_DidStartServiceWorkerContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_DidStopServiceWorkerContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_RequestWorker_Params_Data::Validate,
     &internal::ServiceWorkerHost_RequestWorker_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerHost_WorkerResponseAck_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_OpenChannelToExtension_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_OpenChannelToNativeApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerHost_OpenChannelToTab_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::extensions::mojom::ServiceWorkerHost::Name_,
    kServiceWorkerHostValidationInfo);
}

bool ServiceWorkerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::extensions::mojom::ServiceWorkerHost::Name_,
    kServiceWorkerHostValidationInfo);
}


}  // extensions::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void ServiceWorkerHostInterceptorForTesting::DidInitializeServiceWorkerContext(const ::extensions::ExtensionId& extension_id, int64_t service_worker_version_id, int32_t worker_thread_id, const ::blink::ServiceWorkerToken& service_worker_token, ::mojo::PendingAssociatedRemote<::extensions::mojom::EventDispatcher> event_dispatcher) {
  GetForwardingInterface()->DidInitializeServiceWorkerContext(
    std::move(extension_id)
    , 
    std::move(service_worker_version_id)
    , 
    std::move(worker_thread_id)
    , 
    std::move(service_worker_token)
    , 
    std::move(event_dispatcher)
    );
}
void ServiceWorkerHostInterceptorForTesting::DidStartServiceWorkerContext(const ::extensions::ExtensionId& extension_id, const ::base::UnguessableToken& activation_token, const ::GURL& service_worker_scope, int64_t service_worker_version_id, int32_t worker_thread_id) {
  GetForwardingInterface()->DidStartServiceWorkerContext(
    std::move(extension_id)
    , 
    std::move(activation_token)
    , 
    std::move(service_worker_scope)
    , 
    std::move(service_worker_version_id)
    , 
    std::move(worker_thread_id)
    );
}
void ServiceWorkerHostInterceptorForTesting::DidStopServiceWorkerContext(const ::extensions::ExtensionId& extension_id, const ::base::UnguessableToken& activation_token, const ::GURL& service_worker_scope, int64_t service_worker_version_id, int32_t worker_thread_id) {
  GetForwardingInterface()->DidStopServiceWorkerContext(
    std::move(extension_id)
    , 
    std::move(activation_token)
    , 
    std::move(service_worker_scope)
    , 
    std::move(service_worker_version_id)
    , 
    std::move(worker_thread_id)
    );
}
void ServiceWorkerHostInterceptorForTesting::RequestWorker(::extensions::mojom::RequestParamsPtr params, RequestWorkerCallback callback) {
  GetForwardingInterface()->RequestWorker(
    std::move(params)
    , std::move(callback));
}
void ServiceWorkerHostInterceptorForTesting::WorkerResponseAck(const ::base::Uuid& request_uuid) {
  GetForwardingInterface()->WorkerResponseAck(
    std::move(request_uuid)
    );
}
void ServiceWorkerHostInterceptorForTesting::OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) {
  GetForwardingInterface()->OpenChannelToExtension(
    std::move(info)
    , 
    std::move(channel_type)
    , 
    std::move(channel_name)
    , 
    std::move(port_id)
    , 
    std::move(port)
    , 
    std::move(port_host)
    );
}
void ServiceWorkerHostInterceptorForTesting::OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) {
  GetForwardingInterface()->OpenChannelToNativeApp(
    std::move(native_app_name)
    , 
    std::move(port_id)
    , 
    std::move(port)
    , 
    std::move(port_host)
    );
}
void ServiceWorkerHostInterceptorForTesting::OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) {
  GetForwardingInterface()->OpenChannelToTab(
    std::move(tab_id)
    , 
    std::move(frame_id)
    , 
    std::move(document_id)
    , 
    std::move(channel_type)
    , 
    std::move(channel_name)
    , 
    std::move(port_id)
    , 
    std::move(port)
    , 
    std::move(port_host)
    );
}
ServiceWorkerHostAsyncWaiter::ServiceWorkerHostAsyncWaiter(
    ServiceWorkerHost* proxy) : proxy_(proxy) {}

ServiceWorkerHostAsyncWaiter::~ServiceWorkerHostAsyncWaiter() = default;


void ServiceWorkerHostAsyncWaiter::RequestWorker(
    ::extensions::mojom::RequestParamsPtr params, bool* out_success, ::base::Value::List* out_response_wrapper, std::string* out_error, ::extensions::mojom::ExtraResponseDataPtr* out_extra_data) {
  base::RunLoop loop;
  proxy_->RequestWorker(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::base::Value::List* out_response_wrapper
,
             std::string* out_error
,
             ::extensions::mojom::ExtraResponseDataPtr* out_extra_data
,
             bool success,
             ::base::Value::List response_wrapper,
             const std::string& error,
             ::extensions::mojom::ExtraResponseDataPtr extra_data) {*out_success = std::move(success);*out_response_wrapper = std::move(response_wrapper);*out_error = std::move(error);*out_extra_data = std::move(extra_data);
            loop->Quit();
          },
          &loop,
          out_success,
          out_response_wrapper,
          out_error,
          out_extra_data));
  loop.Run();
}








}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif