// extensions/common/mojom/permission_set.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_SEND_VALIDATION_H_
#define EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_SEND_VALIDATION_H_

#include "extensions/common/mojom/permission_set.mojom-shared-internal.h"
#include "extensions/common/mojom/api_permission_id.mojom-shared.h"
#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"

#include "extensions/common/mojom/permission_set.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::APIPermissionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::APIPermissionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::APIPermission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::extensions::mojom::APIPermissionID>(
        Traits::id(input),
        &fragment->id);

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<decltype(fragment->value)>
          value_fragment(fragment.message());
      value_fragment.Claim(&fragment->value);
      
      mojo::internal::Serialize<::mojo_base::mojom::ValueDataView, send_validation>(
        in_value,
        value_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::APIPermissionSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::APIPermissionSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::APIPermissionSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::permission_map(input)) in_permission_map = Traits::permission_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->permission_map)::BaseType>
          permission_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& permission_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::extensions::mojom::internal::APIPermissionID_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::extensions::mojom::APIPermissionID, ::extensions::mojom::APIPermissionDataView>, send_validation>(
        in_permission_map,
        permission_map_fragment,
        &permission_map_validate_params);

      fragment->permission_map.Set(
          permission_map_fragment.is_null() ? nullptr : permission_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->permission_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permission_map in APIPermissionSet struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::ManifestPermissionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ManifestPermissionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ManifestPermission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ManifestPermission struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<decltype(fragment->value)>
          value_fragment(fragment.message());
      value_fragment.Claim(&fragment->value);
      
      mojo::internal::Serialize<::mojo_base::mojom::ValueDataView, send_validation>(
        in_value,
        value_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::ManifestPermissionSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ManifestPermissionSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ManifestPermissionSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::permission_map(input)) in_permission_map = Traits::permission_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->permission_map)::BaseType>
          permission_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& permission_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::extensions::mojom::ManifestPermissionDataView>, send_validation>(
        in_permission_map,
        permission_map_fragment,
        &permission_map_validate_params);

      fragment->permission_map.Set(
          permission_map_fragment.is_null() ? nullptr : permission_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->permission_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permission_map in ManifestPermissionSet struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::extensions::mojom::PermissionSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::PermissionSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::PermissionSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::apis(input)) in_apis = Traits::apis(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->apis)::BaseType> apis_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::APIPermissionSetDataView, send_validation>(
        in_apis,
        apis_fragment);

      fragment->apis.Set(
          apis_fragment.is_null() ? nullptr : apis_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->apis.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null apis in PermissionSet struct");

      decltype(Traits::manifest_permissions(input)) in_manifest_permissions = Traits::manifest_permissions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->manifest_permissions)::BaseType> manifest_permissions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::ManifestPermissionSetDataView, send_validation>(
        in_manifest_permissions,
        manifest_permissions_fragment);

      fragment->manifest_permissions.Set(
          manifest_permissions_fragment.is_null() ? nullptr : manifest_permissions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->manifest_permissions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manifest_permissions in PermissionSet struct");

      decltype(Traits::hosts(input)) in_hosts = Traits::hosts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hosts)::BaseType> hosts_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView, send_validation>(
        in_hosts,
        hosts_fragment);

      fragment->hosts.Set(
          hosts_fragment.is_null() ? nullptr : hosts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hosts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hosts in PermissionSet struct");

      decltype(Traits::user_script_hosts(input)) in_user_script_hosts = Traits::user_script_hosts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_script_hosts)::BaseType> user_script_hosts_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView, send_validation>(
        in_user_script_hosts,
        user_script_hosts_fragment);

      fragment->user_script_hosts.Set(
          user_script_hosts_fragment.is_null() ? nullptr : user_script_hosts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_script_hosts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_script_hosts in PermissionSet struct");
  }
};

}  // namespace mojo::internal

#endif  // EXTENSIONS_COMMON_MOJOM_PERMISSION_SET_MOJOM_SEND_VALIDATION_H_