// extensions/common/mojom/guest_view.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('extensions.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.GuestViewPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.GuestView.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.GuestViewInterface }
 */
extensions.mojom.GuestViewRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.GuestViewPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.GuestViewPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.GuestViewPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } success
   */

  readyToCreateMimeHandlerView(
      success) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
        null,
        [
          success
        ],
        false);
  }

  
  /**
   * @param { !string } scriptId
   * @return {!Promise<{
        allowed: !boolean,
   *  }>}
   */

  canExecuteContentScript(
      scriptId) {
    return this.proxy.sendMessage(
        1,
        extensions.mojom.GuestView_CanExecuteContentScript_ParamsSpec.$,
        extensions.mojom.GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
        [
          scriptId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GuestView
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.GuestViewReceiver = class {
  /**
   * @param {!extensions.mojom.GuestViewInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.GuestViewRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.GuestViewRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.GuestViewRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
        null,
        impl.readyToCreateMimeHandlerView.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.GuestView_CanExecuteContentScript_ParamsSpec.$,
        extensions.mojom.GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
        impl.canExecuteContentScript.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.GuestView = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.GuestView";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.GuestViewRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.GuestViewRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GuestView
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.GuestViewCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.GuestViewRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.GuestViewRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readyToCreateMimeHandlerView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
        null,
        this.readyToCreateMimeHandlerView.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.canExecuteContentScript =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.GuestView_CanExecuteContentScript_ParamsSpec.$,
        extensions.mojom.GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
        this.canExecuteContentScript.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.MimeHandlerViewContainerManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.MimeHandlerViewContainerManagerInterface }
 */
extensions.mojom.MimeHandlerViewContainerManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.MimeHandlerViewContainerManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.MimeHandlerViewContainerManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.MimeHandlerViewContainerManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } tokenId
   */

  setInternalId(
      tokenId) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
        null,
        [
          tokenId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        beforeUnloadControl: !extensions.mimeHandler.BeforeUnloadControlRemote,
   *  }>}
   */

  createBeforeUnloadControl() {
    return this.proxy.sendMessage(
        1,
        extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
        extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } elementInstanceId
   */

  destroyFrameContainer(
      elementInstanceId) {
    this.proxy.sendMessage(
        2,
        extensions.mojom.MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
        null,
        [
          elementInstanceId
        ],
        false);
  }

  
  /**
   * @param { !number } mimeHandlerViewGuestElementInstanceId
   * @param { !url.mojom.Url } resourceUrl
   */

  didLoad(
      mimeHandlerViewGuestElementInstanceId,
      resourceUrl) {
    this.proxy.sendMessage(
        3,
        extensions.mojom.MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
        null,
        [
          mimeHandlerViewGuestElementInstanceId,
          resourceUrl
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MimeHandlerViewContainerManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManagerReceiver = class {
  /**
   * @param {!extensions.mojom.MimeHandlerViewContainerManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.MimeHandlerViewContainerManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.MimeHandlerViewContainerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.MimeHandlerViewContainerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
        null,
        impl.setInternalId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
        extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
        impl.createBeforeUnloadControl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
        null,
        impl.destroyFrameContainer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
        null,
        impl.didLoad.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.MimeHandlerViewContainerManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.MimeHandlerViewContainerManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.MimeHandlerViewContainerManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.MimeHandlerViewContainerManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MimeHandlerViewContainerManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.MimeHandlerViewContainerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.MimeHandlerViewContainerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInternalId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
        null,
        this.setInternalId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createBeforeUnloadControl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
        extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
        this.createBeforeUnloadControl.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.destroyFrameContainer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        extensions.mojom.MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
        null,
        this.destroyFrameContainer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        extensions.mojom.MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
        null,
        this.didLoad.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.GuestView_ReadyToCreateMimeHandlerView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.GuestView_CanExecuteContentScript_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.GuestView_CanExecuteContentScript_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManager_SetInternalId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.MimeHandlerViewContainerManager_DidLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.GuestView_ReadyToCreateMimeHandlerView_ParamsSpec.$,
    'GuestView_ReadyToCreateMimeHandlerView_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.GuestView_ReadyToCreateMimeHandlerView_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    extensions.mojom.GuestView_CanExecuteContentScript_ParamsSpec.$,
    'GuestView_CanExecuteContentScript_Params',
    [
      mojo.internal.StructField(
        'scriptId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.GuestView_CanExecuteContentScript_Params = class {
  constructor() {
    /** @export { !string } */
    this.scriptId;
  }
};



mojo.internal.Struct(
    extensions.mojom.GuestView_CanExecuteContentScript_ResponseParamsSpec.$,
    'GuestView_CanExecuteContentScript_ResponseParams',
    [
      mojo.internal.StructField(
        'allowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.GuestView_CanExecuteContentScript_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.allowed;
  }
};



mojo.internal.Struct(
    extensions.mojom.MimeHandlerViewContainerManager_SetInternalId_ParamsSpec.$,
    'MimeHandlerViewContainerManager_SetInternalId_Params',
    [
      mojo.internal.StructField(
        'tokenId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.MimeHandlerViewContainerManager_SetInternalId_Params = class {
  constructor() {
    /** @export { !string } */
    this.tokenId;
  }
};



mojo.internal.Struct(
    extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ParamsSpec.$,
    'MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParamsSpec.$,
    'MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams',
    [
      mojo.internal.StructField(
        'beforeUnloadControl', 0,
        0,
        mojo.internal.InterfaceProxy(extensions.mimeHandler.BeforeUnloadControlRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.MimeHandlerViewContainerManager_CreateBeforeUnloadControl_ResponseParams = class {
  constructor() {
    /** @export { !extensions.mimeHandler.BeforeUnloadControlRemote } */
    this.beforeUnloadControl;
  }
};



mojo.internal.Struct(
    extensions.mojom.MimeHandlerViewContainerManager_DestroyFrameContainer_ParamsSpec.$,
    'MimeHandlerViewContainerManager_DestroyFrameContainer_Params',
    [
      mojo.internal.StructField(
        'elementInstanceId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.MimeHandlerViewContainerManager_DestroyFrameContainer_Params = class {
  constructor() {
    /** @export { !number } */
    this.elementInstanceId;
  }
};



mojo.internal.Struct(
    extensions.mojom.MimeHandlerViewContainerManager_DidLoad_ParamsSpec.$,
    'MimeHandlerViewContainerManager_DidLoad_Params',
    [
      mojo.internal.StructField(
        'mimeHandlerViewGuestElementInstanceId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resourceUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mojom.MimeHandlerViewContainerManager_DidLoad_Params = class {
  constructor() {
    /** @export { !number } */
    this.mimeHandlerViewGuestElementInstanceId;
    /** @export { !url.mojom.Url } */
    this.resourceUrl;
  }
};

