// extensions/common/mojom/frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/frame.mojom-params-data.h"
#include "extensions/common/mojom/frame.mojom-shared-message-ids.h"

#include "extensions/common/mojom/frame.mojom-import-headers.h"
#include "extensions/common/mojom/frame.mojom-test-utils.h"


namespace extensions::mojom {
ExecuteCodeParams::ExecuteCodeParams()
    : host_id(),
      injection(),
      webview_src(),
      match_origin_as_fallback_behavior(),
      run_at(),
      is_web_view() {}

ExecuteCodeParams::ExecuteCodeParams(
    ::extensions::mojom::HostIDPtr host_id_in,
    ::extensions::mojom::CodeInjectionPtr injection_in,
    const ::GURL& webview_src_in,
    ::extensions::mojom::MatchOriginAsFallbackBehavior match_origin_as_fallback_behavior_in,
    ::extensions::mojom::RunLocation run_at_in,
    bool is_web_view_in)
    : host_id(std::move(host_id_in)),
      injection(std::move(injection_in)),
      webview_src(std::move(webview_src_in)),
      match_origin_as_fallback_behavior(std::move(match_origin_as_fallback_behavior_in)),
      run_at(std::move(run_at_in)),
      is_web_view(std::move(is_web_view_in)) {}

ExecuteCodeParams::~ExecuteCodeParams() = default;

void ExecuteCodeParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_id"), this->host_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::HostIDPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injection"), this->injection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::CodeInjectionPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webview_src"), this->webview_src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_origin_as_fallback_behavior"), this->match_origin_as_fallback_behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::MatchOriginAsFallbackBehavior>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "run_at"), this->run_at,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::RunLocation>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_web_view"), this->is_web_view,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExecuteCodeParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RequestParams::RequestParams()
    : name(),
      arguments(),
      extension_id(),
      source_url(),
      context_type(),
      request_id(),
      has_callback(),
      user_gesture(),
      worker_thread_id(),
      service_worker_version_id(),
      js_callstack() {}

RequestParams::RequestParams(
    const std::string& name_in,
    ::base::Value::List arguments_in,
    const std::string& extension_id_in,
    const ::GURL& source_url_in,
    ::extensions::mojom::ContextType context_type_in,
    int32_t request_id_in,
    bool has_callback_in,
    bool user_gesture_in,
    int32_t worker_thread_id_in,
    int64_t service_worker_version_id_in,
    std::optional<std::vector<::extensions::StackFrame>> js_callstack_in)
    : name(std::move(name_in)),
      arguments(std::move(arguments_in)),
      extension_id(std::move(extension_id_in)),
      source_url(std::move(source_url_in)),
      context_type(std::move(context_type_in)),
      request_id(std::move(request_id_in)),
      has_callback(std::move(has_callback_in)),
      user_gesture(std::move(user_gesture_in)),
      worker_thread_id(std::move(worker_thread_id_in)),
      service_worker_version_id(std::move(service_worker_version_id_in)),
      js_callstack(std::move(js_callstack_in)) {}

RequestParams::~RequestParams() = default;

void RequestParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "arguments"), this->arguments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::List>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension_id"), this->extension_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_url"), this->source_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_type"), this->context_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::extensions::mojom::ContextType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_callback"), this->has_callback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worker_thread_id"), this->worker_thread_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_worker_version_id"), this->service_worker_version_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "js_callstack"), this->js_callstack,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::extensions::StackFrame>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LocalFrame::IPCStableHashFunction LocalFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalFrame>(message.name())) {
    case messages::LocalFrame::kSetFrameName: {
      return &LocalFrame::SetFrameName_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSetSpatialNavigationEnabled: {
      return &LocalFrame::SetSpatialNavigationEnabled_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kSetTabId: {
      return &LocalFrame::SetTabId_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kAppWindowClosed: {
      return &LocalFrame::AppWindowClosed_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kNotifyRenderViewType: {
      return &LocalFrame::NotifyRenderViewType_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kMessageInvoke: {
      return &LocalFrame::MessageInvoke_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kExecuteCode: {
      return &LocalFrame::ExecuteCode_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kExecuteDeclarativeScript: {
      return &LocalFrame::ExecuteDeclarativeScript_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kUpdateBrowserWindowId: {
      return &LocalFrame::UpdateBrowserWindowId_Sym::IPCStableHash;
    }
    case messages::LocalFrame::kDispatchOnConnect: {
      return &LocalFrame::DispatchOnConnect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalFrame>(message.name())) {
      case messages::LocalFrame::kSetFrameName:
            return "Receive extensions::mojom::LocalFrame::SetFrameName";
      case messages::LocalFrame::kSetSpatialNavigationEnabled:
            return "Receive extensions::mojom::LocalFrame::SetSpatialNavigationEnabled";
      case messages::LocalFrame::kSetTabId:
            return "Receive extensions::mojom::LocalFrame::SetTabId";
      case messages::LocalFrame::kAppWindowClosed:
            return "Receive extensions::mojom::LocalFrame::AppWindowClosed";
      case messages::LocalFrame::kNotifyRenderViewType:
            return "Receive extensions::mojom::LocalFrame::NotifyRenderViewType";
      case messages::LocalFrame::kMessageInvoke:
            return "Receive extensions::mojom::LocalFrame::MessageInvoke";
      case messages::LocalFrame::kExecuteCode:
            return "Receive extensions::mojom::LocalFrame::ExecuteCode";
      case messages::LocalFrame::kExecuteDeclarativeScript:
            return "Receive extensions::mojom::LocalFrame::ExecuteDeclarativeScript";
      case messages::LocalFrame::kUpdateBrowserWindowId:
            return "Receive extensions::mojom::LocalFrame::UpdateBrowserWindowId";
      case messages::LocalFrame::kDispatchOnConnect:
            return "Receive extensions::mojom::LocalFrame::DispatchOnConnect";
    }
  } else {
    switch (static_cast<messages::LocalFrame>(message.name())) {
      case messages::LocalFrame::kSetFrameName:
            return "Receive reply extensions::mojom::LocalFrame::SetFrameName";
      case messages::LocalFrame::kSetSpatialNavigationEnabled:
            return "Receive reply extensions::mojom::LocalFrame::SetSpatialNavigationEnabled";
      case messages::LocalFrame::kSetTabId:
            return "Receive reply extensions::mojom::LocalFrame::SetTabId";
      case messages::LocalFrame::kAppWindowClosed:
            return "Receive reply extensions::mojom::LocalFrame::AppWindowClosed";
      case messages::LocalFrame::kNotifyRenderViewType:
            return "Receive reply extensions::mojom::LocalFrame::NotifyRenderViewType";
      case messages::LocalFrame::kMessageInvoke:
            return "Receive reply extensions::mojom::LocalFrame::MessageInvoke";
      case messages::LocalFrame::kExecuteCode:
            return "Receive reply extensions::mojom::LocalFrame::ExecuteCode";
      case messages::LocalFrame::kExecuteDeclarativeScript:
            return "Receive reply extensions::mojom::LocalFrame::ExecuteDeclarativeScript";
      case messages::LocalFrame::kUpdateBrowserWindowId:
            return "Receive reply extensions::mojom::LocalFrame::UpdateBrowserWindowId";
      case messages::LocalFrame::kDispatchOnConnect:
            return "Receive reply extensions::mojom::LocalFrame::DispatchOnConnect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalFrame::SetFrameName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd23eee80;  // IPCStableHash for extensions::mojom::LocalFrame::SetFrameName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SetSpatialNavigationEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1440bc45;  // IPCStableHash for extensions::mojom::LocalFrame::SetSpatialNavigationEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::SetTabId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x060843ba;  // IPCStableHash for extensions::mojom::LocalFrame::SetTabId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::AppWindowClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb02331df;  // IPCStableHash for extensions::mojom::LocalFrame::AppWindowClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::NotifyRenderViewType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1cdfcda3;  // IPCStableHash for extensions::mojom::LocalFrame::NotifyRenderViewType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::MessageInvoke_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2aa9f81c;  // IPCStableHash for extensions::mojom::LocalFrame::MessageInvoke
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ExecuteCode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x38c3e662;  // IPCStableHash for extensions::mojom::LocalFrame::ExecuteCode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::ExecuteDeclarativeScript_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaff6dc15;  // IPCStableHash for extensions::mojom::LocalFrame::ExecuteDeclarativeScript
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::UpdateBrowserWindowId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa24113cd;  // IPCStableHash for extensions::mojom::LocalFrame::UpdateBrowserWindowId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrame::DispatchOnConnect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ed93c0e;  // IPCStableHash for extensions::mojom::LocalFrame::DispatchOnConnect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LocalFrame_ExecuteCode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_ExecuteCode_ForwardToCallback(
      LocalFrame::ExecuteCodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_ExecuteCode_ForwardToCallback(const LocalFrame_ExecuteCode_ForwardToCallback&) = delete;
  LocalFrame_ExecuteCode_ForwardToCallback& operator=(const LocalFrame_ExecuteCode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::ExecuteCodeCallback callback_;
};

class LocalFrame_DispatchOnConnect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrame_DispatchOnConnect_ForwardToCallback(
      LocalFrame::DispatchOnConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrame_DispatchOnConnect_ForwardToCallback(const LocalFrame_DispatchOnConnect_ForwardToCallback&) = delete;
  LocalFrame_DispatchOnConnect_ForwardToCallback& operator=(const LocalFrame_DispatchOnConnect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrame::DispatchOnConnectCallback callback_;
};

LocalFrameProxy::LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameProxy::SetFrameName(
    const std::string& in_frame_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::SetFrameName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_name"), in_frame_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSetFrameName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetFrameName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_name)::BaseType> frame_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_frame_name,
    frame_name_fragment);

  params->frame_name.Set(
      frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_name in LocalFrame.SetFrameName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetFrameName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::SetSpatialNavigationEnabled(
    bool in_spatial_nav_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::SetSpatialNavigationEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("spatial_nav_enabled"), in_spatial_nav_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSetSpatialNavigationEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->spatial_nav_enabled = in_spatial_nav_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetSpatialNavigationEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::SetTabId(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::SetTabId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kSetTabId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_SetTabId_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("SetTabId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::AppWindowClosed(
    bool in_send_onclosed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::AppWindowClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("send_onclosed"), in_send_onclosed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kAppWindowClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_AppWindowClosed_Params_Data> params(
          message);
  params.Allocate();

  params->send_onclosed = in_send_onclosed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("AppWindowClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::NotifyRenderViewType(
    ::extensions::mojom::ViewType in_view_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::NotifyRenderViewType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_type"), in_view_type,
                        "<value of type ::extensions::mojom::ViewType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kNotifyRenderViewType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_NotifyRenderViewType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::extensions::mojom::ViewType>(
    in_view_type,
    &params->view_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("NotifyRenderViewType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::MessageInvoke(
    const ::extensions::ExtensionId& in_extension_id, const std::string& in_module_name, const std::string& in_function_name, ::base::Value::List in_args) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::MessageInvoke", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("function_name"), in_function_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type ::base::Value::List>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kMessageInvoke), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_MessageInvoke_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in LocalFrame.MessageInvoke request");
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in LocalFrame.MessageInvoke request");
  mojo::internal::MessageFragment<
      typename decltype(params->function_name)::BaseType> function_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_function_name,
    function_name_fragment);

  params->function_name.Set(
      function_name_fragment.is_null() ? nullptr : function_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->function_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null function_name in LocalFrame.MessageInvoke request");
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_args,
    args_fragment);

  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->args.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null args in LocalFrame.MessageInvoke request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("MessageInvoke");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::ExecuteCode(
    ExecuteCodeParamsPtr in_param, ExecuteCodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::ExecuteCode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("param"), in_param,
                        "<value of type ExecuteCodeParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExecuteCode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_ExecuteCode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->param)::BaseType> param_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExecuteCodeParamsDataView>(
    in_param,
    param_fragment);

  params->param.Set(
      param_fragment.is_null() ? nullptr : param_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->param.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null param in LocalFrame.ExecuteCode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExecuteCode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_ExecuteCode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameProxy::ExecuteDeclarativeScript(
    int32_t in_tab_id, const ::extensions::ExtensionId& in_extension_id, const std::string& in_script_id, const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::ExecuteDeclarativeScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_id"), in_script_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExecuteDeclarativeScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_ExecuteDeclarativeScript_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in LocalFrame.ExecuteDeclarativeScript request");
  mojo::internal::MessageFragment<
      typename decltype(params->script_id)::BaseType> script_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_script_id,
    script_id_fragment);

  params->script_id.Set(
      script_id_fragment.is_null() ? nullptr : script_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_id in LocalFrame.ExecuteDeclarativeScript request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrame.ExecuteDeclarativeScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExecuteDeclarativeScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::UpdateBrowserWindowId(
    int32_t in_window_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::UpdateBrowserWindowId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_id"), in_window_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kUpdateBrowserWindowId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_UpdateBrowserWindowId_Params_Data> params(
          message);
  params.Allocate();

  params->window_id = in_window_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("UpdateBrowserWindowId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameProxy::DispatchOnConnect(
    const ::extensions::PortId& in_port_id, ::extensions::mojom::ChannelType in_channel_type, const std::string& in_channel_name, ::extensions::mojom::TabConnectionInfoPtr in_tab_info, ::extensions::mojom::ExternalConnectionInfoPtr in_external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> in_port_host, DispatchOnConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrame::DispatchOnConnect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_type"), in_channel_type,
                        "<value of type ::extensions::mojom::ChannelType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_name"), in_channel_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_info"), in_tab_info,
                        "<value of type ::extensions::mojom::TabConnectionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("external_connection_info"), in_external_connection_info,
                        "<value of type ::extensions::mojom::ExternalConnectionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kDispatchOnConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_DispatchOnConnect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in LocalFrame.DispatchOnConnect request");

  
  mojo::internal::Serialize<::extensions::mojom::ChannelType>(
    in_channel_type,
    &params->channel_type);
  mojo::internal::MessageFragment<
      typename decltype(params->channel_name)::BaseType> channel_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_channel_name,
    channel_name_fragment);

  params->channel_name.Set(
      channel_name_fragment.is_null() ? nullptr : channel_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->channel_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null channel_name in LocalFrame.DispatchOnConnect request");
  mojo::internal::MessageFragment<
      typename decltype(params->tab_info)::BaseType> tab_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::TabConnectionInfoDataView>(
    in_tab_info,
    tab_info_fragment);

  params->tab_info.Set(
      tab_info_fragment.is_null() ? nullptr : tab_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_info in LocalFrame.DispatchOnConnect request");
  mojo::internal::MessageFragment<
      typename decltype(params->external_connection_info)::BaseType> external_connection_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExternalConnectionInfoDataView>(
    in_external_connection_info,
    external_connection_info_fragment);

  params->external_connection_info.Set(
      external_connection_info_fragment.is_null() ? nullptr : external_connection_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->external_connection_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null external_connection_info in LocalFrame.DispatchOnConnect request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedRequestDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in LocalFrame.DispatchOnConnect request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedPtrInfoDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in LocalFrame.DispatchOnConnect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DispatchOnConnect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrame_DispatchOnConnect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LocalFrame_ExecuteCode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::ExecuteCodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_ExecuteCode_ProxyToResponder> proxy(
        new LocalFrame_ExecuteCode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_ExecuteCode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_ExecuteCode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_ExecuteCode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::ExecuteCodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_error, const ::GURL& in_url, std::optional<::base::Value> in_result);
};

bool LocalFrame_ExecuteCode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_ExecuteCode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_ExecuteCode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.6
  bool success = true;
  std::string p_error{};
  ::GURL p_url{};
  std::optional<::base::Value> p_result{};
  LocalFrame_ExecuteCode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_url), 
std::move(p_result));
  }
  return true;
}

void LocalFrame_ExecuteCode_ProxyToResponder::Run(
    const std::string& in_error, const ::GURL& in_url, std::optional<::base::Value> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::LocalFrame::ExecuteCode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type std::optional<::base::Value>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kExecuteCode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_ExecuteCode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in ");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("ExecuteCode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrame_DispatchOnConnect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrame::DispatchOnConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrame_DispatchOnConnect_ProxyToResponder> proxy(
        new LocalFrame_DispatchOnConnect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrame_DispatchOnConnect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrame_DispatchOnConnect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrame_DispatchOnConnect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrame::DispatchOnConnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool LocalFrame_DispatchOnConnect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrame_DispatchOnConnect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrame_DispatchOnConnect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrame.9
  bool success = true;
  bool p_success{};
  LocalFrame_DispatchOnConnect_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrame::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void LocalFrame_DispatchOnConnect_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::LocalFrame::DispatchOnConnect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrame::kDispatchOnConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrame_DispatchOnConnect_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrame::Name_);
  message.set_method_name("DispatchOnConnect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameStubDispatch::Accept(
    LocalFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LocalFrame>(message->header()->name)) {
    case messages::LocalFrame::kSetFrameName: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SetFrameName_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetFrameName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.0
      bool success = true;
      std::string p_frame_name{};
      LocalFrame_SetFrameName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameName(&p_frame_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameName(        
        std::move(p_frame_name));
      return true;
    }
    case messages::LocalFrame::kSetSpatialNavigationEnabled: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.1
      bool success = true;
      bool p_spatial_nav_enabled{};
      LocalFrame_SetSpatialNavigationEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_spatial_nav_enabled = input_data_view.spatial_nav_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSpatialNavigationEnabled(        
        std::move(p_spatial_nav_enabled));
      return true;
    }
    case messages::LocalFrame::kSetTabId: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_SetTabId_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_SetTabId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.2
      bool success = true;
      int32_t p_tab_id{};
      LocalFrame_SetTabId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTabId(        
        std::move(p_tab_id));
      return true;
    }
    case messages::LocalFrame::kAppWindowClosed: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_AppWindowClosed_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_AppWindowClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.3
      bool success = true;
      bool p_send_onclosed{};
      LocalFrame_AppWindowClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_send_onclosed = input_data_view.send_onclosed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AppWindowClosed(        
        std::move(p_send_onclosed));
      return true;
    }
    case messages::LocalFrame::kNotifyRenderViewType: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_NotifyRenderViewType_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_NotifyRenderViewType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.4
      bool success = true;
      ::extensions::mojom::ViewType p_view_type{};
      LocalFrame_NotifyRenderViewType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViewType(&p_view_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyRenderViewType(        
        std::move(p_view_type));
      return true;
    }
    case messages::LocalFrame::kMessageInvoke: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_MessageInvoke_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_MessageInvoke_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.5
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      std::string p_module_name{};
      std::string p_function_name{};
      ::base::Value::List p_args{};
      LocalFrame_MessageInvoke_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadFunctionName(&p_function_name))
        success = false;
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MessageInvoke(        
        std::move(p_extension_id), 
        std::move(p_module_name), 
        std::move(p_function_name), 
        std::move(p_args));
      return true;
    }
    case messages::LocalFrame::kExecuteCode: {
      break;
    }
    case messages::LocalFrame::kExecuteDeclarativeScript: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_ExecuteDeclarativeScript_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_ExecuteDeclarativeScript_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.7
      bool success = true;
      int32_t p_tab_id{};
      ::extensions::ExtensionId p_extension_id{};
      std::string p_script_id{};
      ::GURL p_url{};
      LocalFrame_ExecuteDeclarativeScript_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadScriptId(&p_script_id))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteDeclarativeScript(        
        std::move(p_tab_id), 
        std::move(p_extension_id), 
        std::move(p_script_id), 
        std::move(p_url));
      return true;
    }
    case messages::LocalFrame::kUpdateBrowserWindowId: {
      DCHECK(message->is_serialized());
      internal::LocalFrame_UpdateBrowserWindowId_Params_Data* params =
          reinterpret_cast<internal::LocalFrame_UpdateBrowserWindowId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrame.8
      bool success = true;
      int32_t p_window_id{};
      LocalFrame_UpdateBrowserWindowId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_window_id = input_data_view.window_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateBrowserWindowId(        
        std::move(p_window_id));
      return true;
    }
    case messages::LocalFrame::kDispatchOnConnect: {
      break;
    }
  }
  return false;
}

// static
bool LocalFrameStubDispatch::AcceptWithResponder(
    LocalFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LocalFrame>(message->header()->name)) {
    case messages::LocalFrame::kSetFrameName: {
      break;
    }
    case messages::LocalFrame::kSetSpatialNavigationEnabled: {
      break;
    }
    case messages::LocalFrame::kSetTabId: {
      break;
    }
    case messages::LocalFrame::kAppWindowClosed: {
      break;
    }
    case messages::LocalFrame::kNotifyRenderViewType: {
      break;
    }
    case messages::LocalFrame::kMessageInvoke: {
      break;
    }
    case messages::LocalFrame::kExecuteCode: {
      internal::LocalFrame_ExecuteCode_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_ExecuteCode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.6
      bool success = true;
      ExecuteCodeParamsPtr p_param{};
      LocalFrame_ExecuteCode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParam(&p_param))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 6, false);
        return false;
      }
      auto callback =
          LocalFrame_ExecuteCode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteCode(        
        std::move(p_param), std::move(callback));
      return true;
    }
    case messages::LocalFrame::kExecuteDeclarativeScript: {
      break;
    }
    case messages::LocalFrame::kUpdateBrowserWindowId: {
      break;
    }
    case messages::LocalFrame::kDispatchOnConnect: {
      internal::LocalFrame_DispatchOnConnect_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrame_DispatchOnConnect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrame.9
      bool success = true;
      ::extensions::PortId p_port_id{};
      ::extensions::mojom::ChannelType p_channel_type{};
      std::string p_channel_name{};
      ::extensions::mojom::TabConnectionInfoPtr p_tab_info{};
      ::extensions::mojom::ExternalConnectionInfoPtr p_external_connection_info{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> p_port_host{};
      LocalFrame_DispatchOnConnect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success && !input_data_view.ReadChannelType(&p_channel_type))
        success = false;
      if (success && !input_data_view.ReadChannelName(&p_channel_name))
        success = false;
      if (success && !input_data_view.ReadTabInfo(&p_tab_info))
        success = false;
      if (success && !input_data_view.ReadExternalConnectionInfo(&p_external_connection_info))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrame::Name_, 9, false);
        return false;
      }
      auto callback =
          LocalFrame_DispatchOnConnect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchOnConnect(        
        std::move(p_port_id), 
        std::move(p_channel_type), 
        std::move(p_channel_name), 
        std::move(p_tab_info), 
        std::move(p_external_connection_info), 
        std::move(p_port), 
        std::move(p_port_host), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLocalFrameValidationInfo[] = {
    { &internal::LocalFrame_SetFrameName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_SetSpatialNavigationEnabled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_SetTabId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_AppWindowClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_NotifyRenderViewType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_MessageInvoke_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_ExecuteCode_Params_Data::Validate,
     &internal::LocalFrame_ExecuteCode_ResponseParams_Data::Validate},
    { &internal::LocalFrame_ExecuteDeclarativeScript_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_UpdateBrowserWindowId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrame_DispatchOnConnect_Params_Data::Validate,
     &internal::LocalFrame_DispatchOnConnect_ResponseParams_Data::Validate},
};

bool LocalFrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::extensions::mojom::LocalFrame::Name_,
    kLocalFrameValidationInfo);
}

bool LocalFrameResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::extensions::mojom::LocalFrame::Name_,
    kLocalFrameValidationInfo);
}
// The declaration includes the definition on other builds.

LocalFrameHost::IPCStableHashFunction LocalFrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LocalFrameHost>(message.name())) {
    case messages::LocalFrameHost::kRequestScriptInjectionPermission: {
      return &LocalFrameHost::RequestScriptInjectionPermission_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kGetAppInstallState: {
      return &LocalFrameHost::GetAppInstallState_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kRequest: {
      return &LocalFrameHost::Request_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kResponseAck: {
      return &LocalFrameHost::ResponseAck_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kWatchedPageChange: {
      return &LocalFrameHost::WatchedPageChange_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDetailedConsoleMessageAdded: {
      return &LocalFrameHost::DetailedConsoleMessageAdded_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kContentScriptsExecuting: {
      return &LocalFrameHost::ContentScriptsExecuting_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kIncrementLazyKeepaliveCount: {
      return &LocalFrameHost::IncrementLazyKeepaliveCount_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kDecrementLazyKeepaliveCount: {
      return &LocalFrameHost::DecrementLazyKeepaliveCount_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kAppWindowReady: {
      return &LocalFrameHost::AppWindowReady_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kOpenChannelToExtension: {
      return &LocalFrameHost::OpenChannelToExtension_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kOpenChannelToNativeApp: {
      return &LocalFrameHost::OpenChannelToNativeApp_Sym::IPCStableHash;
    }
    case messages::LocalFrameHost::kOpenChannelToTab: {
      return &LocalFrameHost::OpenChannelToTab_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LocalFrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LocalFrameHost>(message.name())) {
      case messages::LocalFrameHost::kRequestScriptInjectionPermission:
            return "Receive extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission";
      case messages::LocalFrameHost::kGetAppInstallState:
            return "Receive extensions::mojom::LocalFrameHost::GetAppInstallState";
      case messages::LocalFrameHost::kRequest:
            return "Receive extensions::mojom::LocalFrameHost::Request";
      case messages::LocalFrameHost::kResponseAck:
            return "Receive extensions::mojom::LocalFrameHost::ResponseAck";
      case messages::LocalFrameHost::kWatchedPageChange:
            return "Receive extensions::mojom::LocalFrameHost::WatchedPageChange";
      case messages::LocalFrameHost::kDetailedConsoleMessageAdded:
            return "Receive extensions::mojom::LocalFrameHost::DetailedConsoleMessageAdded";
      case messages::LocalFrameHost::kContentScriptsExecuting:
            return "Receive extensions::mojom::LocalFrameHost::ContentScriptsExecuting";
      case messages::LocalFrameHost::kIncrementLazyKeepaliveCount:
            return "Receive extensions::mojom::LocalFrameHost::IncrementLazyKeepaliveCount";
      case messages::LocalFrameHost::kDecrementLazyKeepaliveCount:
            return "Receive extensions::mojom::LocalFrameHost::DecrementLazyKeepaliveCount";
      case messages::LocalFrameHost::kAppWindowReady:
            return "Receive extensions::mojom::LocalFrameHost::AppWindowReady";
      case messages::LocalFrameHost::kOpenChannelToExtension:
            return "Receive extensions::mojom::LocalFrameHost::OpenChannelToExtension";
      case messages::LocalFrameHost::kOpenChannelToNativeApp:
            return "Receive extensions::mojom::LocalFrameHost::OpenChannelToNativeApp";
      case messages::LocalFrameHost::kOpenChannelToTab:
            return "Receive extensions::mojom::LocalFrameHost::OpenChannelToTab";
    }
  } else {
    switch (static_cast<messages::LocalFrameHost>(message.name())) {
      case messages::LocalFrameHost::kRequestScriptInjectionPermission:
            return "Receive reply extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission";
      case messages::LocalFrameHost::kGetAppInstallState:
            return "Receive reply extensions::mojom::LocalFrameHost::GetAppInstallState";
      case messages::LocalFrameHost::kRequest:
            return "Receive reply extensions::mojom::LocalFrameHost::Request";
      case messages::LocalFrameHost::kResponseAck:
            return "Receive reply extensions::mojom::LocalFrameHost::ResponseAck";
      case messages::LocalFrameHost::kWatchedPageChange:
            return "Receive reply extensions::mojom::LocalFrameHost::WatchedPageChange";
      case messages::LocalFrameHost::kDetailedConsoleMessageAdded:
            return "Receive reply extensions::mojom::LocalFrameHost::DetailedConsoleMessageAdded";
      case messages::LocalFrameHost::kContentScriptsExecuting:
            return "Receive reply extensions::mojom::LocalFrameHost::ContentScriptsExecuting";
      case messages::LocalFrameHost::kIncrementLazyKeepaliveCount:
            return "Receive reply extensions::mojom::LocalFrameHost::IncrementLazyKeepaliveCount";
      case messages::LocalFrameHost::kDecrementLazyKeepaliveCount:
            return "Receive reply extensions::mojom::LocalFrameHost::DecrementLazyKeepaliveCount";
      case messages::LocalFrameHost::kAppWindowReady:
            return "Receive reply extensions::mojom::LocalFrameHost::AppWindowReady";
      case messages::LocalFrameHost::kOpenChannelToExtension:
            return "Receive reply extensions::mojom::LocalFrameHost::OpenChannelToExtension";
      case messages::LocalFrameHost::kOpenChannelToNativeApp:
            return "Receive reply extensions::mojom::LocalFrameHost::OpenChannelToNativeApp";
      case messages::LocalFrameHost::kOpenChannelToTab:
            return "Receive reply extensions::mojom::LocalFrameHost::OpenChannelToTab";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LocalFrameHost::RequestScriptInjectionPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8fa066a;  // IPCStableHash for extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::GetAppInstallState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6d38b21b;  // IPCStableHash for extensions::mojom::LocalFrameHost::GetAppInstallState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::Request_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf7cd38e;  // IPCStableHash for extensions::mojom::LocalFrameHost::Request
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ResponseAck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72d06efd;  // IPCStableHash for extensions::mojom::LocalFrameHost::ResponseAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::WatchedPageChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d04abe2;  // IPCStableHash for extensions::mojom::LocalFrameHost::WatchedPageChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DetailedConsoleMessageAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ae8f1a4;  // IPCStableHash for extensions::mojom::LocalFrameHost::DetailedConsoleMessageAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::ContentScriptsExecuting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79dd399c;  // IPCStableHash for extensions::mojom::LocalFrameHost::ContentScriptsExecuting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::IncrementLazyKeepaliveCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d8c3aa0;  // IPCStableHash for extensions::mojom::LocalFrameHost::IncrementLazyKeepaliveCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::DecrementLazyKeepaliveCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x235393f1;  // IPCStableHash for extensions::mojom::LocalFrameHost::DecrementLazyKeepaliveCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::AppWindowReady_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e4e2a51;  // IPCStableHash for extensions::mojom::LocalFrameHost::AppWindowReady
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::OpenChannelToExtension_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8d40be2;  // IPCStableHash for extensions::mojom::LocalFrameHost::OpenChannelToExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::OpenChannelToNativeApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5bdfb2c;  // IPCStableHash for extensions::mojom::LocalFrameHost::OpenChannelToNativeApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LocalFrameHost::OpenChannelToTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18b39c69;  // IPCStableHash for extensions::mojom::LocalFrameHost::OpenChannelToTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback(
      LocalFrameHost::RequestScriptInjectionPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback(const LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback&) = delete;
  LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback& operator=(const LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RequestScriptInjectionPermissionCallback callback_;
};

class LocalFrameHost_GetAppInstallState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_GetAppInstallState_ForwardToCallback(
      LocalFrameHost::GetAppInstallStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_GetAppInstallState_ForwardToCallback(const LocalFrameHost_GetAppInstallState_ForwardToCallback&) = delete;
  LocalFrameHost_GetAppInstallState_ForwardToCallback& operator=(const LocalFrameHost_GetAppInstallState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::GetAppInstallStateCallback callback_;
};

class LocalFrameHost_Request_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LocalFrameHost_Request_ForwardToCallback(
      LocalFrameHost::RequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  LocalFrameHost_Request_ForwardToCallback(const LocalFrameHost_Request_ForwardToCallback&) = delete;
  LocalFrameHost_Request_ForwardToCallback& operator=(const LocalFrameHost_Request_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LocalFrameHost::RequestCallback callback_;
};

LocalFrameHostProxy::LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LocalFrameHostProxy::RequestScriptInjectionPermission(
    const ::extensions::ExtensionId& in_extension_id, ::extensions::mojom::InjectionType in_script_type, ::extensions::mojom::RunLocation in_run_location, RequestScriptInjectionPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const ::extensions::ExtensionId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_type"), in_script_type,
                        "<value of type ::extensions::mojom::InjectionType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("run_location"), in_run_location,
                        "<value of type ::extensions::mojom::RunLocation>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRequestScriptInjectionPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtensionIdDataView>(
    in_extension_id,
    extension_id_fragment);

  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id in LocalFrameHost.RequestScriptInjectionPermission request");

  
  mojo::internal::Serialize<::extensions::mojom::InjectionType>(
    in_script_type,
    &params->script_type);

  
  mojo::internal::Serialize<::extensions::mojom::RunLocation>(
    in_run_location,
    &params->run_location);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RequestScriptInjectionPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::GetAppInstallState(
    const ::GURL& in_url, GetAppInstallStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::GetAppInstallState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kGetAppInstallState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_GetAppInstallState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in LocalFrameHost.GetAppInstallState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GetAppInstallState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_GetAppInstallState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::Request(
    RequestParamsPtr in_params, RequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::Request", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type RequestParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRequest), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_Request_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::RequestParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in LocalFrameHost.Request request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Request");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LocalFrameHost_Request_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void LocalFrameHostProxy::ResponseAck(
    const ::base::Uuid& in_request_uuid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::ResponseAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_uuid"), in_request_uuid,
                        "<value of type const ::base::Uuid&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kResponseAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_ResponseAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_uuid)::BaseType> request_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UuidDataView>(
    in_request_uuid,
    request_uuid_fragment);

  params->request_uuid.Set(
      request_uuid_fragment.is_null() ? nullptr : request_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request_uuid in LocalFrameHost.ResponseAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ResponseAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::WatchedPageChange(
    const std::vector<std::string>& in_css_selectors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::WatchedPageChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("css_selectors"), in_css_selectors,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kWatchedPageChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_WatchedPageChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->css_selectors)::BaseType>
      css_selectors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& css_selectors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_css_selectors,
    css_selectors_fragment,
    &css_selectors_validate_params);

  params->css_selectors.Set(
      css_selectors_fragment.is_null() ? nullptr : css_selectors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->css_selectors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null css_selectors in LocalFrameHost.WatchedPageChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("WatchedPageChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DetailedConsoleMessageAdded(
    const ::std::u16string& in_message, const ::std::u16string& in_source, const std::vector<::extensions::StackFrame>& in_stack_trace, ::blink::mojom::ConsoleMessageLevel in_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::DetailedConsoleMessageAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stack_trace"), in_stack_trace,
                        "<value of type const std::vector<::extensions::StackFrame>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("level"), in_level,
                        "<value of type ::blink::mojom::ConsoleMessageLevel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDetailedConsoleMessageAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_DetailedConsoleMessageAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in LocalFrameHost.DetailedConsoleMessageAdded request");
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in LocalFrameHost.DetailedConsoleMessageAdded request");
  mojo::internal::MessageFragment<
      typename decltype(params->stack_trace)::BaseType>
      stack_trace_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& stack_trace_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>>(
    in_stack_trace,
    stack_trace_fragment,
    &stack_trace_validate_params);

  params->stack_trace.Set(
      stack_trace_fragment.is_null() ? nullptr : stack_trace_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stack_trace.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stack_trace in LocalFrameHost.DetailedConsoleMessageAdded request");

  
  mojo::internal::Serialize<::blink::mojom::ConsoleMessageLevel>(
    in_level,
    &params->level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DetailedConsoleMessageAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::ContentScriptsExecuting(
    const base::flat_map<std::string, std::vector<std::string>>& in_extension_id_to_scripts, const ::GURL& in_frame_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::ContentScriptsExecuting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id_to_scripts"), in_extension_id_to_scripts,
                        "<value of type const base::flat_map<std::string, std::vector<std::string>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_url"), in_frame_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kContentScriptsExecuting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_ContentScriptsExecuting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id_to_scripts)::BaseType>
      extension_id_to_scripts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& extension_id_to_scripts_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
    in_extension_id_to_scripts,
    extension_id_to_scripts_fragment,
    &extension_id_to_scripts_validate_params);

  params->extension_id_to_scripts.Set(
      extension_id_to_scripts_fragment.is_null() ? nullptr : extension_id_to_scripts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_id_to_scripts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_id_to_scripts in LocalFrameHost.ContentScriptsExecuting request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_url)::BaseType> frame_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_frame_url,
    frame_url_fragment);

  params->frame_url.Set(
      frame_url_fragment.is_null() ? nullptr : frame_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_url in LocalFrameHost.ContentScriptsExecuting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("ContentScriptsExecuting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::IncrementLazyKeepaliveCount(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mojom::LocalFrameHost::IncrementLazyKeepaliveCount");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kIncrementLazyKeepaliveCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_IncrementLazyKeepaliveCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("IncrementLazyKeepaliveCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::DecrementLazyKeepaliveCount(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mojom::LocalFrameHost::DecrementLazyKeepaliveCount");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kDecrementLazyKeepaliveCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_DecrementLazyKeepaliveCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("DecrementLazyKeepaliveCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::AppWindowReady(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mojom::LocalFrameHost::AppWindowReady");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kAppWindowReady), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_AppWindowReady_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("AppWindowReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::OpenChannelToExtension(
    ::extensions::mojom::ExternalConnectionInfoPtr in_info, ::extensions::mojom::ChannelType in_channel_type, const std::string& in_channel_name, const ::extensions::PortId& in_port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> in_port_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::OpenChannelToExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::extensions::mojom::ExternalConnectionInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_type"), in_channel_type,
                        "<value of type ::extensions::mojom::ChannelType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_name"), in_channel_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kOpenChannelToExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_OpenChannelToExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExternalConnectionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in LocalFrameHost.OpenChannelToExtension request");

  
  mojo::internal::Serialize<::extensions::mojom::ChannelType>(
    in_channel_type,
    &params->channel_type);
  mojo::internal::MessageFragment<
      typename decltype(params->channel_name)::BaseType> channel_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_channel_name,
    channel_name_fragment);

  params->channel_name.Set(
      channel_name_fragment.is_null() ? nullptr : channel_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->channel_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null channel_name in LocalFrameHost.OpenChannelToExtension request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in LocalFrameHost.OpenChannelToExtension request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedPtrInfoDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in LocalFrameHost.OpenChannelToExtension request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedRequestDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in LocalFrameHost.OpenChannelToExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("OpenChannelToExtension");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::OpenChannelToNativeApp(
    const std::string& in_native_app_name, const ::extensions::PortId& in_port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> in_port_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::OpenChannelToNativeApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_app_name"), in_native_app_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kOpenChannelToNativeApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_OpenChannelToNativeApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_app_name)::BaseType> native_app_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_native_app_name,
    native_app_name_fragment);

  params->native_app_name.Set(
      native_app_name_fragment.is_null() ? nullptr : native_app_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_app_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_app_name in LocalFrameHost.OpenChannelToNativeApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in LocalFrameHost.OpenChannelToNativeApp request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedPtrInfoDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in LocalFrameHost.OpenChannelToNativeApp request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedRequestDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in LocalFrameHost.OpenChannelToNativeApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("OpenChannelToNativeApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LocalFrameHostProxy::OpenChannelToTab(
    int32_t in_tab_id, int32_t in_frame_id, const std::optional<std::string>& in_document_id, ::extensions::mojom::ChannelType in_channel_type, const std::string& in_channel_name, const ::extensions::PortId& in_port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> in_port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> in_port_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::LocalFrameHost::OpenChannelToTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_id"), in_frame_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_id"), in_document_id,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_type"), in_channel_type,
                        "<value of type ::extensions::mojom::ChannelType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("channel_name"), in_channel_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_id"), in_port_id,
                        "<value of type const ::extensions::PortId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port_host"), in_port_host,
                        "<value of type ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kOpenChannelToTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_OpenChannelToTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->frame_id = in_frame_id;
  mojo::internal::MessageFragment<
      typename decltype(params->document_id)::BaseType> document_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_document_id,
    document_id_fragment);

  params->document_id.Set(
      document_id_fragment.is_null() ? nullptr : document_id_fragment.data());

  
  mojo::internal::Serialize<::extensions::mojom::ChannelType>(
    in_channel_type,
    &params->channel_type);
  mojo::internal::MessageFragment<
      typename decltype(params->channel_name)::BaseType> channel_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_channel_name,
    channel_name_fragment);

  params->channel_name.Set(
      channel_name_fragment.is_null() ? nullptr : channel_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->channel_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null channel_name in LocalFrameHost.OpenChannelToTab request");
  mojo::internal::MessageFragment<
      typename decltype(params->port_id)::BaseType> port_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::PortIdDataView>(
    in_port_id,
    port_id_fragment);

  params->port_id.Set(
      port_id_fragment.is_null() ? nullptr : port_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->port_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null port_id in LocalFrameHost.OpenChannelToTab request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortAssociatedPtrInfoDataView>(
    in_port,
    &params->port,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port in LocalFrameHost.OpenChannelToTab request");

  
  mojo::internal::Serialize<::extensions::mojom::MessagePortHostAssociatedRequestDataView>(
    in_port_host,
    &params->port_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->port_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid port_host in LocalFrameHost.OpenChannelToTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("OpenChannelToTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RequestScriptInjectionPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder> proxy(
        new LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RequestScriptInjectionPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_granted);
};

bool LocalFrameHost_RequestScriptInjectionPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.0
  bool success = true;
  bool p_granted{};
  LocalFrameHost_RequestScriptInjectionPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted = input_data_view.granted();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_granted));
  }
  return true;
}

void LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder::Run(
    bool in_granted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::LocalFrameHost::RequestScriptInjectionPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted"), in_granted,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRequestScriptInjectionPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->granted = in_granted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("RequestScriptInjectionPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_GetAppInstallState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::GetAppInstallStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_GetAppInstallState_ProxyToResponder> proxy(
        new LocalFrameHost_GetAppInstallState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_GetAppInstallState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_GetAppInstallState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_GetAppInstallState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::GetAppInstallStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_state);
};

bool LocalFrameHost_GetAppInstallState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.1
  bool success = true;
  std::string p_state{};
  LocalFrameHost_GetAppInstallState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void LocalFrameHost_GetAppInstallState_ProxyToResponder::Run(
    const std::string& in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::LocalFrameHost::GetAppInstallState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kGetAppInstallState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("GetAppInstallState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class LocalFrameHost_Request_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LocalFrameHost::RequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LocalFrameHost_Request_ProxyToResponder> proxy(
        new LocalFrameHost_Request_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LocalFrameHost_Request_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LocalFrameHost_Request_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LocalFrameHost_Request_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LocalFrameHost::RequestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::base::Value::List in_response_wrapper, const std::string& in_error, ::extensions::mojom::ExtraResponseDataPtr in_extra_data);
};

bool LocalFrameHost_Request_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LocalFrameHost_Request_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LocalFrameHost_Request_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LocalFrameHost.2
  bool success = true;
  bool p_success{};
  ::base::Value::List p_response_wrapper{};
  std::string p_error{};
  ::extensions::mojom::ExtraResponseDataPtr p_extra_data{};
  LocalFrameHost_Request_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResponseWrapper(&p_response_wrapper))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadExtraData(&p_extra_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LocalFrameHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_response_wrapper), 
std::move(p_error), 
std::move(p_extra_data));
  }
  return true;
}

void LocalFrameHost_Request_ProxyToResponder::Run(
    bool in_success, ::base::Value::List in_response_wrapper, const std::string& in_error, ::extensions::mojom::ExtraResponseDataPtr in_extra_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::LocalFrameHost::Request", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_wrapper"), in_response_wrapper,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extra_data"), in_extra_data,
                        "<value of type ::extensions::mojom::ExtraResponseDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LocalFrameHost::kRequest), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::LocalFrameHost_Request_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->response_wrapper)::BaseType> response_wrapper_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_response_wrapper,
    response_wrapper_fragment);

  params->response_wrapper.Set(
      response_wrapper_fragment.is_null() ? nullptr : response_wrapper_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_wrapper.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_wrapper in ");
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in ");
  mojo::internal::MessageFragment<
      typename decltype(params->extra_data)::BaseType> extra_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mojom::ExtraResponseDataDataView>(
    in_extra_data,
    extra_data_fragment);

  params->extra_data.Set(
      extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LocalFrameHost::Name_);
  message.set_method_name("Request");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LocalFrameHostStubDispatch::Accept(
    LocalFrameHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LocalFrameHost>(message->header()->name)) {
    case messages::LocalFrameHost::kRequestScriptInjectionPermission: {
      break;
    }
    case messages::LocalFrameHost::kGetAppInstallState: {
      break;
    }
    case messages::LocalFrameHost::kRequest: {
      break;
    }
    case messages::LocalFrameHost::kResponseAck: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ResponseAck_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ResponseAck_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.3
      bool success = true;
      ::base::Uuid p_request_uuid{};
      LocalFrameHost_ResponseAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestUuid(&p_request_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResponseAck(        
        std::move(p_request_uuid));
      return true;
    }
    case messages::LocalFrameHost::kWatchedPageChange: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_WatchedPageChange_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_WatchedPageChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.4
      bool success = true;
      std::vector<std::string> p_css_selectors{};
      LocalFrameHost_WatchedPageChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCssSelectors(&p_css_selectors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WatchedPageChange(        
        std::move(p_css_selectors));
      return true;
    }
    case messages::LocalFrameHost::kDetailedConsoleMessageAdded: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DetailedConsoleMessageAdded_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DetailedConsoleMessageAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.5
      bool success = true;
      ::std::u16string p_message{};
      ::std::u16string p_source{};
      std::vector<::extensions::StackFrame> p_stack_trace{};
      ::blink::mojom::ConsoleMessageLevel p_level{};
      LocalFrameHost_DetailedConsoleMessageAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadStackTrace(&p_stack_trace))
        success = false;
      if (success && !input_data_view.ReadLevel(&p_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetailedConsoleMessageAdded(        
        std::move(p_message), 
        std::move(p_source), 
        std::move(p_stack_trace), 
        std::move(p_level));
      return true;
    }
    case messages::LocalFrameHost::kContentScriptsExecuting: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_ContentScriptsExecuting_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_ContentScriptsExecuting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.6
      bool success = true;
      base::flat_map<std::string, std::vector<std::string>> p_extension_id_to_scripts{};
      ::GURL p_frame_url{};
      LocalFrameHost_ContentScriptsExecuting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionIdToScripts(&p_extension_id_to_scripts))
        success = false;
      if (success && !input_data_view.ReadFrameUrl(&p_frame_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContentScriptsExecuting(        
        std::move(p_extension_id_to_scripts), 
        std::move(p_frame_url));
      return true;
    }
    case messages::LocalFrameHost::kIncrementLazyKeepaliveCount: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_IncrementLazyKeepaliveCount_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_IncrementLazyKeepaliveCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.7
      bool success = true;
      LocalFrameHost_IncrementLazyKeepaliveCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IncrementLazyKeepaliveCount(        );
      return true;
    }
    case messages::LocalFrameHost::kDecrementLazyKeepaliveCount: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_DecrementLazyKeepaliveCount_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_DecrementLazyKeepaliveCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.8
      bool success = true;
      LocalFrameHost_DecrementLazyKeepaliveCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecrementLazyKeepaliveCount(        );
      return true;
    }
    case messages::LocalFrameHost::kAppWindowReady: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_AppWindowReady_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_AppWindowReady_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.9
      bool success = true;
      LocalFrameHost_AppWindowReady_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AppWindowReady(        );
      return true;
    }
    case messages::LocalFrameHost::kOpenChannelToExtension: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_OpenChannelToExtension_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_OpenChannelToExtension_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.10
      bool success = true;
      ::extensions::mojom::ExternalConnectionInfoPtr p_info{};
      ::extensions::mojom::ChannelType p_channel_type{};
      std::string p_channel_name{};
      ::extensions::PortId p_port_id{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> p_port_host{};
      LocalFrameHost_OpenChannelToExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadChannelType(&p_channel_type))
        success = false;
      if (success && !input_data_view.ReadChannelName(&p_channel_name))
        success = false;
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToExtension(        
        std::move(p_info), 
        std::move(p_channel_type), 
        std::move(p_channel_name), 
        std::move(p_port_id), 
        std::move(p_port), 
        std::move(p_port_host));
      return true;
    }
    case messages::LocalFrameHost::kOpenChannelToNativeApp: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_OpenChannelToNativeApp_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_OpenChannelToNativeApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.11
      bool success = true;
      std::string p_native_app_name{};
      ::extensions::PortId p_port_id{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> p_port_host{};
      LocalFrameHost_OpenChannelToNativeApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeAppName(&p_native_app_name))
        success = false;
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToNativeApp(        
        std::move(p_native_app_name), 
        std::move(p_port_id), 
        std::move(p_port), 
        std::move(p_port_host));
      return true;
    }
    case messages::LocalFrameHost::kOpenChannelToTab: {
      DCHECK(message->is_serialized());
      internal::LocalFrameHost_OpenChannelToTab_Params_Data* params =
          reinterpret_cast<internal::LocalFrameHost_OpenChannelToTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LocalFrameHost.12
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_frame_id{};
      std::optional<std::string> p_document_id{};
      ::extensions::mojom::ChannelType p_channel_type{};
      std::string p_channel_name{};
      ::extensions::PortId p_port_id{};
      ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> p_port{};
      ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> p_port_host{};
      LocalFrameHost_OpenChannelToTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_frame_id = input_data_view.frame_id();
      if (success && !input_data_view.ReadDocumentId(&p_document_id))
        success = false;
      if (success && !input_data_view.ReadChannelType(&p_channel_type))
        success = false;
      if (success && !input_data_view.ReadChannelName(&p_channel_name))
        success = false;
      if (success && !input_data_view.ReadPortId(&p_port_id))
        success = false;
      if (success) {
        p_port =
            input_data_view.TakePort<decltype(p_port)>();
      }
      if (success) {
        p_port_host =
            input_data_view.TakePortHost<decltype(p_port_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChannelToTab(        
        std::move(p_tab_id), 
        std::move(p_frame_id), 
        std::move(p_document_id), 
        std::move(p_channel_type), 
        std::move(p_channel_name), 
        std::move(p_port_id), 
        std::move(p_port), 
        std::move(p_port_host));
      return true;
    }
  }
  return false;
}

// static
bool LocalFrameHostStubDispatch::AcceptWithResponder(
    LocalFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LocalFrameHost>(message->header()->name)) {
    case messages::LocalFrameHost::kRequestScriptInjectionPermission: {
      internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.0
      bool success = true;
      ::extensions::ExtensionId p_extension_id{};
      ::extensions::mojom::InjectionType p_script_type{};
      ::extensions::mojom::RunLocation p_run_location{};
      LocalFrameHost_RequestScriptInjectionPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadScriptType(&p_script_type))
        success = false;
      if (success && !input_data_view.ReadRunLocation(&p_run_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 0, false);
        return false;
      }
      auto callback =
          LocalFrameHost_RequestScriptInjectionPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestScriptInjectionPermission(        
        std::move(p_extension_id), 
        std::move(p_script_type), 
        std::move(p_run_location), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kGetAppInstallState: {
      internal::LocalFrameHost_GetAppInstallState_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_GetAppInstallState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.1
      bool success = true;
      ::GURL p_url{};
      LocalFrameHost_GetAppInstallState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 1, false);
        return false;
      }
      auto callback =
          LocalFrameHost_GetAppInstallState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAppInstallState(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kRequest: {
      internal::LocalFrameHost_Request_Params_Data* params =
          reinterpret_cast<
              internal::LocalFrameHost_Request_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LocalFrameHost.2
      bool success = true;
      RequestParamsPtr p_params{};
      LocalFrameHost_Request_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LocalFrameHost::Name_, 2, false);
        return false;
      }
      auto callback =
          LocalFrameHost_Request_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Request(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::LocalFrameHost::kResponseAck: {
      break;
    }
    case messages::LocalFrameHost::kWatchedPageChange: {
      break;
    }
    case messages::LocalFrameHost::kDetailedConsoleMessageAdded: {
      break;
    }
    case messages::LocalFrameHost::kContentScriptsExecuting: {
      break;
    }
    case messages::LocalFrameHost::kIncrementLazyKeepaliveCount: {
      break;
    }
    case messages::LocalFrameHost::kDecrementLazyKeepaliveCount: {
      break;
    }
    case messages::LocalFrameHost::kAppWindowReady: {
      break;
    }
    case messages::LocalFrameHost::kOpenChannelToExtension: {
      break;
    }
    case messages::LocalFrameHost::kOpenChannelToNativeApp: {
      break;
    }
    case messages::LocalFrameHost::kOpenChannelToTab: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLocalFrameHostValidationInfo[] = {
    { &internal::LocalFrameHost_RequestScriptInjectionPermission_Params_Data::Validate,
     &internal::LocalFrameHost_RequestScriptInjectionPermission_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_GetAppInstallState_Params_Data::Validate,
     &internal::LocalFrameHost_GetAppInstallState_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_Request_Params_Data::Validate,
     &internal::LocalFrameHost_Request_ResponseParams_Data::Validate},
    { &internal::LocalFrameHost_ResponseAck_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_WatchedPageChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DetailedConsoleMessageAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_ContentScriptsExecuting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_IncrementLazyKeepaliveCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_DecrementLazyKeepaliveCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_AppWindowReady_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_OpenChannelToExtension_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_OpenChannelToNativeApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LocalFrameHost_OpenChannelToTab_Params_Data::Validate,
     nullptr /* no response */},
};

bool LocalFrameHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::extensions::mojom::LocalFrameHost::Name_,
    kLocalFrameHostValidationInfo);
}

bool LocalFrameHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::extensions::mojom::LocalFrameHost::Name_,
    kLocalFrameHostValidationInfo);
}


}  // extensions::mojom


namespace mojo {


// static
bool StructTraits<::extensions::mojom::ExecuteCodeParams::DataView, ::extensions::mojom::ExecuteCodeParamsPtr>::Read(
    ::extensions::mojom::ExecuteCodeParams::DataView input,
    ::extensions::mojom::ExecuteCodeParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::ExecuteCodeParamsPtr result(::extensions::mojom::ExecuteCodeParams::New());
  
      if (success && !input.ReadHostId(&result->host_id))
        success = false;
      if (success && !input.ReadInjection(&result->injection))
        success = false;
      if (success && !input.ReadWebviewSrc(&result->webview_src))
        success = false;
      if (success && !input.ReadMatchOriginAsFallbackBehavior(&result->match_origin_as_fallback_behavior))
        success = false;
      if (success && !input.ReadRunAt(&result->run_at))
        success = false;
      if (success)
        result->is_web_view = input.is_web_view();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mojom::RequestParams::DataView, ::extensions::mojom::RequestParamsPtr>::Read(
    ::extensions::mojom::RequestParams::DataView input,
    ::extensions::mojom::RequestParamsPtr* output) {
  bool success = true;
  ::extensions::mojom::RequestParamsPtr result(::extensions::mojom::RequestParams::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadArguments(&result->arguments))
        success = false;
      if (success && !input.ReadExtensionId(&result->extension_id))
        success = false;
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success && !input.ReadContextType(&result->context_type))
        success = false;
      if (success)
        result->request_id = input.request_id();
      if (success)
        result->has_callback = input.has_callback();
      if (success)
        result->user_gesture = input.user_gesture();
      if (success)
        result->worker_thread_id = input.worker_thread_id();
      if (success)
        result->service_worker_version_id = input.service_worker_version_id();
      if (success && !input.ReadJsCallstack(&result->js_callstack))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void LocalFrameInterceptorForTesting::SetFrameName(const std::string& frame_name) {
  GetForwardingInterface()->SetFrameName(
    std::move(frame_name)
    );
}
void LocalFrameInterceptorForTesting::SetSpatialNavigationEnabled(bool spatial_nav_enabled) {
  GetForwardingInterface()->SetSpatialNavigationEnabled(
    std::move(spatial_nav_enabled)
    );
}
void LocalFrameInterceptorForTesting::SetTabId(int32_t tab_id) {
  GetForwardingInterface()->SetTabId(
    std::move(tab_id)
    );
}
void LocalFrameInterceptorForTesting::AppWindowClosed(bool send_onclosed) {
  GetForwardingInterface()->AppWindowClosed(
    std::move(send_onclosed)
    );
}
void LocalFrameInterceptorForTesting::NotifyRenderViewType(::extensions::mojom::ViewType view_type) {
  GetForwardingInterface()->NotifyRenderViewType(
    std::move(view_type)
    );
}
void LocalFrameInterceptorForTesting::MessageInvoke(const ::extensions::ExtensionId& extension_id, const std::string& module_name, const std::string& function_name, ::base::Value::List args) {
  GetForwardingInterface()->MessageInvoke(
    std::move(extension_id)
    , 
    std::move(module_name)
    , 
    std::move(function_name)
    , 
    std::move(args)
    );
}
void LocalFrameInterceptorForTesting::ExecuteCode(ExecuteCodeParamsPtr param, ExecuteCodeCallback callback) {
  GetForwardingInterface()->ExecuteCode(
    std::move(param)
    , std::move(callback));
}
void LocalFrameInterceptorForTesting::ExecuteDeclarativeScript(int32_t tab_id, const ::extensions::ExtensionId& extension_id, const std::string& script_id, const ::GURL& url) {
  GetForwardingInterface()->ExecuteDeclarativeScript(
    std::move(tab_id)
    , 
    std::move(extension_id)
    , 
    std::move(script_id)
    , 
    std::move(url)
    );
}
void LocalFrameInterceptorForTesting::UpdateBrowserWindowId(int32_t window_id) {
  GetForwardingInterface()->UpdateBrowserWindowId(
    std::move(window_id)
    );
}
void LocalFrameInterceptorForTesting::DispatchOnConnect(const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, DispatchOnConnectCallback callback) {
  GetForwardingInterface()->DispatchOnConnect(
    std::move(port_id)
    , 
    std::move(channel_type)
    , 
    std::move(channel_name)
    , 
    std::move(tab_info)
    , 
    std::move(external_connection_info)
    , 
    std::move(port)
    , 
    std::move(port_host)
    , std::move(callback));
}
LocalFrameAsyncWaiter::LocalFrameAsyncWaiter(
    LocalFrame* proxy) : proxy_(proxy) {}

LocalFrameAsyncWaiter::~LocalFrameAsyncWaiter() = default;


void LocalFrameAsyncWaiter::ExecuteCode(
    ExecuteCodeParamsPtr param, std::string* out_error, ::GURL* out_url, std::optional<::base::Value>* out_result) {
  base::RunLoop loop;
  proxy_->ExecuteCode(
      std::move(param),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_error
,
             ::GURL* out_url
,
             std::optional<::base::Value>* out_result
,
             const std::string& error,
             const ::GURL& url,
             std::optional<::base::Value> result) {*out_error = std::move(error);*out_url = std::move(url);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_error,
          out_url,
          out_result));
  loop.Run();
}



void LocalFrameAsyncWaiter::DispatchOnConnect(
    const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host, bool* out_success) {
  base::RunLoop loop;
  proxy_->DispatchOnConnect(
      std::move(port_id),
      std::move(channel_type),
      std::move(channel_name),
      std::move(tab_info),
      std::move(external_connection_info),
      std::move(port),
      std::move(port_host),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool LocalFrameAsyncWaiter::DispatchOnConnect(
    const ::extensions::PortId& port_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, ::extensions::mojom::TabConnectionInfoPtr tab_info, ::extensions::mojom::ExternalConnectionInfoPtr external_connection_info, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePortHost> port_host) {
  bool async_wait_result;
  DispatchOnConnect(std::move(port_id),std::move(channel_type),std::move(channel_name),std::move(tab_info),std::move(external_connection_info),std::move(port),std::move(port_host),&async_wait_result);
  return async_wait_result;
}




void LocalFrameHostInterceptorForTesting::RequestScriptInjectionPermission(const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, RequestScriptInjectionPermissionCallback callback) {
  GetForwardingInterface()->RequestScriptInjectionPermission(
    std::move(extension_id)
    , 
    std::move(script_type)
    , 
    std::move(run_location)
    , std::move(callback));
}
void LocalFrameHostInterceptorForTesting::GetAppInstallState(const ::GURL& url, GetAppInstallStateCallback callback) {
  GetForwardingInterface()->GetAppInstallState(
    std::move(url)
    , std::move(callback));
}
void LocalFrameHostInterceptorForTesting::Request(RequestParamsPtr params, RequestCallback callback) {
  GetForwardingInterface()->Request(
    std::move(params)
    , std::move(callback));
}
void LocalFrameHostInterceptorForTesting::ResponseAck(const ::base::Uuid& request_uuid) {
  GetForwardingInterface()->ResponseAck(
    std::move(request_uuid)
    );
}
void LocalFrameHostInterceptorForTesting::WatchedPageChange(const std::vector<std::string>& css_selectors) {
  GetForwardingInterface()->WatchedPageChange(
    std::move(css_selectors)
    );
}
void LocalFrameHostInterceptorForTesting::DetailedConsoleMessageAdded(const ::std::u16string& message, const ::std::u16string& source, const std::vector<::extensions::StackFrame>& stack_trace, ::blink::mojom::ConsoleMessageLevel level) {
  GetForwardingInterface()->DetailedConsoleMessageAdded(
    std::move(message)
    , 
    std::move(source)
    , 
    std::move(stack_trace)
    , 
    std::move(level)
    );
}
void LocalFrameHostInterceptorForTesting::ContentScriptsExecuting(const base::flat_map<std::string, std::vector<std::string>>& extension_id_to_scripts, const ::GURL& frame_url) {
  GetForwardingInterface()->ContentScriptsExecuting(
    std::move(extension_id_to_scripts)
    , 
    std::move(frame_url)
    );
}
void LocalFrameHostInterceptorForTesting::IncrementLazyKeepaliveCount() {
  GetForwardingInterface()->IncrementLazyKeepaliveCount();
}
void LocalFrameHostInterceptorForTesting::DecrementLazyKeepaliveCount() {
  GetForwardingInterface()->DecrementLazyKeepaliveCount();
}
void LocalFrameHostInterceptorForTesting::AppWindowReady() {
  GetForwardingInterface()->AppWindowReady();
}
void LocalFrameHostInterceptorForTesting::OpenChannelToExtension(::extensions::mojom::ExternalConnectionInfoPtr info, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) {
  GetForwardingInterface()->OpenChannelToExtension(
    std::move(info)
    , 
    std::move(channel_type)
    , 
    std::move(channel_name)
    , 
    std::move(port_id)
    , 
    std::move(port)
    , 
    std::move(port_host)
    );
}
void LocalFrameHostInterceptorForTesting::OpenChannelToNativeApp(const std::string& native_app_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) {
  GetForwardingInterface()->OpenChannelToNativeApp(
    std::move(native_app_name)
    , 
    std::move(port_id)
    , 
    std::move(port)
    , 
    std::move(port_host)
    );
}
void LocalFrameHostInterceptorForTesting::OpenChannelToTab(int32_t tab_id, int32_t frame_id, const std::optional<std::string>& document_id, ::extensions::mojom::ChannelType channel_type, const std::string& channel_name, const ::extensions::PortId& port_id, ::mojo::PendingAssociatedRemote<::extensions::mojom::MessagePort> port, ::mojo::PendingAssociatedReceiver<::extensions::mojom::MessagePortHost> port_host) {
  GetForwardingInterface()->OpenChannelToTab(
    std::move(tab_id)
    , 
    std::move(frame_id)
    , 
    std::move(document_id)
    , 
    std::move(channel_type)
    , 
    std::move(channel_name)
    , 
    std::move(port_id)
    , 
    std::move(port)
    , 
    std::move(port_host)
    );
}
LocalFrameHostAsyncWaiter::LocalFrameHostAsyncWaiter(
    LocalFrameHost* proxy) : proxy_(proxy) {}

LocalFrameHostAsyncWaiter::~LocalFrameHostAsyncWaiter() = default;


void LocalFrameHostAsyncWaiter::RequestScriptInjectionPermission(
    const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location, bool* out_granted) {
  base::RunLoop loop;
  proxy_->RequestScriptInjectionPermission(
      std::move(extension_id),
      std::move(script_type),
      std::move(run_location),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_granted
,
             bool granted) {*out_granted = std::move(granted);
            loop->Quit();
          },
          &loop,
          out_granted));
  loop.Run();
}

bool LocalFrameHostAsyncWaiter::RequestScriptInjectionPermission(
    const ::extensions::ExtensionId& extension_id, ::extensions::mojom::InjectionType script_type, ::extensions::mojom::RunLocation run_location) {
  bool async_wait_result;
  RequestScriptInjectionPermission(std::move(extension_id),std::move(script_type),std::move(run_location),&async_wait_result);
  return async_wait_result;
}

void LocalFrameHostAsyncWaiter::GetAppInstallState(
    const ::GURL& url, std::string* out_state) {
  base::RunLoop loop;
  proxy_->GetAppInstallState(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_state
,
             const std::string& state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

std::string LocalFrameHostAsyncWaiter::GetAppInstallState(
    const ::GURL& url) {
  std::string async_wait_result;
  GetAppInstallState(std::move(url),&async_wait_result);
  return async_wait_result;
}

void LocalFrameHostAsyncWaiter::Request(
    RequestParamsPtr params, bool* out_success, ::base::Value::List* out_response_wrapper, std::string* out_error, ::extensions::mojom::ExtraResponseDataPtr* out_extra_data) {
  base::RunLoop loop;
  proxy_->Request(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::base::Value::List* out_response_wrapper
,
             std::string* out_error
,
             ::extensions::mojom::ExtraResponseDataPtr* out_extra_data
,
             bool success,
             ::base::Value::List response_wrapper,
             const std::string& error,
             ::extensions::mojom::ExtraResponseDataPtr extra_data) {*out_success = std::move(success);*out_response_wrapper = std::move(response_wrapper);*out_error = std::move(error);*out_extra_data = std::move(extra_data);
            loop->Quit();
          },
          &loop,
          out_success,
          out_response_wrapper,
          out_error,
          out_extra_data));
  loop.Run();
}








}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif