// extensions/common/mojom/automation_registry.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/automation_registry.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/automation_registry.mojom-params-data.h"
#include "extensions/common/mojom/automation_registry.mojom-shared-message-ids.h"

#include "extensions/common/mojom/automation_registry.mojom-import-headers.h"
#include "extensions/common/mojom/automation_registry.mojom-test-utils.h"


namespace extensions::mojom {
// The declaration includes the definition on other builds.

RendererAutomationRegistry::IPCStableHashFunction RendererAutomationRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererAutomationRegistry>(message.name())) {
    case messages::RendererAutomationRegistry::kBindAutomation: {
      return &RendererAutomationRegistry::BindAutomation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererAutomationRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererAutomationRegistry>(message.name())) {
      case messages::RendererAutomationRegistry::kBindAutomation:
            return "Receive extensions::mojom::RendererAutomationRegistry::BindAutomation";
    }
  } else {
    switch (static_cast<messages::RendererAutomationRegistry>(message.name())) {
      case messages::RendererAutomationRegistry::kBindAutomation:
            return "Receive reply extensions::mojom::RendererAutomationRegistry::BindAutomation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererAutomationRegistry::BindAutomation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e8b58d8;  // IPCStableHash for extensions::mojom::RendererAutomationRegistry::BindAutomation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RendererAutomationRegistryProxy::RendererAutomationRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererAutomationRegistryProxy::BindAutomation(
    ::mojo::PendingAssociatedRemote<::ax::mojom::Automation> in_automation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::RendererAutomationRegistry::BindAutomation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("automation"), in_automation,
                        "<value of type ::mojo::PendingAssociatedRemote<::ax::mojom::Automation>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererAutomationRegistry::kBindAutomation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererAutomationRegistry_BindAutomation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ax::mojom::AutomationAssociatedPtrInfoDataView>(
    in_automation,
    &params->automation,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->automation)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid automation in RendererAutomationRegistry.BindAutomation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAutomationRegistry::Name_);
  message.set_method_name("BindAutomation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RendererAutomationRegistryStubDispatch::Accept(
    RendererAutomationRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererAutomationRegistry>(message->header()->name)) {
    case messages::RendererAutomationRegistry::kBindAutomation: {
      DCHECK(message->is_serialized());
      internal::RendererAutomationRegistry_BindAutomation_Params_Data* params =
          reinterpret_cast<internal::RendererAutomationRegistry_BindAutomation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RendererAutomationRegistry.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<::ax::mojom::Automation> p_automation{};
      RendererAutomationRegistry_BindAutomation_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_automation =
            input_data_view.TakeAutomation<decltype(p_automation)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererAutomationRegistry::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAutomation(        
        std::move(p_automation));
      return true;
    }
  }
  return false;
}

// static
bool RendererAutomationRegistryStubDispatch::AcceptWithResponder(
    RendererAutomationRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererAutomationRegistry>(message->header()->name)) {
    case messages::RendererAutomationRegistry::kBindAutomation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererAutomationRegistryValidationInfo[] = {
    { &internal::RendererAutomationRegistry_BindAutomation_Params_Data::Validate,
     nullptr /* no response */},
};

bool RendererAutomationRegistryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::extensions::mojom::RendererAutomationRegistry::Name_,
    kRendererAutomationRegistryValidationInfo);
}



}  // extensions::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void RendererAutomationRegistryInterceptorForTesting::BindAutomation(::mojo::PendingAssociatedRemote<::ax::mojom::Automation> automation) {
  GetForwardingInterface()->BindAutomation(
    std::move(automation)
    );
}
RendererAutomationRegistryAsyncWaiter::RendererAutomationRegistryAsyncWaiter(
    RendererAutomationRegistry* proxy) : proxy_(proxy) {}

RendererAutomationRegistryAsyncWaiter::~RendererAutomationRegistryAsyncWaiter() = default;







}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif