// extensions/common/mojom/app_window.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('extensions.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mojom.AppWindowPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mojom.AppWindow.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mojom.AppWindowInterface }
 */
extensions.mojom.AppWindowRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mojom.AppWindowPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mojom.AppWindowPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mojom.AppWindowPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } deemphasized
   */

  setVisuallyDeemphasized(
      deemphasized) {
    this.proxy.sendMessage(
        0,
        extensions.mojom.AppWindow_SetVisuallyDeemphasized_ParamsSpec.$,
        null,
        [
          deemphasized
        ],
        false);
  }

  
  /**
   * @param { !boolean } supportsDraggableRegions
   */

  setSupportsDraggableRegions(
      supportsDraggableRegions) {
    this.proxy.sendMessage(
        1,
        extensions.mojom.AppWindow_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        [
          supportsDraggableRegions
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AppWindow
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mojom.AppWindowReceiver = class {
  /**
   * @param {!extensions.mojom.AppWindowInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mojom.AppWindowRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mojom.AppWindowRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.AppWindowRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.AppWindow_SetVisuallyDeemphasized_ParamsSpec.$,
        null,
        impl.setVisuallyDeemphasized.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.AppWindow_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        impl.setSupportsDraggableRegions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mojom.AppWindow = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mojom.AppWindow";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mojom.AppWindowRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mojom.AppWindowRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AppWindow
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mojom.AppWindowCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mojom.AppWindowRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mojom.AppWindowRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setVisuallyDeemphasized =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mojom.AppWindow_SetVisuallyDeemphasized_ParamsSpec.$,
        null,
        this.setVisuallyDeemphasized.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSupportsDraggableRegions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mojom.AppWindow_SetSupportsDraggableRegions_ParamsSpec.$,
        null,
        this.setSupportsDraggableRegions.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.AppWindow_SetVisuallyDeemphasized_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mojom.AppWindow_SetSupportsDraggableRegions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mojom.AppWindow_SetVisuallyDeemphasized_ParamsSpec.$,
    'AppWindow_SetVisuallyDeemphasized_Params',
    [
      mojo.internal.StructField(
        'deemphasized', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.AppWindow_SetVisuallyDeemphasized_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.deemphasized;
  }
};



mojo.internal.Struct(
    extensions.mojom.AppWindow_SetSupportsDraggableRegions_ParamsSpec.$,
    'AppWindow_SetSupportsDraggableRegions_Params',
    [
      mojo.internal.StructField(
        'supportsDraggableRegions', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mojom.AppWindow_SetSupportsDraggableRegions_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.supportsDraggableRegions;
  }
};

