// extensions/common/api/mime_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/api/mime_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/api/mime_handler.mojom-params-data.h"
#include "extensions/common/api/mime_handler.mojom-shared-message-ids.h"

#include "extensions/common/api/mime_handler.mojom-import-headers.h"
#include "extensions/common/api/mime_handler.mojom-test-utils.h"


namespace extensions::mime_handler {
StreamInfo::StreamInfo()
    : mime_type(),
      original_url(),
      stream_url(),
      tab_id(),
      response_headers(),
      embedded() {}

StreamInfo::StreamInfo(
    const std::string& mime_type_in,
    const std::string& original_url_in,
    const std::string& stream_url_in,
    int32_t tab_id_in,
    const base::flat_map<std::string, std::string>& response_headers_in,
    bool embedded_in)
    : mime_type(std::move(mime_type_in)),
      original_url(std::move(original_url_in)),
      stream_url(std::move(stream_url_in)),
      tab_id(std::move(tab_id_in)),
      response_headers(std::move(response_headers_in)),
      embedded(std::move(embedded_in)) {}

StreamInfo::~StreamInfo() = default;

void StreamInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "original_url"), this->original_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_url"), this->stream_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response_headers"), this->response_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedded"), this->embedded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PdfPluginAttributes::PdfPluginAttributes()
    : background_color(),
      allow_javascript() {}

PdfPluginAttributes::PdfPluginAttributes(
    double background_color_in,
    bool allow_javascript_in)
    : background_color(std::move(background_color_in)),
      allow_javascript(std::move(allow_javascript_in)) {}

PdfPluginAttributes::~PdfPluginAttributes() = default;
size_t PdfPluginAttributes::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->background_color);
  seed = mojo::internal::Hash(seed, this->allow_javascript);
  return seed;
}

void PdfPluginAttributes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_javascript"), this->allow_javascript,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PdfPluginAttributes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MimeHandlerService::IPCStableHashFunction MimeHandlerService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MimeHandlerService>(message.name())) {
    case messages::MimeHandlerService::kGetStreamInfo: {
      return &MimeHandlerService::GetStreamInfo_Sym::IPCStableHash;
    }
    case messages::MimeHandlerService::kSetPdfPluginAttributes: {
      return &MimeHandlerService::SetPdfPluginAttributes_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MimeHandlerService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MimeHandlerService>(message.name())) {
      case messages::MimeHandlerService::kGetStreamInfo:
            return "Receive extensions::mime_handler::MimeHandlerService::GetStreamInfo";
      case messages::MimeHandlerService::kSetPdfPluginAttributes:
            return "Receive extensions::mime_handler::MimeHandlerService::SetPdfPluginAttributes";
    }
  } else {
    switch (static_cast<messages::MimeHandlerService>(message.name())) {
      case messages::MimeHandlerService::kGetStreamInfo:
            return "Receive reply extensions::mime_handler::MimeHandlerService::GetStreamInfo";
      case messages::MimeHandlerService::kSetPdfPluginAttributes:
            return "Receive reply extensions::mime_handler::MimeHandlerService::SetPdfPluginAttributes";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MimeHandlerService::GetStreamInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a07b051;  // IPCStableHash for extensions::mime_handler::MimeHandlerService::GetStreamInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MimeHandlerService::SetPdfPluginAttributes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2a9db586;  // IPCStableHash for extensions::mime_handler::MimeHandlerService::SetPdfPluginAttributes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MimeHandlerService_GetStreamInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MimeHandlerService_GetStreamInfo_ForwardToCallback(
      MimeHandlerService::GetStreamInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  MimeHandlerService_GetStreamInfo_ForwardToCallback(const MimeHandlerService_GetStreamInfo_ForwardToCallback&) = delete;
  MimeHandlerService_GetStreamInfo_ForwardToCallback& operator=(const MimeHandlerService_GetStreamInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MimeHandlerService::GetStreamInfoCallback callback_;
};

MimeHandlerServiceProxy::MimeHandlerServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MimeHandlerServiceProxy::GetStreamInfo(
    GetStreamInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send extensions::mime_handler::MimeHandlerService::GetStreamInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerService::kGetStreamInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::MimeHandlerService_GetStreamInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerService::Name_);
  message.set_method_name("GetStreamInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MimeHandlerService_GetStreamInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MimeHandlerServiceProxy::SetPdfPluginAttributes(
    PdfPluginAttributesPtr in_pdf_plugin_attributes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mime_handler::MimeHandlerService::SetPdfPluginAttributes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_plugin_attributes"), in_pdf_plugin_attributes,
                        "<value of type PdfPluginAttributesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerService::kSetPdfPluginAttributes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::MimeHandlerService_SetPdfPluginAttributes_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_plugin_attributes)::BaseType> pdf_plugin_attributes_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mime_handler::PdfPluginAttributesDataView>(
    in_pdf_plugin_attributes,
    pdf_plugin_attributes_fragment);

  params->pdf_plugin_attributes.Set(
      pdf_plugin_attributes_fragment.is_null() ? nullptr : pdf_plugin_attributes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pdf_plugin_attributes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pdf_plugin_attributes in MimeHandlerService.SetPdfPluginAttributes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerService::Name_);
  message.set_method_name("SetPdfPluginAttributes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class MimeHandlerService_GetStreamInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MimeHandlerService::GetStreamInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MimeHandlerService_GetStreamInfo_ProxyToResponder> proxy(
        new MimeHandlerService_GetStreamInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MimeHandlerService_GetStreamInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MimeHandlerService_GetStreamInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MimeHandlerService_GetStreamInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MimeHandlerService::GetStreamInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      StreamInfoPtr in_stream_info);
};

bool MimeHandlerService_GetStreamInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MimeHandlerService.0
  bool success = true;
  StreamInfoPtr p_stream_info{};
  MimeHandlerService_GetStreamInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStreamInfo(&p_stream_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MimeHandlerService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_stream_info));
  }
  return true;
}

void MimeHandlerService_GetStreamInfo_ProxyToResponder::Run(
    StreamInfoPtr in_stream_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mime_handler::MimeHandlerService::GetStreamInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_info"), in_stream_info,
                        "<value of type StreamInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeHandlerService::kGetStreamInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->stream_info)::BaseType> stream_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::extensions::mime_handler::StreamInfoDataView>(
    in_stream_info,
    stream_info_fragment);

  params->stream_info.Set(
      stream_info_fragment.is_null() ? nullptr : stream_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeHandlerService::Name_);
  message.set_method_name("GetStreamInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MimeHandlerServiceStubDispatch::Accept(
    MimeHandlerService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MimeHandlerService>(message->header()->name)) {
    case messages::MimeHandlerService::kGetStreamInfo: {
      break;
    }
    case messages::MimeHandlerService::kSetPdfPluginAttributes: {
      DCHECK(message->is_serialized());
      internal::MimeHandlerService_SetPdfPluginAttributes_Params_Data* params =
          reinterpret_cast<internal::MimeHandlerService_SetPdfPluginAttributes_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MimeHandlerService.1
      bool success = true;
      PdfPluginAttributesPtr p_pdf_plugin_attributes{};
      MimeHandlerService_SetPdfPluginAttributes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPdfPluginAttributes(&p_pdf_plugin_attributes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPdfPluginAttributes(        
        std::move(p_pdf_plugin_attributes));
      return true;
    }
  }
  return false;
}

// static
bool MimeHandlerServiceStubDispatch::AcceptWithResponder(
    MimeHandlerService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MimeHandlerService>(message->header()->name)) {
    case messages::MimeHandlerService::kGetStreamInfo: {
      internal::MimeHandlerService_GetStreamInfo_Params_Data* params =
          reinterpret_cast<
              internal::MimeHandlerService_GetStreamInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MimeHandlerService.0
      bool success = true;
      MimeHandlerService_GetStreamInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeHandlerService::Name_, 0, false);
        return false;
      }
      auto callback =
          MimeHandlerService_GetStreamInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStreamInfo(std::move(callback));
      return true;
    }
    case messages::MimeHandlerService::kSetPdfPluginAttributes: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMimeHandlerServiceValidationInfo[] = {
    { &internal::MimeHandlerService_GetStreamInfo_Params_Data::Validate,
     &internal::MimeHandlerService_GetStreamInfo_ResponseParams_Data::Validate},
    { &internal::MimeHandlerService_SetPdfPluginAttributes_Params_Data::Validate,
     nullptr /* no response */},
};

bool MimeHandlerServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::extensions::mime_handler::MimeHandlerService::Name_,
    kMimeHandlerServiceValidationInfo);
}

bool MimeHandlerServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::extensions::mime_handler::MimeHandlerService::Name_,
    kMimeHandlerServiceValidationInfo);
}
// The declaration includes the definition on other builds.

BeforeUnloadControl::IPCStableHashFunction BeforeUnloadControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BeforeUnloadControl>(message.name())) {
    case messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog: {
      return &BeforeUnloadControl::SetShowBeforeUnloadDialog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BeforeUnloadControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BeforeUnloadControl>(message.name())) {
      case messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog:
            return "Receive extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog";
    }
  } else {
    switch (static_cast<messages::BeforeUnloadControl>(message.name())) {
      case messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog:
            return "Receive reply extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BeforeUnloadControl::SetShowBeforeUnloadDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95502f45;  // IPCStableHash for extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback(
      BeforeUnloadControl::SetShowBeforeUnloadDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback(const BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback&) = delete;
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback& operator=(const BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BeforeUnloadControl::SetShowBeforeUnloadDialogCallback callback_;
};

BeforeUnloadControlProxy::BeforeUnloadControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BeforeUnloadControlProxy::SetShowBeforeUnloadDialog(
    bool in_show_dialog, SetShowBeforeUnloadDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show_dialog"), in_show_dialog,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data> params(
          message);
  params.Allocate();

  params->show_dialog = in_show_dialog;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BeforeUnloadControl::Name_);
  message.set_method_name("SetShowBeforeUnloadDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BeforeUnloadControl::SetShowBeforeUnloadDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder> proxy(
        new BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BeforeUnloadControl::SetShowBeforeUnloadDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BeforeUnloadControl_SetShowBeforeUnloadDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BeforeUnloadControl.0
  bool success = true;
  BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BeforeUnloadControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply extensions::mime_handler::BeforeUnloadControl::SetShowBeforeUnloadDialog");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mime_handler::internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BeforeUnloadControl::Name_);
  message.set_method_name("SetShowBeforeUnloadDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BeforeUnloadControlStubDispatch::Accept(
    BeforeUnloadControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BeforeUnloadControl>(message->header()->name)) {
    case messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog: {
      break;
    }
  }
  return false;
}

// static
bool BeforeUnloadControlStubDispatch::AcceptWithResponder(
    BeforeUnloadControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BeforeUnloadControl>(message->header()->name)) {
    case messages::BeforeUnloadControl::kSetShowBeforeUnloadDialog: {
      internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data* params =
          reinterpret_cast<
              internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BeforeUnloadControl.0
      bool success = true;
      bool p_show_dialog{};
      BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_show_dialog = input_data_view.show_dialog();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BeforeUnloadControl::Name_, 0, false);
        return false;
      }
      auto callback =
          BeforeUnloadControl_SetShowBeforeUnloadDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetShowBeforeUnloadDialog(        
        std::move(p_show_dialog), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBeforeUnloadControlValidationInfo[] = {
    { &internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_Params_Data::Validate,
     &internal::BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams_Data::Validate},
};

bool BeforeUnloadControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::extensions::mime_handler::BeforeUnloadControl::Name_,
    kBeforeUnloadControlValidationInfo);
}

bool BeforeUnloadControlResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::extensions::mime_handler::BeforeUnloadControl::Name_,
    kBeforeUnloadControlValidationInfo);
}


}  // extensions::mime_handler


namespace mojo {


// static
bool StructTraits<::extensions::mime_handler::StreamInfo::DataView, ::extensions::mime_handler::StreamInfoPtr>::Read(
    ::extensions::mime_handler::StreamInfo::DataView input,
    ::extensions::mime_handler::StreamInfoPtr* output) {
  bool success = true;
  ::extensions::mime_handler::StreamInfoPtr result(::extensions::mime_handler::StreamInfo::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadOriginalUrl(&result->original_url))
        success = false;
      if (success && !input.ReadStreamUrl(&result->stream_url))
        success = false;
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadResponseHeaders(&result->response_headers))
        success = false;
      if (success)
        result->embedded = input.embedded();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::extensions::mime_handler::PdfPluginAttributes::DataView, ::extensions::mime_handler::PdfPluginAttributesPtr>::Read(
    ::extensions::mime_handler::PdfPluginAttributes::DataView input,
    ::extensions::mime_handler::PdfPluginAttributesPtr* output) {
  bool success = true;
  ::extensions::mime_handler::PdfPluginAttributesPtr result(::extensions::mime_handler::PdfPluginAttributes::New());
  
      if (success)
        result->background_color = input.background_color();
      if (success)
        result->allow_javascript = input.allow_javascript();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mime_handler {


void MimeHandlerServiceInterceptorForTesting::GetStreamInfo(GetStreamInfoCallback callback) {
  GetForwardingInterface()->GetStreamInfo(std::move(callback));
}
void MimeHandlerServiceInterceptorForTesting::SetPdfPluginAttributes(PdfPluginAttributesPtr pdf_plugin_attributes) {
  GetForwardingInterface()->SetPdfPluginAttributes(
    std::move(pdf_plugin_attributes)
    );
}
MimeHandlerServiceAsyncWaiter::MimeHandlerServiceAsyncWaiter(
    MimeHandlerService* proxy) : proxy_(proxy) {}

MimeHandlerServiceAsyncWaiter::~MimeHandlerServiceAsyncWaiter() = default;


void MimeHandlerServiceAsyncWaiter::GetStreamInfo(
    StreamInfoPtr* out_stream_info) {
  base::RunLoop loop;
  proxy_->GetStreamInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             StreamInfoPtr* out_stream_info
,
             StreamInfoPtr stream_info) {*out_stream_info = std::move(stream_info);
            loop->Quit();
          },
          &loop,
          out_stream_info));
  loop.Run();
}

StreamInfoPtr MimeHandlerServiceAsyncWaiter::GetStreamInfo(
    ) {
  StreamInfoPtr async_wait_result;
  GetStreamInfo(&async_wait_result);
  return async_wait_result;
}




void BeforeUnloadControlInterceptorForTesting::SetShowBeforeUnloadDialog(bool show_dialog, SetShowBeforeUnloadDialogCallback callback) {
  GetForwardingInterface()->SetShowBeforeUnloadDialog(
    std::move(show_dialog)
    , std::move(callback));
}
BeforeUnloadControlAsyncWaiter::BeforeUnloadControlAsyncWaiter(
    BeforeUnloadControl* proxy) : proxy_(proxy) {}

BeforeUnloadControlAsyncWaiter::~BeforeUnloadControlAsyncWaiter() = default;


void BeforeUnloadControlAsyncWaiter::SetShowBeforeUnloadDialog(
    bool show_dialog) {
  base::RunLoop loop;
  proxy_->SetShowBeforeUnloadDialog(
      std::move(show_dialog),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // extensions::mime_handler


#if defined(__clang__)
#pragma clang diagnostic pop
#endif