// extensions/common/api/mime_handler.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('extensions.mimeHandler');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mimeHandler.MimeHandlerServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mimeHandler.MimeHandlerService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mimeHandler.MimeHandlerServiceInterface }
 */
extensions.mimeHandler.MimeHandlerServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mimeHandler.MimeHandlerServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mimeHandler.MimeHandlerServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mimeHandler.MimeHandlerServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        streamInfo: ?extensions.mimeHandler.StreamInfo,
   *  }>}
   */

  getStreamInfo() {
    return this.proxy.sendMessage(
        0,
        extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ParamsSpec.$,
        extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !extensions.mimeHandler.PdfPluginAttributes } pdfPluginAttributes
   */

  setPdfPluginAttributes(
      pdfPluginAttributes) {
    this.proxy.sendMessage(
        1,
        extensions.mimeHandler.MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
        null,
        [
          pdfPluginAttributes
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MimeHandlerService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mimeHandler.MimeHandlerServiceReceiver = class {
  /**
   * @param {!extensions.mimeHandler.MimeHandlerServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mimeHandler.MimeHandlerServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mimeHandler.MimeHandlerServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mimeHandler.MimeHandlerServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ParamsSpec.$,
        extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
        impl.getStreamInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        extensions.mimeHandler.MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
        null,
        impl.setPdfPluginAttributes.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mimeHandler.MimeHandlerService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mime_handler.MimeHandlerService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mimeHandler.MimeHandlerServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mimeHandler.MimeHandlerServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MimeHandlerService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mimeHandler.MimeHandlerServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mimeHandler.MimeHandlerServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mimeHandler.MimeHandlerServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStreamInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ParamsSpec.$,
        extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
        this.getStreamInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPdfPluginAttributes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        extensions.mimeHandler.MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
        null,
        this.setPdfPluginAttributes.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
extensions.mimeHandler.BeforeUnloadControlPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        extensions.mimeHandler.BeforeUnloadControl.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { extensions.mimeHandler.BeforeUnloadControlInterface }
 */
extensions.mimeHandler.BeforeUnloadControlRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!extensions.mimeHandler.BeforeUnloadControlPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          extensions.mimeHandler.BeforeUnloadControlPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!extensions.mimeHandler.BeforeUnloadControlPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } showDialog
   * @return {!Promise}
   */

  setShowBeforeUnloadDialog(
      showDialog) {
    return this.proxy.sendMessage(
        0,
        extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
        extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
        [
          showDialog
        ],
        false);
  }
};

/**
 * An object which receives request messages for the BeforeUnloadControl
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
extensions.mimeHandler.BeforeUnloadControlReceiver = class {
  /**
   * @param {!extensions.mimeHandler.BeforeUnloadControlInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!extensions.mimeHandler.BeforeUnloadControlRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        extensions.mimeHandler.BeforeUnloadControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mimeHandler.BeforeUnloadControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
        extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
        impl.setShowBeforeUnloadDialog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
extensions.mimeHandler.BeforeUnloadControl = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "extensions.mime_handler.BeforeUnloadControl";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!extensions.mimeHandler.BeforeUnloadControlRemote}
   * @export
   */
  static getRemote() {
    let remote = new extensions.mimeHandler.BeforeUnloadControlRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the BeforeUnloadControl
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
extensions.mimeHandler.BeforeUnloadControlCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      extensions.mimeHandler.BeforeUnloadControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!extensions.mimeHandler.BeforeUnloadControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setShowBeforeUnloadDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
        extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
        this.setShowBeforeUnloadDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.StreamInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.PdfPluginAttributesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.MimeHandlerService_SetPdfPluginAttributes_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    extensions.mimeHandler.StreamInfoSpec.$,
    'StreamInfo',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalUrl', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamUrl', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tabId', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'responseHeaders', 32,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'embedded', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
extensions.mimeHandler.StreamInfo = class {
  constructor() {
    /** @export { !string } */
    this.mimeType;
    /** @export { !string } */
    this.originalUrl;
    /** @export { !string } */
    this.streamUrl;
    /** @export { !number } */
    this.tabId;
    /** @export { !Object<!string, !string> } */
    this.responseHeaders;
    /** @export { !boolean } */
    this.embedded;
  }
};



mojo.internal.Struct(
    extensions.mimeHandler.PdfPluginAttributesSpec.$,
    'PdfPluginAttributes',
    [
      mojo.internal.StructField(
        'backgroundColor', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowJavascript', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
extensions.mimeHandler.PdfPluginAttributes = class {
  constructor() {
    /** @export { !number } */
    this.backgroundColor;
    /** @export { !boolean } */
    this.allowJavascript;
  }
};



mojo.internal.Struct(
    extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ParamsSpec.$,
    'MimeHandlerService_GetStreamInfo_Params',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mimeHandler.MimeHandlerService_GetStreamInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ResponseParamsSpec.$,
    'MimeHandlerService_GetStreamInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'streamInfo', 0,
        0,
        extensions.mimeHandler.StreamInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mimeHandler.MimeHandlerService_GetStreamInfo_ResponseParams = class {
  constructor() {
    /** @export { (extensions.mimeHandler.StreamInfo|undefined) } */
    this.streamInfo;
  }
};



mojo.internal.Struct(
    extensions.mimeHandler.MimeHandlerService_SetPdfPluginAttributes_ParamsSpec.$,
    'MimeHandlerService_SetPdfPluginAttributes_Params',
    [
      mojo.internal.StructField(
        'pdfPluginAttributes', 0,
        0,
        extensions.mimeHandler.PdfPluginAttributesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mimeHandler.MimeHandlerService_SetPdfPluginAttributes_Params = class {
  constructor() {
    /** @export { !extensions.mimeHandler.PdfPluginAttributes } */
    this.pdfPluginAttributes;
  }
};



mojo.internal.Struct(
    extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ParamsSpec.$,
    'BeforeUnloadControl_SetShowBeforeUnloadDialog_Params',
    [
      mojo.internal.StructField(
        'showDialog', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.showDialog;
  }
};



mojo.internal.Struct(
    extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParamsSpec.$,
    'BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
extensions.mimeHandler.BeforeUnloadControl_SetShowBeforeUnloadDialog_ResponseParams = class {
  constructor() {
  }
};

