// device/vr/public/mojom/vr_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/vr_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/vr_service.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* XRHandednessToStringHelper(XRHandedness value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRHandedness::NONE:
      return "NONE";
    case XRHandedness::LEFT:
      return "LEFT";
    case XRHandedness::RIGHT:
      return "RIGHT";
    default:
      return nullptr;
  }
}

std::string XRHandednessToString(XRHandedness value) {
  const char *str = XRHandednessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRHandedness value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRHandedness value) {
  return os << XRHandednessToString(value);
}

NOINLINE static const char* XRTargetRayModeToStringHelper(XRTargetRayMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRTargetRayMode::GAZING:
      return "GAZING";
    case XRTargetRayMode::POINTING:
      return "POINTING";
    case XRTargetRayMode::TAPPING:
      return "TAPPING";
    default:
      return nullptr;
  }
}

std::string XRTargetRayModeToString(XRTargetRayMode value) {
  const char *str = XRTargetRayModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRTargetRayMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRTargetRayMode value) {
  return os << XRTargetRayModeToString(value);
}

NOINLINE static const char* XRSessionFeatureRequestStatusToStringHelper(XRSessionFeatureRequestStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRSessionFeatureRequestStatus::kNotRequested:
      return "kNotRequested";
    case XRSessionFeatureRequestStatus::kRequired:
      return "kRequired";
    case XRSessionFeatureRequestStatus::kOptionalAccepted:
      return "kOptionalAccepted";
    case XRSessionFeatureRequestStatus::kOptionalRejected:
      return "kOptionalRejected";
    default:
      return nullptr;
  }
}

std::string XRSessionFeatureRequestStatusToString(XRSessionFeatureRequestStatus value) {
  const char *str = XRSessionFeatureRequestStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRSessionFeatureRequestStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRSessionFeatureRequestStatus value) {
  return os << XRSessionFeatureRequestStatusToString(value);
}

NOINLINE static const char* XREnvironmentBlendModeToStringHelper(XREnvironmentBlendMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XREnvironmentBlendMode::kOpaque:
      return "kOpaque";
    case XREnvironmentBlendMode::kAlphaBlend:
      return "kAlphaBlend";
    case XREnvironmentBlendMode::kAdditive:
      return "kAdditive";
    default:
      return nullptr;
  }
}

std::string XREnvironmentBlendModeToString(XREnvironmentBlendMode value) {
  const char *str = XREnvironmentBlendModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XREnvironmentBlendMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XREnvironmentBlendMode value) {
  return os << XREnvironmentBlendModeToString(value);
}

NOINLINE static const char* XRInteractionModeToStringHelper(XRInteractionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRInteractionMode::kScreenSpace:
      return "kScreenSpace";
    case XRInteractionMode::kWorldSpace:
      return "kWorldSpace";
    default:
      return nullptr;
  }
}

std::string XRInteractionModeToString(XRInteractionMode value) {
  const char *str = XRInteractionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRInteractionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRInteractionMode value) {
  return os << XRInteractionModeToString(value);
}

NOINLINE static const char* XREyeToStringHelper(XREye value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XREye::kNone:
      return "kNone";
    case XREye::kLeft:
      return "kLeft";
    case XREye::kRight:
      return "kRight";
    default:
      return nullptr;
  }
}

std::string XREyeToString(XREye value) {
  const char *str = XREyeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XREye value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XREye value) {
  return os << XREyeToString(value);
}

NOINLINE static const char* XRPresentationTransportMethodToStringHelper(XRPresentationTransportMethod value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRPresentationTransportMethod::NONE:
      return "NONE";
    case XRPresentationTransportMethod::SUBMIT_AS_TEXTURE_HANDLE:
      return "SUBMIT_AS_TEXTURE_HANDLE";
    case XRPresentationTransportMethod::SUBMIT_AS_MAILBOX_HOLDER:
      return "SUBMIT_AS_MAILBOX_HOLDER";
    case XRPresentationTransportMethod::DRAW_INTO_TEXTURE_MAILBOX:
      return "DRAW_INTO_TEXTURE_MAILBOX";
    default:
      return nullptr;
  }
}

std::string XRPresentationTransportMethodToString(XRPresentationTransportMethod value) {
  const char *str = XRPresentationTransportMethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRPresentationTransportMethod value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRPresentationTransportMethod value) {
  return os << XRPresentationTransportMethodToString(value);
}

NOINLINE static const char* XRReferenceSpaceTypeToStringHelper(XRReferenceSpaceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRReferenceSpaceType::kViewer:
      return "kViewer";
    case XRReferenceSpaceType::kLocal:
      return "kLocal";
    case XRReferenceSpaceType::kLocalFloor:
      return "kLocalFloor";
    case XRReferenceSpaceType::kBoundedFloor:
      return "kBoundedFloor";
    case XRReferenceSpaceType::kUnbounded:
      return "kUnbounded";
    default:
      return nullptr;
  }
}

std::string XRReferenceSpaceTypeToString(XRReferenceSpaceType value) {
  const char *str = XRReferenceSpaceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRReferenceSpaceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRReferenceSpaceType value) {
  return os << XRReferenceSpaceTypeToString(value);
}

NOINLINE static const char* XRInputSourceSpaceTypeToStringHelper(XRInputSourceSpaceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRInputSourceSpaceType::kTargetRay:
      return "kTargetRay";
    case XRInputSourceSpaceType::kGrip:
      return "kGrip";
    default:
      return nullptr;
  }
}

std::string XRInputSourceSpaceTypeToString(XRInputSourceSpaceType value) {
  const char *str = XRInputSourceSpaceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRInputSourceSpaceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRInputSourceSpaceType value) {
  return os << XRInputSourceSpaceTypeToString(value);
}

NOINLINE static const char* XRPlaneOrientationToStringHelper(XRPlaneOrientation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRPlaneOrientation::UNKNOWN:
      return "UNKNOWN";
    case XRPlaneOrientation::HORIZONTAL:
      return "HORIZONTAL";
    case XRPlaneOrientation::VERTICAL:
      return "VERTICAL";
    default:
      return nullptr;
  }
}

std::string XRPlaneOrientationToString(XRPlaneOrientation value) {
  const char *str = XRPlaneOrientationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRPlaneOrientation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRPlaneOrientation value) {
  return os << XRPlaneOrientationToString(value);
}

NOINLINE static const char* XrCompatibleResultToStringHelper(XrCompatibleResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XrCompatibleResult::kAlreadyCompatible:
      return "kAlreadyCompatible";
    case XrCompatibleResult::kNoDeviceAvailable:
      return "kNoDeviceAvailable";
    case XrCompatibleResult::kWebXrFeaturePolicyBlocked:
      return "kWebXrFeaturePolicyBlocked";
    case XrCompatibleResult::kCompatibleAfterRestart:
      return "kCompatibleAfterRestart";
    case XrCompatibleResult::kNotCompatibleAfterRestart:
      return "kNotCompatibleAfterRestart";
    default:
      return nullptr;
  }
}

std::string XrCompatibleResultToString(XrCompatibleResult value) {
  const char *str = XrCompatibleResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XrCompatibleResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XrCompatibleResult value) {
  return os << XrCompatibleResultToString(value);
}

NOINLINE static const char* EntityTypeForHitTestToStringHelper(EntityTypeForHitTest value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case EntityTypeForHitTest::POINT:
      return "POINT";
    case EntityTypeForHitTest::PLANE:
      return "PLANE";
    default:
      return nullptr;
  }
}

std::string EntityTypeForHitTestToString(EntityTypeForHitTest value) {
  const char *str = EntityTypeForHitTestToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown EntityTypeForHitTest value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, EntityTypeForHitTest value) {
  return os << EntityTypeForHitTestToString(value);
}

NOINLINE static const char* XRVisibilityStateToStringHelper(XRVisibilityState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRVisibilityState::VISIBLE:
      return "VISIBLE";
    case XRVisibilityState::VISIBLE_BLURRED:
      return "VISIBLE_BLURRED";
    case XRVisibilityState::HIDDEN:
      return "HIDDEN";
    default:
      return nullptr;
  }
}

std::string XRVisibilityStateToString(XRVisibilityState value) {
  const char *str = XRVisibilityStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRVisibilityState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRVisibilityState value) {
  return os << XRVisibilityStateToString(value);
}

namespace internal {
// static
bool XRNativeOriginInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const XRNativeOriginInformation_Data* object = static_cast<const XRNativeOriginInformation_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case XRNativeOriginInformation_Tag::kInputSourceSpaceInfo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_input_source_space_info, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_input_source_space_info, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::kPlaneId: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_plane_id, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_plane_id, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::kAnchorId: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_anchor_id, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_anchor_id, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::kReferenceSpaceType: {


      if (!::device::mojom::internal::XRReferenceSpaceType_Data
            ::Validate(object->data.f_reference_space_type, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::kHandJointSpaceInfo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_hand_joint_space_info, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_hand_joint_space_info, validation_context))
        return false;
      return true;
    }
    case XRNativeOriginInformation_Tag::kImageIndex: {

      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in XRNativeOriginInformation");
      return false;
    }
  }
}
// static
bool XRDepthData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const XRDepthData_Data* object = static_cast<const XRDepthData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case XRDepthData_Tag::kDataStillValid: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data_still_valid, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data_still_valid, validation_context))
        return false;
      return true;
    }
    case XRDepthData_Tag::kUpdatedDepthData: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_updated_depth_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_updated_depth_data, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in XRDepthData");
      return false;
    }
  }
}
// static
bool RequestSessionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RequestSessionResult_Data* object = static_cast<const RequestSessionResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RequestSessionResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case RequestSessionResult_Tag::kFailureReason: {


      if (!::device::mojom::internal::RequestSessionError_Data
            ::Validate(object->data.f_failure_reason, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RequestSessionResult");
      return false;
    }
  }
}


// static
bool XRDepthConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRDepthConfig_Data* object =
      static_cast<const XRDepthConfig_Data*>(data);


  if (!::device::mojom::internal::XRDepthUsage_Data
        ::Validate(object->depth_usage, validation_context))
    return false;


  if (!::device::mojom::internal::XRDepthDataFormat_Data
        ::Validate(object->depth_data_format, validation_context))
    return false;


  if (!::device::mojom::internal::XRDepthType_Data
        ::Validate(object->depth_type_$value, validation_context))
    return false;

  return true;
}

XRDepthConfig_Data::XRDepthConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionDeviceConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSessionDeviceConfig_Data* object =
      static_cast<const XRSessionDeviceConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->views, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& views_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->views, validation_context,
                                         &views_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->depth_configuration, validation_context))
    return false;

  return true;
}

XRSessionDeviceConfig_Data::XRSessionDeviceConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSession_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSession_Data* object =
      static_cast<const XRSession_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_provider,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->submit_frame_sink, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_features, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& enabled_features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->enabled_features, validation_context,
                                         &enabled_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_config, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_config, validation_context))
    return false;


  if (!::device::mojom::internal::XREnvironmentBlendMode_Data
        ::Validate(object->enviroment_blend_mode, validation_context))
    return false;


  if (!::device::mojom::internal::XRInteractionMode_Data
        ::Validate(object->interaction_mode, validation_context))
    return false;

  return true;
}

XRSession_Data::XRSession_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationConnection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationConnection_Data* object =
      static_cast<const XRPresentationConnection_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->provider,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transport_options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transport_options, validation_context))
    return false;

  return true;
}

XRPresentationConnection_Data::XRPresentationConnection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceDescription_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRInputSourceDescription_Data* object =
      static_cast<const XRInputSourceDescription_Data*>(data);


  if (!::device::mojom::internal::XRTargetRayMode_Data
        ::Validate(object->target_ray_mode, validation_context))
    return false;


  if (!::device::mojom::internal::XRHandedness_Data
        ::Validate(object->handedness, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->input_from_pointer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profiles, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& profiles_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->profiles, validation_context,
                                         &profiles_validate_params)) {
    return false;
  }

  return true;
}

XRInputSourceDescription_Data::XRInputSourceDescription_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRInputSourceState_Data* object =
      static_cast<const XRInputSourceState_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_input, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->gamepad, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->overlay_pointer_position, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hand_tracking_data, validation_context))
    return false;

  return true;
}

XRInputSourceState_Data::XRInputSourceState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRFieldOfView_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRFieldOfView_Data* object =
      static_cast<const VRFieldOfView_Data*>(data);

  return true;
}

VRFieldOfView_Data::VRFieldOfView_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRPose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRPose_Data* object =
      static_cast<const VRPose_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

VRPose_Data::VRPose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Pose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Pose_Data* object =
      static_cast<const Pose_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->orientation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

Pose_Data::Pose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlaneId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PlaneId_Data* object =
      static_cast<const PlaneId_Data*>(data);

  return true;
}

PlaneId_Data::PlaneId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnchorId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnchorId_Data* object =
      static_cast<const AnchorId_Data*>(data);

  return true;
}

AnchorId_Data::AnchorId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HitTestSubscriptionId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HitTestSubscriptionId_Data* object =
      static_cast<const HitTestSubscriptionId_Data*>(data);

  return true;
}

HitTestSubscriptionId_Data::HitTestSubscriptionId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRRay_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRRay_Data* object =
      static_cast<const XRRay_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->direction, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->direction, validation_context))
    return false;

  return true;
}

XRRay_Data::XRRay_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHitResult_Data* object =
      static_cast<const XRHitResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->plane_id, validation_context))
    return false;

  return true;
}

XRHitResult_Data::XRHitResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRViewGeometry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRViewGeometry_Data* object =
      static_cast<const XRViewGeometry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_of_view, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_of_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_view, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_view, validation_context))
    return false;

  return true;
}

XRViewGeometry_Data::XRViewGeometry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRView_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRView_Data* object =
      static_cast<const XRView_Data*>(data);


  if (!::device::mojom::internal::XREye_Data
        ::Validate(object->eye, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->geometry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->geometry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->depth_data, validation_context))
    return false;

  return true;
}

XRView_Data::XRView_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRStageParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRStageParameters_Data* object =
      static_cast<const VRStageParameters_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_stage, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_stage, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& bounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bounds, validation_context,
                                         &bounds_validate_params)) {
    return false;
  }

  return true;
}

VRStageParameters_Data::VRStageParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationTransportOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationTransportOptions_Data* object =
      static_cast<const XRPresentationTransportOptions_Data*>(data);


  if (!::device::mojom::internal::XRPresentationTransportMethod_Data
        ::Validate(object->transport_method, validation_context))
    return false;

  return true;
}

XRPresentationTransportOptions_Data::XRPresentationTransportOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceSpaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRInputSourceSpaceInfo_Data* object =
      static_cast<const XRInputSourceSpaceInfo_Data*>(data);


  if (!::device::mojom::internal::XRInputSourceSpaceType_Data
        ::Validate(object->input_source_space_type, validation_context))
    return false;

  return true;
}

XRInputSourceSpaceInfo_Data::XRInputSourceSpaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHandJointSpaceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHandJointSpaceInfo_Data* object =
      static_cast<const XRHandJointSpaceInfo_Data*>(data);


  if (!::device::mojom::internal::XRHandedness_Data
        ::Validate(object->handedness, validation_context))
    return false;


  if (!::device::mojom::internal::XRHandJoint_Data
        ::Validate(object->joint, validation_context))
    return false;

  return true;
}

XRHandJointSpaceInfo_Data::XRHandJointSpaceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlanePointData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPlanePointData_Data* object =
      static_cast<const XRPlanePointData_Data*>(data);

  return true;
}

XRPlanePointData_Data::XRPlanePointData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlaneData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPlaneData_Data* object =
      static_cast<const XRPlaneData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;


  if (!::device::mojom::internal::XRPlaneOrientation_Data
        ::Validate(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_plane, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->polygon, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& polygon_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->polygon, validation_context,
                                         &polygon_validate_params)) {
    return false;
  }

  return true;
}

XRPlaneData_Data::XRPlaneData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlaneDetectionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPlaneDetectionData_Data* object =
      static_cast<const XRPlaneDetectionData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_planes_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_planes_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->all_planes_ids, validation_context,
                                         &all_planes_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_planes_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& updated_planes_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->updated_planes_data, validation_context,
                                         &updated_planes_data_validate_params)) {
    return false;
  }

  return true;
}

XRPlaneDetectionData_Data::XRPlaneDetectionData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRAnchorData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRAnchorData_Data* object =
      static_cast<const XRAnchorData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_anchor, validation_context))
    return false;

  return true;
}

XRAnchorData_Data::XRAnchorData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRAnchorsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRAnchorsData_Data* object =
      static_cast<const XRAnchorsData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_anchors_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_anchors_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->all_anchors_ids, validation_context,
                                         &all_anchors_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_anchors_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& updated_anchors_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->updated_anchors_data, validation_context,
                                         &updated_anchors_data_validate_params)) {
    return false;
  }

  return true;
}

XRAnchorsData_Data::XRAnchorsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestSubscriptionResultData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHitTestSubscriptionResultData_Data* object =
      static_cast<const XRHitTestSubscriptionResultData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subscription_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subscription_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_test_results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hit_test_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hit_test_results, validation_context,
                                         &hit_test_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestSubscriptionResultData_Data::XRHitTestSubscriptionResultData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestTransientInputSubscriptionResultData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHitTestTransientInputSubscriptionResultData_Data* object =
      static_cast<const XRHitTestTransientInputSubscriptionResultData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subscription_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subscription_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_source_id_to_hit_test_results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_source_id_to_hit_test_results_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->input_source_id_to_hit_test_results, validation_context,
                                         &input_source_id_to_hit_test_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestTransientInputSubscriptionResultData_Data::XRHitTestTransientInputSubscriptionResultData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestSubscriptionResultsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRHitTestSubscriptionResultsData_Data* object =
      static_cast<const XRHitTestSubscriptionResultsData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transient_input_results, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transient_input_results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transient_input_results, validation_context,
                                         &transient_input_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestSubscriptionResultsData_Data::XRHitTestSubscriptionResultsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RgbTupleF32_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RgbTupleF32_Data* object =
      static_cast<const RgbTupleF32_Data*>(data);

  return true;
}

RgbTupleF32_Data::RgbTupleF32_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSphericalHarmonics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSphericalHarmonics_Data* object =
      static_cast<const XRSphericalHarmonics_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coefficients, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& coefficients_validate_params =
      mojo::internal::GetArrayValidator<9, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->coefficients, validation_context,
                                         &coefficients_validate_params)) {
    return false;
  }

  return true;
}

XRSphericalHarmonics_Data::XRSphericalHarmonics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRCubeMap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRCubeMap_Data* object =
      static_cast<const XRCubeMap_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_x, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& positive_x_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->positive_x, validation_context,
                                         &positive_x_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_x, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& negative_x_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->negative_x, validation_context,
                                         &negative_x_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_y, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& positive_y_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->positive_y, validation_context,
                                         &positive_y_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_y, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& negative_y_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->negative_y, validation_context,
                                         &negative_y_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_z, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& positive_z_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->positive_z, validation_context,
                                         &positive_z_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_z, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& negative_z_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->negative_z, validation_context,
                                         &negative_z_validate_params)) {
    return false;
  }

  return true;
}

XRCubeMap_Data::XRCubeMap_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRLightProbe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRLightProbe_Data* object =
      static_cast<const XRLightProbe_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spherical_harmonics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->spherical_harmonics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_light_direction, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_light_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_light_intensity, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_light_intensity, validation_context))
    return false;

  return true;
}

XRLightProbe_Data::XRLightProbe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRReflectionProbe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRReflectionProbe_Data* object =
      static_cast<const XRReflectionProbe_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cube_map, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cube_map, validation_context))
    return false;

  return true;
}

XRReflectionProbe_Data::XRReflectionProbe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRLightEstimationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRLightEstimationData_Data* object =
      static_cast<const XRLightEstimationData_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->light_probe, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reflection_probe, validation_context))
    return false;

  return true;
}

XRLightEstimationData_Data::XRLightEstimationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthDataStillValid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRDepthDataStillValid_Data* object =
      static_cast<const XRDepthDataStillValid_Data*>(data);

  return true;
}

XRDepthDataStillValid_Data::XRDepthDataStillValid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthDataUpdated_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRDepthDataUpdated_Data* object =
      static_cast<const XRDepthDataUpdated_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pixel_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pixel_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->norm_texture_from_norm_view, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->norm_texture_from_norm_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->view_geometry, validation_context))
    return false;

  return true;
}

XRDepthDataUpdated_Data::XRDepthDataUpdated_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTrackedImageData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRTrackedImageData_Data* object =
      static_cast<const XRTrackedImageData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_image, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_image, validation_context))
    return false;

  return true;
}

XRTrackedImageData_Data::XRTrackedImageData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRTrackedImagesData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRTrackedImagesData_Data* object =
      static_cast<const XRTrackedImagesData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& images_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->images_data, validation_context,
                                         &images_data_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& image_trackable_scores_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_trackable_scores, validation_context,
                                         &image_trackable_scores_validate_params)) {
    return false;
  }

  return true;
}

XRTrackedImagesData_Data::XRTrackedImagesData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRRenderInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRRenderInfo_Data* object =
      static_cast<const XRRenderInfo_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->mojo_from_viewer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->views, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& views_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->views, validation_context,
                                         &views_validate_params)) {
    return false;
  }

  return true;
}

XRRenderInfo_Data::XRRenderInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRFrameData_Data* object =
      static_cast<const XRFrameData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->render_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_delta, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_delta, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->buffer_shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->buffer_sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->camera_image_buffer_shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->camera_image_buffer_sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->camera_image_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_floor, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& input_state_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_state, validation_context,
                                         &input_state_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->stage_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->detected_planes_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->anchors_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->light_estimation_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hit_test_subscription_results, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tracked_images, validation_context))
    return false;

  return true;
}

XRFrameData_Data::XRFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestSessionSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RequestSessionSuccess_Data* object =
      static_cast<const RequestSessionSuccess_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->metrics_recorder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->metrics_recorder,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->xr_internals_listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RequestSessionSuccess_Data::RequestSessionSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataRequestOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRFrameDataRequestOptions_Data* object =
      static_cast<const XRFrameDataRequestOptions_Data*>(data);

  return true;
}

XRFrameDataRequestOptions_Data::XRFrameDataRequestOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_SetClient_Params_Data* object =
      static_cast<const VRService_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VRService_SetClient_Params_Data::VRService_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_RequestSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_RequestSession_Params_Data* object =
      static_cast<const VRService_RequestSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VRService_RequestSession_Params_Data::VRService_RequestSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_RequestSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_RequestSession_ResponseParams_Data* object =
      static_cast<const VRService_RequestSession_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

VRService_RequestSession_ResponseParams_Data::VRService_RequestSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SupportsSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_SupportsSession_Params_Data* object =
      static_cast<const VRService_SupportsSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VRService_SupportsSession_Params_Data::VRService_SupportsSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SupportsSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_SupportsSession_ResponseParams_Data* object =
      static_cast<const VRService_SupportsSession_ResponseParams_Data*>(data);

  return true;
}

VRService_SupportsSession_ResponseParams_Data::VRService_SupportsSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_ExitPresent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_ExitPresent_Params_Data* object =
      static_cast<const VRService_ExitPresent_Params_Data*>(data);

  return true;
}

VRService_ExitPresent_Params_Data::VRService_ExitPresent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_ExitPresent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_ExitPresent_ResponseParams_Data* object =
      static_cast<const VRService_ExitPresent_ResponseParams_Data*>(data);

  return true;
}

VRService_ExitPresent_ResponseParams_Data::VRService_ExitPresent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SetFramesThrottled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_SetFramesThrottled_Params_Data* object =
      static_cast<const VRService_SetFramesThrottled_Params_Data*>(data);

  return true;
}

VRService_SetFramesThrottled_Params_Data::VRService_SetFramesThrottled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_MakeXrCompatible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_MakeXrCompatible_Params_Data* object =
      static_cast<const VRService_MakeXrCompatible_Params_Data*>(data);

  return true;
}

VRService_MakeXrCompatible_Params_Data::VRService_MakeXrCompatible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_MakeXrCompatible_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRService_MakeXrCompatible_ResponseParams_Data* object =
      static_cast<const VRService_MakeXrCompatible_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::XrCompatibleResult_Data
        ::Validate(object->xr_compatible_result, validation_context))
    return false;

  return true;
}

VRService_MakeXrCompatible_ResponseParams_Data::VRService_MakeXrCompatible_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* object =
      static_cast<const XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data*>(data);


  if (!::device::mojom::internal::XRSessionFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRServiceClient_OnDeviceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VRServiceClient_OnDeviceChanged_Params_Data* object =
      static_cast<const VRServiceClient_OnDeviceChanged_Params_Data*>(data);

  return true;
}

VRServiceClient_OnDeviceChanged_Params_Data::VRServiceClient_OnDeviceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entity_types, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entity_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->entity_types, validation_context,
                                         &entity_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ray, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ray, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->subscription_id, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& profile_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->profile_name, validation_context,
                                         &profile_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entity_types, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entity_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->entity_types, validation_context,
                                         &entity_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ray, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ray, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->subscription_id, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subscription_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subscription_id, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_CreateAnchor_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_origin_from_anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->native_origin_from_anchor, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->plane_id, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->anchor_id, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* object =
      static_cast<const XREnvironmentIntegrationProvider_DetachAnchor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->anchor_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->anchor_id, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetFrameData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRFrameDataProvider_GetFrameData_Params_Data* object =
      static_cast<const XRFrameDataProvider_GetFrameData_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

XRFrameDataProvider_GetFrameData_Params_Data::XRFrameDataProvider_GetFrameData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetFrameData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRFrameDataProvider_GetFrameData_ResponseParams_Data* object =
      static_cast<const XRFrameDataProvider_GetFrameData_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->frame_data, validation_context))
    return false;

  return true;
}

XRFrameDataProvider_GetFrameData_ResponseParams_Data::XRFrameDataProvider_GetFrameData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* object =
      static_cast<const XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->environment_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->environment_provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_UpdateLayerBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationProvider_UpdateLayerBounds_Params_Data* object =
      static_cast<const XRPresentationProvider_UpdateLayerBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->left_bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->left_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->right_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->right_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_size, validation_context))
    return false;

  return true;
}

XRPresentationProvider_UpdateLayerBounds_Params_Data::XRPresentationProvider_UpdateLayerBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameMissing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationProvider_SubmitFrameMissing_Params_Data* object =
      static_cast<const XRPresentationProvider_SubmitFrameMissing_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrameMissing_Params_Data::XRPresentationProvider_SubmitFrameMissing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationProvider_SubmitFrame_Params_Data* object =
      static_cast<const XRPresentationProvider_SubmitFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox_holder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox_holder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_waited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_waited, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrame_Params_Data::XRPresentationProvider_SubmitFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* object =
      static_cast<const XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_waited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_waited, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameTransferred_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationClient_OnSubmitFrameTransferred_Params_Data* object =
      static_cast<const XRPresentationClient_OnSubmitFrameTransferred_Params_Data*>(data);

  return true;
}

XRPresentationClient_OnSubmitFrameTransferred_Params_Data::XRPresentationClient_OnSubmitFrameTransferred_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationClient_OnSubmitFrameRendered_Params_Data* object =
      static_cast<const XRPresentationClient_OnSubmitFrameRendered_Params_Data*>(data);

  return true;
}

XRPresentationClient_OnSubmitFrameRendered_Params_Data::XRPresentationClient_OnSubmitFrameRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* object =
      static_cast<const XRPresentationClient_OnSubmitFrameGpuFence_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_fence_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_fence_handle, validation_context))
    return false;

  return true;
}

XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnExitPresent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSessionClient_OnExitPresent_Params_Data* object =
      static_cast<const XRSessionClient_OnExitPresent_Params_Data*>(data);

  return true;
}

XRSessionClient_OnExitPresent_Params_Data::XRSessionClient_OnExitPresent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnVisibilityStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const XRSessionClient_OnVisibilityStateChanged_Params_Data* object =
      static_cast<const XRSessionClient_OnVisibilityStateChanged_Params_Data*>(data);


  if (!::device::mojom::internal::XRVisibilityState_Data
        ::Validate(object->visibility_state, validation_context))
    return false;

  return true;
}

XRSessionClient_OnVisibilityStateChanged_Params_Data::XRSessionClient_OnVisibilityStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebXrInternalsRendererListener_OnFrameData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebXrInternalsRendererListener_OnFrameData_Params_Data* object =
      static_cast<const WebXrInternalsRendererListener_OnFrameData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->xrframe_statistics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->xrframe_statistics, validation_context))
    return false;

  return true;
}

WebXrInternalsRendererListener_OnFrameData_Params_Data::WebXrInternalsRendererListener_OnFrameData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebXrInternalsRendererListener_OnConsoleLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebXrInternalsRendererListener_OnConsoleLog_Params_Data* object =
      static_cast<const WebXrInternalsRendererListener_OnConsoleLog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->xrlogging_statistics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->xrlogging_statistics, validation_context))
    return false;

  return true;
}

WebXrInternalsRendererListener_OnConsoleLog_Params_Data::WebXrInternalsRendererListener_OnConsoleLog_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRHandedness>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRHandedness value) {
  return std::move(context).WriteString(::device::mojom::XRHandednessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRTargetRayMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRTargetRayMode value) {
  return std::move(context).WriteString(::device::mojom::XRTargetRayModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRSessionFeatureRequestStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRSessionFeatureRequestStatus value) {
  return std::move(context).WriteString(::device::mojom::XRSessionFeatureRequestStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XREnvironmentBlendMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XREnvironmentBlendMode value) {
  return std::move(context).WriteString(::device::mojom::XREnvironmentBlendModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRInteractionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRInteractionMode value) {
  return std::move(context).WriteString(::device::mojom::XRInteractionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XREye>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XREye value) {
  return std::move(context).WriteString(::device::mojom::XREyeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRPresentationTransportMethod>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRPresentationTransportMethod value) {
  return std::move(context).WriteString(::device::mojom::XRPresentationTransportMethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRReferenceSpaceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRReferenceSpaceType value) {
  return std::move(context).WriteString(::device::mojom::XRReferenceSpaceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRInputSourceSpaceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRInputSourceSpaceType value) {
  return std::move(context).WriteString(::device::mojom::XRInputSourceSpaceTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRPlaneOrientation>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRPlaneOrientation value) {
  return std::move(context).WriteString(::device::mojom::XRPlaneOrientationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XrCompatibleResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XrCompatibleResult value) {
  return std::move(context).WriteString(::device::mojom::XrCompatibleResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::EntityTypeForHitTest>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::EntityTypeForHitTest value) {
  return std::move(context).WriteString(::device::mojom::EntityTypeForHitTestToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRVisibilityState>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRVisibilityState value) {
  return std::move(context).WriteString(::device::mojom::XRVisibilityStateToString(value));
}

} // namespace perfetto