// device/vr/public/mojom/vr_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SEND_VALIDATION_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "device/vr/public/mojom/vr_service.mojom-shared-internal.h"
#include "device/gamepad/public/mojom/gamepad.mojom-shared.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom-shared.h"
#include "device/vr/public/mojom/xr_session.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-shared.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/display/mojom/display.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"

#include "device/vr/public/mojom/vr_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRHandedness, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRTargetRayMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRSessionFeatureRequestStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XREnvironmentBlendMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRInteractionMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XREye, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRPresentationTransportMethod, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRReferenceSpaceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRInputSourceSpaceType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRPlaneOrientation, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XrCompatibleResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::EntityTypeForHitTest, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::XRVisibilityState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRDepthConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XRDepthUsage>(
        Traits::depth_usage(input),
        &fragment->depth_usage);

      
      mojo::internal::Serialize<::device::mojom::XRDepthDataFormat>(
        Traits::depth_data_format(input),
        &fragment->depth_data_format);
      fragment->depth_type_$flag = Traits::depth_type(input).has_value();
      if (Traits::depth_type(input).has_value()) {
        
        mojo::internal::Serialize<::device::mojom::XRDepthType>(
          Traits::depth_type(input).value(),
          &fragment->depth_type_$value);
      } else {
        fragment->depth_type_$value =
            static_cast<int32_t>(::device::mojom::XRDepthType::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRSessionDeviceConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionDeviceConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSessionDeviceConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->default_framebuffer_scale = Traits::default_framebuffer_scale(input);

      decltype(Traits::views(input)) in_views = Traits::views(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->views)::BaseType>
          views_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& views_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>, send_validation>(
        in_views,
        views_fragment,
        &views_validate_params);

      fragment->views.Set(
          views_fragment.is_null() ? nullptr : views_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->views.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null views in XRSessionDeviceConfig struct");

      fragment->supports_viewport_scaling = Traits::supports_viewport_scaling(input);

      fragment->enable_anti_aliasing = Traits::enable_anti_aliasing(input);

      decltype(Traits::depth_configuration(input)) in_depth_configuration = Traits::depth_configuration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->depth_configuration)::BaseType> depth_configuration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRDepthConfigDataView, send_validation>(
        in_depth_configuration,
        depth_configuration_fragment);

      fragment->depth_configuration.Set(
          depth_configuration_fragment.is_null() ? nullptr : depth_configuration_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRSessionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSession_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data_provider(input)) in_data_provider = Traits::data_provider(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRFrameDataProviderInterfaceBase>>(
        in_data_provider,
        &fragment->data_provider,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data_provider)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid data_provider in XRSession struct");

      decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::XRSessionClientInterfaceBase>>(
        in_client_receiver,
        &fragment->client_receiver,
        &fragment.message());

      decltype(Traits::submit_frame_sink(input)) in_submit_frame_sink = Traits::submit_frame_sink(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->submit_frame_sink)::BaseType> submit_frame_sink_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRPresentationConnectionDataView, send_validation>(
        in_submit_frame_sink,
        submit_frame_sink_fragment);

      fragment->submit_frame_sink.Set(
          submit_frame_sink_fragment.is_null() ? nullptr : submit_frame_sink_fragment.data());

      decltype(Traits::enabled_features(input)) in_enabled_features = Traits::enabled_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->enabled_features)::BaseType>
          enabled_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& enabled_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>, send_validation>(
        in_enabled_features,
        enabled_features_fragment,
        &enabled_features_validate_params);

      fragment->enabled_features.Set(
          enabled_features_fragment.is_null() ? nullptr : enabled_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->enabled_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_features in XRSession struct");

      decltype(Traits::device_config(input)) in_device_config = Traits::device_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_config)::BaseType> device_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRSessionDeviceConfigDataView, send_validation>(
        in_device_config,
        device_config_fragment);

      fragment->device_config.Set(
          device_config_fragment.is_null() ? nullptr : device_config_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_config.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_config in XRSession struct");

      
      mojo::internal::Serialize<::device::mojom::XREnvironmentBlendMode>(
        Traits::enviroment_blend_mode(input),
        &fragment->enviroment_blend_mode);

      
      mojo::internal::Serialize<::device::mojom::XRInteractionMode>(
        Traits::interaction_mode(input),
        &fragment->interaction_mode);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRPresentationConnectionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPresentationConnectionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPresentationConnection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::provider(input)) in_provider = Traits::provider(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRPresentationProviderInterfaceBase>>(
        in_provider,
        &fragment->provider,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->provider)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid provider in XRPresentationConnection struct");

      decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::XRPresentationClientInterfaceBase>>(
        in_client_receiver,
        &fragment->client_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_receiver in XRPresentationConnection struct");

      decltype(Traits::transport_options(input)) in_transport_options = Traits::transport_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transport_options)::BaseType> transport_options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRPresentationTransportOptionsDataView, send_validation>(
        in_transport_options,
        transport_options_fragment);

      fragment->transport_options.Set(
          transport_options_fragment.is_null() ? nullptr : transport_options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transport_options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transport_options in XRPresentationConnection struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRInputSourceDescriptionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceDescriptionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRInputSourceDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XRTargetRayMode>(
        Traits::target_ray_mode(input),
        &fragment->target_ray_mode);

      
      mojo::internal::Serialize<::device::mojom::XRHandedness>(
        Traits::handedness(input),
        &fragment->handedness);

      decltype(Traits::input_from_pointer(input)) in_input_from_pointer = Traits::input_from_pointer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_from_pointer)::BaseType> input_from_pointer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_input_from_pointer,
        input_from_pointer_fragment);

      fragment->input_from_pointer.Set(
          input_from_pointer_fragment.is_null() ? nullptr : input_from_pointer_fragment.data());

      decltype(Traits::profiles(input)) in_profiles = Traits::profiles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->profiles)::BaseType>
          profiles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& profiles_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_profiles,
        profiles_fragment,
        &profiles_validate_params);

      fragment->profiles.Set(
          profiles_fragment.is_null() ? nullptr : profiles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->profiles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null profiles in XRInputSourceDescription struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRInputSourceStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRInputSourceState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->source_id = Traits::source_id(input);

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRInputSourceDescriptionDataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      decltype(Traits::mojo_from_input(input)) in_mojo_from_input = Traits::mojo_from_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_input)::BaseType> mojo_from_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_mojo_from_input,
        mojo_from_input_fragment);

      fragment->mojo_from_input.Set(
          mojo_from_input_fragment.is_null() ? nullptr : mojo_from_input_fragment.data());

      fragment->emulated_position = Traits::emulated_position(input);

      fragment->is_auxiliary = Traits::is_auxiliary(input);

      fragment->primary_input_pressed = Traits::primary_input_pressed(input);

      fragment->primary_input_clicked = Traits::primary_input_clicked(input);

      fragment->primary_squeeze_pressed = Traits::primary_squeeze_pressed(input);

      fragment->primary_squeeze_clicked = Traits::primary_squeeze_clicked(input);

      decltype(Traits::gamepad(input)) in_gamepad = Traits::gamepad(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gamepad)::BaseType> gamepad_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::GamepadDataView, send_validation>(
        in_gamepad,
        gamepad_fragment);

      fragment->gamepad.Set(
          gamepad_fragment.is_null() ? nullptr : gamepad_fragment.data());

      decltype(Traits::overlay_pointer_position(input)) in_overlay_pointer_position = Traits::overlay_pointer_position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->overlay_pointer_position)::BaseType> overlay_pointer_position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_overlay_pointer_position,
        overlay_pointer_position_fragment);

      fragment->overlay_pointer_position.Set(
          overlay_pointer_position_fragment.is_null() ? nullptr : overlay_pointer_position_fragment.data());

      decltype(Traits::hand_tracking_data(input)) in_hand_tracking_data = Traits::hand_tracking_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hand_tracking_data)::BaseType> hand_tracking_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRHandTrackingDataDataView, send_validation>(
        in_hand_tracking_data,
        hand_tracking_data_fragment);

      fragment->hand_tracking_data.Set(
          hand_tracking_data_fragment.is_null() ? nullptr : hand_tracking_data_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::VRFieldOfViewDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRFieldOfViewDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VRFieldOfView_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->up_degrees = Traits::up_degrees(input);

      fragment->down_degrees = Traits::down_degrees(input);

      fragment->left_degrees = Traits::left_degrees(input);

      fragment->right_degrees = Traits::right_degrees(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::VRPoseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRPoseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VRPose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->orientation)::BaseType> orientation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::QuaternionDataView, send_validation>(
        in_orientation,
        orientation_fragment);

      fragment->orientation.Set(
          orientation_fragment.is_null() ? nullptr : orientation_fragment.data());

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Point3FDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      fragment->emulated_position = Traits::emulated_position(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::PoseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::PoseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::Pose_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::orientation(input)) in_orientation = Traits::orientation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->orientation)::BaseType> orientation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::QuaternionDataView, send_validation>(
        in_orientation,
        orientation_fragment);

      fragment->orientation.Set(
          orientation_fragment.is_null() ? nullptr : orientation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->orientation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null orientation in Pose struct");

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Point3FDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->position.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in Pose struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::PlaneIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::PlaneIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::PlaneId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id_value = Traits::id_value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::AnchorIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::AnchorIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::AnchorId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id_value = Traits::id_value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::HitTestSubscriptionIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HitTestSubscriptionIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HitTestSubscriptionId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id_value = Traits::id_value(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRRayDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRayDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRay_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Point3FDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in XRRay struct");

      decltype(Traits::direction(input)) in_direction = Traits::direction(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->direction)::BaseType> direction_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView, send_validation>(
        in_direction,
        direction_fragment);

      fragment->direction.Set(
          direction_fragment.is_null() ? nullptr : direction_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->direction.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null direction in XRRay struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRHitResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mojo_from_result(input)) in_mojo_from_result = Traits::mojo_from_result(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_result)::BaseType> mojo_from_result_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PoseDataView, send_validation>(
        in_mojo_from_result,
        mojo_from_result_fragment);

      fragment->mojo_from_result.Set(
          mojo_from_result_fragment.is_null() ? nullptr : mojo_from_result_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mojo_from_result.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_result in XRHitResult struct");

      decltype(Traits::plane_id(input)) in_plane_id = Traits::plane_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->plane_id)::BaseType> plane_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PlaneIdDataView, send_validation>(
        in_plane_id,
        plane_id_fragment);

      fragment->plane_id.Set(
          plane_id_fragment.is_null() ? nullptr : plane_id_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRViewGeometryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRViewGeometryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRViewGeometry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::field_of_view(input)) in_field_of_view = Traits::field_of_view(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->field_of_view)::BaseType> field_of_view_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::VRFieldOfViewDataView, send_validation>(
        in_field_of_view,
        field_of_view_fragment);

      fragment->field_of_view.Set(
          field_of_view_fragment.is_null() ? nullptr : field_of_view_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->field_of_view.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field_of_view in XRViewGeometry struct");

      decltype(Traits::mojo_from_view(input)) in_mojo_from_view = Traits::mojo_from_view(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_view)::BaseType> mojo_from_view_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_mojo_from_view,
        mojo_from_view_fragment);

      fragment->mojo_from_view.Set(
          mojo_from_view_fragment.is_null() ? nullptr : mojo_from_view_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mojo_from_view.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_view in XRViewGeometry struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRViewDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRViewDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRView_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XREye>(
        Traits::eye(input),
        &fragment->eye);

      decltype(Traits::geometry(input)) in_geometry = Traits::geometry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geometry)::BaseType> geometry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRViewGeometryDataView, send_validation>(
        in_geometry,
        geometry_fragment);

      fragment->geometry.Set(
          geometry_fragment.is_null() ? nullptr : geometry_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->geometry.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null geometry in XRView struct");

      decltype(Traits::viewport(input)) in_viewport = Traits::viewport(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->viewport)::BaseType> viewport_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_viewport,
        viewport_fragment);

      fragment->viewport.Set(
          viewport_fragment.is_null() ? nullptr : viewport_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->viewport.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport in XRView struct");

      decltype(Traits::depth_data(input)) in_depth_data = Traits::depth_data(input);
      mojo::internal::MessageFragment<decltype(fragment->depth_data)>
          depth_data_fragment(fragment.message());
      depth_data_fragment.Claim(&fragment->depth_data);
      
      mojo::internal::Serialize<::device::mojom::XRDepthDataDataView, send_validation>(
        in_depth_data,
        depth_data_fragment,
        true);

      fragment->is_first_person_observer = Traits::is_first_person_observer(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::VRStageParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VRStageParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VRStageParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mojo_from_stage(input)) in_mojo_from_stage = Traits::mojo_from_stage(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_stage)::BaseType> mojo_from_stage_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_mojo_from_stage,
        mojo_from_stage_fragment);

      fragment->mojo_from_stage.Set(
          mojo_from_stage_fragment.is_null() ? nullptr : mojo_from_stage_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mojo_from_stage.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_stage in VRStageParameters struct");

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType>
          bounds_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bounds_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::Point3FDataView>, send_validation>(
        in_bounds,
        bounds_fragment,
        &bounds_validate_params);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRPresentationTransportOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPresentationTransportOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPresentationTransportOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XRPresentationTransportMethod>(
        Traits::transport_method(input),
        &fragment->transport_method);

      fragment->wait_for_transfer_notification = Traits::wait_for_transfer_notification(input);

      fragment->wait_for_render_notification = Traits::wait_for_render_notification(input);

      fragment->wait_for_gpu_fence = Traits::wait_for_gpu_fence(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRInputSourceSpaceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRInputSourceSpaceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRInputSourceSpaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->input_source_id = Traits::input_source_id(input);

      
      mojo::internal::Serialize<::device::mojom::XRInputSourceSpaceType>(
        Traits::input_source_space_type(input),
        &fragment->input_source_space_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRHandJointSpaceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHandJointSpaceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHandJointSpaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::XRHandedness>(
        Traits::handedness(input),
        &fragment->handedness);

      
      mojo::internal::Serialize<::device::mojom::XRHandJoint>(
        Traits::joint(input),
        &fragment->joint);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRPlanePointDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlanePointDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPlanePointData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->x = Traits::x(input);

      fragment->z = Traits::z(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRPlaneDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlaneDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPlaneData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PlaneIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in XRPlaneData struct");

      
      mojo::internal::Serialize<::device::mojom::XRPlaneOrientation>(
        Traits::orientation(input),
        &fragment->orientation);

      decltype(Traits::mojo_from_plane(input)) in_mojo_from_plane = Traits::mojo_from_plane(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_plane)::BaseType> mojo_from_plane_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PoseDataView, send_validation>(
        in_mojo_from_plane,
        mojo_from_plane_fragment);

      fragment->mojo_from_plane.Set(
          mojo_from_plane_fragment.is_null() ? nullptr : mojo_from_plane_fragment.data());

      decltype(Traits::polygon(input)) in_polygon = Traits::polygon(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->polygon)::BaseType>
          polygon_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& polygon_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRPlanePointDataDataView>, send_validation>(
        in_polygon,
        polygon_fragment,
        &polygon_validate_params);

      fragment->polygon.Set(
          polygon_fragment.is_null() ? nullptr : polygon_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->polygon.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null polygon in XRPlaneData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRPlaneDetectionDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRPlaneDetectionDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRPlaneDetectionData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::all_planes_ids(input)) in_all_planes_ids = Traits::all_planes_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->all_planes_ids)::BaseType>
          all_planes_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& all_planes_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::PlaneIdDataView>, send_validation>(
        in_all_planes_ids,
        all_planes_ids_fragment,
        &all_planes_ids_validate_params);

      fragment->all_planes_ids.Set(
          all_planes_ids_fragment.is_null() ? nullptr : all_planes_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->all_planes_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_planes_ids in XRPlaneDetectionData struct");

      decltype(Traits::updated_planes_data(input)) in_updated_planes_data = Traits::updated_planes_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->updated_planes_data)::BaseType>
          updated_planes_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& updated_planes_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRPlaneDataDataView>, send_validation>(
        in_updated_planes_data,
        updated_planes_data_fragment,
        &updated_planes_data_validate_params);

      fragment->updated_planes_data.Set(
          updated_planes_data_fragment.is_null() ? nullptr : updated_planes_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->updated_planes_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updated_planes_data in XRPlaneDetectionData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRAnchorDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRAnchorDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRAnchorData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::AnchorIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in XRAnchorData struct");

      decltype(Traits::mojo_from_anchor(input)) in_mojo_from_anchor = Traits::mojo_from_anchor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_anchor)::BaseType> mojo_from_anchor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PoseDataView, send_validation>(
        in_mojo_from_anchor,
        mojo_from_anchor_fragment);

      fragment->mojo_from_anchor.Set(
          mojo_from_anchor_fragment.is_null() ? nullptr : mojo_from_anchor_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRAnchorsDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRAnchorsDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRAnchorsData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::all_anchors_ids(input)) in_all_anchors_ids = Traits::all_anchors_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->all_anchors_ids)::BaseType>
          all_anchors_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& all_anchors_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::AnchorIdDataView>, send_validation>(
        in_all_anchors_ids,
        all_anchors_ids_fragment,
        &all_anchors_ids_validate_params);

      fragment->all_anchors_ids.Set(
          all_anchors_ids_fragment.is_null() ? nullptr : all_anchors_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->all_anchors_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_anchors_ids in XRAnchorsData struct");

      decltype(Traits::updated_anchors_data(input)) in_updated_anchors_data = Traits::updated_anchors_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->updated_anchors_data)::BaseType>
          updated_anchors_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& updated_anchors_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRAnchorDataDataView>, send_validation>(
        in_updated_anchors_data,
        updated_anchors_data_fragment,
        &updated_anchors_data_validate_params);

      fragment->updated_anchors_data.Set(
          updated_anchors_data_fragment.is_null() ? nullptr : updated_anchors_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->updated_anchors_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null updated_anchors_data in XRAnchorsData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRHitTestSubscriptionResultDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestSubscriptionResultDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitTestSubscriptionResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::subscription_id(input)) in_subscription_id = Traits::subscription_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subscription_id)::BaseType> subscription_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::HitTestSubscriptionIdDataView, send_validation>(
        in_subscription_id,
        subscription_id_fragment);

      fragment->subscription_id.Set(
          subscription_id_fragment.is_null() ? nullptr : subscription_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subscription_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subscription_id in XRHitTestSubscriptionResultData struct");

      decltype(Traits::hit_test_results(input)) in_hit_test_results = Traits::hit_test_results(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hit_test_results)::BaseType>
          hit_test_results_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& hit_test_results_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitResultDataView>, send_validation>(
        in_hit_test_results,
        hit_test_results_fragment,
        &hit_test_results_validate_params);

      fragment->hit_test_results.Set(
          hit_test_results_fragment.is_null() ? nullptr : hit_test_results_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hit_test_results.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hit_test_results in XRHitTestSubscriptionResultData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitTestTransientInputSubscriptionResultData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::subscription_id(input)) in_subscription_id = Traits::subscription_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subscription_id)::BaseType> subscription_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::HitTestSubscriptionIdDataView, send_validation>(
        in_subscription_id,
        subscription_id_fragment);

      fragment->subscription_id.Set(
          subscription_id_fragment.is_null() ? nullptr : subscription_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subscription_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subscription_id in XRHitTestTransientInputSubscriptionResultData struct");

      decltype(Traits::input_source_id_to_hit_test_results(input)) in_input_source_id_to_hit_test_results = Traits::input_source_id_to_hit_test_results(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_source_id_to_hit_test_results)::BaseType>
          input_source_id_to_hit_test_results_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& input_source_id_to_hit_test_results_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint32_t, mojo::ArrayDataView<::device::mojom::XRHitResultDataView>>, send_validation>(
        in_input_source_id_to_hit_test_results,
        input_source_id_to_hit_test_results_fragment,
        &input_source_id_to_hit_test_results_validate_params);

      fragment->input_source_id_to_hit_test_results.Set(
          input_source_id_to_hit_test_results_fragment.is_null() ? nullptr : input_source_id_to_hit_test_results_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input_source_id_to_hit_test_results.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_source_id_to_hit_test_results in XRHitTestTransientInputSubscriptionResultData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRHitTestSubscriptionResultsDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRHitTestSubscriptionResultsDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRHitTestSubscriptionResultsData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::results(input)) in_results = Traits::results(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->results)::BaseType>
          results_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitTestSubscriptionResultDataDataView>, send_validation>(
        in_results,
        results_fragment,
        &results_validate_params);

      fragment->results.Set(
          results_fragment.is_null() ? nullptr : results_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->results.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null results in XRHitTestSubscriptionResultsData struct");

      decltype(Traits::transient_input_results(input)) in_transient_input_results = Traits::transient_input_results(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transient_input_results)::BaseType>
          transient_input_results_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& transient_input_results_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRHitTestTransientInputSubscriptionResultDataDataView>, send_validation>(
        in_transient_input_results,
        transient_input_results_fragment,
        &transient_input_results_validate_params);

      fragment->transient_input_results.Set(
          transient_input_results_fragment.is_null() ? nullptr : transient_input_results_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transient_input_results.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transient_input_results in XRHitTestSubscriptionResultsData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::RgbTupleF32DataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RgbTupleF32DataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::RgbTupleF32_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->red = Traits::red(input);

      fragment->green = Traits::green(input);

      fragment->blue = Traits::blue(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRSphericalHarmonicsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSphericalHarmonicsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSphericalHarmonics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::coefficients(input)) in_coefficients = Traits::coefficients(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->coefficients)::BaseType>
          coefficients_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& coefficients_validate_params =
          mojo::internal::GetArrayValidator<9, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::RgbTupleF32DataView>, send_validation>(
        in_coefficients,
        coefficients_fragment,
        &coefficients_validate_params);

      fragment->coefficients.Set(
          coefficients_fragment.is_null() ? nullptr : coefficients_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->coefficients.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coefficients in XRSphericalHarmonics struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRCubeMapDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRCubeMapDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRCubeMap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->width_and_height = Traits::width_and_height(input);

      decltype(Traits::positive_x(input)) in_positive_x = Traits::positive_x(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->positive_x)::BaseType>
          positive_x_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& positive_x_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_positive_x,
        positive_x_fragment,
        &positive_x_validate_params);

      fragment->positive_x.Set(
          positive_x_fragment.is_null() ? nullptr : positive_x_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->positive_x.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_x in XRCubeMap struct");

      decltype(Traits::negative_x(input)) in_negative_x = Traits::negative_x(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->negative_x)::BaseType>
          negative_x_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& negative_x_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_negative_x,
        negative_x_fragment,
        &negative_x_validate_params);

      fragment->negative_x.Set(
          negative_x_fragment.is_null() ? nullptr : negative_x_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->negative_x.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_x in XRCubeMap struct");

      decltype(Traits::positive_y(input)) in_positive_y = Traits::positive_y(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->positive_y)::BaseType>
          positive_y_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& positive_y_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_positive_y,
        positive_y_fragment,
        &positive_y_validate_params);

      fragment->positive_y.Set(
          positive_y_fragment.is_null() ? nullptr : positive_y_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->positive_y.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_y in XRCubeMap struct");

      decltype(Traits::negative_y(input)) in_negative_y = Traits::negative_y(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->negative_y)::BaseType>
          negative_y_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& negative_y_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_negative_y,
        negative_y_fragment,
        &negative_y_validate_params);

      fragment->negative_y.Set(
          negative_y_fragment.is_null() ? nullptr : negative_y_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->negative_y.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_y in XRCubeMap struct");

      decltype(Traits::positive_z(input)) in_positive_z = Traits::positive_z(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->positive_z)::BaseType>
          positive_z_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& positive_z_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_positive_z,
        positive_z_fragment,
        &positive_z_validate_params);

      fragment->positive_z.Set(
          positive_z_fragment.is_null() ? nullptr : positive_z_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->positive_z.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null positive_z in XRCubeMap struct");

      decltype(Traits::negative_z(input)) in_negative_z = Traits::negative_z(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->negative_z)::BaseType>
          negative_z_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& negative_z_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_negative_z,
        negative_z_fragment,
        &negative_z_validate_params);

      fragment->negative_z.Set(
          negative_z_fragment.is_null() ? nullptr : negative_z_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->negative_z.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null negative_z in XRCubeMap struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRLightProbeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRLightProbeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRLightProbe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::spherical_harmonics(input)) in_spherical_harmonics = Traits::spherical_harmonics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->spherical_harmonics)::BaseType> spherical_harmonics_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRSphericalHarmonicsDataView, send_validation>(
        in_spherical_harmonics,
        spherical_harmonics_fragment);

      fragment->spherical_harmonics.Set(
          spherical_harmonics_fragment.is_null() ? nullptr : spherical_harmonics_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->spherical_harmonics.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null spherical_harmonics in XRLightProbe struct");

      decltype(Traits::main_light_direction(input)) in_main_light_direction = Traits::main_light_direction(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->main_light_direction)::BaseType> main_light_direction_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector3dFDataView, send_validation>(
        in_main_light_direction,
        main_light_direction_fragment);

      fragment->main_light_direction.Set(
          main_light_direction_fragment.is_null() ? nullptr : main_light_direction_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->main_light_direction.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_light_direction in XRLightProbe struct");

      decltype(Traits::main_light_intensity(input)) in_main_light_intensity = Traits::main_light_intensity(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->main_light_intensity)::BaseType> main_light_intensity_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::RgbTupleF32DataView, send_validation>(
        in_main_light_intensity,
        main_light_intensity_fragment);

      fragment->main_light_intensity.Set(
          main_light_intensity_fragment.is_null() ? nullptr : main_light_intensity_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->main_light_intensity.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_light_intensity in XRLightProbe struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRReflectionProbeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRReflectionProbeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRReflectionProbe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cube_map(input)) in_cube_map = Traits::cube_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cube_map)::BaseType> cube_map_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRCubeMapDataView, send_validation>(
        in_cube_map,
        cube_map_fragment);

      fragment->cube_map.Set(
          cube_map_fragment.is_null() ? nullptr : cube_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cube_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cube_map in XRReflectionProbe struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRLightEstimationDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRLightEstimationDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRLightEstimationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::light_probe(input)) in_light_probe = Traits::light_probe(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->light_probe)::BaseType> light_probe_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRLightProbeDataView, send_validation>(
        in_light_probe,
        light_probe_fragment);

      fragment->light_probe.Set(
          light_probe_fragment.is_null() ? nullptr : light_probe_fragment.data());

      decltype(Traits::reflection_probe(input)) in_reflection_probe = Traits::reflection_probe(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reflection_probe)::BaseType> reflection_probe_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRReflectionProbeDataView, send_validation>(
        in_reflection_probe,
        reflection_probe_fragment);

      fragment->reflection_probe.Set(
          reflection_probe_fragment.is_null() ? nullptr : reflection_probe_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRDepthDataStillValidDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthDataStillValidDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthDataStillValid_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRDepthDataUpdatedDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthDataUpdatedDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthDataUpdated_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
      mojo::internal::MessageFragment<decltype(fragment->pixel_data)>
          pixel_data_fragment(fragment.message());
      pixel_data_fragment.Claim(&fragment->pixel_data);
      
      mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView, send_validation>(
        in_pixel_data,
        pixel_data_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pixel_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_data in XRDepthDataUpdated struct");

      decltype(Traits::norm_texture_from_norm_view(input)) in_norm_texture_from_norm_view = Traits::norm_texture_from_norm_view(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->norm_texture_from_norm_view)::BaseType> norm_texture_from_norm_view_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_norm_texture_from_norm_view,
        norm_texture_from_norm_view_fragment);

      fragment->norm_texture_from_norm_view.Set(
          norm_texture_from_norm_view_fragment.is_null() ? nullptr : norm_texture_from_norm_view_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->norm_texture_from_norm_view.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null norm_texture_from_norm_view in XRDepthDataUpdated struct");

      decltype(Traits::size(input)) in_size = Traits::size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size)::BaseType> size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size,
        size_fragment);

      fragment->size.Set(
          size_fragment.is_null() ? nullptr : size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in XRDepthDataUpdated struct");

      fragment->raw_value_to_meters = Traits::raw_value_to_meters(input);

      decltype(Traits::view_geometry(input)) in_view_geometry = Traits::view_geometry(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_geometry)::BaseType> view_geometry_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRViewGeometryDataView, send_validation>(
        in_view_geometry,
        view_geometry_fragment);

      fragment->view_geometry.Set(
          view_geometry_fragment.is_null() ? nullptr : view_geometry_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRTrackedImageDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImageDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImageData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->index = Traits::index(input);

      decltype(Traits::mojo_from_image(input)) in_mojo_from_image = Traits::mojo_from_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_image)::BaseType> mojo_from_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PoseDataView, send_validation>(
        in_mojo_from_image,
        mojo_from_image_fragment);

      fragment->mojo_from_image.Set(
          mojo_from_image_fragment.is_null() ? nullptr : mojo_from_image_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mojo_from_image.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mojo_from_image in XRTrackedImageData struct");

      fragment->actively_tracked = Traits::actively_tracked(input);

      fragment->width_in_meters = Traits::width_in_meters(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRTrackedImagesDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImagesDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImagesData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::images_data(input)) in_images_data = Traits::images_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->images_data)::BaseType>
          images_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& images_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataDataView>, send_validation>(
        in_images_data,
        images_data_fragment,
        &images_data_validate_params);

      fragment->images_data.Set(
          images_data_fragment.is_null() ? nullptr : images_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->images_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null images_data in XRTrackedImagesData struct");

      decltype(Traits::image_trackable_scores(input)) in_image_trackable_scores = Traits::image_trackable_scores(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_trackable_scores)::BaseType>
          image_trackable_scores_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& image_trackable_scores_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<bool>, send_validation>(
        in_image_trackable_scores,
        image_trackable_scores_fragment,
        &image_trackable_scores_validate_params);

      fragment->image_trackable_scores.Set(
          image_trackable_scores_fragment.is_null() ? nullptr : image_trackable_scores_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRRenderInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRRenderInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRRenderInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->frame_id = Traits::frame_id(input);

      decltype(Traits::mojo_from_viewer(input)) in_mojo_from_viewer = Traits::mojo_from_viewer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_viewer)::BaseType> mojo_from_viewer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::VRPoseDataView, send_validation>(
        in_mojo_from_viewer,
        mojo_from_viewer_fragment);

      fragment->mojo_from_viewer.Set(
          mojo_from_viewer_fragment.is_null() ? nullptr : mojo_from_viewer_fragment.data());

      decltype(Traits::views(input)) in_views = Traits::views(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->views)::BaseType>
          views_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& views_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRViewDataView>, send_validation>(
        in_views,
        views_fragment,
        &views_validate_params);

      fragment->views.Set(
          views_fragment.is_null() ? nullptr : views_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->views.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null views in XRRenderInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRFrameDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRFrameDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRFrameData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::render_info(input)) in_render_info = Traits::render_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->render_info)::BaseType> render_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRRenderInfoDataView, send_validation>(
        in_render_info,
        render_info_fragment);

      fragment->render_info.Set(
          render_info_fragment.is_null() ? nullptr : render_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->render_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null render_info in XRFrameData struct");

      decltype(Traits::time_delta(input)) in_time_delta = Traits::time_delta(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time_delta)::BaseType> time_delta_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_time_delta,
        time_delta_fragment);

      fragment->time_delta.Set(
          time_delta_fragment.is_null() ? nullptr : time_delta_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time_delta.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_delta in XRFrameData struct");

      decltype(Traits::buffer_shared_image(input)) in_buffer_shared_image = Traits::buffer_shared_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buffer_shared_image)::BaseType> buffer_shared_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView, send_validation>(
        in_buffer_shared_image,
        buffer_shared_image_fragment);

      fragment->buffer_shared_image.Set(
          buffer_shared_image_fragment.is_null() ? nullptr : buffer_shared_image_fragment.data());

      decltype(Traits::buffer_sync_token(input)) in_buffer_sync_token = Traits::buffer_sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buffer_sync_token)::BaseType> buffer_sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_buffer_sync_token,
        buffer_sync_token_fragment);

      fragment->buffer_sync_token.Set(
          buffer_sync_token_fragment.is_null() ? nullptr : buffer_sync_token_fragment.data());

      decltype(Traits::camera_image_buffer_shared_image(input)) in_camera_image_buffer_shared_image = Traits::camera_image_buffer_shared_image(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->camera_image_buffer_shared_image)::BaseType> camera_image_buffer_shared_image_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView, send_validation>(
        in_camera_image_buffer_shared_image,
        camera_image_buffer_shared_image_fragment);

      fragment->camera_image_buffer_shared_image.Set(
          camera_image_buffer_shared_image_fragment.is_null() ? nullptr : camera_image_buffer_shared_image_fragment.data());

      decltype(Traits::camera_image_buffer_sync_token(input)) in_camera_image_buffer_sync_token = Traits::camera_image_buffer_sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->camera_image_buffer_sync_token)::BaseType> camera_image_buffer_sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_camera_image_buffer_sync_token,
        camera_image_buffer_sync_token_fragment);

      fragment->camera_image_buffer_sync_token.Set(
          camera_image_buffer_sync_token_fragment.is_null() ? nullptr : camera_image_buffer_sync_token_fragment.data());

      decltype(Traits::camera_image_size(input)) in_camera_image_size = Traits::camera_image_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->camera_image_size)::BaseType> camera_image_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_camera_image_size,
        camera_image_size_fragment);

      fragment->camera_image_size.Set(
          camera_image_size_fragment.is_null() ? nullptr : camera_image_size_fragment.data());

      fragment->mojo_space_reset = Traits::mojo_space_reset(input);

      decltype(Traits::mojo_from_floor(input)) in_mojo_from_floor = Traits::mojo_from_floor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mojo_from_floor)::BaseType> mojo_from_floor_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_mojo_from_floor,
        mojo_from_floor_fragment);

      fragment->mojo_from_floor.Set(
          mojo_from_floor_fragment.is_null() ? nullptr : mojo_from_floor_fragment.data());

      decltype(Traits::input_state(input)) in_input_state = Traits::input_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_state)::BaseType>
          input_state_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& input_state_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRInputSourceStateDataView>, send_validation>(
        in_input_state,
        input_state_fragment,
        &input_state_validate_params);

      fragment->input_state.Set(
          input_state_fragment.is_null() ? nullptr : input_state_fragment.data());

      fragment->stage_parameters_id = Traits::stage_parameters_id(input);

      decltype(Traits::stage_parameters(input)) in_stage_parameters = Traits::stage_parameters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stage_parameters)::BaseType> stage_parameters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::VRStageParametersDataView, send_validation>(
        in_stage_parameters,
        stage_parameters_fragment);

      fragment->stage_parameters.Set(
          stage_parameters_fragment.is_null() ? nullptr : stage_parameters_fragment.data());

      decltype(Traits::detected_planes_data(input)) in_detected_planes_data = Traits::detected_planes_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->detected_planes_data)::BaseType> detected_planes_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRPlaneDetectionDataDataView, send_validation>(
        in_detected_planes_data,
        detected_planes_data_fragment);

      fragment->detected_planes_data.Set(
          detected_planes_data_fragment.is_null() ? nullptr : detected_planes_data_fragment.data());

      decltype(Traits::anchors_data(input)) in_anchors_data = Traits::anchors_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->anchors_data)::BaseType> anchors_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRAnchorsDataDataView, send_validation>(
        in_anchors_data,
        anchors_data_fragment);

      fragment->anchors_data.Set(
          anchors_data_fragment.is_null() ? nullptr : anchors_data_fragment.data());

      decltype(Traits::light_estimation_data(input)) in_light_estimation_data = Traits::light_estimation_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->light_estimation_data)::BaseType> light_estimation_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRLightEstimationDataDataView, send_validation>(
        in_light_estimation_data,
        light_estimation_data_fragment);

      fragment->light_estimation_data.Set(
          light_estimation_data_fragment.is_null() ? nullptr : light_estimation_data_fragment.data());

      decltype(Traits::hit_test_subscription_results(input)) in_hit_test_subscription_results = Traits::hit_test_subscription_results(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hit_test_subscription_results)::BaseType> hit_test_subscription_results_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRHitTestSubscriptionResultsDataDataView, send_validation>(
        in_hit_test_subscription_results,
        hit_test_subscription_results_fragment);

      fragment->hit_test_subscription_results.Set(
          hit_test_subscription_results_fragment.is_null() ? nullptr : hit_test_subscription_results_fragment.data());

      fragment->rendering_time_ratio = Traits::rendering_time_ratio(input);

      decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tracked_images)::BaseType> tracked_images_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRTrackedImagesDataDataView, send_validation>(
        in_tracked_images,
        tracked_images_fragment);

      fragment->tracked_images.Set(
          tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::RequestSessionSuccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::RequestSessionSuccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::RequestSessionSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::session(input)) in_session = Traits::session(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session)::BaseType> session_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::XRSessionDataView, send_validation>(
        in_session,
        session_fragment);

      fragment->session.Set(
          session_fragment.is_null() ? nullptr : session_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session in RequestSessionSuccess struct");

      fragment->trace_id = Traits::trace_id(input);

      decltype(Traits::metrics_recorder(input)) in_metrics_recorder = Traits::metrics_recorder(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::XRSessionMetricsRecorderInterfaceBase>>(
        in_metrics_recorder,
        &fragment->metrics_recorder,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->metrics_recorder)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid metrics_recorder in RequestSessionSuccess struct");

      decltype(Traits::xr_internals_listener(input)) in_xr_internals_listener = Traits::xr_internals_listener(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::WebXrInternalsRendererListenerInterfaceBase>>(
        in_xr_internals_listener,
        &fragment->xr_internals_listener,
        &fragment.message());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRFrameDataRequestOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRFrameDataRequestOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRFrameDataRequestOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->include_lighting_estimation_data = Traits::include_lighting_estimation_data(input);

      fragment->depth_active = Traits::depth_active(input);

      fragment->stage_parameters_id = Traits::stage_parameters_id(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRNativeOriginInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::XRNativeOriginInformationDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::XRNativeOriginInformation_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::XRNativeOriginInformationDataView::Tag::kInputSourceSpaceInfo: {
    decltype(Traits::input_source_space_info(input))
    in_input_source_space_info = Traits::input_source_space_info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_input_source_space_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::XRInputSourceSpaceInfoDataView, send_validation>(
  in_input_source_space_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null input_source_space_info in XRNativeOriginInformation union");
    fragment->data.f_input_source_space_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::XRNativeOriginInformationDataView::Tag::kPlaneId: {
    decltype(Traits::plane_id(input))
    in_plane_id = Traits::plane_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_plane_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::PlaneIdDataView, send_validation>(
  in_plane_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null plane_id in XRNativeOriginInformation union");
    fragment->data.f_plane_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::XRNativeOriginInformationDataView::Tag::kAnchorId: {
    decltype(Traits::anchor_id(input))
    in_anchor_id = Traits::anchor_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_anchor_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::AnchorIdDataView, send_validation>(
  in_anchor_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null anchor_id in XRNativeOriginInformation union");
    fragment->data.f_anchor_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::XRNativeOriginInformationDataView::Tag::kReferenceSpaceType: {
    decltype(Traits::reference_space_type(input))
    in_reference_space_type = Traits::reference_space_type(input);
        
mojo::internal::Serialize<::device::mojom::XRReferenceSpaceType, send_validation>(
  in_reference_space_type,
  &fragment->data.f_reference_space_type);
    break;
  }
  case ::device::mojom::XRNativeOriginInformationDataView::Tag::kHandJointSpaceInfo: {
    decltype(Traits::hand_joint_space_info(input))
    in_hand_joint_space_info = Traits::hand_joint_space_info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_hand_joint_space_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::XRHandJointSpaceInfoDataView, send_validation>(
  in_hand_joint_space_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null hand_joint_space_info in XRNativeOriginInformation union");
    fragment->data.f_hand_joint_space_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::XRNativeOriginInformationDataView::Tag::kImageIndex: {
    decltype(Traits::image_index(input))
    in_image_index = Traits::image_index(input);
    fragment->data.f_image_index = in_image_index;
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::XRDepthDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::XRDepthDataDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::XRDepthData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::XRDepthDataDataView::Tag::kDataStillValid: {
    decltype(Traits::data_still_valid(input))
    in_data_still_valid = Traits::data_still_valid(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data_still_valid)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::XRDepthDataStillValidDataView, send_validation>(
  in_data_still_valid,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data_still_valid in XRDepthData union");
    fragment->data.f_data_still_valid.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::XRDepthDataDataView::Tag::kUpdatedDepthData: {
    decltype(Traits::updated_depth_data(input))
    in_updated_depth_data = Traits::updated_depth_data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_updated_depth_data)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::XRDepthDataUpdatedDataView, send_validation>(
  in_updated_depth_data,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null updated_depth_data in XRDepthData union");
    fragment->data.f_updated_depth_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::RequestSessionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::RequestSessionResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::RequestSessionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::RequestSessionResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::RequestSessionSuccessDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in RequestSessionResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::RequestSessionResultDataView::Tag::kFailureReason: {
    decltype(Traits::failure_reason(input))
    in_failure_reason = Traits::failure_reason(input);
        
mojo::internal::Serialize<::device::mojom::RequestSessionError, send_validation>(
  in_failure_reason,
  &fragment->data.f_failure_reason);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_SEND_VALIDATION_H_