// device/gamepad/public/mojom/gamepad.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_TEST_UTILS_H_
#define DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_TEST_UTILS_H_

#include "device/gamepad/public/mojom/gamepad.mojom.h"
#include "base/component_export.h"


namespace device::mojom {


class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadObserverInterceptorForTesting : public GamepadObserver {
  virtual GamepadObserver* GetForwardingInterface() = 0;
  void GamepadConnected(uint32_t index, const ::device::Gamepad& gamepad) override;
  void GamepadDisconnected(uint32_t index, const ::device::Gamepad& gamepad) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadObserverAsyncWaiter {
 public:
  explicit GamepadObserverAsyncWaiter(GamepadObserver* proxy);

  GamepadObserverAsyncWaiter(const GamepadObserverAsyncWaiter&) = delete;
  GamepadObserverAsyncWaiter& operator=(const GamepadObserverAsyncWaiter&) = delete;

  ~GamepadObserverAsyncWaiter();

 private:
  GamepadObserver* const proxy_;
};


class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitorInterceptorForTesting : public GamepadMonitor {
  virtual GamepadMonitor* GetForwardingInterface() = 0;
  void GamepadStartPolling(GamepadStartPollingCallback callback) override;
  void GamepadStopPolling(GamepadStopPollingCallback callback) override;
  void SetObserver(::mojo::PendingRemote<GamepadObserver> gamepad_observer) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadMonitorAsyncWaiter {
 public:
  explicit GamepadMonitorAsyncWaiter(GamepadMonitor* proxy);

  GamepadMonitorAsyncWaiter(const GamepadMonitorAsyncWaiter&) = delete;
  GamepadMonitorAsyncWaiter& operator=(const GamepadMonitorAsyncWaiter&) = delete;

  ~GamepadMonitorAsyncWaiter();
  void GamepadStartPolling(
      ::base::ReadOnlySharedMemoryRegion* out_memory_region);
  ::base::ReadOnlySharedMemoryRegion GamepadStartPolling();
  void GamepadStopPolling(
      );
  

 private:
  GamepadMonitor* const proxy_;
};


class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManagerInterceptorForTesting : public GamepadHapticsManager {
  virtual GamepadHapticsManager* GetForwardingInterface() = 0;
  void PlayVibrationEffectOnce(uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params, PlayVibrationEffectOnceCallback callback) override;
  void ResetVibrationActuator(uint32_t pad_index, ResetVibrationActuatorCallback callback) override;
};
class COMPONENT_EXPORT(GAMEPAD_MOJOM) GamepadHapticsManagerAsyncWaiter {
 public:
  explicit GamepadHapticsManagerAsyncWaiter(GamepadHapticsManager* proxy);

  GamepadHapticsManagerAsyncWaiter(const GamepadHapticsManagerAsyncWaiter&) = delete;
  GamepadHapticsManagerAsyncWaiter& operator=(const GamepadHapticsManagerAsyncWaiter&) = delete;

  ~GamepadHapticsManagerAsyncWaiter();
  void PlayVibrationEffectOnce(
      uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params, GamepadHapticsResult* out_result);
  GamepadHapticsResult PlayVibrationEffectOnce(uint32_t pad_index, GamepadHapticEffectType type, GamepadEffectParametersPtr params);
  void ResetVibrationActuator(
      uint32_t pad_index, GamepadHapticsResult* out_result);
  GamepadHapticsResult ResetVibrationActuator(uint32_t pad_index);

 private:
  GamepadHapticsManager* const proxy_;
};




}  // device::mojom

#endif  // DEVICE_GAMEPAD_PUBLIC_MOJOM_GAMEPAD_MOJOM_TEST_UTILS_H_