// device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_GATT_CHARACTERISTIC_PROPERTIES_MOJOM_BLINK_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_GATT_CHARACTERISTIC_PROPERTIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-features.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-shared.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace bluetooth::mojom::blink {








class  GattCharacteristicProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GattCharacteristicProperties, T>::value>;
  using DataView = GattCharacteristicPropertiesDataView;
  using Data_ = internal::GattCharacteristicProperties_Data;

  template <typename... Args>
  static GattCharacteristicPropertiesPtr New(Args&&... args) {
    return GattCharacteristicPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GattCharacteristicPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<GattCharacteristicPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GattCharacteristicProperties>::Convert(*this);
  }


  GattCharacteristicProperties();

  GattCharacteristicProperties(
      bool broadcast,
      bool read,
      bool write_without_response,
      bool write,
      bool notify,
      bool indicate,
      bool authenticated_signed_writes,
      bool extended_properties,
      bool reliable_write,
      bool writable_auxiliaries,
      bool read_encrypted,
      bool write_encrypted,
      bool read_encrypted_authenticated,
      bool write_encrypted_authenticated);


  ~GattCharacteristicProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GattCharacteristicPropertiesPtr>
  GattCharacteristicPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GattCharacteristicProperties::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GattCharacteristicProperties::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GattCharacteristicProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GattCharacteristicProperties_UnserializedMessageContext<
            UserType, GattCharacteristicProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GattCharacteristicProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GattCharacteristicProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GattCharacteristicProperties_UnserializedMessageContext<
            UserType, GattCharacteristicProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GattCharacteristicProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool broadcast;
  
  bool read;
  
  bool write_without_response;
  
  bool write;
  
  bool notify;
  
  bool indicate;
  
  bool authenticated_signed_writes;
  
  bool extended_properties;
  
  bool reliable_write;
  
  bool writable_auxiliaries;
  
  bool read_encrypted;
  
  bool write_encrypted;
  
  bool read_encrypted_authenticated;
  
  bool write_encrypted_authenticated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GattCharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GattCharacteristicPropertiesPtr GattCharacteristicProperties::Clone() const {
  return New(
      mojo::Clone(broadcast),
      mojo::Clone(read),
      mojo::Clone(write_without_response),
      mojo::Clone(write),
      mojo::Clone(notify),
      mojo::Clone(indicate),
      mojo::Clone(authenticated_signed_writes),
      mojo::Clone(extended_properties),
      mojo::Clone(reliable_write),
      mojo::Clone(writable_auxiliaries),
      mojo::Clone(read_encrypted),
      mojo::Clone(write_encrypted),
      mojo::Clone(read_encrypted_authenticated),
      mojo::Clone(write_encrypted_authenticated)
  );
}

template <typename T, GattCharacteristicProperties::EnableIfSame<T>*>
bool GattCharacteristicProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->broadcast, other_struct.broadcast))
    return false;
  if (!mojo::Equals(this->read, other_struct.read))
    return false;
  if (!mojo::Equals(this->write_without_response, other_struct.write_without_response))
    return false;
  if (!mojo::Equals(this->write, other_struct.write))
    return false;
  if (!mojo::Equals(this->notify, other_struct.notify))
    return false;
  if (!mojo::Equals(this->indicate, other_struct.indicate))
    return false;
  if (!mojo::Equals(this->authenticated_signed_writes, other_struct.authenticated_signed_writes))
    return false;
  if (!mojo::Equals(this->extended_properties, other_struct.extended_properties))
    return false;
  if (!mojo::Equals(this->reliable_write, other_struct.reliable_write))
    return false;
  if (!mojo::Equals(this->writable_auxiliaries, other_struct.writable_auxiliaries))
    return false;
  if (!mojo::Equals(this->read_encrypted, other_struct.read_encrypted))
    return false;
  if (!mojo::Equals(this->write_encrypted, other_struct.write_encrypted))
    return false;
  if (!mojo::Equals(this->read_encrypted_authenticated, other_struct.read_encrypted_authenticated))
    return false;
  if (!mojo::Equals(this->write_encrypted_authenticated, other_struct.write_encrypted_authenticated))
    return false;
  return true;
}

template <typename T, GattCharacteristicProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.broadcast < rhs.broadcast)
    return true;
  if (rhs.broadcast < lhs.broadcast)
    return false;
  if (lhs.read < rhs.read)
    return true;
  if (rhs.read < lhs.read)
    return false;
  if (lhs.write_without_response < rhs.write_without_response)
    return true;
  if (rhs.write_without_response < lhs.write_without_response)
    return false;
  if (lhs.write < rhs.write)
    return true;
  if (rhs.write < lhs.write)
    return false;
  if (lhs.notify < rhs.notify)
    return true;
  if (rhs.notify < lhs.notify)
    return false;
  if (lhs.indicate < rhs.indicate)
    return true;
  if (rhs.indicate < lhs.indicate)
    return false;
  if (lhs.authenticated_signed_writes < rhs.authenticated_signed_writes)
    return true;
  if (rhs.authenticated_signed_writes < lhs.authenticated_signed_writes)
    return false;
  if (lhs.extended_properties < rhs.extended_properties)
    return true;
  if (rhs.extended_properties < lhs.extended_properties)
    return false;
  if (lhs.reliable_write < rhs.reliable_write)
    return true;
  if (rhs.reliable_write < lhs.reliable_write)
    return false;
  if (lhs.writable_auxiliaries < rhs.writable_auxiliaries)
    return true;
  if (rhs.writable_auxiliaries < lhs.writable_auxiliaries)
    return false;
  if (lhs.read_encrypted < rhs.read_encrypted)
    return true;
  if (rhs.read_encrypted < lhs.read_encrypted)
    return false;
  if (lhs.write_encrypted < rhs.write_encrypted)
    return true;
  if (rhs.write_encrypted < lhs.write_encrypted)
    return false;
  if (lhs.read_encrypted_authenticated < rhs.read_encrypted_authenticated)
    return true;
  if (rhs.read_encrypted_authenticated < lhs.read_encrypted_authenticated)
    return false;
  if (lhs.write_encrypted_authenticated < rhs.write_encrypted_authenticated)
    return true;
  if (rhs.write_encrypted_authenticated < lhs.write_encrypted_authenticated)
    return false;
  return false;
}


}  // bluetooth::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::bluetooth::mojom::blink::GattCharacteristicProperties::DataView,
                                         ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr> {
  static bool IsNull(const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr* output) { output->reset(); }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::broadcast) broadcast(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->broadcast;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::read) read(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->read;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::write_without_response) write_without_response(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->write_without_response;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::write) write(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->write;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::notify) notify(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->notify;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::indicate) indicate(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->indicate;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::authenticated_signed_writes) authenticated_signed_writes(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->authenticated_signed_writes;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::extended_properties) extended_properties(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->extended_properties;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::reliable_write) reliable_write(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->reliable_write;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::writable_auxiliaries) writable_auxiliaries(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->writable_auxiliaries;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::read_encrypted) read_encrypted(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->read_encrypted;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::write_encrypted) write_encrypted(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->write_encrypted;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::read_encrypted_authenticated) read_encrypted_authenticated(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->read_encrypted_authenticated;
  }

  static decltype(::bluetooth::mojom::blink::GattCharacteristicProperties::write_encrypted_authenticated) write_encrypted_authenticated(
      const ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr& input) {
    return input->write_encrypted_authenticated;
  }

  static bool Read(::bluetooth::mojom::blink::GattCharacteristicProperties::DataView input, ::bluetooth::mojom::blink::GattCharacteristicPropertiesPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_GATT_CHARACTERISTIC_PROPERTIES_MOJOM_BLINK_H_