// device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-features.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/uuid.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "device/bluetooth/public/mojom/emulation/fake_bluetooth_mojom_traits.h"




namespace bluetooth::mojom {

class FakeBluetoothProxy;

template <typename ImplRefTraits>
class FakeBluetoothStub;

class FakeBluetoothRequestValidator;
class FakeBluetoothResponseValidator;


class FakeBluetooth
    : public FakeBluetoothInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.FakeBluetooth";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FakeBluetoothInterfaceBase;
  using Proxy_ = FakeBluetoothProxy;

  template <typename ImplRefTraits>
  using Stub_ = FakeBluetoothStub<ImplRefTraits>;

  using RequestValidator_ = FakeBluetoothRequestValidator;
  using ResponseValidator_ = FakeBluetoothResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetLESupportedMinVersion = 0,
    kSimulateCentralMinVersion = 0,
    kAllResponsesConsumedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetLESupported_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateCentral_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllResponsesConsumed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FakeBluetooth() = default;

  using SetLESupportedCallback = base::OnceCallback<void()>;
  using SetLESupportedMojoCallback = base::OnceCallback<void()>;

  virtual void SetLESupported(bool available, SetLESupportedCallback callback) = 0;

  using SimulateCentralCallback = base::OnceCallback<void(::mojo::PendingRemote<FakeCentral>)>;
  using SimulateCentralMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<FakeCentral>)>;

  virtual void SimulateCentral(CentralState state, SimulateCentralCallback callback) = 0;

  using AllResponsesConsumedCallback = base::OnceCallback<void(bool)>;
  using AllResponsesConsumedMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AllResponsesConsumed(AllResponsesConsumedCallback callback) = 0;
};

class FakeCentralProxy;

template <typename ImplRefTraits>
class FakeCentralStub;

class FakeCentralRequestValidator;
class FakeCentralResponseValidator;


class FakeCentral
    : public FakeCentralInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.FakeCentral";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FakeCentralInterfaceBase;
  using Proxy_ = FakeCentralProxy;

  template <typename ImplRefTraits>
  using Stub_ = FakeCentralStub<ImplRefTraits>;

  using RequestValidator_ = FakeCentralRequestValidator;
  using ResponseValidator_ = FakeCentralResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSimulatePreconnectedPeripheralMinVersion = 0,
    kSimulateAdvertisementReceivedMinVersion = 0,
    kSetStateMinVersion = 0,
    kSetNextGATTConnectionResponseMinVersion = 0,
    kSetNextGATTDiscoveryResponseMinVersion = 0,
    kSimulateGATTOperationResponseMinVersion = 0,
    kSimulateGATTDisconnectionMinVersion = 0,
    kSimulateGATTServicesChangedMinVersion = 0,
    kSimulateCharacteristicOperationResponseMinVersion = 0,
    kSimulateDescriptorOperationResponseMinVersion = 0,
    kAddFakeServiceMinVersion = 0,
    kRemoveFakeServiceMinVersion = 0,
    kAddFakeCharacteristicMinVersion = 0,
    kRemoveFakeCharacteristicMinVersion = 0,
    kAddFakeDescriptorMinVersion = 0,
    kRemoveFakeDescriptorMinVersion = 0,
    kSetNextReadCharacteristicResponseMinVersion = 0,
    kSetNextWriteCharacteristicResponseMinVersion = 0,
    kSetNextSubscribeToNotificationsResponseMinVersion = 0,
    kSetNextUnsubscribeFromNotificationsResponseMinVersion = 0,
    kIsNotifyingMinVersion = 0,
    kGetLastWrittenCharacteristicValueMinVersion = 0,
    kSetNextReadDescriptorResponseMinVersion = 0,
    kSetNextWriteDescriptorResponseMinVersion = 0,
    kGetLastWrittenDescriptorValueMinVersion = 0,
    kSetClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SimulatePreconnectedPeripheral_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateAdvertisementReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextGATTConnectionResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextGATTDiscoveryResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateGATTOperationResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateGATTDisconnection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateGATTServicesChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateCharacteristicOperationResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateDescriptorOperationResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFakeService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveFakeService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFakeCharacteristic_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveFakeCharacteristic_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFakeDescriptor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveFakeDescriptor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextReadCharacteristicResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextWriteCharacteristicResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextSubscribeToNotificationsResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextUnsubscribeFromNotificationsResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsNotifying_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLastWrittenCharacteristicValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextReadDescriptorResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNextWriteDescriptorResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLastWrittenDescriptorValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FakeCentral() = default;

  using SimulatePreconnectedPeripheralCallback = base::OnceCallback<void()>;
  using SimulatePreconnectedPeripheralMojoCallback = base::OnceCallback<void()>;

  virtual void SimulatePreconnectedPeripheral(const std::string& address, const std::string& name, const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data, const std::vector<::device::BluetoothUUID>& known_service_uuids, SimulatePreconnectedPeripheralCallback callback) = 0;

  using SimulateAdvertisementReceivedCallback = base::OnceCallback<void()>;
  using SimulateAdvertisementReceivedMojoCallback = base::OnceCallback<void()>;

  virtual void SimulateAdvertisementReceived(ScanResultPtr result, SimulateAdvertisementReceivedCallback callback) = 0;

  using SetStateCallback = base::OnceCallback<void()>;
  using SetStateMojoCallback = base::OnceCallback<void()>;

  virtual void SetState(CentralState state, SetStateCallback callback) = 0;

  using SetNextGATTConnectionResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextGATTConnectionResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextGATTConnectionResponse(const std::string& address, uint16_t code, SetNextGATTConnectionResponseCallback callback) = 0;

  using SetNextGATTDiscoveryResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextGATTDiscoveryResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextGATTDiscoveryResponse(const std::string& address, uint16_t code, SetNextGATTDiscoveryResponseCallback callback) = 0;

  using SimulateGATTOperationResponseCallback = base::OnceCallback<void(bool)>;
  using SimulateGATTOperationResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SimulateGATTOperationResponse(GATTOperationType type, const std::string& address, uint16_t code, SimulateGATTOperationResponseCallback callback) = 0;

  using SimulateGATTDisconnectionCallback = base::OnceCallback<void(bool)>;
  using SimulateGATTDisconnectionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SimulateGATTDisconnection(const std::string& address, SimulateGATTDisconnectionCallback callback) = 0;

  using SimulateGATTServicesChangedCallback = base::OnceCallback<void(bool)>;
  using SimulateGATTServicesChangedMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SimulateGATTServicesChanged(const std::string& address, SimulateGATTServicesChangedCallback callback) = 0;

  using SimulateCharacteristicOperationResponseCallback = base::OnceCallback<void(bool)>;
  using SimulateCharacteristicOperationResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SimulateCharacteristicOperationResponse(CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateCharacteristicOperationResponseCallback callback) = 0;

  using SimulateDescriptorOperationResponseCallback = base::OnceCallback<void(bool)>;
  using SimulateDescriptorOperationResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SimulateDescriptorOperationResponse(DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateDescriptorOperationResponseCallback callback) = 0;

  using AddFakeServiceCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using AddFakeServiceMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void AddFakeService(const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid, AddFakeServiceCallback callback) = 0;

  using RemoveFakeServiceCallback = base::OnceCallback<void(bool)>;
  using RemoveFakeServiceMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveFakeService(const std::string& service_id, const std::string& peripheral_address, RemoveFakeServiceCallback callback) = 0;

  using AddFakeCharacteristicCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using AddFakeCharacteristicMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void AddFakeCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address, AddFakeCharacteristicCallback callback) = 0;

  using RemoveFakeCharacteristicCallback = base::OnceCallback<void(bool)>;
  using RemoveFakeCharacteristicMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveFakeCharacteristic(const std::string& identifier, const std::string& service_id, const std::string& peripheral_address, RemoveFakeCharacteristicCallback callback) = 0;

  using AddFakeDescriptorCallback = base::OnceCallback<void(const std::optional<std::string>&)>;
  using AddFakeDescriptorMojoCallback = base::OnceCallback<void(const std::optional<std::string>&)>;

  virtual void AddFakeDescriptor(const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, AddFakeDescriptorCallback callback) = 0;

  using RemoveFakeDescriptorCallback = base::OnceCallback<void(bool)>;
  using RemoveFakeDescriptorMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveFakeDescriptor(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, RemoveFakeDescriptorCallback callback) = 0;

  using SetNextReadCharacteristicResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextReadCharacteristicResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextReadCharacteristicResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadCharacteristicResponseCallback callback) = 0;

  using SetNextWriteCharacteristicResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextWriteCharacteristicResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextWriteCharacteristicResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteCharacteristicResponseCallback callback) = 0;

  using SetNextSubscribeToNotificationsResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextSubscribeToNotificationsResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextSubscribeToNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextSubscribeToNotificationsResponseCallback callback) = 0;

  using SetNextUnsubscribeFromNotificationsResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextUnsubscribeFromNotificationsResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextUnsubscribeFromNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextUnsubscribeFromNotificationsResponseCallback callback) = 0;

  using IsNotifyingCallback = base::OnceCallback<void(bool, bool)>;
  using IsNotifyingMojoCallback = base::OnceCallback<void(bool, bool)>;

  virtual void IsNotifying(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, IsNotifyingCallback callback) = 0;

  using GetLastWrittenCharacteristicValueCallback = base::OnceCallback<void(bool, const std::optional<std::vector<uint8_t>>&, WriteType)>;
  using GetLastWrittenCharacteristicValueMojoCallback = base::OnceCallback<void(bool, const std::optional<std::vector<uint8_t>>&, WriteType)>;

  virtual void GetLastWrittenCharacteristicValue(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenCharacteristicValueCallback callback) = 0;

  using SetNextReadDescriptorResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextReadDescriptorResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextReadDescriptorResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadDescriptorResponseCallback callback) = 0;

  using SetNextWriteDescriptorResponseCallback = base::OnceCallback<void(bool)>;
  using SetNextWriteDescriptorResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetNextWriteDescriptorResponse(uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteDescriptorResponseCallback callback) = 0;

  using GetLastWrittenDescriptorValueCallback = base::OnceCallback<void(bool, const std::optional<std::vector<uint8_t>>&)>;
  using GetLastWrittenDescriptorValueMojoCallback = base::OnceCallback<void(bool, const std::optional<std::vector<uint8_t>>&)>;

  virtual void GetLastWrittenDescriptorValue(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenDescriptorValueCallback callback) = 0;

  virtual void SetClient(::mojo::PendingAssociatedRemote<FakeCentralClient> client) = 0;
};

class FakeCentralClientProxy;

template <typename ImplRefTraits>
class FakeCentralClientStub;

class FakeCentralClientRequestValidator;


class FakeCentralClient
    : public FakeCentralClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.FakeCentralClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FakeCentralClientInterfaceBase;
  using Proxy_ = FakeCentralClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = FakeCentralClientStub<ImplRefTraits>;

  using RequestValidator_ = FakeCentralClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchGATTOperationEventMinVersion = 0,
    kDispatchCharacteristicOperationEventMinVersion = 0,
    kDispatchDescriptorOperationEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchGATTOperationEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchCharacteristicOperationEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchDescriptorOperationEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FakeCentralClient() = default;

  virtual void DispatchGATTOperationEvent(GATTOperationType type, const std::string& peripheral_address) = 0;

  virtual void DispatchCharacteristicOperationEvent(CharacteristicOperationType type, const std::optional<std::vector<uint8_t>>& data, std::optional<WriteType> write_type, const std::string& characteristic_id) = 0;

  virtual void DispatchDescriptorOperationEvent(DescriptorOperationType type, const std::optional<std::vector<uint8_t>>& data, const std::string& descriptor_id) = 0;
};



class  FakeBluetoothProxy
    : public FakeBluetooth {
 public:
  using InterfaceType = FakeBluetooth;

  explicit FakeBluetoothProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetLESupported(bool available, SetLESupportedCallback callback) final;
  
  void SimulateCentral(CentralState state, SimulateCentralCallback callback) final;
  
  void AllResponsesConsumed(AllResponsesConsumedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FakeCentralProxy
    : public FakeCentral {
 public:
  using InterfaceType = FakeCentral;

  explicit FakeCentralProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SimulatePreconnectedPeripheral(const std::string& address, const std::string& name, const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data, const std::vector<::device::BluetoothUUID>& known_service_uuids, SimulatePreconnectedPeripheralCallback callback) final;
  
  void SimulateAdvertisementReceived(ScanResultPtr result, SimulateAdvertisementReceivedCallback callback) final;
  
  void SetState(CentralState state, SetStateCallback callback) final;
  
  void SetNextGATTConnectionResponse(const std::string& address, uint16_t code, SetNextGATTConnectionResponseCallback callback) final;
  
  void SetNextGATTDiscoveryResponse(const std::string& address, uint16_t code, SetNextGATTDiscoveryResponseCallback callback) final;
  
  void SimulateGATTOperationResponse(GATTOperationType type, const std::string& address, uint16_t code, SimulateGATTOperationResponseCallback callback) final;
  
  void SimulateGATTDisconnection(const std::string& address, SimulateGATTDisconnectionCallback callback) final;
  
  void SimulateGATTServicesChanged(const std::string& address, SimulateGATTServicesChangedCallback callback) final;
  
  void SimulateCharacteristicOperationResponse(CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateCharacteristicOperationResponseCallback callback) final;
  
  void SimulateDescriptorOperationResponse(DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateDescriptorOperationResponseCallback callback) final;
  
  void AddFakeService(const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid, AddFakeServiceCallback callback) final;
  
  void RemoveFakeService(const std::string& service_id, const std::string& peripheral_address, RemoveFakeServiceCallback callback) final;
  
  void AddFakeCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address, AddFakeCharacteristicCallback callback) final;
  
  void RemoveFakeCharacteristic(const std::string& identifier, const std::string& service_id, const std::string& peripheral_address, RemoveFakeCharacteristicCallback callback) final;
  
  void AddFakeDescriptor(const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, AddFakeDescriptorCallback callback) final;
  
  void RemoveFakeDescriptor(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, RemoveFakeDescriptorCallback callback) final;
  
  void SetNextReadCharacteristicResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadCharacteristicResponseCallback callback) final;
  
  void SetNextWriteCharacteristicResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteCharacteristicResponseCallback callback) final;
  
  void SetNextSubscribeToNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextSubscribeToNotificationsResponseCallback callback) final;
  
  void SetNextUnsubscribeFromNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextUnsubscribeFromNotificationsResponseCallback callback) final;
  
  void IsNotifying(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, IsNotifyingCallback callback) final;
  
  void GetLastWrittenCharacteristicValue(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenCharacteristicValueCallback callback) final;
  
  void SetNextReadDescriptorResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadDescriptorResponseCallback callback) final;
  
  void SetNextWriteDescriptorResponse(uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteDescriptorResponseCallback callback) final;
  
  void GetLastWrittenDescriptorValue(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenDescriptorValueCallback callback) final;
  
  void SetClient(::mojo::PendingAssociatedRemote<FakeCentralClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FakeCentralClientProxy
    : public FakeCentralClient {
 public:
  using InterfaceType = FakeCentralClient;

  explicit FakeCentralClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchGATTOperationEvent(GATTOperationType type, const std::string& peripheral_address) final;
  
  void DispatchCharacteristicOperationEvent(CharacteristicOperationType type, const std::optional<std::vector<uint8_t>>& data, std::optional<WriteType> write_type, const std::string& characteristic_id) final;
  
  void DispatchDescriptorOperationEvent(DescriptorOperationType type, const std::optional<std::vector<uint8_t>>& data, const std::string& descriptor_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FakeBluetoothStubDispatch {
 public:
  static bool Accept(FakeBluetooth* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FakeBluetooth* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FakeBluetooth>>
class FakeBluetoothStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FakeBluetoothStub() = default;
  ~FakeBluetoothStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FakeBluetoothStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FakeBluetoothStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FakeCentralStubDispatch {
 public:
  static bool Accept(FakeCentral* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FakeCentral* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FakeCentral>>
class FakeCentralStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FakeCentralStub() = default;
  ~FakeCentralStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FakeCentralStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FakeCentralStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FakeCentralClientStubDispatch {
 public:
  static bool Accept(FakeCentralClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FakeCentralClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FakeCentralClient>>
class FakeCentralClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FakeCentralClientStub() = default;
  ~FakeCentralClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FakeCentralClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FakeCentralClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FakeBluetoothRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FakeCentralRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FakeCentralClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FakeBluetoothResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FakeCentralResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  Appearance {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Appearance, T>::value>;
  using DataView = AppearanceDataView;
  using Data_ = internal::Appearance_Data;

  template <typename... Args>
  static AppearancePtr New(Args&&... args) {
    return AppearancePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppearancePtr From(const U& u) {
    return mojo::TypeConverter<AppearancePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Appearance>::Convert(*this);
  }


  Appearance();

  Appearance(
      bool has_value,
      int8_t value);


  ~Appearance();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppearancePtr>
  AppearancePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Appearance::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Appearance::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Appearance::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Appearance::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Appearance::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Appearance::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Appearance_UnserializedMessageContext<
            UserType, Appearance::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Appearance::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Appearance::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Appearance_UnserializedMessageContext<
            UserType, Appearance::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Appearance::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_value;
  
  int8_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Appearance::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Appearance::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Appearance::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Appearance::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Power {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Power, T>::value>;
  using DataView = PowerDataView;
  using Data_ = internal::Power_Data;

  template <typename... Args>
  static PowerPtr New(Args&&... args) {
    return PowerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PowerPtr From(const U& u) {
    return mojo::TypeConverter<PowerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Power>::Convert(*this);
  }


  Power();

  Power(
      bool has_value,
      int8_t value);


  ~Power();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PowerPtr>
  PowerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Power::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Power::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Power::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Power::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Power::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Power::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Power_UnserializedMessageContext<
            UserType, Power::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Power::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Power::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Power_UnserializedMessageContext<
            UserType, Power::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Power::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_value;
  
  int8_t value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Power::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Power::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Power::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Power::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class  ServiceDataMap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceDataMap, T>::value>;
  using DataView = ServiceDataMapDataView;
  using Data_ = internal::ServiceDataMap_Data;

  template <typename... Args>
  static ServiceDataMapPtr New(Args&&... args) {
    return ServiceDataMapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceDataMapPtr From(const U& u) {
    return mojo::TypeConverter<ServiceDataMapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceDataMap>::Convert(*this);
  }


  ServiceDataMap();

  explicit ServiceDataMap(
      const base::flat_map<std::string, std::vector<uint8_t>>& service_data);


  ~ServiceDataMap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceDataMapPtr>
  ServiceDataMapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceDataMap::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceDataMap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceDataMap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceDataMap_UnserializedMessageContext<
            UserType, ServiceDataMap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceDataMap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceDataMap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceDataMap_UnserializedMessageContext<
            UserType, ServiceDataMap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceDataMap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<std::string, std::vector<uint8_t>> service_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceDataMap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScanRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScanRecord, T>::value>;
  using DataView = ScanRecordDataView;
  using Data_ = internal::ScanRecord_Data;

  template <typename... Args>
  static ScanRecordPtr New(Args&&... args) {
    return ScanRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScanRecordPtr From(const U& u) {
    return mojo::TypeConverter<ScanRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScanRecord>::Convert(*this);
  }


  ScanRecord();

  ScanRecord(
      const std::optional<std::string>& name,
      std::optional<std::vector<::device::BluetoothUUID>> uuids,
      AppearancePtr appearance,
      PowerPtr tx_power,
      const std::optional<base::flat_map<uint16_t, std::vector<uint8_t>>>& manufacturer_data,
      const std::optional<::device::BluetoothDevice::ServiceDataMap>& service_data);

ScanRecord(const ScanRecord&) = delete;
ScanRecord& operator=(const ScanRecord&) = delete;

  ~ScanRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScanRecordPtr>
  ScanRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScanRecord::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScanRecord::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScanRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScanRecord_UnserializedMessageContext<
            UserType, ScanRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScanRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScanRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScanRecord_UnserializedMessageContext<
            UserType, ScanRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScanRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> name;
  
  std::optional<std::vector<::device::BluetoothUUID>> uuids;
  
  AppearancePtr appearance;
  
  PowerPtr tx_power;
  
  std::optional<base::flat_map<uint16_t, std::vector<uint8_t>>> manufacturer_data;
  
  std::optional<::device::BluetoothDevice::ServiceDataMap> service_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScanRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ScanResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScanResult, T>::value>;
  using DataView = ScanResultDataView;
  using Data_ = internal::ScanResult_Data;

  template <typename... Args>
  static ScanResultPtr New(Args&&... args) {
    return ScanResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScanResultPtr From(const U& u) {
    return mojo::TypeConverter<ScanResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScanResult>::Convert(*this);
  }


  ScanResult();

  ScanResult(
      const std::string& device_address,
      int8_t rssi,
      ScanRecordPtr scan_record);

ScanResult(const ScanResult&) = delete;
ScanResult& operator=(const ScanResult&) = delete;

  ~ScanResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScanResultPtr>
  ScanResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScanResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScanResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScanResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScanResult_UnserializedMessageContext<
            UserType, ScanResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScanResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScanResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScanResult_UnserializedMessageContext<
            UserType, ScanResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScanResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string device_address;
  
  int8_t rssi;
  
  ScanRecordPtr scan_record;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScanResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CharacteristicProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CharacteristicProperties, T>::value>;
  using DataView = CharacteristicPropertiesDataView;
  using Data_ = internal::CharacteristicProperties_Data;

  template <typename... Args>
  static CharacteristicPropertiesPtr New(Args&&... args) {
    return CharacteristicPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CharacteristicPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<CharacteristicPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CharacteristicProperties>::Convert(*this);
  }


  CharacteristicProperties();

  CharacteristicProperties(
      bool broadcast,
      bool read,
      bool write_without_response,
      bool write,
      bool notify,
      bool indicate,
      bool authenticated_signed_writes,
      bool extended_properties);


  ~CharacteristicProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CharacteristicPropertiesPtr>
  CharacteristicPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CharacteristicProperties::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CharacteristicProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CharacteristicProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CharacteristicProperties_UnserializedMessageContext<
            UserType, CharacteristicProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CharacteristicProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CharacteristicProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CharacteristicProperties_UnserializedMessageContext<
            UserType, CharacteristicProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CharacteristicProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool broadcast;
  
  bool read;
  
  bool write_without_response;
  
  bool write;
  
  bool notify;
  
  bool indicate;
  
  bool authenticated_signed_writes;
  
  bool extended_properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CharacteristicProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AppearancePtr Appearance::Clone() const {
  return New(
      mojo::Clone(has_value),
      mojo::Clone(value)
  );
}

template <typename T, Appearance::EnableIfSame<T>*>
bool Appearance::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_value, other_struct.has_value))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, Appearance::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_value < rhs.has_value)
    return true;
  if (rhs.has_value < lhs.has_value)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
PowerPtr Power::Clone() const {
  return New(
      mojo::Clone(has_value),
      mojo::Clone(value)
  );
}

template <typename T, Power::EnableIfSame<T>*>
bool Power::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_value, other_struct.has_value))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, Power::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_value < rhs.has_value)
    return true;
  if (rhs.has_value < lhs.has_value)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceDataMapPtr ServiceDataMap::Clone() const {
  return New(
      mojo::Clone(service_data)
  );
}

template <typename T, ServiceDataMap::EnableIfSame<T>*>
bool ServiceDataMap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->service_data, other_struct.service_data))
    return false;
  return true;
}

template <typename T, ServiceDataMap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.service_data < rhs.service_data)
    return true;
  if (rhs.service_data < lhs.service_data)
    return false;
  return false;
}
template <typename StructPtrType>
ScanRecordPtr ScanRecord::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(uuids),
      mojo::Clone(appearance),
      mojo::Clone(tx_power),
      mojo::Clone(manufacturer_data),
      mojo::Clone(service_data)
  );
}

template <typename T, ScanRecord::EnableIfSame<T>*>
bool ScanRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->uuids, other_struct.uuids))
    return false;
  if (!mojo::Equals(this->appearance, other_struct.appearance))
    return false;
  if (!mojo::Equals(this->tx_power, other_struct.tx_power))
    return false;
  if (!mojo::Equals(this->manufacturer_data, other_struct.manufacturer_data))
    return false;
  if (!mojo::Equals(this->service_data, other_struct.service_data))
    return false;
  return true;
}

template <typename T, ScanRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.uuids < rhs.uuids)
    return true;
  if (rhs.uuids < lhs.uuids)
    return false;
  if (lhs.appearance < rhs.appearance)
    return true;
  if (rhs.appearance < lhs.appearance)
    return false;
  if (lhs.tx_power < rhs.tx_power)
    return true;
  if (rhs.tx_power < lhs.tx_power)
    return false;
  if (lhs.manufacturer_data < rhs.manufacturer_data)
    return true;
  if (rhs.manufacturer_data < lhs.manufacturer_data)
    return false;
  if (lhs.service_data < rhs.service_data)
    return true;
  if (rhs.service_data < lhs.service_data)
    return false;
  return false;
}
template <typename StructPtrType>
ScanResultPtr ScanResult::Clone() const {
  return New(
      mojo::Clone(device_address),
      mojo::Clone(rssi),
      mojo::Clone(scan_record)
  );
}

template <typename T, ScanResult::EnableIfSame<T>*>
bool ScanResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_address, other_struct.device_address))
    return false;
  if (!mojo::Equals(this->rssi, other_struct.rssi))
    return false;
  if (!mojo::Equals(this->scan_record, other_struct.scan_record))
    return false;
  return true;
}

template <typename T, ScanResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_address < rhs.device_address)
    return true;
  if (rhs.device_address < lhs.device_address)
    return false;
  if (lhs.rssi < rhs.rssi)
    return true;
  if (rhs.rssi < lhs.rssi)
    return false;
  if (lhs.scan_record < rhs.scan_record)
    return true;
  if (rhs.scan_record < lhs.scan_record)
    return false;
  return false;
}
template <typename StructPtrType>
CharacteristicPropertiesPtr CharacteristicProperties::Clone() const {
  return New(
      mojo::Clone(broadcast),
      mojo::Clone(read),
      mojo::Clone(write_without_response),
      mojo::Clone(write),
      mojo::Clone(notify),
      mojo::Clone(indicate),
      mojo::Clone(authenticated_signed_writes),
      mojo::Clone(extended_properties)
  );
}

template <typename T, CharacteristicProperties::EnableIfSame<T>*>
bool CharacteristicProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->broadcast, other_struct.broadcast))
    return false;
  if (!mojo::Equals(this->read, other_struct.read))
    return false;
  if (!mojo::Equals(this->write_without_response, other_struct.write_without_response))
    return false;
  if (!mojo::Equals(this->write, other_struct.write))
    return false;
  if (!mojo::Equals(this->notify, other_struct.notify))
    return false;
  if (!mojo::Equals(this->indicate, other_struct.indicate))
    return false;
  if (!mojo::Equals(this->authenticated_signed_writes, other_struct.authenticated_signed_writes))
    return false;
  if (!mojo::Equals(this->extended_properties, other_struct.extended_properties))
    return false;
  return true;
}

template <typename T, CharacteristicProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.broadcast < rhs.broadcast)
    return true;
  if (rhs.broadcast < lhs.broadcast)
    return false;
  if (lhs.read < rhs.read)
    return true;
  if (rhs.read < lhs.read)
    return false;
  if (lhs.write_without_response < rhs.write_without_response)
    return true;
  if (rhs.write_without_response < lhs.write_without_response)
    return false;
  if (lhs.write < rhs.write)
    return true;
  if (rhs.write < lhs.write)
    return false;
  if (lhs.notify < rhs.notify)
    return true;
  if (rhs.notify < lhs.notify)
    return false;
  if (lhs.indicate < rhs.indicate)
    return true;
  if (rhs.indicate < lhs.indicate)
    return false;
  if (lhs.authenticated_signed_writes < rhs.authenticated_signed_writes)
    return true;
  if (rhs.authenticated_signed_writes < lhs.authenticated_signed_writes)
    return false;
  if (lhs.extended_properties < rhs.extended_properties)
    return true;
  if (rhs.extended_properties < lhs.extended_properties)
    return false;
  return false;
}


}  // bluetooth::mojom

namespace mojo {


template <>
struct  StructTraits<::bluetooth::mojom::Appearance::DataView,
                                         ::bluetooth::mojom::AppearancePtr> {
  static bool IsNull(const ::bluetooth::mojom::AppearancePtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::AppearancePtr* output) { output->reset(); }

  static decltype(::bluetooth::mojom::Appearance::has_value) has_value(
      const ::bluetooth::mojom::AppearancePtr& input) {
    return input->has_value;
  }

  static decltype(::bluetooth::mojom::Appearance::value) value(
      const ::bluetooth::mojom::AppearancePtr& input) {
    return input->value;
  }

  static bool Read(::bluetooth::mojom::Appearance::DataView input, ::bluetooth::mojom::AppearancePtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::Power::DataView,
                                         ::bluetooth::mojom::PowerPtr> {
  static bool IsNull(const ::bluetooth::mojom::PowerPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::PowerPtr* output) { output->reset(); }

  static decltype(::bluetooth::mojom::Power::has_value) has_value(
      const ::bluetooth::mojom::PowerPtr& input) {
    return input->has_value;
  }

  static decltype(::bluetooth::mojom::Power::value) value(
      const ::bluetooth::mojom::PowerPtr& input) {
    return input->value;
  }

  static bool Read(::bluetooth::mojom::Power::DataView input, ::bluetooth::mojom::PowerPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::ServiceDataMap::DataView,
                                         ::bluetooth::mojom::ServiceDataMapPtr> {
  static bool IsNull(const ::bluetooth::mojom::ServiceDataMapPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::ServiceDataMapPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::ServiceDataMap::service_data)& service_data(
      const ::bluetooth::mojom::ServiceDataMapPtr& input) {
    return input->service_data;
  }

  static bool Read(::bluetooth::mojom::ServiceDataMap::DataView input, ::bluetooth::mojom::ServiceDataMapPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::ScanRecord::DataView,
                                         ::bluetooth::mojom::ScanRecordPtr> {
  static bool IsNull(const ::bluetooth::mojom::ScanRecordPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::ScanRecordPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::ScanRecord::name)& name(
      const ::bluetooth::mojom::ScanRecordPtr& input) {
    return input->name;
  }

  static const decltype(::bluetooth::mojom::ScanRecord::uuids)& uuids(
      const ::bluetooth::mojom::ScanRecordPtr& input) {
    return input->uuids;
  }

  static const decltype(::bluetooth::mojom::ScanRecord::appearance)& appearance(
      const ::bluetooth::mojom::ScanRecordPtr& input) {
    return input->appearance;
  }

  static const decltype(::bluetooth::mojom::ScanRecord::tx_power)& tx_power(
      const ::bluetooth::mojom::ScanRecordPtr& input) {
    return input->tx_power;
  }

  static const decltype(::bluetooth::mojom::ScanRecord::manufacturer_data)& manufacturer_data(
      const ::bluetooth::mojom::ScanRecordPtr& input) {
    return input->manufacturer_data;
  }

  static const decltype(::bluetooth::mojom::ScanRecord::service_data)& service_data(
      const ::bluetooth::mojom::ScanRecordPtr& input) {
    return input->service_data;
  }

  static bool Read(::bluetooth::mojom::ScanRecord::DataView input, ::bluetooth::mojom::ScanRecordPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::ScanResult::DataView,
                                         ::bluetooth::mojom::ScanResultPtr> {
  static bool IsNull(const ::bluetooth::mojom::ScanResultPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::ScanResultPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::ScanResult::device_address)& device_address(
      const ::bluetooth::mojom::ScanResultPtr& input) {
    return input->device_address;
  }

  static decltype(::bluetooth::mojom::ScanResult::rssi) rssi(
      const ::bluetooth::mojom::ScanResultPtr& input) {
    return input->rssi;
  }

  static const decltype(::bluetooth::mojom::ScanResult::scan_record)& scan_record(
      const ::bluetooth::mojom::ScanResultPtr& input) {
    return input->scan_record;
  }

  static bool Read(::bluetooth::mojom::ScanResult::DataView input, ::bluetooth::mojom::ScanResultPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::CharacteristicProperties::DataView,
                                         ::bluetooth::mojom::CharacteristicPropertiesPtr> {
  static bool IsNull(const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::CharacteristicPropertiesPtr* output) { output->reset(); }

  static decltype(::bluetooth::mojom::CharacteristicProperties::broadcast) broadcast(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->broadcast;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::read) read(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->read;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::write_without_response) write_without_response(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->write_without_response;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::write) write(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->write;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::notify) notify(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->notify;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::indicate) indicate(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->indicate;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::authenticated_signed_writes) authenticated_signed_writes(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->authenticated_signed_writes;
  }

  static decltype(::bluetooth::mojom::CharacteristicProperties::extended_properties) extended_properties(
      const ::bluetooth::mojom::CharacteristicPropertiesPtr& input) {
    return input->extended_properties;
  }

  static bool Read(::bluetooth::mojom::CharacteristicProperties::DataView input, ::bluetooth::mojom::CharacteristicPropertiesPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_EMULATION_FAKE_BLUETOOTH_MOJOM_H_