// device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-params-data.h"
#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-shared-message-ids.h"

#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-import-headers.h"
#include "device/bluetooth/public/mojom/emulation/fake_bluetooth.mojom-test-utils.h"


namespace bluetooth::mojom {
Appearance::Appearance()
    : has_value(),
      value() {}

Appearance::Appearance(
    bool has_value_in,
    int8_t value_in)
    : has_value(std::move(has_value_in)),
      value(std::move(value_in)) {}

Appearance::~Appearance() = default;
size_t Appearance::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->has_value);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void Appearance::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_value"), this->has_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Appearance::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Power::Power()
    : has_value(),
      value() {}

Power::Power(
    bool has_value_in,
    int8_t value_in)
    : has_value(std::move(has_value_in)),
      value(std::move(value_in)) {}

Power::~Power() = default;
size_t Power::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->has_value);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void Power::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_value"), this->has_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Power::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceDataMap::ServiceDataMap()
    : service_data() {}

ServiceDataMap::ServiceDataMap(
    const base::flat_map<std::string, std::vector<uint8_t>>& service_data_in)
    : service_data(std::move(service_data_in)) {}

ServiceDataMap::~ServiceDataMap() = default;

void ServiceDataMap::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_data"), this->service_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceDataMap::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScanRecord::ScanRecord()
    : name(),
      uuids(),
      appearance(),
      tx_power(),
      manufacturer_data(),
      service_data() {}

ScanRecord::ScanRecord(
    const std::optional<std::string>& name_in,
    std::optional<std::vector<::device::BluetoothUUID>> uuids_in,
    AppearancePtr appearance_in,
    PowerPtr tx_power_in,
    const std::optional<base::flat_map<uint16_t, std::vector<uint8_t>>>& manufacturer_data_in,
    const std::optional<::device::BluetoothDevice::ServiceDataMap>& service_data_in)
    : name(std::move(name_in)),
      uuids(std::move(uuids_in)),
      appearance(std::move(appearance_in)),
      tx_power(std::move(tx_power_in)),
      manufacturer_data(std::move(manufacturer_data_in)),
      service_data(std::move(service_data_in)) {}

ScanRecord::~ScanRecord() = default;

void ScanRecord::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uuids"), this->uuids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::device::BluetoothUUID>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appearance"), this->appearance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AppearancePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tx_power"), this->tx_power,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PowerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manufacturer_data"), this->manufacturer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<uint16_t, std::vector<uint8_t>>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "service_data"), this->service_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::device::BluetoothDevice::ServiceDataMap>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScanRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScanResult::ScanResult()
    : device_address(),
      rssi(),
      scan_record() {}

ScanResult::ScanResult(
    const std::string& device_address_in,
    int8_t rssi_in,
    ScanRecordPtr scan_record_in)
    : device_address(std::move(device_address_in)),
      rssi(std::move(rssi_in)),
      scan_record(std::move(scan_record_in)) {}

ScanResult::~ScanResult() = default;

void ScanResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_address"), this->device_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rssi"), this->rssi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scan_record"), this->scan_record,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScanRecordPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScanResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CharacteristicProperties::CharacteristicProperties()
    : broadcast(),
      read(),
      write_without_response(),
      write(),
      notify(),
      indicate(),
      authenticated_signed_writes(),
      extended_properties() {}

CharacteristicProperties::CharacteristicProperties(
    bool broadcast_in,
    bool read_in,
    bool write_without_response_in,
    bool write_in,
    bool notify_in,
    bool indicate_in,
    bool authenticated_signed_writes_in,
    bool extended_properties_in)
    : broadcast(std::move(broadcast_in)),
      read(std::move(read_in)),
      write_without_response(std::move(write_without_response_in)),
      write(std::move(write_in)),
      notify(std::move(notify_in)),
      indicate(std::move(indicate_in)),
      authenticated_signed_writes(std::move(authenticated_signed_writes_in)),
      extended_properties(std::move(extended_properties_in)) {}

CharacteristicProperties::~CharacteristicProperties() = default;
size_t CharacteristicProperties::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->broadcast);
  seed = mojo::internal::Hash(seed, this->read);
  seed = mojo::internal::Hash(seed, this->write_without_response);
  seed = mojo::internal::Hash(seed, this->write);
  seed = mojo::internal::Hash(seed, this->notify);
  seed = mojo::internal::Hash(seed, this->indicate);
  seed = mojo::internal::Hash(seed, this->authenticated_signed_writes);
  seed = mojo::internal::Hash(seed, this->extended_properties);
  return seed;
}

void CharacteristicProperties::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "broadcast"), this->broadcast,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read"), this->read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "write_without_response"), this->write_without_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "write"), this->write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "notify"), this->notify,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indicate"), this->indicate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticated_signed_writes"), this->authenticated_signed_writes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extended_properties"), this->extended_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CharacteristicProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FakeBluetooth::IPCStableHashFunction FakeBluetooth::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FakeBluetooth>(message.name())) {
    case messages::FakeBluetooth::kSetLESupported: {
      return &FakeBluetooth::SetLESupported_Sym::IPCStableHash;
    }
    case messages::FakeBluetooth::kSimulateCentral: {
      return &FakeBluetooth::SimulateCentral_Sym::IPCStableHash;
    }
    case messages::FakeBluetooth::kAllResponsesConsumed: {
      return &FakeBluetooth::AllResponsesConsumed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FakeBluetooth::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FakeBluetooth>(message.name())) {
      case messages::FakeBluetooth::kSetLESupported:
            return "Receive bluetooth::mojom::FakeBluetooth::SetLESupported";
      case messages::FakeBluetooth::kSimulateCentral:
            return "Receive bluetooth::mojom::FakeBluetooth::SimulateCentral";
      case messages::FakeBluetooth::kAllResponsesConsumed:
            return "Receive bluetooth::mojom::FakeBluetooth::AllResponsesConsumed";
    }
  } else {
    switch (static_cast<messages::FakeBluetooth>(message.name())) {
      case messages::FakeBluetooth::kSetLESupported:
            return "Receive reply bluetooth::mojom::FakeBluetooth::SetLESupported";
      case messages::FakeBluetooth::kSimulateCentral:
            return "Receive reply bluetooth::mojom::FakeBluetooth::SimulateCentral";
      case messages::FakeBluetooth::kAllResponsesConsumed:
            return "Receive reply bluetooth::mojom::FakeBluetooth::AllResponsesConsumed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FakeBluetooth::SetLESupported_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4cdf226f;  // IPCStableHash for bluetooth::mojom::FakeBluetooth::SetLESupported
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeBluetooth::SimulateCentral_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0707a5d7;  // IPCStableHash for bluetooth::mojom::FakeBluetooth::SimulateCentral
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeBluetooth::AllResponsesConsumed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x935a778f;  // IPCStableHash for bluetooth::mojom::FakeBluetooth::AllResponsesConsumed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FakeBluetooth_SetLESupported_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeBluetooth_SetLESupported_ForwardToCallback(
      FakeBluetooth::SetLESupportedCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeBluetooth_SetLESupported_ForwardToCallback(const FakeBluetooth_SetLESupported_ForwardToCallback&) = delete;
  FakeBluetooth_SetLESupported_ForwardToCallback& operator=(const FakeBluetooth_SetLESupported_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeBluetooth::SetLESupportedCallback callback_;
};

class FakeBluetooth_SimulateCentral_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeBluetooth_SimulateCentral_ForwardToCallback(
      FakeBluetooth::SimulateCentralCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeBluetooth_SimulateCentral_ForwardToCallback(const FakeBluetooth_SimulateCentral_ForwardToCallback&) = delete;
  FakeBluetooth_SimulateCentral_ForwardToCallback& operator=(const FakeBluetooth_SimulateCentral_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeBluetooth::SimulateCentralCallback callback_;
};

class FakeBluetooth_AllResponsesConsumed_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeBluetooth_AllResponsesConsumed_ForwardToCallback(
      FakeBluetooth::AllResponsesConsumedCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeBluetooth_AllResponsesConsumed_ForwardToCallback(const FakeBluetooth_AllResponsesConsumed_ForwardToCallback&) = delete;
  FakeBluetooth_AllResponsesConsumed_ForwardToCallback& operator=(const FakeBluetooth_AllResponsesConsumed_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeBluetooth::AllResponsesConsumedCallback callback_;
};

FakeBluetoothProxy::FakeBluetoothProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FakeBluetoothProxy::SetLESupported(
    bool in_available, SetLESupportedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeBluetooth::SetLESupported", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeBluetooth::kSetLESupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeBluetooth_SetLESupported_Params_Data> params(
          message);
  params.Allocate();

  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeBluetooth::Name_);
  message.set_method_name("SetLESupported");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeBluetooth_SetLESupported_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeBluetoothProxy::SimulateCentral(
    CentralState in_state, SimulateCentralCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeBluetooth::SimulateCentral", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type CentralState>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeBluetooth::kSimulateCentral), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeBluetooth_SimulateCentral_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::CentralState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeBluetooth::Name_);
  message.set_method_name("SimulateCentral");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeBluetooth_SimulateCentral_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeBluetoothProxy::AllResponsesConsumed(
    AllResponsesConsumedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send bluetooth::mojom::FakeBluetooth::AllResponsesConsumed");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeBluetooth::kAllResponsesConsumed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeBluetooth_AllResponsesConsumed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeBluetooth::Name_);
  message.set_method_name("AllResponsesConsumed");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeBluetooth_AllResponsesConsumed_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FakeBluetooth_SetLESupported_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeBluetooth::SetLESupportedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeBluetooth_SetLESupported_ProxyToResponder> proxy(
        new FakeBluetooth_SetLESupported_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeBluetooth_SetLESupported_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeBluetooth_SetLESupported_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeBluetooth_SetLESupported_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeBluetooth::SetLESupportedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FakeBluetooth_SetLESupported_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeBluetooth_SetLESupported_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeBluetooth_SetLESupported_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeBluetooth.0
  bool success = true;
  FakeBluetooth_SetLESupported_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeBluetooth::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FakeBluetooth_SetLESupported_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::FakeBluetooth::SetLESupported");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeBluetooth::kSetLESupported), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeBluetooth_SetLESupported_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeBluetooth::Name_);
  message.set_method_name("SetLESupported");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeBluetooth_SimulateCentral_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeBluetooth::SimulateCentralCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeBluetooth_SimulateCentral_ProxyToResponder> proxy(
        new FakeBluetooth_SimulateCentral_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeBluetooth_SimulateCentral_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeBluetooth_SimulateCentral_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeBluetooth_SimulateCentral_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeBluetooth::SimulateCentralCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<FakeCentral> in_fake_central);
};

bool FakeBluetooth_SimulateCentral_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeBluetooth_SimulateCentral_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeBluetooth_SimulateCentral_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeBluetooth.1
  bool success = true;
  ::mojo::PendingRemote<FakeCentral> p_fake_central{};
  FakeBluetooth_SimulateCentral_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_fake_central =
        input_data_view.TakeFakeCentral<decltype(p_fake_central)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeBluetooth::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_fake_central));
  }
  return true;
}

void FakeBluetooth_SimulateCentral_ProxyToResponder::Run(
    ::mojo::PendingRemote<FakeCentral> in_fake_central) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeBluetooth::SimulateCentral", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fake_central"), in_fake_central,
                        "<value of type ::mojo::PendingRemote<FakeCentral>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeBluetooth::kSimulateCentral), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeBluetooth_SimulateCentral_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::FakeCentralInterfaceBase>>(
    in_fake_central,
    &params->fake_central,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->fake_central)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid fake_central in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeBluetooth::Name_);
  message.set_method_name("SimulateCentral");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeBluetooth_AllResponsesConsumed_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeBluetooth::AllResponsesConsumedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeBluetooth_AllResponsesConsumed_ProxyToResponder> proxy(
        new FakeBluetooth_AllResponsesConsumed_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeBluetooth_AllResponsesConsumed_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeBluetooth_AllResponsesConsumed_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeBluetooth_AllResponsesConsumed_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeBluetooth::AllResponsesConsumedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_consumed);
};

bool FakeBluetooth_AllResponsesConsumed_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeBluetooth_AllResponsesConsumed_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeBluetooth_AllResponsesConsumed_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeBluetooth.2
  bool success = true;
  bool p_consumed{};
  FakeBluetooth_AllResponsesConsumed_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_consumed = input_data_view.consumed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeBluetooth::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_consumed));
  }
  return true;
}

void FakeBluetooth_AllResponsesConsumed_ProxyToResponder::Run(
    bool in_consumed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeBluetooth::AllResponsesConsumed", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumed"), in_consumed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeBluetooth::kAllResponsesConsumed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeBluetooth_AllResponsesConsumed_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->consumed = in_consumed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeBluetooth::Name_);
  message.set_method_name("AllResponsesConsumed");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FakeBluetoothStubDispatch::Accept(
    FakeBluetooth* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FakeBluetooth>(message->header()->name)) {
    case messages::FakeBluetooth::kSetLESupported: {
      break;
    }
    case messages::FakeBluetooth::kSimulateCentral: {
      break;
    }
    case messages::FakeBluetooth::kAllResponsesConsumed: {
      break;
    }
  }
  return false;
}

// static
bool FakeBluetoothStubDispatch::AcceptWithResponder(
    FakeBluetooth* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FakeBluetooth>(message->header()->name)) {
    case messages::FakeBluetooth::kSetLESupported: {
      internal::FakeBluetooth_SetLESupported_Params_Data* params =
          reinterpret_cast<
              internal::FakeBluetooth_SetLESupported_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeBluetooth.0
      bool success = true;
      bool p_available{};
      FakeBluetooth_SetLESupported_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_available = input_data_view.available();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeBluetooth::Name_, 0, false);
        return false;
      }
      auto callback =
          FakeBluetooth_SetLESupported_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLESupported(        
        std::move(p_available), std::move(callback));
      return true;
    }
    case messages::FakeBluetooth::kSimulateCentral: {
      internal::FakeBluetooth_SimulateCentral_Params_Data* params =
          reinterpret_cast<
              internal::FakeBluetooth_SimulateCentral_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeBluetooth.1
      bool success = true;
      CentralState p_state{};
      FakeBluetooth_SimulateCentral_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeBluetooth::Name_, 1, false);
        return false;
      }
      auto callback =
          FakeBluetooth_SimulateCentral_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateCentral(        
        std::move(p_state), std::move(callback));
      return true;
    }
    case messages::FakeBluetooth::kAllResponsesConsumed: {
      internal::FakeBluetooth_AllResponsesConsumed_Params_Data* params =
          reinterpret_cast<
              internal::FakeBluetooth_AllResponsesConsumed_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeBluetooth.2
      bool success = true;
      FakeBluetooth_AllResponsesConsumed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeBluetooth::Name_, 2, false);
        return false;
      }
      auto callback =
          FakeBluetooth_AllResponsesConsumed_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllResponsesConsumed(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFakeBluetoothValidationInfo[] = {
    { &internal::FakeBluetooth_SetLESupported_Params_Data::Validate,
     &internal::FakeBluetooth_SetLESupported_ResponseParams_Data::Validate},
    { &internal::FakeBluetooth_SimulateCentral_Params_Data::Validate,
     &internal::FakeBluetooth_SimulateCentral_ResponseParams_Data::Validate},
    { &internal::FakeBluetooth_AllResponsesConsumed_Params_Data::Validate,
     &internal::FakeBluetooth_AllResponsesConsumed_ResponseParams_Data::Validate},
};

bool FakeBluetoothRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::FakeBluetooth::Name_,
    kFakeBluetoothValidationInfo);
}

bool FakeBluetoothResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::FakeBluetooth::Name_,
    kFakeBluetoothValidationInfo);
}
// The declaration includes the definition on other builds.

FakeCentral::IPCStableHashFunction FakeCentral::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FakeCentral>(message.name())) {
    case messages::FakeCentral::kSimulatePreconnectedPeripheral: {
      return &FakeCentral::SimulatePreconnectedPeripheral_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSimulateAdvertisementReceived: {
      return &FakeCentral::SimulateAdvertisementReceived_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetState: {
      return &FakeCentral::SetState_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextGATTConnectionResponse: {
      return &FakeCentral::SetNextGATTConnectionResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextGATTDiscoveryResponse: {
      return &FakeCentral::SetNextGATTDiscoveryResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSimulateGATTOperationResponse: {
      return &FakeCentral::SimulateGATTOperationResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSimulateGATTDisconnection: {
      return &FakeCentral::SimulateGATTDisconnection_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSimulateGATTServicesChanged: {
      return &FakeCentral::SimulateGATTServicesChanged_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSimulateCharacteristicOperationResponse: {
      return &FakeCentral::SimulateCharacteristicOperationResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSimulateDescriptorOperationResponse: {
      return &FakeCentral::SimulateDescriptorOperationResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kAddFakeService: {
      return &FakeCentral::AddFakeService_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kRemoveFakeService: {
      return &FakeCentral::RemoveFakeService_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kAddFakeCharacteristic: {
      return &FakeCentral::AddFakeCharacteristic_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kRemoveFakeCharacteristic: {
      return &FakeCentral::RemoveFakeCharacteristic_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kAddFakeDescriptor: {
      return &FakeCentral::AddFakeDescriptor_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kRemoveFakeDescriptor: {
      return &FakeCentral::RemoveFakeDescriptor_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextReadCharacteristicResponse: {
      return &FakeCentral::SetNextReadCharacteristicResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextWriteCharacteristicResponse: {
      return &FakeCentral::SetNextWriteCharacteristicResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextSubscribeToNotificationsResponse: {
      return &FakeCentral::SetNextSubscribeToNotificationsResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse: {
      return &FakeCentral::SetNextUnsubscribeFromNotificationsResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kIsNotifying: {
      return &FakeCentral::IsNotifying_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kGetLastWrittenCharacteristicValue: {
      return &FakeCentral::GetLastWrittenCharacteristicValue_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextReadDescriptorResponse: {
      return &FakeCentral::SetNextReadDescriptorResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetNextWriteDescriptorResponse: {
      return &FakeCentral::SetNextWriteDescriptorResponse_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kGetLastWrittenDescriptorValue: {
      return &FakeCentral::GetLastWrittenDescriptorValue_Sym::IPCStableHash;
    }
    case messages::FakeCentral::kSetClient: {
      return &FakeCentral::SetClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FakeCentral::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FakeCentral>(message.name())) {
      case messages::FakeCentral::kSimulatePreconnectedPeripheral:
            return "Receive bluetooth::mojom::FakeCentral::SimulatePreconnectedPeripheral";
      case messages::FakeCentral::kSimulateAdvertisementReceived:
            return "Receive bluetooth::mojom::FakeCentral::SimulateAdvertisementReceived";
      case messages::FakeCentral::kSetState:
            return "Receive bluetooth::mojom::FakeCentral::SetState";
      case messages::FakeCentral::kSetNextGATTConnectionResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextGATTConnectionResponse";
      case messages::FakeCentral::kSetNextGATTDiscoveryResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextGATTDiscoveryResponse";
      case messages::FakeCentral::kSimulateGATTOperationResponse:
            return "Receive bluetooth::mojom::FakeCentral::SimulateGATTOperationResponse";
      case messages::FakeCentral::kSimulateGATTDisconnection:
            return "Receive bluetooth::mojom::FakeCentral::SimulateGATTDisconnection";
      case messages::FakeCentral::kSimulateGATTServicesChanged:
            return "Receive bluetooth::mojom::FakeCentral::SimulateGATTServicesChanged";
      case messages::FakeCentral::kSimulateCharacteristicOperationResponse:
            return "Receive bluetooth::mojom::FakeCentral::SimulateCharacteristicOperationResponse";
      case messages::FakeCentral::kSimulateDescriptorOperationResponse:
            return "Receive bluetooth::mojom::FakeCentral::SimulateDescriptorOperationResponse";
      case messages::FakeCentral::kAddFakeService:
            return "Receive bluetooth::mojom::FakeCentral::AddFakeService";
      case messages::FakeCentral::kRemoveFakeService:
            return "Receive bluetooth::mojom::FakeCentral::RemoveFakeService";
      case messages::FakeCentral::kAddFakeCharacteristic:
            return "Receive bluetooth::mojom::FakeCentral::AddFakeCharacteristic";
      case messages::FakeCentral::kRemoveFakeCharacteristic:
            return "Receive bluetooth::mojom::FakeCentral::RemoveFakeCharacteristic";
      case messages::FakeCentral::kAddFakeDescriptor:
            return "Receive bluetooth::mojom::FakeCentral::AddFakeDescriptor";
      case messages::FakeCentral::kRemoveFakeDescriptor:
            return "Receive bluetooth::mojom::FakeCentral::RemoveFakeDescriptor";
      case messages::FakeCentral::kSetNextReadCharacteristicResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextReadCharacteristicResponse";
      case messages::FakeCentral::kSetNextWriteCharacteristicResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextWriteCharacteristicResponse";
      case messages::FakeCentral::kSetNextSubscribeToNotificationsResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextSubscribeToNotificationsResponse";
      case messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextUnsubscribeFromNotificationsResponse";
      case messages::FakeCentral::kIsNotifying:
            return "Receive bluetooth::mojom::FakeCentral::IsNotifying";
      case messages::FakeCentral::kGetLastWrittenCharacteristicValue:
            return "Receive bluetooth::mojom::FakeCentral::GetLastWrittenCharacteristicValue";
      case messages::FakeCentral::kSetNextReadDescriptorResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextReadDescriptorResponse";
      case messages::FakeCentral::kSetNextWriteDescriptorResponse:
            return "Receive bluetooth::mojom::FakeCentral::SetNextWriteDescriptorResponse";
      case messages::FakeCentral::kGetLastWrittenDescriptorValue:
            return "Receive bluetooth::mojom::FakeCentral::GetLastWrittenDescriptorValue";
      case messages::FakeCentral::kSetClient:
            return "Receive bluetooth::mojom::FakeCentral::SetClient";
    }
  } else {
    switch (static_cast<messages::FakeCentral>(message.name())) {
      case messages::FakeCentral::kSimulatePreconnectedPeripheral:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulatePreconnectedPeripheral";
      case messages::FakeCentral::kSimulateAdvertisementReceived:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulateAdvertisementReceived";
      case messages::FakeCentral::kSetState:
            return "Receive reply bluetooth::mojom::FakeCentral::SetState";
      case messages::FakeCentral::kSetNextGATTConnectionResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextGATTConnectionResponse";
      case messages::FakeCentral::kSetNextGATTDiscoveryResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextGATTDiscoveryResponse";
      case messages::FakeCentral::kSimulateGATTOperationResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulateGATTOperationResponse";
      case messages::FakeCentral::kSimulateGATTDisconnection:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulateGATTDisconnection";
      case messages::FakeCentral::kSimulateGATTServicesChanged:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulateGATTServicesChanged";
      case messages::FakeCentral::kSimulateCharacteristicOperationResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulateCharacteristicOperationResponse";
      case messages::FakeCentral::kSimulateDescriptorOperationResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SimulateDescriptorOperationResponse";
      case messages::FakeCentral::kAddFakeService:
            return "Receive reply bluetooth::mojom::FakeCentral::AddFakeService";
      case messages::FakeCentral::kRemoveFakeService:
            return "Receive reply bluetooth::mojom::FakeCentral::RemoveFakeService";
      case messages::FakeCentral::kAddFakeCharacteristic:
            return "Receive reply bluetooth::mojom::FakeCentral::AddFakeCharacteristic";
      case messages::FakeCentral::kRemoveFakeCharacteristic:
            return "Receive reply bluetooth::mojom::FakeCentral::RemoveFakeCharacteristic";
      case messages::FakeCentral::kAddFakeDescriptor:
            return "Receive reply bluetooth::mojom::FakeCentral::AddFakeDescriptor";
      case messages::FakeCentral::kRemoveFakeDescriptor:
            return "Receive reply bluetooth::mojom::FakeCentral::RemoveFakeDescriptor";
      case messages::FakeCentral::kSetNextReadCharacteristicResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextReadCharacteristicResponse";
      case messages::FakeCentral::kSetNextWriteCharacteristicResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextWriteCharacteristicResponse";
      case messages::FakeCentral::kSetNextSubscribeToNotificationsResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextSubscribeToNotificationsResponse";
      case messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextUnsubscribeFromNotificationsResponse";
      case messages::FakeCentral::kIsNotifying:
            return "Receive reply bluetooth::mojom::FakeCentral::IsNotifying";
      case messages::FakeCentral::kGetLastWrittenCharacteristicValue:
            return "Receive reply bluetooth::mojom::FakeCentral::GetLastWrittenCharacteristicValue";
      case messages::FakeCentral::kSetNextReadDescriptorResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextReadDescriptorResponse";
      case messages::FakeCentral::kSetNextWriteDescriptorResponse:
            return "Receive reply bluetooth::mojom::FakeCentral::SetNextWriteDescriptorResponse";
      case messages::FakeCentral::kGetLastWrittenDescriptorValue:
            return "Receive reply bluetooth::mojom::FakeCentral::GetLastWrittenDescriptorValue";
      case messages::FakeCentral::kSetClient:
            return "Receive reply bluetooth::mojom::FakeCentral::SetClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FakeCentral::SimulatePreconnectedPeripheral_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12a13383;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulatePreconnectedPeripheral
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SimulateAdvertisementReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0bfc798c;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulateAdvertisementReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a875daf;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextGATTConnectionResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3983100f;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextGATTConnectionResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextGATTDiscoveryResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4b1b6c68;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextGATTDiscoveryResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SimulateGATTOperationResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd78e6c8f;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulateGATTOperationResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SimulateGATTDisconnection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4c00212;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulateGATTDisconnection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SimulateGATTServicesChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdbe05ca4;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulateGATTServicesChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SimulateCharacteristicOperationResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8491b07;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulateCharacteristicOperationResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SimulateDescriptorOperationResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x535d06d7;  // IPCStableHash for bluetooth::mojom::FakeCentral::SimulateDescriptorOperationResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::AddFakeService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x143cffe7;  // IPCStableHash for bluetooth::mojom::FakeCentral::AddFakeService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::RemoveFakeService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x75bd805a;  // IPCStableHash for bluetooth::mojom::FakeCentral::RemoveFakeService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::AddFakeCharacteristic_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf0537bae;  // IPCStableHash for bluetooth::mojom::FakeCentral::AddFakeCharacteristic
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::RemoveFakeCharacteristic_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdbc2e951;  // IPCStableHash for bluetooth::mojom::FakeCentral::RemoveFakeCharacteristic
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::AddFakeDescriptor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4bf4787;  // IPCStableHash for bluetooth::mojom::FakeCentral::AddFakeDescriptor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::RemoveFakeDescriptor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3ba6e3a;  // IPCStableHash for bluetooth::mojom::FakeCentral::RemoveFakeDescriptor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextReadCharacteristicResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6689377;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextReadCharacteristicResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextWriteCharacteristicResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c0ff1fe;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextWriteCharacteristicResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextSubscribeToNotificationsResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe179de5a;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextSubscribeToNotificationsResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextUnsubscribeFromNotificationsResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9fab6c34;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextUnsubscribeFromNotificationsResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::IsNotifying_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3845d05;  // IPCStableHash for bluetooth::mojom::FakeCentral::IsNotifying
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::GetLastWrittenCharacteristicValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7d8dfc6;  // IPCStableHash for bluetooth::mojom::FakeCentral::GetLastWrittenCharacteristicValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextReadDescriptorResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb55304b2;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextReadDescriptorResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetNextWriteDescriptorResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41f7eb91;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetNextWriteDescriptorResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::GetLastWrittenDescriptorValue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa18dce44;  // IPCStableHash for bluetooth::mojom::FakeCentral::GetLastWrittenDescriptorValue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentral::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6375ad88;  // IPCStableHash for bluetooth::mojom::FakeCentral::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback(
      FakeCentral::SimulatePreconnectedPeripheralCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback(const FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback&) = delete;
  FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback& operator=(const FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulatePreconnectedPeripheralCallback callback_;
};

class FakeCentral_SimulateAdvertisementReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulateAdvertisementReceived_ForwardToCallback(
      FakeCentral::SimulateAdvertisementReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulateAdvertisementReceived_ForwardToCallback(const FakeCentral_SimulateAdvertisementReceived_ForwardToCallback&) = delete;
  FakeCentral_SimulateAdvertisementReceived_ForwardToCallback& operator=(const FakeCentral_SimulateAdvertisementReceived_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulateAdvertisementReceivedCallback callback_;
};

class FakeCentral_SetState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetState_ForwardToCallback(
      FakeCentral::SetStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetState_ForwardToCallback(const FakeCentral_SetState_ForwardToCallback&) = delete;
  FakeCentral_SetState_ForwardToCallback& operator=(const FakeCentral_SetState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetStateCallback callback_;
};

class FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback(
      FakeCentral::SetNextGATTConnectionResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback(const FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback& operator=(const FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextGATTConnectionResponseCallback callback_;
};

class FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback(
      FakeCentral::SetNextGATTDiscoveryResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback(const FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback& operator=(const FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextGATTDiscoveryResponseCallback callback_;
};

class FakeCentral_SimulateGATTOperationResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulateGATTOperationResponse_ForwardToCallback(
      FakeCentral::SimulateGATTOperationResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulateGATTOperationResponse_ForwardToCallback(const FakeCentral_SimulateGATTOperationResponse_ForwardToCallback&) = delete;
  FakeCentral_SimulateGATTOperationResponse_ForwardToCallback& operator=(const FakeCentral_SimulateGATTOperationResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulateGATTOperationResponseCallback callback_;
};

class FakeCentral_SimulateGATTDisconnection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulateGATTDisconnection_ForwardToCallback(
      FakeCentral::SimulateGATTDisconnectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulateGATTDisconnection_ForwardToCallback(const FakeCentral_SimulateGATTDisconnection_ForwardToCallback&) = delete;
  FakeCentral_SimulateGATTDisconnection_ForwardToCallback& operator=(const FakeCentral_SimulateGATTDisconnection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulateGATTDisconnectionCallback callback_;
};

class FakeCentral_SimulateGATTServicesChanged_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulateGATTServicesChanged_ForwardToCallback(
      FakeCentral::SimulateGATTServicesChangedCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulateGATTServicesChanged_ForwardToCallback(const FakeCentral_SimulateGATTServicesChanged_ForwardToCallback&) = delete;
  FakeCentral_SimulateGATTServicesChanged_ForwardToCallback& operator=(const FakeCentral_SimulateGATTServicesChanged_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulateGATTServicesChangedCallback callback_;
};

class FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback(
      FakeCentral::SimulateCharacteristicOperationResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback(const FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback&) = delete;
  FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback& operator=(const FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulateCharacteristicOperationResponseCallback callback_;
};

class FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback(
      FakeCentral::SimulateDescriptorOperationResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback(const FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback&) = delete;
  FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback& operator=(const FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SimulateDescriptorOperationResponseCallback callback_;
};

class FakeCentral_AddFakeService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_AddFakeService_ForwardToCallback(
      FakeCentral::AddFakeServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_AddFakeService_ForwardToCallback(const FakeCentral_AddFakeService_ForwardToCallback&) = delete;
  FakeCentral_AddFakeService_ForwardToCallback& operator=(const FakeCentral_AddFakeService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::AddFakeServiceCallback callback_;
};

class FakeCentral_RemoveFakeService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_RemoveFakeService_ForwardToCallback(
      FakeCentral::RemoveFakeServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_RemoveFakeService_ForwardToCallback(const FakeCentral_RemoveFakeService_ForwardToCallback&) = delete;
  FakeCentral_RemoveFakeService_ForwardToCallback& operator=(const FakeCentral_RemoveFakeService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::RemoveFakeServiceCallback callback_;
};

class FakeCentral_AddFakeCharacteristic_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_AddFakeCharacteristic_ForwardToCallback(
      FakeCentral::AddFakeCharacteristicCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_AddFakeCharacteristic_ForwardToCallback(const FakeCentral_AddFakeCharacteristic_ForwardToCallback&) = delete;
  FakeCentral_AddFakeCharacteristic_ForwardToCallback& operator=(const FakeCentral_AddFakeCharacteristic_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::AddFakeCharacteristicCallback callback_;
};

class FakeCentral_RemoveFakeCharacteristic_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_RemoveFakeCharacteristic_ForwardToCallback(
      FakeCentral::RemoveFakeCharacteristicCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_RemoveFakeCharacteristic_ForwardToCallback(const FakeCentral_RemoveFakeCharacteristic_ForwardToCallback&) = delete;
  FakeCentral_RemoveFakeCharacteristic_ForwardToCallback& operator=(const FakeCentral_RemoveFakeCharacteristic_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::RemoveFakeCharacteristicCallback callback_;
};

class FakeCentral_AddFakeDescriptor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_AddFakeDescriptor_ForwardToCallback(
      FakeCentral::AddFakeDescriptorCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_AddFakeDescriptor_ForwardToCallback(const FakeCentral_AddFakeDescriptor_ForwardToCallback&) = delete;
  FakeCentral_AddFakeDescriptor_ForwardToCallback& operator=(const FakeCentral_AddFakeDescriptor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::AddFakeDescriptorCallback callback_;
};

class FakeCentral_RemoveFakeDescriptor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_RemoveFakeDescriptor_ForwardToCallback(
      FakeCentral::RemoveFakeDescriptorCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_RemoveFakeDescriptor_ForwardToCallback(const FakeCentral_RemoveFakeDescriptor_ForwardToCallback&) = delete;
  FakeCentral_RemoveFakeDescriptor_ForwardToCallback& operator=(const FakeCentral_RemoveFakeDescriptor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::RemoveFakeDescriptorCallback callback_;
};

class FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback(
      FakeCentral::SetNextReadCharacteristicResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback(const FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback& operator=(const FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextReadCharacteristicResponseCallback callback_;
};

class FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback(
      FakeCentral::SetNextWriteCharacteristicResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback(const FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback& operator=(const FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextWriteCharacteristicResponseCallback callback_;
};

class FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback(
      FakeCentral::SetNextSubscribeToNotificationsResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback(const FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback& operator=(const FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextSubscribeToNotificationsResponseCallback callback_;
};

class FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback(
      FakeCentral::SetNextUnsubscribeFromNotificationsResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback(const FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback& operator=(const FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextUnsubscribeFromNotificationsResponseCallback callback_;
};

class FakeCentral_IsNotifying_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_IsNotifying_ForwardToCallback(
      FakeCentral::IsNotifyingCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_IsNotifying_ForwardToCallback(const FakeCentral_IsNotifying_ForwardToCallback&) = delete;
  FakeCentral_IsNotifying_ForwardToCallback& operator=(const FakeCentral_IsNotifying_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::IsNotifyingCallback callback_;
};

class FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback(
      FakeCentral::GetLastWrittenCharacteristicValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback(const FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback&) = delete;
  FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback& operator=(const FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::GetLastWrittenCharacteristicValueCallback callback_;
};

class FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback(
      FakeCentral::SetNextReadDescriptorResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback(const FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback& operator=(const FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextReadDescriptorResponseCallback callback_;
};

class FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback(
      FakeCentral::SetNextWriteDescriptorResponseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback(const FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback&) = delete;
  FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback& operator=(const FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::SetNextWriteDescriptorResponseCallback callback_;
};

class FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback(
      FakeCentral::GetLastWrittenDescriptorValueCallback callback
      ) : callback_(std::move(callback)) {
  }

  FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback(const FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback&) = delete;
  FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback& operator=(const FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FakeCentral::GetLastWrittenDescriptorValueCallback callback_;
};

FakeCentralProxy::FakeCentralProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FakeCentralProxy::SimulatePreconnectedPeripheral(
    const std::string& in_address, const std::string& in_name, const base::flat_map<uint16_t, std::vector<uint8_t>>& in_manufacturer_data, const std::vector<::device::BluetoothUUID>& in_known_service_uuids, SimulatePreconnectedPeripheralCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulatePreconnectedPeripheral", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manufacturer_data"), in_manufacturer_data,
                        "<value of type const base::flat_map<uint16_t, std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("known_service_uuids"), in_known_service_uuids,
                        "<value of type const std::vector<::device::BluetoothUUID>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulatePreconnectedPeripheral), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulatePreconnectedPeripheral_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in FakeCentral.SimulatePreconnectedPeripheral request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in FakeCentral.SimulatePreconnectedPeripheral request");
  mojo::internal::MessageFragment<
      typename decltype(params->manufacturer_data)::BaseType>
      manufacturer_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& manufacturer_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<uint16_t, mojo::ArrayDataView<uint8_t>>>(
    in_manufacturer_data,
    manufacturer_data_fragment,
    &manufacturer_data_validate_params);

  params->manufacturer_data.Set(
      manufacturer_data_fragment.is_null() ? nullptr : manufacturer_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manufacturer_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manufacturer_data in FakeCentral.SimulatePreconnectedPeripheral request");
  mojo::internal::MessageFragment<
      typename decltype(params->known_service_uuids)::BaseType>
      known_service_uuids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& known_service_uuids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::bluetooth::mojom::UUIDDataView>>(
    in_known_service_uuids,
    known_service_uuids_fragment,
    &known_service_uuids_validate_params);

  params->known_service_uuids.Set(
      known_service_uuids_fragment.is_null() ? nullptr : known_service_uuids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->known_service_uuids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null known_service_uuids in FakeCentral.SimulatePreconnectedPeripheral request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulatePreconnectedPeripheral");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SimulateAdvertisementReceived(
    ScanResultPtr in_result, SimulateAdvertisementReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulateAdvertisementReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ScanResultPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateAdvertisementReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateAdvertisementReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::ScanResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in FakeCentral.SimulateAdvertisementReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateAdvertisementReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulateAdvertisementReceived_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetState(
    CentralState in_state, SetStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type CentralState>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::CentralState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextGATTConnectionResponse(
    const std::string& in_address, uint16_t in_code, SetNextGATTConnectionResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextGATTConnectionResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextGATTConnectionResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextGATTConnectionResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in FakeCentral.SetNextGATTConnectionResponse request");

  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextGATTConnectionResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextGATTDiscoveryResponse(
    const std::string& in_address, uint16_t in_code, SetNextGATTDiscoveryResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextGATTDiscoveryResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextGATTDiscoveryResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextGATTDiscoveryResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in FakeCentral.SetNextGATTDiscoveryResponse request");

  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextGATTDiscoveryResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SimulateGATTOperationResponse(
    GATTOperationType in_type, const std::string& in_address, uint16_t in_code, SimulateGATTOperationResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulateGATTOperationResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type GATTOperationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateGATTOperationResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateGATTOperationResponse_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::GATTOperationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in FakeCentral.SimulateGATTOperationResponse request");

  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateGATTOperationResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulateGATTOperationResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SimulateGATTDisconnection(
    const std::string& in_address, SimulateGATTDisconnectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulateGATTDisconnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateGATTDisconnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateGATTDisconnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in FakeCentral.SimulateGATTDisconnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateGATTDisconnection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulateGATTDisconnection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SimulateGATTServicesChanged(
    const std::string& in_address, SimulateGATTServicesChangedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulateGATTServicesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address"), in_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateGATTServicesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateGATTServicesChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->address)::BaseType> address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_address,
    address_fragment);

  params->address.Set(
      address_fragment.is_null() ? nullptr : address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null address in FakeCentral.SimulateGATTServicesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateGATTServicesChanged");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulateGATTServicesChanged_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SimulateCharacteristicOperationResponse(
    CharacteristicOperationType in_type, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, uint16_t in_code, const std::optional<std::vector<uint8_t>>& in_data, SimulateCharacteristicOperationResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulateCharacteristicOperationResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type CharacteristicOperationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateCharacteristicOperationResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateCharacteristicOperationResponse_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::CharacteristicOperationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SimulateCharacteristicOperationResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SimulateCharacteristicOperationResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SimulateCharacteristicOperationResponse request");

  params->code = in_code;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateCharacteristicOperationResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SimulateDescriptorOperationResponse(
    DescriptorOperationType in_type, const std::string& in_descriptor_id, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, uint16_t in_code, const std::optional<std::vector<uint8_t>>& in_data, SimulateDescriptorOperationResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SimulateDescriptorOperationResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type DescriptorOperationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateDescriptorOperationResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateDescriptorOperationResponse_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::DescriptorOperationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in FakeCentral.SimulateDescriptorOperationResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SimulateDescriptorOperationResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SimulateDescriptorOperationResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SimulateDescriptorOperationResponse request");

  params->code = in_code;
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateDescriptorOperationResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::AddFakeService(
    const std::string& in_peripheral_address, const ::device::BluetoothUUID& in_service_uuid, AddFakeServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::AddFakeService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_uuid"), in_service_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kAddFakeService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_AddFakeService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.AddFakeService request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_uuid)::BaseType> service_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_service_uuid,
    service_uuid_fragment);

  params->service_uuid.Set(
      service_uuid_fragment.is_null() ? nullptr : service_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_uuid in FakeCentral.AddFakeService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("AddFakeService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_AddFakeService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::RemoveFakeService(
    const std::string& in_service_id, const std::string& in_peripheral_address, RemoveFakeServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::RemoveFakeService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kRemoveFakeService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_RemoveFakeService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.RemoveFakeService request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.RemoveFakeService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("RemoveFakeService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_RemoveFakeService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::AddFakeCharacteristic(
    const ::device::BluetoothUUID& in_characteristic_uuid, CharacteristicPropertiesPtr in_properties, const std::string& in_service_id, const std::string& in_peripheral_address, AddFakeCharacteristicCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::AddFakeCharacteristic", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_uuid"), in_characteristic_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type CharacteristicPropertiesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kAddFakeCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_AddFakeCharacteristic_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_uuid)::BaseType> characteristic_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_characteristic_uuid,
    characteristic_uuid_fragment);

  params->characteristic_uuid.Set(
      characteristic_uuid_fragment.is_null() ? nullptr : characteristic_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_uuid in FakeCentral.AddFakeCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::CharacteristicPropertiesDataView>(
    in_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in FakeCentral.AddFakeCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.AddFakeCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.AddFakeCharacteristic request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("AddFakeCharacteristic");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_AddFakeCharacteristic_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::RemoveFakeCharacteristic(
    const std::string& in_identifier, const std::string& in_service_id, const std::string& in_peripheral_address, RemoveFakeCharacteristicCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::RemoveFakeCharacteristic", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identifier"), in_identifier,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kRemoveFakeCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_RemoveFakeCharacteristic_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identifier)::BaseType> identifier_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_identifier,
    identifier_fragment);

  params->identifier.Set(
      identifier_fragment.is_null() ? nullptr : identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identifier in FakeCentral.RemoveFakeCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.RemoveFakeCharacteristic request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.RemoveFakeCharacteristic request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("RemoveFakeCharacteristic");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_RemoveFakeCharacteristic_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::AddFakeDescriptor(
    const ::device::BluetoothUUID& in_descriptor_uuid, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, AddFakeDescriptorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::AddFakeDescriptor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_uuid"), in_descriptor_uuid,
                        "<value of type const ::device::BluetoothUUID&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kAddFakeDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_AddFakeDescriptor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_uuid)::BaseType> descriptor_uuid_fragment(
          params.message());
  
  mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView>(
    in_descriptor_uuid,
    descriptor_uuid_fragment);

  params->descriptor_uuid.Set(
      descriptor_uuid_fragment.is_null() ? nullptr : descriptor_uuid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_uuid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_uuid in FakeCentral.AddFakeDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.AddFakeDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.AddFakeDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.AddFakeDescriptor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("AddFakeDescriptor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_AddFakeDescriptor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::RemoveFakeDescriptor(
    const std::string& in_descriptor_id, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, RemoveFakeDescriptorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::RemoveFakeDescriptor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kRemoveFakeDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_RemoveFakeDescriptor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in FakeCentral.RemoveFakeDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.RemoveFakeDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.RemoveFakeDescriptor request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.RemoveFakeDescriptor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("RemoveFakeDescriptor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_RemoveFakeDescriptor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextReadCharacteristicResponse(
    uint16_t in_gatt_code, const std::optional<std::vector<uint8_t>>& in_value, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, SetNextReadCharacteristicResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextReadCharacteristicResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_code"), in_gatt_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextReadCharacteristicResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextReadCharacteristicResponse_Params_Data> params(
          message);
  params.Allocate();

  params->gatt_code = in_gatt_code;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SetNextReadCharacteristicResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SetNextReadCharacteristicResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SetNextReadCharacteristicResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextReadCharacteristicResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextWriteCharacteristicResponse(
    uint16_t in_gatt_code, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, SetNextWriteCharacteristicResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextWriteCharacteristicResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_code"), in_gatt_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextWriteCharacteristicResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextWriteCharacteristicResponse_Params_Data> params(
          message);
  params.Allocate();

  params->gatt_code = in_gatt_code;
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SetNextWriteCharacteristicResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SetNextWriteCharacteristicResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SetNextWriteCharacteristicResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextWriteCharacteristicResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextSubscribeToNotificationsResponse(
    uint16_t in_gatt_code, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, SetNextSubscribeToNotificationsResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextSubscribeToNotificationsResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_code"), in_gatt_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextSubscribeToNotificationsResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data> params(
          message);
  params.Allocate();

  params->gatt_code = in_gatt_code;
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SetNextSubscribeToNotificationsResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SetNextSubscribeToNotificationsResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SetNextSubscribeToNotificationsResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextSubscribeToNotificationsResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextUnsubscribeFromNotificationsResponse(
    uint16_t in_gatt_code, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, SetNextUnsubscribeFromNotificationsResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextUnsubscribeFromNotificationsResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_code"), in_gatt_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data> params(
          message);
  params.Allocate();

  params->gatt_code = in_gatt_code;
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SetNextUnsubscribeFromNotificationsResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SetNextUnsubscribeFromNotificationsResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SetNextUnsubscribeFromNotificationsResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextUnsubscribeFromNotificationsResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::IsNotifying(
    const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, IsNotifyingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::IsNotifying", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kIsNotifying), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_IsNotifying_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.IsNotifying request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.IsNotifying request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.IsNotifying request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("IsNotifying");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_IsNotifying_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::GetLastWrittenCharacteristicValue(
    const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, GetLastWrittenCharacteristicValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::GetLastWrittenCharacteristicValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kGetLastWrittenCharacteristicValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_GetLastWrittenCharacteristicValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.GetLastWrittenCharacteristicValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.GetLastWrittenCharacteristicValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.GetLastWrittenCharacteristicValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("GetLastWrittenCharacteristicValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextReadDescriptorResponse(
    uint16_t in_gatt_code, const std::optional<std::vector<uint8_t>>& in_value, const std::string& in_descriptor_id, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, SetNextReadDescriptorResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextReadDescriptorResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_code"), in_gatt_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextReadDescriptorResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextReadDescriptorResponse_Params_Data> params(
          message);
  params.Allocate();

  params->gatt_code = in_gatt_code;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in FakeCentral.SetNextReadDescriptorResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SetNextReadDescriptorResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SetNextReadDescriptorResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SetNextReadDescriptorResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextReadDescriptorResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetNextWriteDescriptorResponse(
    uint16_t in_gatt_code, const std::string& in_descriptor_id, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, SetNextWriteDescriptorResponseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetNextWriteDescriptorResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gatt_code"), in_gatt_code,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextWriteDescriptorResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextWriteDescriptorResponse_Params_Data> params(
          message);
  params.Allocate();

  params->gatt_code = in_gatt_code;
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in FakeCentral.SetNextWriteDescriptorResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.SetNextWriteDescriptorResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.SetNextWriteDescriptorResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.SetNextWriteDescriptorResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextWriteDescriptorResponse");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::GetLastWrittenDescriptorValue(
    const std::string& in_descriptor_id, const std::string& in_characteristic_id, const std::string& in_service_id, const std::string& in_peripheral_address, GetLastWrittenDescriptorValueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::GetLastWrittenDescriptorValue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kGetLastWrittenDescriptorValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_GetLastWrittenDescriptorValue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in FakeCentral.GetLastWrittenDescriptorValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentral.GetLastWrittenDescriptorValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_id in FakeCentral.GetLastWrittenDescriptorValue request");
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentral.GetLastWrittenDescriptorValue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("GetLastWrittenDescriptorValue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FakeCentralProxy::SetClient(
    ::mojo::PendingAssociatedRemote<FakeCentralClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentral::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<FakeCentralClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::FakeCentralClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in FakeCentral.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulatePreconnectedPeripheralCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder> proxy(
        new FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulatePreconnectedPeripheralCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FakeCentral_SimulatePreconnectedPeripheral_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.0
  bool success = true;
  FakeCentral_SimulatePreconnectedPeripheral_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::FakeCentral::SimulatePreconnectedPeripheral");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulatePreconnectedPeripheral), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulatePreconnectedPeripheral");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SimulateAdvertisementReceived_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulateAdvertisementReceivedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulateAdvertisementReceived_ProxyToResponder> proxy(
        new FakeCentral_SimulateAdvertisementReceived_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulateAdvertisementReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulateAdvertisementReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulateAdvertisementReceived_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulateAdvertisementReceivedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FakeCentral_SimulateAdvertisementReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.1
  bool success = true;
  FakeCentral_SimulateAdvertisementReceived_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FakeCentral_SimulateAdvertisementReceived_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::FakeCentral::SimulateAdvertisementReceived");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateAdvertisementReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateAdvertisementReceived");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetState_ProxyToResponder> proxy(
        new FakeCentral_SetState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FakeCentral_SetState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.2
  bool success = true;
  FakeCentral_SetState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FakeCentral_SetState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply bluetooth::mojom::FakeCentral::SetState");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextGATTConnectionResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextGATTConnectionResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextGATTConnectionResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.3
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextGATTConnectionResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextGATTConnectionResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextGATTConnectionResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextGATTConnectionResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextGATTDiscoveryResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextGATTDiscoveryResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextGATTDiscoveryResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.4
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextGATTDiscoveryResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextGATTDiscoveryResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextGATTDiscoveryResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextGATTDiscoveryResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SimulateGATTOperationResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulateGATTOperationResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulateGATTOperationResponse_ProxyToResponder> proxy(
        new FakeCentral_SimulateGATTOperationResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulateGATTOperationResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulateGATTOperationResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulateGATTOperationResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulateGATTOperationResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SimulateGATTOperationResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.5
  bool success = true;
  bool p_success{};
  FakeCentral_SimulateGATTOperationResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SimulateGATTOperationResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SimulateGATTOperationResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateGATTOperationResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateGATTOperationResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SimulateGATTDisconnection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulateGATTDisconnectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulateGATTDisconnection_ProxyToResponder> proxy(
        new FakeCentral_SimulateGATTDisconnection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulateGATTDisconnection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulateGATTDisconnection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulateGATTDisconnection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulateGATTDisconnectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SimulateGATTDisconnection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulateGATTDisconnection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulateGATTDisconnection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.6
  bool success = true;
  bool p_success{};
  FakeCentral_SimulateGATTDisconnection_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SimulateGATTDisconnection_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SimulateGATTDisconnection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateGATTDisconnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateGATTDisconnection_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateGATTDisconnection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SimulateGATTServicesChanged_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulateGATTServicesChangedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulateGATTServicesChanged_ProxyToResponder> proxy(
        new FakeCentral_SimulateGATTServicesChanged_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulateGATTServicesChanged_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulateGATTServicesChanged_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulateGATTServicesChanged_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulateGATTServicesChangedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SimulateGATTServicesChanged_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.7
  bool success = true;
  bool p_success{};
  FakeCentral_SimulateGATTServicesChanged_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SimulateGATTServicesChanged_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SimulateGATTServicesChanged", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateGATTServicesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateGATTServicesChanged");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulateCharacteristicOperationResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder> proxy(
        new FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulateCharacteristicOperationResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SimulateCharacteristicOperationResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.8
  bool success = true;
  bool p_success{};
  FakeCentral_SimulateCharacteristicOperationResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SimulateCharacteristicOperationResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateCharacteristicOperationResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateCharacteristicOperationResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SimulateDescriptorOperationResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder> proxy(
        new FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SimulateDescriptorOperationResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SimulateDescriptorOperationResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.9
  bool success = true;
  bool p_success{};
  FakeCentral_SimulateDescriptorOperationResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SimulateDescriptorOperationResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSimulateDescriptorOperationResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SimulateDescriptorOperationResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_AddFakeService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::AddFakeServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_AddFakeService_ProxyToResponder> proxy(
        new FakeCentral_AddFakeService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_AddFakeService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_AddFakeService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_AddFakeService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::AddFakeServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_service_id);
};

bool FakeCentral_AddFakeService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_AddFakeService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_AddFakeService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.10
  bool success = true;
  std::optional<std::string> p_service_id{};
  FakeCentral_AddFakeService_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadServiceId(&p_service_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_service_id));
  }
  return true;
}

void FakeCentral_AddFakeService_ProxyToResponder::Run(
    const std::optional<std::string>& in_service_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::AddFakeService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kAddFakeService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_AddFakeService_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_id,
    service_id_fragment);

  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("AddFakeService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_RemoveFakeService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::RemoveFakeServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_RemoveFakeService_ProxyToResponder> proxy(
        new FakeCentral_RemoveFakeService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_RemoveFakeService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_RemoveFakeService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_RemoveFakeService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::RemoveFakeServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_RemoveFakeService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_RemoveFakeService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_RemoveFakeService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.11
  bool success = true;
  bool p_success{};
  FakeCentral_RemoveFakeService_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_RemoveFakeService_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::RemoveFakeService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kRemoveFakeService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_RemoveFakeService_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("RemoveFakeService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_AddFakeCharacteristic_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::AddFakeCharacteristicCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_AddFakeCharacteristic_ProxyToResponder> proxy(
        new FakeCentral_AddFakeCharacteristic_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_AddFakeCharacteristic_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_AddFakeCharacteristic_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_AddFakeCharacteristic_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::AddFakeCharacteristicCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_characteristic_id);
};

bool FakeCentral_AddFakeCharacteristic_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_AddFakeCharacteristic_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_AddFakeCharacteristic_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.12
  bool success = true;
  std::optional<std::string> p_characteristic_id{};
  FakeCentral_AddFakeCharacteristic_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_characteristic_id));
  }
  return true;
}

void FakeCentral_AddFakeCharacteristic_ProxyToResponder::Run(
    const std::optional<std::string>& in_characteristic_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::AddFakeCharacteristic", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kAddFakeCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_AddFakeCharacteristic_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("AddFakeCharacteristic");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_RemoveFakeCharacteristic_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::RemoveFakeCharacteristicCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_RemoveFakeCharacteristic_ProxyToResponder> proxy(
        new FakeCentral_RemoveFakeCharacteristic_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_RemoveFakeCharacteristic_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_RemoveFakeCharacteristic_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_RemoveFakeCharacteristic_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::RemoveFakeCharacteristicCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_RemoveFakeCharacteristic_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.13
  bool success = true;
  bool p_success{};
  FakeCentral_RemoveFakeCharacteristic_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_RemoveFakeCharacteristic_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::RemoveFakeCharacteristic", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kRemoveFakeCharacteristic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("RemoveFakeCharacteristic");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_AddFakeDescriptor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::AddFakeDescriptorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_AddFakeDescriptor_ProxyToResponder> proxy(
        new FakeCentral_AddFakeDescriptor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_AddFakeDescriptor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_AddFakeDescriptor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_AddFakeDescriptor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::AddFakeDescriptorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_descriptor_id);
};

bool FakeCentral_AddFakeDescriptor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_AddFakeDescriptor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_AddFakeDescriptor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.14
  bool success = true;
  std::optional<std::string> p_descriptor_id{};
  FakeCentral_AddFakeDescriptor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_descriptor_id));
  }
  return true;
}

void FakeCentral_AddFakeDescriptor_ProxyToResponder::Run(
    const std::optional<std::string>& in_descriptor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::AddFakeDescriptor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kAddFakeDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_AddFakeDescriptor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("AddFakeDescriptor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_RemoveFakeDescriptor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::RemoveFakeDescriptorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_RemoveFakeDescriptor_ProxyToResponder> proxy(
        new FakeCentral_RemoveFakeDescriptor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_RemoveFakeDescriptor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_RemoveFakeDescriptor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_RemoveFakeDescriptor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::RemoveFakeDescriptorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_RemoveFakeDescriptor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_RemoveFakeDescriptor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_RemoveFakeDescriptor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.15
  bool success = true;
  bool p_success{};
  FakeCentral_RemoveFakeDescriptor_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_RemoveFakeDescriptor_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::RemoveFakeDescriptor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kRemoveFakeDescriptor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_RemoveFakeDescriptor_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("RemoveFakeDescriptor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextReadCharacteristicResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextReadCharacteristicResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextReadCharacteristicResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.16
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextReadCharacteristicResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextReadCharacteristicResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextReadCharacteristicResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextReadCharacteristicResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextWriteCharacteristicResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextWriteCharacteristicResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextWriteCharacteristicResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.17
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextWriteCharacteristicResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextWriteCharacteristicResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextWriteCharacteristicResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextWriteCharacteristicResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextSubscribeToNotificationsResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextSubscribeToNotificationsResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextSubscribeToNotificationsResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.18
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextSubscribeToNotificationsResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextSubscribeToNotificationsResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextSubscribeToNotificationsResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextUnsubscribeFromNotificationsResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextUnsubscribeFromNotificationsResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.19
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextUnsubscribeFromNotificationsResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextUnsubscribeFromNotificationsResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_IsNotifying_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::IsNotifyingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_IsNotifying_ProxyToResponder> proxy(
        new FakeCentral_IsNotifying_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_IsNotifying_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_IsNotifying_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_IsNotifying_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::IsNotifyingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, bool in_is_notifying);
};

bool FakeCentral_IsNotifying_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_IsNotifying_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_IsNotifying_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.20
  bool success = true;
  bool p_success{};
  bool p_is_notifying{};
  FakeCentral_IsNotifying_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_is_notifying = input_data_view.is_notifying();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_is_notifying));
  }
  return true;
}

void FakeCentral_IsNotifying_ProxyToResponder::Run(
    bool in_success, bool in_is_notifying) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::IsNotifying", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_notifying"), in_is_notifying,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kIsNotifying), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_IsNotifying_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->is_notifying = in_is_notifying;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("IsNotifying");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::GetLastWrittenCharacteristicValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder> proxy(
        new FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::GetLastWrittenCharacteristicValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::optional<std::vector<uint8_t>>& in_value, WriteType in_write_type);
};

bool FakeCentral_GetLastWrittenCharacteristicValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.21
  bool success = true;
  bool p_success{};
  std::optional<std::vector<uint8_t>> p_value{};
  WriteType p_write_type{};
  FakeCentral_GetLastWrittenCharacteristicValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (success && !input_data_view.ReadWriteType(&p_write_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_value), 
std::move(p_write_type));
  }
  return true;
}

void FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder::Run(
    bool in_success, const std::optional<std::vector<uint8_t>>& in_value, WriteType in_write_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::GetLastWrittenCharacteristicValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_type"), in_write_type,
                        "<value of type WriteType>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kGetLastWrittenCharacteristicValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  mojo::internal::Serialize<::bluetooth::mojom::WriteType>(
    in_write_type,
    &params->write_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("GetLastWrittenCharacteristicValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextReadDescriptorResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextReadDescriptorResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextReadDescriptorResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.22
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextReadDescriptorResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextReadDescriptorResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextReadDescriptorResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextReadDescriptorResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::SetNextWriteDescriptorResponseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder> proxy(
        new FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::SetNextWriteDescriptorResponseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool FakeCentral_SetNextWriteDescriptorResponse_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.23
  bool success = true;
  bool p_success{};
  FakeCentral_SetNextWriteDescriptorResponse_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::SetNextWriteDescriptorResponse", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kSetNextWriteDescriptorResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("SetNextWriteDescriptorResponse");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FakeCentral::GetLastWrittenDescriptorValueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder> proxy(
        new FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FakeCentral::GetLastWrittenDescriptorValueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::optional<std::vector<uint8_t>>& in_value);
};

bool FakeCentral_GetLastWrittenDescriptorValue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FakeCentral.24
  bool success = true;
  bool p_success{};
  std::optional<std::vector<uint8_t>> p_value{};
  FakeCentral_GetLastWrittenDescriptorValue_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FakeCentral::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_value));
  }
  return true;
}

void FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder::Run(
    bool in_success, const std::optional<std::vector<uint8_t>>& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply bluetooth::mojom::FakeCentral::GetLastWrittenDescriptorValue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentral::kGetLastWrittenDescriptorValue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType>
      value_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_value,
    value_fragment,
    &value_validate_params);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentral::Name_);
  message.set_method_name("GetLastWrittenDescriptorValue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FakeCentralStubDispatch::Accept(
    FakeCentral* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FakeCentral>(message->header()->name)) {
    case messages::FakeCentral::kSimulatePreconnectedPeripheral: {
      break;
    }
    case messages::FakeCentral::kSimulateAdvertisementReceived: {
      break;
    }
    case messages::FakeCentral::kSetState: {
      break;
    }
    case messages::FakeCentral::kSetNextGATTConnectionResponse: {
      break;
    }
    case messages::FakeCentral::kSetNextGATTDiscoveryResponse: {
      break;
    }
    case messages::FakeCentral::kSimulateGATTOperationResponse: {
      break;
    }
    case messages::FakeCentral::kSimulateGATTDisconnection: {
      break;
    }
    case messages::FakeCentral::kSimulateGATTServicesChanged: {
      break;
    }
    case messages::FakeCentral::kSimulateCharacteristicOperationResponse: {
      break;
    }
    case messages::FakeCentral::kSimulateDescriptorOperationResponse: {
      break;
    }
    case messages::FakeCentral::kAddFakeService: {
      break;
    }
    case messages::FakeCentral::kRemoveFakeService: {
      break;
    }
    case messages::FakeCentral::kAddFakeCharacteristic: {
      break;
    }
    case messages::FakeCentral::kRemoveFakeCharacteristic: {
      break;
    }
    case messages::FakeCentral::kAddFakeDescriptor: {
      break;
    }
    case messages::FakeCentral::kRemoveFakeDescriptor: {
      break;
    }
    case messages::FakeCentral::kSetNextReadCharacteristicResponse: {
      break;
    }
    case messages::FakeCentral::kSetNextWriteCharacteristicResponse: {
      break;
    }
    case messages::FakeCentral::kSetNextSubscribeToNotificationsResponse: {
      break;
    }
    case messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse: {
      break;
    }
    case messages::FakeCentral::kIsNotifying: {
      break;
    }
    case messages::FakeCentral::kGetLastWrittenCharacteristicValue: {
      break;
    }
    case messages::FakeCentral::kSetNextReadDescriptorResponse: {
      break;
    }
    case messages::FakeCentral::kSetNextWriteDescriptorResponse: {
      break;
    }
    case messages::FakeCentral::kGetLastWrittenDescriptorValue: {
      break;
    }
    case messages::FakeCentral::kSetClient: {
      DCHECK(message->is_serialized());
      internal::FakeCentral_SetClient_Params_Data* params =
          reinterpret_cast<internal::FakeCentral_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FakeCentral.25
      bool success = true;
      ::mojo::PendingAssociatedRemote<FakeCentralClient> p_client{};
      FakeCentral_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool FakeCentralStubDispatch::AcceptWithResponder(
    FakeCentral* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FakeCentral>(message->header()->name)) {
    case messages::FakeCentral::kSimulatePreconnectedPeripheral: {
      internal::FakeCentral_SimulatePreconnectedPeripheral_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulatePreconnectedPeripheral_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.0
      bool success = true;
      std::string p_address{};
      std::string p_name{};
      base::flat_map<uint16_t, std::vector<uint8_t>> p_manufacturer_data{};
      std::vector<::device::BluetoothUUID> p_known_service_uuids{};
      FakeCentral_SimulatePreconnectedPeripheral_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadManufacturerData(&p_manufacturer_data))
        success = false;
      if (success && !input_data_view.ReadKnownServiceUuids(&p_known_service_uuids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 0, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulatePreconnectedPeripheral_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulatePreconnectedPeripheral(        
        std::move(p_address), 
        std::move(p_name), 
        std::move(p_manufacturer_data), 
        std::move(p_known_service_uuids), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSimulateAdvertisementReceived: {
      internal::FakeCentral_SimulateAdvertisementReceived_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulateAdvertisementReceived_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.1
      bool success = true;
      ScanResultPtr p_result{};
      FakeCentral_SimulateAdvertisementReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 1, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulateAdvertisementReceived_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateAdvertisementReceived(        
        std::move(p_result), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetState: {
      internal::FakeCentral_SetState_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.2
      bool success = true;
      CentralState p_state{};
      FakeCentral_SetState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 2, false);
        return false;
      }
      auto callback =
          FakeCentral_SetState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetState(        
        std::move(p_state), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextGATTConnectionResponse: {
      internal::FakeCentral_SetNextGATTConnectionResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextGATTConnectionResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.3
      bool success = true;
      std::string p_address{};
      uint16_t p_code{};
      FakeCentral_SetNextGATTConnectionResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 3, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextGATTConnectionResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextGATTConnectionResponse(        
        std::move(p_address), 
        std::move(p_code), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextGATTDiscoveryResponse: {
      internal::FakeCentral_SetNextGATTDiscoveryResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextGATTDiscoveryResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.4
      bool success = true;
      std::string p_address{};
      uint16_t p_code{};
      FakeCentral_SetNextGATTDiscoveryResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 4, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextGATTDiscoveryResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextGATTDiscoveryResponse(        
        std::move(p_address), 
        std::move(p_code), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSimulateGATTOperationResponse: {
      internal::FakeCentral_SimulateGATTOperationResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulateGATTOperationResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.5
      bool success = true;
      GATTOperationType p_type{};
      std::string p_address{};
      uint16_t p_code{};
      FakeCentral_SimulateGATTOperationResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 5, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulateGATTOperationResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateGATTOperationResponse(        
        std::move(p_type), 
        std::move(p_address), 
        std::move(p_code), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSimulateGATTDisconnection: {
      internal::FakeCentral_SimulateGATTDisconnection_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulateGATTDisconnection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.6
      bool success = true;
      std::string p_address{};
      FakeCentral_SimulateGATTDisconnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 6, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulateGATTDisconnection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateGATTDisconnection(        
        std::move(p_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSimulateGATTServicesChanged: {
      internal::FakeCentral_SimulateGATTServicesChanged_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulateGATTServicesChanged_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.7
      bool success = true;
      std::string p_address{};
      FakeCentral_SimulateGATTServicesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 7, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulateGATTServicesChanged_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateGATTServicesChanged(        
        std::move(p_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSimulateCharacteristicOperationResponse: {
      internal::FakeCentral_SimulateCharacteristicOperationResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulateCharacteristicOperationResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.8
      bool success = true;
      CharacteristicOperationType p_type{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      uint16_t p_code{};
      std::optional<std::vector<uint8_t>> p_data{};
      FakeCentral_SimulateCharacteristicOperationResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 8, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulateCharacteristicOperationResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateCharacteristicOperationResponse(        
        std::move(p_type), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), 
        std::move(p_code), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSimulateDescriptorOperationResponse: {
      internal::FakeCentral_SimulateDescriptorOperationResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SimulateDescriptorOperationResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.9
      bool success = true;
      DescriptorOperationType p_type{};
      std::string p_descriptor_id{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      uint16_t p_code{};
      std::optional<std::vector<uint8_t>> p_data{};
      FakeCentral_SimulateDescriptorOperationResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (success)
        p_code = input_data_view.code();
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 9, false);
        return false;
      }
      auto callback =
          FakeCentral_SimulateDescriptorOperationResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SimulateDescriptorOperationResponse(        
        std::move(p_type), 
        std::move(p_descriptor_id), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), 
        std::move(p_code), 
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kAddFakeService: {
      internal::FakeCentral_AddFakeService_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_AddFakeService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.10
      bool success = true;
      std::string p_peripheral_address{};
      ::device::BluetoothUUID p_service_uuid{};
      FakeCentral_AddFakeService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (success && !input_data_view.ReadServiceUuid(&p_service_uuid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 10, false);
        return false;
      }
      auto callback =
          FakeCentral_AddFakeService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFakeService(        
        std::move(p_peripheral_address), 
        std::move(p_service_uuid), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kRemoveFakeService: {
      internal::FakeCentral_RemoveFakeService_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_RemoveFakeService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.11
      bool success = true;
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_RemoveFakeService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 11, false);
        return false;
      }
      auto callback =
          FakeCentral_RemoveFakeService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFakeService(        
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kAddFakeCharacteristic: {
      internal::FakeCentral_AddFakeCharacteristic_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_AddFakeCharacteristic_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.12
      bool success = true;
      ::device::BluetoothUUID p_characteristic_uuid{};
      CharacteristicPropertiesPtr p_properties{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_AddFakeCharacteristic_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicUuid(&p_characteristic_uuid))
        success = false;
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 12, false);
        return false;
      }
      auto callback =
          FakeCentral_AddFakeCharacteristic_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFakeCharacteristic(        
        std::move(p_characteristic_uuid), 
        std::move(p_properties), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kRemoveFakeCharacteristic: {
      internal::FakeCentral_RemoveFakeCharacteristic_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_RemoveFakeCharacteristic_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.13
      bool success = true;
      std::string p_identifier{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_RemoveFakeCharacteristic_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentifier(&p_identifier))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 13, false);
        return false;
      }
      auto callback =
          FakeCentral_RemoveFakeCharacteristic_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFakeCharacteristic(        
        std::move(p_identifier), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kAddFakeDescriptor: {
      internal::FakeCentral_AddFakeDescriptor_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_AddFakeDescriptor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.14
      bool success = true;
      ::device::BluetoothUUID p_descriptor_uuid{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_AddFakeDescriptor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescriptorUuid(&p_descriptor_uuid))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 14, false);
        return false;
      }
      auto callback =
          FakeCentral_AddFakeDescriptor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFakeDescriptor(        
        std::move(p_descriptor_uuid), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kRemoveFakeDescriptor: {
      internal::FakeCentral_RemoveFakeDescriptor_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_RemoveFakeDescriptor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.15
      bool success = true;
      std::string p_descriptor_id{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_RemoveFakeDescriptor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 15, false);
        return false;
      }
      auto callback =
          FakeCentral_RemoveFakeDescriptor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFakeDescriptor(        
        std::move(p_descriptor_id), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextReadCharacteristicResponse: {
      internal::FakeCentral_SetNextReadCharacteristicResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextReadCharacteristicResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.16
      bool success = true;
      uint16_t p_gatt_code{};
      std::optional<std::vector<uint8_t>> p_value{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_SetNextReadCharacteristicResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gatt_code = input_data_view.gatt_code();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 16, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextReadCharacteristicResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextReadCharacteristicResponse(        
        std::move(p_gatt_code), 
        std::move(p_value), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextWriteCharacteristicResponse: {
      internal::FakeCentral_SetNextWriteCharacteristicResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextWriteCharacteristicResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.17
      bool success = true;
      uint16_t p_gatt_code{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_SetNextWriteCharacteristicResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gatt_code = input_data_view.gatt_code();
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 17, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextWriteCharacteristicResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextWriteCharacteristicResponse(        
        std::move(p_gatt_code), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextSubscribeToNotificationsResponse: {
      internal::FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.18
      bool success = true;
      uint16_t p_gatt_code{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_SetNextSubscribeToNotificationsResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gatt_code = input_data_view.gatt_code();
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 18, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextSubscribeToNotificationsResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextSubscribeToNotificationsResponse(        
        std::move(p_gatt_code), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextUnsubscribeFromNotificationsResponse: {
      internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.19
      bool success = true;
      uint16_t p_gatt_code{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gatt_code = input_data_view.gatt_code();
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 19, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextUnsubscribeFromNotificationsResponse(        
        std::move(p_gatt_code), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kIsNotifying: {
      internal::FakeCentral_IsNotifying_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_IsNotifying_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.20
      bool success = true;
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_IsNotifying_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 20, false);
        return false;
      }
      auto callback =
          FakeCentral_IsNotifying_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsNotifying(        
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kGetLastWrittenCharacteristicValue: {
      internal::FakeCentral_GetLastWrittenCharacteristicValue_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_GetLastWrittenCharacteristicValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.21
      bool success = true;
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_GetLastWrittenCharacteristicValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 21, false);
        return false;
      }
      auto callback =
          FakeCentral_GetLastWrittenCharacteristicValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLastWrittenCharacteristicValue(        
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextReadDescriptorResponse: {
      internal::FakeCentral_SetNextReadDescriptorResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextReadDescriptorResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.22
      bool success = true;
      uint16_t p_gatt_code{};
      std::optional<std::vector<uint8_t>> p_value{};
      std::string p_descriptor_id{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_SetNextReadDescriptorResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gatt_code = input_data_view.gatt_code();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 22, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextReadDescriptorResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextReadDescriptorResponse(        
        std::move(p_gatt_code), 
        std::move(p_value), 
        std::move(p_descriptor_id), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetNextWriteDescriptorResponse: {
      internal::FakeCentral_SetNextWriteDescriptorResponse_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_SetNextWriteDescriptorResponse_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.23
      bool success = true;
      uint16_t p_gatt_code{};
      std::string p_descriptor_id{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_SetNextWriteDescriptorResponse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_gatt_code = input_data_view.gatt_code();
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 23, false);
        return false;
      }
      auto callback =
          FakeCentral_SetNextWriteDescriptorResponse_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNextWriteDescriptorResponse(        
        std::move(p_gatt_code), 
        std::move(p_descriptor_id), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kGetLastWrittenDescriptorValue: {
      internal::FakeCentral_GetLastWrittenDescriptorValue_Params_Data* params =
          reinterpret_cast<
              internal::FakeCentral_GetLastWrittenDescriptorValue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FakeCentral.24
      bool success = true;
      std::string p_descriptor_id{};
      std::string p_characteristic_id{};
      std::string p_service_id{};
      std::string p_peripheral_address{};
      FakeCentral_GetLastWrittenDescriptorValue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentral::Name_, 24, false);
        return false;
      }
      auto callback =
          FakeCentral_GetLastWrittenDescriptorValue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLastWrittenDescriptorValue(        
        std::move(p_descriptor_id), 
        std::move(p_characteristic_id), 
        std::move(p_service_id), 
        std::move(p_peripheral_address), std::move(callback));
      return true;
    }
    case messages::FakeCentral::kSetClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFakeCentralValidationInfo[] = {
    { &internal::FakeCentral_SimulatePreconnectedPeripheral_Params_Data::Validate,
     &internal::FakeCentral_SimulatePreconnectedPeripheral_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SimulateAdvertisementReceived_Params_Data::Validate,
     &internal::FakeCentral_SimulateAdvertisementReceived_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetState_Params_Data::Validate,
     &internal::FakeCentral_SetState_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextGATTConnectionResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextGATTConnectionResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextGATTDiscoveryResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextGATTDiscoveryResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SimulateGATTOperationResponse_Params_Data::Validate,
     &internal::FakeCentral_SimulateGATTOperationResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SimulateGATTDisconnection_Params_Data::Validate,
     &internal::FakeCentral_SimulateGATTDisconnection_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SimulateGATTServicesChanged_Params_Data::Validate,
     &internal::FakeCentral_SimulateGATTServicesChanged_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SimulateCharacteristicOperationResponse_Params_Data::Validate,
     &internal::FakeCentral_SimulateCharacteristicOperationResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SimulateDescriptorOperationResponse_Params_Data::Validate,
     &internal::FakeCentral_SimulateDescriptorOperationResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_AddFakeService_Params_Data::Validate,
     &internal::FakeCentral_AddFakeService_ResponseParams_Data::Validate},
    { &internal::FakeCentral_RemoveFakeService_Params_Data::Validate,
     &internal::FakeCentral_RemoveFakeService_ResponseParams_Data::Validate},
    { &internal::FakeCentral_AddFakeCharacteristic_Params_Data::Validate,
     &internal::FakeCentral_AddFakeCharacteristic_ResponseParams_Data::Validate},
    { &internal::FakeCentral_RemoveFakeCharacteristic_Params_Data::Validate,
     &internal::FakeCentral_RemoveFakeCharacteristic_ResponseParams_Data::Validate},
    { &internal::FakeCentral_AddFakeDescriptor_Params_Data::Validate,
     &internal::FakeCentral_AddFakeDescriptor_ResponseParams_Data::Validate},
    { &internal::FakeCentral_RemoveFakeDescriptor_Params_Data::Validate,
     &internal::FakeCentral_RemoveFakeDescriptor_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextReadCharacteristicResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextReadCharacteristicResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextWriteCharacteristicResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextWriteCharacteristicResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextSubscribeToNotificationsResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextSubscribeToNotificationsResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextUnsubscribeFromNotificationsResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_IsNotifying_Params_Data::Validate,
     &internal::FakeCentral_IsNotifying_ResponseParams_Data::Validate},
    { &internal::FakeCentral_GetLastWrittenCharacteristicValue_Params_Data::Validate,
     &internal::FakeCentral_GetLastWrittenCharacteristicValue_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextReadDescriptorResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextReadDescriptorResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetNextWriteDescriptorResponse_Params_Data::Validate,
     &internal::FakeCentral_SetNextWriteDescriptorResponse_ResponseParams_Data::Validate},
    { &internal::FakeCentral_GetLastWrittenDescriptorValue_Params_Data::Validate,
     &internal::FakeCentral_GetLastWrittenDescriptorValue_ResponseParams_Data::Validate},
    { &internal::FakeCentral_SetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool FakeCentralRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::FakeCentral::Name_,
    kFakeCentralValidationInfo);
}

bool FakeCentralResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::bluetooth::mojom::FakeCentral::Name_,
    kFakeCentralValidationInfo);
}
// The declaration includes the definition on other builds.

FakeCentralClient::IPCStableHashFunction FakeCentralClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FakeCentralClient>(message.name())) {
    case messages::FakeCentralClient::kDispatchGATTOperationEvent: {
      return &FakeCentralClient::DispatchGATTOperationEvent_Sym::IPCStableHash;
    }
    case messages::FakeCentralClient::kDispatchCharacteristicOperationEvent: {
      return &FakeCentralClient::DispatchCharacteristicOperationEvent_Sym::IPCStableHash;
    }
    case messages::FakeCentralClient::kDispatchDescriptorOperationEvent: {
      return &FakeCentralClient::DispatchDescriptorOperationEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FakeCentralClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FakeCentralClient>(message.name())) {
      case messages::FakeCentralClient::kDispatchGATTOperationEvent:
            return "Receive bluetooth::mojom::FakeCentralClient::DispatchGATTOperationEvent";
      case messages::FakeCentralClient::kDispatchCharacteristicOperationEvent:
            return "Receive bluetooth::mojom::FakeCentralClient::DispatchCharacteristicOperationEvent";
      case messages::FakeCentralClient::kDispatchDescriptorOperationEvent:
            return "Receive bluetooth::mojom::FakeCentralClient::DispatchDescriptorOperationEvent";
    }
  } else {
    switch (static_cast<messages::FakeCentralClient>(message.name())) {
      case messages::FakeCentralClient::kDispatchGATTOperationEvent:
            return "Receive reply bluetooth::mojom::FakeCentralClient::DispatchGATTOperationEvent";
      case messages::FakeCentralClient::kDispatchCharacteristicOperationEvent:
            return "Receive reply bluetooth::mojom::FakeCentralClient::DispatchCharacteristicOperationEvent";
      case messages::FakeCentralClient::kDispatchDescriptorOperationEvent:
            return "Receive reply bluetooth::mojom::FakeCentralClient::DispatchDescriptorOperationEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FakeCentralClient::DispatchGATTOperationEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3dcaad8;  // IPCStableHash for bluetooth::mojom::FakeCentralClient::DispatchGATTOperationEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentralClient::DispatchCharacteristicOperationEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2fb1c051;  // IPCStableHash for bluetooth::mojom::FakeCentralClient::DispatchCharacteristicOperationEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FakeCentralClient::DispatchDescriptorOperationEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x256596f9;  // IPCStableHash for bluetooth::mojom::FakeCentralClient::DispatchDescriptorOperationEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FakeCentralClientProxy::FakeCentralClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FakeCentralClientProxy::DispatchGATTOperationEvent(
    GATTOperationType in_type, const std::string& in_peripheral_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentralClient::DispatchGATTOperationEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type GATTOperationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peripheral_address"), in_peripheral_address,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentralClient::kDispatchGATTOperationEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentralClient_DispatchGATTOperationEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::GATTOperationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->peripheral_address)::BaseType> peripheral_address_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_peripheral_address,
    peripheral_address_fragment);

  params->peripheral_address.Set(
      peripheral_address_fragment.is_null() ? nullptr : peripheral_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->peripheral_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null peripheral_address in FakeCentralClient.DispatchGATTOperationEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentralClient::Name_);
  message.set_method_name("DispatchGATTOperationEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FakeCentralClientProxy::DispatchCharacteristicOperationEvent(
    CharacteristicOperationType in_type, const std::optional<std::vector<uint8_t>>& in_data, std::optional<WriteType> in_write_type, const std::string& in_characteristic_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentralClient::DispatchCharacteristicOperationEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type CharacteristicOperationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_type"), in_write_type,
                        "<value of type std::optional<WriteType>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("characteristic_id"), in_characteristic_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentralClient::kDispatchCharacteristicOperationEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::CharacteristicOperationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  params->write_type_$flag = in_write_type.has_value();
  if (in_write_type.has_value()) {
    
    mojo::internal::Serialize<::bluetooth::mojom::WriteType>(
      in_write_type.value(),
      &params->write_type_$value);
  } else {
    params->write_type_$value =
        static_cast<int32_t>(::bluetooth::mojom::WriteType::kMinValue);
  }
  mojo::internal::MessageFragment<
      typename decltype(params->characteristic_id)::BaseType> characteristic_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_characteristic_id,
    characteristic_id_fragment);

  params->characteristic_id.Set(
      characteristic_id_fragment.is_null() ? nullptr : characteristic_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->characteristic_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null characteristic_id in FakeCentralClient.DispatchCharacteristicOperationEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentralClient::Name_);
  message.set_method_name("DispatchCharacteristicOperationEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FakeCentralClientProxy::DispatchDescriptorOperationEvent(
    DescriptorOperationType in_type, const std::optional<std::vector<uint8_t>>& in_data, const std::string& in_descriptor_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send bluetooth::mojom::FakeCentralClient::DispatchDescriptorOperationEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type DescriptorOperationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptor_id"), in_descriptor_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FakeCentralClient::kDispatchDescriptorOperationEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::bluetooth::mojom::internal::FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::bluetooth::mojom::DescriptorOperationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->descriptor_id)::BaseType> descriptor_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_descriptor_id,
    descriptor_id_fragment);

  params->descriptor_id.Set(
      descriptor_id_fragment.is_null() ? nullptr : descriptor_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptor_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptor_id in FakeCentralClient.DispatchDescriptorOperationEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FakeCentralClient::Name_);
  message.set_method_name("DispatchDescriptorOperationEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FakeCentralClientStubDispatch::Accept(
    FakeCentralClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FakeCentralClient>(message->header()->name)) {
    case messages::FakeCentralClient::kDispatchGATTOperationEvent: {
      DCHECK(message->is_serialized());
      internal::FakeCentralClient_DispatchGATTOperationEvent_Params_Data* params =
          reinterpret_cast<internal::FakeCentralClient_DispatchGATTOperationEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FakeCentralClient.0
      bool success = true;
      GATTOperationType p_type{};
      std::string p_peripheral_address{};
      FakeCentralClient_DispatchGATTOperationEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadPeripheralAddress(&p_peripheral_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentralClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchGATTOperationEvent(        
        std::move(p_type), 
        std::move(p_peripheral_address));
      return true;
    }
    case messages::FakeCentralClient::kDispatchCharacteristicOperationEvent: {
      DCHECK(message->is_serialized());
      internal::FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data* params =
          reinterpret_cast<internal::FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FakeCentralClient.1
      bool success = true;
      CharacteristicOperationType p_type{};
      std::optional<std::vector<uint8_t>> p_data{};
      std::optional<WriteType> p_write_type{};
      std::string p_characteristic_id{};
      FakeCentralClient_DispatchCharacteristicOperationEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadWriteType(&p_write_type)) {
        success = false;
      }
      if (success && !input_data_view.ReadCharacteristicId(&p_characteristic_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentralClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchCharacteristicOperationEvent(        
        std::move(p_type), 
        std::move(p_data), 
        std::move(p_write_type), 
        std::move(p_characteristic_id));
      return true;
    }
    case messages::FakeCentralClient::kDispatchDescriptorOperationEvent: {
      DCHECK(message->is_serialized());
      internal::FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data* params =
          reinterpret_cast<internal::FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FakeCentralClient.2
      bool success = true;
      DescriptorOperationType p_type{};
      std::optional<std::vector<uint8_t>> p_data{};
      std::string p_descriptor_id{};
      FakeCentralClient_DispatchDescriptorOperationEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadDescriptorId(&p_descriptor_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FakeCentralClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchDescriptorOperationEvent(        
        std::move(p_type), 
        std::move(p_data), 
        std::move(p_descriptor_id));
      return true;
    }
  }
  return false;
}

// static
bool FakeCentralClientStubDispatch::AcceptWithResponder(
    FakeCentralClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FakeCentralClient>(message->header()->name)) {
    case messages::FakeCentralClient::kDispatchGATTOperationEvent: {
      break;
    }
    case messages::FakeCentralClient::kDispatchCharacteristicOperationEvent: {
      break;
    }
    case messages::FakeCentralClient::kDispatchDescriptorOperationEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFakeCentralClientValidationInfo[] = {
    { &internal::FakeCentralClient_DispatchGATTOperationEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FakeCentralClient_DispatchCharacteristicOperationEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FakeCentralClient_DispatchDescriptorOperationEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool FakeCentralClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::bluetooth::mojom::FakeCentralClient::Name_,
    kFakeCentralClientValidationInfo);
}



}  // bluetooth::mojom


namespace mojo {


// static
bool StructTraits<::bluetooth::mojom::Appearance::DataView, ::bluetooth::mojom::AppearancePtr>::Read(
    ::bluetooth::mojom::Appearance::DataView input,
    ::bluetooth::mojom::AppearancePtr* output) {
  bool success = true;
  ::bluetooth::mojom::AppearancePtr result(::bluetooth::mojom::Appearance::New());
  
      if (success)
        result->has_value = input.has_value();
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::Power::DataView, ::bluetooth::mojom::PowerPtr>::Read(
    ::bluetooth::mojom::Power::DataView input,
    ::bluetooth::mojom::PowerPtr* output) {
  bool success = true;
  ::bluetooth::mojom::PowerPtr result(::bluetooth::mojom::Power::New());
  
      if (success)
        result->has_value = input.has_value();
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::ServiceDataMap::DataView, ::bluetooth::mojom::ServiceDataMapPtr>::Read(
    ::bluetooth::mojom::ServiceDataMap::DataView input,
    ::bluetooth::mojom::ServiceDataMapPtr* output) {
  bool success = true;
  ::bluetooth::mojom::ServiceDataMapPtr result(::bluetooth::mojom::ServiceDataMap::New());
  
      if (success && !input.ReadServiceData(&result->service_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::ScanRecord::DataView, ::bluetooth::mojom::ScanRecordPtr>::Read(
    ::bluetooth::mojom::ScanRecord::DataView input,
    ::bluetooth::mojom::ScanRecordPtr* output) {
  bool success = true;
  ::bluetooth::mojom::ScanRecordPtr result(::bluetooth::mojom::ScanRecord::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUuids(&result->uuids))
        success = false;
      if (success && !input.ReadAppearance(&result->appearance))
        success = false;
      if (success && !input.ReadTxPower(&result->tx_power))
        success = false;
      if (success && !input.ReadManufacturerData(&result->manufacturer_data))
        success = false;
      if (success && !input.ReadServiceData(&result->service_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::ScanResult::DataView, ::bluetooth::mojom::ScanResultPtr>::Read(
    ::bluetooth::mojom::ScanResult::DataView input,
    ::bluetooth::mojom::ScanResultPtr* output) {
  bool success = true;
  ::bluetooth::mojom::ScanResultPtr result(::bluetooth::mojom::ScanResult::New());
  
      if (success && !input.ReadDeviceAddress(&result->device_address))
        success = false;
      if (success)
        result->rssi = input.rssi();
      if (success && !input.ReadScanRecord(&result->scan_record))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::bluetooth::mojom::CharacteristicProperties::DataView, ::bluetooth::mojom::CharacteristicPropertiesPtr>::Read(
    ::bluetooth::mojom::CharacteristicProperties::DataView input,
    ::bluetooth::mojom::CharacteristicPropertiesPtr* output) {
  bool success = true;
  ::bluetooth::mojom::CharacteristicPropertiesPtr result(::bluetooth::mojom::CharacteristicProperties::New());
  
      if (success)
        result->broadcast = input.broadcast();
      if (success)
        result->read = input.read();
      if (success)
        result->write_without_response = input.write_without_response();
      if (success)
        result->write = input.write();
      if (success)
        result->notify = input.notify();
      if (success)
        result->indicate = input.indicate();
      if (success)
        result->authenticated_signed_writes = input.authenticated_signed_writes();
      if (success)
        result->extended_properties = input.extended_properties();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace bluetooth::mojom {


void FakeBluetoothInterceptorForTesting::SetLESupported(bool available, SetLESupportedCallback callback) {
  GetForwardingInterface()->SetLESupported(
    std::move(available)
    , std::move(callback));
}
void FakeBluetoothInterceptorForTesting::SimulateCentral(CentralState state, SimulateCentralCallback callback) {
  GetForwardingInterface()->SimulateCentral(
    std::move(state)
    , std::move(callback));
}
void FakeBluetoothInterceptorForTesting::AllResponsesConsumed(AllResponsesConsumedCallback callback) {
  GetForwardingInterface()->AllResponsesConsumed(std::move(callback));
}
FakeBluetoothAsyncWaiter::FakeBluetoothAsyncWaiter(
    FakeBluetooth* proxy) : proxy_(proxy) {}

FakeBluetoothAsyncWaiter::~FakeBluetoothAsyncWaiter() = default;


void FakeBluetoothAsyncWaiter::SetLESupported(
    bool available) {
  base::RunLoop loop;
  proxy_->SetLESupported(
      std::move(available),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FakeBluetoothAsyncWaiter::SimulateCentral(
    CentralState state, ::mojo::PendingRemote<FakeCentral>* out_fake_central) {
  base::RunLoop loop;
  proxy_->SimulateCentral(
      std::move(state),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<FakeCentral>* out_fake_central
,
             ::mojo::PendingRemote<FakeCentral> fake_central) {*out_fake_central = std::move(fake_central);
            loop->Quit();
          },
          &loop,
          out_fake_central));
  loop.Run();
}

::mojo::PendingRemote<FakeCentral> FakeBluetoothAsyncWaiter::SimulateCentral(
    CentralState state) {
  ::mojo::PendingRemote<FakeCentral> async_wait_result;
  SimulateCentral(std::move(state),&async_wait_result);
  return async_wait_result;
}

void FakeBluetoothAsyncWaiter::AllResponsesConsumed(
    bool* out_consumed) {
  base::RunLoop loop;
  proxy_->AllResponsesConsumed(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_consumed
,
             bool consumed) {*out_consumed = std::move(consumed);
            loop->Quit();
          },
          &loop,
          out_consumed));
  loop.Run();
}

bool FakeBluetoothAsyncWaiter::AllResponsesConsumed(
    ) {
  bool async_wait_result;
  AllResponsesConsumed(&async_wait_result);
  return async_wait_result;
}




void FakeCentralInterceptorForTesting::SimulatePreconnectedPeripheral(const std::string& address, const std::string& name, const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data, const std::vector<::device::BluetoothUUID>& known_service_uuids, SimulatePreconnectedPeripheralCallback callback) {
  GetForwardingInterface()->SimulatePreconnectedPeripheral(
    std::move(address)
    , 
    std::move(name)
    , 
    std::move(manufacturer_data)
    , 
    std::move(known_service_uuids)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SimulateAdvertisementReceived(ScanResultPtr result, SimulateAdvertisementReceivedCallback callback) {
  GetForwardingInterface()->SimulateAdvertisementReceived(
    std::move(result)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetState(CentralState state, SetStateCallback callback) {
  GetForwardingInterface()->SetState(
    std::move(state)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextGATTConnectionResponse(const std::string& address, uint16_t code, SetNextGATTConnectionResponseCallback callback) {
  GetForwardingInterface()->SetNextGATTConnectionResponse(
    std::move(address)
    , 
    std::move(code)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextGATTDiscoveryResponse(const std::string& address, uint16_t code, SetNextGATTDiscoveryResponseCallback callback) {
  GetForwardingInterface()->SetNextGATTDiscoveryResponse(
    std::move(address)
    , 
    std::move(code)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SimulateGATTOperationResponse(GATTOperationType type, const std::string& address, uint16_t code, SimulateGATTOperationResponseCallback callback) {
  GetForwardingInterface()->SimulateGATTOperationResponse(
    std::move(type)
    , 
    std::move(address)
    , 
    std::move(code)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SimulateGATTDisconnection(const std::string& address, SimulateGATTDisconnectionCallback callback) {
  GetForwardingInterface()->SimulateGATTDisconnection(
    std::move(address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SimulateGATTServicesChanged(const std::string& address, SimulateGATTServicesChangedCallback callback) {
  GetForwardingInterface()->SimulateGATTServicesChanged(
    std::move(address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SimulateCharacteristicOperationResponse(CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateCharacteristicOperationResponseCallback callback) {
  GetForwardingInterface()->SimulateCharacteristicOperationResponse(
    std::move(type)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , 
    std::move(code)
    , 
    std::move(data)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SimulateDescriptorOperationResponse(DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, SimulateDescriptorOperationResponseCallback callback) {
  GetForwardingInterface()->SimulateDescriptorOperationResponse(
    std::move(type)
    , 
    std::move(descriptor_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , 
    std::move(code)
    , 
    std::move(data)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::AddFakeService(const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid, AddFakeServiceCallback callback) {
  GetForwardingInterface()->AddFakeService(
    std::move(peripheral_address)
    , 
    std::move(service_uuid)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::RemoveFakeService(const std::string& service_id, const std::string& peripheral_address, RemoveFakeServiceCallback callback) {
  GetForwardingInterface()->RemoveFakeService(
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::AddFakeCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address, AddFakeCharacteristicCallback callback) {
  GetForwardingInterface()->AddFakeCharacteristic(
    std::move(characteristic_uuid)
    , 
    std::move(properties)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::RemoveFakeCharacteristic(const std::string& identifier, const std::string& service_id, const std::string& peripheral_address, RemoveFakeCharacteristicCallback callback) {
  GetForwardingInterface()->RemoveFakeCharacteristic(
    std::move(identifier)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::AddFakeDescriptor(const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, AddFakeDescriptorCallback callback) {
  GetForwardingInterface()->AddFakeDescriptor(
    std::move(descriptor_uuid)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::RemoveFakeDescriptor(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, RemoveFakeDescriptorCallback callback) {
  GetForwardingInterface()->RemoveFakeDescriptor(
    std::move(descriptor_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextReadCharacteristicResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadCharacteristicResponseCallback callback) {
  GetForwardingInterface()->SetNextReadCharacteristicResponse(
    std::move(gatt_code)
    , 
    std::move(value)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextWriteCharacteristicResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteCharacteristicResponseCallback callback) {
  GetForwardingInterface()->SetNextWriteCharacteristicResponse(
    std::move(gatt_code)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextSubscribeToNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextSubscribeToNotificationsResponseCallback callback) {
  GetForwardingInterface()->SetNextSubscribeToNotificationsResponse(
    std::move(gatt_code)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextUnsubscribeFromNotificationsResponse(uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextUnsubscribeFromNotificationsResponseCallback callback) {
  GetForwardingInterface()->SetNextUnsubscribeFromNotificationsResponse(
    std::move(gatt_code)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::IsNotifying(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, IsNotifyingCallback callback) {
  GetForwardingInterface()->IsNotifying(
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::GetLastWrittenCharacteristicValue(const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenCharacteristicValueCallback callback) {
  GetForwardingInterface()->GetLastWrittenCharacteristicValue(
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextReadDescriptorResponse(uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextReadDescriptorResponseCallback callback) {
  GetForwardingInterface()->SetNextReadDescriptorResponse(
    std::move(gatt_code)
    , 
    std::move(value)
    , 
    std::move(descriptor_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetNextWriteDescriptorResponse(uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, SetNextWriteDescriptorResponseCallback callback) {
  GetForwardingInterface()->SetNextWriteDescriptorResponse(
    std::move(gatt_code)
    , 
    std::move(descriptor_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::GetLastWrittenDescriptorValue(const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, GetLastWrittenDescriptorValueCallback callback) {
  GetForwardingInterface()->GetLastWrittenDescriptorValue(
    std::move(descriptor_id)
    , 
    std::move(characteristic_id)
    , 
    std::move(service_id)
    , 
    std::move(peripheral_address)
    , std::move(callback));
}
void FakeCentralInterceptorForTesting::SetClient(::mojo::PendingAssociatedRemote<FakeCentralClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
FakeCentralAsyncWaiter::FakeCentralAsyncWaiter(
    FakeCentral* proxy) : proxy_(proxy) {}

FakeCentralAsyncWaiter::~FakeCentralAsyncWaiter() = default;


void FakeCentralAsyncWaiter::SimulatePreconnectedPeripheral(
    const std::string& address, const std::string& name, const base::flat_map<uint16_t, std::vector<uint8_t>>& manufacturer_data, const std::vector<::device::BluetoothUUID>& known_service_uuids) {
  base::RunLoop loop;
  proxy_->SimulatePreconnectedPeripheral(
      std::move(address),
      std::move(name),
      std::move(manufacturer_data),
      std::move(known_service_uuids),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FakeCentralAsyncWaiter::SimulateAdvertisementReceived(
    ScanResultPtr result) {
  base::RunLoop loop;
  proxy_->SimulateAdvertisementReceived(
      std::move(result),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FakeCentralAsyncWaiter::SetState(
    CentralState state) {
  base::RunLoop loop;
  proxy_->SetState(
      std::move(state),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void FakeCentralAsyncWaiter::SetNextGATTConnectionResponse(
    const std::string& address, uint16_t code, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextGATTConnectionResponse(
      std::move(address),
      std::move(code),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextGATTConnectionResponse(
    const std::string& address, uint16_t code) {
  bool async_wait_result;
  SetNextGATTConnectionResponse(std::move(address),std::move(code),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SetNextGATTDiscoveryResponse(
    const std::string& address, uint16_t code, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextGATTDiscoveryResponse(
      std::move(address),
      std::move(code),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextGATTDiscoveryResponse(
    const std::string& address, uint16_t code) {
  bool async_wait_result;
  SetNextGATTDiscoveryResponse(std::move(address),std::move(code),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SimulateGATTOperationResponse(
    GATTOperationType type, const std::string& address, uint16_t code, bool* out_success) {
  base::RunLoop loop;
  proxy_->SimulateGATTOperationResponse(
      std::move(type),
      std::move(address),
      std::move(code),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SimulateGATTOperationResponse(
    GATTOperationType type, const std::string& address, uint16_t code) {
  bool async_wait_result;
  SimulateGATTOperationResponse(std::move(type),std::move(address),std::move(code),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SimulateGATTDisconnection(
    const std::string& address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SimulateGATTDisconnection(
      std::move(address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SimulateGATTDisconnection(
    const std::string& address) {
  bool async_wait_result;
  SimulateGATTDisconnection(std::move(address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SimulateGATTServicesChanged(
    const std::string& address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SimulateGATTServicesChanged(
      std::move(address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SimulateGATTServicesChanged(
    const std::string& address) {
  bool async_wait_result;
  SimulateGATTServicesChanged(std::move(address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SimulateCharacteristicOperationResponse(
    CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, bool* out_success) {
  base::RunLoop loop;
  proxy_->SimulateCharacteristicOperationResponse(
      std::move(type),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      std::move(code),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SimulateCharacteristicOperationResponse(
    CharacteristicOperationType type, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data) {
  bool async_wait_result;
  SimulateCharacteristicOperationResponse(std::move(type),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),std::move(code),std::move(data),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SimulateDescriptorOperationResponse(
    DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data, bool* out_success) {
  base::RunLoop loop;
  proxy_->SimulateDescriptorOperationResponse(
      std::move(type),
      std::move(descriptor_id),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      std::move(code),
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SimulateDescriptorOperationResponse(
    DescriptorOperationType type, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, uint16_t code, const std::optional<std::vector<uint8_t>>& data) {
  bool async_wait_result;
  SimulateDescriptorOperationResponse(std::move(type),std::move(descriptor_id),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),std::move(code),std::move(data),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::AddFakeService(
    const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid, std::optional<std::string>* out_service_id) {
  base::RunLoop loop;
  proxy_->AddFakeService(
      std::move(peripheral_address),
      std::move(service_uuid),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_service_id
,
             const std::optional<std::string>& service_id) {*out_service_id = std::move(service_id);
            loop->Quit();
          },
          &loop,
          out_service_id));
  loop.Run();
}

std::optional<std::string> FakeCentralAsyncWaiter::AddFakeService(
    const std::string& peripheral_address, const ::device::BluetoothUUID& service_uuid) {
  std::optional<std::string> async_wait_result;
  AddFakeService(std::move(peripheral_address),std::move(service_uuid),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::RemoveFakeService(
    const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveFakeService(
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::RemoveFakeService(
    const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  RemoveFakeService(std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::AddFakeCharacteristic(
    const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address, std::optional<std::string>* out_characteristic_id) {
  base::RunLoop loop;
  proxy_->AddFakeCharacteristic(
      std::move(characteristic_uuid),
      std::move(properties),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_characteristic_id
,
             const std::optional<std::string>& characteristic_id) {*out_characteristic_id = std::move(characteristic_id);
            loop->Quit();
          },
          &loop,
          out_characteristic_id));
  loop.Run();
}

std::optional<std::string> FakeCentralAsyncWaiter::AddFakeCharacteristic(
    const ::device::BluetoothUUID& characteristic_uuid, CharacteristicPropertiesPtr properties, const std::string& service_id, const std::string& peripheral_address) {
  std::optional<std::string> async_wait_result;
  AddFakeCharacteristic(std::move(characteristic_uuid),std::move(properties),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::RemoveFakeCharacteristic(
    const std::string& identifier, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveFakeCharacteristic(
      std::move(identifier),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::RemoveFakeCharacteristic(
    const std::string& identifier, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  RemoveFakeCharacteristic(std::move(identifier),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::AddFakeDescriptor(
    const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, std::optional<std::string>* out_descriptor_id) {
  base::RunLoop loop;
  proxy_->AddFakeDescriptor(
      std::move(descriptor_uuid),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_descriptor_id
,
             const std::optional<std::string>& descriptor_id) {*out_descriptor_id = std::move(descriptor_id);
            loop->Quit();
          },
          &loop,
          out_descriptor_id));
  loop.Run();
}

std::optional<std::string> FakeCentralAsyncWaiter::AddFakeDescriptor(
    const ::device::BluetoothUUID& descriptor_uuid, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  std::optional<std::string> async_wait_result;
  AddFakeDescriptor(std::move(descriptor_uuid),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::RemoveFakeDescriptor(
    const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveFakeDescriptor(
      std::move(descriptor_id),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::RemoveFakeDescriptor(
    const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  RemoveFakeDescriptor(std::move(descriptor_id),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SetNextReadCharacteristicResponse(
    uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextReadCharacteristicResponse(
      std::move(gatt_code),
      std::move(value),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextReadCharacteristicResponse(
    uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  SetNextReadCharacteristicResponse(std::move(gatt_code),std::move(value),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SetNextWriteCharacteristicResponse(
    uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextWriteCharacteristicResponse(
      std::move(gatt_code),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextWriteCharacteristicResponse(
    uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  SetNextWriteCharacteristicResponse(std::move(gatt_code),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SetNextSubscribeToNotificationsResponse(
    uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextSubscribeToNotificationsResponse(
      std::move(gatt_code),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextSubscribeToNotificationsResponse(
    uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  SetNextSubscribeToNotificationsResponse(std::move(gatt_code),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SetNextUnsubscribeFromNotificationsResponse(
    uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextUnsubscribeFromNotificationsResponse(
      std::move(gatt_code),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextUnsubscribeFromNotificationsResponse(
    uint16_t gatt_code, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  SetNextUnsubscribeFromNotificationsResponse(std::move(gatt_code),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::IsNotifying(
    const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success, bool* out_is_notifying) {
  base::RunLoop loop;
  proxy_->IsNotifying(
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool* out_is_notifying
,
             bool success,
             bool is_notifying) {*out_success = std::move(success);*out_is_notifying = std::move(is_notifying);
            loop->Quit();
          },
          &loop,
          out_success,
          out_is_notifying));
  loop.Run();
}



void FakeCentralAsyncWaiter::GetLastWrittenCharacteristicValue(
    const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success, std::optional<std::vector<uint8_t>>* out_value, WriteType* out_write_type) {
  base::RunLoop loop;
  proxy_->GetLastWrittenCharacteristicValue(
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::optional<std::vector<uint8_t>>* out_value
,
             WriteType* out_write_type
,
             bool success,
             const std::optional<std::vector<uint8_t>>& value,
             WriteType write_type) {*out_success = std::move(success);*out_value = std::move(value);*out_write_type = std::move(write_type);
            loop->Quit();
          },
          &loop,
          out_success,
          out_value,
          out_write_type));
  loop.Run();
}



void FakeCentralAsyncWaiter::SetNextReadDescriptorResponse(
    uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextReadDescriptorResponse(
      std::move(gatt_code),
      std::move(value),
      std::move(descriptor_id),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextReadDescriptorResponse(
    uint16_t gatt_code, const std::optional<std::vector<uint8_t>>& value, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  SetNextReadDescriptorResponse(std::move(gatt_code),std::move(value),std::move(descriptor_id),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::SetNextWriteDescriptorResponse(
    uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetNextWriteDescriptorResponse(
      std::move(gatt_code),
      std::move(descriptor_id),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FakeCentralAsyncWaiter::SetNextWriteDescriptorResponse(
    uint16_t gatt_code, const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address) {
  bool async_wait_result;
  SetNextWriteDescriptorResponse(std::move(gatt_code),std::move(descriptor_id),std::move(characteristic_id),std::move(service_id),std::move(peripheral_address),&async_wait_result);
  return async_wait_result;
}

void FakeCentralAsyncWaiter::GetLastWrittenDescriptorValue(
    const std::string& descriptor_id, const std::string& characteristic_id, const std::string& service_id, const std::string& peripheral_address, bool* out_success, std::optional<std::vector<uint8_t>>* out_value) {
  base::RunLoop loop;
  proxy_->GetLastWrittenDescriptorValue(
      std::move(descriptor_id),
      std::move(characteristic_id),
      std::move(service_id),
      std::move(peripheral_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::optional<std::vector<uint8_t>>* out_value
,
             bool success,
             const std::optional<std::vector<uint8_t>>& value) {*out_success = std::move(success);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_success,
          out_value));
  loop.Run();
}






void FakeCentralClientInterceptorForTesting::DispatchGATTOperationEvent(GATTOperationType type, const std::string& peripheral_address) {
  GetForwardingInterface()->DispatchGATTOperationEvent(
    std::move(type)
    , 
    std::move(peripheral_address)
    );
}
void FakeCentralClientInterceptorForTesting::DispatchCharacteristicOperationEvent(CharacteristicOperationType type, const std::optional<std::vector<uint8_t>>& data, std::optional<WriteType> write_type, const std::string& characteristic_id) {
  GetForwardingInterface()->DispatchCharacteristicOperationEvent(
    std::move(type)
    , 
    std::move(data)
    , 
    std::move(write_type)
    , 
    std::move(characteristic_id)
    );
}
void FakeCentralClientInterceptorForTesting::DispatchDescriptorOperationEvent(DescriptorOperationType type, const std::optional<std::vector<uint8_t>>& data, const std::string& descriptor_id) {
  GetForwardingInterface()->DispatchDescriptorOperationEvent(
    std::move(type)
    , 
    std::move(data)
    , 
    std::move(descriptor_id)
    );
}
FakeCentralClientAsyncWaiter::FakeCentralClientAsyncWaiter(
    FakeCentralClient* proxy) : proxy_(proxy) {}

FakeCentralClientAsyncWaiter::~FakeCentralClientAsyncWaiter() = default;







}  // bluetooth::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif