// device/bluetooth/public/mojom/device.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_TEST_UTILS_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_TEST_UTILS_H_

#include "device/bluetooth/public/mojom/device.mojom.h"


namespace bluetooth::mojom {


class  DeviceInterceptorForTesting : public Device {
  virtual Device* GetForwardingInterface() = 0;
  void Disconnect() override;
  void GetInfo(GetInfoCallback callback) override;
  void GetServices(GetServicesCallback callback) override;
  void GetCharacteristics(const std::string& service_id, GetCharacteristicsCallback callback) override;
  void ReadValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, ReadValueForCharacteristicCallback callback) override;
  void WriteValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value, WriteValueForCharacteristicCallback callback) override;
  void GetDescriptors(const std::string& service_id, const std::string& characteristic_id, GetDescriptorsCallback callback) override;
  void ReadValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, ReadValueForDescriptorCallback callback) override;
  void WriteValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value, WriteValueForDescriptorCallback callback) override;
};
class  DeviceAsyncWaiter {
 public:
  explicit DeviceAsyncWaiter(Device* proxy);

  DeviceAsyncWaiter(const DeviceAsyncWaiter&) = delete;
  DeviceAsyncWaiter& operator=(const DeviceAsyncWaiter&) = delete;

  ~DeviceAsyncWaiter();
  void GetInfo(
      DeviceInfoPtr* out_info);
  DeviceInfoPtr GetInfo();
  void GetServices(
      std::vector<ServiceInfoPtr>* out_services);
  std::vector<ServiceInfoPtr> GetServices();
  void GetCharacteristics(
      const std::string& service_id, std::optional<std::vector<CharacteristicInfoPtr>>* out_characteristics);
  std::optional<std::vector<CharacteristicInfoPtr>> GetCharacteristics(const std::string& service_id);
  void ReadValueForCharacteristic(
      const std::string& service_id, const std::string& characteristic_id, GattResult* out_result, std::optional<std::vector<uint8_t>>* out_value);
  
  void WriteValueForCharacteristic(
      const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value, GattResult* out_result);
  GattResult WriteValueForCharacteristic(const std::string& service_id, const std::string& characteristic_id, const std::vector<uint8_t>& value);
  void GetDescriptors(
      const std::string& service_id, const std::string& characteristic_id, std::optional<std::vector<DescriptorInfoPtr>>* out_descriptors);
  std::optional<std::vector<DescriptorInfoPtr>> GetDescriptors(const std::string& service_id, const std::string& characteristic_id);
  void ReadValueForDescriptor(
      const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, GattResult* out_result, std::optional<std::vector<uint8_t>>* out_value);
  
  void WriteValueForDescriptor(
      const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value, GattResult* out_result);
  GattResult WriteValueForDescriptor(const std::string& service_id, const std::string& characteristic_id, const std::string& descriptor_id, const std::vector<uint8_t>& value);

 private:
  Device* const proxy_;
};




}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_DEVICE_MOJOM_TEST_UTILS_H_