// device/bluetooth/public/mojom/adapter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/bluetooth/public/mojom/adapter.mojom-features.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/adapter.mojom-shared.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/adapter.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/device.mojom.h"
#include "device/bluetooth/public/mojom/uuid.mojom.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom.h"
#include "device/bluetooth/public/mojom/gatt_service_error_code.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace bluetooth::mojom {

class AdvertisementProxy;

template <typename ImplRefTraits>
class AdvertisementStub;

class AdvertisementRequestValidator;
class AdvertisementResponseValidator;


class Advertisement
    : public AdvertisementInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.Advertisement";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AdvertisementInterfaceBase;
  using Proxy_ = AdvertisementProxy;

  template <typename ImplRefTraits>
  using Stub_ = AdvertisementStub<ImplRefTraits>;

  using RequestValidator_ = AdvertisementRequestValidator;
  using ResponseValidator_ = AdvertisementResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUnregisterMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Unregister_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Advertisement() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Unregister();
  using UnregisterCallback = base::OnceCallback<void()>;
  using UnregisterMojoCallback = base::OnceCallback<void()>;

  virtual void Unregister(UnregisterCallback callback) = 0;
};

class DiscoverySessionProxy;

template <typename ImplRefTraits>
class DiscoverySessionStub;

class DiscoverySessionRequestValidator;
class DiscoverySessionResponseValidator;


class DiscoverySession
    : public DiscoverySessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.DiscoverySession";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DiscoverySessionInterfaceBase;
  using Proxy_ = DiscoverySessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = DiscoverySessionStub<ImplRefTraits>;

  using RequestValidator_ = DiscoverySessionRequestValidator;
  using ResponseValidator_ = DiscoverySessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kIsActiveMinVersion = 0,
    kStopMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct IsActive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DiscoverySession() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsActive(bool* out_active);
  using IsActiveCallback = base::OnceCallback<void(bool)>;
  using IsActiveMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsActive(IsActiveCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Stop(bool* out_success);
  using StopCallback = base::OnceCallback<void(bool)>;
  using StopMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Stop(StopCallback callback) = 0;
};

class SocketProxy;

template <typename ImplRefTraits>
class SocketStub;

class SocketRequestValidator;
class SocketResponseValidator;


class Socket
    : public SocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.Socket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SocketInterfaceBase;
  using Proxy_ = SocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = SocketStub<ImplRefTraits>;

  using RequestValidator_ = SocketRequestValidator;
  using ResponseValidator_ = SocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisconnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Disconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Socket() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Disconnect();
  using DisconnectCallback = base::OnceCallback<void()>;
  using DisconnectMojoCallback = base::OnceCallback<void()>;

  virtual void Disconnect(DisconnectCallback callback) = 0;
};

class ServerSocketProxy;

template <typename ImplRefTraits>
class ServerSocketStub;

class ServerSocketRequestValidator;
class ServerSocketResponseValidator;


class ServerSocket
    : public ServerSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.ServerSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServerSocketInterfaceBase;
  using Proxy_ = ServerSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServerSocketStub<ImplRefTraits>;

  using RequestValidator_ = ServerSocketRequestValidator;
  using ResponseValidator_ = ServerSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAcceptMinVersion = 0,
    kDisconnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Accept_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Disconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServerSocket() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Accept(AcceptConnectionResultPtr* out_result);
  using AcceptCallback = base::OnceCallback<void(AcceptConnectionResultPtr)>;
  using AcceptMojoCallback = base::OnceCallback<void(AcceptConnectionResultPtr)>;

  virtual void Accept(AcceptCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Disconnect();
  using DisconnectCallback = base::OnceCallback<void()>;
  using DisconnectMojoCallback = base::OnceCallback<void()>;

  virtual void Disconnect(DisconnectCallback callback) = 0;
};

class GattServiceProxy;

template <typename ImplRefTraits>
class GattServiceStub;

class GattServiceRequestValidator;
class GattServiceResponseValidator;


class GattService
    : public GattServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.GattService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GattServiceInterfaceBase;
  using Proxy_ = GattServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GattServiceStub<ImplRefTraits>;

  using RequestValidator_ = GattServiceRequestValidator;
  using ResponseValidator_ = GattServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateCharacteristicMinVersion = 0,
    kRegisterMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCharacteristic_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Register_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GattService() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, bool* out_success);
  using CreateCharacteristicCallback = base::OnceCallback<void(bool)>;
  using CreateCharacteristicMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, CreateCharacteristicCallback callback) = 0;

  using RegisterCallback = base::OnceCallback<void(std::optional<::device::BluetoothGattService::GattErrorCode>)>;
  using RegisterMojoCallback = base::OnceCallback<void(std::optional<::device::BluetoothGattService::GattErrorCode>)>;

  virtual void Register(RegisterCallback callback) = 0;
};

class GattServiceObserverProxy;

template <typename ImplRefTraits>
class GattServiceObserverStub;

class GattServiceObserverRequestValidator;
class GattServiceObserverResponseValidator;


class GattServiceObserver
    : public GattServiceObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.GattServiceObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GattServiceObserverInterfaceBase;
  using Proxy_ = GattServiceObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = GattServiceObserverStub<ImplRefTraits>;

  using RequestValidator_ = GattServiceObserverRequestValidator;
  using ResponseValidator_ = GattServiceObserverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnLocalCharacteristicReadMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLocalCharacteristicRead_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GattServiceObserver() = default;

  using OnLocalCharacteristicReadCallback = base::OnceCallback<void(LocalCharacteristicReadResultPtr)>;
  using OnLocalCharacteristicReadMojoCallback = base::OnceCallback<void(LocalCharacteristicReadResultPtr)>;

  virtual void OnLocalCharacteristicRead(::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset, OnLocalCharacteristicReadCallback callback) = 0;
};

class AdapterProxy;

template <typename ImplRefTraits>
class AdapterStub;

class AdapterRequestValidator;
class AdapterResponseValidator;


class Adapter
    : public AdapterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.Adapter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    2, 
    3, 
    4, 
    5, 
    6, 
    7, 
    8, 
    9, 
    10, 
    11
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AdapterInterfaceBase;
  using Proxy_ = AdapterProxy;

  template <typename ImplRefTraits>
  using Stub_ = AdapterStub<ImplRefTraits>;

  using RequestValidator_ = AdapterRequestValidator;
  using ResponseValidator_ = AdapterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kConnectToDeviceMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kGetInfoMinVersion = 0,
    kAddObserverMinVersion = 0,
    kRegisterAdvertisementMinVersion = 0,
    kSetDiscoverableMinVersion = 0,
    kSetNameMinVersion = 0,
    kStartDiscoverySessionMinVersion = 0,
    kConnectToServiceInsecurelyMinVersion = 0,
    kCreateRfcommServiceInsecurelyMinVersion = 0,
    kCreateLocalGattServiceMinVersion = 0,
    kIsLeScatternetDualRoleSupportedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ConnectToDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterAdvertisement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDiscoverable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDiscoverySession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectToServiceInsecurely_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRfcommServiceInsecurely_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateLocalGattService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsLeScatternetDualRoleSupported_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Adapter() = default;

  using ConnectToDeviceCallback = base::OnceCallback<void(ConnectResult, ::mojo::PendingRemote<::bluetooth::mojom::Device>)>;
  using ConnectToDeviceMojoCallback = base::OnceCallback<void(ConnectResult, ::mojo::PendingRemote<::bluetooth::mojom::Device>)>;

  virtual void ConnectToDevice(const std::string& address, ConnectToDeviceCallback callback) = 0;

  using GetDevicesCallback = base::OnceCallback<void(std::vector<::bluetooth::mojom::DeviceInfoPtr>)>;
  using GetDevicesMojoCallback = base::OnceCallback<void(std::vector<::bluetooth::mojom::DeviceInfoPtr>)>;

  virtual void GetDevices(GetDevicesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetInfo(AdapterInfoPtr* out_info);
  using GetInfoCallback = base::OnceCallback<void(AdapterInfoPtr)>;
  using GetInfoMojoCallback = base::OnceCallback<void(AdapterInfoPtr)>;

  virtual void GetInfo(GetInfoCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AddObserver(::mojo::PendingRemote<AdapterObserver> observer);
  using AddObserverCallback = base::OnceCallback<void()>;
  using AddObserverMojoCallback = base::OnceCallback<void()>;

  virtual void AddObserver(::mojo::PendingRemote<AdapterObserver> observer, AddObserverCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, ::mojo::PendingRemote<Advertisement>* out_advertisement);
  using RegisterAdvertisementCallback = base::OnceCallback<void(::mojo::PendingRemote<Advertisement>)>;
  using RegisterAdvertisementMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<Advertisement>)>;

  virtual void RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, RegisterAdvertisementCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetDiscoverable(bool discoverable, bool* out_success);
  using SetDiscoverableCallback = base::OnceCallback<void(bool)>;
  using SetDiscoverableMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetDiscoverable(bool discoverable, SetDiscoverableCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetName(const std::string& name, bool* out_success);
  using SetNameCallback = base::OnceCallback<void(bool)>;
  using SetNameMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetName(const std::string& name, SetNameCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool StartDiscoverySession(const std::string& client_name, ::mojo::PendingRemote<DiscoverySession>* out_session);
  using StartDiscoverySessionCallback = base::OnceCallback<void(::mojo::PendingRemote<DiscoverySession>)>;
  using StartDiscoverySessionMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<DiscoverySession>)>;

  virtual void StartDiscoverySession(const std::string& client_name, StartDiscoverySessionCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceResultPtr* out_result);
  using ConnectToServiceInsecurelyCallback = base::OnceCallback<void(ConnectToServiceResultPtr)>;
  using ConnectToServiceInsecurelyMojoCallback = base::OnceCallback<void(ConnectToServiceResultPtr)>;

  virtual void ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceInsecurelyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, ::mojo::PendingRemote<ServerSocket>* out_server_socket);
  using CreateRfcommServiceInsecurelyCallback = base::OnceCallback<void(::mojo::PendingRemote<ServerSocket>)>;
  using CreateRfcommServiceInsecurelyMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<ServerSocket>)>;

  virtual void CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, CreateRfcommServiceInsecurelyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, ::mojo::PendingRemote<GattService>* out_gatt_service);
  using CreateLocalGattServiceCallback = base::OnceCallback<void(::mojo::PendingRemote<GattService>)>;
  using CreateLocalGattServiceMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<GattService>)>;

  virtual void CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, CreateLocalGattServiceCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsLeScatternetDualRoleSupported(bool* out_is_supported);
  using IsLeScatternetDualRoleSupportedCallback = base::OnceCallback<void(bool)>;
  using IsLeScatternetDualRoleSupportedMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsLeScatternetDualRoleSupported(IsLeScatternetDualRoleSupportedCallback callback) = 0;
};

class AdapterObserverProxy;

template <typename ImplRefTraits>
class AdapterObserverStub;

class AdapterObserverRequestValidator;


class AdapterObserver
    : public AdapterObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "bluetooth.mojom.AdapterObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AdapterObserverInterfaceBase;
  using Proxy_ = AdapterObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = AdapterObserverStub<ImplRefTraits>;

  using RequestValidator_ = AdapterObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPresentChangedMinVersion = 0,
    kPoweredChangedMinVersion = 0,
    kDiscoverableChangedMinVersion = 0,
    kDiscoveringChangedMinVersion = 0,
    kDeviceAddedMinVersion = 0,
    kDeviceChangedMinVersion = 0,
    kDeviceRemovedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PresentChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PoweredChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DiscoverableChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DiscoveringChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeviceAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeviceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeviceRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AdapterObserver() = default;

  virtual void PresentChanged(bool present) = 0;

  virtual void PoweredChanged(bool powered) = 0;

  virtual void DiscoverableChanged(bool discoverable) = 0;

  virtual void DiscoveringChanged(bool discovering) = 0;

  virtual void DeviceAdded(::bluetooth::mojom::DeviceInfoPtr device) = 0;

  virtual void DeviceChanged(::bluetooth::mojom::DeviceInfoPtr device) = 0;

  virtual void DeviceRemoved(::bluetooth::mojom::DeviceInfoPtr device) = 0;
};



class  AdvertisementProxy
    : public Advertisement {
 public:
  using InterfaceType = Advertisement;

  explicit AdvertisementProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Unregister() final;
  
  void Unregister(UnregisterCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DiscoverySessionProxy
    : public DiscoverySession {
 public:
  using InterfaceType = DiscoverySession;

  explicit DiscoverySessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool IsActive(bool* out_active) final;
  
  void IsActive(IsActiveCallback callback) final;
  
  bool Stop(bool* out_success) final;
  
  void Stop(StopCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SocketProxy
    : public Socket {
 public:
  using InterfaceType = Socket;

  explicit SocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Disconnect() final;
  
  void Disconnect(DisconnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServerSocketProxy
    : public ServerSocket {
 public:
  using InterfaceType = ServerSocket;

  explicit ServerSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Accept(AcceptConnectionResultPtr* out_result) final;
  
  void Accept(AcceptCallback callback) final;
  
  bool Disconnect() final;
  
  void Disconnect(DisconnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GattServiceProxy
    : public GattService {
 public:
  using InterfaceType = GattService;

  explicit GattServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, bool* out_success) final;
  
  void CreateCharacteristic(const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothGattCharacteristic::Permissions& permissions, const ::device::BluetoothGattCharacteristic::Properties& properties, CreateCharacteristicCallback callback) final;
  
  void Register(RegisterCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GattServiceObserverProxy
    : public GattServiceObserver {
 public:
  using InterfaceType = GattServiceObserver;

  explicit GattServiceObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLocalCharacteristicRead(::bluetooth::mojom::DeviceInfoPtr remote_device, const ::device::BluetoothUUID& characteristic_uuid, const ::device::BluetoothUUID& service_uuid, uint32_t offset, OnLocalCharacteristicReadCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AdapterProxy
    : public Adapter {
 public:
  using InterfaceType = Adapter;

  explicit AdapterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToDevice(const std::string& address, ConnectToDeviceCallback callback) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  bool GetInfo(AdapterInfoPtr* out_info) final;
  
  void GetInfo(GetInfoCallback callback) final;
  
  bool AddObserver(::mojo::PendingRemote<AdapterObserver> observer) final;
  
  void AddObserver(::mojo::PendingRemote<AdapterObserver> observer, AddObserverCallback callback) final;
  
  bool RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, ::mojo::PendingRemote<Advertisement>* out_advertisement) final;
  
  void RegisterAdvertisement(const ::device::BluetoothUUID& service_id, const std::vector<uint8_t>& service_data, bool use_scan_response, bool connectable, RegisterAdvertisementCallback callback) final;
  
  bool SetDiscoverable(bool discoverable, bool* out_success) final;
  
  void SetDiscoverable(bool discoverable, SetDiscoverableCallback callback) final;
  
  bool SetName(const std::string& name, bool* out_success) final;
  
  void SetName(const std::string& name, SetNameCallback callback) final;
  
  bool StartDiscoverySession(const std::string& client_name, ::mojo::PendingRemote<DiscoverySession>* out_session) final;
  
  void StartDiscoverySession(const std::string& client_name, StartDiscoverySessionCallback callback) final;
  
  bool ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceResultPtr* out_result) final;
  
  void ConnectToServiceInsecurely(const std::string& address, const ::device::BluetoothUUID& service_uuid, bool should_unbond_on_error, ConnectToServiceInsecurelyCallback callback) final;
  
  bool CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, ::mojo::PendingRemote<ServerSocket>* out_server_socket) final;
  
  void CreateRfcommServiceInsecurely(const std::string& service_name, const ::device::BluetoothUUID& service_uuid, CreateRfcommServiceInsecurelyCallback callback) final;
  
  bool CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, ::mojo::PendingRemote<GattService>* out_gatt_service) final;
  
  void CreateLocalGattService(const ::device::BluetoothUUID& service_id, ::mojo::PendingRemote<GattServiceObserver> observer, CreateLocalGattServiceCallback callback) final;
  
  bool IsLeScatternetDualRoleSupported(bool* out_is_supported) final;
  
  void IsLeScatternetDualRoleSupported(IsLeScatternetDualRoleSupportedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AdapterObserverProxy
    : public AdapterObserver {
 public:
  using InterfaceType = AdapterObserver;

  explicit AdapterObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PresentChanged(bool present) final;
  
  void PoweredChanged(bool powered) final;
  
  void DiscoverableChanged(bool discoverable) final;
  
  void DiscoveringChanged(bool discovering) final;
  
  void DeviceAdded(::bluetooth::mojom::DeviceInfoPtr device) final;
  
  void DeviceChanged(::bluetooth::mojom::DeviceInfoPtr device) final;
  
  void DeviceRemoved(::bluetooth::mojom::DeviceInfoPtr device) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AdvertisementStubDispatch {
 public:
  static bool Accept(Advertisement* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Advertisement* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Advertisement>>
class AdvertisementStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AdvertisementStub() = default;
  ~AdvertisementStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdvertisementStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdvertisementStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DiscoverySessionStubDispatch {
 public:
  static bool Accept(DiscoverySession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DiscoverySession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DiscoverySession>>
class DiscoverySessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DiscoverySessionStub() = default;
  ~DiscoverySessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DiscoverySessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DiscoverySessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SocketStubDispatch {
 public:
  static bool Accept(Socket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Socket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Socket>>
class SocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SocketStub() = default;
  ~SocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServerSocketStubDispatch {
 public:
  static bool Accept(ServerSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServerSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServerSocket>>
class ServerSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServerSocketStub() = default;
  ~ServerSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServerSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServerSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GattServiceStubDispatch {
 public:
  static bool Accept(GattService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GattService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GattService>>
class GattServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GattServiceStub() = default;
  ~GattServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GattServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GattServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GattServiceObserverStubDispatch {
 public:
  static bool Accept(GattServiceObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GattServiceObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GattServiceObserver>>
class GattServiceObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GattServiceObserverStub() = default;
  ~GattServiceObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GattServiceObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GattServiceObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AdapterStubDispatch {
 public:
  static bool Accept(Adapter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Adapter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Adapter>>
class AdapterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AdapterStub() = default;
  ~AdapterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdapterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdapterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AdapterObserverStubDispatch {
 public:
  static bool Accept(AdapterObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AdapterObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AdapterObserver>>
class AdapterObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AdapterObserverStub() = default;
  ~AdapterObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdapterObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdapterObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AdvertisementRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DiscoverySessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServerSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GattServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GattServiceObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AdapterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AdapterObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AdvertisementResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DiscoverySessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServerSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GattServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GattServiceObserverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AdapterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  LocalCharacteristicReadResult {
 public:
  using DataView = LocalCharacteristicReadResultDataView;
  using Data_ = internal::LocalCharacteristicReadResult_Data;
  using Tag = Data_::LocalCharacteristicReadResult_Tag;

  template <typename... Args>
  static LocalCharacteristicReadResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_code|.
  static LocalCharacteristicReadResultPtr NewErrorCode(
      ::device::BluetoothGattService::GattErrorCode value);
  // Construct an instance holding |data|.
  static LocalCharacteristicReadResultPtr NewData(
      std::vector<uint8_t> value);

  template <typename U>
  static LocalCharacteristicReadResultPtr From(const U& u) {
    return mojo::TypeConverter<LocalCharacteristicReadResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocalCharacteristicReadResult>::Convert(*this);
  }
  ~LocalCharacteristicReadResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  LocalCharacteristicReadResult(const LocalCharacteristicReadResult& other) = delete;
  LocalCharacteristicReadResult& operator=(const LocalCharacteristicReadResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = LocalCharacteristicReadResultPtr>
  LocalCharacteristicReadResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, LocalCharacteristicReadResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, LocalCharacteristicReadResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_code() const { return tag_ == Tag::kErrorCode; }
  ::device::BluetoothGattService::GattErrorCode get_error_code() const {
    CHECK(tag_ == Tag::kErrorCode);
    return data_.error_code;
  }
  void set_error_code(::device::BluetoothGattService::GattErrorCode error_code);

  bool is_data() const { return tag_ == Tag::kData; }
  const std::vector<uint8_t>& get_data() const {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  std::vector<uint8_t>& get_data() {
    CHECK(tag_ == Tag::kData);
    return data_.data;
  }
  void set_data(std::vector<uint8_t> data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocalCharacteristicReadResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<LocalCharacteristicReadResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
        ::device::BluetoothGattService::GattErrorCode value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
        std::vector<uint8_t> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::device::BluetoothGattService::GattErrorCode error_code;
    std::vector<uint8_t> data;
  };

  LocalCharacteristicReadResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
      ::device::BluetoothGattService::GattErrorCode value);
  LocalCharacteristicReadResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kData)>,
      std::vector<uint8_t> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  ConnectToServiceResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConnectToServiceResult, T>::value>;
  using DataView = ConnectToServiceResultDataView;
  using Data_ = internal::ConnectToServiceResult_Data;

  template <typename... Args>
  static ConnectToServiceResultPtr New(Args&&... args) {
    return ConnectToServiceResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConnectToServiceResultPtr From(const U& u) {
    return mojo::TypeConverter<ConnectToServiceResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConnectToServiceResult>::Convert(*this);
  }


  ConnectToServiceResult();

  ConnectToServiceResult(
      ::mojo::PendingRemote<Socket> socket,
      ::mojo::ScopedDataPipeConsumerHandle receive_stream,
      ::mojo::ScopedDataPipeProducerHandle send_stream);

ConnectToServiceResult(const ConnectToServiceResult&) = delete;
ConnectToServiceResult& operator=(const ConnectToServiceResult&) = delete;

  ~ConnectToServiceResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConnectToServiceResultPtr>
  ConnectToServiceResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConnectToServiceResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConnectToServiceResult_UnserializedMessageContext<
            UserType, ConnectToServiceResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConnectToServiceResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConnectToServiceResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConnectToServiceResult_UnserializedMessageContext<
            UserType, ConnectToServiceResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConnectToServiceResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<Socket> socket;
  
  ::mojo::ScopedDataPipeConsumerHandle receive_stream;
  
  ::mojo::ScopedDataPipeProducerHandle send_stream;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConnectToServiceResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AcceptConnectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AcceptConnectionResult, T>::value>;
  using DataView = AcceptConnectionResultDataView;
  using Data_ = internal::AcceptConnectionResult_Data;

  template <typename... Args>
  static AcceptConnectionResultPtr New(Args&&... args) {
    return AcceptConnectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AcceptConnectionResultPtr From(const U& u) {
    return mojo::TypeConverter<AcceptConnectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AcceptConnectionResult>::Convert(*this);
  }


  AcceptConnectionResult();

  AcceptConnectionResult(
      ::bluetooth::mojom::DeviceInfoPtr device,
      ::mojo::PendingRemote<Socket> socket,
      ::mojo::ScopedDataPipeConsumerHandle receive_stream,
      ::mojo::ScopedDataPipeProducerHandle send_stream);

AcceptConnectionResult(const AcceptConnectionResult&) = delete;
AcceptConnectionResult& operator=(const AcceptConnectionResult&) = delete;

  ~AcceptConnectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AcceptConnectionResultPtr>
  AcceptConnectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AcceptConnectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AcceptConnectionResult_UnserializedMessageContext<
            UserType, AcceptConnectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AcceptConnectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AcceptConnectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AcceptConnectionResult_UnserializedMessageContext<
            UserType, AcceptConnectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AcceptConnectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::bluetooth::mojom::DeviceInfoPtr device;
  
  ::mojo::PendingRemote<Socket> socket;
  
  ::mojo::ScopedDataPipeConsumerHandle receive_stream;
  
  ::mojo::ScopedDataPipeProducerHandle send_stream;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AcceptConnectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AdapterInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdapterInfo, T>::value>;
  using DataView = AdapterInfoDataView;
  using Data_ = internal::AdapterInfo_Data;

  template <typename... Args>
  static AdapterInfoPtr New(Args&&... args) {
    return AdapterInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdapterInfoPtr From(const U& u) {
    return mojo::TypeConverter<AdapterInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdapterInfo>::Convert(*this);
  }


  AdapterInfo();

  AdapterInfo(
      const std::string& address,
      const std::string& name,
      const std::string& system_name,
      bool floss,
      bool extended_advertisement_support,
      bool initialized,
      bool present,
      bool powered,
      bool discoverable,
      bool discovering);


  ~AdapterInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdapterInfoPtr>
  AdapterInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdapterInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdapterInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdapterInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdapterInfo_UnserializedMessageContext<
            UserType, AdapterInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdapterInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdapterInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdapterInfo_UnserializedMessageContext<
            UserType, AdapterInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdapterInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string address;
  
  std::string name;
  
  std::string system_name;
  
  bool floss;
  
  bool extended_advertisement_support;
  
  bool initialized;
  
  bool present;
  
  bool powered;
  
  bool discoverable;
  
  bool discovering;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdapterInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
LocalCharacteristicReadResultPtr LocalCharacteristicReadResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorCode:
      return NewErrorCode(
          mojo::Clone(data_.error_code));
    case Tag::kData:
      return NewData(
          mojo::Clone(data_.data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, LocalCharacteristicReadResult>::value>::type*>
bool LocalCharacteristicReadResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorCode:
      return mojo::Equals(data_.error_code, other.data_.error_code);
    case Tag::kData:
      return mojo::Equals(data_.data, other.data_.data);
  }

  return false;
}
template <typename StructPtrType>
ConnectToServiceResultPtr ConnectToServiceResult::Clone() const {
  return New(
      mojo::Clone(socket),
      mojo::Clone(receive_stream),
      mojo::Clone(send_stream)
  );
}

template <typename T, ConnectToServiceResult::EnableIfSame<T>*>
bool ConnectToServiceResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->socket, other_struct.socket))
    return false;
  if (!mojo::Equals(this->receive_stream, other_struct.receive_stream))
    return false;
  if (!mojo::Equals(this->send_stream, other_struct.send_stream))
    return false;
  return true;
}

template <typename T, ConnectToServiceResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.socket < rhs.socket)
    return true;
  if (rhs.socket < lhs.socket)
    return false;
  if (lhs.receive_stream < rhs.receive_stream)
    return true;
  if (rhs.receive_stream < lhs.receive_stream)
    return false;
  if (lhs.send_stream < rhs.send_stream)
    return true;
  if (rhs.send_stream < lhs.send_stream)
    return false;
  return false;
}
template <typename StructPtrType>
AcceptConnectionResultPtr AcceptConnectionResult::Clone() const {
  return New(
      mojo::Clone(device),
      mojo::Clone(socket),
      mojo::Clone(receive_stream),
      mojo::Clone(send_stream)
  );
}

template <typename T, AcceptConnectionResult::EnableIfSame<T>*>
bool AcceptConnectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device, other_struct.device))
    return false;
  if (!mojo::Equals(this->socket, other_struct.socket))
    return false;
  if (!mojo::Equals(this->receive_stream, other_struct.receive_stream))
    return false;
  if (!mojo::Equals(this->send_stream, other_struct.send_stream))
    return false;
  return true;
}

template <typename T, AcceptConnectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device < rhs.device)
    return true;
  if (rhs.device < lhs.device)
    return false;
  if (lhs.socket < rhs.socket)
    return true;
  if (rhs.socket < lhs.socket)
    return false;
  if (lhs.receive_stream < rhs.receive_stream)
    return true;
  if (rhs.receive_stream < lhs.receive_stream)
    return false;
  if (lhs.send_stream < rhs.send_stream)
    return true;
  if (rhs.send_stream < lhs.send_stream)
    return false;
  return false;
}
template <typename StructPtrType>
AdapterInfoPtr AdapterInfo::Clone() const {
  return New(
      mojo::Clone(address),
      mojo::Clone(name),
      mojo::Clone(system_name),
      mojo::Clone(floss),
      mojo::Clone(extended_advertisement_support),
      mojo::Clone(initialized),
      mojo::Clone(present),
      mojo::Clone(powered),
      mojo::Clone(discoverable),
      mojo::Clone(discovering)
  );
}

template <typename T, AdapterInfo::EnableIfSame<T>*>
bool AdapterInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->address, other_struct.address))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->system_name, other_struct.system_name))
    return false;
  if (!mojo::Equals(this->floss, other_struct.floss))
    return false;
  if (!mojo::Equals(this->extended_advertisement_support, other_struct.extended_advertisement_support))
    return false;
  if (!mojo::Equals(this->initialized, other_struct.initialized))
    return false;
  if (!mojo::Equals(this->present, other_struct.present))
    return false;
  if (!mojo::Equals(this->powered, other_struct.powered))
    return false;
  if (!mojo::Equals(this->discoverable, other_struct.discoverable))
    return false;
  if (!mojo::Equals(this->discovering, other_struct.discovering))
    return false;
  return true;
}

template <typename T, AdapterInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.address < rhs.address)
    return true;
  if (rhs.address < lhs.address)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.system_name < rhs.system_name)
    return true;
  if (rhs.system_name < lhs.system_name)
    return false;
  if (lhs.floss < rhs.floss)
    return true;
  if (rhs.floss < lhs.floss)
    return false;
  if (lhs.extended_advertisement_support < rhs.extended_advertisement_support)
    return true;
  if (rhs.extended_advertisement_support < lhs.extended_advertisement_support)
    return false;
  if (lhs.initialized < rhs.initialized)
    return true;
  if (rhs.initialized < lhs.initialized)
    return false;
  if (lhs.present < rhs.present)
    return true;
  if (rhs.present < lhs.present)
    return false;
  if (lhs.powered < rhs.powered)
    return true;
  if (rhs.powered < lhs.powered)
    return false;
  if (lhs.discoverable < rhs.discoverable)
    return true;
  if (rhs.discoverable < lhs.discoverable)
    return false;
  if (lhs.discovering < rhs.discovering)
    return true;
  if (rhs.discovering < lhs.discovering)
    return false;
  return false;
}


}  // bluetooth::mojom

namespace mojo {


template <>
struct  StructTraits<::bluetooth::mojom::ConnectToServiceResult::DataView,
                                         ::bluetooth::mojom::ConnectToServiceResultPtr> {
  static bool IsNull(const ::bluetooth::mojom::ConnectToServiceResultPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::ConnectToServiceResultPtr* output) { output->reset(); }

  static  decltype(::bluetooth::mojom::ConnectToServiceResult::socket)& socket(
       ::bluetooth::mojom::ConnectToServiceResultPtr& input) {
    return input->socket;
  }

  static  decltype(::bluetooth::mojom::ConnectToServiceResult::receive_stream)& receive_stream(
       ::bluetooth::mojom::ConnectToServiceResultPtr& input) {
    return input->receive_stream;
  }

  static  decltype(::bluetooth::mojom::ConnectToServiceResult::send_stream)& send_stream(
       ::bluetooth::mojom::ConnectToServiceResultPtr& input) {
    return input->send_stream;
  }

  static bool Read(::bluetooth::mojom::ConnectToServiceResult::DataView input, ::bluetooth::mojom::ConnectToServiceResultPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::AcceptConnectionResult::DataView,
                                         ::bluetooth::mojom::AcceptConnectionResultPtr> {
  static bool IsNull(const ::bluetooth::mojom::AcceptConnectionResultPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::AcceptConnectionResultPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::AcceptConnectionResult::device)& device(
      const ::bluetooth::mojom::AcceptConnectionResultPtr& input) {
    return input->device;
  }

  static  decltype(::bluetooth::mojom::AcceptConnectionResult::socket)& socket(
       ::bluetooth::mojom::AcceptConnectionResultPtr& input) {
    return input->socket;
  }

  static  decltype(::bluetooth::mojom::AcceptConnectionResult::receive_stream)& receive_stream(
       ::bluetooth::mojom::AcceptConnectionResultPtr& input) {
    return input->receive_stream;
  }

  static  decltype(::bluetooth::mojom::AcceptConnectionResult::send_stream)& send_stream(
       ::bluetooth::mojom::AcceptConnectionResultPtr& input) {
    return input->send_stream;
  }

  static bool Read(::bluetooth::mojom::AcceptConnectionResult::DataView input, ::bluetooth::mojom::AcceptConnectionResultPtr* output);
};


template <>
struct  StructTraits<::bluetooth::mojom::AdapterInfo::DataView,
                                         ::bluetooth::mojom::AdapterInfoPtr> {
  static bool IsNull(const ::bluetooth::mojom::AdapterInfoPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::AdapterInfoPtr* output) { output->reset(); }

  static const decltype(::bluetooth::mojom::AdapterInfo::address)& address(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->address;
  }

  static const decltype(::bluetooth::mojom::AdapterInfo::name)& name(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->name;
  }

  static const decltype(::bluetooth::mojom::AdapterInfo::system_name)& system_name(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->system_name;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::floss) floss(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->floss;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::extended_advertisement_support) extended_advertisement_support(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->extended_advertisement_support;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::initialized) initialized(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->initialized;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::present) present(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->present;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::powered) powered(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->powered;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::discoverable) discoverable(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->discoverable;
  }

  static decltype(::bluetooth::mojom::AdapterInfo::discovering) discovering(
      const ::bluetooth::mojom::AdapterInfoPtr& input) {
    return input->discovering;
  }

  static bool Read(::bluetooth::mojom::AdapterInfo::DataView input, ::bluetooth::mojom::AdapterInfoPtr* output);
};


template <>
struct  UnionTraits<::bluetooth::mojom::LocalCharacteristicReadResult::DataView,
                                        ::bluetooth::mojom::LocalCharacteristicReadResultPtr> {
  static bool IsNull(const ::bluetooth::mojom::LocalCharacteristicReadResultPtr& input) { return !input; }
  static void SetToNull(::bluetooth::mojom::LocalCharacteristicReadResultPtr* output) { output->reset(); }

  static ::bluetooth::mojom::LocalCharacteristicReadResult::Tag GetTag(const ::bluetooth::mojom::LocalCharacteristicReadResultPtr& input) {
    return input->which();
  }

  static  ::device::BluetoothGattService::GattErrorCode error_code(const ::bluetooth::mojom::LocalCharacteristicReadResultPtr& input) {
    return input->get_error_code();
  }

  static const std::vector<uint8_t>& data(const ::bluetooth::mojom::LocalCharacteristicReadResultPtr& input) {
    return input->get_data();
  }

  static bool Read(::bluetooth::mojom::LocalCharacteristicReadResult::DataView input, ::bluetooth::mojom::LocalCharacteristicReadResultPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_H_