// device/bluetooth/public/mojom/adapter.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_DATA_VIEW_H_
#define DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "device/bluetooth/public/mojom/adapter.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/device.mojom-shared.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_permissions.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_characteristic_properties.mojom-shared.h"
#include "device/bluetooth/public/mojom/gatt_service_error_code.mojom-shared.h"


namespace bluetooth::mojom {
class ConnectToServiceResultDataView;

class AcceptConnectionResultDataView;

class AdapterInfoDataView;

class LocalCharacteristicReadResultDataView;


}  // bluetooth::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::bluetooth::mojom::ConnectToServiceResultDataView> {
  using Data = ::bluetooth::mojom::internal::ConnectToServiceResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::AcceptConnectionResultDataView> {
  using Data = ::bluetooth::mojom::internal::AcceptConnectionResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::AdapterInfoDataView> {
  using Data = ::bluetooth::mojom::internal::AdapterInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::bluetooth::mojom::LocalCharacteristicReadResultDataView> {
  using Data = ::bluetooth::mojom::internal::LocalCharacteristicReadResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace bluetooth::mojom {


enum class ConnectResult : int32_t {
  
  SUCCESS = 0,
  
  AUTH_CANCELED = 1,
  
  AUTH_FAILED = 2,
  
  AUTH_REJECTED = 3,
  
  AUTH_TIMEOUT = 4,
  
  FAILED = 5,
  
  INPROGRESS = 6,
  
  UNKNOWN = 7,
  
  UNSUPPORTED_DEVICE = 8,
  
  DEVICE_NO_LONGER_IN_RANGE = 9,
  
  NOT_READY = 10,
  
  ALREADY_CONNECTED = 11,
  
  ALREADY_EXISTS = 12,
  
  NOT_CONNECTED = 13,
  
  DOES_NOT_EXIST = 14,
  
  INVALID_ARGS = 15,
  
  NON_AUTH_TIMEOUT = 16,
  
  NO_MEMORY = 17,
  
  JNI_ENVIRONMENT = 18,
  
  JNI_THREAD_ATTACH = 19,
  
  WAKELOCK = 20,
  
  UNEXPECTED_STATE = 21,
  
  SOCKET = 22,
  kMinValue = 0,
  kMaxValue = 22,
};

 std::ostream& operator<<(std::ostream& os, ConnectResult value);
inline bool IsKnownEnumValue(ConnectResult value) {
  return internal::ConnectResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AdvertisementInterfaceBase {};

using AdvertisementPtrDataView =
    mojo::InterfacePtrDataView<AdvertisementInterfaceBase>;
using AdvertisementRequestDataView =
    mojo::InterfaceRequestDataView<AdvertisementInterfaceBase>;
using AdvertisementAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AdvertisementInterfaceBase>;
using AdvertisementAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AdvertisementInterfaceBase>;
class DiscoverySessionInterfaceBase {};

using DiscoverySessionPtrDataView =
    mojo::InterfacePtrDataView<DiscoverySessionInterfaceBase>;
using DiscoverySessionRequestDataView =
    mojo::InterfaceRequestDataView<DiscoverySessionInterfaceBase>;
using DiscoverySessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DiscoverySessionInterfaceBase>;
using DiscoverySessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DiscoverySessionInterfaceBase>;
class SocketInterfaceBase {};

using SocketPtrDataView =
    mojo::InterfacePtrDataView<SocketInterfaceBase>;
using SocketRequestDataView =
    mojo::InterfaceRequestDataView<SocketInterfaceBase>;
using SocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SocketInterfaceBase>;
using SocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SocketInterfaceBase>;
class ServerSocketInterfaceBase {};

using ServerSocketPtrDataView =
    mojo::InterfacePtrDataView<ServerSocketInterfaceBase>;
using ServerSocketRequestDataView =
    mojo::InterfaceRequestDataView<ServerSocketInterfaceBase>;
using ServerSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServerSocketInterfaceBase>;
using ServerSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServerSocketInterfaceBase>;
class GattServiceInterfaceBase {};

using GattServicePtrDataView =
    mojo::InterfacePtrDataView<GattServiceInterfaceBase>;
using GattServiceRequestDataView =
    mojo::InterfaceRequestDataView<GattServiceInterfaceBase>;
using GattServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GattServiceInterfaceBase>;
using GattServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GattServiceInterfaceBase>;
class GattServiceObserverInterfaceBase {};

using GattServiceObserverPtrDataView =
    mojo::InterfacePtrDataView<GattServiceObserverInterfaceBase>;
using GattServiceObserverRequestDataView =
    mojo::InterfaceRequestDataView<GattServiceObserverInterfaceBase>;
using GattServiceObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GattServiceObserverInterfaceBase>;
using GattServiceObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GattServiceObserverInterfaceBase>;
class AdapterInterfaceBase {};

using AdapterPtrDataView =
    mojo::InterfacePtrDataView<AdapterInterfaceBase>;
using AdapterRequestDataView =
    mojo::InterfaceRequestDataView<AdapterInterfaceBase>;
using AdapterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AdapterInterfaceBase>;
using AdapterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AdapterInterfaceBase>;
class AdapterObserverInterfaceBase {};

using AdapterObserverPtrDataView =
    mojo::InterfacePtrDataView<AdapterObserverInterfaceBase>;
using AdapterObserverRequestDataView =
    mojo::InterfaceRequestDataView<AdapterObserverInterfaceBase>;
using AdapterObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AdapterObserverInterfaceBase>;
using AdapterObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AdapterObserverInterfaceBase>;


class ConnectToServiceResultDataView {
 public:
  ConnectToServiceResultDataView() = default;

  ConnectToServiceResultDataView(
      internal::ConnectToServiceResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::SocketInterfaceBase>>(
            &data_->socket, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeReceiveStream() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->receive_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeSendStream() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->send_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ConnectToServiceResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AcceptConnectionResultDataView {
 public:
  AcceptConnectionResultDataView() = default;

  AcceptConnectionResultDataView(
      internal::AcceptConnectionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceDataView(
      ::bluetooth::mojom::DeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevice(UserType* output) {
    
    auto* pointer = data_->device.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::DeviceInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::bluetooth::mojom::SocketInterfaceBase>>(
            &data_->socket, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeConsumerHandle TakeReceiveStream() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->receive_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeSendStream() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->send_stream, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AcceptConnectionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdapterInfoDataView {
 public:
  AdapterInfoDataView() = default;

  AdapterInfoDataView(
      internal::AdapterInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAddressDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddress(UserType* output) {
    
    auto* pointer = data_->address.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSystemNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSystemName(UserType* output) {
    
    auto* pointer = data_->system_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool floss() const {
    return data_->floss;
  }
  bool extended_advertisement_support() const {
    return data_->extended_advertisement_support;
  }
  bool initialized() const {
    return data_->initialized;
  }
  bool present() const {
    return data_->present;
  }
  bool powered() const {
    return data_->powered;
  }
  bool discoverable() const {
    return data_->discoverable;
  }
  bool discovering() const {
    return data_->discovering;
  }
 private:
  internal::AdapterInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LocalCharacteristicReadResultDataView {
 public:
  using Tag = internal::LocalCharacteristicReadResult_Data::LocalCharacteristicReadResult_Tag;

  LocalCharacteristicReadResultDataView() = default;

  LocalCharacteristicReadResultDataView(
      internal::LocalCharacteristicReadResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_code() const { return data_->tag == Tag::kErrorCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    CHECK(is_error_code());
    return mojo::internal::Deserialize<::bluetooth::mojom::GattServiceErrorCode>(
        data_->data.f_error_code, output);
  }
  ::bluetooth::mojom::GattServiceErrorCode error_code() const {
    CHECK(is_error_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::bluetooth::mojom::GattServiceErrorCode>(data_->data.f_error_code));
  }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_data.Get(), output, message_);
  }

 private:
  internal::LocalCharacteristicReadResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // bluetooth::mojom

#endif  // DEVICE_BLUETOOTH_PUBLIC_MOJOM_ADAPTER_MOJOM_DATA_VIEW_H_